/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.internal.cocoa;

import org.eclipse.swt.internal.*;

public class OS extends C {
	static {
		Library.loadLibrary("swt-pi"); //$NON-NLS-1$
	}
	
	public static final int VERSION;
	static {
		int [] response = new int [1];
		OS.Gestalt (OS.gestaltSystemVersion, response);
		VERSION = response [0] & 0xffff;		
	}

	//TODO - don't hard code
	public static final int PTR_SIZEOF = 4;
	
	public static final int gestaltSystemVersion = ('s'<<24) + ('y'<<16) + ('s'<<8) + 'v';
	public static final int noErr = 0;
	public static final int kProcessTransformToForegroundApplication = 1;
	public static final int kAlertCautionIcon = ('c'<<24) + ('a'<<16) + ('u'<<8) + 't';
	public static final int kAlertNoteIcon = ('n'<<24) + ('o'<<16) + ('t'<<8) + 'e';
	public static final int kAlertStopIcon = ('s'<<24) + ('t'<<16) + ('o'<<8) + 'p';

	public static final int sel_sendSelection = sel_registerName("sendSelection");
	public static final int sel_sendDoubleSelection = sel_registerName("sendDoubleSelection");
	public static final int sel_sendArrowSelection = sel_registerName("sendArrowSelection");
	public static final int sel_sendVerticalSelection = sel_registerName("sendVerticalSelection");
	public static final int sel_sendHorizontalSelection = sel_registerName("sendHorizontalSelection");
	public static final int sel_drawAtPoint_ = sel_registerName("drawAtPoint:");
	public static final int sel_timerProc_1 = sel_registerName("timerProc:");
	
	public static final native int NSDeviceRGBColorSpace();

/** JNI natives */
public static final native int NewGlobalRef(Object object);
public static final native void DeleteGlobalRef(int globalRef);
public static final native Object JNIGetObject(int globalRef);

public static final native int Gestalt(int selector, int[] response);
public static final native int GetCurrentProcess(int[] psn);
public static final native int SetFrontProcess(int[] psn);
public static final native int TransformProcessType(int[] psn, int transformState);
public static final native void NSIntersectionRect (NSRect result, NSRect aRect, NSRect bRect);
public static final native int CGWarpMouseCursorPosition (CGPoint newCursorPosition);

/** QuickDraw calls */
public static final native int NewRgn();
public static final native void RectRgn(int rgnHandle, short[] rect);
public static final native void OpenRgn();
public static final native void OffsetRgn(int rgnHandle, short dh, short dv);
public static final native void MoveTo(short h, short v);
public static final native void LineTo(short h, short v);
public static final native void UnionRgn(int srcRgnA, int srcRgnB, int dstRgn);
public static final native void CloseRgn(int dstRgn);
public static final native void DisposeRgn(int rgnHandle);
public static final native boolean PtInRgn(short[] pt, int rgnHandle);
public static final native void GetRegionBounds(int rgnHandle, short[] bounds);
public static final native void SectRgn(int srcRgnA, int srcRgnB, int dstRgn);
public static final native boolean EmptyRgn(int rgnHandle);
public static final native void DiffRgn(int srcRgnA, int srcRgnB, int dstRgn);
public static final native boolean RectInRgn(short[] rect, int rgnHandle);
public static final native int QDRegionToRects(int rgn, int dir, int proc, int userData);
public static final native void CopyRgn(int srcRgnHandle, int dstRgnHandle);
public static final native void SetRect(short[] r, short left, short top, short right, short bottom);
public static final int kQDParseRegionFromTop = (1 << 0);
public static final int kQDParseRegionFromBottom = (1 << 1);
public static final int kQDParseRegionFromLeft = (1 << 2);
public static final int kQDParseRegionFromRight = (1 << 3);
public static final int kQDParseRegionFromTopLeft = kQDParseRegionFromTop | kQDParseRegionFromLeft;
public static final int kQDRegionToRectsMsgParse = 2;
	
	
public static final native boolean class_addIvar(int cls, String name, int size, byte alignment, String types);
public static final native boolean class_addMethod(int cls, int name, int imp, String types);
public static final native int objc_allocateClassPair(int superclass, String name, int extraBytes);
public static final native int objc_getClass(String className);
public static final native int objc_lookUpClass(String className);
public static final native void objc_registerClassPair(int cls);
public static final native int object_getClassName(int obj);
public static final native int object_getInstanceVariable(int obj, String name, int[] outValue);
public static final native int object_setInstanceVariable(int obj, String name, int value);
public static final native int sel_registerName(String selectorName);


public static final native int objc_msgSend(int id, int sel, char[] arg0);
public static final native int objc_msgSend(int id, int sel, char[] arg0, int arg1);
public static final native int objc_msgSend(int id, int sel, float[] arg0, int arg1, float arg2);
public static final native int objc_msgSend(int id, int sel, float[] arg0);
public static final native int objc_msgSend(int id, int sel, char[] arg0, NSRange arg1);
public static final native int objc_msgSend(int id, int sel, String arg0);
public static final native int objc_msgSend(int id, int sel, NSPoint arg0, int arg1, float[] arg2);
public static final native int objc_msgSend(int id, int sel, int [] arg0);
public static final native int objc_msgSend(int id, int sel, int [] arg0, int arg1, int arg2);
public static final native int objc_msgSend(int id, int sel, NSPoint arg0, int arg1, int arg2);
public static final native int objc_msgSend(int id, int sel, NSRect arg0, NSRange arg1, NSRect arg2);
public static final native int objc_msgSend(int id, int sel, double arg0, int arg1);
public static final native int objc_msgSend(int id, int sel, int arg0, int arg1, int arg2, int arg3, int arg4, NSRange arg5, int arg6);
public static final native void objc_msgSend_stret(NSPoint result, int id, int sel, int arg0, NSRect arg1, int arg2);
public static final native void objc_msgSend_stret(NSRange result, int id, int sel);
public static final native int objc_msgSend(int id, int sel, int arg0, NSRect arg1, boolean arg2, int arg3);
public static final native void objc_msgSend_stret(NSRect result, int id, int sel, NSRange arg0, int arg1);
public static final native int objc_msgSend(int id, int sel, NSSize arg0);
public static final native void objc_msgSend_stret(NSRange result, int id, int sel, int arg0, int arg1, int arg2, int arg3);
public static final native int objc_msgSend(int id, int sel, int arg0, int arg1, double arg2, int arg3);
public static final native void objc_msgSend_stret(NSRange result, int id, int sel, NSRect arg0);
public static final native void objc_msgSend_stret(NSRect result, int id, int sel, int arg0, NSRect arg1, NSRect arg2, int arg3, NSRange arg4);
public static final native void objc_msgSend_stret(NSDecimal result, int id, int sel);
public static final native int objc_msgSend(int id, int sel, NSSize arg0, int arg1, boolean arg2, boolean arg3);
public static final native int objc_msgSend(int id, int sel, int arg0, int arg1, int arg2, int arg3);
public static final native void objc_msgSend_stret(NSSize result, int id, int sel, NSRect arg0);
public static final native int objc_msgSend(int id, int sel, NSPoint arg0, NSRange arg1);
public static final native int objc_msgSend(int id, int sel, int arg0);
public static final native int objc_msgSend(int id, int sel, NSRect arg0, NSRect arg1, int arg2, float arg3);
public static final native int objc_msgSend(int id, int sel, NSRange arg0, NSRange arg1);
public static final native int objc_msgSend(int id, int sel, NSPoint arg0, NSRect arg1, float arg2);
public static final native int objc_msgSend(int id, int sel, NSRange arg0);
public static final native int objc_msgSend(int id, int sel, float arg0, int arg1);
public static final native int objc_msgSend(int id, int sel, int arg0, int arg1, long arg2);
public static final native int objc_msgSend(int id, int sel, int arg0, int arg1, NSPoint arg2);
public static final native int objc_msgSend(int id, int sel, int arg0, float arg1, int arg2, NSPoint arg3);
public static final native int objc_msgSend(int id, int sel, int arg0, NSPoint arg1);
public static final native int objc_msgSend(int id, int sel, NSRange arg0, int arg1, NSRect arg2, NSRange arg3, NSPoint arg4);
public static final native double objc_msgSend_fpret(int id, int sel, int arg0, float arg1);
public static final native int objc_msgSend(int id, int sel, int arg0, int arg1, NSPoint arg2, int arg3);
public static final native int objc_msgSend(int id, int sel, int arg0, NSPoint arg1, int arg2, double arg3, int arg4, int arg5, int arg6, int arg7, float arg8);
public static final native int objc_msgSend(int id, int sel, NSPoint arg0, float arg1, float arg2, float arg3);
public static final native double objc_msgSend_fpret(int id, int sel);
public static final native int objc_msgSend(int id, int sel, NSPoint arg0, int arg1);
public static final native void objc_msgSend_stret(NSAffineTransformStruct result, int id, int sel);
public static final native void objc_msgSend_stret(NSRange result, int id, int sel, int arg0, NSRange arg1, NSRange arg2);
public static final native void objc_msgSend_stret(NSSize result, int id, int sel, int arg0, NSRange arg1, int arg2, int arg3);
public static final native int objc_msgSend(int id, int sel, NSRect arg0, int arg1, int arg2, int arg3, int arg4);
public static final native void objc_msgSend_stret(NSRange result, int id, int sel, int arg0, int arg1, int arg2);
public static final native int objc_msgSend(int id, int sel, float arg0, int arg1, float arg2);
public static final native int objc_msgSend(int id, int sel, NSRect arg0, int arg1, int arg2, int arg3);
public static final native int objc_msgSend(int id, int sel, boolean arg0);
public static final native int objc_msgSend(int id, int sel, NSDecimal arg0);
public static final native int objc_msgSend(int id, int sel, NSRect arg0, NSRect arg1, int arg2);
public static final native int objc_msgSend(int id, int sel, NSRange arg0, int arg1, int arg2);
public static final native void objc_msgSend_stret(NSSize result, int id, int sel);
public static final native int objc_msgSend(int id, int sel, long arg0, short arg1, boolean arg2);
public static final native int objc_msgSend(int id, int sel, int arg0, int arg1, int arg2, int arg3, int arg4);
public static final native void objc_msgSend_stret(NSRect result, int id, int sel, int arg0, NSRect arg1, NSPoint arg2, int arg3);
public static final native void objc_msgSend_stret(NSRange result, int id, int sel, int arg0);
public static final native void objc_msgSend_stret(NSRect result, int id, int sel, int arg0, NSRect arg1);
public static final native void objc_msgSend_stret(NSRange result, int id, int sel, NSRange arg0, int arg1, int arg2);
public static final native int objc_msgSend(int id, int sel, NSPoint arg0, NSRect arg1);
public static final native void objc_msgSend_stret(NSRect result, int id, int sel, int arg0, NSRect arg1, int arg2);
public static final native int objc_msgSend(int id, int sel, NSRect arg0, NSSize arg1);
public static final native int objc_msgSend(int id, int sel, int arg0, float arg1);
public static final native int objc_msgSend(int id, int sel, int arg0, int arg1, int arg2, int arg3, int arg4, int arg5);
public static final native int objc_msgSend(int id, int sel, int arg0, int arg1, short arg2);
public static final native int objc_msgSend(int id, int sel, NSRect arg0, int arg1, int arg2, boolean arg3);
public static final native int objc_msgSend(int id, int sel, int arg0, int arg1, NSRect arg2, int arg3);
public static final native double objc_msgSend_fpret(int id, int sel, NSPoint arg0, int arg1);
public static final native int objc_msgSend(int id, int sel, int arg0, int arg1, int arg2, short arg3, int arg4);
public static final native int objc_msgSend(int id, int sel, NSPoint arg0, float arg1, float arg2, float arg3, boolean arg4);
public static final native int objc_msgSend(int id, int sel, int arg0, int arg1, int arg2, int arg3, int arg4, NSPoint arg5);
public static final native int objc_msgSend(int id, int sel, boolean arg0, NSRect arg1, int arg2);
public static final native void objc_msgSend_stret(NSRange result, int id, int sel, NSRange arg0);
public static final native void objc_msgSend_stret(NSPoint result, int id, int sel, int arg0, int arg1, int arg2, int arg3, int arg4);
public static final native int objc_msgSend(int id, int sel, double arg0, double arg1);
public static final native int objc_msgSend(int id, int sel, int arg0, double arg1, int arg2, int arg3, int arg4, boolean arg5);
public static final native int objc_msgSend(int id, int sel, int arg0, NSRect arg1);
public static final native void objc_msgSend_stret(NSRect result, int id, int sel, int arg0, int arg1, NSRect arg2);
public static final native int objc_msgSend(int id, int sel, int arg0, boolean arg1, int arg2, int arg3, int arg4);
public static final native int objc_msgSend(int id, int sel, float arg0, float arg1);
public static final native int objc_msgSend(int id, int sel, int arg0, float arg1, int arg2);
public static final native int objc_msgSend(int id, int sel, NSRange arg0, int arg1, NSRange arg2);
public static final native int objc_msgSend(int id, int sel, int arg0, float arg1, float arg2, float arg3);
public static final native double objc_msgSend_fpret(int id, int sel, double arg0);
public static final native int objc_msgSend(int id, int sel, int arg0, NSRange arg1);
public static final native void objc_msgSend_stret(NSSize result, int id, int sel, boolean arg0);
public static final native int objc_msgSend(int id, int sel, int arg0, int arg1, NSRange arg2, NSPoint arg3);
public static final native int objc_msgSend(int id, int sel, NSPoint arg0, int arg1, NSRange arg2);
public static final native int objc_msgSend(int id, int sel, NSRange arg0, int arg1, int arg2, int arg3, int arg4, int arg5);
public static final native int objc_msgSend(int id, int sel, NSPoint arg0, NSPoint arg1, int arg2, boolean arg3);
public static final native int objc_msgSend(int id, int sel, NSRange arg0, NSRange arg1, int arg2, int arg3);
public static final native int objc_msgSend(int id, int sel, float arg0);
public static final native int objc_msgSend(int id, int sel, NSPoint arg0, float arg1);
public static final native void objc_msgSend_stret(NSRect result, int id, int sel, NSRect arg0, int arg1);
public static final native int objc_msgSend(int id, int sel, NSPoint arg0);
public static final native void objc_msgSend_stret(NSPoint result, int id, int sel);
public static final native void objc_msgSend_stret(NSPoint result, int id, int sel, NSRect arg0);
public static final native double objc_msgSend_fpret(int id, int sel, float arg0);
public static final native double objc_msgSend_fpret(int id, int sel, int arg0);
public static final native int objc_msgSend(int id, int sel, int arg0, int arg1, NSRange arg2, int arg3, NSRange arg4);
public static final native int objc_msgSend(int id, int sel, double arg0);
public static final native int objc_msgSend(int id, int sel, NSRange arg0, int arg1, int arg2, int arg3, int arg4);
public static final native void objc_msgSend_stret(NSRect result, int id, int sel, NSRect arg0, int arg1, int arg2, int arg3);
public static final native void objc_msgSend_stret(NSRect result, int id, int sel, int arg0, int arg1, boolean arg2);
public static final native int objc_msgSend(int id, int sel, NSRect arg0, float arg1, float arg2);
public static final native void objc_msgSend_stret(NSRect result, int id, int sel, boolean arg0);
public static final native int objc_msgSend(int id, int sel, boolean arg0, NSRange arg1);
public static final native int objc_msgSend(int id, int sel, int arg0, int arg1, int arg2, int arg3, int arg4, boolean arg5, boolean arg6, int arg7, int arg8, int arg9, int arg10);
public static final native void objc_msgSend_stret(NSPoint result, int id, int sel, int arg0);
public static final native void objc_msgSend_stret(NSRect result, int id, int sel, int arg0);
public static final native int objc_msgSend(int id, int sel, NSRange arg0, NSPoint arg1);
public static final native int objc_msgSend(int id, int sel, NSRange arg0, boolean arg1, int arg2);
public static final native int objc_msgSend(int id, int sel, int arg0, NSPoint arg1, int arg2, int arg3);
public static final native int objc_msgSend(int id, int sel, NSRect arg0, float arg1);
public static final native void objc_msgSend_stret(NSRange result, int id, int sel, int arg0, int arg1, NSRange arg2, int arg3);
public static final native int objc_msgSend(int id, int sel, NSPoint arg0, NSPoint arg1);
public static final native int objc_msgSend(int id, int sel, int arg0, NSPoint arg1, NSSize arg2, int arg3, int arg4, int arg5, boolean arg6);
public static final native int objc_msgSend(int id, int sel, NSSize arg0, NSRange arg1);
public static final native int objc_msgSend(int id, int sel, int arg0, int arg1, int arg2, boolean arg3, int arg4);
public static final native int objc_msgSend(int id, int sel, int arg0, int arg1, int arg2);
public static final native void objc_msgSend_stret(NSPoint result, int id, int sel, NSPoint arg0);
public static final native int objc_msgSend(int id, int sel, int arg0, boolean arg1, int arg2);
public static final native double objc_msgSend_fpret(int id, int sel, int arg0, int arg1);
public static final native void objc_msgSend_stret(NSPoint result, int id, int sel, NSPoint arg0, int arg1);
public static final native int objc_msgSend(int id, int sel, NSSize arg0, int arg1);
public static final native int objc_msgSend(int id, int sel, NSRect arg0, int arg1, int arg2, int arg3, int arg4, int arg5);
public static final native int objc_msgSend(int id, int sel, int arg0, NSSize arg1, boolean arg2);
public static final native int objc_msgSend(int id, int sel, int arg0, int arg1, NSRect arg2, int arg3, int arg4);
public static final native int objc_msgSend(int id, int sel, int arg0, int arg1, NSRange arg2);
public static final native void objc_msgSend_stret(NSRect result, int id, int sel, int arg0, int arg1);
public static final native void objc_msgSend_stret(NSSize result, int id, int sel, NSSize arg0, boolean arg1, boolean arg2, int arg3);
public static final native int objc_msgSend(int id, int sel, int arg0, NSRange arg1, NSRange arg2);
public static final native int objc_msgSend(int id, int sel, float arg0, int arg1, int arg2);
public static final native int objc_msgSend(int id, int sel, NSRect arg0, int arg1, boolean arg2, int arg3);
public static final native int objc_msgSend(int id, int sel, int arg0, int arg1, boolean arg2, int arg3);
public static final native int objc_msgSend(int id, int sel, NSRange arg0, int arg1, boolean arg2);
public static final native int objc_msgSend(int id, int sel, int arg0, NSRect arg1, int arg2, int arg3);
public static final native double objc_msgSend_fpret(int id, int sel, NSPoint arg0);
public static final native double objc_msgSend_fpret(int id, int sel, NSRect arg0);
public static final native void objc_msgSend_stret(NSRect result, int id, int sel, int arg0, NSRect arg1, NSRect arg2, int arg3);
public static final native int objc_msgSend(int id, int sel, int arg0, NSPoint arg1, int arg2, double arg3, int arg4, int arg5, short arg6, int arg7, int arg8);
public static final native int objc_msgSend(int id, int sel, byte arg0);
public static final native void objc_msgSend_stret(NSRange result, int id, int sel, int arg0, int arg1);
public static final native double objc_msgSend_fpret(int id, int sel, int arg0, NSRect arg1);
public static final native void objc_msgSend_stret(NSRect result, int id, int sel);
public static final native int objc_msgSend(int id, int sel, int arg0, NSPoint arg1, int arg2);
public static final native void objc_msgSend_stret(NSPoint result, int id, int sel, int arg0, short arg1, NSRect arg2);
public static final native void objc_msgSend_stret(NSRect result, int id, int sel, NSPoint arg0, NSRect arg1, int arg2, NSRange arg3);
public static final native void objc_msgSend_stret(NSSize result, int id, int sel, NSSize arg0);
public static final native int objc_msgSend(int id, int sel, int arg0, int arg1, int arg2, int arg3, int arg4, boolean arg5, boolean arg6, int arg7, int arg8, int arg9);
public static final native int objc_msgSend(int id, int sel, int arg0, NSRect arg1, int arg2, boolean arg3, int arg4);
public static final native int objc_msgSend(int id, int sel, long arg0, int arg1);
public static final native int objc_msgSend(int id, int sel, boolean arg0, boolean arg1);
public static final native int objc_msgSend(int id, int sel, int arg0, NSRect arg1, int arg2, NSRange arg3, int arg4);
public static final native int objc_msgSend(int id, int sel, NSRange arg0, int arg1);
public static final native double objc_msgSend_fpret(int id, int sel, int arg0, int arg1, boolean arg2, float arg3);
public static final native void objc_msgSend_stret(NSRect result, int id, int sel, int arg0, NSPoint arg1, NSRect arg2, int arg3, NSRange arg4);
public static final native int objc_msgSend(int id, int sel, int arg0, int arg1, double arg2);
public static final native int objc_msgSend(int id, int sel, int arg0, int arg1, NSRange arg2, NSPoint arg3, int arg4, int arg5, NSSize arg6);
public static final native int objc_msgSend(int id, int sel, int arg0, boolean arg1, int arg2, int arg3);
public static final native int objc_msgSend(int id, int sel, long arg0);
public static final native int objc_msgSend(int id, int sel, NSRect arg0, int arg1, NSRange arg2);
public static final native int objc_msgSend(int id, int sel, NSRect arg0, int arg1);
public static final native void objc_msgSend_stret(NSRect result, int id, int sel, int arg0, int arg1, int arg2);
public static final native int objc_msgSend(int id, int sel, NSRect arg0, int arg1, boolean arg2);
public static final native int objc_msgSend(int id, int sel, int arg0, short arg1, boolean arg2, boolean arg3, boolean arg4, boolean arg5);
public static final native int objc_msgSend(int id, int sel, NSRect arg0, int arg1, int arg2, boolean arg3, int arg4);
public static final native void objc_msgSend_stret(NSSize result, int id, int sel, NSSize arg0, int arg1);
public static final native int objc_msgSend(int id, int sel, NSPoint arg0, NSPoint arg1, int arg2);
public static final native int objc_msgSend(int id, int sel, NSRect arg0, int arg1, NSRange arg2, int arg3);
public static final native int objc_msgSend(int id, int sel, NSRect arg0, int arg1, int arg2);
public static final native int objc_msgSend(int id, int sel, NSRect arg0, NSRange arg1, NSRect arg2, float arg3);
public static final native void objc_msgSend_stret(NSSize result, int id, int sel, int arg0, int arg1);
public static final native int objc_msgSend(int id, int sel, float arg0, float arg1, float arg2, float arg3);
public static final native void objc_msgSend_stret(NSRect result, int id, int sel, NSRange arg0);
public static final native int objc_msgSend(int id, int sel, NSPoint arg0, NSRect arg1, int arg2);
public static final native int objc_msgSend(int id, int sel, int arg0, int arg1, boolean arg2);
public static final native int objc_msgSend(int id, int sel, int arg0, int arg1, float arg2, int arg3, int arg4);
public static final native int objc_msgSend(int id, int sel, double arg0, int arg1, boolean arg2);
public static final native int objc_msgSend(int id, int sel);
public static final native int objc_msgSend(int id, int sel, NSRange arg0, int arg1, float arg2, NSRect arg3, NSRange arg4, NSPoint arg5);
public static final native int objc_msgSend(int id, int sel, NSRect arg0, boolean arg1, boolean arg2);
public static final native int objc_msgSend(int id, int sel, int arg0, int arg1, int arg2, NSRange arg3, int arg4);
public static final native int objc_msgSend(int id, int sel, NSRect arg0);
public static final native void objc_msgSend_stret(NSRect result, int id, int sel, NSSize arg0, int arg1, int arg2);
public static final native int objc_msgSend(int id, int sel, NSPoint arg0, float arg1, NSPoint arg2, float arg3, int arg4);
public static final native int objc_msgSend(int id, int sel, int arg0, int arg1, boolean arg2, int arg3, int arg4);
public static final native int objc_msgSend(int id, int sel, short arg0);
public static final native int objc_msgSend(int id, int sel, int arg0, NSRect arg1, int arg2);
public static final native void objc_msgSend_stret(NSRect result, int id, int sel, NSRect arg0, NSRect arg1, int arg2, NSRange arg3);
public static final native int objc_msgSend(int id, int sel, NSRange arg0, int arg1, int arg2, int arg3);
public static final native int objc_msgSend(int id, int sel, int arg0, boolean arg1, boolean arg2, int arg3, int arg4);
public static final native void objc_msgSend_stret(NSRange result, int id, int sel, int arg0, int arg1, int arg2, int arg3, boolean arg4);
public static final native int objc_msgSend(int id, int sel, NSRect arg0, NSPoint arg1);
public static final native void objc_msgSend_stret(NSSize result, int id, int sel, int arg0, NSSize arg1);
public static final native int objc_msgSend(int id, int sel, int arg0, int arg1, int arg2, NSPoint arg3);
public static final native double objc_msgSend_fpret(int id, int sel, int arg0, int arg1, float arg2);
public static final native int objc_msgSend(int id, int sel, int arg0, boolean arg1, boolean arg2);
public static final native int objc_msgSend(int id, int sel, int arg0, int arg1, int arg2, boolean arg3);
public static final native void objc_msgSend_stret(NSRect result, int id, int sel, int arg0, int arg1, NSRect arg2, NSPoint arg3, int arg4);
public static final native int objc_msgSend(int id, int sel, int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6);
public static final native void objc_msgSend_stret(NSSize result, int id, int sel, float arg0);
public static final native void objc_msgSend_stret(NSRect result, int id, int sel, int arg0, NSRange arg1);
public static final native int objc_msgSend(int id, int sel, int arg0, int arg1, NSRange arg2, int arg3);
public static final native void objc_msgSend_stret(NSRange result, int id, int sel, NSRange arg0, int arg1);
public static final native void objc_msgSend_stret(NSRange result, int id, int sel, int arg0, int arg1, NSRange arg2);
public static final native int objc_msgSend(int id, int sel, int arg0, int arg1, int arg2, float arg3);
public static final native void objc_msgSend_stret(NSSize result, int id, int sel, int arg0);
public static final native int objc_msgSend(int id, int sel, int arg0, NSPoint arg1, boolean arg2);
public static final native int objc_msgSend(int id, int sel, int arg0, NSRange arg1, int arg2, int arg3);
public static final native void objc_msgSend_stret(NSPoint result, int id, int sel, int arg0, int arg1, int arg2);
public static final native void objc_msgSend_stret(NSRect result, int id, int sel, NSRect arg0);
public static final native int objc_msgSend(int id, int sel, int arg0, int arg1);
public static final native int objc_msgSend(int id, int sel, float arg0, int arg1, int arg2, int arg3);
public static final native int objc_msgSend(int id, int sel, int arg0, NSRect arg1, int arg2, boolean arg3);
public static final native int objc_msgSend(int id, int sel, int arg0, boolean arg1);
public static final native int objc_msgSend(int id, int sel, NSAffineTransformStruct arg0);
public static final native int objc_msgSend(int id, int sel, int arg0, int arg1, NSRect arg2);
public static final native int objc_msgSend(int id, int sel, NSPoint arg0, int arg1, float arg2);
public static final native int objc_msgSend(int id, int sel, int arg0, int arg1, int arg2, NSRange arg3);
public static final native int objc_msgSend(int id, int sel, boolean arg0, NSRect arg1);
public static final native int objc_msgSend(int id, int sel, boolean arg0, int arg1);
public static final native void objc_msgSend_stret(NSRange result, int id, int sel, int arg0, int arg1, int arg2, boolean arg3, int arg4, int arg5);
public static final native int objc_msgSend(int id, int sel, NSPoint arg0, NSRect arg1, int arg2, float arg3);
public static final native int objc_msgSend(int id, int sel, int arg0, NSRect arg1, int arg2, int arg3, boolean arg4);
public static final native double objc_msgSend_fpret(int id, int sel, NSSize arg0);
public static final native int objc_msgSend(int id, int sel, NSPoint arg0, NSPoint arg1, float arg2);
public static final native int objc_msgSend(int id, int sel, int arg0, NSPoint arg1, int arg2, double arg3, int arg4, int arg5, int arg6, int arg7, boolean arg8, short arg9);
public static final native int objc_msgSend(int id, int sel, int arg0, int arg1, int arg2, int arg3, NSRect arg4, float arg5, float arg6, float arg7);
public static final native int objc_msgSend(int id, int sel, short arg0, int arg1);
public static final native int objc_msgSend(int id, int sel, int arg0, NSRange arg1, int arg2);
public static final native void objc_msgSend_stret(NSRange result, int id, int sel, NSRect arg0, int arg1);
public static final native double objc_msgSend_fpret(int id, int sel, int arg0, float arg1, int arg2);
public static final native int objc_msgSend(int id, int sel, float arg0, float arg1, float arg2, float arg3, float arg4);
public static final native int objc_msgSend(int id, int sel, int arg0, short arg1);
public static final native int objc_msgSend(int id, int sel, NSPoint arg0, NSPoint arg1, NSPoint arg2);
public static final native int objc_msgSend(int id, int sel, int arg0, NSPoint arg1, int arg2, double arg3, int arg4, int arg5, int arg6, int arg7, int arg8);
public static final native int objc_msgSend(int id, int sel, double arg0, int arg1, int arg2, int arg3, boolean arg4);
public static final native int objc_msgSend(int id, int sel, boolean arg0, int arg1, int arg2);
public static final native int objc_msgSend(int id, int sel, int arg0, NSRange arg1, int arg2, boolean arg3);
public static final native int objc_msgSend(int id, int sel, int arg0, NSSize arg1);
public static final native int objc_msgSend(int id, int sel, NSRect arg0, boolean arg1);
public static final native int objc_msgSend(int id, int sel, int arg0, NSPoint arg1, NSPoint arg2);
public static final native void objc_msgSend_stret(NSRect result, int id, int sel, NSSize arg0, int arg1);
public static final native int objc_msgSend(int id, int sel, int arg0, int arg1, float arg2);

public static final native int objc_msgSend_struct(NSSize result, int object, int selector);
public static final native void objc_msgSend_struct(NSRange result, int id, int sel, NSRange arg0, int arg1);
public static final native void objc_msgSend_struct(NSSize result, int id, int sel, NSSize arg0, boolean arg1, boolean arg2, int arg3);
public static final native int objc_msgSend_struct(NSPoint result, int object, int selector);
public static final native int objc_msgSend_struct(NSPoint result, int object, int selector, int arg0);
public static final native int objc_msgSend_struct(NSPoint result, int object, int selector, NSPoint arg0);
public static final native int objc_msgSend_struct(NSRange result, int object, int selector, NSRange arg0);
public static final native int objc_msgSend_struct(NSPoint result, int object, int selector, NSPoint arg0, int arg1);
public static final native int objc_msgSend_struct(NSRange result, int object, int selector);
public static final native int objc_msgSend_struct(NSRange result, int object, int selector, int arg0);

public static final native int drawRect_CALLBACK(int func);
public static final native int setFrame_CALLBACK(int func);
public static final native int setFrameOrigin_CALLBACK(int func);
public static final native int setFrameSize_CALLBACK(int func);
public static final native int hitTest_CALLBACK(int func);

public static final native int objc_msgSendSuper(objc_super superId, int sel);
public static final native int objc_msgSendSuper(objc_super superId, int sel, NSRect arg0);
public static final native int objc_msgSendSuper(objc_super superId, int sel, NSPoint arg0);
public static final native int objc_msgSendSuper(objc_super superId, int sel, NSSize arg0);
public static final native int objc_msgSendSuper(objc_super superId, int sel, int arg0);
public static final native int objc_msgSendSuper(objc_super superId, int sel, int arg0, int arg1, int arg2, int arg3);
public static final native void memmove (int /*long*/ dest, NSRect src, int /*long*/ size);
public static final native void memmove (NSRect dest, int /*long*/ src, int /*long*/ size);
public static final native void memmove (NSPoint dest, int /*long*/ src, int /*long*/ size);
public static final native void memmove (NSSize dest, int /*long*/ src, int /*long*/ size);
public static final native void memmove (NSRange dest, int /*long*/ src, int /*long*/ size);

/** Classes */
public static final int class_NSScanner = objc_getClass("NSScanner");
public static final int class_NSCIImageRep = objc_getClass("NSCIImageRep");
public static final int class_NSPathControl = objc_getClass("NSPathControl");
public static final int class_NSTreeController = objc_getClass("NSTreeController");
public static final int class_NSPDFImageRep = objc_getClass("NSPDFImageRep");
public static final int class_NSPageLayout = objc_getClass("NSPageLayout");
public static final int class_NSMetadataQueryAttributeValueTuple = objc_getClass("NSMetadataQueryAttributeValueTuple");
public static final int class_NSAppleScript = objc_getClass("NSAppleScript");
public static final int class_NSGradient = objc_getClass("NSGradient");
public static final int class_NSColorPanel = objc_getClass("NSColorPanel");
public static final int class_NSPrinter = objc_getClass("NSPrinter");
public static final int class_NSCachedURLResponse = objc_getClass("NSCachedURLResponse");
public static final int class_NSLevelIndicatorCell = objc_getClass("NSLevelIndicatorCell");
public static final int class_NSScriptClassDescription = objc_getClass("NSScriptClassDescription");
public static final int class_NSDistantObjectRequest = objc_getClass("NSDistantObjectRequest");
public static final int class_NSOpenPanel = objc_getClass("NSOpenPanel");
public static final int class_NSOperationQueue = objc_getClass("NSOperationQueue");
public static final int class_NSOpenGLPixelBuffer = objc_getClass("NSOpenGLPixelBuffer");
public static final int class_NSRelativeSpecifier = objc_getClass("NSRelativeSpecifier");
public static final int class_NSTextStorage = objc_getClass("NSTextStorage");
public static final int class_NSPopUpButtonCell = objc_getClass("NSPopUpButtonCell");
public static final int class_NSTextContainer = objc_getClass("NSTextContainer");
public static final int class_NSStepperCell = objc_getClass("NSStepperCell");
public static final int class_NSTextTable = objc_getClass("NSTextTable");
public static final int class_NSInvocationOperation = objc_getClass("NSInvocationOperation");
public static final int class_NSDeleteCommand = objc_getClass("NSDeleteCommand");
public static final int class_NSImageView = objc_getClass("NSImageView");
public static final int class_NSMovieView = objc_getClass("NSMovieView");
public static final int class_NSLock = objc_getClass("NSLock");
public static final int class_NSCoder = objc_getClass("NSCoder");
public static final int class_NSXMLElement = objc_getClass("NSXMLElement");
public static final int class_NSLayoutManager = objc_getClass("NSLayoutManager");
public static final int class_NSTabView = objc_getClass("NSTabView");
public static final int class_NSSpeechRecognizer = objc_getClass("NSSpeechRecognizer");
public static final int class_NSAttributedString = objc_getClass("NSAttributedString");
public static final int class_NSProcessInfo = objc_getClass("NSProcessInfo");
public static final int class_NSTextFieldCell = objc_getClass("NSTextFieldCell");
public static final int class_NSDate = objc_getClass("NSDate");
public static final int class_NSMachBootstrapServer = objc_getClass("NSMachBootstrapServer");
public static final int class_NSData = objc_getClass("NSData");
public static final int class_NSNumberFormatter = objc_getClass("NSNumberFormatter");
public static final int class_NSPositionalSpecifier = objc_getClass("NSPositionalSpecifier");
public static final int class_NSSegmentedControl = objc_getClass("NSSegmentedControl");
public static final int class_NSMatrix = objc_getClass("NSMatrix");
public static final int class_NSPanel = objc_getClass("NSPanel");
public static final int class_NSPrintInfo = objc_getClass("NSPrintInfo");
public static final int class_NSResponder = objc_getClass("NSResponder");
public static final int class_NSNull = objc_getClass("NSNull");
public static final int class_NSRunLoop = objc_getClass("NSRunLoop");
public static final int class_NSMutableAttributedString = objc_getClass("NSMutableAttributedString");
public static final int class_NSImageCell = objc_getClass("NSImageCell");
public static final int class_CIColor = objc_getClass("CIColor");
public static final int class_NSSegmentedCell = objc_getClass("NSSegmentedCell");
public static final int class_NSDocument = objc_getClass("NSDocument");
public static final int class_NSTextTab = objc_getClass("NSTextTab");
public static final int class_NSWhoseSpecifier = objc_getClass("NSWhoseSpecifier");
public static final int class_NSMenu = objc_getClass("NSMenu");
public static final int class_NSPopUpButton = objc_getClass("NSPopUpButton");
public static final int class_NSInvocation = objc_getClass("NSInvocation");
public static final int class_NSDatePicker = objc_getClass("NSDatePicker");
public static final int class_NSSliderCell = objc_getClass("NSSliderCell");
public static final int class_NSURLCache = objc_getClass("NSURLCache");
public static final int class_NSSpeechSynthesizer = objc_getClass("NSSpeechSynthesizer");
public static final int class_NSBezierPath = objc_getClass("NSBezierPath");
public static final int class_NSSavePanel = objc_getClass("NSSavePanel");
public static final int class_NSMetadataQuery = objc_getClass("NSMetadataQuery");
public static final int class_NSLogicalTest = objc_getClass("NSLogicalTest");
public static final int class_NSAffineTransform = objc_getClass("NSAffineTransform");
public static final int class_NSTreeNode = objc_getClass("NSTreeNode");
public static final int class_NSControl = objc_getClass("NSControl");
public static final int class_NSWindowController = objc_getClass("NSWindowController");
public static final int class_NSURLResponse = objc_getClass("NSURLResponse");
public static final int class_NSFormatter = objc_getClass("NSFormatter");
public static final int class_NSAssertionHandler = objc_getClass("NSAssertionHandler");
public static final int class_NSPort = objc_getClass("NSPort");
public static final int class_NSURLProtectionSpace = objc_getClass("NSURLProtectionSpace");
public static final int class_NSPredicate = objc_getClass("NSPredicate");
public static final int class_NSIndexSpecifier = objc_getClass("NSIndexSpecifier");
public static final int class_NSPortMessage = objc_getClass("NSPortMessage");
public static final int class_NSTypesetter = objc_getClass("NSTypesetter");
public static final int class_NSCompoundPredicate = objc_getClass("NSCompoundPredicate");
public static final int class_NSBundle = objc_getClass("NSBundle");
public static final int class_NSSortDescriptor = objc_getClass("NSSortDescriptor");
public static final int class_NSFontManager = objc_getClass("NSFontManager");
public static final int class_NSProxy = objc_getClass("NSProxy");
public static final int class_NSTextView = objc_getClass("NSTextView");
public static final int class_NSMutableSet = objc_getClass("NSMutableSet");
public static final int class_NSDatePickerCell = objc_getClass("NSDatePickerCell");
public static final int class_NSStatusItem = objc_getClass("NSStatusItem");
public static final int class_NSDirectoryEnumerator = objc_getClass("NSDirectoryEnumerator");
public static final int class_NSPropertyListSerialization = objc_getClass("NSPropertyListSerialization");
public static final int class_NSHost = objc_getClass("NSHost");
public static final int class_NSPipe = objc_getClass("NSPipe");
public static final int class_NSNibConnector = objc_getClass("NSNibConnector");
public static final int class_NSDecimalNumber = objc_getClass("NSDecimalNumber");
public static final int class_NSMenuView = objc_getClass("NSMenuView");
public static final int class_NSMenuItem = objc_getClass("NSMenuItem");
public static final int class_NSPICTImageRep = objc_getClass("NSPICTImageRep");
public static final int class_NSPasteboard = objc_getClass("NSPasteboard");
public static final int class_NSScriptExecutionContext = objc_getClass("NSScriptExecutionContext");
public static final int class_NSNotificationQueue = objc_getClass("NSNotificationQueue");
public static final int class_NSError = objc_getClass("NSError");
public static final int class_NSNib = objc_getClass("NSNib");
public static final int class_NSAppleEventManager = objc_getClass("NSAppleEventManager");
public static final int class_NSCondition = objc_getClass("NSCondition");
public static final int class_NSBrowser = objc_getClass("NSBrowser");
public static final int class_NSDocumentController = objc_getClass("NSDocumentController");
public static final int class_NSMethodSignature = objc_getClass("NSMethodSignature");
public static final int class_NSTextList = objc_getClass("NSTextList");
public static final int class_NSURLCredentialStorage = objc_getClass("NSURLCredentialStorage");
public static final int class_NSEvent = objc_getClass("NSEvent");
public static final int class_NSScreen = objc_getClass("NSScreen");
public static final int class_NSMutableCharacterSet = objc_getClass("NSMutableCharacterSet");
public static final int class_NSSecureTextFieldCell = objc_getClass("NSSecureTextFieldCell");
public static final int class_NSOpenGLPixelFormat = objc_getClass("NSOpenGLPixelFormat");
public static final int class_NSInputServer = objc_getClass("NSInputServer");
public static final int class_NSNotification = objc_getClass("NSNotification");
public static final int class_NSSpecifierTest = objc_getClass("NSSpecifierTest");
public static final int class_NSCustomImageRep = objc_getClass("NSCustomImageRep");
public static final int class_NSParagraphStyle = objc_getClass("NSParagraphStyle");
public static final int class_NSTableView = objc_getClass("NSTableView");
public static final int class_NSFileWrapper = objc_getClass("NSFileWrapper");
public static final int class_NSNotificationCenter = objc_getClass("NSNotificationCenter");
public static final int class_NSMutableString = objc_getClass("NSMutableString");
public static final int class_NSFontPanel = objc_getClass("NSFontPanel");
public static final int class_NSAppleEventDescriptor = objc_getClass("NSAppleEventDescriptor");
public static final int class_NSConnection = objc_getClass("NSConnection");
public static final int class_NSURLDownload = objc_getClass("NSURLDownload");
public static final int class_NSKeyedUnarchiver = objc_getClass("NSKeyedUnarchiver");
public static final int class_NSCountedSet = objc_getClass("NSCountedSet");
public static final int class_NSSlider = objc_getClass("NSSlider");
public static final int class_NSCharacterSet = objc_getClass("NSCharacterSet");
public static final int class_NSDictionary = objc_getClass("NSDictionary");
public static final int class_NSOpenGLContext = objc_getClass("NSOpenGLContext");
public static final int class_NSCachedImageRep = objc_getClass("NSCachedImageRep");
public static final int class_NSURL = objc_getClass("NSURL");
public static final int class_NSInputStream = objc_getClass("NSInputStream");
public static final int class_NSMutableURLRequest = objc_getClass("NSMutableURLRequest");
public static final int class_NSURLConnection = objc_getClass("NSURLConnection");
public static final int class_NSPersistentDocument = objc_getClass("NSPersistentDocument");
public static final int class_NSClipView = objc_getClass("NSClipView");
public static final int class_NSScriptSuiteRegistry = objc_getClass("NSScriptSuiteRegistry");
public static final int class_NSStepper = objc_getClass("NSStepper");
public static final int class_NSXMLNode = objc_getClass("NSXMLNode");
public static final int class_NSHTTPCookie = objc_getClass("NSHTTPCookie");
public static final int class_NSMetadataQueryResultGroup = objc_getClass("NSMetadataQueryResultGroup");
public static final int class_NSURLCredential = objc_getClass("NSURLCredential");
public static final int class_NSHashTable = objc_getClass("NSHashTable");
public static final int class_NSColor = objc_getClass("NSColor");
public static final int class_NSPathComponentCell = objc_getClass("NSPathComponentCell");
public static final int class_NSToolbar = objc_getClass("NSToolbar");
public static final int class_NSUndoManager = objc_getClass("NSUndoManager");
public static final int class_NSNibControlConnector = objc_getClass("NSNibControlConnector");
public static final int class_NSFontDescriptor = objc_getClass("NSFontDescriptor");
public static final int class_NSSpellChecker = objc_getClass("NSSpellChecker");
public static final int class_NSTableColumn = objc_getClass("NSTableColumn");
public static final int class_NSSpellServer = objc_getClass("NSSpellServer");
public static final int class_NSAutoreleasePool = objc_getClass("NSAutoreleasePool");
public static final int class_NSUnarchiver = objc_getClass("NSUnarchiver");
public static final int class_NSColorSpace = objc_getClass("NSColorSpace");
public static final int class_NSQuickDrawView = objc_getClass("NSQuickDrawView");
public static final int class_NSDrawer = objc_getClass("NSDrawer");
public static final int class_NSFileHandle = objc_getClass("NSFileHandle");
public static final int class_NSCalendarDate = objc_getClass("NSCalendarDate");
public static final int class_NSThread = objc_getClass("NSThread");
public static final int class_NSProtocolChecker = objc_getClass("NSProtocolChecker");
public static final int class_NSDateComponents = objc_getClass("NSDateComponents");
public static final int class_NSAnimationContext = objc_getClass("NSAnimationContext");
public static final int class_NSURLRequest = objc_getClass("NSURLRequest");
public static final int class_NSViewAnimation = objc_getClass("NSViewAnimation");
public static final int class_NSScriptObjectSpecifier = objc_getClass("NSScriptObjectSpecifier");
public static final int class_NSCell = objc_getClass("NSCell");
public static final int class_NSTableHeaderCell = objc_getClass("NSTableHeaderCell");
public static final int class_NSATSTypesetter = objc_getClass("NSATSTypesetter");
public static final int class_NSNetService = objc_getClass("NSNetService");
public static final int class_NSMutableParagraphStyle = objc_getClass("NSMutableParagraphStyle");
public static final int class_NSButton = objc_getClass("NSButton");
public static final int class_NSAnimation = objc_getClass("NSAnimation");
public static final int class_NSText = objc_getClass("NSText");
public static final int class_NSMapTable = objc_getClass("NSMapTable");
public static final int class_NSDictionaryController = objc_getClass("NSDictionaryController");
public static final int class_NSTrackingArea = objc_getClass("NSTrackingArea");
public static final int class_NSURLProtocol = objc_getClass("NSURLProtocol");
public static final int class_NSGlyphInfo = objc_getClass("NSGlyphInfo");
public static final int class_NSSocketPortNameServer = objc_getClass("NSSocketPortNameServer");
public static final int class_NSQuitCommand = objc_getClass("NSQuitCommand");
public static final int class_NSDistributedNotificationCenter = objc_getClass("NSDistributedNotificationCenter");
public static final int class_NSCloseCommand = objc_getClass("NSCloseCommand");
public static final int class_NSPrintOperation = objc_getClass("NSPrintOperation");
public static final int class_NSGraphicsContext = objc_getClass("NSGraphicsContext");
public static final int class_NSNumber = objc_getClass("NSNumber");
public static final int class_NSPortCoder = objc_getClass("NSPortCoder");
public static final int class_NSTextTableBlock = objc_getClass("NSTextTableBlock");
public static final int class_NSNibOutletConnector = objc_getClass("NSNibOutletConnector");
public static final int class_NSLocale = objc_getClass("NSLocale");
public static final int class_NSTableHeaderView = objc_getClass("NSTableHeaderView");
public static final int class_NSScriptWhoseTest = objc_getClass("NSScriptWhoseTest");
public static final int class_NSNetServiceBrowser = objc_getClass("NSNetServiceBrowser");
public static final int class_NSConditionLock = objc_getClass("NSConditionLock");
public static final int class_NSTimeZone = objc_getClass("NSTimeZone");
public static final int class_NSComparisonPredicate = objc_getClass("NSComparisonPredicate");
public static final int class_NSScriptCoercionHandler = objc_getClass("NSScriptCoercionHandler");
public static final int class_NSFileManager = objc_getClass("NSFileManager");
public static final int class_NSPredicateEditorRowTemplate = objc_getClass("NSPredicateEditorRowTemplate");
public static final int class_NSString = objc_getClass("NSString");
public static final int class_NSToolbarItem = objc_getClass("NSToolbarItem");
public static final int class_NSPointerArray = objc_getClass("NSPointerArray");
public static final int class_NSURLAuthenticationChallenge = objc_getClass("NSURLAuthenticationChallenge");
public static final int class_NSStatusBar = objc_getClass("NSStatusBar");
public static final int class_NSTextField = objc_getClass("NSTextField");
public static final int class_NSSecureTextField = objc_getClass("NSSecureTextField");
public static final int class_NSOutputStream = objc_getClass("NSOutputStream");
public static final int class_NSComboBoxCell = objc_getClass("NSComboBoxCell");
public static final int class_NSXMLDTDNode = objc_getClass("NSXMLDTDNode");
public static final int class_NSMessagePortNameServer = objc_getClass("NSMessagePortNameServer");
public static final int class_NSHTTPCookieStorage = objc_getClass("NSHTTPCookieStorage");
public static final int class_NSActionCell = objc_getClass("NSActionCell");
public static final int class_NSXMLDocument = objc_getClass("NSXMLDocument");
public static final int class_NSBitmapImageRep = objc_getClass("NSBitmapImageRep");
public static final int class_NSHTTPURLResponse = objc_getClass("NSHTTPURLResponse");
public static final int class_NSImage = objc_getClass("NSImage");
public static final int class_NSIndexSet = objc_getClass("NSIndexSet");
public static final int class_NSRangeSpecifier = objc_getClass("NSRangeSpecifier");
public static final int class_NSGlyphGenerator = objc_getClass("NSGlyphGenerator");
public static final int class_NSFormCell = objc_getClass("NSFormCell");
public static final int class_NSScroller = objc_getClass("NSScroller");
public static final int class_NSMetadataItem = objc_getClass("NSMetadataItem");
public static final int class_NSStream = objc_getClass("NSStream");
public static final int class_NSClassDescription = objc_getClass("NSClassDescription");
public static final int class_NSMutableIndexSet = objc_getClass("NSMutableIndexSet");
public static final int class_NSView = objc_getClass("NSView");
public static final int class_NSUserDefaults = objc_getClass("NSUserDefaults");
public static final int class_NSSetCommand = objc_getClass("NSSetCommand");
public static final int class_NSPathCell = objc_getClass("NSPathCell");
public static final int class_NSMoveCommand = objc_getClass("NSMoveCommand");
public static final int class_NSSplitView = objc_getClass("NSSplitView");
public static final int class_NSTextBlock = objc_getClass("NSTextBlock");
public static final int class_NSTabViewItem = objc_getClass("NSTabViewItem");
public static final int class_NSCollectionViewItem = objc_getClass("NSCollectionViewItem");
public static final int class_NSValue = objc_getClass("NSValue");
public static final int class_NSHelpManager = objc_getClass("NSHelpManager");
public static final int class_NSEnumerator = objc_getClass("NSEnumerator");
public static final int class_NSDistantObject = objc_getClass("NSDistantObject");
public static final int class_NSGarbageCollector = objc_getClass("NSGarbageCollector");
public static final int class_NSXMLParser = objc_getClass("NSXMLParser");
public static final int class_NSFont = objc_getClass("NSFont");
public static final int class_NSAlert = objc_getClass("NSAlert");
public static final int class_NSUniqueIDSpecifier = objc_getClass("NSUniqueIDSpecifier");
public static final int class_NSOutlineView = objc_getClass("NSOutlineView");
public static final int class_NSProgressIndicator = objc_getClass("NSProgressIndicator");
public static final int class_NSController = objc_getClass("NSController");
public static final int class_NSComboBox = objc_getClass("NSComboBox");
public static final int class_NSArrayController = objc_getClass("NSArrayController");
public static final int class_NSKeyedArchiver = objc_getClass("NSKeyedArchiver");
public static final int class_NSDecimalNumberHandler = objc_getClass("NSDecimalNumberHandler");
public static final int class_NSObject = objc_getClass("NSObject");
public static final int class_NSNameSpecifier = objc_getClass("NSNameSpecifier");
public static final int class_NSUserDefaultsController = objc_getClass("NSUserDefaultsController");
public static final int class_NSLevelIndicator = objc_getClass("NSLevelIndicator");
public static final int class_NSDistributedLock = objc_getClass("NSDistributedLock");
public static final int class_NSTokenFieldCell = objc_getClass("NSTokenFieldCell");
public static final int class_NSSet = objc_getClass("NSSet");
public static final int class_NSMutableData = objc_getClass("NSMutableData");
public static final int class_NSArray = objc_getClass("NSArray");
public static final int class_NSExpression = objc_getClass("NSExpression");
public static final int class_NSMenuItemCell = objc_getClass("NSMenuItemCell");
public static final int class_NSColorPicker = objc_getClass("NSColorPicker");
public static final int class_NSForm = objc_getClass("NSForm");
public static final int class_NSApplication = objc_getClass("NSApplication");
public static final int class_NSInputManager = objc_getClass("NSInputManager");
public static final int class_NSPointerFunctions = objc_getClass("NSPointerFunctions");
public static final int class_NSRecursiveLock = objc_getClass("NSRecursiveLock");
public static final int class_NSBox = objc_getClass("NSBox");
public static final int class_NSDockTile = objc_getClass("NSDockTile");
public static final int class_NSTextAttachment = objc_getClass("NSTextAttachment");
public static final int class_NSIndexPath = objc_getClass("NSIndexPath");
public static final int class_NSEPSImageRep = objc_getClass("NSEPSImageRep");
public static final int class_NSBrowserCell = objc_getClass("NSBrowserCell");
public static final int class_NSValueTransformer = objc_getClass("NSValueTransformer");
public static final int class_CIImage = objc_getClass("CIImage");
public static final int class_NSMovie = objc_getClass("NSMovie");
public static final int class_NSTimer = objc_getClass("NSTimer");
public static final int class_NSMachPort = objc_getClass("NSMachPort");
public static final int class_NSCreateCommand = objc_getClass("NSCreateCommand");
public static final int class_NSPortNameServer = objc_getClass("NSPortNameServer");
public static final int class_NSRulerMarker = objc_getClass("NSRulerMarker");
public static final int class_NSImageRep = objc_getClass("NSImageRep");
public static final int class_NSWindow = objc_getClass("NSWindow");
public static final int class_NSColorWell = objc_getClass("NSColorWell");
public static final int class_NSSound = objc_getClass("NSSound");
public static final int class_NSToolbarItemGroup = objc_getClass("NSToolbarItemGroup");
public static final int class_NSRulerView = objc_getClass("NSRulerView");
public static final int class_NSWorkspace = objc_getClass("NSWorkspace");
public static final int class_NSSearchFieldCell = objc_getClass("NSSearchFieldCell");
public static final int class_NSMutableArray = objc_getClass("NSMutableArray");
public static final int class_NSRuleEditor = objc_getClass("NSRuleEditor");
public static final int class_NSScriptCommandDescription = objc_getClass("NSScriptCommandDescription");
public static final int class_NSViewController = objc_getClass("NSViewController");
public static final int class_NSPredicateEditor = objc_getClass("NSPredicateEditor");
public static final int class_NSCloneCommand = objc_getClass("NSCloneCommand");
public static final int class_NSOpenGLView = objc_getClass("NSOpenGLView");
public static final int class_NSCursor = objc_getClass("NSCursor");
public static final int class_NSSearchField = objc_getClass("NSSearchField");
public static final int class_NSXMLDTD = objc_getClass("NSXMLDTD");
public static final int class_NSSocketPort = objc_getClass("NSSocketPort");
public static final int class_NSObjectController = objc_getClass("NSObjectController");
public static final int class_NSScriptCommand = objc_getClass("NSScriptCommand");
public static final int class_NSShadow = objc_getClass("NSShadow");
public static final int class_NSScrollView = objc_getClass("NSScrollView");
public static final int class_NSPrintPanel = objc_getClass("NSPrintPanel");
public static final int class_NSURLHandle = objc_getClass("NSURLHandle");
public static final int class_NSOperation = objc_getClass("NSOperation");
public static final int class_NSMutableDictionary = objc_getClass("NSMutableDictionary");
public static final int class_NSException = objc_getClass("NSException");
public static final int class_NSButtonCell = objc_getClass("NSButtonCell");
public static final int class_NSTask = objc_getClass("NSTask");
public static final int class_NSArchiver = objc_getClass("NSArchiver");
public static final int class_NSDateFormatter = objc_getClass("NSDateFormatter");
public static final int class_NSCalendar = objc_getClass("NSCalendar");
public static final int class_NSTokenField = objc_getClass("NSTokenField");
public static final int class_NSCollectionView = objc_getClass("NSCollectionView");
public static final int class_NSColorList = objc_getClass("NSColorList");
public static final int class_DOMEvent = objc_getClass("DOMEvent");
public static final int class_DOMWheelEvent = objc_getClass("DOMWheelEvent");
public static final int class_WebView = objc_getClass("WebView");
public static final int class_WebPreferences = objc_getClass("WebPreferences");
public static final int class_WebFrameView = objc_getClass("WebFrameView");

/** Selectors */
public static final int sel_inputClientEnabled_1 = sel_registerName("inputClientEnabled:");
public static final int sel_setVerticalPagination_1 = sel_registerName("setVerticalPagination:");
public static final int sel_isEqualToHost_1 = sel_registerName("isEqualToHost:");
public static final int sel_compare_1 = sel_registerName("compare:");
public static final int sel_printPanel = sel_registerName("printPanel");
public static final int sel_unregisterImageRepClass_1 = sel_registerName("unregisterImageRepClass:");
public static final int sel_dataWithLength_1 = sel_registerName("dataWithLength:");
public static final int sel_dismissPopUp = sel_registerName("dismissPopUp");
public static final int sel_substituteFontForFont_1 = sel_registerName("substituteFontForFont:");
public static final int sel_sendAction_1to_1 = sel_registerName("sendAction:to:");
public static final int sel_rangeOfCharacterFromSet_1options_1range_1 = sel_registerName("rangeOfCharacterFromSet:options:range:");
public static final int sel_autoupdatingCurrentCalendar = sel_registerName("autoupdatingCurrentCalendar");
public static final int sel_nextDaylightSavingTimeTransitionAfterDate_1 = sel_registerName("nextDaylightSavingTimeTransitionAfterDate:");
public static final int sel_attachmentSizeForGlyphAtIndex_1 = sel_registerName("attachmentSizeForGlyphAtIndex:");
public static final int sel_shouldCollapseAutoExpandedItemsForDeposited_1 = sel_registerName("shouldCollapseAutoExpandedItemsForDeposited:");
public static final int sel_decimalNumberByRoundingAccordingToBehavior_1 = sel_registerName("decimalNumberByRoundingAccordingToBehavior:");
public static final int sel_scanHexFloat_1 = sel_registerName("scanHexFloat:");
public static final int sel_rangesForUserTextChange = sel_registerName("rangesForUserTextChange");
public static final int sel_indexOfItemWithObjectValue_1 = sel_registerName("indexOfItemWithObjectValue:");
public static final int sel_sendsSearchStringImmediately = sel_registerName("sendsSearchStringImmediately");
public static final int sel_isTransparent = sel_registerName("isTransparent");
public static final int sel_widthOfColumn_1 = sel_registerName("widthOfColumn:");
public static final int sel_calendarFormat = sel_registerName("calendarFormat");
public static final int sel_lineBreakByHyphenatingBeforeIndex_1withinRange_1 = sel_registerName("lineBreakByHyphenatingBeforeIndex:withinRange:");
public static final int sel_parentNode = sel_registerName("parentNode");
public static final int sel_setDrawsOutsideLineFragment_1forGlyphRange_1 = sel_registerName("setDrawsOutsideLineFragment:forGlyphRange:");
public static final int sel_negativeSuffix = sel_registerName("negativeSuffix");
public static final int sel_setFlatness_1 = sel_registerName("setFlatness:");
public static final int sel_ignoresAlpha = sel_registerName("ignoresAlpha");
public static final int sel_setValue_1type_1forDimension_1 = sel_registerName("setValue:type:forDimension:");
public static final int sel_setLayer_1 = sel_registerName("setLayer:");
public static final int sel_setActionName_1 = sel_registerName("setActionName:");
public static final int sel_setIcon_1 = sel_registerName("setIcon:");
public static final int sel_tokenFieldCell_1readFromPasteboard_1 = sel_registerName("tokenFieldCell:readFromPasteboard:");
public static final int sel_setPropertyList_1forType_1 = sel_registerName("setPropertyList:forType:");
public static final int sel_endModalSession_1 = sel_registerName("endModalSession:");
public static final int sel_sharedColorPanel = sel_registerName("sharedColorPanel");
public static final int sel_contentSizeForFrameSize_1hasHorizontalScroller_1hasVerticalScroller_1borderType_1 = sel_registerName("contentSizeForFrameSize:hasHorizontalScroller:hasVerticalScroller:borderType:");
public static final int sel_layoutRectForTextBlock_1glyphRange_1 = sel_registerName("layoutRectForTextBlock:glyphRange:");
public static final int sel_scrollRowToVisible_1 = sel_registerName("scrollRowToVisible:");
public static final int sel_attributedStringForZero = sel_registerName("attributedStringForZero");
public static final int sel_showsInvisibleCharacters = sel_registerName("showsInvisibleCharacters");
public static final int sel_adjustPageWidthNew_1left_1right_1limit_1 = sel_registerName("adjustPageWidthNew:left:right:limit:");
public static final int sel_client = sel_registerName("client");
public static final int sel_initWithKey_1ascending_1selector_1 = sel_registerName("initWithKey:ascending:selector:");
public static final int sel_completedString_1 = sel_registerName("completedString:");
public static final int sel_bundleForClass_1 = sel_registerName("bundleForClass:");
public static final int sel_pathControl_1acceptDrop_1 = sel_registerName("pathControl:acceptDrop:");
public static final int sel_imageRepsWithPasteboard_1 = sel_registerName("imageRepsWithPasteboard:");
public static final int sel_toolTipForSegment_1 = sel_registerName("toolTipForSegment:");
public static final int sel_suspended = sel_registerName("suspended");
public static final int sel_encodeDouble_1forKey_1 = sel_registerName("encodeDouble:forKey:");
public static final int sel_setNextState = sel_registerName("setNextState");
public static final int sel_ignoreWord_1inSpellDocumentWithTag_1 = sel_registerName("ignoreWord:inSpellDocumentWithTag:");
public static final int sel_stopMonitoring = sel_registerName("stopMonitoring");
public static final int sel_initWithTitle_1action_1keyEquivalent_1 = sel_registerName("initWithTitle:action:keyEquivalent:");
public static final int sel_setDropRow_1dropOperation_1 = sel_registerName("setDropRow:dropOperation:");
public static final int sel_contentView = sel_registerName("contentView");
public static final int sel_setNilSymbol_1 = sel_registerName("setNilSymbol:");
public static final int sel_removePropertyForKey_1inRequest_1 = sel_registerName("removePropertyForKey:inRequest:");
public static final int sel_setMarkerLocation_1 = sel_registerName("setMarkerLocation:");
public static final int sel_resolvedKeyDictionary = sel_registerName("resolvedKeyDictionary");
public static final int sel_enumeratorAtPath_1 = sel_registerName("enumeratorAtPath:");
public static final int sel_decodeObjectForKey_1 = sel_registerName("decodeObjectForKey:");
public static final int sel_loadInForeground = sel_registerName("loadInForeground");
public static final int sel_baseSpecifier = sel_registerName("baseSpecifier");
public static final int sel_isMemberOfClass_1 = sel_registerName("isMemberOfClass:");
public static final int sel_setMaxVisibleColumns_1 = sel_registerName("setMaxVisibleColumns:");
public static final int sel_unmountAndEjectDeviceAtPath_1 = sel_registerName("unmountAndEjectDeviceAtPath:");
public static final int sel_openTempFile_1 = sel_registerName("openTempFile:");
public static final int sel_isRowSelected_1 = sel_registerName("isRowSelected:");
public static final int sel_insertItemWithItemIdentifier_1atIndex_1 = sel_registerName("insertItemWithItemIdentifier:atIndex:");
public static final int sel_parserDidEndDocument_1 = sel_registerName("parserDidEndDocument:");
public static final int sel_reverseTransformedValue_1 = sel_registerName("reverseTransformedValue:");
public static final int sel_setTimeStyle_1 = sel_registerName("setTimeStyle:");
public static final int sel_initWithContentsOfFile_1usedEncoding_1error_1 = sel_registerName("initWithContentsOfFile:usedEncoding:error:");
public static final int sel_endGrouping = sel_registerName("endGrouping");
public static final int sel_initWithProxyHost_1port_1type_1realm_1authenticationMethod_1 = sel_registerName("initWithProxyHost:port:type:realm:authenticationMethod:");
public static final int sel_tableView_1dataCellForTableColumn_1row_1 = sel_registerName("tableView:dataCellForTableColumn:row:");
public static final int sel_convertPoint_1toView_1 = sel_registerName("convertPoint:toView:");
public static final int sel_setFrame_1display_1animate_1 = sel_registerName("setFrame:display:animate:");
public static final int sel_exceptionDuringOperation_1error_1leftOperand_1rightOperand_1 = sel_registerName("exceptionDuringOperation:error:leftOperand:rightOperand:");
public static final int sel_applicationOpenUntitledFile_1 = sel_registerName("applicationOpenUntitledFile:");
public static final int sel_initWithRootElement_1 = sel_registerName("initWithRootElement:");
public static final int sel_setHorizontalScroller_1 = sel_registerName("setHorizontalScroller:");
public static final int sel_finalWritePrintInfo = sel_registerName("finalWritePrintInfo");
public static final int sel_addItemWithTitle_1 = sel_registerName("addItemWithTitle:");
public static final int sel_setColor_1 = sel_registerName("setColor:");
public static final int sel_isHostCacheEnabled = sel_registerName("isHostCacheEnabled");
public static final int sel_controlTextDidChange_1 = sel_registerName("controlTextDidChange:");
public static final int sel_headerLevel = sel_registerName("headerLevel");
public static final int sel_loadInBackground = sel_registerName("loadInBackground");
public static final int sel_setNeedsDisplayForItemAtIndex_1 = sel_registerName("setNeedsDisplayForItemAtIndex:");
public static final int sel_setCellPrototype_1 = sel_registerName("setCellPrototype:");
public static final int sel_enqueueNotification_1postingStyle_1coalesceMask_1forModes_1 = sel_registerName("enqueueNotification:postingStyle:coalesceMask:forModes:");
public static final int sel_minColumnWidth = sel_registerName("minColumnWidth");
public static final int sel_tableView_1shouldTypeSelectForEvent_1withCurrentSearchString_1 = sel_registerName("tableView:shouldTypeSelectForEvent:withCurrentSearchString:");
public static final int sel_validateValue_1forKey_1error_1 = sel_registerName("validateValue:forKey:error:");
public static final int sel_canBeConvertedToEncoding_1 = sel_registerName("canBeConvertedToEncoding:");
public static final int sel_numberOfItems = sel_registerName("numberOfItems");
public static final int sel_bestRepresentationForDevice_1 = sel_registerName("bestRepresentationForDevice:");
public static final int sel_setBorderColor_1forEdge_1 = sel_registerName("setBorderColor:forEdge:");
public static final int sel_setHorizontalLineScroll_1 = sel_registerName("setHorizontalLineScroll:");
public static final int sel_sharedHTTPCookieStorage = sel_registerName("sharedHTTPCookieStorage");
public static final int sel_cachesBezierPath = sel_registerName("cachesBezierPath");
public static final int sel_strokeLineFromPoint_1toPoint_1 = sel_registerName("strokeLineFromPoint:toPoint:");
public static final int sel_preferredBackingLocation = sel_registerName("preferredBackingLocation");
public static final int sel_removeRowAtIndex_1 = sel_registerName("removeRowAtIndex:");
public static final int sel_setCurrentTime_1 = sel_registerName("setCurrentTime:");
public static final int sel_string = sel_registerName("string");
public static final int sel_hasVerticalScroller = sel_registerName("hasVerticalScroller");
public static final int sel_initWithTimeInterval_1sinceDate_1 = sel_registerName("initWithTimeInterval:sinceDate:");
public static final int sel_showsProgressPanel = sel_registerName("showsProgressPanel");
public static final int sel_setDirectParameter_1 = sel_registerName("setDirectParameter:");
public static final int sel_storeCachedResponse_1forRequest_1 = sel_registerName("storeCachedResponse:forRequest:");
public static final int sel_textUnfilteredPasteboardTypes = sel_registerName("textUnfilteredPasteboardTypes");
public static final int sel_isDragging = sel_registerName("isDragging");
public static final int sel_tableView_1shouldTrackCell_1forTableColumn_1row_1 = sel_registerName("tableView:shouldTrackCell:forTableColumn:row:");
public static final int sel_dictionaryRepresentation = sel_registerName("dictionaryRepresentation");
public static final int sel_attributesForExtraLineFragment = sel_registerName("attributesForExtraLineFragment");
public static final int sel_getCharacters_1range_1 = sel_registerName("getCharacters:range:");
public static final int sel_nibName = sel_registerName("nibName");
public static final int sel_initWithURL_1options_1documentAttributes_1error_1 = sel_registerName("initWithURL:options:documentAttributes:error:");
public static final int sel_initWithFrame_1mode_1cellClass_1numberOfRows_1numberOfColumns_1 = sel_registerName("initWithFrame:mode:cellClass:numberOfRows:numberOfColumns:");
public static final int sel_reflectScrolledClipView_1 = sel_registerName("reflectScrolledClipView:");
public static final int sel_stringWithContentsOfURL_1usedEncoding_1error_1 = sel_registerName("stringWithContentsOfURL:usedEncoding:error:");
public static final int sel_displayIfNeededIgnoringOpacity = sel_registerName("displayIfNeededIgnoringOpacity");
public static final int sel_archiverWillFinish_1 = sel_registerName("archiverWillFinish:");
public static final int sel_initWithOptions_1 = sel_registerName("initWithOptions:");
public static final int sel_ruleEditor_1numberOfChildrenForCriterion_1withRowType_1 = sel_registerName("ruleEditor:numberOfChildrenForCriterion:withRowType:");
public static final int sel_removeColorWithKey_1 = sel_registerName("removeColorWithKey:");
public static final int sel_setObjectValue_1 = sel_registerName("setObjectValue:");
public static final int sel_graphicsContextWithGraphicsPort_1flipped_1 = sel_registerName("graphicsContextWithGraphicsPort:flipped:");
public static final int sel_setMarkedText_1selectedRange_1replacementRange_1 = sel_registerName("setMarkedText:selectedRange:replacementRange:");
public static final int sel_outlineView_1numberOfChildrenOfItem_1 = sel_registerName("outlineView:numberOfChildrenOfItem:");
public static final int sel_cellFrameAtRow_1column_1 = sel_registerName("cellFrameAtRow:column:");
public static final int sel_blueColor = sel_registerName("blueColor");
public static final int sel_selectedTextBackgroundColor = sel_registerName("selectedTextBackgroundColor");
public static final int sel_initWithFormat_1locale_1 = sel_registerName("initWithFormat:locale:");
public static final int sel_propertyListForType_1 = sel_registerName("propertyListForType:");
public static final int sel_setConfigurationFromDictionary_1 = sel_registerName("setConfigurationFromDictionary:");
public static final int sel_registerClassDescription_1forClass_1 = sel_registerName("registerClassDescription:forClass:");
public static final int sel_removeAllItems = sel_registerName("removeAllItems");
public static final int sel_setFontPanelFactory_1 = sel_registerName("setFontPanelFactory:");
public static final int sel_didChangeValueForKey_1withSetMutation_1usingObjects_1 = sel_registerName("didChangeValueForKey:withSetMutation:usingObjects:");
public static final int sel_CGEvent = sel_registerName("CGEvent");
public static final int sel_disable = sel_registerName("disable");
public static final int sel_setColumnAutoresizingStyle_1 = sel_registerName("setColumnAutoresizingStyle:");
public static final int sel_absoluteZ = sel_registerName("absoluteZ");
public static final int sel_intForKey_1inTable_1 = sel_registerName("intForKey:inTable:");
public static final int sel_minFrameWidthWithTitle_1styleMask_1 = sel_registerName("minFrameWidthWithTitle:styleMask:");
public static final int sel_highlightColor = sel_registerName("highlightColor");
public static final int sel_setRoundingMode_1 = sel_registerName("setRoundingMode:");
public static final int sel_didChangeValueForKey_1 = sel_registerName("didChangeValueForKey:");
public static final int sel_setMenuZone_1 = sel_registerName("setMenuZone:");
public static final int sel_updateFromPrintInfo = sel_registerName("updateFromPrintInfo");
public static final int sel_setSelectedItemIdentifier_1 = sel_registerName("setSelectedItemIdentifier:");
public static final int sel_setReplyTimeout_1 = sel_registerName("setReplyTimeout:");
public static final int sel_showsFirstResponder = sel_registerName("showsFirstResponder");
public static final int sel_loadNibNamed_1owner_1 = sel_registerName("loadNibNamed:owner:");
public static final int sel_setDocument_1 = sel_registerName("setDocument:");
public static final int sel_filePosixPermissions = sel_registerName("filePosixPermissions");
public static final int sel_collapseItem_1collapseChildren_1 = sel_registerName("collapseItem:collapseChildren:");
public static final int sel_setCell_1 = sel_registerName("setCell:");
public static final int sel_setHTTPBodyStream_1 = sel_registerName("setHTTPBodyStream:");
public static final int sel_updateAttachmentsFromPath_1 = sel_registerName("updateAttachmentsFromPath:");
public static final int sel_updateFontPanel = sel_registerName("updateFontPanel");
public static final int sel_animationDidStop_1 = sel_registerName("animationDidStop:");
public static final int sel_URL_1resourceDidFailLoadingWithReason_1 = sel_registerName("URL:resourceDidFailLoadingWithReason:");
public static final int sel_defaultBaselineOffsetForFont_1 = sel_registerName("defaultBaselineOffsetForFont:");
public static final int sel_browser_1shouldShowCellExpansionForRow_1column_1 = sel_registerName("browser:shouldShowCellExpansionForRow:column:");
public static final int sel_draggingEnded_1 = sel_registerName("draggingEnded:");
public static final int sel_openURL_1 = sel_registerName("openURL:");
public static final int sel_longLongValue = sel_registerName("longLongValue");
public static final int sel_colorPanel = sel_registerName("colorPanel");
public static final int sel_encodeFloat_1forKey_1 = sel_registerName("encodeFloat:forKey:");
public static final int sel_shouldBreakLineByHyphenatingBeforeCharacterAtIndex_1 = sel_registerName("shouldBreakLineByHyphenatingBeforeCharacterAtIndex:");
public static final int sel_performSelectorInBackground_1withObject_1 = sel_registerName("performSelectorInBackground:withObject:");
public static final int sel_initTextCell_1 = sel_registerName("initTextCell:");
public static final int sel_classDescription = sel_registerName("classDescription");
public static final int sel_menuFontOfSize_1 = sel_registerName("menuFontOfSize:");
public static final int sel_window_1willPositionSheet_1usingRect_1 = sel_registerName("window:willPositionSheet:usingRect:");
public static final int sel_allowsTypeSelect = sel_registerName("allowsTypeSelect");
public static final int sel_attributeWithName_1URI_1stringValue_1 = sel_registerName("attributeWithName:URI:stringValue:");
public static final int sel_setLinkTextAttributes_1 = sel_registerName("setLinkTextAttributes:");
public static final int sel_stringWithFormat_1 = sel_registerName("stringWithFormat:");
public static final int sel_initWithTable_1startingRow_1rowSpan_1startingColumn_1columnSpan_1 = sel_registerName("initWithTable:startingRow:rowSpan:startingColumn:columnSpan:");
public static final int sel_setShouldProcessNamespaces_1 = sel_registerName("setShouldProcessNamespaces:");
public static final int sel_orderFrontRegardless = sel_registerName("orderFrontRegardless");
public static final int sel_setProtocolForProxy_1 = sel_registerName("setProtocolForProxy:");
public static final int sel_bundlePath = sel_registerName("bundlePath");
public static final int sel_isAutoscroll = sel_registerName("isAutoscroll");
public static final int sel_addConnection_1toRunLoop_1forMode_1 = sel_registerName("addConnection:toRunLoop:forMode:");
public static final int sel_moveWordBackwardAndModifySelection_1 = sel_registerName("moveWordBackwardAndModifySelection:");
public static final int sel_textContainerChangedGeometry_1 = sel_registerName("textContainerChangedGeometry:");
public static final int sel_conversation = sel_registerName("conversation");
public static final int sel_showWindow_1 = sel_registerName("showWindow:");
public static final int sel_showGuessPanel_1 = sel_registerName("showGuessPanel:");
public static final int sel_setBorderWidth_1 = sel_registerName("setBorderWidth:");
public static final int sel_buttons = sel_registerName("buttons");
public static final int sel_bitmapRepresentation = sel_registerName("bitmapRepresentation");
public static final int sel_nextObject = sel_registerName("nextObject");
public static final int sel_predicate = sel_registerName("predicate");
public static final int sel_verticalPagination = sel_registerName("verticalPagination");
public static final int sel_readInBackgroundAndNotify = sel_registerName("readInBackgroundAndNotify");
public static final int sel_pixelBufferMipMapLevel = sel_registerName("pixelBufferMipMapLevel");
public static final int sel_getValue_1 = sel_registerName("getValue:");
public static final int sel_eventID = sel_registerName("eventID");
public static final int sel_sortDescriptors = sel_registerName("sortDescriptors");
public static final int sel_removeObjectAtArrangedObjectIndexPath_1 = sel_registerName("removeObjectAtArrangedObjectIndexPath:");
public static final int sel_decodeBytesWithReturnedLength_1 = sel_registerName("decodeBytesWithReturnedLength:");
public static final int sel_textView_1shouldChangeTextInRange_1replacementString_1 = sel_registerName("textView:shouldChangeTextInRange:replacementString:");
public static final int sel_removeCursorRect_1cursor_1 = sel_registerName("removeCursorRect:cursor:");
public static final int sel_hasPassword = sel_registerName("hasPassword");
public static final int sel_updateWindows = sel_registerName("updateWindows");
public static final int sel_pasteboardWithName_1 = sel_registerName("pasteboardWithName:");
public static final int sel_writeSelectionToPasteboard_1types_1 = sel_registerName("writeSelectionToPasteboard:types:");
public static final int sel_setFlipped_1 = sel_registerName("setFlipped:");
public static final int sel_glyphWithName_1 = sel_registerName("glyphWithName:");
public static final int sel_launchApplication_1showIcon_1autolaunch_1 = sel_registerName("launchApplication:showIcon:autolaunch:");
public static final int sel_indexPath = sel_registerName("indexPath");
public static final int sel_setAttributeDescriptor_1forKeyword_1 = sel_registerName("setAttributeDescriptor:forKeyword:");
public static final int sel_removeAllActions = sel_registerName("removeAllActions");
public static final int sel_defaultAttachmentScaling = sel_registerName("defaultAttachmentScaling");
public static final int sel_localizedStringWithFormat_1 = sel_registerName("localizedStringWithFormat:");
public static final int sel_setAutoscroll_1 = sel_registerName("setAutoscroll:");
public static final int sel_heightAdjustLimit = sel_registerName("heightAdjustLimit");
public static final int sel_moveUpAndModifySelection_1 = sel_registerName("moveUpAndModifySelection:");
public static final int sel_visibilityPriority = sel_registerName("visibilityPriority");
public static final int sel_textView_1clickedOnCell_1inRect_1atIndex_1 = sel_registerName("textView:clickedOnCell:inRect:atIndex:");
public static final int sel_archivedDataWithRootObject_1 = sel_registerName("archivedDataWithRootObject:");
public static final int sel_parser_1foundCDATA_1 = sel_registerName("parser:foundCDATA:");
public static final int sel_setWidth_1ofColumn_1 = sel_registerName("setWidth:ofColumn:");
public static final int sel_setHighlightedTableColumn_1 = sel_registerName("setHighlightedTableColumn:");
public static final int sel_toggle_1 = sel_registerName("toggle:");
public static final int sel_parent = sel_registerName("parent");
public static final int sel_tableView_1shouldSelectRow_1 = sel_registerName("tableView:shouldSelectRow:");
public static final int sel_setWithObject_1 = sel_registerName("setWithObject:");
public static final int sel_attribute_1atIndex_1effectiveRange_1 = sel_registerName("attribute:atIndex:effectiveRange:");
public static final int sel_columnsInRect_1 = sel_registerName("columnsInRect:");
public static final int sel_setSearchScopes_1 = sel_registerName("setSearchScopes:");
public static final int sel_setByAddingObjectsFromArray_1 = sel_registerName("setByAddingObjectsFromArray:");
public static final int sel_textViewDidChangeTypingAttributes_1 = sel_registerName("textViewDidChangeTypingAttributes:");
public static final int sel_frameRate = sel_registerName("frameRate");
public static final int sel_browser_1writeRowsWithIndexes_1inColumn_1toPasteboard_1 = sel_registerName("browser:writeRowsWithIndexes:inColumn:toPasteboard:");
public static final int sel_errorWithDomain_1code_1userInfo_1 = sel_registerName("errorWithDomain:code:userInfo:");
public static final int sel_setAlternate_1 = sel_registerName("setAlternate:");
public static final int sel_currentValue = sel_registerName("currentValue");
public static final int sel_download_1decideDestinationWithSuggestedFilename_1 = sel_registerName("download:decideDestinationWithSuggestedFilename:");
public static final int sel_setBoxType_1 = sel_registerName("setBoxType:");
public static final int sel_fileNamesFromRunningOpenPanel = sel_registerName("fileNamesFromRunningOpenPanel");
public static final int sel_valueWithPointer_1 = sel_registerName("valueWithPointer:");
public static final int sel_metadataQuery_1replacementObjectForResultObject_1 = sel_registerName("metadataQuery:replacementObjectForResultObject:");
public static final int sel_editedColumn = sel_registerName("editedColumn");
public static final int sel_cachedResponseForRequest_1 = sel_registerName("cachedResponseForRequest:");
public static final int sel_failureReason = sel_registerName("failureReason");
public static final int sel_constantValue = sel_registerName("constantValue");
public static final int sel_commandClassName = sel_registerName("commandClassName");
public static final int sel_fileWrapper = sel_registerName("fileWrapper");
public static final int sel_setUsesUserKeyEquivalents_1 = sel_registerName("setUsesUserKeyEquivalents:");
public static final int sel_prototype = sel_registerName("prototype");
public static final int sel_clearStartAnimation = sel_registerName("clearStartAnimation");
public static final int sel_setMovableByWindowBackground_1 = sel_registerName("setMovableByWindowBackground:");
public static final int sel_setDateFormat_1 = sel_registerName("setDateFormat:");
public static final int sel_stringWithContentsOfFile_1usedEncoding_1error_1 = sel_registerName("stringWithContentsOfFile:usedEncoding:error:");
public static final int sel_toggleAutomaticLinkDetection_1 = sel_registerName("toggleAutomaticLinkDetection:");
public static final int sel_statusForTable_1 = sel_registerName("statusForTable:");
public static final int sel_setAllowsColumnSelection_1 = sel_registerName("setAllowsColumnSelection:");
public static final int sel_lowercaseWord_1 = sel_registerName("lowercaseWord:");
public static final int sel_setResolvesAliases_1 = sel_registerName("setResolvesAliases:");
public static final int sel_appendFormat_1 = sel_registerName("appendFormat:");
public static final int sel_isAnimating = sel_registerName("isAnimating");
public static final int sel_dateFormat = sel_registerName("dateFormat");
public static final int sel_setMuted_1 = sel_registerName("setMuted:");
public static final int sel_drawWithExpansionFrame_1inView_1 = sel_registerName("drawWithExpansionFrame:inView:");
public static final int sel_copyPath_1toPath_1handler_1 = sel_registerName("copyPath:toPath:handler:");
public static final int sel_isExplicitlyIncluded = sel_registerName("isExplicitlyIncluded");
public static final int sel_isExtensionHidden = sel_registerName("isExtensionHidden");
public static final int sel_showPackedGlyphs_1length_1glyphRange_1atPoint_1font_1color_1printingAdjustment_1 = sel_registerName("showPackedGlyphs:length:glyphRange:atPoint:font:color:printingAdjustment:");
public static final int sel_rulerView_1didRemoveMarker_1 = sel_registerName("rulerView:didRemoveMarker:");
public static final int sel_setControlTint_1 = sel_registerName("setControlTint:");
public static final int sel_isSelectable = sel_registerName("isSelectable");
public static final int sel_initWithMachPort_1 = sel_registerName("initWithMachPort:");
public static final int sel_fill = sel_registerName("fill");
public static final int sel_isEnteringProximity = sel_registerName("isEnteringProximity");
public static final int sel_drawingRectForBounds_1 = sel_registerName("drawingRectForBounds:");
public static final int sel_decodeInt32ForKey_1 = sel_registerName("decodeInt32ForKey:");
public static final int sel_deltaY = sel_registerName("deltaY");
public static final int sel_displaysLinkToolTips = sel_registerName("displaysLinkToolTips");
public static final int sel_moveToEndOfDocument_1 = sel_registerName("moveToEndOfDocument:");
public static final int sel_isFirstResponder = sel_registerName("isFirstResponder");
public static final int sel_receiversSpecifier = sel_registerName("receiversSpecifier");
public static final int sel_canInitWithURL_1 = sel_registerName("canInitWithURL:");
public static final int sel_parameterString = sel_registerName("parameterString");
public static final int sel_isMovable = sel_registerName("isMovable");
public static final int sel_setAvoidsEmptySelection_1 = sel_registerName("setAvoidsEmptySelection:");
public static final int sel_lockFocusIfCanDrawInContext_1 = sel_registerName("lockFocusIfCanDrawInContext:");
public static final int sel_updateChangeCount_1 = sel_registerName("updateChangeCount:");
public static final int sel_rootDocument = sel_registerName("rootDocument");
public static final int sel_superview = sel_registerName("superview");
public static final int sel_resolveNamespaceForName_1 = sel_registerName("resolveNamespaceForName:");
public static final int sel_maxNumberOfColumns = sel_registerName("maxNumberOfColumns");
public static final int sel_setMaxSize_1 = sel_registerName("setMaxSize:");
public static final int sel_completePathIntoString_1caseSensitive_1matchesIntoArray_1filterTypes_1 = sel_registerName("completePathIntoString:caseSensitive:matchesIntoArray:filterTypes:");
public static final int sel_updateCell_1 = sel_registerName("updateCell:");
public static final int sel_setWeek_1 = sel_registerName("setWeek:");
public static final int sel_titleRectForBounds_1 = sel_registerName("titleRectForBounds:");
public static final int sel_rulerView_1willAddMarker_1atLocation_1 = sel_registerName("rulerView:willAddMarker:atLocation:");
public static final int sel_message = sel_registerName("message");
public static final int sel_setContentSize_1 = sel_registerName("setContentSize:");
public static final int sel_broadcast = sel_registerName("broadcast");
public static final int sel_isNativeType_1 = sel_registerName("isNativeType:");
public static final int sel_contentBorderThicknessForEdge_1 = sel_registerName("contentBorderThicknessForEdge:");
public static final int sel_keyEquivalentOffset = sel_registerName("keyEquivalentOffset");
public static final int sel_makeUntitledDocumentOfType_1 = sel_registerName("makeUntitledDocumentOfType:");
public static final int sel_windowFrameTextColor = sel_registerName("windowFrameTextColor");
public static final int sel_addItemsWithTitles_1 = sel_registerName("addItemsWithTitles:");
public static final int sel_levelForRow_1 = sel_registerName("levelForRow:");
public static final int sel_dissolveToPoint_1fromRect_1fraction_1 = sel_registerName("dissolveToPoint:fromRect:fraction:");
public static final int sel_discardCachedImage = sel_registerName("discardCachedImage");
public static final int sel_rootProxyForConnectionWithRegisteredName_1host_1usingNameServer_1 = sel_registerName("rootProxyForConnectionWithRegisteredName:host:usingNameServer:");
public static final int sel_mouseExited_1 = sel_registerName("mouseExited:");
public static final int sel_stringWithCString_1 = sel_registerName("stringWithCString:");
public static final int sel_standardUserDefaults = sel_registerName("standardUserDefaults");
public static final int sel_archiver_1didEncodeObject_1 = sel_registerName("archiver:didEncodeObject:");
public static final int sel_canDraw = sel_registerName("canDraw");
public static final int sel_shouldDelayWindowOrderingForEvent_1 = sel_registerName("shouldDelayWindowOrderingForEvent:");
public static final int sel_selectedMenuItemTextColor = sel_registerName("selectedMenuItemTextColor");
public static final int sel_attachSubmenuForItemAtIndex_1 = sel_registerName("attachSubmenuForItemAtIndex:");
public static final int sel_condition = sel_registerName("condition");
public static final int sel_setReservedThicknessForAccessoryView_1 = sel_registerName("setReservedThicknessForAccessoryView:");
public static final int sel_replaceObjectsInRange_1withObjectsFromArray_1 = sel_registerName("replaceObjectsInRange:withObjectsFromArray:");
public static final int sel_placeholderString = sel_registerName("placeholderString");
public static final int sel_setPMSymbol_1 = sel_registerName("setPMSymbol:");
public static final int sel_localizedNameOfStringEncoding_1 = sel_registerName("localizedNameOfStringEncoding:");
public static final int sel_outlineViewItemWillCollapse_1 = sel_registerName("outlineViewItemWillCollapse:");
public static final int sel_localizedKey = sel_registerName("localizedKey");
public static final int sel_whiteColor = sel_registerName("whiteColor");
public static final int sel_viewBoundsChanged_1 = sel_registerName("viewBoundsChanged:");
public static final int sel_vendorDefined = sel_registerName("vendorDefined");
public static final int sel_classNameDecodedForArchiveClassName_1 = sel_registerName("classNameDecodedForArchiveClassName:");
public static final int sel_lockDate = sel_registerName("lockDate");
public static final int sel_twoDigitStartDate = sel_registerName("twoDigitStartDate");
public static final int sel_rectOfRow_1 = sel_registerName("rectOfRow:");
public static final int sel_receivePort = sel_registerName("receivePort");
public static final int sel_decimalNumberByMultiplyingByPowerOf10_1withBehavior_1 = sel_registerName("decimalNumberByMultiplyingByPowerOf10:withBehavior:");
public static final int sel_isAnyApplicationSpeaking = sel_registerName("isAnyApplicationSpeaking");
public static final int sel_aeDesc = sel_registerName("aeDesc");
public static final int sel_windowWillBeginSheet_1 = sel_registerName("windowWillBeginSheet:");
public static final int sel_accessibilityFocusedUIElement = sel_registerName("accessibilityFocusedUIElement");
public static final int sel_orderBack_1 = sel_registerName("orderBack:");
public static final int sel_scanDecimal_1 = sel_registerName("scanDecimal:");
public static final int sel_transformStruct = sel_registerName("transformStruct");
public static final int sel_fileAttributesToWriteToFile_1ofType_1saveOperation_1 = sel_registerName("fileAttributesToWriteToFile:ofType:saveOperation:");
public static final int sel_controlCharacterSet = sel_registerName("controlCharacterSet");
public static final int sel_setNextResponder_1 = sel_registerName("setNextResponder:");
public static final int sel_pasteboardChangedOwner_1 = sel_registerName("pasteboardChangedOwner:");
public static final int sel_canSelectHiddenExtension = sel_registerName("canSelectHiddenExtension");
public static final int sel_attribute_1atIndex_1longestEffectiveRange_1inRange_1 = sel_registerName("attribute:atIndex:longestEffectiveRange:inRange:");
public static final int sel_setAutovalidates_1 = sel_registerName("setAutovalidates:");
public static final int sel_setAllowsFloats_1 = sel_registerName("setAllowsFloats:");
public static final int sel_sortDescriptorPrototype = sel_registerName("sortDescriptorPrototype");
public static final int sel_trackKnob_1 = sel_registerName("trackKnob:");
public static final int sel_comboBox_1indexOfItemWithStringValue_1 = sel_registerName("comboBox:indexOfItemWithStringValue:");
public static final int sel_setSource_1 = sel_registerName("setSource:");
public static final int sel_contentFilters = sel_registerName("contentFilters");
public static final int sel_dictionaryWithContentsOfFile_1 = sel_registerName("dictionaryWithContentsOfFile:");
public static final int sel_drawArrow_1highlight_1 = sel_registerName("drawArrow:highlight:");
public static final int sel_handleSaveScriptCommand_1 = sel_registerName("handleSaveScriptCommand:");
public static final int sel_rangeOfString_1options_1 = sel_registerName("rangeOfString:options:");
public static final int sel_setPickerMode_1 = sel_registerName("setPickerMode:");
public static final int sel_setStandaloneQuarterSymbols_1 = sel_registerName("setStandaloneQuarterSymbols:");
public static final int sel_setSize_1 = sel_registerName("setSize:");
public static final int sel_setAllowsUndo_1 = sel_registerName("setAllowsUndo:");
public static final int sel_edge = sel_registerName("edge");
public static final int sel_stopLoading = sel_registerName("stopLoading");
public static final int sel_fileURLWithPath_1isDirectory_1 = sel_registerName("fileURLWithPath:isDirectory:");
public static final int sel_userInfo = sel_registerName("userInfo");
public static final int sel_components_1fromDate_1 = sel_registerName("components:fromDate:");
public static final int sel_dictionary = sel_registerName("dictionary");
public static final int sel_connection_1didCancelAuthenticationChallenge_1 = sel_registerName("connection:didCancelAuthenticationChallenge:");
public static final int sel_selectParagraph_1 = sel_registerName("selectParagraph:");
public static final int sel_initWithCapacity_1 = sel_registerName("initWithCapacity:");
public static final int sel_initWithObjectSpecifier_1comparisonOperator_1testObject_1 = sel_registerName("initWithObjectSpecifier:comparisonOperator:testObject:");
public static final int sel_nestingMode = sel_registerName("nestingMode");
public static final int sel_paragraphSpacingBefore = sel_registerName("paragraphSpacingBefore");
public static final int sel_itemChanged_1 = sel_registerName("itemChanged:");
public static final int sel_setSelectionIndexes_1 = sel_registerName("setSelectionIndexes:");
public static final int sel_open = sel_registerName("open");
public static final int sel_sendActionOn_1 = sel_registerName("sendActionOn:");
public static final int sel_initWithFireDate_1interval_1target_1selector_1userInfo_1repeats_1 = sel_registerName("initWithFireDate:interval:target:selector:userInfo:repeats:");
public static final int sel_formatterBehavior = sel_registerName("formatterBehavior");
public static final int sel_fillRect_1 = sel_registerName("fillRect:");
public static final int sel_animationCurve = sel_registerName("animationCurve");
public static final int sel_remoteObjects = sel_registerName("remoteObjects");
public static final int sel_setSelectionIndexPath_1 = sel_registerName("setSelectionIndexPath:");
public static final int sel_availableFontNamesWithTraits_1 = sel_registerName("availableFontNamesWithTraits:");
public static final int sel_convertFont_1toFamily_1 = sel_registerName("convertFont:toFamily:");
public static final int sel_splitView_1resizeSubviewsWithOldSize_1 = sel_registerName("splitView:resizeSubviewsWithOldSize:");
public static final int sel_setSmartInsertDeleteEnabled_1 = sel_registerName("setSmartInsertDeleteEnabled:");
public static final int sel_shouldChangePrintInfo_1 = sel_registerName("shouldChangePrintInfo:");
public static final int sel_objectBeingTested = sel_registerName("objectBeingTested");
public static final int sel_selectItemWithObjectValue_1 = sel_registerName("selectItemWithObjectValue:");
public static final int sel_rightExpressions = sel_registerName("rightExpressions");
public static final int sel_unableToSetNilForKey_1 = sel_registerName("unableToSetNilForKey:");
public static final int sel_visibleItems = sel_registerName("visibleItems");
public static final int sel_items = sel_registerName("items");
public static final int sel_templatesWithAttributeKeyPaths_1inEntityDescription_1 = sel_registerName("templatesWithAttributeKeyPaths:inEntityDescription:");
public static final int sel_setMaximumIntegerDigits_1 = sel_registerName("setMaximumIntegerDigits:");
public static final int sel_scrollRectToVisible_1 = sel_registerName("scrollRectToVisible:");
public static final int sel_disableKeyEquivalentForDefaultButtonCell = sel_registerName("disableKeyEquivalentForDefaultButtonCell");
public static final int sel_objectsForXQuery_1error_1 = sel_registerName("objectsForXQuery:error:");
public static final int sel_readToEndOfFileInBackgroundAndNotifyForModes_1 = sel_registerName("readToEndOfFileInBackgroundAndNotifyForModes:");
public static final int sel_scanHexLongLong_1 = sel_registerName("scanHexLongLong:");
public static final int sel_ascender = sel_registerName("ascender");
public static final int sel_arrangeObjects_1 = sel_registerName("arrangeObjects:");
public static final int sel_setNegativeSuffix_1 = sel_registerName("setNegativeSuffix:");
public static final int sel_initWithString_1 = sel_registerName("initWithString:");
public static final int sel_initWithName_1data_1 = sel_registerName("initWithName:data:");
public static final int sel_data = sel_registerName("data");
public static final int sel_encodePortObject_1 = sel_registerName("encodePortObject:");
public static final int sel_becomeFirstResponder = sel_registerName("becomeFirstResponder");
public static final int sel_setImage_1forSegment_1 = sel_registerName("setImage:forSegment:");
public static final int sel_copyRuler_1 = sel_registerName("copyRuler:");
public static final int sel_appendBezierPathWithGlyphs_1count_1inFont_1 = sel_registerName("appendBezierPathWithGlyphs:count:inFont:");
public static final int sel_playsSelectionOnly = sel_registerName("playsSelectionOnly");
public static final int sel_boundsRectForTextBlock_1glyphRange_1 = sel_registerName("boundsRectForTextBlock:glyphRange:");
public static final int sel_makeObjectsPerformSelector_1withObject_1 = sel_registerName("makeObjectsPerformSelector:withObject:");
public static final int sel_stringByTrimmingCharactersInSet_1 = sel_registerName("stringByTrimmingCharactersInSet:");
public static final int sel_timerWithTimeInterval_1invocation_1repeats_1 = sel_registerName("timerWithTimeInterval:invocation:repeats:");
public static final int sel_viewDidMoveToSuperview = sel_registerName("viewDidMoveToSuperview");
public static final int sel_pathCell_1willDisplayOpenPanel_1 = sel_registerName("pathCell:willDisplayOpenPanel:");
public static final int sel_pathSeparator = sel_registerName("pathSeparator");
public static final int sel_generatesCalendarDates = sel_registerName("generatesCalendarDates");
public static final int sel_pressure = sel_registerName("pressure");
public static final int sel_sendPort = sel_registerName("sendPort");
public static final int sel_argumentsRetained = sel_registerName("argumentsRetained");
public static final int sel_setContainerSpecifier_1 = sel_registerName("setContainerSpecifier:");
public static final int sel_decodeNXColor = sel_registerName("decodeNXColor");
public static final int sel_orientation = sel_registerName("orientation");
public static final int sel_setScriptErrorString_1 = sel_registerName("setScriptErrorString:");
public static final int sel_makeDocumentWithContentsOfFile_1ofType_1 = sel_registerName("makeDocumentWithContentsOfFile:ofType:");
public static final int sel_reason = sel_registerName("reason");
public static final int sel_currentEvent = sel_registerName("currentEvent");
public static final int sel_setOffScreen_1width_1height_1rowbytes_1 = sel_registerName("setOffScreen:width:height:rowbytes:");
public static final int sel_invalidateAttributesInRange_1 = sel_registerName("invalidateAttributesInRange:");
public static final int sel_descriptorWithDescriptorType_1bytes_1length_1 = sel_registerName("descriptorWithDescriptorType:bytes:length:");
public static final int sel_setCredential_1forProtectionSpace_1 = sel_registerName("setCredential:forProtectionSpace:");
public static final int sel_fileGroupOwnerAccountName = sel_registerName("fileGroupOwnerAccountName");
public static final int sel_setColor_1forKey_1 = sel_registerName("setColor:forKey:");
public static final int sel_setAutohidesScrollers_1 = sel_registerName("setAutohidesScrollers:");
public static final int sel_noteNumberOfRowsChanged = sel_registerName("noteNumberOfRowsChanged");
public static final int sel_disableCursorRects = sel_registerName("disableCursorRects");
public static final int sel_setLenient_1 = sel_registerName("setLenient:");
public static final int sel_registerUnitWithName_1abbreviation_1unitToPointsConversionFactor_1stepUpCycle_1stepDownCycle_1 = sel_registerName("registerUnitWithName:abbreviation:unitToPointsConversionFactor:stepUpCycle:stepDownCycle:");
public static final int sel_standardWindowButton_1 = sel_registerName("standardWindowButton:");
public static final int sel_objectForProperty_1error_1 = sel_registerName("objectForProperty:error:");
public static final int sel_imageRepWithData_1 = sel_registerName("imageRepWithData:");
public static final int sel_flushGraphics = sel_registerName("flushGraphics");
public static final int sel_setCacheDepthMatchesImageDepth_1 = sel_registerName("setCacheDepthMatchesImageDepth:");
public static final int sel_highlightColorInView_1 = sel_registerName("highlightColorInView:");
public static final int sel_setBaseSpecifier_1 = sel_registerName("setBaseSpecifier:");
public static final int sel_performFileOperation_1source_1destination_1files_1tag_1 = sel_registerName("performFileOperation:source:destination:files:tag:");
public static final int sel_outlineView_1itemForPersistentObject_1 = sel_registerName("outlineView:itemForPersistentObject:");
public static final int sel_propertyListFromData_1mutabilityOption_1format_1errorDescription_1 = sel_registerName("propertyListFromData:mutabilityOption:format:errorDescription:");
public static final int sel_setDocumentView_1 = sel_registerName("setDocumentView:");
public static final int sel_drawsOutsideLineFragmentForGlyphAtIndex_1 = sel_registerName("drawsOutsideLineFragmentForGlyphAtIndex:");
public static final int sel_dragImageForSelectionWithEvent_1origin_1 = sel_registerName("dragImageForSelectionWithEvent:origin:");
public static final int sel_buttonNumber = sel_registerName("buttonNumber");
public static final int sel_advancementForGlyph_1 = sel_registerName("advancementForGlyph:");
public static final int sel_parser_1validationErrorOccurred_1 = sel_registerName("parser:validationErrorOccurred:");
public static final int sel_reusesColumns = sel_registerName("reusesColumns");
public static final int sel_minute = sel_registerName("minute");
public static final int sel_setCanChooseFiles_1 = sel_registerName("setCanChooseFiles:");
public static final int sel_groupingSize = sel_registerName("groupingSize");
public static final int sel_containsAttachments = sel_registerName("containsAttachments");
public static final int sel_selectedControlTextColor = sel_registerName("selectedControlTextColor");
public static final int sel_initWithMantissa_1exponent_1isNegative_1 = sel_registerName("initWithMantissa:exponent:isNegative:");
public static final int sel_initWithVoice_1 = sel_registerName("initWithVoice:");
public static final int sel_setResizingMask_1 = sel_registerName("setResizingMask:");
public static final int sel_setOnMouseExited_1 = sel_registerName("setOnMouseExited:");
public static final int sel_toggleContinuousSpellChecking_1 = sel_registerName("toggleContinuousSpellChecking:");
public static final int sel_allowsCutCopyPaste = sel_registerName("allowsCutCopyPaste");
public static final int sel_endSheet_1 = sel_registerName("endSheet:");
public static final int sel_allowsBranchSelection = sel_registerName("allowsBranchSelection");
public static final int sel_initWithRequest_1delegate_1 = sel_registerName("initWithRequest:delegate:");
public static final int sel_isAtEnd = sel_registerName("isAtEnd");
public static final int sel_relativeString = sel_registerName("relativeString");
public static final int sel_tableView_1willDisplayCell_1forTableColumn_1row_1 = sel_registerName("tableView:willDisplayCell:forTableColumn:row:");
public static final int sel_resizeSubviewsWithOldSize_1 = sel_registerName("resizeSubviewsWithOldSize:");
public static final int sel_compoundPredicateType = sel_registerName("compoundPredicateType");
public static final int sel_accessoryControllers = sel_registerName("accessoryControllers");
public static final int sel_shouldDrawColor = sel_registerName("shouldDrawColor");
public static final int sel_applicationShouldTerminate_1 = sel_registerName("applicationShouldTerminate:");
public static final int sel_setTextContainer_1 = sel_registerName("setTextContainer:");
public static final int sel_discardCursorRects = sel_registerName("discardCursorRects");
public static final int sel_deviceCMYKColorSpace = sel_registerName("deviceCMYKColorSpace");
public static final int sel_setDefaultPlaceholder_1forMarker_1withBinding_1 = sel_registerName("setDefaultPlaceholder:forMarker:withBinding:");
public static final int sel_setIsZoomed_1 = sel_registerName("setIsZoomed:");
public static final int sel_blueComponent = sel_registerName("blueComponent");
public static final int sel_portWithMachPort_1options_1 = sel_registerName("portWithMachPort:options:");
public static final int sel_restoreGraphicsState = sel_registerName("restoreGraphicsState");
public static final int sel_isTemplate = sel_registerName("isTemplate");
public static final int sel_setScanLocation_1 = sel_registerName("setScanLocation:");
public static final int sel_initWithBool_1 = sel_registerName("initWithBool:");
public static final int sel_initWithSet_1copyItems_1 = sel_registerName("initWithSet:copyItems:");
public static final int sel_setPositivePrefix_1 = sel_registerName("setPositivePrefix:");
public static final int sel_propertyForKeyIfAvailable_1 = sel_registerName("propertyForKeyIfAvailable:");
public static final int sel_fileOwnerAccountID = sel_registerName("fileOwnerAccountID");
public static final int sel_initForIncrementalLoad = sel_registerName("initForIncrementalLoad");
public static final int sel_cellAttribute_1 = sel_registerName("cellAttribute:");
public static final int sel_baselineLocation = sel_registerName("baselineLocation");
public static final int sel_initWithAttributedString_1 = sel_registerName("initWithAttributedString:");
public static final int sel_showWindows = sel_registerName("showWindows");
public static final int sel_writeToFile_1atomically_1updateFilenames_1 = sel_registerName("writeToFile:atomically:updateFilenames:");
public static final int sel_setCookies_1forURL_1mainDocumentURL_1 = sel_registerName("setCookies:forURL:mainDocumentURL:");
public static final int sel_unarchiver_1cannotDecodeObjectOfClassName_1originalClasses_1 = sel_registerName("unarchiver:cannotDecodeObjectOfClassName:originalClasses:");
public static final int sel_selectRow_1inColumn_1 = sel_registerName("selectRow:inColumn:");
public static final int sel_dissolveToPoint_1fraction_1 = sel_registerName("dissolveToPoint:fraction:");
public static final int sel_wantsToTrackMouseForEvent_1inRect_1ofView_1atCharacterIndex_1 = sel_registerName("wantsToTrackMouseForEvent:inRect:ofView:atCharacterIndex:");
public static final int sel_openURLs_1withAppBundleIdentifier_1options_1additionalEventParamDescriptor_1launchIdentifiers_1 = sel_registerName("openURLs:withAppBundleIdentifier:options:additionalEventParamDescriptor:launchIdentifiers:");
public static final int sel_checkForRemovableMedia = sel_registerName("checkForRemovableMedia");
public static final int sel_setImage_1 = sel_registerName("setImage:");
public static final int sel_isFixedPitch = sel_registerName("isFixedPitch");
public static final int sel_protocolFamily = sel_registerName("protocolFamily");
public static final int sel_protocolCheckerWithTarget_1protocol_1 = sel_registerName("protocolCheckerWithTarget:protocol:");
public static final int sel_streamError = sel_registerName("streamError");
public static final int sel_replaceBytesInRange_1withBytes_1length_1 = sel_registerName("replaceBytesInRange:withBytes:length:");
public static final int sel_canChooseDirectories = sel_registerName("canChooseDirectories");
public static final int sel_classForPortCoder = sel_registerName("classForPortCoder");
public static final int sel_mainRunLoop = sel_registerName("mainRunLoop");
public static final int sel_setItemPrototype_1 = sel_registerName("setItemPrototype:");
public static final int sel_controlShadowColor = sel_registerName("controlShadowColor");
public static final int sel_level = sel_registerName("level");
public static final int sel_setContextHelpModeActive_1 = sel_registerName("setContextHelpModeActive:");
public static final int sel_levelForItem_1 = sel_registerName("levelForItem:");
public static final int sel_setHeightTracksTextView_1 = sel_registerName("setHeightTracksTextView:");
public static final int sel_applicationWillTerminate_1 = sel_registerName("applicationWillTerminate:");
public static final int sel_wantsPeriodicDraggingUpdates = sel_registerName("wantsPeriodicDraggingUpdates");
public static final int sel_createCommandInstance = sel_registerName("createCommandInstance");
public static final int sel_parser_1foundElementDeclarationWithName_1model_1 = sel_registerName("parser:foundElementDeclarationWithName:model:");
public static final int sel_window_1shouldPopUpDocumentPathMenu_1 = sel_registerName("window:shouldPopUpDocumentPathMenu:");
public static final int sel_setRepresentedURL_1 = sel_registerName("setRepresentedURL:");
public static final int sel_outlineView_1didDragTableColumn_1 = sel_registerName("outlineView:didDragTableColumn:");
public static final int sel_appendTransform_1 = sel_registerName("appendTransform:");
public static final int sel_setMIMEType_1 = sel_registerName("setMIMEType:");
public static final int sel_setHeadIndent_1 = sel_registerName("setHeadIndent:");
public static final int sel_setConstrainedFrameSize_1 = sel_registerName("setConstrainedFrameSize:");
public static final int sel_setUsesDataSource_1 = sel_registerName("setUsesDataSource:");
public static final int sel_replaceBytesInRange_1withBytes_1 = sel_registerName("replaceBytesInRange:withBytes:");
public static final int sel_rowTypeKeyPath = sel_registerName("rowTypeKeyPath");
public static final int sel_undoManager = sel_registerName("undoManager");
public static final int sel_frameCenterRotation = sel_registerName("frameCenterRotation");
public static final int sel_setTextView_1 = sel_registerName("setTextView:");
public static final int sel_executeAppleEvent_1error_1 = sel_registerName("executeAppleEvent:error:");
public static final int sel_setFormatter_1 = sel_registerName("setFormatter:");
public static final int sel_scanLocation = sel_registerName("scanLocation");
public static final int sel_scrollsDynamically = sel_registerName("scrollsDynamically");
public static final int sel_setIndentationLevel_1 = sel_registerName("setIndentationLevel:");
public static final int sel_minimumRangeOfUnit_1 = sel_registerName("minimumRangeOfUnit:");
public static final int sel_textViewForBeginningOfSelection = sel_registerName("textViewForBeginningOfSelection");
public static final int sel_tokenFieldCell_1displayStringForRepresentedObject_1 = sel_registerName("tokenFieldCell:displayStringForRepresentedObject:");
public static final int sel_constrainFrameRect_1toScreen_1 = sel_registerName("constrainFrameRect:toScreen:");
public static final int sel_getObjectValue_1forString_1range_1error_1 = sel_registerName("getObjectValue:forString:range:error:");
public static final int sel_writeFileContents_1 = sel_registerName("writeFileContents:");
public static final int sel_setProgressMarks_1 = sel_registerName("setProgressMarks:");
public static final int sel_lastComponentOfFileName = sel_registerName("lastComponentOfFileName");
public static final int sel_preventWindowOrdering = sel_registerName("preventWindowOrdering");
public static final int sel_setDefaultDate_1 = sel_registerName("setDefaultDate:");
public static final int sel_submenu = sel_registerName("submenu");
public static final int sel_setTXTRecordData_1 = sel_registerName("setTXTRecordData:");
public static final int sel_bytesPerRow = sel_registerName("bytesPerRow");
public static final int sel_outlineView_1toolTipForCell_1rect_1tableColumn_1item_1mouseLocation_1 = sel_registerName("outlineView:toolTipForCell:rect:tableColumn:item:mouseLocation:");
public static final int sel_outlineView_1shouldEditTableColumn_1item_1 = sel_registerName("outlineView:shouldEditTableColumn:item:");
public static final int sel_initWithContainerSize_1 = sel_registerName("initWithContainerSize:");
public static final int sel_setEvaluationErrorNumber_1 = sel_registerName("setEvaluationErrorNumber:");
public static final int sel_setTopLevelObject_1 = sel_registerName("setTopLevelObject:");
public static final int sel_dataOfType_1error_1 = sel_registerName("dataOfType:error:");
public static final int sel_isSupersetOfSet_1 = sel_registerName("isSupersetOfSet:");
public static final int sel_initWithURL_1cachePolicy_1timeoutInterval_1 = sel_registerName("initWithURL:cachePolicy:timeoutInterval:");
public static final int sel_setAutosaveExpandedItems_1 = sel_registerName("setAutosaveExpandedItems:");
public static final int sel_rangeValue = sel_registerName("rangeValue");
public static final int sel_indexPathByAddingIndex_1 = sel_registerName("indexPathByAddingIndex:");
public static final int sel_deleteToMark_1 = sel_registerName("deleteToMark:");
public static final int sel_appleEventCodeForSuite_1 = sel_registerName("appleEventCodeForSuite:");
public static final int sel_getBytes_1 = sel_registerName("getBytes:");
public static final int sel_setMinimumDaysInFirstWeek_1 = sel_registerName("setMinimumDaysInFirstWeek:");
public static final int sel_refusesFirstResponder = sel_registerName("refusesFirstResponder");
public static final int sel_setMaxItemSize_1 = sel_registerName("setMaxItemSize:");
public static final int sel_localizedStringForKey_1value_1table_1 = sel_registerName("localizedStringForKey:value:table:");
public static final int sel_mapTableWithKeyOptions_1valueOptions_1 = sel_registerName("mapTableWithKeyOptions:valueOptions:");
public static final int sel_test = sel_registerName("test");
public static final int sel_trackScrollButtons_1 = sel_registerName("trackScrollButtons:");
public static final int sel_PDFRepresentation = sel_registerName("PDFRepresentation");
public static final int sel_setImageFrameStyle_1 = sel_registerName("setImageFrameStyle:");
public static final int sel_encodeClassName_1intoClassName_1 = sel_registerName("encodeClassName:intoClassName:");
public static final int sel_beginPageInRect_1atPlacement_1 = sel_registerName("beginPageInRect:atPlacement:");
public static final int sel_setAllowsOtherFileTypes_1 = sel_registerName("setAllowsOtherFileTypes:");
public static final int sel_isWordInUserDictionaries_1caseSensitive_1 = sel_registerName("isWordInUserDictionaries:caseSensitive:");
public static final int sel_dispatchRawAppleEvent_1withRawReply_1handlerRefCon_1 = sel_registerName("dispatchRawAppleEvent:withRawReply:handlerRefCon:");
public static final int sel_isScrollable = sel_registerName("isScrollable");
public static final int sel_numberOfColorStops = sel_registerName("numberOfColorStops");
public static final int sel_unhideAllApplications_1 = sel_registerName("unhideAllApplications:");
public static final int sel_retainCount = sel_registerName("retainCount");
public static final int sel_runModalPrintOperation_1delegate_1didRunSelector_1contextInfo_1 = sel_registerName("runModalPrintOperation:delegate:didRunSelector:contextInfo:");
public static final int sel_update = sel_registerName("update");
public static final int sel_isRotatedOrScaledFromBase = sel_registerName("isRotatedOrScaledFromBase");
public static final int sel_initWithWindowNibPath_1owner_1 = sel_registerName("initWithWindowNibPath:owner:");
public static final int sel_entryType = sel_registerName("entryType");
public static final int sel_dictionaryFromTXTRecordData_1 = sel_registerName("dictionaryFromTXTRecordData:");
public static final int sel_setLineCapStyle_1 = sel_registerName("setLineCapStyle:");
public static final int sel_setValues_1forParameter_1 = sel_registerName("setValues:forParameter:");
public static final int sel_numberStyle = sel_registerName("numberStyle");
public static final int sel_disableCollectorForPointer_1 = sel_registerName("disableCollectorForPointer:");
public static final int sel_initWithPointerFunctions_1capacity_1 = sel_registerName("initWithPointerFunctions:capacity:");
public static final int sel_sendEvent_1 = sel_registerName("sendEvent:");
public static final int sel_removeSelectedObjects_1 = sel_registerName("removeSelectedObjects:");
public static final int sel_serviceConnectionWithName_1rootObject_1usingNameServer_1 = sel_registerName("serviceConnectionWithName:rootObject:usingNameServer:");
public static final int sel_decimalNumberByMultiplyingBy_1 = sel_registerName("decimalNumberByMultiplyingBy:");
public static final int sel_shouldChangeTextInRanges_1replacementStrings_1 = sel_registerName("shouldChangeTextInRanges:replacementStrings:");
public static final int sel_setResizeIncrements_1 = sel_registerName("setResizeIncrements:");
public static final int sel_alignLeft_1 = sel_registerName("alignLeft:");
public static final int sel_launch = sel_registerName("launch");
public static final int sel_executeCommand = sel_registerName("executeCommand");
public static final int sel_setPixelBuffer_1cubeMapFace_1mipMapLevel_1currentVirtualScreen_1 = sel_registerName("setPixelBuffer:cubeMapFace:mipMapLevel:currentVirtualScreen:");
public static final int sel_isCachedSeparately = sel_registerName("isCachedSeparately");
public static final int sel_setUsesSignificantDigits_1 = sel_registerName("setUsesSignificantDigits:");
public static final int sel_countKeyPathForNode_1 = sel_registerName("countKeyPathForNode:");
public static final int sel_setContainerIsRangeContainerObject_1 = sel_registerName("setContainerIsRangeContainerObject:");
public static final int sel_showsStateColumn = sel_registerName("showsStateColumn");
public static final int sel_uppercaseString = sel_registerName("uppercaseString");
public static final int sel_directoryContentsAtPath_1 = sel_registerName("directoryContentsAtPath:");
public static final int sel_titleFont = sel_registerName("titleFont");
public static final int sel_comparisonPredicateModifier = sel_registerName("comparisonPredicateModifier");
public static final int sel_isMultiThreaded = sel_registerName("isMultiThreaded");
public static final int sel_setGroupingAttributes_1 = sel_registerName("setGroupingAttributes:");
public static final int sel_selectedRowIndexesInColumn_1 = sel_registerName("selectedRowIndexesInColumn:");
public static final int sel_isFlushWindowDisabled = sel_registerName("isFlushWindowDisabled");
public static final int sel_setReusesColumns_1 = sel_registerName("setReusesColumns:");
public static final int sel_getCString_1maxLength_1 = sel_registerName("getCString:maxLength:");
public static final int sel_setIndicatorImage_1inTableColumn_1 = sel_registerName("setIndicatorImage:inTableColumn:");
public static final int sel_keyEquivalent = sel_registerName("keyEquivalent");
public static final int sel_skipDescendents = sel_registerName("skipDescendents");
public static final int sel_waitUntilExit = sel_registerName("waitUntilExit");
public static final int sel_initWithWindowNibName_1owner_1 = sel_registerName("initWithWindowNibName:owner:");
public static final int sel_objectClass = sel_registerName("objectClass");
public static final int sel_allFrameworks = sel_registerName("allFrameworks");
public static final int sel_cellWithTag_1 = sel_registerName("cellWithTag:");
public static final int sel_representationUsingType_1properties_1 = sel_registerName("representationUsingType:properties:");
public static final int sel_textPasteboardTypes = sel_registerName("textPasteboardTypes");
public static final int sel_contentViewMargins = sel_registerName("contentViewMargins");
public static final int sel_canUndo = sel_registerName("canUndo");
public static final int sel_initWithFormat_1locale_1arguments_1 = sel_registerName("initWithFormat:locale:arguments:");
public static final int sel_usableParts = sel_registerName("usableParts");
public static final int sel_comboBoxSelectionIsChanging_1 = sel_registerName("comboBoxSelectionIsChanging:");
public static final int sel_raise_1format_1arguments_1 = sel_registerName("raise:format:arguments:");
public static final int sel_isWindowLoaded = sel_registerName("isWindowLoaded");
public static final int sel_levelIndicatorStyle = sel_registerName("levelIndicatorStyle");
public static final int sel_localizedFailureReason = sel_registerName("localizedFailureReason");
public static final int sel_characterRangeForGlyphRange_1actualGlyphRange_1 = sel_registerName("characterRangeForGlyphRange:actualGlyphRange:");
public static final int sel_lineNumber = sel_registerName("lineNumber");
public static final int sel_HTTPBody = sel_registerName("HTTPBody");
public static final int sel_lineBreakMode = sel_registerName("lineBreakMode");
public static final int sel_isStopped = sel_registerName("isStopped");
public static final int sel_canResumeDownloadDecodedWithEncodingMIMEType_1 = sel_registerName("canResumeDownloadDecodedWithEncodingMIMEType:");
public static final int sel_removeObjectsAtArrangedObjectIndexPaths_1 = sel_registerName("removeObjectsAtArrangedObjectIndexPaths:");
public static final int sel_isHidden = sel_registerName("isHidden");
public static final int sel_otherMouseDragged_1 = sel_registerName("otherMouseDragged:");
public static final int sel_headerRectOfColumn_1 = sel_registerName("headerRectOfColumn:");
public static final int sel_hasVerticalRuler = sel_registerName("hasVerticalRuler");
public static final int sel_setBottomMargin_1 = sel_registerName("setBottomMargin:");
public static final int sel_initWithNotificationCenter_1 = sel_registerName("initWithNotificationCenter:");
public static final int sel_addSpeechDictionary_1 = sel_registerName("addSpeechDictionary:");
public static final int sel_setPositiveFormat_1 = sel_registerName("setPositiveFormat:");
public static final int sel_application_1openTempFile_1 = sel_registerName("application:openTempFile:");
public static final int sel_setEntityName_1 = sel_registerName("setEntityName:");
public static final int sel_setForegroundColor_1 = sel_registerName("setForegroundColor:");
public static final int sel_initWithUnsignedLong_1 = sel_registerName("initWithUnsignedLong:");
public static final int sel_setWindowsMenu_1 = sel_registerName("setWindowsMenu:");
public static final int sel_applicationDidUnhide_1 = sel_registerName("applicationDidUnhide:");
public static final int sel_availableData = sel_registerName("availableData");
public static final int sel_setVertical_1 = sel_registerName("setVertical:");
public static final int sel_disableUpdates = sel_registerName("disableUpdates");
public static final int sel_compileAndReturnError_1 = sel_registerName("compileAndReturnError:");
public static final int sel_containsIndex_1 = sel_registerName("containsIndex:");
public static final int sel_canSelectPrevious = sel_registerName("canSelectPrevious");
public static final int sel_initWithBytes_1length_1encoding_1 = sel_registerName("initWithBytes:length:encoding:");
public static final int sel_setTextColor_1 = sel_registerName("setTextColor:");
public static final int sel_stream_1handleEvent_1 = sel_registerName("stream:handleEvent:");
public static final int sel_setWeekdaySymbols_1 = sel_registerName("setWeekdaySymbols:");
public static final int sel_setHiddenUntilMouseMoves_1 = sel_registerName("setHiddenUntilMouseMoves:");
public static final int sel_orderFrontStandardAboutPanelWithOptions_1 = sel_registerName("orderFrontStandardAboutPanelWithOptions:");
public static final int sel_setAttributesAsDictionary_1 = sel_registerName("setAttributesAsDictionary:");
public static final int sel_rowTypeForRow_1 = sel_registerName("rowTypeForRow:");
public static final int sel_setRequestTimeout_1 = sel_registerName("setRequestTimeout:");
public static final int sel_XMLDataWithOptions_1 = sel_registerName("XMLDataWithOptions:");
public static final int sel_closedHandCursor = sel_registerName("closedHandCursor");
public static final int sel_nextSibling = sel_registerName("nextSibling");
public static final int sel_controlTextColor = sel_registerName("controlTextColor");
public static final int sel_abbreviationDictionary = sel_registerName("abbreviationDictionary");
public static final int sel_archiverDidFinish_1 = sel_registerName("archiverDidFinish:");
public static final int sel_valueTypeForDimension_1 = sel_registerName("valueTypeForDimension:");
public static final int sel_setCriteriaKeyPath_1 = sel_registerName("setCriteriaKeyPath:");
public static final int sel_isLessThan_1 = sel_registerName("isLessThan:");
public static final int sel_processName = sel_registerName("processName");
public static final int sel_frameOfOutlineCellAtRow_1 = sel_registerName("frameOfOutlineCellAtRow:");
public static final int sel_removeObjectsInArray_1 = sel_registerName("removeObjectsInArray:");
public static final int sel_leftExpression = sel_registerName("leftExpression");
public static final int sel_removeToolTip_1 = sel_registerName("removeToolTip:");
public static final int sel_mutableCopy = sel_registerName("mutableCopy");
public static final int sel_directParameter = sel_registerName("directParameter");
public static final int sel_name = sel_registerName("name");
public static final int sel_bitsPerPixel = sel_registerName("bitsPerPixel");
public static final int sel_weekday = sel_registerName("weekday");
public static final int sel_descendantNodeAtIndexPath_1 = sel_registerName("descendantNodeAtIndexPath:");
public static final int sel_setPercentSymbol_1 = sel_registerName("setPercentSymbol:");
public static final int sel_selectedCell = sel_registerName("selectedCell");
public static final int sel_windowWillClose_1 = sel_registerName("windowWillClose:");
public static final int sel_setDatePickerStyle_1 = sel_registerName("setDatePickerStyle:");
public static final int sel_initWithObjects_1 = sel_registerName("initWithObjects:");
public static final int sel_numberWithInt_1 = sel_registerName("numberWithInt:");
public static final int sel_collection = sel_registerName("collection");
public static final int sel_initWithTarget_1selector_1object_1 = sel_registerName("initWithTarget:selector:object:");
public static final int sel_insertText_1replacementRange_1 = sel_registerName("insertText:replacementRange:");
public static final int sel_initWithAEDescNoCopy_1 = sel_registerName("initWithAEDescNoCopy:");
public static final int sel_usesGroupingSeparator = sel_registerName("usesGroupingSeparator");
public static final int sel_pathControl_1shouldDragPathComponentCell_1withPasteboard_1 = sel_registerName("pathControl:shouldDragPathComponentCell:withPasteboard:");
public static final int sel_decimalNumberByAdding_1withBehavior_1 = sel_registerName("decimalNumberByAdding:withBehavior:");
public static final int sel_setTextContainer_1forGlyphRange_1 = sel_registerName("setTextContainer:forGlyphRange:");
public static final int sel_needsToDrawRect_1 = sel_registerName("needsToDrawRect:");
public static final int sel_activeConversationChanged_1toNewConversation_1 = sel_registerName("activeConversationChanged:toNewConversation:");
public static final int sel_italicAngle = sel_registerName("italicAngle");
public static final int sel_aeteResource_1 = sel_registerName("aeteResource:");
public static final int sel_noteNewRecentDocumentURL_1 = sel_registerName("noteNewRecentDocumentURL:");
public static final int sel_setPageScroll_1 = sel_registerName("setPageScroll:");
public static final int sel_speechSynthesizer_1didFinishSpeaking_1 = sel_registerName("speechSynthesizer:didFinishSpeaking:");
public static final int sel_convertSizeToBase_1 = sel_registerName("convertSizeToBase:");
public static final int sel_pointerFunctionsWithOptions_1 = sel_registerName("pointerFunctionsWithOptions:");
public static final int sel_setHTTPBody_1 = sel_registerName("setHTTPBody:");
public static final int sel_itemWithTag_1 = sel_registerName("itemWithTag:");
public static final int sel_spellServer_1checkGrammarInString_1language_1details_1 = sel_registerName("spellServer:checkGrammarInString:language:details:");
public static final int sel_vendorPointingDeviceType = sel_registerName("vendorPointingDeviceType");
public static final int sel_firstRectForCharacterRange_1 = sel_registerName("firstRectForCharacterRange:");
public static final int sel_classDescriptionsInSuite_1 = sel_registerName("classDescriptionsInSuite:");
public static final int sel_setAttachmentSize_1forGlyphRange_1 = sel_registerName("setAttachmentSize:forGlyphRange:");
public static final int sel_isEmpty = sel_registerName("isEmpty");
public static final int sel_soundNamed_1 = sel_registerName("soundNamed:");
public static final int sel_preparedCellAtColumn_1row_1 = sel_registerName("preparedCellAtColumn:row:");
public static final int sel_setLeafKeyPath_1 = sel_registerName("setLeafKeyPath:");
public static final int sel_initWithUnsignedInteger_1 = sel_registerName("initWithUnsignedInteger:");
public static final int sel_fractionOfDistanceThroughGlyphForPoint_1inTextContainer_1 = sel_registerName("fractionOfDistanceThroughGlyphForPoint:inTextContainer:");
public static final int sel_isFloatingPanel = sel_registerName("isFloatingPanel");
public static final int sel_replaceObjectsAtIndexes_1withObjects_1 = sel_registerName("replaceObjectsAtIndexes:withObjects:");
public static final int sel_getComponents_1 = sel_registerName("getComponents:");
public static final int sel_fileType = sel_registerName("fileType");
public static final int sel_setShowsBaselineSeparator_1 = sel_registerName("setShowsBaselineSeparator:");
public static final int sel_removeCredential_1forProtectionSpace_1 = sel_registerName("removeCredential:forProtectionSpace:");
public static final int sel_imageRepWithContentsOfFile_1 = sel_registerName("imageRepWithContentsOfFile:");
public static final int sel_predicateWithFormat_1argumentArray_1 = sel_registerName("predicateWithFormat:argumentArray:");
public static final int sel_positiveSuffix = sel_registerName("positiveSuffix");
public static final int sel_formatter = sel_registerName("formatter");
public static final int sel_setAnimationDelay_1 = sel_registerName("setAnimationDelay:");
public static final int sel_maxConcurrentOperationCount = sel_registerName("maxConcurrentOperationCount");
public static final int sel_childSpecifier = sel_registerName("childSpecifier");
public static final int sel_cacheMode = sel_registerName("cacheMode");
public static final int sel_registerForServices = sel_registerName("registerForServices");
public static final int sel_setFirstWeekday_1 = sel_registerName("setFirstWeekday:");
public static final int sel_rulerViewClass = sel_registerName("rulerViewClass");
public static final int sel_initialValue = sel_registerName("initialValue");
public static final int sel_redColor = sel_registerName("redColor");
public static final int sel_addDependency_1 = sel_registerName("addDependency:");
public static final int sel_pathExtension = sel_registerName("pathExtension");
public static final int sel_fastestEncoding = sel_registerName("fastestEncoding");
public static final int sel_socketType = sel_registerName("socketType");
public static final int sel_setRuleThickness_1 = sel_registerName("setRuleThickness:");
public static final int sel_setDTDKind_1 = sel_registerName("setDTDKind:");
public static final int sel_setClass_1forClassName_1 = sel_registerName("setClass:forClassName:");
public static final int sel_setDocumentCursor_1 = sel_registerName("setDocumentCursor:");
public static final int sel_extraLineFragmentRect = sel_registerName("extraLineFragmentRect");
public static final int sel_attributeForName_1 = sel_registerName("attributeForName:");
public static final int sel_defaultCredentialForProtectionSpace_1 = sel_registerName("defaultCredentialForProtectionSpace:");
public static final int sel_indexOfItemWithTag_1 = sel_registerName("indexOfItemWithTag:");
public static final int sel_fontManager_1willIncludeFont_1 = sel_registerName("fontManager:willIncludeFont:");
public static final int sel_scrollRangeToVisible_1 = sel_registerName("scrollRangeToVisible:");
public static final int sel_fileTypeFromLastRunSavePanel = sel_registerName("fileTypeFromLastRunSavePanel");
public static final int sel_collectionView = sel_registerName("collectionView");
public static final int sel_tabView = sel_registerName("tabView");
public static final int sel_commonISOCurrencyCodes = sel_registerName("commonISOCurrencyCodes");
public static final int sel_removeFontTrait_1 = sel_registerName("removeFontTrait:");
public static final int sel_drawKnob_1 = sel_registerName("drawKnob:");
public static final int sel_tokenField_1menuForRepresentedObject_1 = sel_registerName("tokenField:menuForRepresentedObject:");
public static final int sel_setFrameUsingName_1 = sel_registerName("setFrameUsingName:");
public static final int sel_classNameEncodedForTrueClassName_1 = sel_registerName("classNameEncodedForTrueClassName:");
public static final int sel_windowFrameAutosaveName = sel_registerName("windowFrameAutosaveName");
public static final int sel_characterAtIndex_1 = sel_registerName("characterAtIndex:");
public static final int sel_smartInsertAfterStringForString_1replacingRange_1 = sel_registerName("smartInsertAfterStringForString:replacingRange:");
public static final int sel_version = sel_registerName("version");
public static final int sel_objectsAtIndexes_1 = sel_registerName("objectsAtIndexes:");
public static final int sel_requestIsCacheEquivalent_1toRequest_1 = sel_registerName("requestIsCacheEquivalent:toRequest:");
public static final int sel_columnOfMatrix_1 = sel_registerName("columnOfMatrix:");
public static final int sel_isBezeled = sel_registerName("isBezeled");
public static final int sel_setAutosaveName_1 = sel_registerName("setAutosaveName:");
public static final int sel_becomeMainWindow = sel_registerName("becomeMainWindow");
public static final int sel_pasteAsRichText_1 = sel_registerName("pasteAsRichText:");
public static final int sel_isSpeaking = sel_registerName("isSpeaking");
public static final int sel_format = sel_registerName("format");
public static final int sel_volume = sel_registerName("volume");
public static final int sel_setMenu_1 = sel_registerName("setMenu:");
public static final int sel_setEra_1 = sel_registerName("setEra:");
public static final int sel_textContainerOrigin = sel_registerName("textContainerOrigin");
public static final int sel_setLocalizesFormat_1 = sel_registerName("setLocalizesFormat:");
public static final int sel_removeIndex_1 = sel_registerName("removeIndex:");
public static final int sel_gotoPosterFrame_1 = sel_registerName("gotoPosterFrame:");
public static final int sel_validateValue_1forKeyPath_1error_1 = sel_registerName("validateValue:forKeyPath:error:");
public static final int sel_initWithCharactersNoCopy_1length_1freeWhenDone_1 = sel_registerName("initWithCharactersNoCopy:length:freeWhenDone:");
public static final int sel_initWithLength_1 = sel_registerName("initWithLength:");
public static final int sel_setAllowsMultipleSelection_1 = sel_registerName("setAllowsMultipleSelection:");
public static final int sel_isRotatedFromBase = sel_registerName("isRotatedFromBase");
public static final int sel_beginDocument = sel_registerName("beginDocument");
public static final int sel_initWithContentsOfURL_1usedEncoding_1error_1 = sel_registerName("initWithContentsOfURL:usedEncoding:error:");
public static final int sel_showsSuppressionButton = sel_registerName("showsSuppressionButton");
public static final int sel_tearOffMenuRepresentation = sel_registerName("tearOffMenuRepresentation");
public static final int sel_otherEventWithType_1location_1modifierFlags_1timestamp_1windowNumber_1context_1subtype_1data1_1data2_1 = sel_registerName("otherEventWithType:location:modifierFlags:timestamp:windowNumber:context:subtype:data1:data2:");
public static final int sel_imageUnfilteredFileTypes = sel_registerName("imageUnfilteredFileTypes");
public static final int sel_isGathering = sel_registerName("isGathering");
public static final int sel_slideImage_1from_1to_1 = sel_registerName("slideImage:from:to:");
public static final int sel_initWithTCPPort_1 = sel_registerName("initWithTCPPort:");
public static final int sel_stringByFoldingWithOptions_1locale_1 = sel_registerName("stringByFoldingWithOptions:locale:");
public static final int sel_viewDidUnhide = sel_registerName("viewDidUnhide");
public static final int sel_controlSize = sel_registerName("controlSize");
public static final int sel_resourceDataUsingCache_1 = sel_registerName("resourceDataUsingCache:");
public static final int sel_startWhenAnimation_1reachesProgress_1 = sel_registerName("startWhenAnimation:reachesProgress:");
public static final int sel_registerURLHandleClass_1 = sel_registerName("registerURLHandleClass:");
public static final int sel_indicatorImageInTableColumn_1 = sel_registerName("indicatorImageInTableColumn:");
public static final int sel_decimalNumberByMultiplyingByPowerOf10_1 = sel_registerName("decimalNumberByMultiplyingByPowerOf10:");
public static final int sel_scrollPoint_1 = sel_registerName("scrollPoint:");
public static final int sel_setValue_1forKeyPath_1 = sel_registerName("setValue:forKeyPath:");
public static final int sel_fontDescriptorWithMatrix_1 = sel_registerName("fontDescriptorWithMatrix:");
public static final int sel_parser_1foundProcessingInstructionWithTarget_1data_1 = sel_registerName("parser:foundProcessingInstructionWithTarget:data:");
public static final int sel_interfaceStyle = sel_registerName("interfaceStyle");
public static final int sel_comboBox_1objectValueForItemAtIndex_1 = sel_registerName("comboBox:objectValueForItemAtIndex:");
public static final int sel_applicationDidFinishLaunching_1 = sel_registerName("applicationDidFinishLaunching:");
public static final int sel_currentMemoryUsage = sel_registerName("currentMemoryUsage");
public static final int sel_altersStateOfSelectedItem = sel_registerName("altersStateOfSelectedItem");
public static final int sel_selectedColumn = sel_registerName("selectedColumn");
public static final int sel_convertBaseToScreen_1 = sel_registerName("convertBaseToScreen:");
public static final int sel_lineHeightMultiple = sel_registerName("lineHeightMultiple");
public static final int sel_CGColorSpace = sel_registerName("CGColorSpace");
public static final int sel_descriptionInStringsFileFormat = sel_registerName("descriptionInStringsFileFormat");
public static final int sel_isOutputStackInReverseOrder = sel_registerName("isOutputStackInReverseOrder");
public static final int sel_takeValue_1forKey_1 = sel_registerName("takeValue:forKey:");
public static final int sel_stringWithContentsOfFile_1 = sel_registerName("stringWithContentsOfFile:");
public static final int sel_addItem_1 = sel_registerName("addItem:");
public static final int sel_viewWillMoveToWindow_1 = sel_registerName("viewWillMoveToWindow:");
public static final int sel_changeFileAttributes_1atPath_1 = sel_registerName("changeFileAttributes:atPath:");
public static final int sel_userFixedPitchFontOfSize_1 = sel_registerName("userFixedPitchFontOfSize:");
public static final int sel_selectRowIndexes_1inColumn_1 = sel_registerName("selectRowIndexes:inColumn:");
public static final int sel_defaultLineCapStyle = sel_registerName("defaultLineCapStyle");
public static final int sel_attributedAlternateTitle = sel_registerName("attributedAlternateTitle");
public static final int sel_fileExistsAtPath_1 = sel_registerName("fileExistsAtPath:");
public static final int sel_textView_1clickedOnLink_1atIndex_1 = sel_registerName("textView:clickedOnLink:atIndex:");
public static final int sel_drawers = sel_registerName("drawers");
public static final int sel_outlineView_1shouldSelectTableColumn_1 = sel_registerName("outlineView:shouldSelectTableColumn:");
public static final int sel_pointValue = sel_registerName("pointValue");
public static final int sel_integerValue = sel_registerName("integerValue");
public static final int sel_modifyFontViaPanel_1 = sel_registerName("modifyFontViaPanel:");
public static final int sel_windowTitleForDocumentDisplayName_1 = sel_registerName("windowTitleForDocumentDisplayName:");
public static final int sel_shortWeekdaySymbols = sel_registerName("shortWeekdaySymbols");
public static final int sel_titleOfSelectedItem = sel_registerName("titleOfSelectedItem");
public static final int sel_setWindowsNeedUpdate_1 = sel_registerName("setWindowsNeedUpdate:");
public static final int sel_stringWithUTF8String_1 = sel_registerName("stringWithUTF8String:");
public static final int sel_transformedValueClass = sel_registerName("transformedValueClass");
public static final int sel_initWithColorsAndLocations_1 = sel_registerName("initWithColorsAndLocations:");
public static final int sel_acceptsMouseMovedEvents = sel_registerName("acceptsMouseMovedEvents");
public static final int sel_toolTipsFontOfSize_1 = sel_registerName("toolTipsFontOfSize:");
public static final int sel_setTextAttributesForPositiveValues_1 = sel_registerName("setTextAttributesForPositiveValues:");
public static final int sel_setAlwaysShowsDecimalSeparator_1 = sel_registerName("setAlwaysShowsDecimalSeparator:");
public static final int sel_setNumberOfColumns_1 = sel_registerName("setNumberOfColumns:");
public static final int sel_moveRightAndModifySelection_1 = sel_registerName("moveRightAndModifySelection:");
public static final int sel_indexOfItem_1 = sel_registerName("indexOfItem:");
public static final int sel_moveWordRight_1 = sel_registerName("moveWordRight:");
public static final int sel_numberWithUnsignedLongLong_1 = sel_registerName("numberWithUnsignedLongLong:");
public static final int sel_initWithAuthenticationChallenge_1sender_1 = sel_registerName("initWithAuthenticationChallenge:sender:");
public static final int sel_panelConvertFont_1 = sel_registerName("panelConvertFont:");
public static final int sel_temporaryAttribute_1atCharacterIndex_1effectiveRange_1 = sel_registerName("temporaryAttribute:atCharacterIndex:effectiveRange:");
public static final int sel_intersectHashTable_1 = sel_registerName("intersectHashTable:");
public static final int sel_positionOfGlyph_1precededByGlyph_1isNominal_1 = sel_registerName("positionOfGlyph:precededByGlyph:isNominal:");
public static final int sel_setLocalizedKeyTable_1 = sel_registerName("setLocalizedKeyTable:");
public static final int sel_fileManager_1shouldLinkItemAtPath_1toPath_1 = sel_registerName("fileManager:shouldLinkItemAtPath:toPath:");
public static final int sel_setScriptErrorNumber_1 = sel_registerName("setScriptErrorNumber:");
public static final int sel_initWithLocaleIdentifier_1 = sel_registerName("initWithLocaleIdentifier:");
public static final int sel_toolTip = sel_registerName("toolTip");
public static final int sel_alternateMnemonic = sel_registerName("alternateMnemonic");
public static final int sel_setChannelMapping_1 = sel_registerName("setChannelMapping:");
public static final int sel_setLocalizedKey_1 = sel_registerName("setLocalizedKey:");
public static final int sel_selector = sel_registerName("selector");
public static final int sel_setCurrencyGroupingSeparator_1 = sel_registerName("setCurrencyGroupingSeparator:");
public static final int sel_initWithKeyOptions_1valueOptions_1capacity_1 = sel_registerName("initWithKeyOptions:valueOptions:capacity:");
public static final int sel_setStandaloneMonthSymbols_1 = sel_registerName("setStandaloneMonthSymbols:");
public static final int sel_physicalMemory = sel_registerName("physicalMemory");
public static final int sel_parse = sel_registerName("parse");
public static final int sel_defaultTypesetterBehavior = sel_registerName("defaultTypesetterBehavior");
public static final int sel_setRulerVisible_1 = sel_registerName("setRulerVisible:");
public static final int sel_resizeDownCursor = sel_registerName("resizeDownCursor");
public static final int sel_getBoundingRects_1forGlyphs_1count_1 = sel_registerName("getBoundingRects:forGlyphs:count:");
public static final int sel_openPanel = sel_registerName("openPanel");
public static final int sel_setEntryWidth_1 = sel_registerName("setEntryWidth:");
public static final int sel_insertChildren_1atIndex_1 = sel_registerName("insertChildren:atIndex:");
public static final int sel_selectNext_1 = sel_registerName("selectNext:");
public static final int sel_paragraphGlyphRange = sel_registerName("paragraphGlyphRange");
public static final int sel_animations = sel_registerName("animations");
public static final int sel_setMarkers_1 = sel_registerName("setMarkers:");
public static final int sel_raise = sel_registerName("raise");
public static final int sel_menuZone = sel_registerName("menuZone");
public static final int sel_weekdaySymbols = sel_registerName("weekdaySymbols");
public static final int sel_setHTTPMethod_1 = sel_registerName("setHTTPMethod:");
public static final int sel_placeholderAttributedString = sel_registerName("placeholderAttributedString");
public static final int sel_filenameExtension_1isValidForType_1 = sel_registerName("filenameExtension:isValidForType:");
public static final int sel_initWithReceivePort_1sendPort_1 = sel_registerName("initWithReceivePort:sendPort:");
public static final int sel_setContextHelp_1forObject_1 = sel_registerName("setContextHelp:forObject:");
public static final int sel_archiveRootObject_1toFile_1 = sel_registerName("archiveRootObject:toFile:");
public static final int sel_setAnimations_1 = sel_registerName("setAnimations:");
public static final int sel_locationOfPrintRect_1 = sel_registerName("locationOfPrintRect:");
public static final int sel_setInterfaceStyle_1 = sel_registerName("setInterfaceStyle:");
public static final int sel_startMonitoring = sel_registerName("startMonitoring");
public static final int sel_presentError_1modalForWindow_1delegate_1didPresentSelector_1contextInfo_1 = sel_registerName("presentError:modalForWindow:delegate:didPresentSelector:contextInfo:");
public static final int sel_windowFrameColor = sel_registerName("windowFrameColor");
public static final int sel_paragraphSpacing = sel_registerName("paragraphSpacing");
public static final int sel_fileAttributes = sel_registerName("fileAttributes");
public static final int sel_setDisplayedCommandsTitle_1 = sel_registerName("setDisplayedCommandsTitle:");
public static final int sel_preflightAndReturnError_1 = sel_registerName("preflightAndReturnError:");
public static final int sel_setObservationInfo_1 = sel_registerName("setObservationInfo:");
public static final int sel_currentCommand = sel_registerName("currentCommand");
public static final int sel_processInfo = sel_registerName("processInfo");
public static final int sel_appendString_1 = sel_registerName("appendString:");
public static final int sel_setShowsHelp_1 = sel_registerName("setShowsHelp:");
public static final int sel_datePickerStyle = sel_registerName("datePickerStyle");
public static final int sel_addFileWrapper_1 = sel_registerName("addFileWrapper:");
public static final int sel_bitmapImageRepForCachingDisplayInRect_1 = sel_registerName("bitmapImageRepForCachingDisplayInRect:");
public static final int sel_initWithFileAtPath_1 = sel_registerName("initWithFileAtPath:");
public static final int sel_cellClass = sel_registerName("cellClass");
public static final int sel_imageRepsWithContentsOfFile_1 = sel_registerName("imageRepsWithContentsOfFile:");
public static final int sel_localizedScannerWithString_1 = sel_registerName("localizedScannerWithString:");
public static final int sel_isExpandable_1 = sel_registerName("isExpandable:");
public static final int sel_isLoaded = sel_registerName("isLoaded");
public static final int sel_browser_1acceptDrop_1atRow_1column_1dropOperation_1 = sel_registerName("browser:acceptDrop:atRow:column:dropOperation:");
public static final int sel_panel_1directoryDidChange_1 = sel_registerName("panel:directoryDidChange:");
public static final int sel_publicID = sel_registerName("publicID");
public static final int sel_contentMaxSize = sel_registerName("contentMaxSize");
public static final int sel_menuDidClose_1 = sel_registerName("menuDidClose:");
public static final int sel_setPrinter_1 = sel_registerName("setPrinter:");
public static final int sel_keywordForDescriptorAtIndex_1 = sel_registerName("keywordForDescriptorAtIndex:");
public static final int sel_notANumberSymbol = sel_registerName("notANumberSymbol");
public static final int sel_minimumLineHeight = sel_registerName("minimumLineHeight");
public static final int sel_setContentBorderThickness_1forEdge_1 = sel_registerName("setContentBorderThickness:forEdge:");
public static final int sel_titleFrameOfColumn_1 = sel_registerName("titleFrameOfColumn:");
public static final int sel_dateValue = sel_registerName("dateValue");
public static final int sel_numberOfRows = sel_registerName("numberOfRows");
public static final int sel_isReadableFileAtPath_1 = sel_registerName("isReadableFileAtPath:");
public static final int sel_canInsertChild = sel_registerName("canInsertChild");
public static final int sel_stringByReplacingOccurrencesOfString_1withString_1options_1range_1 = sel_registerName("stringByReplacingOccurrencesOfString:withString:options:range:");
public static final int sel_ok_1 = sel_registerName("ok:");
public static final int sel_hourOfDay = sel_registerName("hourOfDay");
public static final int sel_paragraphRangeForRange_1 = sel_registerName("paragraphRangeForRange:");
public static final int sel_focusStack = sel_registerName("focusStack");
public static final int sel_setUsesThreadedAnimation_1 = sel_registerName("setUsesThreadedAnimation:");
public static final int sel_dataForType_1 = sel_registerName("dataForType:");
public static final int sel_isByref = sel_registerName("isByref");
public static final int sel_initWithResponse_1data_1userInfo_1storagePolicy_1 = sel_registerName("initWithResponse:data:userInfo:storagePolicy:");
public static final int sel_initWithSerializedRepresentation_1 = sel_registerName("initWithSerializedRepresentation:");
public static final int sel_openDocument_1 = sel_registerName("openDocument:");
public static final int sel_translateRectsNeedingDisplayInRect_1by_1 = sel_registerName("translateRectsNeedingDisplayInRect:by:");
public static final int sel_highlightsBy = sel_registerName("highlightsBy");
public static final int sel_openHandCursor = sel_registerName("openHandCursor");
public static final int sel_lineFragmentRectForProposedRect_1remainingRect_1 = sel_registerName("lineFragmentRectForProposedRect:remainingRect:");
public static final int sel_selectedNodes = sel_registerName("selectedNodes");
public static final int sel_replaceObjectAtIndex_1withObject_1 = sel_registerName("replaceObjectAtIndex:withObject:");
public static final int sel_indexOfItemAtPoint_1 = sel_registerName("indexOfItemAtPoint:");
public static final int sel_setCriteria_1andDisplayValues_1forRowAtIndex_1 = sel_registerName("setCriteria:andDisplayValues:forRowAtIndex:");
public static final int sel_textStorage_1edited_1range_1changeInLength_1invalidatedRange_1 = sel_registerName("textStorage:edited:range:changeInLength:invalidatedRange:");
public static final int sel_synchronizeWindowTitleWithDocumentName = sel_registerName("synchronizeWindowTitleWithDocumentName");
public static final int sel_fileHandleWithNullDevice = sel_registerName("fileHandleWithNullDevice");
public static final int sel_descriptorWithTypeCode_1 = sel_registerName("descriptorWithTypeCode:");
public static final int sel_initWithDocFormat_1documentAttributes_1 = sel_registerName("initWithDocFormat:documentAttributes:");
public static final int sel_setAutoresizingMask_1 = sel_registerName("setAutoresizingMask:");
public static final int sel_methodReturnLength = sel_registerName("methodReturnLength");
public static final int sel_recentDocumentURLs = sel_registerName("recentDocumentURLs");
public static final int sel_setCurrentDirectoryPath_1 = sel_registerName("setCurrentDirectoryPath:");
public static final int sel_characterSetWithRange_1 = sel_registerName("characterSetWithRange:");
public static final int sel_resizeUpCursor = sel_registerName("resizeUpCursor");
public static final int sel_rect = sel_registerName("rect");
public static final int sel_removeCharactersInRange_1 = sel_registerName("removeCharactersInRange:");
public static final int sel_performSelectorOnMainThread_1withObject_1waitUntilDone_1 = sel_registerName("performSelectorOnMainThread:withObject:waitUntilDone:");
public static final int sel_elementAtIndex_1associatedPoints_1 = sel_registerName("elementAtIndex:associatedPoints:");
public static final int sel_dataForKey_1 = sel_registerName("dataForKey:");
public static final int sel_defaultDepthLimit = sel_registerName("defaultDepthLimit");
public static final int sel_rulersVisible = sel_registerName("rulersVisible");
public static final int sel_generalPasteboard = sel_registerName("generalPasteboard");
public static final int sel_setAllowsTickMarkValuesOnly_1 = sel_registerName("setAllowsTickMarkValuesOnly:");
public static final int sel_stateImageOffset = sel_registerName("stateImageOffset");
public static final int sel_isBordered = sel_registerName("isBordered");
public static final int sel_insertPointer_1atIndex_1 = sel_registerName("insertPointer:atIndex:");
public static final int sel_keyForFileWrapper_1 = sel_registerName("keyForFileWrapper:");
public static final int sel_renewGState = sel_registerName("renewGState");
public static final int sel_autovalidates = sel_registerName("autovalidates");
public static final int sel_localizedNameForFamily_1face_1 = sel_registerName("localizedNameForFamily:face:");
public static final int sel_setAltIncrementValue_1 = sel_registerName("setAltIncrementValue:");
public static final int sel_sortUsingFunction_1context_1 = sel_registerName("sortUsingFunction:context:");
public static final int sel_fileNameExtensionWasHiddenInLastRunSavePanel = sel_registerName("fileNameExtensionWasHiddenInLastRunSavePanel");
public static final int sel_endSheet_1returnCode_1 = sel_registerName("endSheet:returnCode:");
public static final int sel_insertObjects_1atIndexes_1 = sel_registerName("insertObjects:atIndexes:");
public static final int sel_standaloneMonthSymbols = sel_registerName("standaloneMonthSymbols");
public static final int sel_prefersAllColumnUserResizing = sel_registerName("prefersAllColumnUserResizing");
public static final int sel_separatesColumns = sel_registerName("separatesColumns");
public static final int sel_moveToBeginningOfDocument_1 = sel_registerName("moveToBeginningOfDocument:");
public static final int sel_objectZone = sel_registerName("objectZone");
public static final int sel_initWithURL_1MIMEType_1expectedContentLength_1textEncodingName_1 = sel_registerName("initWithURL:MIMEType:expectedContentLength:textEncodingName:");
public static final int sel_gotoEnd_1 = sel_registerName("gotoEnd:");
public static final int sel_superscriptRange_1 = sel_registerName("superscriptRange:");
public static final int sel_readInBackgroundAndNotifyForModes_1 = sel_registerName("readInBackgroundAndNotifyForModes:");
public static final int sel_initWithObjects_1forKeys_1 = sel_registerName("initWithObjects:forKeys:");
public static final int sel_cancel = sel_registerName("cancel");
public static final int sel_suiteName = sel_registerName("suiteName");
public static final int sel_sortedArrayUsingFunction_1context_1hint_1 = sel_registerName("sortedArrayUsingFunction:context:hint:");
public static final int sel_countWordsInString_1language_1 = sel_registerName("countWordsInString:language:");
public static final int sel_prepareWithInvocationTarget_1 = sel_registerName("prepareWithInvocationTarget:");
public static final int sel_statusItemWithLength_1 = sel_registerName("statusItemWithLength:");
public static final int sel_tableView_1shouldEditTableColumn_1row_1 = sel_registerName("tableView:shouldEditTableColumn:row:");
public static final int sel_appendBezierPathWithRect_1 = sel_registerName("appendBezierPathWithRect:");
public static final int sel_scrollColumnsRightBy_1 = sel_registerName("scrollColumnsRightBy:");
public static final int sel_negativeInfinitySymbol = sel_registerName("negativeInfinitySymbol");
public static final int sel_firstLineHeadIndent = sel_registerName("firstLineHeadIndent");
public static final int sel_generateGlyphsForGlyphStorage_1desiredNumberOfCharacters_1glyphIndex_1characterIndex_1 = sel_registerName("generateGlyphsForGlyphStorage:desiredNumberOfCharacters:glyphIndex:characterIndex:");
public static final int sel_dateWithTimeIntervalSinceReferenceDate_1 = sel_registerName("dateWithTimeIntervalSinceReferenceDate:");
public static final int sel_menu_1updateItem_1atIndex_1shouldCancel_1 = sel_registerName("menu:updateItem:atIndex:shouldCancel:");
public static final int sel_connection_1willSendRequest_1redirectResponse_1 = sel_registerName("connection:willSendRequest:redirectResponse:");
public static final int sel_attemptRecoveryFromError_1optionIndex_1delegate_1didRecoverSelector_1contextInfo_1 = sel_registerName("attemptRecoveryFromError:optionIndex:delegate:didRecoverSelector:contextInfo:");
public static final int sel_cursorUpdate_1 = sel_registerName("cursorUpdate:");
public static final int sel_initWithMachPort_1options_1 = sel_registerName("initWithMachPort:options:");
public static final int sel_applyFontTraits_1range_1 = sel_registerName("applyFontTraits:range:");
public static final int sel_noteHeightOfRowsWithIndexesChanged_1 = sel_registerName("noteHeightOfRowsWithIndexesChanged:");
public static final int sel_orderFrontTablePanel_1 = sel_registerName("orderFrontTablePanel:");
public static final int sel_arrayWithObjects_1 = sel_registerName("arrayWithObjects:");
public static final int sel_enableFlushWindow = sel_registerName("enableFlushWindow");
public static final int sel_minimum = sel_registerName("minimum");
public static final int sel_stopListening = sel_registerName("stopListening");
public static final int sel_endParagraph = sel_registerName("endParagraph");
public static final int sel_sharingType = sel_registerName("sharingType");
public static final int sel_backgroundLayoutEnabled = sel_registerName("backgroundLayoutEnabled");
public static final int sel_yellowColor = sel_registerName("yellowColor");
public static final int sel_columnIndexesInRect_1 = sel_registerName("columnIndexesInRect:");
public static final int sel_compositingOperation = sel_registerName("compositingOperation");
public static final int sel_stopModalWithCode_1 = sel_registerName("stopModalWithCode:");
public static final int sel_smallSystemFontSize = sel_registerName("smallSystemFontSize");
public static final int sel_nonretainedObjectValue = sel_registerName("nonretainedObjectValue");
public static final int sel_encodeBytes_1length_1forKey_1 = sel_registerName("encodeBytes:length:forKey:");
public static final int sel_objectValues = sel_registerName("objectValues");
public static final int sel_destroyContext = sel_registerName("destroyContext");
public static final int sel_setFileModificationDate_1 = sel_registerName("setFileModificationDate:");
public static final int sel_rightMouseDragged_1 = sel_registerName("rightMouseDragged:");
public static final int sel_systemStatusBar = sel_registerName("systemStatusBar");
public static final int sel_executableArchitectures = sel_registerName("executableArchitectures");
public static final int sel_recentSearches = sel_registerName("recentSearches");
public static final int sel_getWhite_1alpha_1 = sel_registerName("getWhite:alpha:");
public static final int sel_readDataToEndOfFile = sel_registerName("readDataToEndOfFile");
public static final int sel_setHour_1 = sel_registerName("setHour:");
public static final int sel_titleBarFontOfSize_1 = sel_registerName("titleBarFontOfSize:");
public static final int sel_canDragRowsWithIndexes_1atPoint_1 = sel_registerName("canDragRowsWithIndexes:atPoint:");
public static final int sel_acceptsArrowKeys = sel_registerName("acceptsArrowKeys");
public static final int sel_availableColorLists = sel_registerName("availableColorLists");
public static final int sel_setUsesLazyFetching_1 = sel_registerName("setUsesLazyFetching:");
public static final int sel_convertAttributes_1 = sel_registerName("convertAttributes:");
public static final int sel_isWritableFileAtPath_1 = sel_registerName("isWritableFileAtPath:");
public static final int sel_timerWithTimeInterval_1target_1selector_1userInfo_1repeats_1 = sel_registerName("timerWithTimeInterval:target:selector:userInfo:repeats:");
public static final int sel_windowDidChangeScreen_1 = sel_registerName("windowDidChangeScreen:");
public static final int sel_insertTextContainer_1atIndex_1 = sel_registerName("insertTextContainer:atIndex:");
public static final int sel_weightOfFont_1 = sel_registerName("weightOfFont:");
public static final int sel_temporaryAttributesAtCharacterIndex_1longestEffectiveRange_1inRange_1 = sel_registerName("temporaryAttributesAtCharacterIndex:longestEffectiveRange:inRange:");
public static final int sel_trackWithEvent_1 = sel_registerName("trackWithEvent:");
public static final int sel_selectRowIndexes_1byExtendingSelection_1 = sel_registerName("selectRowIndexes:byExtendingSelection:");
public static final int sel_charactersToBeSkipped = sel_registerName("charactersToBeSkipped");
public static final int sel_names = sel_registerName("names");
public static final int sel_setAllowsCutCopyPaste_1 = sel_registerName("setAllowsCutCopyPaste:");
public static final int sel_setDuration_1 = sel_registerName("setDuration:");
public static final int sel_sleepForTimeInterval_1 = sel_registerName("sleepForTimeInterval:");
public static final int sel_removeChildAtIndex_1 = sel_registerName("removeChildAtIndex:");
public static final int sel_tokenFieldCell_1writeRepresentedObjects_1toPasteboard_1 = sel_registerName("tokenFieldCell:writeRepresentedObjects:toPasteboard:");
public static final int sel_backgroundStyle = sel_registerName("backgroundStyle");
public static final int sel_open_1 = sel_registerName("open:");
public static final int sel_indexGreaterThanOrEqualToIndex_1 = sel_registerName("indexGreaterThanOrEqualToIndex:");
public static final int sel_isAbsolutePath = sel_registerName("isAbsolutePath");
public static final int sel_paletteLabel = sel_registerName("paletteLabel");
public static final int sel_setQuarterSymbols_1 = sel_registerName("setQuarterSymbols:");
public static final int sel_suppressionButton = sel_registerName("suppressionButton");
public static final int sel_undo = sel_registerName("undo");
public static final int sel_rangeOfString_1options_1range_1locale_1 = sel_registerName("rangeOfString:options:range:locale:");
public static final int sel_localizedName_1locale_1 = sel_registerName("localizedName:locale:");
public static final int sel_setTableView_1 = sel_registerName("setTableView:");
public static final int sel_isExecutableFileAtPath_1 = sel_registerName("isExecutableFileAtPath:");
public static final int sel_standaloneQuarterSymbols = sel_registerName("standaloneQuarterSymbols");
public static final int sel_textView_1shouldSetSpellingState_1range_1 = sel_registerName("textView:shouldSetSpellingState:range:");
public static final int sel_newObject = sel_registerName("newObject");
public static final int sel_setDocumentEdited_1 = sel_registerName("setDocumentEdited:");
public static final int sel_setRelativePosition_1 = sel_registerName("setRelativePosition:");
public static final int sel_allConnections = sel_registerName("allConnections");
public static final int sel_isLessThanOrEqualTo_1 = sel_registerName("isLessThanOrEqualTo:");
public static final int sel_attributeWithName_1stringValue_1 = sel_registerName("attributeWithName:stringValue:");
public static final int sel_floatForKey_1 = sel_registerName("floatForKey:");
public static final int sel_initWithDomain_1type_1name_1port_1 = sel_registerName("initWithDomain:type:name:port:");
public static final int sel_setShadowOffset_1 = sel_registerName("setShadowOffset:");
public static final int sel_tabViewItems = sel_registerName("tabViewItems");
public static final int sel_appleEventCodeForReturnType = sel_registerName("appleEventCodeForReturnType");
public static final int sel_createFileAtPath_1contents_1attributes_1 = sel_registerName("createFileAtPath:contents:attributes:");
public static final int sel_ruleEditor_1predicatePartsForCriterion_1withDisplayValue_1inRow_1 = sel_registerName("ruleEditor:predicatePartsForCriterion:withDisplayValue:inRow:");
public static final int sel_evaluateWithObject_1 = sel_registerName("evaluateWithObject:");
public static final int sel_pathComponents = sel_registerName("pathComponents");
public static final int sel_setTarget_1 = sel_registerName("setTarget:");
public static final int sel_fileCreationDate = sel_registerName("fileCreationDate");
public static final int sel_port = sel_registerName("port");
public static final int sel_publish = sel_registerName("publish");
public static final int sel_downloadDidFinish_1 = sel_registerName("downloadDidFinish:");
public static final int sel_endEditing_1 = sel_registerName("endEditing:");
public static final int sel_expectedResourceDataSize = sel_registerName("expectedResourceDataSize");
public static final int sel_paddingCharacter = sel_registerName("paddingCharacter");
public static final int sel_convertPoint_1fromView_1 = sel_registerName("convertPoint:fromView:");
public static final int sel_setIntValue_1 = sel_registerName("setIntValue:");
public static final int sel_appendBezierPathWithArcFromPoint_1toPoint_1radius_1 = sel_registerName("appendBezierPathWithArcFromPoint:toPoint:radius:");
public static final int sel_currentFontAction = sel_registerName("currentFontAction");
public static final int sel_expressionForFunction_1arguments_1 = sel_registerName("expressionForFunction:arguments:");
public static final int sel_minimumDaysInFirstWeek = sel_registerName("minimumDaysInFirstWeek");
public static final int sel_setDeletesFileUponFailure_1 = sel_registerName("setDeletesFileUponFailure:");
public static final int sel_pageCount = sel_registerName("pageCount");
public static final int sel_imageAlignment = sel_registerName("imageAlignment");
public static final int sel_URLProtocol_1didCancelAuthenticationChallenge_1 = sel_registerName("URLProtocol:didCancelAuthenticationChallenge:");
public static final int sel_localizedPaperName = sel_registerName("localizedPaperName");
public static final int sel_setAllowsBranchSelection_1 = sel_registerName("setAllowsBranchSelection:");
public static final int sel_symbolicLinkDestination = sel_registerName("symbolicLinkDestination");
public static final int sel_prepareSavePanel_1 = sel_registerName("prepareSavePanel:");
public static final int sel_enableMultipleThreads = sel_registerName("enableMultipleThreads");
public static final int sel_configurePersistentStoreCoordinatorForURL_1ofType_1modelConfiguration_1storeOptions_1error_1 = sel_registerName("configurePersistentStoreCoordinatorForURL:ofType:modelConfiguration:storeOptions:error:");
public static final int sel_backgroundLoadDidFailWithReason_1 = sel_registerName("backgroundLoadDidFailWithReason:");
public static final int sel_copyAttributesFromContext_1withMask_1 = sel_registerName("copyAttributesFromContext:withMask:");
public static final int sel_isVertical = sel_registerName("isVertical");
public static final int sel_wait = sel_registerName("wait");
public static final int sel_firstObjectCommonWithArray_1 = sel_registerName("firstObjectCommonWithArray:");
public static final int sel_hideOtherApplications_1 = sel_registerName("hideOtherApplications:");
public static final int sel_startSpeakingString_1 = sel_registerName("startSpeakingString:");
public static final int sel_makeKeyAndOrderFront_1 = sel_registerName("makeKeyAndOrderFront:");
public static final int sel_drawCellAtIndex_1 = sel_registerName("drawCellAtIndex:");
public static final int sel_headerToolTip = sel_registerName("headerToolTip");
public static final int sel_readRTFDFromFile_1 = sel_registerName("readRTFDFromFile:");
public static final int sel_knownTimeZoneNames = sel_registerName("knownTimeZoneNames");
public static final int sel_toOneRelationshipKeys = sel_registerName("toOneRelationshipKeys");
public static final int sel_replyTimeout = sel_registerName("replyTimeout");
public static final int sel_setDelegate_1 = sel_registerName("setDelegate:");
public static final int sel_initWithTarget_1protocol_1 = sel_registerName("initWithTarget:protocol:");
public static final int sel_setShowsPrintPanel_1 = sel_registerName("setShowsPrintPanel:");
public static final int sel_trackingNumber = sel_registerName("trackingNumber");
public static final int sel_initWithDecimal_1 = sel_registerName("initWithDecimal:");
public static final int sel_proxyWithTarget_1connection_1 = sel_registerName("proxyWithTarget:connection:");
public static final int sel_setCompositingFilter_1 = sel_registerName("setCompositingFilter:");
public static final int sel_systemFontSizeForControlSize_1 = sel_registerName("systemFontSizeForControlSize:");
public static final int sel_registerDefaults_1 = sel_registerName("registerDefaults:");
public static final int sel_veryShortStandaloneMonthSymbols = sel_registerName("veryShortStandaloneMonthSymbols");
public static final int sel_setPlusSign_1 = sel_registerName("setPlusSign:");
public static final int sel_colorRenderingIntent = sel_registerName("colorRenderingIntent");
public static final int sel_thicknessRequiredInRuler = sel_registerName("thicknessRequiredInRuler");
public static final int sel_setAlertStyle_1 = sel_registerName("setAlertStyle:");
public static final int sel_searchScopes = sel_registerName("searchScopes");
public static final int sel_tag = sel_registerName("tag");
public static final int sel_autosavingDelay = sel_registerName("autosavingDelay");
public static final int sel_setDateStyle_1 = sel_registerName("setDateStyle:");
public static final int sel_setIcon_1forFile_1options_1 = sel_registerName("setIcon:forFile:options:");
public static final int sel_internationalCurrencySymbol = sel_registerName("internationalCurrencySymbol");
public static final int sel_netService_1didUpdateTXTRecordData_1 = sel_registerName("netService:didUpdateTXTRecordData:");
public static final int sel_setOnMouseEntered_1 = sel_registerName("setOnMouseEntered:");
public static final int sel_setTextBaseWritingDirection_1 = sel_registerName("setTextBaseWritingDirection:");
public static final int sel_startSpecifier = sel_registerName("startSpecifier");
public static final int sel_setExcludedFromWindowsMenu_1 = sel_registerName("setExcludedFromWindowsMenu:");
public static final int sel_operatingSystemName = sel_registerName("operatingSystemName");
public static final int sel_isConcurrent = sel_registerName("isConcurrent");
public static final int sel_enableRelease_1 = sel_registerName("enableRelease:");
public static final int sel_getValues_1forAttribute_1forVirtualScreen_1 = sel_registerName("getValues:forAttribute:forVirtualScreen:");
public static final int sel_interrupt = sel_registerName("interrupt");
public static final int sel_whiteComponent = sel_registerName("whiteComponent");
public static final int sel_keyEquivalentRectForBounds_1 = sel_registerName("keyEquivalentRectForBounds:");
public static final int sel_numberOfVisibleColumns = sel_registerName("numberOfVisibleColumns");
public static final int sel_windowNibName = sel_registerName("windowNibName");
public static final int sel_parser_1foundIgnorableWhitespace_1 = sel_registerName("parser:foundIgnorableWhitespace:");
public static final int sel_menuItemCellForItemAtIndex_1 = sel_registerName("menuItemCellForItemAtIndex:");
public static final int sel_addTrackingArea_1 = sel_registerName("addTrackingArea:");
public static final int sel_arrangedObjects = sel_registerName("arrangedObjects");
public static final int sel_timeStyle = sel_registerName("timeStyle");
public static final int sel_indexPathWithIndexes_1length_1 = sel_registerName("indexPathWithIndexes:length:");
public static final int sel_addNamespace_1 = sel_registerName("addNamespace:");
public static final int sel_setDisplayValuesKeyPath_1 = sel_registerName("setDisplayValuesKeyPath:");
public static final int sel_notificationBatchingInterval = sel_registerName("notificationBatchingInterval");
public static final int sel_MIMEType = sel_registerName("MIMEType");
public static final int sel_drawerWillClose_1 = sel_registerName("drawerWillClose:");
public static final int sel_sortedArrayHint = sel_registerName("sortedArrayHint");
public static final int sel_shortQuarterSymbols = sel_registerName("shortQuarterSymbols");
public static final int sel_usesAlternatingRowBackgroundColors = sel_registerName("usesAlternatingRowBackgroundColors");
public static final int sel_colorWithKey_1 = sel_registerName("colorWithKey:");
public static final int sel_rangeForUserCompletion = sel_registerName("rangeForUserCompletion");
public static final int sel_boolValue = sel_registerName("boolValue");
public static final int sel_autosaveName = sel_registerName("autosaveName");
public static final int sel_childWindows = sel_registerName("childWindows");
public static final int sel_mapTableWithStrongToWeakObjects = sel_registerName("mapTableWithStrongToWeakObjects");
public static final int sel_unhide = sel_registerName("unhide");
public static final int sel_setRowClass_1 = sel_registerName("setRowClass:");
public static final int sel_endSubelementIndex = sel_registerName("endSubelementIndex");
public static final int sel_preferredLocalizations = sel_registerName("preferredLocalizations");
public static final int sel_fileSystemChanged = sel_registerName("fileSystemChanged");
public static final int sel_secondOfMinute = sel_registerName("secondOfMinute");
public static final int sel_scrollWheel_1 = sel_registerName("scrollWheel:");
public static final int sel_characterIndexForGlyphAtIndex_1 = sel_registerName("characterIndexForGlyphAtIndex:");
public static final int sel_drawRepresentation_1inRect_1 = sel_registerName("drawRepresentation:inRect:");
public static final int sel_setByAddingObject_1 = sel_registerName("setByAddingObject:");
public static final int sel_rotateByAngle_1 = sel_registerName("rotateByAngle:");
public static final int sel_allValues = sel_registerName("allValues");
public static final int sel_addItemWithObjectValue_1 = sel_registerName("addItemWithObjectValue:");
public static final int sel_tabViewItemAtIndex_1 = sel_registerName("tabViewItemAtIndex:");
public static final int sel_servicePortWithName_1 = sel_registerName("servicePortWithName:");
public static final int sel_multiplier = sel_registerName("multiplier");
public static final int sel_setSelectionGranularity_1 = sel_registerName("setSelectionGranularity:");
public static final int sel_setViewsNeedDisplay_1 = sel_registerName("setViewsNeedDisplay:");
public static final int sel_object = sel_registerName("object");
public static final int sel_writeFileWrapper_1 = sel_registerName("writeFileWrapper:");
public static final int sel_authenticationMethod = sel_registerName("authenticationMethod");
public static final int sel_frameLength = sel_registerName("frameLength");
public static final int sel_nextNode = sel_registerName("nextNode");
public static final int sel_characterSetWithCharactersInString_1 = sel_registerName("characterSetWithCharactersInString:");
public static final int sel_messageText = sel_registerName("messageText");
public static final int sel_setArguments_1 = sel_registerName("setArguments:");
public static final int sel_getBytes_1length_1 = sel_registerName("getBytes:length:");
public static final int sel_setDropItem_1dropChildIndex_1 = sel_registerName("setDropItem:dropChildIndex:");
public static final int sel_expressionForVariable_1 = sel_registerName("expressionForVariable:");
public static final int sel_rectPreservedDuringLiveResize = sel_registerName("rectPreservedDuringLiveResize");
public static final int sel_isMuted = sel_registerName("isMuted");
public static final int sel_allowsColumnResizing = sel_registerName("allowsColumnResizing");
public static final int sel_readFileWrapper = sel_registerName("readFileWrapper");
public static final int sel_undoNestedGroup = sel_registerName("undoNestedGroup");
public static final int sel_setIncludedKeys_1 = sel_registerName("setIncludedKeys:");
public static final int sel_textWithStringValue_1 = sel_registerName("textWithStringValue:");
public static final int sel_ruleEditorRowsDidChange_1 = sel_registerName("ruleEditorRowsDidChange:");
public static final int sel_handleMouseEvent_1 = sel_registerName("handleMouseEvent:");
public static final int sel_browser_1canDragRowsWithIndexes_1inColumn_1withEvent_1 = sel_registerName("browser:canDragRowsWithIndexes:inColumn:withEvent:");
public static final int sel_drawPageBorderWithSize_1 = sel_registerName("drawPageBorderWithSize:");
public static final int sel_valueWithBytes_1objCType_1 = sel_registerName("valueWithBytes:objCType:");
public static final int sel_subpathsAtPath_1 = sel_registerName("subpathsAtPath:");
public static final int sel_mnemonicLocation = sel_registerName("mnemonicLocation");
public static final int sel_dockTile = sel_registerName("dockTile");
public static final int sel_setFirstLineHeadIndent_1 = sel_registerName("setFirstLineHeadIndent:");
public static final int sel_isAutomaticQuoteSubstitutionEnabled = sel_registerName("isAutomaticQuoteSubstitutionEnabled");
public static final int sel_allowsReverseTransformation = sel_registerName("allowsReverseTransformation");
public static final int sel_moveNodes_1toIndexPath_1 = sel_registerName("moveNodes:toIndexPath:");
public static final int sel_seekToFileOffset_1 = sel_registerName("seekToFileOffset:");
public static final int sel_scriptingBeginsWith_1 = sel_registerName("scriptingBeginsWith:");
public static final int sel_setInformativeText_1 = sel_registerName("setInformativeText:");
public static final int sel_initWithIndexSet_1 = sel_registerName("initWithIndexSet:");
public static final int sel_write_1maxLength_1 = sel_registerName("write:maxLength:");
public static final int sel_canInitWithRequest_1 = sel_registerName("canInitWithRequest:");
public static final int sel_enqueueNotification_1postingStyle_1 = sel_registerName("enqueueNotification:postingStyle:");
public static final int sel_setShouldResolveExternalEntities_1 = sel_registerName("setShouldResolveExternalEntities:");
public static final int sel_usesFindPanel = sel_registerName("usesFindPanel");
public static final int sel_perMillSymbol = sel_registerName("perMillSymbol");
public static final int sel_setClearsFilterPredicateOnInsertion_1 = sel_registerName("setClearsFilterPredicateOnInsertion:");
public static final int sel_currentLocale = sel_registerName("currentLocale");
public static final int sel_pasteboardByFilteringData_1ofType_1 = sel_registerName("pasteboardByFilteringData:ofType:");
public static final int sel_isSheet = sel_registerName("isSheet");
public static final int sel_hasWritablePropertyForKey_1 = sel_registerName("hasWritablePropertyForKey:");
public static final int sel_drawDividerInRect_1 = sel_registerName("drawDividerInRect:");
public static final int sel_sharedUserDefaultsController = sel_registerName("sharedUserDefaultsController");
public static final int sel_preferredFontNames = sel_registerName("preferredFontNames");
public static final int sel_menuBarFontOfSize_1 = sel_registerName("menuBarFontOfSize:");
public static final int sel_sharedColorPanelExists = sel_registerName("sharedColorPanelExists");
public static final int sel_reshape = sel_registerName("reshape");
public static final int sel_initWithLong_1 = sel_registerName("initWithLong:");
public static final int sel_reservedThicknessForAccessoryView = sel_registerName("reservedThicknessForAccessoryView");
public static final int sel_setTitleCell_1 = sel_registerName("setTitleCell:");
public static final int sel_sharedSpellCheckerExists = sel_registerName("sharedSpellCheckerExists");
public static final int sel_locationForSubmenu_1 = sel_registerName("locationForSubmenu:");
public static final int sel_nodesForXPath_1error_1 = sel_registerName("nodesForXPath:error:");
public static final int sel_setHasVerticalRuler_1 = sel_registerName("setHasVerticalRuler:");
public static final int sel_controlHighlightColor = sel_registerName("controlHighlightColor");
public static final int sel_rowSpan = sel_registerName("rowSpan");
public static final int sel_decodeObject = sel_registerName("decodeObject");
public static final int sel_fileHandleForReadingAtPath_1 = sel_registerName("fileHandleForReadingAtPath:");
public static final int sel_didLoadBytes_1loadComplete_1 = sel_registerName("didLoadBytes:loadComplete:");
public static final int sel_renewRows_1columns_1 = sel_registerName("renewRows:columns:");
public static final int sel_performKeyEquivalent_1 = sel_registerName("performKeyEquivalent:");
public static final int sel_windowDidResignKey_1 = sel_registerName("windowDidResignKey:");
public static final int sel_typeForKey_1 = sel_registerName("typeForKey:");
public static final int sel_selectedObjects = sel_registerName("selectedObjects");
public static final int sel_defaultPrinter = sel_registerName("defaultPrinter");
public static final int sel_colorWithPatternImage_1 = sel_registerName("colorWithPatternImage:");
public static final int sel_setAttributedAlternateTitle_1 = sel_registerName("setAttributedAlternateTitle:");
public static final int sel_setValue_1forKey_1 = sel_registerName("setValue:forKey:");
public static final int sel_drawInteriorWithFrame_1inView_1 = sel_registerName("drawInteriorWithFrame:inView:");
public static final int sel_copy_1 = sel_registerName("copy:");
public static final int sel_scanString_1intoString_1 = sel_registerName("scanString:intoString:");
public static final int sel_fileManager_1shouldProceedAfterError_1 = sel_registerName("fileManager:shouldProceedAfterError:");
public static final int sel_fileManager_1shouldRemoveItemAtPath_1 = sel_registerName("fileManager:shouldRemoveItemAtPath:");
public static final int sel_removeSavedColumnsWithAutosaveName_1 = sel_registerName("removeSavedColumnsWithAutosaveName:");
public static final int sel_numberWithUnsignedInteger_1 = sel_registerName("numberWithUnsignedInteger:");
public static final int sel_rulerMarkersForTextView_1paragraphStyle_1ruler_1 = sel_registerName("rulerMarkersForTextView:paragraphStyle:ruler:");
public static final int sel_layoutRectForTextBlock_1atIndex_1effectiveRange_1 = sel_registerName("layoutRectForTextBlock:atIndex:effectiveRange:");
public static final int sel_maxPossiblePositionOfDividerAtIndex_1 = sel_registerName("maxPossiblePositionOfDividerAtIndex:");
public static final int sel_removePort_1forMode_1 = sel_registerName("removePort:forMode:");
public static final int sel_drawHashMarksAndLabelsInRect_1 = sel_registerName("drawHashMarksAndLabelsInRect:");
public static final int sel_control_1textView_1doCommandBySelector_1 = sel_registerName("control:textView:doCommandBySelector:");
public static final int sel_getLineFragmentRect_1usedRect_1remainingRect_1forStartingGlyphAtIndex_1proposedRect_1lineSpacing_1paragraphSpacingBefore_1paragraphSpacingAfter_1 = sel_registerName("getLineFragmentRect:usedRect:remainingRect:forStartingGlyphAtIndex:proposedRect:lineSpacing:paragraphSpacingBefore:paragraphSpacingAfter:");
public static final int sel_textContainerInset = sel_registerName("textContainerInset");
public static final int sel_positionsForCompositeSequence_1numberOfGlyphs_1pointArray_1 = sel_registerName("positionsForCompositeSequence:numberOfGlyphs:pointArray:");
public static final int sel_stringByAppendingPathComponent_1 = sel_registerName("stringByAppendingPathComponent:");
public static final int sel_application_1printFiles_1 = sel_registerName("application:printFiles:");
public static final int sel_scanInt_1 = sel_registerName("scanInt:");
public static final int sel_operators = sel_registerName("operators");
public static final int sel_fireDate = sel_registerName("fireDate");
public static final int sel_isExternal = sel_registerName("isExternal");
public static final int sel_setImagePosition_1 = sel_registerName("setImagePosition:");
public static final int sel_predicateWithFormat_1arguments_1 = sel_registerName("predicateWithFormat:arguments:");
public static final int sel_stopSpeaking = sel_registerName("stopSpeaking");
public static final int sel_contentWidthValueType = sel_registerName("contentWidthValueType");
public static final int sel_paddingPosition = sel_registerName("paddingPosition");
public static final int sel_removeLastObject = sel_registerName("removeLastObject");
public static final int sel_stringByReplacingCharactersInRange_1withString_1 = sel_registerName("stringByReplacingCharactersInRange:withString:");
public static final int sel_pointerValue = sel_registerName("pointerValue");
public static final int sel_setTruncatesLastVisibleLine_1 = sel_registerName("setTruncatesLastVisibleLine:");
public static final int sel_URLHandleResourceDidBeginLoading_1 = sel_registerName("URLHandleResourceDidBeginLoading:");
public static final int sel_valueForKeyPath_1 = sel_registerName("valueForKeyPath:");
public static final int sel_setPeriodicDelay_1interval_1 = sel_registerName("setPeriodicDelay:interval:");
public static final int sel_imageRepWithCIImage_1 = sel_registerName("imageRepWithCIImage:");
public static final int sel_wantsNotificationForMarkedText = sel_registerName("wantsNotificationForMarkedText");
public static final int sel_rectForPart_1 = sel_registerName("rectForPart:");
public static final int sel_setWeekday_1 = sel_registerName("setWeekday:");
public static final int sel_streamStatus = sel_registerName("streamStatus");
public static final int sel_containsPoint_1 = sel_registerName("containsPoint:");
public static final int sel_underlineThickness = sel_registerName("underlineThickness");
public static final int sel_allObjects = sel_registerName("allObjects");
public static final int sel_characters = sel_registerName("characters");
public static final int sel_outlineViewSelectionIsChanging_1 = sel_registerName("outlineViewSelectionIsChanging:");
public static final int sel_netServiceBrowser_1didNotSearch_1 = sel_registerName("netServiceBrowser:didNotSearch:");
public static final int sel_poolCountHighWaterMark = sel_registerName("poolCountHighWaterMark");
public static final int sel_setColorSpaceName_1 = sel_registerName("setColorSpaceName:");
public static final int sel_graphicsPort = sel_registerName("graphicsPort");
public static final int sel_fontDescriptorWithName_1matrix_1 = sel_registerName("fontDescriptorWithName:matrix:");
public static final int sel_setSelectable_1 = sel_registerName("setSelectable:");
public static final int sel_scriptErrorOffendingObjectDescriptor = sel_registerName("scriptErrorOffendingObjectDescriptor");
public static final int sel_resizingMask = sel_registerName("resizingMask");
public static final int sel_canHandleRequest_1 = sel_registerName("canHandleRequest:");
public static final int sel_imageRepWithPasteboard_1 = sel_registerName("imageRepWithPasteboard:");
public static final int sel_stopQuery = sel_registerName("stopQuery");
public static final int sel_dataWithBytes_1length_1 = sel_registerName("dataWithBytes:length:");
public static final int sel_setCachesBezierPath_1 = sel_registerName("setCachesBezierPath:");
public static final int sel_arrayForKey_1 = sel_registerName("arrayForKey:");
public static final int sel_cell = sel_registerName("cell");
public static final int sel_dealloc = sel_registerName("dealloc");
public static final int sel_constrainScrollPoint_1 = sel_registerName("constrainScrollPoint:");
public static final int sel_printSettings = sel_registerName("printSettings");
public static final int sel_autoresizesOutlineColumn = sel_registerName("autoresizesOutlineColumn");
public static final int sel_setFont_1range_1 = sel_registerName("setFont:range:");
public static final int sel_limitDateForMode_1 = sel_registerName("limitDateForMode:");
public static final int sel_stroke = sel_registerName("stroke");
public static final int sel_parser_1parseErrorOccurred_1 = sel_registerName("parser:parseErrorOccurred:");
public static final int sel_sendsActionOnEndEditing = sel_registerName("sendsActionOnEndEditing");
public static final int sel_toggleGrammarChecking_1 = sel_registerName("toggleGrammarChecking:");
public static final int sel_acceptsBinary = sel_registerName("acceptsBinary");
public static final int sel_indexLessThanIndex_1 = sel_registerName("indexLessThanIndex:");
public static final int sel_setCollapsesBorders_1 = sel_registerName("setCollapsesBorders:");
public static final int sel_setTimeoutInterval_1 = sel_registerName("setTimeoutInterval:");
public static final int sel_setNeedsDisplayInRect_1avoidAdditionalLayout_1 = sel_registerName("setNeedsDisplayInRect:avoidAdditionalLayout:");
public static final int sel_encodeWithCoder_1 = sel_registerName("encodeWithCoder:");
public static final int sel_compositeToPoint_1operation_1 = sel_registerName("compositeToPoint:operation:");
public static final int sel_textView_1doubleClickedOnCell_1inRect_1atIndex_1 = sel_registerName("textView:doubleClickedOnCell:inRect:atIndex:");
public static final int sel_setAlternateTitleWithMnemonic_1 = sel_registerName("setAlternateTitleWithMnemonic:");
public static final int sel_minimumSignificantDigits = sel_registerName("minimumSignificantDigits");
public static final int sel_stackSize = sel_registerName("stackSize");
public static final int sel_setLayoutManager_1 = sel_registerName("setLayoutManager:");
public static final int sel_image_1didLoadRepresentationHeader_1 = sel_registerName("image:didLoadRepresentationHeader:");
public static final int sel_depth = sel_registerName("depth");
public static final int sel_setTypesetter_1 = sel_registerName("setTypesetter:");
public static final int sel_isSessionOnly = sel_registerName("isSessionOnly");
public static final int sel_performFindPanelAction_1 = sel_registerName("performFindPanelAction:");
public static final int sel_fileManager_1shouldProceedAfterError_1removingItemAtPath_1 = sel_registerName("fileManager:shouldProceedAfterError:removingItemAtPath:");
public static final int sel_paperSize = sel_registerName("paperSize");
public static final int sel_changeColor_1 = sel_registerName("changeColor:");
public static final int sel_unarchiverDidFinish_1 = sel_registerName("unarchiverDidFinish:");
public static final int sel_initWithObjectsAndKeys_1 = sel_registerName("initWithObjectsAndKeys:");
public static final int sel_notationDeclarationForName_1 = sel_registerName("notationDeclarationForName:");
public static final int sel_maximumSignificantDigits = sel_registerName("maximumSignificantDigits");
public static final int sel_receivesCredentialSecurely = sel_registerName("receivesCredentialSecurely");
public static final int sel_setObjectBeingTested_1 = sel_registerName("setObjectBeingTested:");
public static final int sel_cacheDepthMatchesImageDepth = sel_registerName("cacheDepthMatchesImageDepth");
public static final int sel_hasPropertyForKey_1 = sel_registerName("hasPropertyForKey:");
public static final int sel_draggingDestinationWindow = sel_registerName("draggingDestinationWindow");
public static final int sel_typeCodeValue = sel_registerName("typeCodeValue");
public static final int sel_portForName_1 = sel_registerName("portForName:");
public static final int sel_getCString_1maxLength_1encoding_1 = sel_registerName("getCString:maxLength:encoding:");
public static final int sel_attributedString = sel_registerName("attributedString");
public static final int sel_fileExistsAtPath_1isDirectory_1 = sel_registerName("fileExistsAtPath:isDirectory:");
public static final int sel_updateRuler = sel_registerName("updateRuler");
public static final int sel_print_1 = sel_registerName("print:");
public static final int sel_setFrameSize_1 = sel_registerName("setFrameSize:");
public static final int sel_dataFromPropertyList_1format_1errorDescription_1 = sel_registerName("dataFromPropertyList:format:errorDescription:");
public static final int sel_initWithContentsOfURL_1ofType_1 = sel_registerName("initWithContentsOfURL:ofType:");
public static final int sel_replaceValueAtIndex_1inPropertyWithKey_1withValue_1 = sel_registerName("replaceValueAtIndex:inPropertyWithKey:withValue:");
public static final int sel_formIntersectionWithCharacterSet_1 = sel_registerName("formIntersectionWithCharacterSet:");
public static final int sel_renderingMode = sel_registerName("renderingMode");
public static final int sel_viewsNeedDisplay = sel_registerName("viewsNeedDisplay");
public static final int sel_lineFragmentRectForProposedRect_1sweepDirection_1movementDirection_1remainingRect_1 = sel_registerName("lineFragmentRectForProposedRect:sweepDirection:movementDirection:remainingRect:");
public static final int sel_rulerAccessoryViewForTextView_1paragraphStyle_1ruler_1enabled_1 = sel_registerName("rulerAccessoryViewForTextView:paragraphStyle:ruler:enabled:");
public static final int sel_initWithArray_1copyItems_1 = sel_registerName("initWithArray:copyItems:");
public static final int sel_ensureLayoutForGlyphRange_1 = sel_registerName("ensureLayoutForGlyphRange:");
public static final int sel_availableLocaleIdentifiers = sel_registerName("availableLocaleIdentifiers");
public static final int sel_viewDidHide = sel_registerName("viewDidHide");
public static final int sel_setShouldReportNamespacePrefixes_1 = sel_registerName("setShouldReportNamespacePrefixes:");
public static final int sel_runToolbarCustomizationPalette_1 = sel_registerName("runToolbarCustomizationPalette:");
public static final int sel_roundingBehavior = sel_registerName("roundingBehavior");
public static final int sel_expressionForEvaluatedObject = sel_registerName("expressionForEvaluatedObject");
public static final int sel_rulerView_1handleMouseDown_1 = sel_registerName("rulerView:handleMouseDown:");
public static final int sel_scanCharactersFromSet_1intoString_1 = sel_registerName("scanCharactersFromSet:intoString:");
public static final int sel_applicationDidChangeScreenParameters_1 = sel_registerName("applicationDidChangeScreenParameters:");
public static final int sel_textView_1clickedOnCell_1inRect_1 = sel_registerName("textView:clickedOnCell:inRect:");
public static final int sel_decodeDoubleForKey_1 = sel_registerName("decodeDoubleForKey:");
public static final int sel_URLHandle_1resourceDidFailLoadingWithReason_1 = sel_registerName("URLHandle:resourceDidFailLoadingWithReason:");
public static final int sel_setCountKeyPath_1 = sel_registerName("setCountKeyPath:");
public static final int sel_showContextHelpForObject_1locationHint_1 = sel_registerName("showContextHelpForObject:locationHint:");
public static final int sel_setData_1forType_1 = sel_registerName("setData:forType:");
public static final int sel_setPixel_1atX_1y_1 = sel_registerName("setPixel:atX:y:");
public static final int sel_setReceiversSpecifier_1 = sel_registerName("setReceiversSpecifier:");
public static final int sel_postNotificationName_1object_1userInfo_1 = sel_registerName("postNotificationName:object:userInfo:");
public static final int sel_rowForItem_1 = sel_registerName("rowForItem:");
public static final int sel_fetch_1 = sel_registerName("fetch:");
public static final int sel_propertyList_1isValidForFormat_1 = sel_registerName("propertyList:isValidForFormat:");
public static final int sel_configureAsServer = sel_registerName("configureAsServer");
public static final int sel_setAllowsColumnReordering_1 = sel_registerName("setAllowsColumnReordering:");
public static final int sel_charValue = sel_registerName("charValue");
public static final int sel_setInsertionClassDescription_1 = sel_registerName("setInsertionClassDescription:");
public static final int sel_cyanColor = sel_registerName("cyanColor");
public static final int sel_lockWhenCondition_1 = sel_registerName("lockWhenCondition:");
public static final int sel_cacheImageInRect_1 = sel_registerName("cacheImageInRect:");
public static final int sel_keyboardFocusIndicatorColor = sel_registerName("keyboardFocusIndicatorColor");
public static final int sel_hasUndoManager = sel_registerName("hasUndoManager");
public static final int sel_drawInBezierPath_1relativeCenterPosition_1 = sel_registerName("drawInBezierPath:relativeCenterPosition:");
public static final int sel_decimalNumberByAdding_1 = sel_registerName("decimalNumberByAdding:");
public static final int sel_initWithDescriptorType_1data_1 = sel_registerName("initWithDescriptorType:data:");
public static final int sel_isUndoing = sel_registerName("isUndoing");
public static final int sel_boolForKey_1 = sel_registerName("boolForKey:");
public static final int sel_localizedCatalogNameComponent = sel_registerName("localizedCatalogNameComponent");
public static final int sel_representations = sel_registerName("representations");
public static final int sel_expressionValueWithObject_1context_1 = sel_registerName("expressionValueWithObject:context:");
public static final int sel_viewWillMoveToSuperview_1 = sel_registerName("viewWillMoveToSuperview:");
public static final int sel_alphaValue = sel_registerName("alphaValue");
public static final int sel_learnWord_1 = sel_registerName("learnWord:");
public static final int sel_releaseGlobally = sel_registerName("releaseGlobally");
public static final int sel_defaultCompletionDelay = sel_registerName("defaultCompletionDelay");
public static final int sel_control_1textShouldEndEditing_1 = sel_registerName("control:textShouldEndEditing:");
public static final int sel_alertWithMessageText_1defaultButton_1alternateButton_1otherButton_1informativeTextWithFormat_1 = sel_registerName("alertWithMessageText:defaultButton:alternateButton:otherButton:informativeTextWithFormat:");
public static final int sel_control_1textShouldBeginEditing_1 = sel_registerName("control:textShouldBeginEditing:");
public static final int sel_sizeMode = sel_registerName("sizeMode");
public static final int sel_representedURL = sel_registerName("representedURL");
public static final int sel_fileHFSCreatorCode = sel_registerName("fileHFSCreatorCode");
public static final int sel_removeDependency_1 = sel_registerName("removeDependency:");
public static final int sel_parentForItem_1 = sel_registerName("parentForItem:");
public static final int sel_adjustPageHeightNew_1top_1bottom_1limit_1 = sel_registerName("adjustPageHeightNew:top:bottom:limit:");
public static final int sel_showPanels = sel_registerName("showPanels");
public static final int sel_alwaysUsesMultipleValuesMarker = sel_registerName("alwaysUsesMultipleValuesMarker");
public static final int sel_setUpFieldEditorAttributes_1 = sel_registerName("setUpFieldEditorAttributes:");
public static final int sel_comboBoxCell_1completedString_1 = sel_registerName("comboBoxCell:completedString:");
public static final int sel_null = sel_registerName("null");
public static final int sel_setTextAttributesForNil_1 = sel_registerName("setTextAttributesForNil:");
public static final int sel_currencyGroupingSeparator = sel_registerName("currencyGroupingSeparator");
public static final int sel_toolbarSelectableItemIdentifiers_1 = sel_registerName("toolbarSelectableItemIdentifiers:");
public static final int sel_size = sel_registerName("size");
public static final int sel_fileModificationDate = sel_registerName("fileModificationDate");
public static final int sel_timestamp = sel_registerName("timestamp");
public static final int sel_canonicalRequestForRequest_1 = sel_registerName("canonicalRequestForRequest:");
public static final int sel_moveBackwardAndModifySelection_1 = sel_registerName("moveBackwardAndModifySelection:");
public static final int sel_frameOfColumn_1 = sel_registerName("frameOfColumn:");
public static final int sel_setRefusesFirstResponder_1 = sel_registerName("setRefusesFirstResponder:");
public static final int sel_hasDynamicDepthLimit = sel_registerName("hasDynamicDepthLimit");
public static final int sel_decodeIntForKey_1 = sel_registerName("decodeIntForKey:");
public static final int sel_autoupdatingCurrentLocale = sel_registerName("autoupdatingCurrentLocale");
public static final int sel_transformBezierPath_1 = sel_registerName("transformBezierPath:");
public static final int sel_registerPort_1name_1nameServerPortNumber_1 = sel_registerName("registerPort:name:nameServerPortNumber:");
public static final int sel_contentWidth = sel_registerName("contentWidth");
public static final int sel_noteUserDefaultsChanged = sel_registerName("noteUserDefaultsChanged");
public static final int sel_orangeColor = sel_registerName("orangeColor");
public static final int sel_lastItem = sel_registerName("lastItem");
public static final int sel_setButtonType_1 = sel_registerName("setButtonType:");
public static final int sel_initWithContentsOfURL_1ofType_1error_1 = sel_registerName("initWithContentsOfURL:ofType:error:");
public static final int sel_rowTemplates = sel_registerName("rowTemplates");
public static final int sel_setEnabled_1forSegment_1 = sel_registerName("setEnabled:forSegment:");
public static final int sel_avoidsEmptySelection = sel_registerName("avoidsEmptySelection");
public static final int sel_encodeInt_1forKey_1 = sel_registerName("encodeInt:forKey:");
public static final int sel_dictionaryWithValuesForKeys_1 = sel_registerName("dictionaryWithValuesForKeys:");
public static final int sel_start_1 = sel_registerName("start:");
public static final int sel_sortUsingDescriptors_1 = sel_registerName("sortUsingDescriptors:");
public static final int sel_currentParagraphStyle = sel_registerName("currentParagraphStyle");
public static final int sel_treeNodeWithRepresentedObject_1 = sel_registerName("treeNodeWithRepresentedObject:");
public static final int sel_tableColumnWithIdentifier_1 = sel_registerName("tableColumnWithIdentifier:");
public static final int sel_attributedTitle = sel_registerName("attributedTitle");
public static final int sel_setEntryType_1 = sel_registerName("setEntryType:");
public static final int sel_pixelFormat = sel_registerName("pixelFormat");
public static final int sel_temporaryAttribute_1atCharacterIndex_1longestEffectiveRange_1inRange_1 = sel_registerName("temporaryAttribute:atCharacterIndex:longestEffectiveRange:inRange:");
public static final int sel_treatsFilePackagesAsDirectories = sel_registerName("treatsFilePackagesAsDirectories");
public static final int sel_glyphAtIndex_1 = sel_registerName("glyphAtIndex:");
public static final int sel_titleWidth_1 = sel_registerName("titleWidth:");
public static final int sel_setWords_1 = sel_registerName("setWords:");
public static final int sel_glyphIndexForPoint_1inTextContainer_1 = sel_registerName("glyphIndexForPoint:inTextContainer:");
public static final int sel_alternateSelectedControlColor = sel_registerName("alternateSelectedControlColor");
public static final int sel_sizeToCells = sel_registerName("sizeToCells");
public static final int sel_flushWindow = sel_registerName("flushWindow");
public static final int sel_URLAtIndex_1effectiveRange_1 = sel_registerName("URLAtIndex:effectiveRange:");
public static final int sel_isSimpleRectangularTextContainer = sel_registerName("isSimpleRectangularTextContainer");
public static final int sel_dragImageForRowsWithIndexes_1tableColumns_1event_1offset_1 = sel_registerName("dragImageForRowsWithIndexes:tableColumns:event:offset:");
public static final int sel_takeDoubleValueFrom_1 = sel_registerName("takeDoubleValueFrom:");
public static final int sel_selectItem_1 = sel_registerName("selectItem:");
public static final int sel_isMultiple = sel_registerName("isMultiple");
public static final int sel_arrangeInFront_1 = sel_registerName("arrangeInFront:");
public static final int sel_defaultFocusRingType = sel_registerName("defaultFocusRingType");
public static final int sel_componentsSeparatedByString_1 = sel_registerName("componentsSeparatedByString:");
public static final int sel_calendar = sel_registerName("calendar");
public static final int sel_openFile_1withApplication_1 = sel_registerName("openFile:withApplication:");
public static final int sel_moveWordBackward_1 = sel_registerName("moveWordBackward:");
public static final int sel_getCharacters_1 = sel_registerName("getCharacters:");
public static final int sel_initWithInt_1 = sel_registerName("initWithInt:");
public static final int sel_initWithReceivePort_1sendPort_1components_1 = sel_registerName("initWithReceivePort:sendPort:components:");
public static final int sel_setBool_1forKey_1 = sel_registerName("setBool:forKey:");
public static final int sel_keyPathsForValuesAffectingValueForKey_1 = sel_registerName("keyPathsForValuesAffectingValueForKey:");
public static final int sel_saveDocumentTo_1 = sel_registerName("saveDocumentTo:");
public static final int sel_knobRectFlipped_1 = sel_registerName("knobRectFlipped:");
public static final int sel_isEqualToAttributedString_1 = sel_registerName("isEqualToAttributedString:");
public static final int sel_indexOfResult_1 = sel_registerName("indexOfResult:");
public static final int sel_attributesForVoice_1 = sel_registerName("attributesForVoice:");
public static final int sel_encodeConditionalObject_1 = sel_registerName("encodeConditionalObject:");
public static final int sel_pixelBufferCubeMapFace = sel_registerName("pixelBufferCubeMapFace");
public static final int sel_index = sel_registerName("index");
public static final int sel_transactionID = sel_registerName("transactionID");
public static final int sel_displayRectIgnoringOpacity_1 = sel_registerName("displayRectIgnoringOpacity:");
public static final int sel_setKeyboardFocusRingNeedsDisplayInRect_1 = sel_registerName("setKeyboardFocusRingNeedsDisplayInRect:");
public static final int sel_invalidateLayoutForCharacterRange_1isSoft_1actualCharacterRange_1 = sel_registerName("invalidateLayoutForCharacterRange:isSoft:actualCharacterRange:");
public static final int sel_contentsEqualAtPath_1andPath_1 = sel_registerName("contentsEqualAtPath:andPath:");
public static final int sel_cancelOperation_1 = sel_registerName("cancelOperation:");
public static final int sel_accessibilityAttributeValue_1 = sel_registerName("accessibilityAttributeValue:");
public static final int sel_windowNibPath = sel_registerName("windowNibPath");
public static final int sel_saveToFile_1saveOperation_1delegate_1didSaveSelector_1contextInfo_1 = sel_registerName("saveToFile:saveOperation:delegate:didSaveSelector:contextInfo:");
public static final int sel_setMixedStateImage_1 = sel_registerName("setMixedStateImage:");
public static final int sel_predicateWithFormat_1 = sel_registerName("predicateWithFormat:");
public static final int sel_initWithSendPort_1receivePort_1components_1 = sel_registerName("initWithSendPort:receivePort:components:");
public static final int sel_setRecentsAutosaveName_1 = sel_registerName("setRecentsAutosaveName:");
public static final int sel_autosavesConfiguration = sel_registerName("autosavesConfiguration");
public static final int sel_setSubitems_1 = sel_registerName("setSubitems:");
public static final int sel_setPathStyle_1 = sel_registerName("setPathStyle:");
public static final int sel_startAnimation_1 = sel_registerName("startAnimation:");
public static final int sel_bezierPath = sel_registerName("bezierPath");
public static final int sel_archiver_1willEncodeObject_1 = sel_registerName("archiver:willEncodeObject:");
public static final int sel_acceptInputForMode_1beforeDate_1 = sel_registerName("acceptInputForMode:beforeDate:");
public static final int sel_setTearOffMenuRepresentation_1 = sel_registerName("setTearOffMenuRepresentation:");
public static final int sel_writableTypes = sel_registerName("writableTypes");
public static final int sel_domain = sel_registerName("domain");
public static final int sel_removeDocument_1 = sel_registerName("removeDocument:");
public static final int sel_showsBaselineSeparator = sel_registerName("showsBaselineSeparator");
public static final int sel_dragImageForRows_1event_1dragImageOffset_1 = sel_registerName("dragImageForRows:event:dragImageOffset:");
public static final int sel_table = sel_registerName("table");
public static final int sel_initRegularFileWithContents_1 = sel_registerName("initRegularFileWithContents:");
public static final int sel_add_1 = sel_registerName("add:");
public static final int sel_stateImageWidth = sel_registerName("stateImageWidth");
public static final int sel_URLProtocol_1didReceiveAuthenticationChallenge_1 = sel_registerName("URLProtocol:didReceiveAuthenticationChallenge:");
public static final int sel_imageAndTitleWidth = sel_registerName("imageAndTitleWidth");
public static final int sel_trackingAreas = sel_registerName("trackingAreas");
public static final int sel_initRecordDescriptor = sel_registerName("initRecordDescriptor");
public static final int sel_itemIdentifier = sel_registerName("itemIdentifier");
public static final int sel_doubleClickAtIndex_1 = sel_registerName("doubleClickAtIndex:");
public static final int sel_fixesAttributesLazily = sel_registerName("fixesAttributesLazily");
public static final int sel_netServiceBrowserWillSearch_1 = sel_registerName("netServiceBrowserWillSearch:");
public static final int sel_textureInternalFormat = sel_registerName("textureInternalFormat");
public static final int sel_valueWithSize_1 = sel_registerName("valueWithSize:");
public static final int sel_setVerticalScroller_1 = sel_registerName("setVerticalScroller:");
public static final int sel_absolutePathForAppBundleWithIdentifier_1 = sel_registerName("absolutePathForAppBundleWithIdentifier:");
public static final int sel_contentMinSize = sel_registerName("contentMinSize");
public static final int sel_persistentDomainForName_1 = sel_registerName("persistentDomainForName:");
public static final int sel_cellAtIndex_1 = sel_registerName("cellAtIndex:");
public static final int sel_setWithArray_1 = sel_registerName("setWithArray:");
public static final int sel_resetCursorRects = sel_registerName("resetCursorRects");
public static final int sel_imageRepClassForFileType_1 = sel_registerName("imageRepClassForFileType:");
public static final int sel_setContainerIsObjectBeingTested_1 = sel_registerName("setContainerIsObjectBeingTested:");
public static final int sel_removeProgressMark_1 = sel_registerName("removeProgressMark:");
public static final int sel_hitTestForEvent_1inRect_1ofView_1 = sel_registerName("hitTestForEvent:inRect:ofView:");
public static final int sel_listDescriptor = sel_registerName("listDescriptor");
public static final int sel_rangeOfUnit_1startDate_1interval_1forDate_1 = sel_registerName("rangeOfUnit:startDate:interval:forDate:");
public static final int sel_checkSpaceForParts = sel_registerName("checkSpaceForParts");
public static final int sel_availableVoices = sel_registerName("availableVoices");
public static final int sel_PMPrintSettings = sel_registerName("PMPrintSettings");
public static final int sel_nonBaseCharacterSet = sel_registerName("nonBaseCharacterSet");
public static final int sel_launchedTaskWithLaunchPath_1arguments_1 = sel_registerName("launchedTaskWithLaunchPath:arguments:");
public static final int sel_clearCurrentContext = sel_registerName("clearCurrentContext");
public static final int sel_applicationWillUpdate_1 = sel_registerName("applicationWillUpdate:");
public static final int sel_addFontTrait_1 = sel_registerName("addFontTrait:");
public static final int sel_arrayByAddingObjectsFromArray_1 = sel_registerName("arrayByAddingObjectsFromArray:");
public static final int sel_abortParsing = sel_registerName("abortParsing");
public static final int sel_subviews = sel_registerName("subviews");
public static final int sel_initWithContainerClassDescription_1containerSpecifier_1key_1uniqueID_1 = sel_registerName("initWithContainerClassDescription:containerSpecifier:key:uniqueID:");
public static final int sel_acceptableDragTypes = sel_registerName("acceptableDragTypes");
public static final int sel_managedObjectContext = sel_registerName("managedObjectContext");
public static final int sel_resizeWithMagnification_1 = sel_registerName("resizeWithMagnification:");
public static final int sel_setUsesFindPanel_1 = sel_registerName("setUsesFindPanel:");
public static final int sel_application_1printFiles_1withSettings_1showPrintPanels_1 = sel_registerName("application:printFiles:withSettings:showPrintPanels:");
public static final int sel_loadAndReturnError_1 = sel_registerName("loadAndReturnError:");
public static final int sel_initWithLeftExpressions_1rightExpressions_1modifier_1operators_1options_1 = sel_registerName("initWithLeftExpressions:rightExpressions:modifier:operators:options:");
public static final int sel_addSelectionIndexes_1 = sel_registerName("addSelectionIndexes:");
public static final int sel_initWithBitmapDataPlanes_1pixelsWide_1pixelsHigh_1bitsPerSample_1samplesPerPixel_1hasAlpha_1isPlanar_1colorSpaceName_1bitmapFormat_1bytesPerRow_1bitsPerPixel_1 = sel_registerName("initWithBitmapDataPlanes:pixelsWide:pixelsHigh:bitsPerSample:samplesPerPixel:hasAlpha:isPlanar:colorSpaceName:bitmapFormat:bytesPerRow:bitsPerPixel:");
public static final int sel_initToFileAtPath_1append_1 = sel_registerName("initToFileAtPath:append:");
public static final int sel_currencyDecimalSeparator = sel_registerName("currencyDecimalSeparator");
public static final int sel_expansionFrameWithFrame_1inView_1 = sel_registerName("expansionFrameWithFrame:inView:");
public static final int sel_HTTPShouldHandleCookies = sel_registerName("HTTPShouldHandleCookies");
public static final int sel_rearrangeObjects = sel_registerName("rearrangeObjects");
public static final int sel_graphicsContextWithWindow_1 = sel_registerName("graphicsContextWithWindow:");
public static final int sel_stringWithCapacity_1 = sel_registerName("stringWithCapacity:");
public static final int sel_results = sel_registerName("results");
public static final int sel_loadFileWrapperRepresentation_1ofType_1 = sel_registerName("loadFileWrapperRepresentation:ofType:");
public static final int sel_secondsFromGMTForDate_1 = sel_registerName("secondsFromGMTForDate:");
public static final int sel_clearStopAnimation = sel_registerName("clearStopAnimation");
public static final int sel_numberWithShort_1 = sel_registerName("numberWithShort:");
public static final int sel_setHorizontallyCentered_1 = sel_registerName("setHorizontallyCentered:");
public static final int sel_setNeedsDisplayInRect_1 = sel_registerName("setNeedsDisplayInRect:");
public static final int sel_objectDidBeginEditing_1 = sel_registerName("objectDidBeginEditing:");
public static final int sel_rightMouseDown_1 = sel_registerName("rightMouseDown:");
public static final int sel_data2 = sel_registerName("data2");
public static final int sel_initWithCalendarIdentifier_1 = sel_registerName("initWithCalendarIdentifier:");
public static final int sel_containsValueForKey_1 = sel_registerName("containsValueForKey:");
public static final int sel_result = sel_registerName("result");
public static final int sel_printDocument_1 = sel_registerName("printDocument:");
public static final int sel_addSuiteNamed_1 = sel_registerName("addSuiteNamed:");
public static final int sel_deleteCookie_1 = sel_registerName("deleteCookie:");
public static final int sel_isLocationRequiredToCreateForKey_1 = sel_registerName("isLocationRequiredToCreateForKey:");
public static final int sel_saveGraphicsState = sel_registerName("saveGraphicsState");
public static final int sel_getInfoForFile_1application_1type_1 = sel_registerName("getInfoForFile:application:type:");
public static final int sel_HTTPBodyStream = sel_registerName("HTTPBodyStream");
public static final int sel_accessibilityParameterizedAttributeNames = sel_registerName("accessibilityParameterizedAttributeNames");
public static final int sel_objectForKey_1 = sel_registerName("objectForKey:");
public static final int sel_classForArchiver = sel_registerName("classForArchiver");
public static final int sel_allBundles = sel_registerName("allBundles");
public static final int sel_rangeOfComposedCharacterSequenceAtIndex_1 = sel_registerName("rangeOfComposedCharacterSequenceAtIndex:");
public static final int sel_allowsDuplicatesInToolbar = sel_registerName("allowsDuplicatesInToolbar");
public static final int sel_speechSynthesizer_1didEncounterSyncMessage_1 = sel_registerName("speechSynthesizer:didEncounterSyncMessage:");
public static final int sel_performSelector_1withObject_1afterDelay_1inModes_1 = sel_registerName("performSelector:withObject:afterDelay:inModes:");
public static final int sel_setScalesWhenResized_1 = sel_registerName("setScalesWhenResized:");
public static final int sel_fileWrappers = sel_registerName("fileWrappers");
public static final int sel_setSubmenu_1 = sel_registerName("setSubmenu:");
public static final int sel_setSendsSearchStringImmediately_1 = sel_registerName("setSendsSearchStringImmediately:");
public static final int sel_movieUnfilteredPasteboardTypes = sel_registerName("movieUnfilteredPasteboardTypes");
public static final int sel_browser_1willDisplayCell_1atRow_1column_1 = sel_registerName("browser:willDisplayCell:atRow:column:");
public static final int sel_valueOfAttribute_1forResultAtIndex_1 = sel_registerName("valueOfAttribute:forResultAtIndex:");
public static final int sel_rightExpression = sel_registerName("rightExpression");
public static final int sel_moveNode_1toIndexPath_1 = sel_registerName("moveNode:toIndexPath:");
public static final int sel_insertionKey = sel_registerName("insertionKey");
public static final int sel_columnsAutosaveName = sel_registerName("columnsAutosaveName");
public static final int sel_connection_1didReceiveResponse_1 = sel_registerName("connection:didReceiveResponse:");
public static final int sel_delegate = sel_registerName("delegate");
public static final int sel_valueForHTTPHeaderField_1 = sel_registerName("valueForHTTPHeaderField:");
public static final int sel_requiredThickness = sel_registerName("requiredThickness");
public static final int sel_selectedCells = sel_registerName("selectedCells");
public static final int sel_setResizable_1 = sel_registerName("setResizable:");
public static final int sel_resizeRightCursor = sel_registerName("resizeRightCursor");
public static final int sel_arrayWithContentsOfURL_1 = sel_registerName("arrayWithContentsOfURL:");
public static final int sel_setEchosBullets_1 = sel_registerName("setEchosBullets:");
public static final int sel_outlineViewItemDidCollapse_1 = sel_registerName("outlineViewItemDidCollapse:");
public static final int sel_mutableSetValueForKey_1 = sel_registerName("mutableSetValueForKey:");
public static final int sel_initWithObjects_1forKeys_1count_1 = sel_registerName("initWithObjects:forKeys:count:");
public static final int sel_canBeDisabled = sel_registerName("canBeDisabled");
public static final int sel_selectTabViewItemWithIdentifier_1 = sel_registerName("selectTabViewItemWithIdentifier:");
public static final int sel_setLongEraSymbols_1 = sel_registerName("setLongEraSymbols:");
public static final int sel_displayRect_1 = sel_registerName("displayRect:");
public static final int sel_initRemoteWithProtocolFamily_1socketType_1protocol_1address_1 = sel_registerName("initRemoteWithProtocolFamily:socketType:protocol:address:");
public static final int sel_setQueuePriority_1 = sel_registerName("setQueuePriority:");
public static final int sel_initWithFileDescriptor_1closeOnDealloc_1 = sel_registerName("initWithFileDescriptor:closeOnDealloc:");
public static final int sel_comboBoxWillDismiss_1 = sel_registerName("comboBoxWillDismiss:");
public static final int sel_setMatchesOnMultipleResolution_1 = sel_registerName("setMatchesOnMultipleResolution:");
public static final int sel_connection = sel_registerName("connection");
public static final int sel_includedKeys = sel_registerName("includedKeys");
public static final int sel_writeToURL_1options_1error_1 = sel_registerName("writeToURL:options:error:");
public static final int sel_activeProcessorCount = sel_registerName("activeProcessorCount");
public static final int sel_countByEnumeratingWithState_1objects_1count_1 = sel_registerName("countByEnumeratingWithState:objects:count:");
public static final int sel_setTransformStruct_1 = sel_registerName("setTransformStruct:");
public static final int sel_setVeryShortWeekdaySymbols_1 = sel_registerName("setVeryShortWeekdaySymbols:");
public static final int sel_markerLocation = sel_registerName("markerLocation");
public static final int sel_widthForLayer_1edge_1 = sel_registerName("widthForLayer:edge:");
public static final int sel_transform = sel_registerName("transform");
public static final int sel_addSelectionIndexPaths_1 = sel_registerName("addSelectionIndexPaths:");
public static final int sel_removeRequestMode_1 = sel_registerName("removeRequestMode:");
public static final int sel_indexOfObject_1inRange_1 = sel_registerName("indexOfObject:inRange:");
public static final int sel_awakeAfterUsingCoder_1 = sel_registerName("awakeAfterUsingCoder:");
public static final int sel_setKnobProportion_1 = sel_registerName("setKnobProportion:");
public static final int sel_setAllowsUserCustomization_1 = sel_registerName("setAllowsUserCustomization:");
public static final int sel_setCurrentOperation_1 = sel_registerName("setCurrentOperation:");
public static final int sel_outlineView_1isGroupItem_1 = sel_registerName("outlineView:isGroupItem:");
public static final int sel_deleteGlyphsInRange_1 = sel_registerName("deleteGlyphsInRange:");
public static final int sel_setSelectedObjects_1 = sel_registerName("setSelectedObjects:");
public static final int sel_pathComponentCellAtPoint_1withFrame_1inView_1 = sel_registerName("pathComponentCellAtPoint:withFrame:inView:");
public static final int sel_outlineView_1acceptDrop_1item_1childIndex_1 = sel_registerName("outlineView:acceptDrop:item:childIndex:");
public static final int sel_setBackgroundColor_1 = sel_registerName("setBackgroundColor:");
public static final int sel_canSelectNext = sel_registerName("canSelectNext");
public static final int sel_encodeRect_1forKey_1 = sel_registerName("encodeRect:forKey:");
public static final int sel_resetCursorRect_1inView_1 = sel_registerName("resetCursorRect:inView:");
public static final int sel_resumeData = sel_registerName("resumeData");
public static final int sel_levelsOfUndo = sel_registerName("levelsOfUndo");
public static final int sel_objectIsForcedForKey_1 = sel_registerName("objectIsForcedForKey:");
public static final int sel_minSize = sel_registerName("minSize");
public static final int sel_indentationPerLevel = sel_registerName("indentationPerLevel");
public static final int sel_browserColumnConfigurationDidChange_1 = sel_registerName("browserColumnConfigurationDidChange:");
public static final int sel_startAnimation = sel_registerName("startAnimation");
public static final int sel_outlineView_1namesOfPromisedFilesDroppedAtDestination_1forDraggedItems_1 = sel_registerName("outlineView:namesOfPromisedFilesDroppedAtDestination:forDraggedItems:");
public static final int sel_setAlignment_1range_1 = sel_registerName("setAlignment:range:");
public static final int sel_zeroSymbol = sel_registerName("zeroSymbol");
public static final int sel_draggedImage_1beganAt_1 = sel_registerName("draggedImage:beganAt:");
public static final int sel_buttonMask = sel_registerName("buttonMask");
public static final int sel_frame = sel_registerName("frame");
public static final int sel_markers = sel_registerName("markers");
public static final int sel_initWithObjects_1count_1 = sel_registerName("initWithObjects:count:");
public static final int sel_unload = sel_registerName("unload");
public static final int sel_initForReadingWithData_1 = sel_registerName("initForReadingWithData:");
public static final int sel_year = sel_registerName("year");
public static final int sel_ruleEditor_1child_1forCriterion_1withRowType_1 = sel_registerName("ruleEditor:child:forCriterion:withRowType:");
public static final int sel_dayOfMonth = sel_registerName("dayOfMonth");
public static final int sel_colorUsingColorSpaceName_1 = sel_registerName("colorUsingColorSpaceName:");
public static final int sel_registerCoercer_1selector_1toConvertFromClass_1toClass_1 = sel_registerName("registerCoercer:selector:toConvertFromClass:toClass:");
public static final int sel_removeObject_1inRange_1 = sel_registerName("removeObject:inRange:");
public static final int sel_setFrameFromString_1 = sel_registerName("setFrameFromString:");
public static final int sel_canAdd = sel_registerName("canAdd");
public static final int sel_era = sel_registerName("era");
public static final int sel_expressionForSubquery_1usingIteratorVariable_1predicate_1 = sel_registerName("expressionForSubquery:usingIteratorVariable:predicate:");
public static final int sel_setAMSymbol_1 = sel_registerName("setAMSymbol:");
public static final int sel_groupedResults = sel_registerName("groupedResults");
public static final int sel_attributedStringValue = sel_registerName("attributedStringValue");
public static final int sel_enclosingScrollView = sel_registerName("enclosingScrollView");
public static final int sel_isEqualToNumber_1 = sel_registerName("isEqualToNumber:");
public static final int sel_mainBundle = sel_registerName("mainBundle");
public static final int sel_textContainerForGlyphAtIndex_1effectiveRange_1 = sel_registerName("textContainerForGlyphAtIndex:effectiveRange:");
public static final int sel_setUsesGroupingSeparator_1 = sel_registerName("setUsesGroupingSeparator:");
public static final int sel_pointerAtIndex_1 = sel_registerName("pointerAtIndex:");
public static final int sel_arrowsPosition = sel_registerName("arrowsPosition");
public static final int sel_panel_1compareFilename_1with_1caseSensitive_1 = sel_registerName("panel:compareFilename:with:caseSensitive:");
public static final int sel_drawSeparatorItemWithFrame_1inView_1 = sel_registerName("drawSeparatorItemWithFrame:inView:");
public static final int sel_objectsByEvaluatingWithContainers_1 = sel_registerName("objectsByEvaluatingWithContainers:");
public static final int sel_textTabForGlyphLocation_1writingDirection_1maxLocation_1 = sel_registerName("textTabForGlyphLocation:writingDirection:maxLocation:");
public static final int sel_fontDescriptor = sel_registerName("fontDescriptor");
public static final int sel_validAttributesForMarkedText = sel_registerName("validAttributesForMarkedText");
public static final int sel_scriptingEndsWith_1 = sel_registerName("scriptingEndsWith:");
public static final int sel_scrollViaScroller_1 = sel_registerName("scrollViaScroller:");
public static final int sel_setAlwaysUsesMultipleValuesMarker_1 = sel_registerName("setAlwaysUsesMultipleValuesMarker:");
public static final int sel_attributeKeys = sel_registerName("attributeKeys");
public static final int sel_darkGrayColor = sel_registerName("darkGrayColor");
public static final int sel_setExtensionHidden_1 = sel_registerName("setExtensionHidden:");
public static final int sel_drawInRect_1withAttributes_1 = sel_registerName("drawInRect:withAttributes:");
public static final int sel_selectTabViewItemAtIndex_1 = sel_registerName("selectTabViewItemAtIndex:");
public static final int sel_contentRectForFrameRect_1 = sel_registerName("contentRectForFrameRect:");
public static final int sel_setParagraphSpacingBefore_1 = sel_registerName("setParagraphSpacingBefore:");
public static final int sel_minDate = sel_registerName("minDate");
public static final int sel_isARepeat = sel_registerName("isARepeat");
public static final int sel_selectedTabViewItem = sel_registerName("selectedTabViewItem");
public static final int sel_minusHashTable_1 = sel_registerName("minusHashTable:");
public static final int sel_preferredLocalizationsFromArray_1forPreferences_1 = sel_registerName("preferredLocalizationsFromArray:forPreferences:");
public static final int sel_setTextBlocks_1 = sel_registerName("setTextBlocks:");
public static final int sel_writePrintInfo = sel_registerName("writePrintInfo");
public static final int sel_paperName = sel_registerName("paperName");
public static final int sel_pauseSpeakingAtBoundary_1 = sel_registerName("pauseSpeakingAtBoundary:");
public static final int sel_markedTextAbandoned_1 = sel_registerName("markedTextAbandoned:");
public static final int sel_setTitled_1 = sel_registerName("setTitled:");
public static final int sel_hidesOnDeactivate = sel_registerName("hidesOnDeactivate");
public static final int sel_selectedRange = sel_registerName("selectedRange");
public static final int sel_reportException_1 = sel_registerName("reportException:");
public static final int sel_drawBezelWithFrame_1inView_1 = sel_registerName("drawBezelWithFrame:inView:");
public static final int sel_relativeMoveToPoint_1 = sel_registerName("relativeMoveToPoint:");
public static final int sel_printingAdjustmentInLayoutManager_1forNominallySpacedGlyphRange_1packedGlyphs_1count_1 = sel_registerName("printingAdjustmentInLayoutManager:forNominallySpacedGlyphRange:packedGlyphs:count:");
public static final int sel_longValue = sel_registerName("longValue");
public static final int sel_setMaxNumberOfColumns_1 = sel_registerName("setMaxNumberOfColumns:");
public static final int sel_textView_1draggedCell_1inRect_1event_1atIndex_1 = sel_registerName("textView:draggedCell:inRect:event:atIndex:");
public static final int sel_isRemovable = sel_registerName("isRemovable");
public static final int sel_handleCloseScriptCommand_1 = sel_registerName("handleCloseScriptCommand:");
public static final int sel_layoutManager_1shouldUseTemporaryAttributes_1forDrawingToScreen_1atCharacterIndex_1effectiveRange_1 = sel_registerName("layoutManager:shouldUseTemporaryAttributes:forDrawingToScreen:atCharacterIndex:effectiveRange:");
public static final int sel_expressionForKeyPath_1 = sel_registerName("expressionForKeyPath:");
public static final int sel_bezierPathWithOvalInRect_1 = sel_registerName("bezierPathWithOvalInRect:");
public static final int sel_deselectSelectedCell = sel_registerName("deselectSelectedCell");
public static final int sel_defaultSubcontainerAttributeKey = sel_registerName("defaultSubcontainerAttributeKey");
public static final int sel_yank_1 = sel_registerName("yank:");
public static final int sel_changeSpelling_1 = sel_registerName("changeSpelling:");
public static final int sel_totalAutoreleasedObjects = sel_registerName("totalAutoreleasedObjects");
public static final int sel_loops = sel_registerName("loops");
public static final int sel_boundsRectForTextBlock_1atIndex_1effectiveRange_1 = sel_registerName("boundsRectForTextBlock:atIndex:effectiveRange:");
public static final int sel_resignMainWindow = sel_registerName("resignMainWindow");
public static final int sel_availableLanguages = sel_registerName("availableLanguages");
public static final int sel_initWithMarkerFormat_1options_1 = sel_registerName("initWithMarkerFormat:options:");
public static final int sel_runInNewThread = sel_registerName("runInNewThread");
public static final int sel_tableView_1selectionIndexesForProposedSelection_1 = sel_registerName("tableView:selectionIndexesForProposedSelection:");
public static final int sel_fetchWithRequest_1merge_1error_1 = sel_registerName("fetchWithRequest:merge:error:");
public static final int sel_endSubelementIdentifier = sel_registerName("endSubelementIdentifier");
public static final int sel_implementationClassName = sel_registerName("implementationClassName");
public static final int sel_eventNumber = sel_registerName("eventNumber");
public static final int sel_requestTimeout = sel_registerName("requestTimeout");
public static final int sel_boldSystemFontOfSize_1 = sel_registerName("boldSystemFontOfSize:");
public static final int sel_setPixelsWide_1 = sel_registerName("setPixelsWide:");
public static final int sel_labelForSegment_1 = sel_registerName("labelForSegment:");
public static final int sel_setAlternateTitle_1 = sel_registerName("setAlternateTitle:");
public static final int sel_shouldBreakLineByWordBeforeCharacterAtIndex_1 = sel_registerName("shouldBreakLineByWordBeforeCharacterAtIndex:");
public static final int sel_lockFocusIfCanDraw = sel_registerName("lockFocusIfCanDraw");
public static final int sel_setFormat_1 = sel_registerName("setFormat:");
public static final int sel_setSegmentCount_1 = sel_registerName("setSegmentCount:");
public static final int sel_accessInstanceVariablesDirectly = sel_registerName("accessInstanceVariablesDirectly");
public static final int sel_comboBox_1completedString_1 = sel_registerName("comboBox:completedString:");
public static final int sel_moveToBeginningOfParagraph_1 = sel_registerName("moveToBeginningOfParagraph:");
public static final int sel_defaultParagraphStyle = sel_registerName("defaultParagraphStyle");
public static final int sel_availableTypeFromArray_1 = sel_registerName("availableTypeFromArray:");
public static final int sel_setGregorianStartDate_1 = sel_registerName("setGregorianStartDate:");
public static final int sel_dateWithTimeIntervalSince1970_1 = sel_registerName("dateWithTimeIntervalSince1970:");
public static final int sel_imagePasteboardTypes = sel_registerName("imagePasteboardTypes");
public static final int sel_laterDate_1 = sel_registerName("laterDate:");
public static final int sel_setBounds_1 = sel_registerName("setBounds:");
public static final int sel_HTTPMethod = sel_registerName("HTTPMethod");
public static final int sel_getGlyphsInRange_1glyphs_1characterIndexes_1glyphInscriptions_1elasticBits_1bidiLevels_1 = sel_registerName("getGlyphsInRange:glyphs:characterIndexes:glyphInscriptions:elasticBits:bidiLevels:");
public static final int sel_rectArrayForCharacterRange_1withinSelectedCharacterRange_1inTextContainer_1rectCount_1 = sel_registerName("rectArrayForCharacterRange:withinSelectedCharacterRange:inTextContainer:rectCount:");
public static final int sel_drawGridInClipRect_1 = sel_registerName("drawGridInClipRect:");
public static final int sel_isStarted = sel_registerName("isStarted");
public static final int sel_descriptorType = sel_registerName("descriptorType");
public static final int sel_ISOCurrencyCodes = sel_registerName("ISOCurrencyCodes");
public static final int sel_resetCancelButtonCell = sel_registerName("resetCancelButtonCell");
public static final int sel_positiveInfinitySymbol = sel_registerName("positiveInfinitySymbol");
public static final int sel_sendsActionOnArrowKeys = sel_registerName("sendsActionOnArrowKeys");
public static final int sel_delete_1 = sel_registerName("delete:");
public static final int sel_toolbarWillAddItem_1 = sel_registerName("toolbarWillAddItem:");
public static final int sel_updateCellInside_1 = sel_registerName("updateCellInside:");
public static final int sel_inputClientResignActive_1 = sel_registerName("inputClientResignActive:");
public static final int sel_initWithEventClass_1eventID_1targetDescriptor_1returnID_1transactionID_1 = sel_registerName("initWithEventClass:eventID:targetDescriptor:returnID:transactionID:");
public static final int sel_decimalNumberByDividingBy_1withBehavior_1 = sel_registerName("decimalNumberByDividingBy:withBehavior:");
public static final int sel_spellServer_1suggestCompletionsForPartialWordRange_1inString_1language_1 = sel_registerName("spellServer:suggestCompletionsForPartialWordRange:inString:language:");
public static final int sel_arrayWithObjects_1count_1 = sel_registerName("arrayWithObjects:count:");
public static final int sel_connectionWithRegisteredName_1host_1 = sel_registerName("connectionWithRegisteredName:host:");
public static final int sel_initWithFormat_1 = sel_registerName("initWithFormat:");
public static final int sel_sharedURLCache = sel_registerName("sharedURLCache");
public static final int sel_edited_1range_1changeInLength_1 = sel_registerName("edited:range:changeInLength:");
public static final int sel_prepareContent = sel_registerName("prepareContent");
public static final int sel_stringWithCString_1encoding_1 = sel_registerName("stringWithCString:encoding:");
public static final int sel_postNotificationName_1object_1userInfo_1deliverImmediately_1 = sel_registerName("postNotificationName:object:userInfo:deliverImmediately:");
public static final int sel_coerceToDescriptorType_1 = sel_registerName("coerceToDescriptorType:");
public static final int sel_selectionIndex = sel_registerName("selectionIndex");
public static final int sel_setContentMaxSize_1 = sel_registerName("setContentMaxSize:");
public static final int sel_setColor_1atX_1y_1 = sel_registerName("setColor:atX:y:");
public static final int sel_graphicsContext = sel_registerName("graphicsContext");
public static final int sel_hostWithName_1 = sel_registerName("hostWithName:");
public static final int sel_toggleRuler_1 = sel_registerName("toggleRuler:");
public static final int sel_glyphInfoWithGlyph_1forFont_1baseString_1 = sel_registerName("glyphInfoWithGlyph:forFont:baseString:");
public static final int sel_panel_1willExpand_1 = sel_registerName("panel:willExpand:");
public static final int sel_selectText_1 = sel_registerName("selectText:");
public static final int sel_setShortMonthSymbols_1 = sel_registerName("setShortMonthSymbols:");
public static final int sel_setBorderType_1 = sel_registerName("setBorderType:");
public static final int sel_rangeOfString_1 = sel_registerName("rangeOfString:");
public static final int sel_invalidateGlyphsOnLayoutInvalidationForGlyphRange_1 = sel_registerName("invalidateGlyphsOnLayoutInvalidationForGlyphRange:");
public static final int sel_availableMembersOfFontFamily_1 = sel_registerName("availableMembersOfFontFamily:");
public static final int sel_XPath = sel_registerName("XPath");
public static final int sel_contentsOfDirectoryAtPath_1error_1 = sel_registerName("contentsOfDirectoryAtPath:error:");
public static final int sel_newItemForRepresentedObject_1 = sel_registerName("newItemForRepresentedObject:");
public static final int sel_setMatrixClass_1 = sel_registerName("setMatrixClass:");
public static final int sel_compositeToPoint_1operation_1fraction_1 = sel_registerName("compositeToPoint:operation:fraction:");
public static final int sel_setHorizontallyResizable_1 = sel_registerName("setHorizontallyResizable:");
public static final int sel_mapTableWithStrongToStrongObjects = sel_registerName("mapTableWithStrongToStrongObjects");
public static final int sel_colorSpaceModel = sel_registerName("colorSpaceModel");
public static final int sel_setCriticalValue_1 = sel_registerName("setCriticalValue:");
public static final int sel_allowsToolTipsWhenApplicationIsInactive = sel_registerName("allowsToolTipsWhenApplicationIsInactive");
public static final int sel_transformUsingAffineTransform_1 = sel_registerName("transformUsingAffineTransform:");
public static final int sel_initWithInvocation_1 = sel_registerName("initWithInvocation:");
public static final int sel_containerClassDescription = sel_registerName("containerClassDescription");
public static final int sel_parser_1resolveExternalEntityName_1systemID_1 = sel_registerName("parser:resolveExternalEntityName:systemID:");
public static final int sel_mouseLocationOutsideOfEventStream = sel_registerName("mouseLocationOutsideOfEventStream");
public static final int sel_detach = sel_registerName("detach");
public static final int sel_setPickerMask_1 = sel_registerName("setPickerMask:");
public static final int sel_tokenStyle = sel_registerName("tokenStyle");
public static final int sel_setOptions_1 = sel_registerName("setOptions:");
public static final int sel_PDFOperationWithView_1insideRect_1toPath_1printInfo_1 = sel_registerName("PDFOperationWithView:insideRect:toPath:printInfo:");
public static final int sel_parser_1didStartElement_1namespaceURI_1qualifiedName_1attributes_1 = sel_registerName("parser:didStartElement:namespaceURI:qualifiedName:attributes:");
public static final int sel_availableFontNamesMatchingFontDescriptor_1 = sel_registerName("availableFontNamesMatchingFontDescriptor:");
public static final int sel_relativePath = sel_registerName("relativePath");
public static final int sel_moveWordForwardAndModifySelection_1 = sel_registerName("moveWordForwardAndModifySelection:");
public static final int sel_currentTime = sel_registerName("currentTime");
public static final int sel_slideDraggedImageTo_1 = sel_registerName("slideDraggedImageTo:");
public static final int sel_application_1printFile_1 = sel_registerName("application:printFile:");
public static final int sel_punctuationCharacterSet = sel_registerName("punctuationCharacterSet");
public static final int sel_allKeysForObject_1 = sel_registerName("allKeysForObject:");
public static final int sel_pathStyle = sel_registerName("pathStyle");
public static final int sel_allowsEditingTextAttributes = sel_registerName("allowsEditingTextAttributes");
public static final int sel_lineSpacingAfterGlyphAtIndex_1withProposedLineFragmentRect_1 = sel_registerName("lineSpacingAfterGlyphAtIndex:withProposedLineFragmentRect:");
public static final int sel_initWithContentsOfMappedFile_1 = sel_registerName("initWithContentsOfMappedFile:");
public static final int sel_initWithFrame_1pullsDown_1 = sel_registerName("initWithFrame:pullsDown:");
public static final int sel_setView_1 = sel_registerName("setView:");
public static final int sel_outlineViewSelectionDidChange_1 = sel_registerName("outlineViewSelectionDidChange:");
public static final int sel_widthValueTypeForLayer_1edge_1 = sel_registerName("widthValueTypeForLayer:edge:");
public static final int sel_dateWithTimeIntervalSinceNow_1 = sel_registerName("dateWithTimeIntervalSinceNow:");
public static final int sel_display = sel_registerName("display");
public static final int sel_setRoundingBehavior_1 = sel_registerName("setRoundingBehavior:");
public static final int sel_valueWithPoint_1 = sel_registerName("valueWithPoint:");
public static final int sel_tickMarkValueAtIndex_1 = sel_registerName("tickMarkValueAtIndex:");
public static final int sel_addColumnWithCells_1 = sel_registerName("addColumnWithCells:");
public static final int sel_exposeBinding_1 = sel_registerName("exposeBinding:");
public static final int sel_weekdayOrdinal = sel_registerName("weekdayOrdinal");
public static final int sel_canAddChild = sel_registerName("canAddChild");
public static final int sel_hitTest_1 = sel_registerName("hitTest:");
public static final int sel_nibBundle = sel_registerName("nibBundle");
public static final int sel_resumeExecutionWithResult_1 = sel_registerName("resumeExecutionWithResult:");
public static final int sel_setMonthSymbols_1 = sel_registerName("setMonthSymbols:");
public static final int sel_hitPart = sel_registerName("hitPart");
public static final int sel_download_1didCancelAuthenticationChallenge_1 = sel_registerName("download:didCancelAuthenticationChallenge:");
public static final int sel_descriptionWithCalendarFormat_1 = sel_registerName("descriptionWithCalendarFormat:");
public static final int sel_setProtocolSpecificInformation_1 = sel_registerName("setProtocolSpecificInformation:");
public static final int sel_tokenField_1shouldAddObjects_1atIndex_1 = sel_registerName("tokenField:shouldAddObjects:atIndex:");
public static final int sel_popUpContextMenu_1withEvent_1forView_1 = sel_registerName("popUpContextMenu:withEvent:forView:");
public static final int sel_stopPeriodicEvents = sel_registerName("stopPeriodicEvents");
public static final int sel_setDTD_1 = sel_registerName("setDTD:");
public static final int sel_glyphAtIndex_1isValidIndex_1 = sel_registerName("glyphAtIndex:isValidIndex:");
public static final int sel_encodeSize_1 = sel_registerName("encodeSize:");
public static final int sel_windowForSheet = sel_registerName("windowForSheet");
public static final int sel_displayMode = sel_registerName("displayMode");
public static final int sel_revertDocumentToSaved_1 = sel_registerName("revertDocumentToSaved:");
public static final int sel_tableView_1objectValueForTableColumn_1row_1 = sel_registerName("tableView:objectValueForTableColumn:row:");
public static final int sel_setBackingType_1 = sel_registerName("setBackingType:");
public static final int sel_scanUpToCharactersFromSet_1intoString_1 = sel_registerName("scanUpToCharactersFromSet:intoString:");
public static final int sel_nextValidKeyView = sel_registerName("nextValidKeyView");
public static final int sel_arrayWithObject_1 = sel_registerName("arrayWithObject:");
public static final int sel_flushBuffer = sel_registerName("flushBuffer");
public static final int sel_hasValidObjectValue = sel_registerName("hasValidObjectValue");
public static final int sel_numberWithUnsignedLong_1 = sel_registerName("numberWithUnsignedLong:");
public static final int sel_collectExhaustively = sel_registerName("collectExhaustively");
public static final int sel_setImageInterpolation_1 = sel_registerName("setImageInterpolation:");
public static final int sel_setSystemID_1 = sel_registerName("setSystemID:");
public static final int sel_setCornerView_1 = sel_registerName("setCornerView:");
public static final int sel_initWithDouble_1 = sel_registerName("initWithDouble:");
public static final int sel_sortedArrayUsingDescriptors_1 = sel_registerName("sortedArrayUsingDescriptors:");
public static final int sel_removeTextContainerAtIndex_1 = sel_registerName("removeTextContainerAtIndex:");
public static final int sel_whitespaceCharacterSet = sel_registerName("whitespaceCharacterSet");
public static final int sel_classDescriptionForClass_1 = sel_registerName("classDescriptionForClass:");
public static final int sel_setAttributedString_1 = sel_registerName("setAttributedString:");
public static final int sel_setPixelsHigh_1 = sel_registerName("setPixelsHigh:");
public static final int sel_setDynamicDepthLimit_1 = sel_registerName("setDynamicDepthLimit:");
public static final int sel_sharedApplication = sel_registerName("sharedApplication");
public static final int sel_sound_1didFinishPlaying_1 = sel_registerName("sound:didFinishPlaying:");
public static final int sel_defaultBehavior = sel_registerName("defaultBehavior");
public static final int sel_beginSheetForDirectory_1file_1types_1modalForWindow_1modalDelegate_1didEndSelector_1contextInfo_1 = sel_registerName("beginSheetForDirectory:file:types:modalForWindow:modalDelegate:didEndSelector:contextInfo:");
public static final int sel_orderFrontFontPanel_1 = sel_registerName("orderFrontFontPanel:");
public static final int sel_searchForBrowsableDomains = sel_registerName("searchForBrowsableDomains");
public static final int sel_toggleAutomaticQuoteSubstitution_1 = sel_registerName("toggleAutomaticQuoteSubstitution:");
public static final int sel_textView_1willChangeSelectionFromCharacterRanges_1toCharacterRanges_1 = sel_registerName("textView:willChangeSelectionFromCharacterRanges:toCharacterRanges:");
public static final int sel_alignRight_1 = sel_registerName("alignRight:");
public static final int sel_getBytes_1maxLength_1usedLength_1encoding_1options_1range_1remainingRange_1 = sel_registerName("getBytes:maxLength:usedLength:encoding:options:range:remainingRange:");
public static final int sel_keyPointerFunctions = sel_registerName("keyPointerFunctions");
public static final int sel_mouseDownFlags = sel_registerName("mouseDownFlags");
public static final int sel_expandItem_1 = sel_registerName("expandItem:");
public static final int sel_bezierPathWithRect_1 = sel_registerName("bezierPathWithRect:");
public static final int sel_setGradientType_1 = sel_registerName("setGradientType:");
public static final int sel_alphanumericCharacterSet = sel_registerName("alphanumericCharacterSet");
public static final int sel_deleteWordForward_1 = sel_registerName("deleteWordForward:");
public static final int sel_cStringUsingEncoding_1 = sel_registerName("cStringUsingEncoding:");
public static final int sel_storedValueForKey_1 = sel_registerName("storedValueForKey:");
public static final int sel_fileSize = sel_registerName("fileSize");
public static final int sel_elementWithName_1URI_1 = sel_registerName("elementWithName:URI:");
public static final int sel_pointSize = sel_registerName("pointSize");
public static final int sel_veryShortMonthSymbols = sel_registerName("veryShortMonthSymbols");
public static final int sel_transformSize_1 = sel_registerName("transformSize:");
public static final int sel_titleWidth = sel_registerName("titleWidth");
public static final int sel_setTextContainerInset_1 = sel_registerName("setTextContainerInset:");
public static final int sel_supportedWindowDepths = sel_registerName("supportedWindowDepths");
public static final int sel_appleEvent = sel_registerName("appleEvent");
public static final int sel_valueClassForBinding_1 = sel_registerName("valueClassForBinding:");
public static final int sel_setFullScreen = sel_registerName("setFullScreen");
public static final int sel_encodeObject_1forKey_1 = sel_registerName("encodeObject:forKey:");
public static final int sel_setSpellingState_1range_1 = sel_registerName("setSpellingState:range:");
public static final int sel_greenComponent = sel_registerName("greenComponent");
public static final int sel_textBackgroundColor = sel_registerName("textBackgroundColor");
public static final int sel_currentEditor = sel_registerName("currentEditor");
public static final int sel_attachedSheet = sel_registerName("attachedSheet");
public static final int sel_new = sel_registerName("new");
public static final int sel_setChildren_1 = sel_registerName("setChildren:");
public static final int sel_options = sel_registerName("options");
public static final int sel_setObjectClass_1 = sel_registerName("setObjectClass:");
public static final int sel_borderWidth = sel_registerName("borderWidth");
public static final int sel_secondarySelectedControlColor = sel_registerName("secondarySelectedControlColor");
public static final int sel_scrollItemAtIndexToVisible_1 = sel_registerName("scrollItemAtIndexToVisible:");
public static final int sel_wantsLayer = sel_registerName("wantsLayer");
public static final int sel_setPath_1 = sel_registerName("setPath:");
public static final int sel_setKeys_1triggerChangeNotificationsForDependentKey_1 = sel_registerName("setKeys:triggerChangeNotificationsForDependentKey:");
public static final int sel_verticalAlignment = sel_registerName("verticalAlignment");
public static final int sel_selectionGranularity = sel_registerName("selectionGranularity");
public static final int sel_minimumIntegerDigits = sel_registerName("minimumIntegerDigits");
public static final int sel_canCreateDirectories = sel_registerName("canCreateDirectories");
public static final int sel_fixAttributesInRange_1 = sel_registerName("fixAttributesInRange:");
public static final int sel_URLWithString_1 = sel_registerName("URLWithString:");
public static final int sel_setFrameFromContentFrame_1 = sel_registerName("setFrameFromContentFrame:");
public static final int sel_setFillColor_1 = sel_registerName("setFillColor:");
public static final int sel_dictionaryWithCapacity_1 = sel_registerName("dictionaryWithCapacity:");
public static final int sel_updateFromPath_1 = sel_registerName("updateFromPath:");
public static final int sel_netServiceDidResolveAddress_1 = sel_registerName("netServiceDidResolveAddress:");
public static final int sel_usesLazyFetching = sel_registerName("usesLazyFetching");
public static final int sel_setMenuBarVisible_1 = sel_registerName("setMenuBarVisible:");
public static final int sel_windowDidBecomeKey_1 = sel_registerName("windowDidBecomeKey:");
public static final int sel_menuChanged_1 = sel_registerName("menuChanged:");
public static final int sel_itemObjectValueAtIndex_1 = sel_registerName("itemObjectValueAtIndex:");
public static final int sel_setClassName_1forClass_1 = sel_registerName("setClassName:forClass:");
public static final int sel_setShowsToolbarButton_1 = sel_registerName("setShowsToolbarButton:");
public static final int sel_plusSign = sel_registerName("plusSign");
public static final int sel_sharedSpellChecker = sel_registerName("sharedSpellChecker");
public static final int sel_getNumberOfRows_1columns_1 = sel_registerName("getNumberOfRows:columns:");
public static final int sel_valueTransformerNames = sel_registerName("valueTransformerNames");
public static final int sel_interpolatedColorAtLocation_1 = sel_registerName("interpolatedColorAtLocation:");
public static final int sel_updateSpellingPanelWithMisspelledWord_1 = sel_registerName("updateSpellingPanelWithMisspelledWord:");
public static final int sel_yellowComponent = sel_registerName("yellowComponent");
public static final int sel_acceptsFirstResponder = sel_registerName("acceptsFirstResponder");
public static final int sel_valueWithRect_1 = sel_registerName("valueWithRect:");
public static final int sel_frameOfCellAtColumn_1row_1 = sel_registerName("frameOfCellAtColumn:row:");
public static final int sel_makeWindowsPerform_1inOrder_1 = sel_registerName("makeWindowsPerform:inOrder:");
public static final int sel_lastIndex = sel_registerName("lastIndex");
public static final int sel_initWithCharacters_1length_1 = sel_registerName("initWithCharacters:length:");
public static final int sel_initWithIdentifier_1 = sel_registerName("initWithIdentifier:");
public static final int sel_proxyWithLocal_1connection_1 = sel_registerName("proxyWithLocal:connection:");
public static final int sel_scrollColumnToVisible_1 = sel_registerName("scrollColumnToVisible:");
public static final int sel_descriptor = sel_registerName("descriptor");
public static final int sel_ISOCountryCodes = sel_registerName("ISOCountryCodes");
public static final int sel_setStandardInput_1 = sel_registerName("setStandardInput:");
public static final int sel_getAdvancements_1forGlyphs_1count_1 = sel_registerName("getAdvancements:forGlyphs:count:");
public static final int sel_displayColumn_1 = sel_registerName("displayColumn:");
public static final int sel_setAltersStateOfSelectedItem_1 = sel_registerName("setAltersStateOfSelectedItem:");
public static final int sel_setFrameRotation_1 = sel_registerName("setFrameRotation:");
public static final int sel_clickedOnLink_1atIndex_1 = sel_registerName("clickedOnLink:atIndex:");
public static final int sel_addAttribute_1 = sel_registerName("addAttribute:");
public static final int sel_readPrintInfo = sel_registerName("readPrintInfo");
public static final int sel_setCurrentContext_1 = sel_registerName("setCurrentContext:");
public static final int sel_setVerticalLineScroll_1 = sel_registerName("setVerticalLineScroll:");
public static final int sel_commands = sel_registerName("commands");
public static final int sel_setNamespaces_1 = sel_registerName("setNamespaces:");
public static final int sel_removeEntryAtIndex_1 = sel_registerName("removeEntryAtIndex:");
public static final int sel_setAllowsColumnResizing_1 = sel_registerName("setAllowsColumnResizing:");
public static final int sel_colorWithDeviceCyan_1magenta_1yellow_1black_1alpha_1 = sel_registerName("colorWithDeviceCyan:magenta:yellow:black:alpha:");
public static final int sel_textView_1shouldChangeTypingAttributes_1toAttributes_1 = sel_registerName("textView:shouldChangeTypingAttributes:toAttributes:");
public static final int sel_usesFeedbackWindow = sel_registerName("usesFeedbackWindow");
public static final int sel_setCookie_1 = sel_registerName("setCookie:");
public static final int sel_keyWindow = sel_registerName("keyWindow");
public static final int sel_headIndent = sel_registerName("headIndent");
public static final int sel_removeObjectIdenticalTo_1inRange_1 = sel_registerName("removeObjectIdenticalTo:inRange:");
public static final int sel_applicationWillUnhide_1 = sel_registerName("applicationWillUnhide:");
public static final int sel_currentPage = sel_registerName("currentPage");
public static final int sel_setOffStateImage_1 = sel_registerName("setOffStateImage:");
public static final int sel_addRowWithCells_1 = sel_registerName("addRowWithCells:");
public static final int sel_setInterlineSpacing_1 = sel_registerName("setInterlineSpacing:");
public static final int sel_imageFileTypes = sel_registerName("imageFileTypes");
public static final int sel_setArray_1 = sel_registerName("setArray:");
public static final int sel_addLayoutManager_1 = sel_registerName("addLayoutManager:");
public static final int sel_outputStreamToFileAtPath_1append_1 = sel_registerName("outputStreamToFileAtPath:append:");
public static final int sel_registeredDraggedTypes = sel_registerName("registeredDraggedTypes");
public static final int sel_colorWithCalibratedRed_1green_1blue_1alpha_1 = sel_registerName("colorWithCalibratedRed:green:blue:alpha:");
public static final int sel_invalidateClassDescriptionCache = sel_registerName("invalidateClassDescriptionCache");
public static final int sel_URLProtocolDidFinishLoading_1 = sel_registerName("URLProtocolDidFinishLoading:");
public static final int sel_didChangeArrangementCriteria = sel_registerName("didChangeArrangementCriteria");
public static final int sel_ICCProfileData = sel_registerName("ICCProfileData");
public static final int sel_availableResourceData = sel_registerName("availableResourceData");
public static final int sel_glyphIndexForPoint_1inTextContainer_1fractionOfDistanceThroughGlyph_1 = sel_registerName("glyphIndexForPoint:inTextContainer:fractionOfDistanceThroughGlyph:");
public static final int sel_moveToEndOfParagraph_1 = sel_registerName("moveToEndOfParagraph:");
public static final int sel_enterFullScreenMode_1withOptions_1 = sel_registerName("enterFullScreenMode:withOptions:");
public static final int sel_fieldEditor_1forObject_1 = sel_registerName("fieldEditor:forObject:");
public static final int sel_setTreatsFilePackagesAsDirectories_1 = sel_registerName("setTreatsFilePackagesAsDirectories:");
public static final int sel_setLevelIndicatorStyle_1 = sel_registerName("setLevelIndicatorStyle:");
public static final int sel_minimumDecimalNumber = sel_registerName("minimumDecimalNumber");
public static final int sel_hasSpaceAvailable = sel_registerName("hasSpaceAvailable");
public static final int sel_widthOfString_1 = sel_registerName("widthOfString:");
public static final int sel_setLocale_1 = sel_registerName("setLocale:");
public static final int sel_setPreferredEdge_1 = sel_registerName("setPreferredEdge:");
public static final int sel_setRichText_1 = sel_registerName("setRichText:");
public static final int sel_rangesForUserCharacterAttributeChange = sel_registerName("rangesForUserCharacterAttributeChange");
public static final int sel_rectForPage_1 = sel_registerName("rectForPage:");
public static final int sel_rowHeight = sel_registerName("rowHeight");
public static final int sel_windowDidChangeScreenProfile_1 = sel_registerName("windowDidChangeScreenProfile:");
public static final int sel_setCachePolicy_1 = sel_registerName("setCachePolicy:");
public static final int sel_parser_1didEndMappingPrefix_1 = sel_registerName("parser:didEndMappingPrefix:");
public static final int sel_cleanUpAfterDragOperation = sel_registerName("cleanUpAfterDragOperation");
public static final int sel_browser_1typeSelectStringForRow_1inColumn_1 = sel_registerName("browser:typeSelectStringForRow:inColumn:");
public static final int sel_canInitWithPasteboard_1 = sel_registerName("canInitWithPasteboard:");
public static final int sel_startListening = sel_registerName("startListening");
public static final int sel_setExcludedKeys_1 = sel_registerName("setExcludedKeys:");
public static final int sel_readFromFile_1ofType_1 = sel_registerName("readFromFile:ofType:");
public static final int sel_setReservedThicknessForMarkers_1 = sel_registerName("setReservedThicknessForMarkers:");
public static final int sel_windowRef = sel_registerName("windowRef");
public static final int sel_browser_1selectRow_1inColumn_1 = sel_registerName("browser:selectRow:inColumn:");
public static final int sel_isOpaque = sel_registerName("isOpaque");
public static final int sel_fontDescriptorWithFamily_1 = sel_registerName("fontDescriptorWithFamily:");
public static final int sel_itemTitleAtIndex_1 = sel_registerName("itemTitleAtIndex:");
public static final int sel_boundingBox = sel_registerName("boundingBox");
public static final int sel_moveColumn_1toColumn_1 = sel_registerName("moveColumn:toColumn:");
public static final int sel_badgeLabel = sel_registerName("badgeLabel");
public static final int sel_outline_1 = sel_registerName("outline:");
public static final int sel_characterIndexForInsertionAtPoint_1 = sel_registerName("characterIndexForInsertionAtPoint:");
public static final int sel_URLHandleClassForURL_1 = sel_registerName("URLHandleClassForURL:");
public static final int sel_selectKeyViewFollowingView_1 = sel_registerName("selectKeyViewFollowingView:");
public static final int sel_fullPathForApplication_1 = sel_registerName("fullPathForApplication:");
public static final int sel_outlineView_1willDisplayOutlineCell_1forTableColumn_1item_1 = sel_registerName("outlineView:willDisplayOutlineCell:forTableColumn:item:");
public static final int sel_encodePropertyList_1 = sel_registerName("encodePropertyList:");
public static final int sel_generatesDecimalNumbers = sel_registerName("generatesDecimalNumbers");
public static final int sel_appendAttributedString_1 = sel_registerName("appendAttributedString:");
public static final int sel_persistentDomainNames = sel_registerName("persistentDomainNames");
public static final int sel_setUserFont_1 = sel_registerName("setUserFont:");
public static final int sel_initWithProperties_1 = sel_registerName("initWithProperties:");
public static final int sel_loadResourceDataNotifyingClient_1usingCache_1 = sel_registerName("loadResourceDataNotifyingClient:usingCache:");
public static final int sel_closeFile = sel_registerName("closeFile");
public static final int sel_allHeaderFields = sel_registerName("allHeaderFields");
public static final int sel_unlearnWord_1 = sel_registerName("unlearnWord:");
public static final int sel_drawsCellBackground = sel_registerName("drawsCellBackground");
public static final int sel_PICTRepresentation = sel_registerName("PICTRepresentation");
public static final int sel_imageScaling = sel_registerName("imageScaling");
public static final int sel_scanUpToString_1intoString_1 = sel_registerName("scanUpToString:intoString:");
public static final int sel_scrollBarColor = sel_registerName("scrollBarColor");
public static final int sel_initWithDelegate_1name_1 = sel_registerName("initWithDelegate:name:");
public static final int sel_setDateValue_1 = sel_registerName("setDateValue:");
public static final int sel_dividerStyle = sel_registerName("dividerStyle");
public static final int sel_scrollPageDown_1 = sel_registerName("scrollPageDown:");
public static final int sel_removeLayoutManager_1 = sel_registerName("removeLayoutManager:");
public static final int sel_textAttributesForNegativeValues = sel_registerName("textAttributesForNegativeValues");
public static final int sel_attachment = sel_registerName("attachment");
public static final int sel_reset = sel_registerName("reset");
public static final int sel_initWithAttributes_1 = sel_registerName("initWithAttributes:");
public static final int sel_allowsMixedState = sel_registerName("allowsMixedState");
public static final int sel_addPort_1forMode_1 = sel_registerName("addPort:forMode:");
public static final int sel_windowDidDeminiaturize_1 = sel_registerName("windowDidDeminiaturize:");
public static final int sel_setRowHeight_1 = sel_registerName("setRowHeight:");
public static final int sel_setGraphicsState_1 = sel_registerName("setGraphicsState:");
public static final int sel_replaceCharactersInRange_1withAttributedString_1 = sel_registerName("replaceCharactersInRange:withAttributedString:");
public static final int sel_setAttributedStringValue_1 = sel_registerName("setAttributedStringValue:");
public static final int sel_criteriaKeyPath = sel_registerName("criteriaKeyPath");
public static final int sel_standardInput = sel_registerName("standardInput");
public static final int sel_isFontAvailable_1 = sel_registerName("isFontAvailable:");
public static final int sel_setAllowsTypeSelect_1 = sel_registerName("setAllowsTypeSelect:");
public static final int sel_portWithMachPort_1 = sel_registerName("portWithMachPort:");
public static final int sel_panel_1isValidFilename_1 = sel_registerName("panel:isValidFilename:");
public static final int sel_imageablePageBounds = sel_registerName("imageablePageBounds");
public static final int sel_notificationWithName_1object_1 = sel_registerName("notificationWithName:object:");
public static final int sel_sharedFontPanelExists = sel_registerName("sharedFontPanelExists");
public static final int sel_blackColor = sel_registerName("blackColor");
public static final int sel_removeDescriptorAtIndex_1 = sel_registerName("removeDescriptorAtIndex:");
public static final int sel_dataUsingEncoding_1allowLossyConversion_1 = sel_registerName("dataUsingEncoding:allowLossyConversion:");
public static final int sel_propertyForKey_1inRequest_1 = sel_registerName("propertyForKey:inRequest:");
public static final int sel_setHeaderLevel_1 = sel_registerName("setHeaderLevel:");
public static final int sel_jobTitle = sel_registerName("jobTitle");
public static final int sel_removePersistentDomainForName_1 = sel_registerName("removePersistentDomainForName:");
public static final int sel_contentResizeIncrements = sel_registerName("contentResizeIncrements");
public static final int sel_textFileTypes = sel_registerName("textFileTypes");
public static final int sel_setAction_1 = sel_registerName("setAction:");
public static final int sel_knobProportion = sel_registerName("knobProportion");
public static final int sel_numberOfArguments = sel_registerName("numberOfArguments");
public static final int sel_setScrollsDynamically_1 = sel_registerName("setScrollsDynamically:");
public static final int sel_setTextColor_1range_1 = sel_registerName("setTextColor:range:");
public static final int sel_setBoundsSize_1 = sel_registerName("setBoundsSize:");
public static final int sel_setVolume_1 = sel_registerName("setVolume:");
public static final int sel_windowControllers = sel_registerName("windowControllers");
public static final int sel_insertAttributedString_1atIndex_1 = sel_registerName("insertAttributedString:atIndex:");
public static final int sel_eventWithEventRef_1 = sel_registerName("eventWithEventRef:");
public static final int sel_initByReferencingFile_1 = sel_registerName("initByReferencingFile:");
public static final int sel_fire = sel_registerName("fire");
public static final int sel_writeToPasteboard_1 = sel_registerName("writeToPasteboard:");
public static final int sel_connectionForProxy = sel_registerName("connectionForProxy");
public static final int sel_outlineView_1mouseDownInHeaderOfTableColumn_1 = sel_registerName("outlineView:mouseDownInHeaderOfTableColumn:");
public static final int sel_mutableArrayValueForKeyPath_1 = sel_registerName("mutableArrayValueForKeyPath:");
public static final int sel_validRequestorForSendType_1returnType_1 = sel_registerName("validRequestorForSendType:returnType:");
public static final int sel_isRichText = sel_registerName("isRichText");
public static final int sel_moveWordLeft_1 = sel_registerName("moveWordLeft:");
public static final int sel_indexSetWithIndex_1 = sel_registerName("indexSetWithIndex:");
public static final int sel_setContextMenuRepresentation_1 = sel_registerName("setContextMenuRepresentation:");
public static final int sel_updateTrackingAreas = sel_registerName("updateTrackingAreas");
public static final int sel_defaultCollector = sel_registerName("defaultCollector");
public static final int sel_orderedIndex = sel_registerName("orderedIndex");
public static final int sel_relativeCurveToPoint_1controlPoint1_1controlPoint2_1 = sel_registerName("relativeCurveToPoint:controlPoint1:controlPoint2:");
public static final int sel_setShowsApplicationBadge_1 = sel_registerName("setShowsApplicationBadge:");
public static final int sel_setValue_1 = sel_registerName("setValue:");
public static final int sel_attributeDeclarationForName_1elementName_1 = sel_registerName("attributeDeclarationForName:elementName:");
public static final int sel_setWidth_1type_1forLayer_1 = sel_registerName("setWidth:type:forLayer:");
public static final int sel_decodePoint = sel_registerName("decodePoint");
public static final int sel_makeWindowControllers = sel_registerName("makeWindowControllers");
public static final int sel_userFontOfSize_1 = sel_registerName("userFontOfSize:");
public static final int sel_dependencies = sel_registerName("dependencies");
public static final int sel_setAttributes_1 = sel_registerName("setAttributes:");
public static final int sel_setFrameCenterRotation_1 = sel_registerName("setFrameCenterRotation:");
public static final int sel_nilSymbol = sel_registerName("nilSymbol");
public static final int sel_scalesWhenResized = sel_registerName("scalesWhenResized");
public static final int sel_setMinusSign_1 = sel_registerName("setMinusSign:");
public static final int sel_predicateOperatorType = sel_registerName("predicateOperatorType");
public static final int sel_replyWithException_1 = sel_registerName("replyWithException:");
public static final int sel_fileName = sel_registerName("fileName");
public static final int sel_indexPathByRemovingLastIndex = sel_registerName("indexPathByRemovingLastIndex");
public static final int sel_openHelpAnchor_1inBook_1 = sel_registerName("openHelpAnchor:inBook:");
public static final int sel_initWithBytes_1objCType_1 = sel_registerName("initWithBytes:objCType:");
public static final int sel_removeObject_1 = sel_registerName("removeObject:");
public static final int sel_colorNameComponent = sel_registerName("colorNameComponent");
public static final int sel_setCellBackgroundColor_1 = sel_registerName("setCellBackgroundColor:");
public static final int sel_getLineDash_1count_1phase_1 = sel_registerName("getLineDash:count:phase:");
public static final int sel_scriptingContains_1 = sel_registerName("scriptingContains:");
public static final int sel_setDefaultWindingRule_1 = sel_registerName("setDefaultWindingRule:");
public static final int sel_outputStreamToBuffer_1capacity_1 = sel_registerName("outputStreamToBuffer:capacity:");
public static final int sel_defaultButtonTitle = sel_registerName("defaultButtonTitle");
public static final int sel_draggingSourceOperationMask = sel_registerName("draggingSourceOperationMask");
public static final int sel_textDidChange_1 = sel_registerName("textDidChange:");
public static final int sel_drawSheetBorderWithSize_1 = sel_registerName("drawSheetBorderWithSize:");
public static final int sel_integerForKey_1 = sel_registerName("integerForKey:");
public static final int sel_setDefaultNameServerPortNumber_1 = sel_registerName("setDefaultNameServerPortNumber:");
public static final int sel_previousNode = sel_registerName("previousNode");
public static final int sel_trackingArea = sel_registerName("trackingArea");
public static final int sel_highlightWithLevel_1 = sel_registerName("highlightWithLevel:");
public static final int sel_trackMouse_1inRect_1ofView_1atCharacterIndex_1untilMouseUp_1 = sel_registerName("trackMouse:inRect:ofView:atCharacterIndex:untilMouseUp:");
public static final int sel_signatureWithObjCTypes_1 = sel_registerName("signatureWithObjCTypes:");
public static final int sel_saveToURL_1ofType_1forSaveOperation_1error_1 = sel_registerName("saveToURL:ofType:forSaveOperation:error:");
public static final int sel_dataWithBytesNoCopy_1length_1freeWhenDone_1 = sel_registerName("dataWithBytesNoCopy:length:freeWhenDone:");
public static final int sel_encodeInteger_1forKey_1 = sel_registerName("encodeInteger:forKey:");
public static final int sel_removeFromSuperview = sel_registerName("removeFromSuperview");
public static final int sel_dataWithBytesNoCopy_1length_1 = sel_registerName("dataWithBytesNoCopy:length:");
public static final int sel_initWithIndexesInRange_1 = sel_registerName("initWithIndexesInRange:");
public static final int sel_initWithKeyPointerFunctions_1valuePointerFunctions_1capacity_1 = sel_registerName("initWithKeyPointerFunctions:valuePointerFunctions:capacity:");
public static final int sel_tilt = sel_registerName("tilt");
public static final int sel_setHidden_1 = sel_registerName("setHidden:");
public static final int sel_setMenuFormRepresentation_1 = sel_registerName("setMenuFormRepresentation:");
public static final int sel_setCanChooseDirectories_1 = sel_registerName("setCanChooseDirectories:");
public static final int sel_usedRectForTextContainer_1 = sel_registerName("usedRectForTextContainer:");
public static final int sel_allowsColumnSelection = sel_registerName("allowsColumnSelection");
public static final int sel_orderOut_1 = sel_registerName("orderOut:");
public static final int sel_filterUsingPredicate_1 = sel_registerName("filterUsingPredicate:");
public static final int sel_setTest_1 = sel_registerName("setTest:");
public static final int sel_setAllowedTypes_1 = sel_registerName("setAllowedTypes:");
public static final int sel_registerForDraggedTypes_1 = sel_registerName("registerForDraggedTypes:");
public static final int sel_objectEnumerator = sel_registerName("objectEnumerator");
public static final int sel_setWindowController_1 = sel_registerName("setWindowController:");
public static final int sel_setDestination_1 = sel_registerName("setDestination:");
public static final int sel_addRepresentation_1 = sel_registerName("addRepresentation:");
public static final int sel_isEqual_1 = sel_registerName("isEqual:");
public static final int sel_glyphRangeForTextContainer_1 = sel_registerName("glyphRangeForTextContainer:");
public static final int sel_setStandaloneWeekdaySymbols_1 = sel_registerName("setStandaloneWeekdaySymbols:");
public static final int sel_setIgnoresAlpha_1 = sel_registerName("setIgnoresAlpha:");
public static final int sel_drawBarInside_1flipped_1 = sel_registerName("drawBarInside:flipped:");
public static final int sel_doesNotRecognizeSelector_1 = sel_registerName("doesNotRecognizeSelector:");
public static final int sel_windowDidResignMain_1 = sel_registerName("windowDidResignMain:");
public static final int sel_scrollItemAtIndexToTop_1 = sel_registerName("scrollItemAtIndexToTop:");
public static final int sel_makePreviousSegmentKey = sel_registerName("makePreviousSegmentKey");
public static final int sel_download_1shouldDecodeSourceDataOfMIMEType_1 = sel_registerName("download:shouldDecodeSourceDataOfMIMEType:");
public static final int sel_compareObject_1toObject_1 = sel_registerName("compareObject:toObject:");
public static final int sel_widthTracksTextView = sel_registerName("widthTracksTextView");
public static final int sel_subpredicates = sel_registerName("subpredicates");
public static final int sel_relativeLineToPoint_1 = sel_registerName("relativeLineToPoint:");
public static final int sel_gridStyleMask = sel_registerName("gridStyleMask");
public static final int sel_initWithCString_1 = sel_registerName("initWithCString:");
public static final int sel_imageScalingForSegment_1 = sel_registerName("imageScalingForSegment:");
public static final int sel_editWithFrame_1inView_1editor_1delegate_1event_1 = sel_registerName("editWithFrame:inView:editor:delegate:event:");
public static final int sel_glyphPacking = sel_registerName("glyphPacking");
public static final int sel_resolveWithTimeout_1 = sel_registerName("resolveWithTimeout:");
public static final int sel_hasEditedDocuments = sel_registerName("hasEditedDocuments");
public static final int sel_getLineFragmentRect_1usedRect_1forParagraphSeparatorGlyphRange_1atProposedOrigin_1 = sel_registerName("getLineFragmentRect:usedRect:forParagraphSeparatorGlyphRange:atProposedOrigin:");
public static final int sel_autosaveDocumentWithDelegate_1didAutosaveSelector_1contextInfo_1 = sel_registerName("autosaveDocumentWithDelegate:didAutosaveSelector:contextInfo:");
public static final int sel_readSelectionFromPasteboard_1type_1 = sel_registerName("readSelectionFromPasteboard:type:");
public static final int sel_spellServer_1suggestGuessesForWord_1inLanguage_1 = sel_registerName("spellServer:suggestGuessesForWord:inLanguage:");
public static final int sel_initWithTimeIntervalSinceNow_1 = sel_registerName("initWithTimeIntervalSinceNow:");
public static final int sel_setMaxWidth_1 = sel_registerName("setMaxWidth:");
public static final int sel_userDefaultsChanged = sel_registerName("userDefaultsChanged");
public static final int sel_setWidth_1 = sel_registerName("setWidth:");
public static final int sel_setPrintPanel_1 = sel_registerName("setPrintPanel:");
public static final int sel_setCurrentPage_1 = sel_registerName("setCurrentPage:");
public static final int sel_resizeIncrements = sel_registerName("resizeIncrements");
public static final int sel_selectWithFrame_1inView_1editor_1delegate_1start_1length_1 = sel_registerName("selectWithFrame:inView:editor:delegate:start:length:");
public static final int sel_sRGBColorSpace = sel_registerName("sRGBColorSpace");
public static final int sel_scriptErrorExpectedTypeDescriptor = sel_registerName("scriptErrorExpectedTypeDescriptor");
public static final int sel_setHasHorizontalRuler_1 = sel_registerName("setHasHorizontalRuler:");
public static final int sel_initialFirstResponder = sel_registerName("initialFirstResponder");
public static final int sel_stringForObjectValue_1 = sel_registerName("stringForObjectValue:");
public static final int sel_pageRange = sel_registerName("pageRange");
public static final int sel_printOperationWithView_1 = sel_registerName("printOperationWithView:");
public static final int sel_initWithFrame_1pixelFormat_1 = sel_registerName("initWithFrame:pixelFormat:");
public static final int sel_fileWrapperOfType_1error_1 = sel_registerName("fileWrapperOfType:error:");
public static final int sel_doesContain_1 = sel_registerName("doesContain:");
public static final int sel_mutableSetValueForKeyPath_1 = sel_registerName("mutableSetValueForKeyPath:");
public static final int sel_initWithURL_1cached_1 = sel_registerName("initWithURL:cached:");
public static final int sel_controlAlternatingRowBackgroundColors = sel_registerName("controlAlternatingRowBackgroundColors");
public static final int sel_pathComponentCellClass = sel_registerName("pathComponentCellClass");
public static final int sel_arrayWithCapacity_1 = sel_registerName("arrayWithCapacity:");
public static final int sel_types = sel_registerName("types");
public static final int sel_setPrintInfo_1 = sel_registerName("setPrintInfo:");
public static final int sel_indexOfTabViewItemWithIdentifier_1 = sel_registerName("indexOfTabViewItemWithIdentifier:");
public static final int sel_isEnabled = sel_registerName("isEnabled");
public static final int sel_setHeaderView_1 = sel_registerName("setHeaderView:");
public static final int sel_accessibilityHitTest_1 = sel_registerName("accessibilityHitTest:");
public static final int sel_removeMarker_1 = sel_registerName("removeMarker:");
public static final int sel_showContextHelp_1 = sel_registerName("showContextHelp:");
public static final int sel_selectsInsertedObjects = sel_registerName("selectsInsertedObjects");
public static final int sel_selectedRowInColumn_1 = sel_registerName("selectedRowInColumn:");
public static final int sel_noteNewRecentDocument_1 = sel_registerName("noteNewRecentDocument:");
public static final int sel_setAttachment_1 = sel_registerName("setAttachment:");
public static final int sel_localeIdentifier = sel_registerName("localeIdentifier");
public static final int sel_scrollLineUp_1 = sel_registerName("scrollLineUp:");
public static final int sel_setCalendarFormat_1 = sel_registerName("setCalendarFormat:");
public static final int sel_setAssociatedPoints_1atIndex_1 = sel_registerName("setAssociatedPoints:atIndex:");
public static final int sel_resourceData = sel_registerName("resourceData");
public static final int sel_setVeryShortStandaloneMonthSymbols_1 = sel_registerName("setVeryShortStandaloneMonthSymbols:");
public static final int sel_windowDidUpdate_1 = sel_registerName("windowDidUpdate:");
public static final int sel_moveLeft_1 = sel_registerName("moveLeft:");
public static final int sel_showsBorderOnlyWhileMouseInside = sel_registerName("showsBorderOnlyWhileMouseInside");
public static final int sel_valueForKey_1 = sel_registerName("valueForKey:");
public static final int sel_setContentResizeIncrements_1 = sel_registerName("setContentResizeIncrements:");
public static final int sel_drain = sel_registerName("drain");
public static final int sel_concat = sel_registerName("concat");
public static final int sel_scrollerWidthForControlSize_1 = sel_registerName("scrollerWidthForControlSize:");
public static final int sel_insertItemWithTitle_1action_1keyEquivalent_1atIndex_1 = sel_registerName("insertItemWithTitle:action:keyEquivalent:atIndex:");
public static final int sel_doubleValue = sel_registerName("doubleValue");
public static final int sel_dividerThickness = sel_registerName("dividerThickness");
public static final int sel_rowAtPoint_1 = sel_registerName("rowAtPoint:");
public static final int sel_updateWindowsItem_1 = sel_registerName("updateWindowsItem:");
public static final int sel_calendarDate = sel_registerName("calendarDate");
public static final int sel_fixAttachmentAttributeInRange_1 = sel_registerName("fixAttachmentAttributeInRange:");
public static final int sel_mapTableWithWeakToWeakObjects = sel_registerName("mapTableWithWeakToWeakObjects");
public static final int sel_setClip = sel_registerName("setClip");
public static final int sel_evaluationErrorNumber = sel_registerName("evaluationErrorNumber");
public static final int sel_revertToSavedFromURL_1ofType_1 = sel_registerName("revertToSavedFromURL:ofType:");
public static final int sel_autorecalculatesContentBorderThicknessForEdge_1 = sel_registerName("autorecalculatesContentBorderThicknessForEdge:");
public static final int sel_lineToPoint_1 = sel_registerName("lineToPoint:");
public static final int sel_insertionReplaces = sel_registerName("insertionReplaces");
public static final int sel_smallestEncoding = sel_registerName("smallestEncoding");
public static final int sel_elementAtIndex_1 = sel_registerName("elementAtIndex:");
public static final int sel_getReturnValue_1 = sel_registerName("getReturnValue:");
public static final int sel_regularFileContents = sel_registerName("regularFileContents");
public static final int sel_recache = sel_registerName("recache");
public static final int sel_setTextAttributesForNegativeInfinity_1 = sel_registerName("setTextAttributesForNegativeInfinity:");
public static final int sel_horizontalRulerView = sel_registerName("horizontalRulerView");
public static final int sel_initToMemory = sel_registerName("initToMemory");
public static final int sel_shouldCreateUI = sel_registerName("shouldCreateUI");
public static final int sel_scheme = sel_registerName("scheme");
public static final int sel_raiseBaseline_1 = sel_registerName("raiseBaseline:");
public static final int sel_initWithArray_1 = sel_registerName("initWithArray:");
public static final int sel_displayNameForKey_1value_1 = sel_registerName("displayNameForKey:value:");
public static final int sel_centerScanRect_1 = sel_registerName("centerScanRect:");
public static final int sel_memoryCapacity = sel_registerName("memoryCapacity");
public static final int sel_setBackgroundLayoutEnabled_1 = sel_registerName("setBackgroundLayoutEnabled:");
public static final int sel_machPort = sel_registerName("machPort");
public static final int sel_selectedFont = sel_registerName("selectedFont");
public static final int sel_tableColumns = sel_registerName("tableColumns");
public static final int sel_removeObjectAtIndex_1 = sel_registerName("removeObjectAtIndex:");
public static final int sel_insertNewButtonImage_1in_1 = sel_registerName("insertNewButtonImage:in:");
public static final int sel_stringWithContentsOfURL_1encoding_1error_1 = sel_registerName("stringWithContentsOfURL:encoding:error:");
public static final int sel_menuChangedMessagesEnabled = sel_registerName("menuChangedMessagesEnabled");
public static final int sel_initWithShort_1 = sel_registerName("initWithShort:");
public static final int sel_setColorRenderingIntent_1 = sel_registerName("setColorRenderingIntent:");
public static final int sel_descriptionWithCalendarFormat_1locale_1 = sel_registerName("descriptionWithCalendarFormat:locale:");
public static final int sel_resourceSpecifier = sel_registerName("resourceSpecifier");
public static final int sel_pasteboardByFilteringFile_1 = sel_registerName("pasteboardByFilteringFile:");
public static final int sel_dragColor_1withEvent_1fromView_1 = sel_registerName("dragColor:withEvent:fromView:");
public static final int sel_setStroke = sel_registerName("setStroke");
public static final int sel_isControllerVisible = sel_registerName("isControllerVisible");
public static final int sel_putCell_1atRow_1column_1 = sel_registerName("putCell:atRow:column:");
public static final int sel_firstIndex = sel_registerName("firstIndex");
public static final int sel_setFontManagerFactory_1 = sel_registerName("setFontManagerFactory:");
public static final int sel_exponentSymbol = sel_registerName("exponentSymbol");
public static final int sel_stringValue = sel_registerName("stringValue");
public static final int sel_getObjects_1range_1 = sel_registerName("getObjects:range:");
public static final int sel_scriptingProperties = sel_registerName("scriptingProperties");
public static final int sel_query = sel_registerName("query");
public static final int sel_eventClass = sel_registerName("eventClass");
public static final int sel_dateWithNaturalLanguageString_1 = sel_registerName("dateWithNaturalLanguageString:");
public static final int sel_datePickerMode = sel_registerName("datePickerMode");
public static final int sel_setAlternateMnemonicLocation_1 = sel_registerName("setAlternateMnemonicLocation:");
public static final int sel_stringByDeletingLastPathComponent = sel_registerName("stringByDeletingLastPathComponent");
public static final int sel_encodeObject_1 = sel_registerName("encodeObject:");
public static final int sel_unarchiveObjectWithData_1 = sel_registerName("unarchiveObjectWithData:");
public static final int sel_destination = sel_registerName("destination");
public static final int sel_ensureLayoutForCharacterRange_1 = sel_registerName("ensureLayoutForCharacterRange:");
public static final int sel_tabView_1didSelectTabViewItem_1 = sel_registerName("tabView:didSelectTabViewItem:");
public static final int sel_removeContextHelpForObject_1 = sel_registerName("removeContextHelpForObject:");
public static final int sel_ensureGlyphsForCharacterRange_1 = sel_registerName("ensureGlyphsForCharacterRange:");
public static final int sel_setMinimumFractionDigits_1 = sel_registerName("setMinimumFractionDigits:");
public static final int sel_boundsRotation = sel_registerName("boundsRotation");
public static final int sel_invalidateDisplayForGlyphRange_1 = sel_registerName("invalidateDisplayForGlyphRange:");
public static final int sel_rectForBlock_1layoutAtPoint_1inRect_1textContainer_1characterRange_1 = sel_registerName("rectForBlock:layoutAtPoint:inRect:textContainer:characterRange:");
public static final int sel_pasteFont_1 = sel_registerName("pasteFont:");
public static final int sel_backgroundColor = sel_registerName("backgroundColor");
public static final int sel_stringFromNumber_1 = sel_registerName("stringFromNumber:");
public static final int sel_expiresDate = sel_registerName("expiresDate");
public static final int sel_initWithWindowRef_1 = sel_registerName("initWithWindowRef:");
public static final int sel_toggleToolbarShown_1 = sel_registerName("toggleToolbarShown:");
public static final int sel_outlineViewItemDidExpand_1 = sel_registerName("outlineViewItemDidExpand:");
public static final int sel_TIFFRepresentationOfImageRepsInArray_1usingCompression_1factor_1 = sel_registerName("TIFFRepresentationOfImageRepsInArray:usingCompression:factor:");
public static final int sel_variable = sel_registerName("variable");
public static final int sel_objectsForKeys_1notFoundMarker_1 = sel_registerName("objectsForKeys:notFoundMarker:");
public static final int sel_controlColor = sel_registerName("controlColor");
public static final int sel_unarchiverWillFinish_1 = sel_registerName("unarchiverWillFinish:");
public static final int sel_proposedCredential = sel_registerName("proposedCredential");
public static final int sel_isPaneSplitter = sel_registerName("isPaneSplitter");
public static final int sel_endUndoGrouping = sel_registerName("endUndoGrouping");
public static final int sel_setFrameRate_1 = sel_registerName("setFrameRate:");
public static final int sel_completionDelay = sel_registerName("completionDelay");
public static final int sel_setUserFixedPitchFont_1 = sel_registerName("setUserFixedPitchFont:");
public static final int sel_isIndeterminate = sel_registerName("isIndeterminate");
public static final int sel_menuItem = sel_registerName("menuItem");
public static final int sel_setNumberStyle_1 = sel_registerName("setNumberStyle:");
public static final int sel_takeIntegerValueFrom_1 = sel_registerName("takeIntegerValueFrom:");
public static final int sel_setIndentationMarkerFollowsCell_1 = sel_registerName("setIndentationMarkerFollowsCell:");
public static final int sel_tile = sel_registerName("tile");
public static final int sel_cancelButtonRectForBounds_1 = sel_registerName("cancelButtonRectForBounds:");
public static final int sel_deselectRow_1 = sel_registerName("deselectRow:");
public static final int sel_setMouseCoalescingEnabled_1 = sel_registerName("setMouseCoalescingEnabled:");
public static final int sel_removeWindowController_1 = sel_registerName("removeWindowController:");
public static final int sel_warningValue = sel_registerName("warningValue");
public static final int sel_isVerticallyResizable = sel_registerName("isVerticallyResizable");
public static final int sel_defaultFetchRequest = sel_registerName("defaultFetchRequest");
public static final int sel_netServiceWillResolve_1 = sel_registerName("netServiceWillResolve:");
public static final int sel_addProgressMark_1 = sel_registerName("addProgressMark:");
public static final int sel_recentsAutosaveName = sel_registerName("recentsAutosaveName");
public static final int sel_commitEditing = sel_registerName("commitEditing");
public static final int sel_attributesOfItemAtPath_1error_1 = sel_registerName("attributesOfItemAtPath:error:");
public static final int sel_download_1willSendRequest_1redirectResponse_1 = sel_registerName("download:willSendRequest:redirectResponse:");
public static final int sel_canBeCompressedUsing_1 = sel_registerName("canBeCompressedUsing:");
public static final int sel_strokeRect_1 = sel_registerName("strokeRect:");
public static final int sel_descriptionWithLocale_1indent_1 = sel_registerName("descriptionWithLocale:indent:");
public static final int sel_applicationDockMenu_1 = sel_registerName("applicationDockMenu:");
public static final int sel_initWithCString_1length_1 = sel_registerName("initWithCString:length:");
public static final int sel_runPageLayout_1 = sel_registerName("runPageLayout:");
public static final int sel_toolbar_1itemForItemIdentifier_1willBeInsertedIntoToolbar_1 = sel_registerName("toolbar:itemForItemIdentifier:willBeInsertedIntoToolbar:");
public static final int sel_setSelectsInsertedObjects_1 = sel_registerName("setSelectsInsertedObjects:");
public static final int sel_alternateSelectedControlTextColor = sel_registerName("alternateSelectedControlTextColor");
public static final int sel_isValidGlyphIndex_1 = sel_registerName("isValidGlyphIndex:");
public static final int sel_stringForKey_1inTable_1 = sel_registerName("stringForKey:inTable:");
public static final int sel_cellSizeForBounds_1 = sel_registerName("cellSizeForBounds:");
public static final int sel_beginSheetForDirectory_1file_1modalForWindow_1modalDelegate_1didEndSelector_1contextInfo_1 = sel_registerName("beginSheetForDirectory:file:modalForWindow:modalDelegate:didEndSelector:contextInfo:");
public static final int sel_invalidateLayoutForCharacterRange_1actualCharacterRange_1 = sel_registerName("invalidateLayoutForCharacterRange:actualCharacterRange:");
public static final int sel_initAsTearOff = sel_registerName("initAsTearOff");
public static final int sel_allowsOtherFileTypes = sel_registerName("allowsOtherFileTypes");
public static final int sel_mouseMoved_1 = sel_registerName("mouseMoved:");
public static final int sel_deleteCharactersInRange_1 = sel_registerName("deleteCharactersInRange:");
public static final int sel_setTitleFont_1 = sel_registerName("setTitleFont:");
public static final int sel_showsApplicationBadge = sel_registerName("showsApplicationBadge");
public static final int sel_initWithLeftExpression_1rightExpression_1modifier_1type_1options_1 = sel_registerName("initWithLeftExpression:rightExpression:modifier:type:options:");
public static final int sel_distantPast = sel_registerName("distantPast");
public static final int sel_isReady = sel_registerName("isReady");
public static final int sel_draggedImage_1movedTo_1 = sel_registerName("draggedImage:movedTo:");
public static final int sel_resetTotalAutoreleasedObjects = sel_registerName("resetTotalAutoreleasedObjects");
public static final int sel_setGlyphGenerator_1 = sel_registerName("setGlyphGenerator:");
public static final int sel_groupsByEvent = sel_registerName("groupsByEvent");
public static final int sel_shortMonthSymbols = sel_registerName("shortMonthSymbols");
public static final int sel_setDescriptor_1forKeyword_1 = sel_registerName("setDescriptor:forKeyword:");
public static final int sel_description = sel_registerName("description");
public static final int sel_replaceOccurrencesOfString_1withString_1options_1range_1 = sel_registerName("replaceOccurrencesOfString:withString:options:range:");
public static final int sel_boundsRectForContentRect_1inRect_1textContainer_1characterRange_1 = sel_registerName("boundsRectForContentRect:inRect:textContainer:characterRange:");
public static final int sel_authenticationDataForComponents_1 = sel_registerName("authenticationDataForComponents:");
public static final int sel_isExecuting = sel_registerName("isExecuting");
public static final int sel_branchImage = sel_registerName("branchImage");
public static final int sel_decodeRectForKey_1 = sel_registerName("decodeRectForKey:");
public static final int sel_rectValue = sel_registerName("rectValue");
public static final int sel_setFrameTopLeftPoint_1 = sel_registerName("setFrameTopLeftPoint:");
public static final int sel_initWithFileDescriptor_1 = sel_registerName("initWithFileDescriptor:");
public static final int sel_removePointerAtIndex_1 = sel_registerName("removePointerAtIndex:");
public static final int sel_executeAndReturnError_1 = sel_registerName("executeAndReturnError:");
public static final int sel_changeCaseOfLetter_1 = sel_registerName("changeCaseOfLetter:");
public static final int sel_appendBezierPathWithArcWithCenter_1radius_1startAngle_1endAngle_1clockwise_1 = sel_registerName("appendBezierPathWithArcWithCenter:radius:startAngle:endAngle:clockwise:");
public static final int sel_insertNewlineIgnoringFieldEditor_1 = sel_registerName("insertNewlineIgnoringFieldEditor:");
public static final int sel_attributeDescriptorForKeyword_1 = sel_registerName("attributeDescriptorForKeyword:");
public static final int sel_decimalNumberWithMantissa_1exponent_1isNegative_1 = sel_registerName("decimalNumberWithMantissa:exponent:isNegative:");
public static final int sel_activeConversationWillChange_1fromOldConversation_1 = sel_registerName("activeConversationWillChange:fromOldConversation:");
public static final int sel_layoutAlgorithm = sel_registerName("layoutAlgorithm");
public static final int sel_itemNumberInTextList_1atIndex_1 = sel_registerName("itemNumberInTextList:atIndex:");
public static final int sel_initWithImage_1hotSpot_1 = sel_registerName("initWithImage:hotSpot:");
public static final int sel_setStackSize_1 = sel_registerName("setStackSize:");
public static final int sel_matrixInColumn_1 = sel_registerName("matrixInColumn:");
public static final int sel_performSelector_1withObject_1 = sel_registerName("performSelector:withObject:");
public static final int sel_setSound_1 = sel_registerName("setSound:");
public static final int sel_accessibilityPerformAction_1 = sel_registerName("accessibilityPerformAction:");
public static final int sel_comment = sel_registerName("comment");
public static final int sel_rangeOfNominallySpacedGlyphsContainingIndex_1 = sel_registerName("rangeOfNominallySpacedGlyphsContainingIndex:");
public static final int sel_showAttachmentCell_1inRect_1characterIndex_1 = sel_registerName("showAttachmentCell:inRect:characterIndex:");
public static final int sel_isDisplayedWhenStopped = sel_registerName("isDisplayedWhenStopped");
public static final int sel_addCollection_1options_1 = sel_registerName("addCollection:options:");
public static final int sel_drawInRect_1angle_1 = sel_registerName("drawInRect:angle:");
public static final int sel_initWithFrame_1mode_1prototype_1numberOfRows_1numberOfColumns_1 = sel_registerName("initWithFrame:mode:prototype:numberOfRows:numberOfColumns:");
public static final int sel_sharedCredentialStorage = sel_registerName("sharedCredentialStorage");
public static final int sel_colorWithDeviceWhite_1alpha_1 = sel_registerName("colorWithDeviceWhite:alpha:");
public static final int sel_setMainDocumentURL_1 = sel_registerName("setMainDocumentURL:");
public static final int sel_interpretKeyEvents_1 = sel_registerName("interpretKeyEvents:");
public static final int sel_readFromData_1ofType_1error_1 = sel_registerName("readFromData:ofType:error:");
public static final int sel_tokenFieldCell_1menuForRepresentedObject_1 = sel_registerName("tokenFieldCell:menuForRepresentedObject:");
public static final int sel_setEventHandler_1andSelector_1forEventClass_1andEventID_1 = sel_registerName("setEventHandler:andSelector:forEventClass:andEventID:");
public static final int sel_addAttribute_1value_1range_1 = sel_registerName("addAttribute:value:range:");
public static final int sel_outlineView_1writeItems_1toPasteboard_1 = sel_registerName("outlineView:writeItems:toPasteboard:");
public static final int sel_initWithCString_1encoding_1 = sel_registerName("initWithCString:encoding:");
public static final int sel_setTypesetterBehavior_1 = sel_registerName("setTypesetterBehavior:");
public static final int sel_removeObjectAtArrangedObjectIndex_1 = sel_registerName("removeObjectAtArrangedObjectIndex:");
public static final int sel_redo = sel_registerName("redo");
public static final int sel_addMarker_1 = sel_registerName("addMarker:");
public static final int sel_backgroundColors = sel_registerName("backgroundColors");
public static final int sel_leafKeyPath = sel_registerName("leafKeyPath");
public static final int sel_setMinimumIntegerDigits_1 = sel_registerName("setMinimumIntegerDigits:");
public static final int sel_waitForDataInBackgroundAndNotify = sel_registerName("waitForDataInBackgroundAndNotify");
public static final int sel_setPreservesContentDuringLiveResize_1 = sel_registerName("setPreservesContentDuringLiveResize:");
public static final int sel_setRootElement_1 = sel_registerName("setRootElement:");
public static final int sel_dataWithEPSInsideRect_1 = sel_registerName("dataWithEPSInsideRect:");
public static final int sel_valuesForKeys_1 = sel_registerName("valuesForKeys:");
public static final int sel_imageOrigin = sel_registerName("imageOrigin");
public static final int sel_writePDFInsideRect_1toPasteboard_1 = sel_registerName("writePDFInsideRect:toPasteboard:");
public static final int sel_sortIndicatorRectForBounds_1 = sel_registerName("sortIndicatorRectForBounds:");
public static final int sel_predefinedNamespaceForPrefix_1 = sel_registerName("predefinedNamespaceForPrefix:");
public static final int sel_viewWillStartLiveResize = sel_registerName("viewWillStartLiveResize");
public static final int sel_becomeKeyWindow = sel_registerName("becomeKeyWindow");
public static final int sel_isHighlighted = sel_registerName("isHighlighted");
public static final int sel_initWithPickerMask_1colorPanel_1 = sel_registerName("initWithPickerMask:colorPanel:");
public static final int sel_systemFontOfSize_1 = sel_registerName("systemFontOfSize:");
public static final int sel_decimalNumberBySubtracting_1withBehavior_1 = sel_registerName("decimalNumberBySubtracting:withBehavior:");
public static final int sel_hide_1 = sel_registerName("hide:");
public static final int sel_resetSearchButtonCell = sel_registerName("resetSearchButtonCell");
public static final int sel_runModalForDirectory_1file_1types_1 = sel_registerName("runModalForDirectory:file:types:");
public static final int sel_pathForImageResource_1 = sel_registerName("pathForImageResource:");
public static final int sel_setFilterPredicate_1 = sel_registerName("setFilterPredicate:");
public static final int sel_validateEditing = sel_registerName("validateEditing");
public static final int sel_makeDocumentForURL_1withContentsOfURL_1ofType_1error_1 = sel_registerName("makeDocumentForURL:withContentsOfURL:ofType:error:");
public static final int sel_localizedCompare_1 = sel_registerName("localizedCompare:");
public static final int sel_sharedWorkspace = sel_registerName("sharedWorkspace");
public static final int sel_deliverResult = sel_registerName("deliverResult");
public static final int sel_aspectRatio = sel_registerName("aspectRatio");
public static final int sel_keyEventWithType_1location_1modifierFlags_1timestamp_1windowNumber_1context_1characters_1charactersIgnoringModifiers_1isARepeat_1keyCode_1 = sel_registerName("keyEventWithType:location:modifierFlags:timestamp:windowNumber:context:characters:charactersIgnoringModifiers:isARepeat:keyCode:");
public static final int sel_soundUnfilteredPasteboardTypes = sel_registerName("soundUnfilteredPasteboardTypes");
public static final int sel_dateByAddingComponents_1toDate_1options_1 = sel_registerName("dateByAddingComponents:toDate:options:");
public static final int sel_indentationMarkerFollowsCell = sel_registerName("indentationMarkerFollowsCell");
public static final int sel_typesetter = sel_registerName("typesetter");
public static final int sel_childCount = sel_registerName("childCount");
public static final int sel_borderRect = sel_registerName("borderRect");
public static final int sel_setPageOrder_1 = sel_registerName("setPageOrder:");
public static final int sel_currentThread = sel_registerName("currentThread");
public static final int sel_textViewDidChangeSelection_1 = sel_registerName("textViewDidChangeSelection:");
public static final int sel_setBaseWritingDirection_1 = sel_registerName("setBaseWritingDirection:");
public static final int sel_attributedSubstringForProposedRange_1actualRange_1 = sel_registerName("attributedSubstringForProposedRange:actualRange:");
public static final int sel_pop = sel_registerName("pop");
public static final int sel_animator = sel_registerName("animator");
public static final int sel_allowsEmptySelection = sel_registerName("allowsEmptySelection");
public static final int sel_scriptingIsGreaterThanOrEqualTo_1 = sel_registerName("scriptingIsGreaterThanOrEqualTo:");
public static final int sel_numberOfSelectedRows = sel_registerName("numberOfSelectedRows");
public static final int sel_imageDidNotDraw_1inRect_1 = sel_registerName("imageDidNotDraw:inRect:");
public static final int sel_topLevelObject = sel_registerName("topLevelObject");
public static final int sel_openDocumentWithContentsOfURL_1display_1 = sel_registerName("openDocumentWithContentsOfURL:display:");
public static final int sel_valueListAttributes = sel_registerName("valueListAttributes");
public static final int sel_enableFreedObjectCheck_1 = sel_registerName("enableFreedObjectCheck:");
public static final int sel_moveForward_1 = sel_registerName("moveForward:");
public static final int sel_setSendsActionOnArrowKeys_1 = sel_registerName("setSendsActionOnArrowKeys:");
public static final int sel_versionForClassName_1 = sel_registerName("versionForClassName:");
public static final int sel_coerceValue_1forKey_1 = sel_registerName("coerceValue:forKey:");
public static final int sel_operatingSystem = sel_registerName("operatingSystem");
public static final int sel_characterEncoding = sel_registerName("characterEncoding");
public static final int sel_blendedColorWithFraction_1ofColor_1 = sel_registerName("blendedColorWithFraction:ofColor:");
public static final int sel_panel_1userEnteredFilename_1confirmed_1 = sel_registerName("panel:userEnteredFilename:confirmed:");
public static final int sel_addSelectedObjects_1 = sel_registerName("addSelectedObjects:");
public static final int sel_pointingDeviceID = sel_registerName("pointingDeviceID");
public static final int sel_children = sel_registerName("children");
public static final int sel_takeObjectValueFrom_1 = sel_registerName("takeObjectValueFrom:");
public static final int sel_indexSet = sel_registerName("indexSet");
public static final int sel_setMovie_1 = sel_registerName("setMovie:");
public static final int sel_setKeyEquivalentModifierMask_1 = sel_registerName("setKeyEquivalentModifierMask:");
public static final int sel_allowsKeyedCoding = sel_registerName("allowsKeyedCoding");
public static final int sel_rotateByDegrees_1 = sel_registerName("rotateByDegrees:");
public static final int sel_compoundTypes = sel_registerName("compoundTypes");
public static final int sel_setShortStandaloneWeekdaySymbols_1 = sel_registerName("setShortStandaloneWeekdaySymbols:");
public static final int sel_removeWindowsItem_1 = sel_registerName("removeWindowsItem:");
public static final int sel_stringArrayForKey_1 = sel_registerName("stringArrayForKey:");
public static final int sel_outlineView_1typeSelectStringForTableColumn_1item_1 = sel_registerName("outlineView:typeSelectStringForTableColumn:item:");
public static final int sel_initWithWindow_1 = sel_registerName("initWithWindow:");
public static final int sel_accessibilityIsAttributeSettable_1 = sel_registerName("accessibilityIsAttributeSettable:");
public static final int sel_rangeForUserCharacterAttributeChange = sel_registerName("rangeForUserCharacterAttributeChange");
public static final int sel_setCalendar_1 = sel_registerName("setCalendar:");
public static final int sel_beginEditing = sel_registerName("beginEditing");
public static final int sel_enableUpdates = sel_registerName("enableUpdates");
public static final int sel_setPrefersAllColumnUserResizing_1 = sel_registerName("setPrefersAllColumnUserResizing:");
public static final int sel_isTornOff = sel_registerName("isTornOff");
public static final int sel_checkSpellingOfString_1startingAt_1 = sel_registerName("checkSpellingOfString:startingAt:");
public static final int sel_drawPackedGlyphs_1atPoint_1 = sel_registerName("drawPackedGlyphs:atPoint:");
public static final int sel_graphicsContextWithAttributes_1 = sel_registerName("graphicsContextWithAttributes:");
public static final int sel_textView_1completions_1forPartialWordRange_1indexOfSelectedItem_1 = sel_registerName("textView:completions:forPartialWordRange:indexOfSelectedItem:");
public static final int sel_outlineView_1shouldExpandItem_1 = sel_registerName("outlineView:shouldExpandItem:");
public static final int sel_isInFullScreenMode = sel_registerName("isInFullScreenMode");
public static final int sel_userKeyEquivalent = sel_registerName("userKeyEquivalent");
public static final int sel_menuBarHeight = sel_registerName("menuBarHeight");
public static final int sel_initWithSize_1depth_1separate_1alpha_1 = sel_registerName("initWithSize:depth:separate:alpha:");
public static final int sel_criticalValue = sel_registerName("criticalValue");
public static final int sel_tableView_1didClickTableColumn_1 = sel_registerName("tableView:didClickTableColumn:");
public static final int sel_addChildWindow_1ordered_1 = sel_registerName("addChildWindow:ordered:");
public static final int sel_autoscroll_1 = sel_registerName("autoscroll:");
public static final int sel_infoDictionary = sel_registerName("infoDictionary");
public static final int sel_printOperationWithSettings_1error_1 = sel_registerName("printOperationWithSettings:error:");
public static final int sel_translateOriginToPoint_1 = sel_registerName("translateOriginToPoint:");
public static final int sel_takeStoredValue_1forKey_1 = sel_registerName("takeStoredValue:forKey:");
public static final int sel_mouseUp_1 = sel_registerName("mouseUp:");
public static final int sel_setNotationName_1 = sel_registerName("setNotationName:");
public static final int sel_setArgument_1atIndex_1 = sel_registerName("setArgument:atIndex:");
public static final int sel_setSelectedAttributes_1isMultiple_1 = sel_registerName("setSelectedAttributes:isMultiple:");
public static final int sel_dayOfCommonEra = sel_registerName("dayOfCommonEra");
public static final int sel_greenColor = sel_registerName("greenColor");
public static final int sel_initWithProtocolFamily_1socketType_1protocol_1address_1 = sel_registerName("initWithProtocolFamily:socketType:protocol:address:");
public static final int sel_setAttachmentCell_1 = sel_registerName("setAttachmentCell:");
public static final int sel_previousFailureCount = sel_registerName("previousFailureCount");
public static final int sel_currentOperation = sel_registerName("currentOperation");
public static final int sel_tokenField_1completionsForSubstring_1indexOfToken_1indexOfSelectedItem_1 = sel_registerName("tokenField:completionsForSubstring:indexOfToken:indexOfSelectedItem:");
public static final int sel_positionOfGlyph_1struckOverGlyph_1metricsExist_1 = sel_registerName("positionOfGlyph:struckOverGlyph:metricsExist:");
public static final int sel_setMarkedTextAttributes_1 = sel_registerName("setMarkedTextAttributes:");
public static final int sel_validateToolbarItem_1 = sel_registerName("validateToolbarItem:");
public static final int sel_startingColumn = sel_registerName("startingColumn");
public static final int sel_setSelectedRanges_1 = sel_registerName("setSelectedRanges:");
public static final int sel_addItemWithTitle_1action_1keyEquivalent_1 = sel_registerName("addItemWithTitle:action:keyEquivalent:");
public static final int sel_postNotificationName_1object_1 = sel_registerName("postNotificationName:object:");
public static final int sel_replacementObjectForKeyedArchiver_1 = sel_registerName("replacementObjectForKeyedArchiver:");
public static final int sel_deletesFileUponFailure = sel_registerName("deletesFileUponFailure");
public static final int sel_speechRecognizer_1didRecognizeCommand_1 = sel_registerName("speechRecognizer:didRecognizeCommand:");
public static final int sel_columnSpan = sel_registerName("columnSpan");
public static final int sel_animationBlockingMode = sel_registerName("animationBlockingMode");
public static final int sel_drawParts = sel_registerName("drawParts");
public static final int sel_style = sel_registerName("style");
public static final int sel_makeUntitledDocumentOfType_1error_1 = sel_registerName("makeUntitledDocumentOfType:error:");
public static final int sel_filteredArrayUsingPredicate_1 = sel_registerName("filteredArrayUsingPredicate:");
public static final int sel_wantsDefaultClipping = sel_registerName("wantsDefaultClipping");
public static final int sel_one = sel_registerName("one");
public static final int sel_persistentStoreTypeForFileType_1 = sel_registerName("persistentStoreTypeForFileType:");
public static final int sel_pixelsHigh = sel_registerName("pixelsHigh");
public static final int sel_rulerView_1shouldMoveMarker_1 = sel_registerName("rulerView:shouldMoveMarker:");
public static final int sel_sizeWithAttributes_1 = sel_registerName("sizeWithAttributes:");
public static final int sel_drawTitleOfColumn_1inRect_1 = sel_registerName("drawTitleOfColumn:inRect:");
public static final int sel_setLevelsOfUndo_1 = sel_registerName("setLevelsOfUndo:");
public static final int sel_invoke = sel_registerName("invoke");
public static final int sel_keyEnumerator = sel_registerName("keyEnumerator");
public static final int sel_convertFont_1toSize_1 = sel_registerName("convertFont:toSize:");
public static final int sel_mouseExited_1withFrame_1inView_1 = sel_registerName("mouseExited:withFrame:inView:");
public static final int sel_widthAdjustLimit = sel_registerName("widthAdjustLimit");
public static final int sel_animationResizeTime_1 = sel_registerName("animationResizeTime:");
public static final int sel_ensureLayoutForBoundingRect_1inTextContainer_1 = sel_registerName("ensureLayoutForBoundingRect:inTextContainer:");
public static final int sel_initWithExpressionType_1 = sel_registerName("initWithExpressionType:");
public static final int sel_numberWithUnsignedChar_1 = sel_registerName("numberWithUnsignedChar:");
public static final int sel_directory = sel_registerName("directory");
public static final int sel_address = sel_registerName("address");
public static final int sel_defaultPixelFormat = sel_registerName("defaultPixelFormat");
public static final int sel_deleteBackwardByDecomposingPreviousCharacter_1 = sel_registerName("deleteBackwardByDecomposingPreviousCharacter:");
public static final int sel_clickCount = sel_registerName("clickCount");
public static final int sel_trackMarker_1withMouseEvent_1 = sel_registerName("trackMarker:withMouseEvent:");
public static final int sel_URL_1resourceDataDidBecomeAvailable_1 = sel_registerName("URL:resourceDataDidBecomeAvailable:");
public static final int sel_outlineView_1setObjectValue_1forTableColumn_1byItem_1 = sel_registerName("outlineView:setObjectValue:forTableColumn:byItem:");
public static final int sel_insert_1 = sel_registerName("insert:");
public static final int sel_methodForSelector_1 = sel_registerName("methodForSelector:");
public static final int sel_insertGlyph_1atGlyphIndex_1characterIndex_1 = sel_registerName("insertGlyph:atGlyphIndex:characterIndex:");
public static final int sel_readFromFileWrapper_1ofType_1error_1 = sel_registerName("readFromFileWrapper:ofType:error:");
public static final int sel_selectedControlColor = sel_registerName("selectedControlColor");
public static final int sel_selectedRow = sel_registerName("selectedRow");
public static final int sel_control_1isValidObject_1 = sel_registerName("control:isValidObject:");
public static final int sel_setUniqueID_1 = sel_registerName("setUniqueID:");
public static final int sel_initWithName_1fromFile_1 = sel_registerName("initWithName:fromFile:");
public static final int sel_sizeOfLabel_1 = sel_registerName("sizeOfLabel:");
public static final int sel_credentialsForProtectionSpace_1 = sel_registerName("credentialsForProtectionSpace:");
public static final int sel_anyObject = sel_registerName("anyObject");
public static final int sel_runLoopModesForAnimating = sel_registerName("runLoopModesForAnimating");
public static final int sel_setSortDescriptors_1 = sel_registerName("setSortDescriptors:");
public static final int sel_convertSize_1toView_1 = sel_registerName("convertSize:toView:");
public static final int sel_setLineFragmentRect_1forGlyphRange_1usedRect_1 = sel_registerName("setLineFragmentRect:forGlyphRange:usedRect:");
public static final int sel_discardEditing = sel_registerName("discardEditing");
public static final int sel_isAutodisplay = sel_registerName("isAutodisplay");
public static final int sel_matchesOnMultipleResolution = sel_registerName("matchesOnMultipleResolution");
public static final int sel_multipleThreadsEnabled = sel_registerName("multipleThreadsEnabled");
public static final int sel_positionOfGlyph_1forCharacter_1struckOverRect_1 = sel_registerName("positionOfGlyph:forCharacter:struckOverRect:");
public static final int sel_boundsRectForBlock_1contentRect_1inRect_1textContainer_1characterRange_1 = sel_registerName("boundsRectForBlock:contentRect:inRect:textContainer:characterRange:");
public static final int sel_outlineView_1objectValueForTableColumn_1byItem_1 = sel_registerName("outlineView:objectValueForTableColumn:byItem:");
public static final int sel_transformPoint_1 = sel_registerName("transformPoint:");
public static final int sel_createClassDescription = sel_registerName("createClassDescription");
public static final int sel_inputStreamWithFileAtPath_1 = sel_registerName("inputStreamWithFileAtPath:");
public static final int sel_menuForEvent_1inRect_1ofView_1 = sel_registerName("menuForEvent:inRect:ofView:");
public static final int sel_setRowTypeKeyPath_1 = sel_registerName("setRowTypeKeyPath:");
public static final int sel_infoForBinding_1 = sel_registerName("infoForBinding:");
public static final int sel_setDataRetained_1 = sel_registerName("setDataRetained:");
public static final int sel_revertToContentsOfURL_1ofType_1error_1 = sel_registerName("revertToContentsOfURL:ofType:error:");
public static final int sel_currentControlTint = sel_registerName("currentControlTint");
public static final int sel_selection = sel_registerName("selection");
public static final int sel_array = sel_registerName("array");
public static final int sel_setStyle_1 = sel_registerName("setStyle:");
public static final int sel_setPredicate_1 = sel_registerName("setPredicate:");
public static final int sel_endEditing = sel_registerName("endEditing");
public static final int sel_doClick_1 = sel_registerName("doClick:");
public static final int sel_toManyRelationshipKeys = sel_registerName("toManyRelationshipKeys");
public static final int sel_selectedKnobColor = sel_registerName("selectedKnobColor");
public static final int sel_setOrderedIndex_1 = sel_registerName("setOrderedIndex:");
public static final int sel_initWithSet_1 = sel_registerName("initWithSet:");
public static final int sel_drawSelector = sel_registerName("drawSelector");
public static final int sel_requestWithURL_1 = sel_registerName("requestWithURL:");
public static final int sel_imageNamed_1 = sel_registerName("imageNamed:");
public static final int sel_hyphenationFactorForGlyphAtIndex_1 = sel_registerName("hyphenationFactorForGlyphAtIndex:");
public static final int sel_miniwindowTitle = sel_registerName("miniwindowTitle");
public static final int sel_isFileURL = sel_registerName("isFileURL");
public static final int sel_selectedSegment = sel_registerName("selectedSegment");
public static final int sel_applicationDidResignActive_1 = sel_registerName("applicationDidResignActive:");
public static final int sel_initWithString_1calendarFormat_1 = sel_registerName("initWithString:calendarFormat:");
public static final int sel_initWithProtectionSpace_1proposedCredential_1previousFailureCount_1failureResponse_1error_1sender_1 = sel_registerName("initWithProtectionSpace:proposedCredential:previousFailureCount:failureResponse:error:sender:");
public static final int sel_menuHasKeyEquivalent_1forEvent_1target_1action_1 = sel_registerName("menuHasKeyEquivalent:forEvent:target:action:");
public static final int sel_minPossiblePositionOfDividerAtIndex_1 = sel_registerName("minPossiblePositionOfDividerAtIndex:");
public static final int sel_abbreviationForDate_1 = sel_registerName("abbreviationForDate:");
public static final int sel_absoluteX = sel_registerName("absoluteX");
public static final int sel_scriptErrorNumber = sel_registerName("scriptErrorNumber");
public static final int sel_previousValidKeyView = sel_registerName("previousValidKeyView");
public static final int sel_valueWithRange_1 = sel_registerName("valueWithRange:");
public static final int sel_initWithDefaults_1initialValues_1 = sel_registerName("initWithDefaults:initialValues:");
public static final int sel_initNotTestWithTest_1 = sel_registerName("initNotTestWithTest:");
public static final int sel_abortModal = sel_registerName("abortModal");
public static final int sel_isSuspended = sel_registerName("isSuspended");
public static final int sel_isFilePackageAtPath_1 = sel_registerName("isFilePackageAtPath:");
public static final int sel_useCredential_1forAuthenticationChallenge_1 = sel_registerName("useCredential:forAuthenticationChallenge:");
public static final int sel_draggingSequenceNumber = sel_registerName("draggingSequenceNumber");
public static final int sel_lastColumn = sel_registerName("lastColumn");
public static final int sel_distantFuture = sel_registerName("distantFuture");
public static final int sel_download_1didReceiveResponse_1 = sel_registerName("download:didReceiveResponse:");
public static final int sel_textTransform = sel_registerName("textTransform");
public static final int sel_hasHorizontalScroller = sel_registerName("hasHorizontalScroller");
public static final int sel_shadowBlurRadius = sel_registerName("shadowBlurRadius");
public static final int sel_pointingDeviceType = sel_registerName("pointingDeviceType");
public static final int sel_setMenuView_1 = sel_registerName("setMenuView:");
public static final int sel_setWindingRule_1 = sel_registerName("setWindingRule:");
public static final int sel_imageForSegment_1 = sel_registerName("imageForSegment:");
public static final int sel_bytes = sel_registerName("bytes");
public static final int sel_propertyListFromStringsFileFormat = sel_registerName("propertyListFromStringsFileFormat");
public static final int sel_setParagraphStyle_1 = sel_registerName("setParagraphStyle:");
public static final int sel_highlightMode = sel_registerName("highlightMode");
public static final int sel_voice = sel_registerName("voice");
public static final int sel_hostName = sel_registerName("hostName");
public static final int sel_removeAccessoryController_1 = sel_registerName("removeAccessoryController:");
public static final int sel_rowsInRect_1 = sel_registerName("rowsInRect:");
public static final int sel_registerImageRepClass_1 = sel_registerName("registerImageRepClass:");
public static final int sel_value_1withObjCType_1 = sel_registerName("value:withObjCType:");
public static final int sel_enclosingMenuItem = sel_registerName("enclosingMenuItem");
public static final int sel_exposedBindings = sel_registerName("exposedBindings");
public static final int sel_setSharedScriptSuiteRegistry_1 = sel_registerName("setSharedScriptSuiteRegistry:");
public static final int sel_readablePasteboardTypes = sel_registerName("readablePasteboardTypes");
public static final int sel_drawViewBackgroundInRect_1 = sel_registerName("drawViewBackgroundInRect:");
public static final int sel_setDataCell_1 = sel_registerName("setDataCell:");
public static final int sel_dataRepresentationOfType_1 = sel_registerName("dataRepresentationOfType:");
public static final int sel_setOrientation_1 = sel_registerName("setOrientation:");
public static final int sel_setFileWrapper_1 = sel_registerName("setFileWrapper:");
public static final int sel_runModalOpenPanel_1forTypes_1 = sel_registerName("runModalOpenPanel:forTypes:");
public static final int sel_adjustSubviews = sel_registerName("adjustSubviews");
public static final int sel_setCurrencyDecimalSeparator_1 = sel_registerName("setCurrencyDecimalSeparator:");
public static final int sel_needsDisplay = sel_registerName("needsDisplay");
public static final int sel_insertValue_1atIndex_1inPropertyWithKey_1 = sel_registerName("insertValue:atIndex:inPropertyWithKey:");
public static final int sel_setTextStorage_1 = sel_registerName("setTextStorage:");
public static final int sel_isAlternate = sel_registerName("isAlternate");
public static final int sel_setOutputFormat_1 = sel_registerName("setOutputFormat:");
public static final int sel_comboBoxWillPopUp_1 = sel_registerName("comboBoxWillPopUp:");
public static final int sel_insertChild_1 = sel_registerName("insertChild:");
public static final int sel_initWithCommandDescription_1 = sel_registerName("initWithCommandDescription:");
public static final int sel_setLineDash_1count_1phase_1 = sel_registerName("setLineDash:count:phase:");
public static final int sel_setHardInvalidation_1forGlyphRange_1 = sel_registerName("setHardInvalidation:forGlyphRange:");
public static final int sel_setAllowsToolTipsWhenApplicationIsInactive_1 = sel_registerName("setAllowsToolTipsWhenApplicationIsInactive:");
public static final int sel_tableView_1namesOfPromisedFilesDroppedAtDestination_1forDraggedRowsWithIndexes_1 = sel_registerName("tableView:namesOfPromisedFilesDroppedAtDestination:forDraggedRowsWithIndexes:");
public static final int sel_highlightedItemIndex = sel_registerName("highlightedItemIndex");
public static final int sel_trailingOffset = sel_registerName("trailingOffset");
public static final int sel_layer = sel_registerName("layer");
public static final int sel_isDeletableFileAtPath_1 = sel_registerName("isDeletableFileAtPath:");
public static final int sel_textUnfilteredTypes = sel_registerName("textUnfilteredTypes");
public static final int sel_gregorianStartDate = sel_registerName("gregorianStartDate");
public static final int sel_isDocumentEdited = sel_registerName("isDocumentEdited");
public static final int sel_colorWithCalibratedWhite_1alpha_1 = sel_registerName("colorWithCalibratedWhite:alpha:");
public static final int sel_shouldRunSavePanelWithAccessoryView = sel_registerName("shouldRunSavePanelWithAccessoryView");
public static final int sel_finishEncoding = sel_registerName("finishEncoding");
public static final int sel_setKeyCell_1 = sel_registerName("setKeyCell:");
public static final int sel_isPartialStringValid_1newEditingString_1errorDescription_1 = sel_registerName("isPartialStringValid:newEditingString:errorDescription:");
public static final int sel_setRangeContainerObject_1 = sel_registerName("setRangeContainerObject:");
public static final int sel_typeOfFile_1error_1 = sel_registerName("typeOfFile:error:");
public static final int sel_disappearingItemCursor = sel_registerName("disappearingItemCursor");
public static final int sel_textureMaxMipMapLevel = sel_registerName("textureMaxMipMapLevel");
public static final int sel_setEraSymbols_1 = sel_registerName("setEraSymbols:");
public static final int sel_setBordered_1 = sel_registerName("setBordered:");
public static final int sel_precomposedStringWithCanonicalMapping = sel_registerName("precomposedStringWithCanonicalMapping");
public static final int sel_setEnabled_1 = sel_registerName("setEnabled:");
public static final int sel_setChildrenKeyPath_1 = sel_registerName("setChildrenKeyPath:");
public static final int sel_applicationDidBecomeActive_1 = sel_registerName("applicationDidBecomeActive:");
public static final int sel_setCancelButtonCell_1 = sel_registerName("setCancelButtonCell:");
public static final int sel_backgroundFilters = sel_registerName("backgroundFilters");
public static final int sel_indexOfCellWithTag_1 = sel_registerName("indexOfCellWithTag:");
public static final int sel_UTF8String = sel_registerName("UTF8String");
public static final int sel_horizontalPagination = sel_registerName("horizontalPagination");
public static final int sel_allowedInputSourceLocales = sel_registerName("allowedInputSourceLocales");
public static final int sel_toolbar = sel_registerName("toolbar");
public static final int sel_setGeneratesDecimalNumbers_1 = sel_registerName("setGeneratesDecimalNumbers:");
public static final int sel_highlight_1withFrame_1inView_1 = sel_registerName("highlight:withFrame:inView:");
public static final int sel_rotation = sel_registerName("rotation");
public static final int sel_colorForControlTint_1 = sel_registerName("colorForControlTint:");
public static final int sel_mutableString = sel_registerName("mutableString");
public static final int sel_shadowWithLevel_1 = sel_registerName("shadowWithLevel:");
public static final int sel_frameRectForContentRect_1styleMask_1 = sel_registerName("frameRectForContentRect:styleMask:");
public static final int sel_numberOfColorComponents = sel_registerName("numberOfColorComponents");
public static final int sel_alternateImage = sel_registerName("alternateImage");
public static final int sel_initWithString_1relativeToURL_1 = sel_registerName("initWithString:relativeToURL:");
public static final int sel_pageOrder = sel_registerName("pageOrder");
public static final int sel_cancel_1 = sel_registerName("cancel:");
public static final int sel_declareTypes_1owner_1 = sel_registerName("declareTypes:owner:");
public static final int sel_lastObject = sel_registerName("lastObject");
public static final int sel_type_1conformsToType_1 = sel_registerName("type:conformsToType:");
public static final int sel_mutableArrayValueForKey_1 = sel_registerName("mutableArrayValueForKey:");
public static final int sel_initWithName_1host_1 = sel_registerName("initWithName:host:");
public static final int sel_keyEquivalentWidth = sel_registerName("keyEquivalentWidth");
public static final int sel_modifier = sel_registerName("modifier");
public static final int sel_setPerMillSymbol_1 = sel_registerName("setPerMillSymbol:");
public static final int sel_setToolbar_1 = sel_registerName("setToolbar:");
public static final int sel_changeAttributes_1 = sel_registerName("changeAttributes:");
public static final int sel_removeItemWithTitle_1 = sel_registerName("removeItemWithTitle:");
public static final int sel_setAspectRatio_1 = sel_registerName("setAspectRatio:");
public static final int sel_undoManagerForTextView_1 = sel_registerName("undoManagerForTextView:");
public static final int sel_clickedPathComponentCell = sel_registerName("clickedPathComponentCell");
public static final int sel_commentWithStringValue_1 = sel_registerName("commentWithStringValue:");
public static final int sel_initWithContainerSpecifier_1key_1 = sel_registerName("initWithContainerSpecifier:key:");
public static final int sel_windowWillReturnUndoManager_1 = sel_registerName("windowWillReturnUndoManager:");
public static final int sel_imageAndTitleOffset = sel_registerName("imageAndTitleOffset");
public static final int sel_initialize = sel_registerName("initialize");
public static final int sel_truncatesLastVisibleLine = sel_registerName("truncatesLastVisibleLine");
public static final int sel_setExponentSymbol_1 = sel_registerName("setExponentSymbol:");
public static final int sel_setCurrentProgress_1 = sel_registerName("setCurrentProgress:");
public static final int sel_initWithContentsOfFile_1options_1error_1 = sel_registerName("initWithContentsOfFile:options:error:");
public static final int sel_titleCell = sel_registerName("titleCell");
public static final int sel_setCurrencySymbol_1 = sel_registerName("setCurrencySymbol:");
public static final int sel_usesScreenFonts = sel_registerName("usesScreenFonts");
public static final int sel_propertyList = sel_registerName("propertyList");
public static final int sel_subgroups = sel_registerName("subgroups");
public static final int sel_setFloatValue_1knobProportion_1 = sel_registerName("setFloatValue:knobProportion:");
public static final int sel_componentsJoinedByString_1 = sel_registerName("componentsJoinedByString:");
public static final int sel_initWithICCProfileData_1 = sel_registerName("initWithICCProfileData:");
public static final int sel_setNextKeyView_1 = sel_registerName("setNextKeyView:");
public static final int sel_setAnimationCurve_1 = sel_registerName("setAnimationCurve:");
public static final int sel_tokenFieldCell_1completionsForSubstring_1indexOfToken_1indexOfSelectedItem_1 = sel_registerName("tokenFieldCell:completionsForSubstring:indexOfToken:indexOfSelectedItem:");
public static final int sel_takeValuesFromDictionary_1 = sel_registerName("takeValuesFromDictionary:");
public static final int sel_imageRepClassForPasteboardType_1 = sel_registerName("imageRepClassForPasteboardType:");
public static final int sel_setPlaybackDeviceIdentifier_1 = sel_registerName("setPlaybackDeviceIdentifier:");
public static final int sel_globallyUniqueString = sel_registerName("globallyUniqueString");
public static final int sel_setLineWidth_1 = sel_registerName("setLineWidth:");
public static final int sel_selectedColumnIndexes = sel_registerName("selectedColumnIndexes");
public static final int sel_addWindowsItem_1title_1filename_1 = sel_registerName("addWindowsItem:title:filename:");
public static final int sel_truncateFileAtOffset_1 = sel_registerName("truncateFileAtOffset:");
public static final int sel_setStandardOutput_1 = sel_registerName("setStandardOutput:");
public static final int sel_encodeInt32_1forKey_1 = sel_registerName("encodeInt32:forKey:");
public static final int sel_baselineDeltaForCharacterAtIndex_1 = sel_registerName("baselineDeltaForCharacterAtIndex:");
public static final int sel_setValueWraps_1 = sel_registerName("setValueWraps:");
public static final int sel_addOperation_1 = sel_registerName("addOperation:");
public static final int sel_resignKeyWindow = sel_registerName("resignKeyWindow");
public static final int sel_insertNewline_1 = sel_registerName("insertNewline:");
public static final int sel_saveFrameUsingName_1 = sel_registerName("saveFrameUsingName:");
public static final int sel_setWithObjects_1 = sel_registerName("setWithObjects:");
public static final int sel_indexOfItemWithTarget_1andAction_1 = sel_registerName("indexOfItemWithTarget:andAction:");
public static final int sel_processEditing = sel_registerName("processEditing");
public static final int sel_removeValueAtIndex_1fromPropertyWithKey_1 = sel_registerName("removeValueAtIndex:fromPropertyWithKey:");
public static final int sel_setShouldCascadeWindows_1 = sel_registerName("setShouldCascadeWindows:");
public static final int sel_stepBack_1 = sel_registerName("stepBack:");
public static final int sel_lockWhenCondition_1beforeDate_1 = sel_registerName("lockWhenCondition:beforeDate:");
public static final int sel_realm = sel_registerName("realm");
public static final int sel_appendBezierPathWithPackedGlyphs_1 = sel_registerName("appendBezierPathWithPackedGlyphs:");
public static final int sel_inputStreamWithData_1 = sel_registerName("inputStreamWithData:");
public static final int sel_clickedRow = sel_registerName("clickedRow");
public static final int sel_animationShouldStart_1 = sel_registerName("animationShouldStart:");
public static final int sel_appleEventCodeForKey_1 = sel_registerName("appleEventCodeForKey:");
public static final int sel_sendAction_1to_1forAllCells_1 = sel_registerName("sendAction:to:forAllCells:");
public static final int sel_writableTypesForSaveOperation_1 = sel_registerName("writableTypesForSaveOperation:");
public static final int sel_drawWellInside_1 = sel_registerName("drawWellInside:");
public static final int sel_intersectsSet_1 = sel_registerName("intersectsSet:");
public static final int sel_runOperationModalForWindow_1delegate_1didRunSelector_1contextInfo_1 = sel_registerName("runOperationModalForWindow:delegate:didRunSelector:contextInfo:");
public static final int sel_setAllowsEmptySelection_1 = sel_registerName("setAllowsEmptySelection:");
public static final int sel_tighteningFactorForTruncation = sel_registerName("tighteningFactorForTruncation");
public static final int sel_insertDescriptor_1atIndex_1 = sel_registerName("insertDescriptor:atIndex:");
public static final int sel_setDefaultBehavior_1 = sel_registerName("setDefaultBehavior:");
public static final int sel_allowsFloats = sel_registerName("allowsFloats");
public static final int sel_representedObject = sel_registerName("representedObject");
public static final int sel_isFlipped = sel_registerName("isFlipped");
public static final int sel_rectOfColumn_1 = sel_registerName("rectOfColumn:");
public static final int sel_setFrame_1display_1 = sel_registerName("setFrame:display:");
public static final int sel_setTextAttributesForPositiveInfinity_1 = sel_registerName("setTextAttributesForPositiveInfinity:");
public static final int sel_textUnfilteredFileTypes = sel_registerName("textUnfilteredFileTypes");
public static final int sel_bezierPathByFlatteningPath = sel_registerName("bezierPathByFlatteningPath");
public static final int sel_week = sel_registerName("week");
public static final int sel_takeIntValueFrom_1 = sel_registerName("takeIntValueFrom:");
public static final int sel_setWantsNotificationForMarkedText_1 = sel_registerName("setWantsNotificationForMarkedText:");
public static final int sel_stringByPaddingToLength_1withString_1startingAtIndex_1 = sel_registerName("stringByPaddingToLength:withString:startingAtIndex:");
public static final int sel_stopModal = sel_registerName("stopModal");
public static final int sel_veryShortWeekdaySymbols = sel_registerName("veryShortWeekdaySymbols");
public static final int sel_user = sel_registerName("user");
public static final int sel_animation_1didReachProgressMark_1 = sel_registerName("animation:didReachProgressMark:");
public static final int sel_fontWithName_1size_1 = sel_registerName("fontWithName:size:");
public static final int sel_selectWord_1 = sel_registerName("selectWord:");
public static final int sel_initWithDuration_1animationCurve_1 = sel_registerName("initWithDuration:animationCurve:");
public static final int sel_afmDictionary = sel_registerName("afmDictionary");
public static final int sel_canChooseFiles = sel_registerName("canChooseFiles");
public static final int sel_defaultLineWidth = sel_registerName("defaultLineWidth");
public static final int sel_childAtIndex_1 = sel_registerName("childAtIndex:");
public static final int sel_pathForResource_1ofType_1inDirectory_1 = sel_registerName("pathForResource:ofType:inDirectory:");
public static final int sel_outlineView_1heightOfRowByItem_1 = sel_registerName("outlineView:heightOfRowByItem:");
public static final int sel_PMSymbol = sel_registerName("PMSymbol");
public static final int sel_setBackgroundStyle_1 = sel_registerName("setBackgroundStyle:");
public static final int sel_decimalSeparator = sel_registerName("decimalSeparator");
public static final int sel_knobThickness = sel_registerName("knobThickness");
public static final int sel_request = sel_registerName("request");
public static final int sel_indicesOfObjectsByEvaluatingWithContainer_1count_1 = sel_registerName("indicesOfObjectsByEvaluatingWithContainer:count:");
public static final int sel_objectByApplyingXSLTString_1arguments_1error_1 = sel_registerName("objectByApplyingXSLTString:arguments:error:");
public static final int sel_colorizeByMappingGray_1toColor_1blackMapping_1whiteMapping_1 = sel_registerName("colorizeByMappingGray:toColor:blackMapping:whiteMapping:");
public static final int sel_minusSet_1 = sel_registerName("minusSet:");
public static final int sel_setAutomaticallyRearrangesObjects_1 = sel_registerName("setAutomaticallyRearrangesObjects:");
public static final int sel_fixFontAttributeInRange_1 = sel_registerName("fixFontAttributeInRange:");
public static final int sel_frameRotation = sel_registerName("frameRotation");
public static final int sel_addObserver_1forKeyPath_1options_1context_1 = sel_registerName("addObserver:forKeyPath:options:context:");
public static final int sel_collectionNames = sel_registerName("collectionNames");
public static final int sel_titleOfColumn_1 = sel_registerName("titleOfColumn:");
public static final int sel_characterIdentifier = sel_registerName("characterIdentifier");
public static final int sel_setPanelFont_1isMultiple_1 = sel_registerName("setPanelFont:isMultiple:");
public static final int sel_ruleThickness = sel_registerName("ruleThickness");
public static final int sel_customSelector = sel_registerName("customSelector");
public static final int sel_startSpeakingString_1toURL_1 = sel_registerName("startSpeakingString:toURL:");
public static final int sel_language = sel_registerName("language");
public static final int sel_draggedImage_1endedAt_1operation_1 = sel_registerName("draggedImage:endedAt:operation:");
public static final int sel_removeSelectionIndexPaths_1 = sel_registerName("removeSelectionIndexPaths:");
public static final int sel_TIFFRepresentationOfImageRepsInArray_1 = sel_registerName("TIFFRepresentationOfImageRepsInArray:");
public static final int sel_setSet_1 = sel_registerName("setSet:");
public static final int sel_stringWithCString_1length_1 = sel_registerName("stringWithCString:length:");
public static final int sel_objectsByEvaluatingSpecifier = sel_registerName("objectsByEvaluatingSpecifier");
public static final int sel_subarrayWithRange_1 = sel_registerName("subarrayWithRange:");
public static final int sel_collectIfNeeded = sel_registerName("collectIfNeeded");
public static final int sel_pathWithComponents_1 = sel_registerName("pathWithComponents:");
public static final int sel_autoreleasedObjectCount = sel_registerName("autoreleasedObjectCount");
public static final int sel_addCharactersInString_1 = sel_registerName("addCharactersInString:");
public static final int sel_setTemplate_1 = sel_registerName("setTemplate:");
public static final int sel_indexOfObjectIdenticalTo_1 = sel_registerName("indexOfObjectIdenticalTo:");
public static final int sel_setRepresentation = sel_registerName("setRepresentation");
public static final int sel_URLResourceDidFinishLoading_1 = sel_registerName("URLResourceDidFinishLoading:");
public static final int sel_type = sel_registerName("type");
public static final int sel_setMarkedText_1selectedRange_1 = sel_registerName("setMarkedText:selectedRange:");
public static final int sel_dictionaryWithObjects_1forKeys_1 = sel_registerName("dictionaryWithObjects:forKeys:");
public static final int sel_wantsToDelayTextChangeNotifications = sel_registerName("wantsToDelayTextChangeNotifications");
public static final int sel_setCompletes_1 = sel_registerName("setCompletes:");
public static final int sel_releaseGState = sel_registerName("releaseGState");
public static final int sel_descriptorWithEnumCode_1 = sel_registerName("descriptorWithEnumCode:");
public static final int sel_label = sel_registerName("label");
public static final int sel_run = sel_registerName("run");
public static final int sel_hasHorizontalRuler = sel_registerName("hasHorizontalRuler");
public static final int sel_rowClass = sel_registerName("rowClass");
public static final int sel_automaticRearrangementKeyPaths = sel_registerName("automaticRearrangementKeyPaths");
public static final int sel_fileManager_1shouldProceedAfterError_1movingItemAtPath_1toPath_1 = sel_registerName("fileManager:shouldProceedAfterError:movingItemAtPath:toPath:");
public static final int sel_writeToURL_1atomically_1encoding_1error_1 = sel_registerName("writeToURL:atomically:encoding:error:");
public static final int sel_deviceID = sel_registerName("deviceID");
public static final int sel_descriptorWithInt32_1 = sel_registerName("descriptorWithInt32:");
public static final int sel_encodeInt64_1forKey_1 = sel_registerName("encodeInt64:forKey:");
public static final int sel_insertEntry_1atIndex_1 = sel_registerName("insertEntry:atIndex:");
public static final int sel_leftMargin = sel_registerName("leftMargin");
public static final int sel_setKeyEquivalentFont_1size_1 = sel_registerName("setKeyEquivalentFont:size:");
public static final int sel_colorWithDeviceHue_1saturation_1brightness_1alpha_1 = sel_registerName("colorWithDeviceHue:saturation:brightness:alpha:");
public static final int sel_nextState = sel_registerName("nextState");
public static final int sel_scanHexInt_1 = sel_registerName("scanHexInt:");
public static final int sel_lineSpacing = sel_registerName("lineSpacing");
public static final int sel_textureTarget = sel_registerName("textureTarget");
public static final int sel_miniaturize_1 = sel_registerName("miniaturize:");
public static final int sel_browser_1namesOfPromisedFilesDroppedAtDestination_1forDraggedRowsWithIndexes_1inColumn_1 = sel_registerName("browser:namesOfPromisedFilesDroppedAtDestination:forDraggedRowsWithIndexes:inColumn:");
public static final int sel_localizedNameForTIFFCompressionType_1 = sel_registerName("localizedNameForTIFFCompressionType:");
public static final int sel_acceptConnectionInBackgroundAndNotifyForModes_1 = sel_registerName("acceptConnectionInBackgroundAndNotifyForModes:");
public static final int sel_setCanBecomeVisibleWithoutLogin_1 = sel_registerName("setCanBecomeVisibleWithoutLogin:");
public static final int sel_dictionaryWithObjectsAndKeys_1 = sel_registerName("dictionaryWithObjectsAndKeys:");
public static final int sel_ensureGlyphsForGlyphRange_1 = sel_registerName("ensureGlyphsForGlyphRange:");
public static final int sel_indexOfTickMarkAtPoint_1 = sel_registerName("indexOfTickMarkAtPoint:");
public static final int sel_dayOfWeek = sel_registerName("dayOfWeek");
public static final int sel_glyphRangeForCharacterRange_1actualCharacterRange_1 = sel_registerName("glyphRangeForCharacterRange:actualCharacterRange:");
public static final int sel_enableCollectorForPointer_1 = sel_registerName("enableCollectorForPointer:");
public static final int sel_rulerView_1willMoveMarker_1toLocation_1 = sel_registerName("rulerView:willMoveMarker:toLocation:");
public static final int sel_comboBoxCell_1objectValueForItemAtIndex_1 = sel_registerName("comboBoxCell:objectValueForItemAtIndex:");
public static final int sel_setValidateSize_1 = sel_registerName("setValidateSize:");
public static final int sel_controlTint = sel_registerName("controlTint");
public static final int sel_deselectItemAtIndex_1 = sel_registerName("deselectItemAtIndex:");
public static final int sel_defaultWindingRule = sel_registerName("defaultWindingRule");
public static final int sel_setMaxValue_1 = sel_registerName("setMaxValue:");
public static final int sel_longEraSymbols = sel_registerName("longEraSymbols");
public static final int sel_canRedo = sel_registerName("canRedo");
public static final int sel_arguments = sel_registerName("arguments");
public static final int sel_windows = sel_registerName("windows");
public static final int sel_downloadDidBegin_1 = sel_registerName("downloadDidBegin:");
public static final int sel_pasteboard_1provideDataForType_1 = sel_registerName("pasteboard:provideDataForType:");
public static final int sel_length = sel_registerName("length");
public static final int sel_imagePosition = sel_registerName("imagePosition");
public static final int sel_setAllowedFileTypes_1 = sel_registerName("setAllowedFileTypes:");
public static final int sel_moveForwardAndModifySelection_1 = sel_registerName("moveForwardAndModifySelection:");
public static final int sel_filename = sel_registerName("filename");
public static final int sel_mountedLocalVolumePaths = sel_registerName("mountedLocalVolumePaths");
public static final int sel_sharedFontManager = sel_registerName("sharedFontManager");
public static final int sel_dictionaryWithObjects_1forKeys_1count_1 = sel_registerName("dictionaryWithObjects:forKeys:count:");
public static final int sel_transpose_1 = sel_registerName("transpose:");
public static final int sel_drawTitleWithFrame_1inView_1 = sel_registerName("drawTitleWithFrame:inView:");
public static final int sel_worksWhenModal = sel_registerName("worksWhenModal");
public static final int sel_registerClassDescription_1 = sel_registerName("registerClassDescription:");
public static final int sel_setAllowsTruncatedLabels_1 = sel_registerName("setAllowsTruncatedLabels:");
public static final int sel_bezierPathWithRoundedRect_1xRadius_1yRadius_1 = sel_registerName("bezierPathWithRoundedRect:xRadius:yRadius:");
public static final int sel_prefix = sel_registerName("prefix");
public static final int sel_usesStrongWriteBarrier = sel_registerName("usesStrongWriteBarrier");
public static final int sel_argumentNames = sel_registerName("argumentNames");
public static final int sel_setCaseSensitive_1 = sel_registerName("setCaseSensitive:");
public static final int sel_outlineView_1didClickTableColumn_1 = sel_registerName("outlineView:didClickTableColumn:");
public static final int sel_textDidBeginEditing_1 = sel_registerName("textDidBeginEditing:");
public static final int sel_visibleRect = sel_registerName("visibleRect");
public static final int sel_isSubviewCollapsed_1 = sel_registerName("isSubviewCollapsed:");
public static final int sel_completionsForPartialWordRange_1indexOfSelectedItem_1 = sel_registerName("completionsForPartialWordRange:indexOfSelectedItem:");
public static final int sel_setMinDate_1 = sel_registerName("setMinDate:");
public static final int sel_colorFromPasteboard_1 = sel_registerName("colorFromPasteboard:");
public static final int sel_instanceMethodSignatureForSelector_1 = sel_registerName("instanceMethodSignatureForSelector:");
public static final int sel_makeCellAtRow_1column_1 = sel_registerName("makeCellAtRow:column:");
public static final int sel_pasteAsPlainText_1 = sel_registerName("pasteAsPlainText:");
public static final int sel_willRemoveSubview_1 = sel_registerName("willRemoveSubview:");
public static final int sel_beginSheet_1modalForWindow_1modalDelegate_1didEndSelector_1contextInfo_1 = sel_registerName("beginSheet:modalForWindow:modalDelegate:didEndSelector:contextInfo:");
public static final int sel_notificationCenterForType_1 = sel_registerName("notificationCenterForType:");
public static final int sel_isDaylightSavingTimeForDate_1 = sel_registerName("isDaylightSavingTimeForDate:");
public static final int sel_load = sel_registerName("load");
public static final int sel_menuForSegment_1 = sel_registerName("menuForSegment:");
public static final int sel_scheduledTimerWithTimeInterval_1invocation_1repeats_1 = sel_registerName("scheduledTimerWithTimeInterval:invocation:repeats:");
public static final int sel_unregisterClass_1 = sel_registerName("unregisterClass:");
public static final int sel_setByAddingObjectsFromSet_1 = sel_registerName("setByAddingObjectsFromSet:");
public static final int sel_setDepthLimit_1 = sel_registerName("setDepthLimit:");
public static final int sel_setVeryShortMonthSymbols_1 = sel_registerName("setVeryShortMonthSymbols:");
public static final int sel_writeToURL_1ofType_1forSaveOperation_1originalContentsURL_1error_1 = sel_registerName("writeToURL:ofType:forSaveOperation:originalContentsURL:error:");
public static final int sel_directoryAttributes = sel_registerName("directoryAttributes");
public static final int sel_otherMouseDown_1 = sel_registerName("otherMouseDown:");
public static final int sel_unhideWithoutActivation = sel_registerName("unhideWithoutActivation");
public static final int sel_initWithContainerClassDescription_1containerSpecifier_1key_1startSpecifier_1endSpecifier_1 = sel_registerName("initWithContainerClassDescription:containerSpecifier:key:startSpecifier:endSpecifier:");
public static final int sel_setHasHorizontalScroller_1 = sel_registerName("setHasHorizontalScroller:");
public static final int sel_trackMouse_1adding_1 = sel_registerName("trackMouse:adding:");
public static final int sel_substituteGlyphsInRange_1withGlyphs_1 = sel_registerName("substituteGlyphsInRange:withGlyphs:");
public static final int sel_drawCell_1 = sel_registerName("drawCell:");
public static final int sel_currentCursor = sel_registerName("currentCursor");
public static final int sel_maxSize = sel_registerName("maxSize");
public static final int sel_cookiesWithResponseHeaderFields_1forURL_1 = sel_registerName("cookiesWithResponseHeaderFields:forURL:");
public static final int sel_isBycopy = sel_registerName("isBycopy");
public static final int sel_addCursorRect_1cursor_1 = sel_registerName("addCursorRect:cursor:");
public static final int sel_accessibilityActionNames = sel_registerName("accessibilityActionNames");
public static final int sel_openDocumentWithContentsOfURL_1display_1error_1 = sel_registerName("openDocumentWithContentsOfURL:display:error:");
public static final int sel_templateViews = sel_registerName("templateViews");
public static final int sel_keyPath = sel_registerName("keyPath");
public static final int sel_minValue = sel_registerName("minValue");
public static final int sel_setImageDimsWhenDisabled_1 = sel_registerName("setImageDimsWhenDisabled:");
public static final int sel_appendData_1 = sel_registerName("appendData:");
public static final int sel_netServiceBrowser_1didFindDomain_1moreComing_1 = sel_registerName("netServiceBrowser:didFindDomain:moreComing:");
public static final int sel_initWithDescriptorType_1bytes_1length_1 = sel_registerName("initWithDescriptorType:bytes:length:");
public static final int sel_hasReadablePropertyForKey_1 = sel_registerName("hasReadablePropertyForKey:");
public static final int sel_stopWhenAnimation_1reachesProgress_1 = sel_registerName("stopWhenAnimation:reachesProgress:");
public static final int sel_setWorksWhenModal_1 = sel_registerName("setWorksWhenModal:");
public static final int sel_localizedInputManagerName = sel_registerName("localizedInputManagerName");
public static final int sel_knobColor = sel_registerName("knobColor");
public static final int sel_screens = sel_registerName("screens");
public static final int sel_deminiaturize_1 = sel_registerName("deminiaturize:");
public static final int sel_bundleIdentifier = sel_registerName("bundleIdentifier");
public static final int sel_setLoopMode_1 = sel_registerName("setLoopMode:");
public static final int sel_expandItem_1expandChildren_1 = sel_registerName("expandItem:expandChildren:");
public static final int sel_dataWithContentsOfFile_1options_1error_1 = sel_registerName("dataWithContentsOfFile:options:error:");
public static final int sel_lineBreakBeforeIndex_1withinRange_1 = sel_registerName("lineBreakBeforeIndex:withinRange:");
public static final int sel_fileOwnerAccountName = sel_registerName("fileOwnerAccountName");
public static final int sel_insertColumn_1withCells_1 = sel_registerName("insertColumn:withCells:");
public static final int sel_windowLevel = sel_registerName("windowLevel");
public static final int sel_setGrammarCheckingEnabled_1 = sel_registerName("setGrammarCheckingEnabled:");
public static final int sel_shortStandaloneWeekdaySymbols = sel_registerName("shortStandaloneWeekdaySymbols");
public static final int sel_push = sel_registerName("push");
public static final int sel_initWithContentsOfFile_1ofType_1 = sel_registerName("initWithContentsOfFile:ofType:");
public static final int sel_removePortForName_1 = sel_registerName("removePortForName:");
public static final int sel_setMaximumRecents_1 = sel_registerName("setMaximumRecents:");
public static final int sel_supermenu = sel_registerName("supermenu");
public static final int sel_setWidth_1type_1forLayer_1edge_1 = sel_registerName("setWidth:type:forLayer:edge:");
public static final int sel_itemRemoved_1 = sel_registerName("itemRemoved:");
public static final int sel_initWithBytesNoCopy_1length_1 = sel_registerName("initWithBytesNoCopy:length:");
public static final int sel_printer = sel_registerName("printer");
public static final int sel_compact = sel_registerName("compact");
public static final int sel_setDefaultLineWidth_1 = sel_registerName("setDefaultLineWidth:");
public static final int sel_CGLPixelFormatObj = sel_registerName("CGLPixelFormatObj");
public static final int sel_initWithDictionary_1copyItems_1 = sel_registerName("initWithDictionary:copyItems:");
public static final int sel_tableView_1didDragTableColumn_1 = sel_registerName("tableView:didDragTableColumn:");
public static final int sel_formattingStringsFilename = sel_registerName("formattingStringsFilename");
public static final int sel_setScrollView_1 = sel_registerName("setScrollView:");
public static final int sel_value = sel_registerName("value");
public static final int sel_editedMask = sel_registerName("editedMask");
public static final int sel_ruleEditor_1displayValueForCriterion_1inRow_1 = sel_registerName("ruleEditor:displayValueForCriterion:inRow:");
public static final int sel_leading = sel_registerName("leading");
public static final int sel_titleRect = sel_registerName("titleRect");
public static final int sel_setColumnsAutosaveName_1 = sel_registerName("setColumnsAutosaveName:");
public static final int sel_stop_1 = sel_registerName("stop:");
public static final int sel_titleColor = sel_registerName("titleColor");
public static final int sel_initWithContainerClassDescription_1containerSpecifier_1key_1test_1 = sel_registerName("initWithContainerClassDescription:containerSpecifier:key:test:");
public static final int sel_bytesPerPlane = sel_registerName("bytesPerPlane");
public static final int sel_pageScroll = sel_registerName("pageScroll");
public static final int sel_groupingAttributes = sel_registerName("groupingAttributes");
public static final int sel_setAutomaticLinkDetectionEnabled_1 = sel_registerName("setAutomaticLinkDetectionEnabled:");
public static final int sel_tableView_1mouseDownInHeaderOfTableColumn_1 = sel_registerName("tableView:mouseDownInHeaderOfTableColumn:");
public static final int sel_representationOfImageRepsInArray_1usingType_1properties_1 = sel_registerName("representationOfImageRepsInArray:usingType:properties:");
public static final int sel_attributeRuns = sel_registerName("attributeRuns");
public static final int sel_decodeRect = sel_registerName("decodeRect");
public static final int sel_drawerDidOpen_1 = sel_registerName("drawerDidOpen:");
public static final int sel_scrollerWidth = sel_registerName("scrollerWidth");
public static final int sel_defaultMenu = sel_registerName("defaultMenu");
public static final int sel_URLProtocol_1didLoadData_1 = sel_registerName("URLProtocol:didLoadData:");
public static final int sel_allKeys = sel_registerName("allKeys");
public static final int sel_startPeriodicEventsAfterDelay_1withPeriod_1 = sel_registerName("startPeriodicEventsAfterDelay:withPeriod:");
public static final int sel_tableViewSelectionDidChange_1 = sel_registerName("tableViewSelectionDidChange:");
public static final int sel_setStandalone_1 = sel_registerName("setStandalone:");
public static final int sel_makeMainWindow = sel_registerName("makeMainWindow");
public static final int sel_moveLeftAndModifySelection_1 = sel_registerName("moveLeftAndModifySelection:");
public static final int sel_pasteboardWithUniqueName = sel_registerName("pasteboardWithUniqueName");
public static final int sel_fileSystemFileNumber = sel_registerName("fileSystemFileNumber");
public static final int sel_jobDisposition = sel_registerName("jobDisposition");
public static final int sel_setCurrentVirtualScreen_1 = sel_registerName("setCurrentVirtualScreen:");
public static final int sel_setHasThousandSeparators_1 = sel_registerName("setHasThousandSeparators:");
public static final int sel_alternateMnemonicLocation = sel_registerName("alternateMnemonicLocation");
public static final int sel_characterSetWithBitmapRepresentation_1 = sel_registerName("characterSetWithBitmapRepresentation:");
public static final int sel_startLoading = sel_registerName("startLoading");
public static final int sel_member_1 = sel_registerName("member:");
public static final int sel_setSelectedFont_1isMultiple_1 = sel_registerName("setSelectedFont:isMultiple:");
public static final int sel_monthOfYear = sel_registerName("monthOfYear");
public static final int sel_restoreCachedImage = sel_registerName("restoreCachedImage");
public static final int sel_image_1didLoadPartOfRepresentation_1withValidRows_1 = sel_registerName("image:didLoadPartOfRepresentation:withValidRows:");
public static final int sel_mouseEventWithType_1location_1modifierFlags_1timestamp_1windowNumber_1context_1eventNumber_1clickCount_1pressure_1 = sel_registerName("mouseEventWithType:location:modifierFlags:timestamp:windowNumber:context:eventNumber:clickCount:pressure:");
public static final int sel_setInternationalCurrencySymbol_1 = sel_registerName("setInternationalCurrencySymbol:");
public static final int sel_mainThread = sel_registerName("mainThread");
public static final int sel_lineCapStyle = sel_registerName("lineCapStyle");
public static final int sel_setDefaultParagraphStyle_1 = sel_registerName("setDefaultParagraphStyle:");
public static final int sel_cellFrameForTextContainer_1proposedLineFragment_1glyphPosition_1characterIndex_1 = sel_registerName("cellFrameForTextContainer:proposedLineFragment:glyphPosition:characterIndex:");
public static final int sel_resolveInstanceMethod_1 = sel_registerName("resolveInstanceMethod:");
public static final int sel_illegalCharacterSet = sel_registerName("illegalCharacterSet");
public static final int sel_setKnobThickness_1 = sel_registerName("setKnobThickness:");
public static final int sel_runModalPageLayoutWithPrintInfo_1 = sel_registerName("runModalPageLayoutWithPrintInfo:");
public static final int sel_popUpContextMenu_1withEvent_1forView_1withFont_1 = sel_registerName("popUpContextMenu:withEvent:forView:withFont:");
public static final int sel_modalWindow = sel_registerName("modalWindow");
public static final int sel_autorelease = sel_registerName("autorelease");
public static final int sel_draggingEntered_1 = sel_registerName("draggingEntered:");
public static final int sel_allowsTruncatedLabels = sel_registerName("allowsTruncatedLabels");
public static final int sel_fileDescriptor = sel_registerName("fileDescriptor");
public static final int sel_ISOLanguageCodes = sel_registerName("ISOLanguageCodes");
public static final int sel_onStateImage = sel_registerName("onStateImage");
public static final int sel_imageFrameStyle = sel_registerName("imageFrameStyle");
public static final int sel_setFloatValue_1 = sel_registerName("setFloatValue:");
public static final int sel_initWithColors_1atLocations_1colorSpace_1 = sel_registerName("initWithColors:atLocations:colorSpace:");
public static final int sel_descriptorWithString_1 = sel_registerName("descriptorWithString:");
public static final int sel_setPoolCountHighWaterMark_1 = sel_registerName("setPoolCountHighWaterMark:");
public static final int sel_veryShortStandaloneWeekdaySymbols = sel_registerName("veryShortStandaloneWeekdaySymbols");
public static final int sel_addTypes_1owner_1 = sel_registerName("addTypes:owner:");
public static final int sel_numberWithLongLong_1 = sel_registerName("numberWithLongLong:");
public static final int sel_setDay_1 = sel_registerName("setDay:");
public static final int sel_initWithHTML_1documentAttributes_1 = sel_registerName("initWithHTML:documentAttributes:");
public static final int sel_replaceSubview_1with_1 = sel_registerName("replaceSubview:with:");
public static final int sel_makeObjectsPerformSelector_1 = sel_registerName("makeObjectsPerformSelector:");
public static final int sel_setRunLoopModes_1 = sel_registerName("setRunLoopModes:");
public static final int sel_getFileSystemRepresentation_1maxLength_1 = sel_registerName("getFileSystemRepresentation:maxLength:");
public static final int sel_scale = sel_registerName("scale");
public static final int sel_draggedImageLocation = sel_registerName("draggedImageLocation");
public static final int sel_setFocusStack_1 = sel_registerName("setFocusStack:");
public static final int sel_isReadOnlyKey_1 = sel_registerName("isReadOnlyKey:");
public static final int sel_shadowOffset = sel_registerName("shadowOffset");
public static final int sel_URLHandleUsingCache_1 = sel_registerName("URLHandleUsingCache:");
public static final int sel_isWellFormed = sel_registerName("isWellFormed");
public static final int sel_tokenField_1editingStringForRepresentedObject_1 = sel_registerName("tokenField:editingStringForRepresentedObject:");
public static final int sel_setGroupsByEvent_1 = sel_registerName("setGroupsByEvent:");
public static final int sel_parser_1foundComment_1 = sel_registerName("parser:foundComment:");
public static final int sel_initWithHTML_1baseURL_1documentAttributes_1 = sel_registerName("initWithHTML:baseURL:documentAttributes:");
public static final int sel_uppercaseWord_1 = sel_registerName("uppercaseWord:");
public static final int sel_testPart_1 = sel_registerName("testPart:");
public static final int sel_dataSource = sel_registerName("dataSource");
public static final int sel_lineRangeForRange_1 = sel_registerName("lineRangeForRange:");
public static final int sel_hostWithAddress_1 = sel_registerName("hostWithAddress:");
public static final int sel_removeRunLoop_1 = sel_registerName("removeRunLoop:");
public static final int sel_fileHandleWithStandardInput = sel_registerName("fileHandleWithStandardInput");
public static final int sel_itemArray = sel_registerName("itemArray");
public static final int sel_rectOfPathComponentCell_1withFrame_1inView_1 = sel_registerName("rectOfPathComponentCell:withFrame:inView:");
public static final int sel_TIFFRepresentation = sel_registerName("TIFFRepresentation");
public static final int sel_archiver_1willReplaceObject_1withObject_1 = sel_registerName("archiver:willReplaceObject:withObject:");
public static final int sel_currentVirtualScreen = sel_registerName("currentVirtualScreen");
public static final int sel_gridColor = sel_registerName("gridColor");
public static final int sel_boundingRectForGlyph_1 = sel_registerName("boundingRectForGlyph:");
public static final int sel_setDataSource_1 = sel_registerName("setDataSource:");
public static final int sel_setDefaultLineJoinStyle_1 = sel_registerName("setDefaultLineJoinStyle:");
public static final int sel_textBlocks = sel_registerName("textBlocks");
public static final int sel_drawerDidClose_1 = sel_registerName("drawerDidClose:");
public static final int sel_valueWithName_1inPropertyWithKey_1 = sel_registerName("valueWithName:inPropertyWithKey:");
public static final int sel_managedObjectModel = sel_registerName("managedObjectModel");
public static final int sel_outlineView_1persistentObjectForItem_1 = sel_registerName("outlineView:persistentObjectForItem:");
public static final int sel_setSelectedRange_1 = sel_registerName("setSelectedRange:");
public static final int sel_magentaComponent = sel_registerName("magentaComponent");
public static final int sel_setIncrement_1 = sel_registerName("setIncrement:");
public static final int sel_editingStringForObjectValue_1 = sel_registerName("editingStringForObjectValue:");
public static final int sel_addClip = sel_registerName("addClip");
public static final int sel_setSelectionIndex_1 = sel_registerName("setSelectionIndex:");
public static final int sel_replyAppleEventForSuspensionID_1 = sel_registerName("replyAppleEventForSuspensionID:");
public static final int sel_URLProtocol_1didFailWithError_1 = sel_registerName("URLProtocol:didFailWithError:");
public static final int sel_ignoresMouseEvents = sel_registerName("ignoresMouseEvents");
public static final int sel_dateWithNaturalLanguageString_1locale_1 = sel_registerName("dateWithNaturalLanguageString:locale:");
public static final int sel_recordDescriptor = sel_registerName("recordDescriptor");
public static final int sel_makeCurrentContext = sel_registerName("makeCurrentContext");
public static final int sel_excludedKeys = sel_registerName("excludedKeys");
public static final int sel_fileManager_1shouldProceedAfterError_1linkingItemAtPath_1toPath_1 = sel_registerName("fileManager:shouldProceedAfterError:linkingItemAtPath:toPath:");
public static final int sel_set = sel_registerName("set");
public static final int sel_mainScreen = sel_registerName("mainScreen");
public static final int sel_setVersion_1 = sel_registerName("setVersion:");
public static final int sel_displayRectIgnoringOpacity_1inContext_1 = sel_registerName("displayRectIgnoringOpacity:inContext:");
public static final int sel_setNumberOfTickMarks_1 = sel_registerName("setNumberOfTickMarks:");
public static final int sel_showsHelp = sel_registerName("showsHelp");
public static final int sel_takeColorFrom_1 = sel_registerName("takeColorFrom:");
public static final int sel_horizontalPageScroll = sel_registerName("horizontalPageScroll");
public static final int sel_pointingHandCursor = sel_registerName("pointingHandCursor");
public static final int sel_vendorID = sel_registerName("vendorID");
public static final int sel_setSelectedRanges_1affinity_1stillSelecting_1 = sel_registerName("setSelectedRanges:affinity:stillSelecting:");
public static final int sel_setHTTPShouldHandleCookies_1 = sel_registerName("setHTTPShouldHandleCookies:");
public static final int sel_initWithType_1location_1 = sel_registerName("initWithType:location:");
public static final int sel_stringByResolvingSymlinksInPath = sel_registerName("stringByResolvingSymlinksInPath");
public static final int sel_tryLock = sel_registerName("tryLock");
public static final int sel_convertSizeFromBase_1 = sel_registerName("convertSizeFromBase:");
public static final int sel_setCacheMode_1 = sel_registerName("setCacheMode:");
public static final int sel_entityName = sel_registerName("entityName");
public static final int sel_takeFloatValueFrom_1 = sel_registerName("takeFloatValueFrom:");
public static final int sel_showsStateBy = sel_registerName("showsStateBy");
public static final int sel_highlightedItem = sel_registerName("highlightedItem");
public static final int sel_superclassDescription = sel_registerName("superclassDescription");
public static final int sel_flagsChanged_1 = sel_registerName("flagsChanged:");
public static final int sel_alloc = sel_registerName("alloc");
public static final int sel_setDisplaysWhenScreenProfileChanges_1 = sel_registerName("setDisplaysWhenScreenProfileChanges:");
public static final int sel_CIImage = sel_registerName("CIImage");
public static final int sel_setSupermenu_1 = sel_registerName("setSupermenu:");
public static final int sel_setSharedURLCache_1 = sel_registerName("setSharedURLCache:");
public static final int sel_pathCell_1willPopUpMenu_1 = sel_registerName("pathCell:willPopUpMenu:");
public static final int sel_setAttributes_1ofItemAtPath_1error_1 = sel_registerName("setAttributes:ofItemAtPath:error:");
public static final int sel_tableView_1typeSelectStringForTableColumn_1row_1 = sel_registerName("tableView:typeSelectStringForTableColumn:row:");
public static final int sel_moveWordLeftAndModifySelection_1 = sel_registerName("moveWordLeftAndModifySelection:");
public static final int sel_whitespaceAndNewlineCharacterSet = sel_registerName("whitespaceAndNewlineCharacterSet");
public static final int sel_pathControl_1validateDrop_1 = sel_registerName("pathControl:validateDrop:");
public static final int sel_createCommandInstanceWithZone_1 = sel_registerName("createCommandInstanceWithZone:");
public static final int sel_configurationDictionary = sel_registerName("configurationDictionary");
public static final int sel_classFallbacksForKeyedArchiver = sel_registerName("classFallbacksForKeyedArchiver");
public static final int sel_DTDKind = sel_registerName("DTDKind");
public static final int sel_initWithPath_1documentAttributes_1 = sel_registerName("initWithPath:documentAttributes:");
public static final int sel_addObjectsFromArray_1 = sel_registerName("addObjectsFromArray:");
public static final int sel_tokenField_1displayStringForRepresentedObject_1 = sel_registerName("tokenField:displayStringForRepresentedObject:");
public static final int sel_firstVisibleColumn = sel_registerName("firstVisibleColumn");
public static final int sel_gradientType = sel_registerName("gradientType");
public static final int sel_familyName = sel_registerName("familyName");
public static final int sel_uniqueID = sel_registerName("uniqueID");
public static final int sel_setFormatterBehavior_1 = sel_registerName("setFormatterBehavior:");
public static final int sel_tokenFieldCell_1hasMenuForRepresentedObject_1 = sel_registerName("tokenFieldCell:hasMenuForRepresentedObject:");
public static final int sel_fileManager_1shouldCopyItemAtPath_1toPath_1 = sel_registerName("fileManager:shouldCopyItemAtPath:toPath:");
public static final int sel_keySpecifier = sel_registerName("keySpecifier");
public static final int sel_copyItemAtPath_1toPath_1error_1 = sel_registerName("copyItemAtPath:toPath:error:");
public static final int sel_setLength_1 = sel_registerName("setLength:");
public static final int sel_reloadItem_1 = sel_registerName("reloadItem:");
public static final int sel_removeObjectsAtArrangedObjectIndexes_1 = sel_registerName("removeObjectsAtArrangedObjectIndexes:");
public static final int sel_setVisibilityPriority_1 = sel_registerName("setVisibilityPriority:");
public static final int sel_insertItemWithObjectValue_1atIndex_1 = sel_registerName("insertItemWithObjectValue:atIndex:");
public static final int sel_searchButtonCell = sel_registerName("searchButtonCell");
public static final int sel_getCString_1maxLength_1range_1remainingRange_1 = sel_registerName("getCString:maxLength:range:remainingRange:");
public static final int sel_outlineView_1child_1ofItem_1 = sel_registerName("outlineView:child:ofItem:");
public static final int sel_numberOfComponents = sel_registerName("numberOfComponents");
public static final int sel_isKindOfClass_1 = sel_registerName("isKindOfClass:");
public static final int sel_processorCount = sel_registerName("processorCount");
public static final int sel_lineJoinStyle = sel_registerName("lineJoinStyle");
public static final int sel_collectionBehavior = sel_registerName("collectionBehavior");
public static final int sel_setApplicationIconImage_1 = sel_registerName("setApplicationIconImage:");
public static final int sel_setLaunchPath_1 = sel_registerName("setLaunchPath:");
public static final int sel_initFileURLWithPath_1 = sel_registerName("initFileURLWithPath:");
public static final int sel_selectItemAtIndex_1 = sel_registerName("selectItemAtIndex:");
public static final int sel_IBeamCursor = sel_registerName("IBeamCursor");
public static final int sel_isColor = sel_registerName("isColor");
public static final int sel_cancelAuthenticationChallenge_1 = sel_registerName("cancelAuthenticationChallenge:");
public static final int sel_echosBullets = sel_registerName("echosBullets");
public static final int sel_setHasUndoManager_1 = sel_registerName("setHasUndoManager:");
public static final int sel_RTFDFileWrapperFromRange_1documentAttributes_1 = sel_registerName("RTFDFileWrapperFromRange:documentAttributes:");
public static final int sel_highlightCell_1atRow_1column_1 = sel_registerName("highlightCell:atRow:column:");
public static final int sel_currentHost = sel_registerName("currentHost");
public static final int sel_setURI_1 = sel_registerName("setURI:");
public static final int sel_suiteNames = sel_registerName("suiteNames");
public static final int sel_genericGrayColorSpace = sel_registerName("genericGrayColorSpace");
public static final int sel_volatileDomainForName_1 = sel_registerName("volatileDomainForName:");
public static final int sel_tokenizingCharacterSet = sel_registerName("tokenizingCharacterSet");
public static final int sel_initWithXMLString_1 = sel_registerName("initWithXMLString:");
public static final int sel_function = sel_registerName("function");
public static final int sel_sizeForMagnification_1 = sel_registerName("sizeForMagnification:");
public static final int sel_commitEditingWithDelegate_1didCommitSelector_1contextInfo_1 = sel_registerName("commitEditingWithDelegate:didCommitSelector:contextInfo:");
public static final int sel_writeToFile_1 = sel_registerName("writeToFile:");
public static final int sel_displayIfNeededInRect_1 = sel_registerName("displayIfNeededInRect:");
public static final int sel_optionDescriptionsForBinding_1 = sel_registerName("optionDescriptionsForBinding:");
public static final int sel_initWithSize_1 = sel_registerName("initWithSize:");
public static final int sel_cornerView = sel_registerName("cornerView");
public static final int sel_redoActionName = sel_registerName("redoActionName");
public static final int sel_setLocation_1forStartOfGlyphRange_1 = sel_registerName("setLocation:forStartOfGlyphRange:");
public static final int sel_setAllowedInputSourceLocales_1 = sel_registerName("setAllowedInputSourceLocales:");
public static final int sel_convertRect_1toView_1 = sel_registerName("convertRect:toView:");
public static final int sel_preferredFilenameExtensionForType_1 = sel_registerName("preferredFilenameExtensionForType:");
public static final int sel_tableView_1writeRows_1toPasteboard_1 = sel_registerName("tableView:writeRows:toPasteboard:");
public static final int sel_rootObject = sel_registerName("rootObject");
public static final int sel_isEqualToHashTable_1 = sel_registerName("isEqualToHashTable:");
public static final int sel_indent_1 = sel_registerName("indent:");
public static final int sel_removeIndexesInRange_1 = sel_registerName("removeIndexesInRange:");
public static final int sel_numberWithBool_1 = sel_registerName("numberWithBool:");
public static final int sel_setPersistentDomain_1forName_1 = sel_registerName("setPersistentDomain:forName:");
public static final int sel_netServiceBrowser_1didRemoveService_1moreComing_1 = sel_registerName("netServiceBrowser:didRemoveService:moreComing:");
public static final int sel_timeZoneWithName_1data_1 = sel_registerName("timeZoneWithName:data:");
public static final int sel_drawImage_1withFrame_1inView_1 = sel_registerName("drawImage:withFrame:inView:");
public static final int sel_buttonToolTip = sel_registerName("buttonToolTip");
public static final int sel_enableCursorRects = sel_registerName("enableCursorRects");
public static final int sel_rulerAttributesInRange_1 = sel_registerName("rulerAttributesInRange:");
public static final int sel_setMemoryCapacity_1 = sel_registerName("setMemoryCapacity:");
public static final int sel_isSeparatorItem = sel_registerName("isSeparatorItem");
public static final int sel_save_1 = sel_registerName("save:");
public static final int sel_documentView = sel_registerName("documentView");
public static final int sel_setHostCacheEnabled_1 = sel_registerName("setHostCacheEnabled:");
public static final int sel_setDatePickerElements_1 = sel_registerName("setDatePickerElements:");
public static final int sel_mixedStateImage = sel_registerName("mixedStateImage");
public static final int sel_setAcceptsMouseMovedEvents_1 = sel_registerName("setAcceptsMouseMovedEvents:");
public static final int sel_numberOfTabViewItems = sel_registerName("numberOfTabViewItems");
public static final int sel_portForName_1host_1nameServerPortNumber_1 = sel_registerName("portForName:host:nameServerPortNumber:");
public static final int sel_printerWithName_1domain_1includeUnavailable_1 = sel_registerName("printerWithName:domain:includeUnavailable:");
public static final int sel_insertObjects_1atArrangedObjectIndexPaths_1 = sel_registerName("insertObjects:atArrangedObjectIndexPaths:");
public static final int sel_browser_1shouldTypeSelectForEvent_1withCurrentSearchString_1 = sel_registerName("browser:shouldTypeSelectForEvent:withCurrentSearchString:");
public static final int sel_defaultTabInterval = sel_registerName("defaultTabInterval");
public static final int sel_initWithTitle_1 = sel_registerName("initWithTitle:");
public static final int sel_timeZoneForSecondsFromGMT_1 = sel_registerName("timeZoneForSecondsFromGMT:");
public static final int sel_initWithPasteboard_1 = sel_registerName("initWithPasteboard:");
public static final int sel_subscriptRange_1 = sel_registerName("subscriptRange:");
public static final int sel_highlightColorWithFrame_1inView_1 = sel_registerName("highlightColorWithFrame:inView:");
public static final int sel_didChangeText = sel_registerName("didChangeText");
public static final int sel_storagePolicy = sel_registerName("storagePolicy");
public static final int sel_respondsToSelector_1 = sel_registerName("respondsToSelector:");
public static final int sel_namesOfPromisedFilesDroppedAtDestination_1 = sel_registerName("namesOfPromisedFilesDroppedAtDestination:");
public static final int sel_unsignedShortValue = sel_registerName("unsignedShortValue");
public static final int sel_setZeroSymbol_1 = sel_registerName("setZeroSymbol:");
public static final int sel_resourcePath = sel_registerName("resourcePath");
public static final int sel_markerFormat = sel_registerName("markerFormat");
public static final int sel_hotSpot = sel_registerName("hotSpot");
public static final int sel_imageUnfilteredPasteboardTypes = sel_registerName("imageUnfilteredPasteboardTypes");
public static final int sel_editedRange = sel_registerName("editedRange");
public static final int sel_setMenuChangedMessagesEnabled_1 = sel_registerName("setMenuChangedMessagesEnabled:");
public static final int sel_tailIndent = sel_registerName("tailIndent");
public static final int sel_release = sel_registerName("release");
public static final int sel_readFromURL_1options_1documentAttributes_1 = sel_registerName("readFromURL:options:documentAttributes:");
public static final int sel_underlinePosition = sel_registerName("underlinePosition");
public static final int sel_setMinItemSize_1 = sel_registerName("setMinItemSize:");
public static final int sel_initWithImage_1foregroundColorHint_1backgroundColorHint_1hotSpot_1 = sel_registerName("initWithImage:foregroundColorHint:backgroundColorHint:hotSpot:");
public static final int sel_setPlaceholderString_1 = sel_registerName("setPlaceholderString:");
public static final int sel_createDirectoryAtPath_1withIntermediateDirectories_1attributes_1error_1 = sel_registerName("createDirectoryAtPath:withIntermediateDirectories:attributes:error:");
public static final int sel_setDefaultTabInterval_1 = sel_registerName("setDefaultTabInterval:");
public static final int sel_invertedSet = sel_registerName("invertedSet");
public static final int sel_iconForFile_1 = sel_registerName("iconForFile:");
public static final int sel_modifyFont_1 = sel_registerName("modifyFont:");
public static final int sel_setProcessName_1 = sel_registerName("setProcessName:");
public static final int sel_addObserver_1toObjectsAtIndexes_1forKeyPath_1options_1context_1 = sel_registerName("addObserver:toObjectsAtIndexes:forKeyPath:options:context:");
public static final int sel_resolve = sel_registerName("resolve");
public static final int sel_namespaces = sel_registerName("namespaces");
public static final int sel_drawInBezierPath_1angle_1 = sel_registerName("drawInBezierPath:angle:");
public static final int sel_setPixelFormat_1 = sel_registerName("setPixelFormat:");
public static final int sel_resizeUpDownCursor = sel_registerName("resizeUpDownCursor");
public static final int sel_daylightSavingTimeOffsetForDate_1 = sel_registerName("daylightSavingTimeOffsetForDate:");
public static final int sel_setCanSpawnSeparateThread_1 = sel_registerName("setCanSpawnSeparateThread:");
public static final int sel_setTitleBaseWritingDirection_1 = sel_registerName("setTitleBaseWritingDirection:");
public static final int sel_subscript_1 = sel_registerName("subscript:");
public static final int sel_URL = sel_registerName("URL");
public static final int sel_headerColor = sel_registerName("headerColor");
public static final int sel_stringByAddingPercentEscapesUsingEncoding_1 = sel_registerName("stringByAddingPercentEscapesUsingEncoding:");
public static final int sel_draggingExited_1 = sel_registerName("draggingExited:");
public static final int sel_ignoreModifierKeysWhileDragging = sel_registerName("ignoreModifierKeysWhileDragging");
public static final int sel_componentsToDisplayForPath_1 = sel_registerName("componentsToDisplayForPath:");
public static final int sel_glyphRangeForBoundingRectWithoutAdditionalLayout_1inTextContainer_1 = sel_registerName("glyphRangeForBoundingRectWithoutAdditionalLayout:inTextContainer:");
public static final int sel_removeTrackingRect_1 = sel_registerName("removeTrackingRect:");
public static final int sel_handlePrintScriptCommand_1 = sel_registerName("handlePrintScriptCommand:");
public static final int sel_viewDidMoveToWindow = sel_registerName("viewDidMoveToWindow");
public static final int sel_allocateGState = sel_registerName("allocateGState");
public static final int sel_availableStringEncodings = sel_registerName("availableStringEncodings");
public static final int sel_instantiateNibWithExternalNameTable_1 = sel_registerName("instantiateNibWithExternalNameTable:");
public static final int sel_setWeekdayOrdinal_1 = sel_registerName("setWeekdayOrdinal:");
public static final int sel_setWithCapacity_1 = sel_registerName("setWithCapacity:");
public static final int sel_setCurrentAppleEventAndReplyEventWithSuspensionID_1 = sel_registerName("setCurrentAppleEventAndReplyEventWithSuspensionID:");
public static final int sel_convertFont_1toNotHaveTrait_1 = sel_registerName("convertFont:toNotHaveTrait:");
public static final int sel_performSelector_1withObject_1withObject_1 = sel_registerName("performSelector:withObject:withObject:");
public static final int sel_removeIndexes_1 = sel_registerName("removeIndexes:");
public static final int sel_objectSpecifierWithDescriptor_1 = sel_registerName("objectSpecifierWithDescriptor:");
public static final int sel_objectValue = sel_registerName("objectValue");
public static final int sel_timeZone = sel_registerName("timeZone");
public static final int sel_viewSizeChanged_1 = sel_registerName("viewSizeChanged:");
public static final int sel_clearDrawable = sel_registerName("clearDrawable");
public static final int sel_parentRowForRow_1 = sel_registerName("parentRowForRow:");
public static final int sel_trackingMode = sel_registerName("trackingMode");
public static final int sel_selectedRanges = sel_registerName("selectedRanges");
public static final int sel_suspendExecution = sel_registerName("suspendExecution");
public static final int sel_setDefaultPrinter_1 = sel_registerName("setDefaultPrinter:");
public static final int sel_loadDataRepresentation_1ofType_1 = sel_registerName("loadDataRepresentation:ofType:");
public static final int sel_closestTickMarkValueToValue_1 = sel_registerName("closestTickMarkValueToValue:");
public static final int sel_removeFromRunLoop_1forMode_1 = sel_registerName("removeFromRunLoop:forMode:");
public static final int sel_cancelUserAttentionRequest_1 = sel_registerName("cancelUserAttentionRequest:");
public static final int sel_dictionaryWithObject_1forKey_1 = sel_registerName("dictionaryWithObject:forKey:");
public static final int sel_isDataRetained = sel_registerName("isDataRetained");
public static final int sel_setLoops_1 = sel_registerName("setLoops:");
public static final int sel_hashTableWithWeakObjects = sel_registerName("hashTableWithWeakObjects");
public static final int sel_documentForURL_1 = sel_registerName("documentForURL:");
public static final int sel_removeRepresentation_1 = sel_registerName("removeRepresentation:");
public static final int sel_keyClassDescription = sel_registerName("keyClassDescription");
public static final int sel_noResponderFor_1 = sel_registerName("noResponderFor:");
public static final int sel_setBidiLevels_1forGlyphRange_1 = sel_registerName("setBidiLevels:forGlyphRange:");
public static final int sel_cancelIncrementalLoad = sel_registerName("cancelIncrementalLoad");
public static final int sel_highlightedBranchImage = sel_registerName("highlightedBranchImage");
public static final int sel_setAttributedStringForZero_1 = sel_registerName("setAttributedStringForZero:");
public static final int sel_drawAtPoint_1fromRect_1operation_1fraction_1 = sel_registerName("drawAtPoint:fromRect:operation:fraction:");
public static final int sel_fileHFSTypeCode = sel_registerName("fileHFSTypeCode");
public static final int sel_maximumRecents = sel_registerName("maximumRecents");
public static final int sel_useFont_1 = sel_registerName("useFont:");
public static final int sel_selectKeyViewPrecedingView_1 = sel_registerName("selectKeyViewPrecedingView:");
public static final int sel_attributedStringForNil = sel_registerName("attributedStringForNil");
public static final int sel_isGrammarCheckingEnabled = sel_registerName("isGrammarCheckingEnabled");
public static final int sel_owner = sel_registerName("owner");
public static final int sel_searchForServicesOfType_1inDomain_1 = sel_registerName("searchForServicesOfType:inDomain:");
public static final int sel_frameAutosaveName = sel_registerName("frameAutosaveName");
public static final int sel_setCommands_1 = sel_registerName("setCommands:");
public static final int sel_URLResourceDidCancelLoading_1 = sel_registerName("URLResourceDidCancelLoading:");
public static final int sel_uniqueSpellDocumentTag = sel_registerName("uniqueSpellDocumentTag");
public static final int sel_needsToBeUpdatedFromPath_1 = sel_registerName("needsToBeUpdatedFromPath:");
public static final int sel_bounds = sel_registerName("bounds");
public static final int sel_contextHelpForKey_1 = sel_registerName("contextHelpForKey:");
public static final int sel_setSendsActionOnEndEditing_1 = sel_registerName("setSendsActionOnEndEditing:");
public static final int sel_scanDouble_1 = sel_registerName("scanDouble:");
public static final int sel_download_1willResumeWithResponse_1fromByte_1 = sel_registerName("download:willResumeWithResponse:fromByte:");
public static final int sel_drawFromCenter_1radius_1toCenter_1radius_1options_1 = sel_registerName("drawFromCenter:radius:toCenter:radius:options:");
public static final int sel_defaultFlatness = sel_registerName("defaultFlatness");
public static final int sel_keepBackupFile = sel_registerName("keepBackupFile");
public static final int sel_willChangeValueForKey_1 = sel_registerName("willChangeValueForKey:");
public static final int sel_initWithDateFormat_1allowNaturalLanguage_1 = sel_registerName("initWithDateFormat:allowNaturalLanguage:");
public static final int sel_textView_1writablePasteboardTypesForCell_1atIndex_1 = sel_registerName("textView:writablePasteboardTypesForCell:atIndex:");
public static final int sel_getTIFFCompressionTypes_1count_1 = sel_registerName("getTIFFCompressionTypes:count:");
public static final int sel_decodePropertyList = sel_registerName("decodePropertyList");
public static final int sel_saveDocumentWithDelegate_1didSaveSelector_1contextInfo_1 = sel_registerName("saveDocumentWithDelegate:didSaveSelector:contextInfo:");
public static final int sel_encodePoint_1 = sel_registerName("encodePoint:");
public static final int sel_selectRow_1byExtendingSelection_1 = sel_registerName("selectRow:byExtendingSelection:");
public static final int sel_preservesContentDuringLiveResize = sel_registerName("preservesContentDuringLiveResize");
public static final int sel_registerUndoWithTarget_1selector_1object_1 = sel_registerName("registerUndoWithTarget:selector:object:");
public static final int sel_removeCollection_1 = sel_registerName("removeCollection:");
public static final int sel_nextEventMatchingMask_1 = sel_registerName("nextEventMatchingMask:");
public static final int sel_getObjects_1andKeys_1 = sel_registerName("getObjects:andKeys:");
public static final int sel_EPSRepresentation = sel_registerName("EPSRepresentation");
public static final int sel_isModalPanel = sel_registerName("isModalPanel");
public static final int sel_statusCode = sel_registerName("statusCode");
public static final int sel_setCopiesOnScroll_1 = sel_registerName("setCopiesOnScroll:");
public static final int sel_setHorizontalPagination_1 = sel_registerName("setHorizontalPagination:");
public static final int sel_removeAllIndexes = sel_registerName("removeAllIndexes");
public static final int sel_download_1didFailWithError_1 = sel_registerName("download:didFailWithError:");
public static final int sel_modifierFlags = sel_registerName("modifierFlags");
public static final int sel_draggedColumn = sel_registerName("draggedColumn");
public static final int sel_initWithUser_1 = sel_registerName("initWithUser:");
public static final int sel_setLayoutRect_1forTextBlock_1glyphRange_1 = sel_registerName("setLayoutRect:forTextBlock:glyphRange:");
public static final int sel_selectionAffinity = sel_registerName("selectionAffinity");
public static final int sel_beginParagraph = sel_registerName("beginParagraph");
public static final int sel_runModalForTypes_1 = sel_registerName("runModalForTypes:");
public static final int sel_reloadCriteria = sel_registerName("reloadCriteria");
public static final int sel_PDFOperationWithView_1insideRect_1toData_1printInfo_1 = sel_registerName("PDFOperationWithView:insideRect:toData:printInfo:");
public static final int sel_cellAtRow_1column_1 = sel_registerName("cellAtRow:column:");
public static final int sel_selectColumn_1byExtendingSelection_1 = sel_registerName("selectColumn:byExtendingSelection:");
public static final int sel_addresses = sel_registerName("addresses");
public static final int sel_setCanBeVisibleOnAllSpaces_1 = sel_registerName("setCanBeVisibleOnAllSpaces:");
public static final int sel_bundleForSuite_1 = sel_registerName("bundleForSuite:");
public static final int sel_stringWithCharacters_1length_1 = sel_registerName("stringWithCharacters:length:");
public static final int sel_dataWithContentsOfURL_1options_1error_1 = sel_registerName("dataWithContentsOfURL:options:error:");
public static final int sel_isExpanded = sel_registerName("isExpanded");
public static final int sel_rectForLayoutAtPoint_1inRect_1textContainer_1characterRange_1 = sel_registerName("rectForLayoutAtPoint:inRect:textContainer:characterRange:");
public static final int sel_initWithXMLString_1options_1error_1 = sel_registerName("initWithXMLString:options:error:");
public static final int sel_datePickerCell_1validateProposedDateValue_1timeInterval_1 = sel_registerName("datePickerCell:validateProposedDateValue:timeInterval:");
public static final int sel_replaceCharactersInRange_1withRTFD_1 = sel_registerName("replaceCharactersInRange:withRTFD:");
public static final int sel_setNeedsDisplay_1 = sel_registerName("setNeedsDisplay:");
public static final int sel_tableViewColumnDidMove_1 = sel_registerName("tableViewColumnDidMove:");
public static final int sel_printOperationWithView_1printInfo_1 = sel_registerName("printOperationWithView:printInfo:");
public static final int sel_parserDidStartDocument_1 = sel_registerName("parserDidStartDocument:");
public static final int sel_privateFrameworksPath = sel_registerName("privateFrameworksPath");
public static final int sel_informativeText = sel_registerName("informativeText");
public static final int sel_attributesAtIndex_1effectiveRange_1 = sel_registerName("attributesAtIndex:effectiveRange:");
public static final int sel_rectArrayForGlyphRange_1withinSelectedGlyphRange_1inTextContainer_1rectCount_1 = sel_registerName("rectArrayForGlyphRange:withinSelectedGlyphRange:inTextContainer:rectCount:");
public static final int sel_swapWithMark_1 = sel_registerName("swapWithMark:");
public static final int sel_setDrawsGrid_1 = sel_registerName("setDrawsGrid:");
public static final int sel_highlight_1 = sel_registerName("highlight:");
public static final int sel_maximumLineHeight = sel_registerName("maximumLineHeight");
public static final int sel_phonemesFromText_1 = sel_registerName("phonemesFromText:");
public static final int sel_convertSize_1fromView_1 = sel_registerName("convertSize:fromView:");
public static final int sel_setProperty_1withValue_1 = sel_registerName("setProperty:withValue:");
public static final int sel_cookieAcceptPolicy = sel_registerName("cookieAcceptPolicy");
public static final int sel_hasThousandSeparators = sel_registerName("hasThousandSeparators");
public static final int sel_setTighteningFactorForTruncation_1 = sel_registerName("setTighteningFactorForTruncation:");
public static final int sel_contextMenuRepresentation = sel_registerName("contextMenuRepresentation");
public static final int sel_precomposedStringWithCompatibilityMapping = sel_registerName("precomposedStringWithCompatibilityMapping");
public static final int sel_threadDictionary = sel_registerName("threadDictionary");
public static final int sel_redoMenuTitleForUndoActionName_1 = sel_registerName("redoMenuTitleForUndoActionName:");
public static final int sel_setNumberOfVisibleItems_1 = sel_registerName("setNumberOfVisibleItems:");
public static final int sel_preferredLanguages = sel_registerName("preferredLanguages");
public static final int sel_mouseDraggedOnCharacterIndex_1atCoordinate_1withModifier_1client_1 = sel_registerName("mouseDraggedOnCharacterIndex:atCoordinate:withModifier:client:");
public static final int sel_setMultiplier_1 = sel_registerName("setMultiplier:");
public static final int sel_sortedArrayUsingSelector_1 = sel_registerName("sortedArrayUsingSelector:");
public static final int sel_drawInRect_1 = sel_registerName("drawInRect:");
public static final int sel_reversedSortDescriptor = sel_registerName("reversedSortDescriptor");
public static final int sel_setIdentifier_1 = sel_registerName("setIdentifier:");
public static final int sel_systemLocale = sel_registerName("systemLocale");
public static final int sel_rulerView_1didMoveMarker_1 = sel_registerName("rulerView:didMoveMarker:");
public static final int sel_serviceConnectionWithName_1rootObject_1 = sel_registerName("serviceConnectionWithName:rootObject:");
public static final int sel_mouseDownCanMoveWindow = sel_registerName("mouseDownCanMoveWindow");
public static final int sel_setMode_1 = sel_registerName("setMode:");
public static final int sel_rectOfTickMarkAtIndex_1 = sel_registerName("rectOfTickMarkAtIndex:");
public static final int sel_rangeOfCharacterFromSet_1 = sel_registerName("rangeOfCharacterFromSet:");
public static final int sel_pageUp_1 = sel_registerName("pageUp:");
public static final int sel_sendsWholeSearchString = sel_registerName("sendsWholeSearchString");
public static final int sel_selectColumnIndexes_1byExtendingSelection_1 = sel_registerName("selectColumnIndexes:byExtendingSelection:");
public static final int sel_localizedCaseInsensitiveCompare_1 = sel_registerName("localizedCaseInsensitiveCompare:");
public static final int sel_isEqualToString_1 = sel_registerName("isEqualToString:");
public static final int sel_invalidateHashMarks = sel_registerName("invalidateHashMarks");
public static final int sel_setInitialKey_1 = sel_registerName("setInitialKey:");
public static final int sel_setDividerStyle_1 = sel_registerName("setDividerStyle:");
public static final int sel_expressionForMinusSet_1with_1 = sel_registerName("expressionForMinusSet:with:");
public static final int sel_netService_1didNotPublish_1 = sel_registerName("netService:didNotPublish:");
public static final int sel_evaluatedReceivers = sel_registerName("evaluatedReceivers");
public static final int sel_removeTabViewItem_1 = sel_registerName("removeTabViewItem:");
public static final int sel_initWithContainerClassDescription_1containerSpecifier_1key_1index_1 = sel_registerName("initWithContainerClassDescription:containerSpecifier:key:index:");
public static final int sel_predicateWithLeftExpression_1rightExpression_1customSelector_1 = sel_registerName("predicateWithLeftExpression:rightExpression:customSelector:");
public static final int sel_brownColor = sel_registerName("brownColor");
public static final int sel_leafKeyPathForNode_1 = sel_registerName("leafKeyPathForNode:");
public static final int sel_drawBackgroundForGlyphRange_1atPoint_1 = sel_registerName("drawBackgroundForGlyphRange:atPoint:");
public static final int sel_rulerView_1willSetClientView_1 = sel_registerName("rulerView:willSetClientView:");
public static final int sel_className = sel_registerName("className");
public static final int sel_runMode_1beforeDate_1 = sel_registerName("runMode:beforeDate:");
public static final int sel_applicationShouldTerminateAfterLastWindowClosed_1 = sel_registerName("applicationShouldTerminateAfterLastWindowClosed:");
public static final int sel_newDocument_1 = sel_registerName("newDocument:");
public static final int sel_arrayByAddingObject_1 = sel_registerName("arrayByAddingObject:");
public static final int sel_savePanel = sel_registerName("savePanel");
public static final int sel_prefersTrackingUntilMouseUp = sel_registerName("prefersTrackingUntilMouseUp");
public static final int sel_setLocations_1startingGlyphIndexes_1count_1forGlyphRange_1 = sel_registerName("setLocations:startingGlyphIndexes:count:forGlyphRange:");
public static final int sel_setListensInForegroundOnly_1 = sel_registerName("setListensInForegroundOnly:");
public static final int sel_initWithUnsignedShort_1 = sel_registerName("initWithUnsignedShort:");
public static final int sel_letterCharacterSet = sel_registerName("letterCharacterSet");
public static final int sel_listensInForegroundOnly = sel_registerName("listensInForegroundOnly");
public static final int sel_menu_1willHighlightItem_1 = sel_registerName("menu:willHighlightItem:");
public static final int sel_charactersIgnoringModifiers = sel_registerName("charactersIgnoringModifiers");
public static final int sel_insertionContainer = sel_registerName("insertionContainer");
public static final int sel_searchButtonRectForBounds_1 = sel_registerName("searchButtonRectForBounds:");
public static final int sel_accessibilitySetValue_1forAttribute_1 = sel_registerName("accessibilitySetValue:forAttribute:");
public static final int sel_setPathSeparator_1 = sel_registerName("setPathSeparator:");
public static final int sel_applicationWillResignActive_1 = sel_registerName("applicationWillResignActive:");
public static final int sel_scriptingIsLessThanOrEqualTo_1 = sel_registerName("scriptingIsLessThanOrEqualTo:");
public static final int sel_decodeValuesOfObjCTypes_1 = sel_registerName("decodeValuesOfObjCTypes:");
public static final int sel_setIntercellSpacing_1 = sel_registerName("setIntercellSpacing:");
public static final int sel_sharedSystemTypesetterForBehavior_1 = sel_registerName("sharedSystemTypesetterForBehavior:");
public static final int sel_drawFromPoint_1toPoint_1options_1 = sel_registerName("drawFromPoint:toPoint:options:");
public static final int sel_windowDidMove_1 = sel_registerName("windowDidMove:");
public static final int sel_setVisible_1 = sel_registerName("setVisible:");
public static final int sel_credentialWithUser_1password_1persistence_1 = sel_registerName("credentialWithUser:password:persistence:");
public static final int sel_decomposedStringWithCanonicalMapping = sel_registerName("decomposedStringWithCanonicalMapping");
public static final int sel_openFile_1withApplication_1andDeactivate_1 = sel_registerName("openFile:withApplication:andDeactivate:");
public static final int sel_convertRectToBase_1 = sel_registerName("convertRectToBase:");
public static final int sel_outputStreamToMemory = sel_registerName("outputStreamToMemory");
public static final int sel_autorepeat = sel_registerName("autorepeat");
public static final int sel_servicesMenu = sel_registerName("servicesMenu");
public static final int sel_beginGrouping = sel_registerName("beginGrouping");
public static final int sel_setNilValueForKey_1 = sel_registerName("setNilValueForKey:");
public static final int sel_usesFontLeading = sel_registerName("usesFontLeading");
public static final int sel_lineFragmentRectForGlyphAtIndex_1effectiveRange_1 = sel_registerName("lineFragmentRectForGlyphAtIndex:effectiveRange:");
public static final int sel_takeStringValueFrom_1 = sel_registerName("takeStringValueFrom:");
public static final int sel_fontDescriptorByAddingAttributes_1 = sel_registerName("fontDescriptorByAddingAttributes:");
public static final int sel_startTrackingAt_1inView_1 = sel_registerName("startTrackingAt:inView:");
public static final int sel_application_1delegateHandlesKey_1 = sel_registerName("application:delegateHandlesKey:");
public static final int sel_stringByExpandingTildeInPath = sel_registerName("stringByExpandingTildeInPath");
public static final int sel_menu = sel_registerName("menu");
public static final int sel_setMinute_1 = sel_registerName("setMinute:");
public static final int sel_startSubelementIdentifier = sel_registerName("startSubelementIdentifier");
public static final int sel_waitForDataInBackgroundAndNotifyForModes_1 = sel_registerName("waitForDataInBackgroundAndNotifyForModes:");
public static final int sel_removeCachedResponseForRequest_1 = sel_registerName("removeCachedResponseForRequest:");
public static final int sel_attributeForLocalName_1URI_1 = sel_registerName("attributeForLocalName:URI:");
public static final int sel_saveDocumentAs_1 = sel_registerName("saveDocumentAs:");
public static final int sel_containerIsObjectBeingTested = sel_registerName("containerIsObjectBeingTested");
public static final int sel_mouseDownOnCharacterIndex_1atCoordinate_1withModifier_1client_1 = sel_registerName("mouseDownOnCharacterIndex:atCoordinate:withModifier:client:");
public static final int sel_setPosition_1ofDividerAtIndex_1 = sel_registerName("setPosition:ofDividerAtIndex:");
public static final int sel_terminationStatus = sel_registerName("terminationStatus");
public static final int sel_imageWidth = sel_registerName("imageWidth");
public static final int sel_accessoryView = sel_registerName("accessoryView");
public static final int sel_outlineView_1shouldTrackCell_1forTableColumn_1item_1 = sel_registerName("outlineView:shouldTrackCell:forTableColumn:item:");
public static final int sel_initWithLevelIndicatorStyle_1 = sel_registerName("initWithLevelIndicatorStyle:");
public static final int sel_deltaX = sel_registerName("deltaX");
public static final int sel_valueForUndefinedKey_1 = sel_registerName("valueForUndefinedKey:");
public static final int sel_mainDocumentURL = sel_registerName("mainDocumentURL");
public static final int sel_position = sel_registerName("position");
public static final int sel_animates = sel_registerName("animates");
public static final int sel_addTabViewItem_1 = sel_registerName("addTabViewItem:");
public static final int sel_unlockFocus = sel_registerName("unlockFocus");
public static final int sel_download_1didCreateDestination_1 = sel_registerName("download:didCreateDestination:");
public static final int sel_defaults = sel_registerName("defaults");
public static final int sel_viewWillDraw = sel_registerName("viewWillDraw");
public static final int sel_findApplications = sel_registerName("findApplications");
public static final int sel_unbind_1 = sel_registerName("unbind:");
public static final int sel_positionOfGlyph_1withRelation_1toBaseGlyph_1totalAdvancement_1metricsExist_1 = sel_registerName("positionOfGlyph:withRelation:toBaseGlyph:totalAdvancement:metricsExist:");
public static final int sel_isGreaterThan_1 = sel_registerName("isGreaterThan:");
public static final int sel_dataWithPDFInsideRect_1 = sel_registerName("dataWithPDFInsideRect:");
public static final int sel_setAttributedTitle_1 = sel_registerName("setAttributedTitle:");
public static final int sel_expressionType = sel_registerName("expressionType");
public static final int sel_tokenFieldCell_1shouldAddObjects_1atIndex_1 = sel_registerName("tokenFieldCell:shouldAddObjects:atIndex:");
public static final int sel_removeEventHandlerForEventClass_1andEventID_1 = sel_registerName("removeEventHandlerForEventClass:andEventID:");
public static final int sel_postNotification_1 = sel_registerName("postNotification:");
public static final int sel_indexOfTabViewItem_1 = sel_registerName("indexOfTabViewItem:");
public static final int sel_outlineView_1shouldSelectItem_1 = sel_registerName("outlineView:shouldSelectItem:");
public static final int sel_setSegmentStyle_1 = sel_registerName("setSegmentStyle:");
public static final int sel_stateImageRectForBounds_1 = sel_registerName("stateImageRectForBounds:");
public static final int sel_setContentAspectRatio_1 = sel_registerName("setContentAspectRatio:");
public static final int sel_instantiateNibWithOwner_1topLevelObjects_1 = sel_registerName("instantiateNibWithOwner:topLevelObjects:");
public static final int sel_setPrototype_1 = sel_registerName("setPrototype:");
public static final int sel_allowsMultipleSelection = sel_registerName("allowsMultipleSelection");
public static final int sel_setRecentSearches_1 = sel_registerName("setRecentSearches:");
public static final int sel_setTypingAttributes_1 = sel_registerName("setTypingAttributes:");
public static final int sel_observeValueForKeyPath_1ofObject_1change_1context_1 = sel_registerName("observeValueForKeyPath:ofObject:change:context:");
public static final int sel_performDragOperation_1 = sel_registerName("performDragOperation:");
public static final int sel_processingInstructionWithName_1stringValue_1 = sel_registerName("processingInstructionWithName:stringValue:");
public static final int sel_initWithKind_1options_1 = sel_registerName("initWithKind:options:");
public static final int sel_instancesRespondToSelector_1 = sel_registerName("instancesRespondToSelector:");
public static final int sel_keyEquivalentFont = sel_registerName("keyEquivalentFont");
public static final int sel_calendarIdentifier = sel_registerName("calendarIdentifier");
public static final int sel_source = sel_registerName("source");
public static final int sel_shouldBeTreatedAsInkEvent_1 = sel_registerName("shouldBeTreatedAsInkEvent:");
public static final int sel_queuePriority = sel_registerName("queuePriority");
public static final int sel_autoresizesAllColumnsToFit = sel_registerName("autoresizesAllColumnsToFit");
public static final int sel_outlineView_1shouldCollapseItem_1 = sel_registerName("outlineView:shouldCollapseItem:");
public static final int sel_dragImage_1at_1offset_1event_1pasteboard_1source_1slideBack_1 = sel_registerName("dragImage:at:offset:event:pasteboard:source:slideBack:");
public static final int sel_sender = sel_registerName("sender");
public static final int sel_numberOfColumns = sel_registerName("numberOfColumns");
public static final int sel_indexPathWithIndex_1 = sel_registerName("indexPathWithIndex:");
public static final int sel_setPreferredFontNames_1 = sel_registerName("setPreferredFontNames:");
public static final int sel_windowDidEndSheet_1 = sel_registerName("windowDidEndSheet:");
public static final int sel_capHeight = sel_registerName("capHeight");
public static final int sel_matchingFontDescriptorWithMandatoryKeys_1 = sel_registerName("matchingFontDescriptorWithMandatoryKeys:");
public static final int sel_finalize = sel_registerName("finalize");
public static final int sel_prepareForDragOperation_1 = sel_registerName("prepareForDragOperation:");
public static final int sel_setCellAttribute_1to_1 = sel_registerName("setCellAttribute:to:");
public static final int sel_metadataQuery_1replacementValueForAttribute_1value_1 = sel_registerName("metadataQuery:replacementValueForAttribute:value:");
public static final int sel_hueComponent = sel_registerName("hueComponent");
public static final int sel_maxValue = sel_registerName("maxValue");
public static final int sel_soundUnfilteredTypes = sel_registerName("soundUnfilteredTypes");
public static final int sel_setFileAttributes_1 = sel_registerName("setFileAttributes:");
public static final int sel_valueLists = sel_registerName("valueLists");
public static final int sel_breakLock = sel_registerName("breakLock");
public static final int sel_selectCellWithTag_1 = sel_registerName("selectCellWithTag:");
public static final int sel_setMovable_1 = sel_registerName("setMovable:");
public static final int sel_synchronizeFile = sel_registerName("synchronizeFile");
public static final int sel_setVerticallyResizable_1 = sel_registerName("setVerticallyResizable:");
public static final int sel_setButtonBordered_1 = sel_registerName("setButtonBordered:");
public static final int sel_useOptimizedDrawing_1 = sel_registerName("useOptimizedDrawing:");
public static final int sel_tryLockWhenCondition_1 = sel_registerName("tryLockWhenCondition:");
public static final int sel_textContainer = sel_registerName("textContainer");
public static final int sel_setValueListAttributes_1 = sel_registerName("setValueListAttributes:");
public static final int sel_rangeOfCharacterFromSet_1options_1 = sel_registerName("rangeOfCharacterFromSet:options:");
public static final int sel_dragFile_1fromRect_1slideBack_1event_1 = sel_registerName("dragFile:fromRect:slideBack:event:");
public static final int sel_tickMarkPosition = sel_registerName("tickMarkPosition");
public static final int sel_addRunLoop_1 = sel_registerName("addRunLoop:");
public static final int sel_dataWithCapacity_1 = sel_registerName("dataWithCapacity:");
public static final int sel_removeVolatileDomainForName_1 = sel_registerName("removeVolatileDomainForName:");
public static final int sel_signal = sel_registerName("signal");
public static final int sel_progressMarks = sel_registerName("progressMarks");
public static final int sel_unhide_1 = sel_registerName("unhide:");
public static final int sel_provideNewButtonImage = sel_registerName("provideNewButtonImage");
public static final int sel_connectionWithRegisteredName_1host_1usingNameServer_1 = sel_registerName("connectionWithRegisteredName:host:usingNameServer:");
public static final int sel_localizesFormat = sel_registerName("localizesFormat");
public static final int sel_lineScroll = sel_registerName("lineScroll");
public static final int sel_initDirectoryWithFileWrappers_1 = sel_registerName("initDirectoryWithFileWrappers:");
public static final int sel_wantsToInterpretAllKeystrokes = sel_registerName("wantsToInterpretAllKeystrokes");
public static final int sel_convertPointToBase_1 = sel_registerName("convertPointToBase:");
public static final int sel_keyWithAppleEventCode_1 = sel_registerName("keyWithAppleEventCode:");
public static final int sel_loadSuiteWithDictionary_1fromBundle_1 = sel_registerName("loadSuiteWithDictionary:fromBundle:");
public static final int sel_automaticallyPreparesContent = sel_registerName("automaticallyPreparesContent");
public static final int sel_cornerRadius = sel_registerName("cornerRadius");
public static final int sel_sharedScriptExecutionContext = sel_registerName("sharedScriptExecutionContext");
public static final int sel_setPoolCountHighWaterResolution_1 = sel_registerName("setPoolCountHighWaterResolution:");
public static final int sel_appendBezierPath_1 = sel_registerName("appendBezierPath:");
public static final int sel_appleEventClassCode = sel_registerName("appleEventClassCode");
public static final int sel_initTextCell_1pullsDown_1 = sel_registerName("initTextCell:pullsDown:");
public static final int sel_numberOfTickMarks = sel_registerName("numberOfTickMarks");
public static final int sel_setIndependentConversationQueueing_1 = sel_registerName("setIndependentConversationQueueing:");
public static final int sel_extendPowerOffBy_1 = sel_registerName("extendPowerOffBy:");
public static final int sel_isCollecting = sel_registerName("isCollecting");
public static final int sel_canInsert = sel_registerName("canInsert");
public static final int sel_valuePointerFunctions = sel_registerName("valuePointerFunctions");
public static final int sel_sizeValue = sel_registerName("sizeValue");
public static final int sel_openOnEdge_1 = sel_registerName("openOnEdge:");
public static final int sel_rectOfItemAtIndex_1 = sel_registerName("rectOfItemAtIndex:");
public static final int sel_booleanForKey_1inTable_1 = sel_registerName("booleanForKey:inTable:");
public static final int sel_showHelp_1 = sel_registerName("showHelp:");
public static final int sel_heightTracksTextView = sel_registerName("heightTracksTextView");
public static final int sel_hasTitleBar = sel_registerName("hasTitleBar");
public static final int sel_setViewAnimations_1 = sel_registerName("setViewAnimations:");
public static final int sel_updateSpellingPanelWithGrammarString_1detail_1 = sel_registerName("updateSpellingPanelWithGrammarString:detail:");
public static final int sel_showsToolbarButton = sel_registerName("showsToolbarButton");
public static final int sel_environment = sel_registerName("environment");
public static final int sel_matchesAppleEventCode_1 = sel_registerName("matchesAppleEventCode:");
public static final int sel_hasPrefix_1 = sel_registerName("hasPrefix:");
public static final int sel_hasUnappliedChanges = sel_registerName("hasUnappliedChanges");
public static final int sel_setName_1 = sel_registerName("setName:");
public static final int sel_isMovableByWindowBackground = sel_registerName("isMovableByWindowBackground");
public static final int sel_printerNames = sel_registerName("printerNames");
public static final int sel_initWithDictionary_1 = sel_registerName("initWithDictionary:");
public static final int sel_stringByStandardizingPath = sel_registerName("stringByStandardizingPath");
public static final int sel_usesUserKeyEquivalents = sel_registerName("usesUserKeyEquivalents");
public static final int sel_drawStateImageWithFrame_1inView_1 = sel_registerName("drawStateImageWithFrame:inView:");
public static final int sel_openUntitledDocumentAndDisplay_1error_1 = sel_registerName("openUntitledDocumentAndDisplay:error:");
public static final int sel_lastVisibleColumn = sel_registerName("lastVisibleColumn");
public static final int sel_paste_1 = sel_registerName("paste:");
public static final int sel_indexOfItemWithRepresentedObject_1 = sel_registerName("indexOfItemWithRepresentedObject:");
public static final int sel_supportsCommand_1 = sel_registerName("supportsCommand:");
public static final int sel_scrollPageUp_1 = sel_registerName("scrollPageUp:");
public static final int sel_draggedImage_1endedAt_1deposited_1 = sel_registerName("draggedImage:endedAt:deposited:");
public static final int sel_setPositiveInfinitySymbol_1 = sel_registerName("setPositiveInfinitySymbol:");
public static final int sel_noteFileSystemChanged_1 = sel_registerName("noteFileSystemChanged:");
public static final int sel_moveRight_1 = sel_registerName("moveRight:");
public static final int sel_arrowPosition = sel_registerName("arrowPosition");
public static final int sel_setMenuRepresentation_1 = sel_registerName("setMenuRepresentation:");
public static final int sel_endLoadInBackground = sel_registerName("endLoadInBackground");
public static final int sel_smartInsertBeforeStringForString_1replacingRange_1 = sel_registerName("smartInsertBeforeStringForString:replacingRange:");
public static final int sel_openUntitledDocumentOfType_1display_1 = sel_registerName("openUntitledDocumentOfType:display:");
public static final int sel_scriptingValueForSpecifier_1 = sel_registerName("scriptingValueForSpecifier:");
public static final int sel_setShowsSuppressionButton_1 = sel_registerName("setShowsSuppressionButton:");
public static final int sel_resizeLeftCursor = sel_registerName("resizeLeftCursor");
public static final int sel_setDefaultCredential_1forProtectionSpace_1 = sel_registerName("setDefaultCredential:forProtectionSpace:");
public static final int sel_systemTabletID = sel_registerName("systemTabletID");
public static final int sel_unlock = sel_registerName("unlock");
public static final int sel_mostCompatibleStringEncoding = sel_registerName("mostCompatibleStringEncoding");
public static final int sel_glyphName = sel_registerName("glyphName");
public static final int sel_center = sel_registerName("center");
public static final int sel_setJobTitle_1 = sel_registerName("setJobTitle:");
public static final int sel_cancelButtonCell = sel_registerName("cancelButtonCell");
public static final int sel_namespaceForPrefix_1 = sel_registerName("namespaceForPrefix:");
public static final int sel_browserWillScroll_1 = sel_registerName("browserWillScroll:");
public static final int sel_initWithCompoundTypes_1 = sel_registerName("initWithCompoundTypes:");
public static final int sel_setPaddingCharacter_1 = sel_registerName("setPaddingCharacter:");
public static final int sel_image_1willLoadRepresentation_1 = sel_registerName("image:willLoadRepresentation:");
public static final int sel_pasteRuler_1 = sel_registerName("pasteRuler:");
public static final int sel_drawGlyphsForGlyphRange_1atPoint_1 = sel_registerName("drawGlyphsForGlyphRange:atPoint:");
public static final int sel_PMPrintSession = sel_registerName("PMPrintSession");
public static final int sel_setDefaultButtonCell_1 = sel_registerName("setDefaultButtonCell:");
public static final int sel_printerTypes = sel_registerName("printerTypes");
public static final int sel_findString_1inBook_1 = sel_registerName("findString:inBook:");
public static final int sel_executablePath = sel_registerName("executablePath");
public static final int sel_components_1fromDate_1toDate_1options_1 = sel_registerName("components:fromDate:toDate:options:");
public static final int sel_displayValuesForRow_1 = sel_registerName("displayValuesForRow:");
public static final int sel_pageLayout = sel_registerName("pageLayout");
public static final int sel_resizeFlags = sel_registerName("resizeFlags");
public static final int sel_DTDNodeWithXMLString_1 = sel_registerName("DTDNodeWithXMLString:");
public static final int sel_replyToOpenOrPrint_1 = sel_registerName("replyToOpenOrPrint:");
public static final int sel_insertTab_1 = sel_registerName("insertTab:");
public static final int sel_documents = sel_registerName("documents");
public static final int sel_tagForSegment_1 = sel_registerName("tagForSegment:");
public static final int sel_initForURL_1withContentsOfURL_1ofType_1error_1 = sel_registerName("initForURL:withContentsOfURL:ofType:error:");
public static final int sel_initWithRoundingMode_1scale_1raiseOnExactness_1raiseOnOverflow_1raiseOnUnderflow_1raiseOnDivideByZero_1 = sel_registerName("initWithRoundingMode:scale:raiseOnExactness:raiseOnOverflow:raiseOnUnderflow:raiseOnDivideByZero:");
public static final int sel_addIndexes_1 = sel_registerName("addIndexes:");
public static final int sel_setAttributeRuns_1 = sel_registerName("setAttributeRuns:");
public static final int sel_splitView_1additionalEffectiveRectOfDividerAtIndex_1 = sel_registerName("splitView:additionalEffectiveRectOfDividerAtIndex:");
public static final int sel_writeSelectionToPasteboard_1type_1 = sel_registerName("writeSelectionToPasteboard:type:");
public static final int sel_day = sel_registerName("day");
public static final int sel_numberOfRowsInTableView_1 = sel_registerName("numberOfRowsInTableView:");
public static final int sel_insertCompletion_1forPartialWordRange_1movement_1isFinal_1 = sel_registerName("insertCompletion:forPartialWordRange:movement:isFinal:");
public static final int sel_notPredicateWithSubpredicate_1 = sel_registerName("notPredicateWithSubpredicate:");
public static final int sel_rootProxyForConnectionWithRegisteredName_1host_1 = sel_registerName("rootProxyForConnectionWithRegisteredName:host:");
public static final int sel_stopSpeakingAtBoundary_1 = sel_registerName("stopSpeakingAtBoundary:");
public static final int sel_pathsMatchingExtensions_1 = sel_registerName("pathsMatchingExtensions:");
public static final int sel_caseInsensitiveCompare_1 = sel_registerName("caseInsensitiveCompare:");
public static final int sel_labelFontOfSize_1 = sel_registerName("labelFontOfSize:");
public static final int sel_createDirectoryAtPath_1attributes_1 = sel_registerName("createDirectoryAtPath:attributes:");
public static final int sel_initListDescriptor = sel_registerName("initListDescriptor");
public static final int sel_setParagraphSpacing_1 = sel_registerName("setParagraphSpacing:");
public static final int sel_getColor_1location_1atIndex_1 = sel_registerName("getColor:location:atIndex:");
public static final int sel_pointerArrayWithOptions_1 = sel_registerName("pointerArrayWithOptions:");
public static final int sel_guessesForWord_1 = sel_registerName("guessesForWord:");
public static final int sel_searchTextRectForBounds_1 = sel_registerName("searchTextRectForBounds:");
public static final int sel_allowsColumnReordering = sel_registerName("allowsColumnReordering");
public static final int sel_isMainThread = sel_registerName("isMainThread");
public static final int sel_accessibilityAttributeNames = sel_registerName("accessibilityAttributeNames");
public static final int sel_saveOptions = sel_registerName("saveOptions");
public static final int sel_setAutomaticallyPreparesContent_1 = sel_registerName("setAutomaticallyPreparesContent:");
public static final int sel_setGridColor_1 = sel_registerName("setGridColor:");
public static final int sel_textAttributesForNegativeInfinity = sel_registerName("textAttributesForNegativeInfinity");
public static final int sel_decimalDigitCharacterSet = sel_registerName("decimalDigitCharacterSet");
public static final int sel_removeObserver_1name_1object_1 = sel_registerName("removeObserver:name:object:");
public static final int sel_columnContentWidthForColumnWidth_1 = sel_registerName("columnContentWidthForColumnWidth:");
public static final int sel_wraps = sel_registerName("wraps");
public static final int sel_getIndexes_1maxCount_1inIndexRange_1 = sel_registerName("getIndexes:maxCount:inIndexRange:");
public static final int sel_doubleAction = sel_registerName("doubleAction");
public static final int sel_layoutParagraphAtPoint_1 = sel_registerName("layoutParagraphAtPoint:");
public static final int sel_cacheDisplayInRect_1toBitmapImageRep_1 = sel_registerName("cacheDisplayInRect:toBitmapImageRep:");
public static final int sel_setUsesItemFromMenu_1 = sel_registerName("setUsesItemFromMenu:");
public static final int sel_parserError = sel_registerName("parserError");
public static final int sel_numberOfMajorTickMarks = sel_registerName("numberOfMajorTickMarks");
public static final int sel_changeFont_1 = sel_registerName("changeFont:");
public static final int sel_displaysWhenScreenProfileChanges = sel_registerName("displaysWhenScreenProfileChanges");
public static final int sel_titleBaseWritingDirection = sel_registerName("titleBaseWritingDirection");
public static final int sel_columnAtPoint_1 = sel_registerName("columnAtPoint:");
public static final int sel_setAppliesImmediately_1 = sel_registerName("setAppliesImmediately:");
public static final int sel_addAccessoryController_1 = sel_registerName("addAccessoryController:");
public static final int sel_setEditable_1 = sel_registerName("setEditable:");
public static final int sel_moveRulerlineFromLocation_1toLocation_1 = sel_registerName("moveRulerlineFromLocation:toLocation:");
public static final int sel_runModal = sel_registerName("runModal");
public static final int sel_selectionShouldChangeInTableView_1 = sel_registerName("selectionShouldChangeInTableView:");
public static final int sel_dragSelectionWithEvent_1offset_1slideBack_1 = sel_registerName("dragSelectionWithEvent:offset:slideBack:");
public static final int sel_rootProxy = sel_registerName("rootProxy");
public static final int sel_brightnessComponent = sel_registerName("brightnessComponent");
public static final int sel_setLabel_1forSegment_1 = sel_registerName("setLabel:forSegment:");
public static final int sel_copy = sel_registerName("copy");
public static final int sel_helpRequested_1 = sel_registerName("helpRequested:");
public static final int sel_setThreadPriority_1 = sel_registerName("setThreadPriority:");
public static final int sel_minContentSize = sel_registerName("minContentSize");
public static final int sel_setShowsProgressPanel_1 = sel_registerName("setShowsProgressPanel:");
public static final int sel_setMessageText_1 = sel_registerName("setMessageText:");
public static final int sel_setLayoutAlgorithm_1 = sel_registerName("setLayoutAlgorithm:");
public static final int sel_setInContext_1 = sel_registerName("setInContext:");
public static final int sel_resultCount = sel_registerName("resultCount");
public static final int sel_usesDataSource = sel_registerName("usesDataSource");
public static final int sel_textLists = sel_registerName("textLists");
public static final int sel_setSelectedRange_1affinity_1stillSelecting_1 = sel_registerName("setSelectedRange:affinity:stillSelecting:");
public static final int sel_shouldResolveExternalEntities = sel_registerName("shouldResolveExternalEntities");
public static final int sel_clientView = sel_registerName("clientView");
public static final int sel_styleMask = sel_registerName("styleMask");
public static final int sel_setCurrencyCode_1 = sel_registerName("setCurrencyCode:");
public static final int sel_methodReturnType = sel_registerName("methodReturnType");
public static final int sel_dataUsingEncoding_1 = sel_registerName("dataUsingEncoding:");
public static final int sel_removeTabStop_1 = sel_registerName("removeTabStop:");
public static final int sel_reloadItem_1reloadChildren_1 = sel_registerName("reloadItem:reloadChildren:");
public static final int sel_ancestorSharedWithView_1 = sel_registerName("ancestorSharedWithView:");
public static final int sel_indexLessThanOrEqualToIndex_1 = sel_registerName("indexLessThanOrEqualToIndex:");
public static final int sel_removeAllActionsWithTarget_1 = sel_registerName("removeAllActionsWithTarget:");
public static final int sel_subtype = sel_registerName("subtype");
public static final int sel_imageRectForPaper_1 = sel_registerName("imageRectForPaper:");
public static final int sel_initWithWindow_1rect_1 = sel_registerName("initWithWindow:rect:");
public static final int sel_enable = sel_registerName("enable");
public static final int sel_scanInteger_1 = sel_registerName("scanInteger:");
public static final int sel_initWithContentsOfURL_1encoding_1error_1 = sel_registerName("initWithContentsOfURL:encoding:error:");
public static final int sel_removeObjectIdenticalTo_1 = sel_registerName("removeObjectIdenticalTo:");
public static final int sel_createTexture_1fromView_1internalFormat_1 = sel_registerName("createTexture:fromView:internalFormat:");
public static final int sel_decimalNumberByRaisingToPower_1withBehavior_1 = sel_registerName("decimalNumberByRaisingToPower:withBehavior:");
public static final int sel_appendBezierPathWithArcWithCenter_1radius_1startAngle_1endAngle_1 = sel_registerName("appendBezierPathWithArcWithCenter:radius:startAngle:endAngle:");
public static final int sel_fontPanel_1 = sel_registerName("fontPanel:");
public static final int sel_predicateWithSubpredicates_1 = sel_registerName("predicateWithSubpredicates:");
public static final int sel_layoutGlyphsInLayoutManager_1startingAtGlyphIndex_1maxNumberOfLineFragments_1nextGlyphIndex_1 = sel_registerName("layoutGlyphsInLayoutManager:startingAtGlyphIndex:maxNumberOfLineFragments:nextGlyphIndex:");
public static final int sel_attributes = sel_registerName("attributes");
public static final int sel_EPSOperationWithView_1insideRect_1toData_1 = sel_registerName("EPSOperationWithView:insideRect:toData:");
public static final int sel_listOptions = sel_registerName("listOptions");
public static final int sel_windowWillLoad = sel_registerName("windowWillLoad");
public static final int sel_alwaysShowsDecimalSeparator = sel_registerName("alwaysShowsDecimalSeparator");
public static final int sel_replyToApplicationShouldTerminate_1 = sel_registerName("replyToApplicationShouldTerminate:");
public static final int sel_setThousandSeparator_1 = sel_registerName("setThousandSeparator:");
public static final int sel_insertObject_1atArrangedObjectIndexPath_1 = sel_registerName("insertObject:atArrangedObjectIndexPath:");
public static final int sel_cleanUpOperation = sel_registerName("cleanUpOperation");
public static final int sel_trackMouse_1inRect_1ofView_1untilMouseUp_1 = sel_registerName("trackMouse:inRect:ofView:untilMouseUp:");
public static final int sel_replaceLayoutManager_1 = sel_registerName("replaceLayoutManager:");
public static final int sel_isPartialStringValid_1proposedSelectedRange_1originalString_1originalSelectedRange_1errorDescription_1 = sel_registerName("isPartialStringValid:proposedSelectedRange:originalString:originalSelectedRange:errorDescription:");
public static final int sel_setNegativeFormat_1 = sel_registerName("setNegativeFormat:");
public static final int sel_copyFont_1 = sel_registerName("copyFont:");
public static final int sel_outlineView_1sortDescriptorsDidChange_1 = sel_registerName("outlineView:sortDescriptorsDidChange:");
public static final int sel_stringWithString_1 = sel_registerName("stringWithString:");
public static final int sel_valueWithUniqueID_1inPropertyWithKey_1 = sel_registerName("valueWithUniqueID:inPropertyWithKey:");
public static final int sel_setHighlightsBy_1 = sel_registerName("setHighlightsBy:");
public static final int sel_setContinuousSpellCheckingEnabled_1 = sel_registerName("setContinuousSpellCheckingEnabled:");
public static final int sel_isMouseCoalescingEnabled = sel_registerName("isMouseCoalescingEnabled");
public static final int sel_numberOfSelectedColumns = sel_registerName("numberOfSelectedColumns");
public static final int sel_spellServer_1findMisspelledWordInString_1language_1wordCount_1countOnly_1 = sel_registerName("spellServer:findMisspelledWordInString:language:wordCount:countOnly:");
public static final int sel_PMPageFormat = sel_registerName("PMPageFormat");
public static final int sel_insertText_1client_1 = sel_registerName("insertText:client:");
public static final int sel_numberWithFloat_1 = sel_registerName("numberWithFloat:");
public static final int sel_compositeToPoint_1fromRect_1operation_1 = sel_registerName("compositeToPoint:fromRect:operation:");
public static final int sel_numberOfPlanes = sel_registerName("numberOfPlanes");
public static final int sel_childrenKeyPath = sel_registerName("childrenKeyPath");
public static final int sel_countForObject_1 = sel_registerName("countForObject:");
public static final int sel_fontWithName_1matrix_1 = sel_registerName("fontWithName:matrix:");
public static final int sel_toolbarAllowedItemIdentifiers_1 = sel_registerName("toolbarAllowedItemIdentifiers:");
public static final int sel_makeDocumentWithContentsOfURL_1ofType_1 = sel_registerName("makeDocumentWithContentsOfURL:ofType:");
public static final int sel_initWithHTML_1options_1documentAttributes_1 = sel_registerName("initWithHTML:options:documentAttributes:");
public static final int sel_fileSystemRepresentation = sel_registerName("fileSystemRepresentation");
public static final int sel_viewAnimations = sel_registerName("viewAnimations");
public static final int sel_tabletProximity_1 = sel_registerName("tabletProximity:");
public static final int sel_replacementClassForClass_1 = sel_registerName("replacementClassForClass:");
public static final int sel_columnWidthForColumnContentWidth_1 = sel_registerName("columnWidthForColumnContentWidth:");
public static final int sel_undoMenuItemTitle = sel_registerName("undoMenuItemTitle");
public static final int sel_expressionForAggregate_1 = sel_registerName("expressionForAggregate:");
public static final int sel_useStoredAccessor = sel_registerName("useStoredAccessor");
public static final int sel_ensureAttributesAreFixedInRange_1 = sel_registerName("ensureAttributesAreFixedInRange:");
public static final int sel_stringForType_1 = sel_registerName("stringForType:");
public static final int sel_setLeaf_1 = sel_registerName("setLeaf:");
public static final int sel_URLFromPasteboard_1 = sel_registerName("URLFromPasteboard:");
public static final int sel_initWithURL_1byReference_1 = sel_registerName("initWithURL:byReference:");
public static final int sel_readToEndOfFileInBackgroundAndNotify = sel_registerName("readToEndOfFileInBackgroundAndNotify");
public static final int sel_application_1openFileWithoutUI_1 = sel_registerName("application:openFileWithoutUI:");
public static final int sel_performClick_1 = sel_registerName("performClick:");
public static final int sel_completes = sel_registerName("completes");
public static final int sel_setRulersVisible_1 = sel_registerName("setRulersVisible:");
public static final int sel_minimumSize = sel_registerName("minimumSize");
public static final int sel_setProperty_1forKey_1inRequest_1 = sel_registerName("setProperty:forKey:inRequest:");
public static final int sel_isCopyingOperation = sel_registerName("isCopyingOperation");
public static final int sel_allowsTickMarkValuesOnly = sel_registerName("allowsTickMarkValuesOnly");
public static final int sel_insertGlyphs_1length_1forStartingGlyphAtIndex_1characterIndex_1 = sel_registerName("insertGlyphs:length:forStartingGlyphAtIndex:characterIndex:");
public static final int sel_convertFont_1 = sel_registerName("convertFont:");
public static final int sel_setNegativePrefix_1 = sel_registerName("setNegativePrefix:");
public static final int sel_dispatch = sel_registerName("dispatch");
public static final int sel_makeNewConnection_1sender_1 = sel_registerName("makeNewConnection:sender:");
public static final int sel_writeToFile_1atomically_1encoding_1error_1 = sel_registerName("writeToFile:atomically:encoding:error:");
public static final int sel_isHiddenOrHasHiddenAncestor = sel_registerName("isHiddenOrHasHiddenAncestor");
public static final int sel_endEditingFor_1 = sel_registerName("endEditingFor:");
public static final int sel_acceptConnectionInBackgroundAndNotify = sel_registerName("acceptConnectionInBackgroundAndNotify");
public static final int sel_setValue_1forHTTPHeaderField_1 = sel_registerName("setValue:forHTTPHeaderField:");
public static final int sel_intersectSet_1 = sel_registerName("intersectSet:");
public static final int sel_tabView_1shouldSelectTabViewItem_1 = sel_registerName("tabView:shouldSelectTabViewItem:");
public static final int sel_mouseDragged_1 = sel_registerName("mouseDragged:");
public static final int sel_dataFromRange_1documentAttributes_1error_1 = sel_registerName("dataFromRange:documentAttributes:error:");
public static final int sel_sharedFrameworksPath = sel_registerName("sharedFrameworksPath");
public static final int sel_tableView_1writeRowsWithIndexes_1toPasteboard_1 = sel_registerName("tableView:writeRowsWithIndexes:toPasteboard:");
public static final int sel_setWindowFrameForAttachingToRect_1onScreen_1preferredEdge_1popUpSelectedItem_1 = sel_registerName("setWindowFrameForAttachingToRect:onScreen:preferredEdge:popUpSelectedItem:");
public static final int sel_valueAtIndex_1inPropertyWithKey_1 = sel_registerName("valueAtIndex:inPropertyWithKey:");
public static final int sel_setDisplaysLinkToolTips_1 = sel_registerName("setDisplaysLinkToolTips:");
public static final int sel_removeObserver_1forKeyPath_1 = sel_registerName("removeObserver:forKeyPath:");
public static final int sel_hasAlpha = sel_registerName("hasAlpha");
public static final int sel_scrollCellToVisibleAtRow_1column_1 = sel_registerName("scrollCellToVisibleAtRow:column:");
public static final int sel_activateIgnoringOtherApps_1 = sel_registerName("activateIgnoringOtherApps:");
public static final int sel_getArgumentTypeAtIndex_1 = sel_registerName("getArgumentTypeAtIndex:");
public static final int sel_textShouldEndEditing_1 = sel_registerName("textShouldEndEditing:");
public static final int sel_nextEventMatchingMask_1untilDate_1inMode_1dequeue_1 = sel_registerName("nextEventMatchingMask:untilDate:inMode:dequeue:");
public static final int sel_timeIntervalSince1970 = sel_registerName("timeIntervalSince1970");
public static final int sel_decimalNumberBySubtracting_1 = sel_registerName("decimalNumberBySubtracting:");
public static final int sel_sendBeforeDate_1 = sel_registerName("sendBeforeDate:");
public static final int sel_autohidesScrollers = sel_registerName("autohidesScrollers");
public static final int sel_controlPointBounds = sel_registerName("controlPointBounds");
public static final int sel_setMinimumSignificantDigits_1 = sel_registerName("setMinimumSignificantDigits:");
public static final int sel_setDestination_1allowOverwrite_1 = sel_registerName("setDestination:allowOverwrite:");
public static final int sel_setTransparent_1 = sel_registerName("setTransparent:");
public static final int sel_decodeArrayOfObjCType_1count_1at_1 = sel_registerName("decodeArrayOfObjCType:count:at:");
public static final int sel_isMiniaturized = sel_registerName("isMiniaturized");
public static final int sel_setAlignment_1 = sel_registerName("setAlignment:");
public static final int sel_setCornerRadius_1 = sel_registerName("setCornerRadius:");
public static final int sel_foregroundColor = sel_registerName("foregroundColor");
public static final int sel_lineFragmentUsedRectForGlyphAtIndex_1effectiveRange_1 = sel_registerName("lineFragmentUsedRectForGlyphAtIndex:effectiveRange:");
public static final int sel_attributedSubstringFromRange_1 = sel_registerName("attributedSubstringFromRange:");
public static final int sel_isSubsetOfSet_1 = sel_registerName("isSubsetOfSet:");
public static final int sel_iconForFileType_1 = sel_registerName("iconForFileType:");
public static final int sel_readFromURL_1ofType_1 = sel_registerName("readFromURL:ofType:");
public static final int sel_decodeBytesForKey_1returnedLength_1 = sel_registerName("decodeBytesForKey:returnedLength:");
public static final int sel_parser_1foundInternalEntityDeclarationWithName_1value_1 = sel_registerName("parser:foundInternalEntityDeclarationWithName:value:");
public static final int sel_commonPrefixWithString_1options_1 = sel_registerName("commonPrefixWithString:options:");
public static final int sel_tableView_1setObjectValue_1forTableColumn_1row_1 = sel_registerName("tableView:setObjectValue:forTableColumn:row:");
public static final int sel_fileWrapperRepresentationOfType_1 = sel_registerName("fileWrapperRepresentationOfType:");
public static final int sel_representedFilename = sel_registerName("representedFilename");
public static final int sel_eventWithCGEvent_1 = sel_registerName("eventWithCGEvent:");
public static final int sel_setFileURL_1 = sel_registerName("setFileURL:");
public static final int sel_loadWindow = sel_registerName("loadWindow");
public static final int sel_defaultLineJoinStyle = sel_registerName("defaultLineJoinStyle");
public static final int sel_backingLocation = sel_registerName("backingLocation");
public static final int sel_matrix = sel_registerName("matrix");
public static final int sel_isEqualToTimeZone_1 = sel_registerName("isEqualToTimeZone:");
public static final int sel_statistics = sel_registerName("statistics");
public static final int sel_launchAppWithBundleIdentifier_1options_1additionalEventParamDescriptor_1launchIdentifier_1 = sel_registerName("launchAppWithBundleIdentifier:options:additionalEventParamDescriptor:launchIdentifier:");
public static final int sel_isHorizontal = sel_registerName("isHorizontal");
public static final int sel_launchPath = sel_registerName("launchPath");
public static final int sel_setTextAlignment_1 = sel_registerName("setTextAlignment:");
public static final int sel_initWithBitmapDataPlanes_1pixelsWide_1pixelsHigh_1bitsPerSample_1samplesPerPixel_1hasAlpha_1isPlanar_1colorSpaceName_1bytesPerRow_1bitsPerPixel_1 = sel_registerName("initWithBitmapDataPlanes:pixelsWide:pixelsHigh:bitsPerSample:samplesPerPixel:hasAlpha:isPlanar:colorSpaceName:bytesPerRow:bitsPerPixel:");
public static final int sel_setPatternPhase_1 = sel_registerName("setPatternPhase:");
public static final int sel_mouseEntered_1withFrame_1inView_1 = sel_registerName("mouseEntered:withFrame:inView:");
public static final int sel_matchingFontDescriptorsWithMandatoryKeys_1 = sel_registerName("matchingFontDescriptorsWithMandatoryKeys:");
public static final int sel_objectDidEndEditing_1 = sel_registerName("objectDidEndEditing:");
public static final int sel_setMaximum_1 = sel_registerName("setMaximum:");
public static final int sel_initWithIndexes_1length_1 = sel_registerName("initWithIndexes:length:");
public static final int sel_tableView_1shouldShowCellExpansionForTableColumn_1row_1 = sel_registerName("tableView:shouldShowCellExpansionForTableColumn:row:");
public static final int sel_moveToPoint_1 = sel_registerName("moveToPoint:");
public static final int sel_setGridStyleMask_1 = sel_registerName("setGridStyleMask:");
public static final int sel_firstUnlaidGlyphIndex = sel_registerName("firstUnlaidGlyphIndex");
public static final int sel_isProxy = sel_registerName("isProxy");
public static final int sel_takeValue_1forKeyPath_1 = sel_registerName("takeValue:forKeyPath:");
public static final int sel_drawCellAtRow_1column_1 = sel_registerName("drawCellAtRow:column:");
public static final int sel_setRulerViewClass_1 = sel_registerName("setRulerViewClass:");
public static final int sel_objectByApplyingXSLT_1arguments_1error_1 = sel_registerName("objectByApplyingXSLT:arguments:error:");
public static final int sel_setArrowPosition_1 = sel_registerName("setArrowPosition:");
public static final int sel_setCharacterIndex_1forGlyphAtIndex_1 = sel_registerName("setCharacterIndex:forGlyphAtIndex:");
public static final int sel_willChangeValueForKey_1withSetMutation_1usingObjects_1 = sel_registerName("willChangeValueForKey:withSetMutation:usingObjects:");
public static final int sel_setVerticalRulerView_1 = sel_registerName("setVerticalRulerView:");
public static final int sel_suspendCurrentAppleEvent = sel_registerName("suspendCurrentAppleEvent");
public static final int sel_drawStatusBarBackgroundInRect_1withHighlight_1 = sel_registerName("drawStatusBarBackgroundInRect:withHighlight:");
public static final int sel_performClickWithFrame_1inView_1 = sel_registerName("performClickWithFrame:inView:");
public static final int sel_coveredCharacterSet = sel_registerName("coveredCharacterSet");
public static final int sel_browser_1numberOfRowsInColumn_1 = sel_registerName("browser:numberOfRowsInColumn:");
public static final int sel_isLike_1 = sel_registerName("isLike:");
public static final int sel_blackComponent = sel_registerName("blackComponent");
public static final int sel_appendBezierPathWithGlyph_1inFont_1 = sel_registerName("appendBezierPathWithGlyph:inFont:");
public static final int sel_validateMenuItem_1 = sel_registerName("validateMenuItem:");
public static final int sel_isEqualToIndexSet_1 = sel_registerName("isEqualToIndexSet:");
public static final int sel_setBezelStyle_1 = sel_registerName("setBezelStyle:");
public static final int sel_scaleUnitSquareToSize_1 = sel_registerName("scaleUnitSquareToSize:");
public static final int sel_setStartSubelementIndex_1 = sel_registerName("setStartSubelementIndex:");
public static final int sel_frameOfInsideOfColumn_1 = sel_registerName("frameOfInsideOfColumn:");
public static final int sel_setBlocksOtherRecognizers_1 = sel_registerName("setBlocksOtherRecognizers:");
public static final int sel_setMinSize_1 = sel_registerName("setMinSize:");
public static final int sel_setEndSubelementIndex_1 = sel_registerName("setEndSubelementIndex:");
public static final int sel_cStringLength = sel_registerName("cStringLength");
public static final int sel_writeWithBackupToFile_1ofType_1saveOperation_1 = sel_registerName("writeWithBackupToFile:ofType:saveOperation:");
public static final int sel_setDefaultButtonTitle_1 = sel_registerName("setDefaultButtonTitle:");
public static final int sel_setMinContentSize_1 = sel_registerName("setMinContentSize:");
public static final int sel_setFormattingDictionary_1 = sel_registerName("setFormattingDictionary:");
public static final int sel_boundingRectForFont = sel_registerName("boundingRectForFont");
public static final int sel_postsBoundsChangedNotifications = sel_registerName("postsBoundsChangedNotifications");
public static final int sel_setParagraphs_1 = sel_registerName("setParagraphs:");
public static final int sel_setShowsControlCharacters_1 = sel_registerName("setShowsControlCharacters:");
public static final int sel_writeSafelyToURL_1ofType_1forSaveOperation_1error_1 = sel_registerName("writeSafelyToURL:ofType:forSaveOperation:error:");
public static final int sel_controlLightHighlightColor = sel_registerName("controlLightHighlightColor");
public static final int sel_objectSpecifier = sel_registerName("objectSpecifier");
public static final int sel_dictionaryWithContentsOfURL_1 = sel_registerName("dictionaryWithContentsOfURL:");
public static final int sel_performSelector_1onThread_1withObject_1waitUntilDone_1modes_1 = sel_registerName("performSelector:onThread:withObject:waitUntilDone:modes:");
public static final int sel_setJobStyleHint_1 = sel_registerName("setJobStyleHint:");
public static final int sel_sortedArrayUsingFunction_1context_1 = sel_registerName("sortedArrayUsingFunction:context:");
public static final int sel_setBoundsRect_1forTextBlock_1glyphRange_1 = sel_registerName("setBoundsRect:forTextBlock:glyphRange:");
public static final int sel_hasShadow = sel_registerName("hasShadow");
public static final int sel_windowShouldClose_1 = sel_registerName("windowShouldClose:");
public static final int sel_defaultTokenizingCharacterSet = sel_registerName("defaultTokenizingCharacterSet");
public static final int sel_isRulerVisible = sel_registerName("isRulerVisible");
public static final int sel_setSubrowsKeyPath_1 = sel_registerName("setSubrowsKeyPath:");
public static final int sel_animationDelay = sel_registerName("animationDelay");
public static final int sel_selectAll_1 = sel_registerName("selectAll:");
public static final int sel_parser_1foundNotationDeclarationWithName_1publicID_1systemID_1 = sel_registerName("parser:foundNotationDeclarationWithName:publicID:systemID:");
public static final int sel_readSelectionFromPasteboard_1 = sel_registerName("readSelectionFromPasteboard:");
public static final int sel_validateAndReturnError_1 = sel_registerName("validateAndReturnError:");
public static final int sel_setScriptErrorOffendingObjectDescriptor_1 = sel_registerName("setScriptErrorOffendingObjectDescriptor:");
public static final int sel_makeKeyWindow = sel_registerName("makeKeyWindow");
public static final int sel_itemAtIndex_1 = sel_registerName("itemAtIndex:");
public static final int sel_objectAtIndex_1 = sel_registerName("objectAtIndex:");
public static final int sel_protectionSpace = sel_registerName("protectionSpace");
public static final int sel_getCString_1 = sel_registerName("getCString:");
public static final int sel_initSymbolicLinkWithDestination_1 = sel_registerName("initSymbolicLinkWithDestination:");
public static final int sel_daylightSavingTimeOffset = sel_registerName("daylightSavingTimeOffset");
public static final int sel_rangeOfTextList_1atIndex_1 = sel_registerName("rangeOfTextList:atIndex:");
public static final int sel_currentDirectory = sel_registerName("currentDirectory");
public static final int sel_windowControllerDidLoadNib_1 = sel_registerName("windowControllerDidLoadNib:");
public static final int sel_setGroupingSize_1 = sel_registerName("setGroupingSize:");
public static final int sel_subitems = sel_registerName("subitems");
public static final int sel_initWithFileWrapper_1 = sel_registerName("initWithFileWrapper:");
public static final int sel_documentVisibleRect = sel_registerName("documentVisibleRect");
public static final int sel_setCount_1 = sel_registerName("setCount:");
public static final int sel_setScriptErrorExpectedTypeDescriptor_1 = sel_registerName("setScriptErrorExpectedTypeDescriptor:");
public static final int sel_setReleasedWhenClosed_1 = sel_registerName("setReleasedWhenClosed:");
public static final int sel_imageUnfilteredTypes = sel_registerName("imageUnfilteredTypes");
public static final int sel_writeToFile_1options_1error_1 = sel_registerName("writeToFile:options:error:");
public static final int sel_controlContentFontOfSize_1 = sel_registerName("controlContentFontOfSize:");
public static final int sel_insertRow_1withCells_1 = sel_registerName("insertRow:withCells:");
public static final int sel_temporaryAttributesAtCharacterIndex_1effectiveRange_1 = sel_registerName("temporaryAttributesAtCharacterIndex:effectiveRange:");
public static final int sel_stepForward_1 = sel_registerName("stepForward:");
public static final int sel_convertScreenToBase_1 = sel_registerName("convertScreenToBase:");
public static final int sel_printerWithType_1 = sel_registerName("printerWithType:");
public static final int sel_setSliderType_1 = sel_registerName("setSliderType:");
public static final int sel_applicationShouldHandleReopen_1hasVisibleWindows_1 = sel_registerName("applicationShouldHandleReopen:hasVisibleWindows:");
public static final int sel_selectedTextAttributes = sel_registerName("selectedTextAttributes");
public static final int sel_setStandardError_1 = sel_registerName("setStandardError:");
public static final int sel_drawRect_1 = sel_registerName("drawRect:");
public static final int sel_URLs = sel_registerName("URLs");
public static final int sel_animationForKey_1 = sel_registerName("animationForKey:");
public static final int sel_setSubviews_1 = sel_registerName("setSubviews:");
public static final int sel_setString_1 = sel_registerName("setString:");
public static final int sel_openFile_1fromImage_1at_1inView_1 = sel_registerName("openFile:fromImage:at:inView:");
public static final int sel_draggedImage = sel_registerName("draggedImage");
public static final int sel_numberOfGlyphs = sel_registerName("numberOfGlyphs");
public static final int sel_itemAtRow_1 = sel_registerName("itemAtRow:");
public static final int sel_drawKnob = sel_registerName("drawKnob");
public static final int sel_imageRepsWithData_1 = sel_registerName("imageRepsWithData:");
public static final int sel_dragOperationForDraggingInfo_1type_1 = sel_registerName("dragOperationForDraggingInfo:type:");
public static final int sel_initWithRTF_1documentAttributes_1 = sel_registerName("initWithRTF:documentAttributes:");
public static final int sel_pathsForResourcesOfType_1inDirectory_1 = sel_registerName("pathsForResourcesOfType:inDirectory:");
public static final int sel_fontName = sel_registerName("fontName");
public static final int sel_layoutManagers = sel_registerName("layoutManagers");
public static final int sel_error = sel_registerName("error");
public static final int sel_parentWindow = sel_registerName("parentWindow");
public static final int sel_registerClass_1 = sel_registerName("registerClass:");
public static final int sel_hideOtherApplications = sel_registerName("hideOtherApplications");
public static final int sel_alphaComponent = sel_registerName("alphaComponent");
public static final int sel_setPrefersColorMatch_1 = sel_registerName("setPrefersColorMatch:");
public static final int sel_stopAnimation_1 = sel_registerName("stopAnimation:");
public static final int sel_glyphIndexForCharacterAtIndex_1 = sel_registerName("glyphIndexForCharacterAtIndex:");
public static final int sel_rulerView_1shouldAddMarker_1 = sel_registerName("rulerView:shouldAddMarker:");
public static final int sel_initWithFrame_1 = sel_registerName("initWithFrame:");
public static final int sel_init = sel_registerName("init");
public static final int sel_selectedColumnEnumerator = sel_registerName("selectedColumnEnumerator");
public static final int sel_viewWithTag_1 = sel_registerName("viewWithTag:");
public static final int sel_classForKeyedUnarchiver = sel_registerName("classForKeyedUnarchiver");
public static final int sel_addRow_1 = sel_registerName("addRow:");
public static final int sel_contextHelpForObject_1 = sel_registerName("contextHelpForObject:");
public static final int sel_server = sel_registerName("server");
public static final int sel_colorUsingColorSpaceName_1device_1 = sel_registerName("colorUsingColorSpaceName:device:");
public static final int sel_valueTransformerForName_1 = sel_registerName("valueTransformerForName:");
public static final int sel_soundUnfilteredFileTypes = sel_registerName("soundUnfilteredFileTypes");
public static final int sel_setSelectedTextAttributes_1 = sel_registerName("setSelectedTextAttributes:");
public static final int sel_setLeadingOffset_1 = sel_registerName("setLeadingOffset:");
public static final int sel_scrollToPoint_1 = sel_registerName("scrollToPoint:");
public static final int sel_lastPathComponent = sel_registerName("lastPathComponent");
public static final int sel_lossyCString = sel_registerName("lossyCString");
public static final int sel_registerServicesMenuSendTypes_1returnTypes_1 = sel_registerName("registerServicesMenuSendTypes:returnTypes:");
public static final int sel_keyDown_1 = sel_registerName("keyDown:");
public static final int sel_setWidthTracksTextView_1 = sel_registerName("setWidthTracksTextView:");
public static final int sel_incrementBy_1 = sel_registerName("incrementBy:");
public static final int sel_moveWordForward_1 = sel_registerName("moveWordForward:");
public static final int sel_dataWithContentsOfMappedFile_1 = sel_registerName("dataWithContentsOfMappedFile:");
public static final int sel_socket = sel_registerName("socket");
public static final int sel_EPSOperationWithView_1insideRect_1toData_1printInfo_1 = sel_registerName("EPSOperationWithView:insideRect:toData:printInfo:");
public static final int sel_width = sel_registerName("width");
public static final int sel_capabilityMask = sel_registerName("capabilityMask");
public static final int sel_setBezeled_1 = sel_registerName("setBezeled:");
public static final int sel_currentMode = sel_registerName("currentMode");
public static final int sel_sliderType = sel_registerName("sliderType");
public static final int sel_fileIsAppendOnly = sel_registerName("fileIsAppendOnly");
public static final int sel_isAutomaticLinkDetectionEnabled = sel_registerName("isAutomaticLinkDetectionEnabled");
public static final int sel_setBoundsOrigin_1 = sel_registerName("setBoundsOrigin:");
public static final int sel_selectionHighlightStyle = sel_registerName("selectionHighlightStyle");
public static final int sel_registerName_1 = sel_registerName("registerName:");
public static final int sel_moveWordRightAndModifySelection_1 = sel_registerName("moveWordRightAndModifySelection:");
public static final int sel_setCharacters_1 = sel_registerName("setCharacters:");
public static final int sel_setWordFieldStringValue_1 = sel_registerName("setWordFieldStringValue:");
public static final int sel_reverseObjectEnumerator = sel_registerName("reverseObjectEnumerator");
public static final int sel_encodeByrefObject_1 = sel_registerName("encodeByrefObject:");
public static final int sel_defaultDecimalNumberHandler = sel_registerName("defaultDecimalNumberHandler");
public static final int sel_isEntryAcceptable_1 = sel_registerName("isEntryAcceptable:");
public static final int sel_orderWindow_1relativeTo_1 = sel_registerName("orderWindow:relativeTo:");
public static final int sel_writablePasteboardTypes = sel_registerName("writablePasteboardTypes");
public static final int sel_addTrackingRect_1owner_1userData_1assumeInside_1 = sel_registerName("addTrackingRect:owner:userData:assumeInside:");
public static final int sel_setPathComponentCells_1 = sel_registerName("setPathComponentCells:");
public static final int sel_timeZoneWithName_1 = sel_registerName("timeZoneWithName:");
public static final int sel_setAutosaveTableColumns_1 = sel_registerName("setAutosaveTableColumns:");
public static final int sel_orPredicateWithSubpredicates_1 = sel_registerName("orPredicateWithSubpredicates:");
public static final int sel_isEqualToDictionary_1 = sel_registerName("isEqualToDictionary:");
public static final int sel_bottomMargin = sel_registerName("bottomMargin");
public static final int sel_initWithYear_1month_1day_1hour_1minute_1second_1timeZone_1 = sel_registerName("initWithYear:month:day:hour:minute:second:timeZone:");
public static final int sel_scrollColumnsLeftBy_1 = sel_registerName("scrollColumnsLeftBy:");
public static final int sel_initWithContentsOfURL_1error_1 = sel_registerName("initWithContentsOfURL:error:");
public static final int sel_setTabViewType_1 = sel_registerName("setTabViewType:");
public static final int sel_initWithFloat_1 = sel_registerName("initWithFloat:");
public static final int sel_attributedStringForObjectValue_1withDefaultAttributes_1 = sel_registerName("attributedStringForObjectValue:withDefaultAttributes:");
public static final int sel_sharedGlyphGenerator = sel_registerName("sharedGlyphGenerator");
public static final int sel_maximumRangeOfUnit_1 = sel_registerName("maximumRangeOfUnit:");
public static final int sel_docFormatFromRange_1documentAttributes_1 = sel_registerName("docFormatFromRange:documentAttributes:");
public static final int sel_initWithBitmapImageRep_1 = sel_registerName("initWithBitmapImageRep:");
public static final int sel_mnemonic = sel_registerName("mnemonic");
public static final int sel_prefersColorMatch = sel_registerName("prefersColorMatch");
public static final int sel_fileSystemAttributesAtPath_1 = sel_registerName("fileSystemAttributesAtPath:");
public static final int sel_rotateByRadians_1 = sel_registerName("rotateByRadians:");
public static final int sel_createConversationForConnection_1 = sel_registerName("createConversationForConnection:");
public static final int sel_setWindow_1 = sel_registerName("setWindow:");
public static final int sel_addFontDescriptors_1toCollection_1 = sel_registerName("addFontDescriptors:toCollection:");
public static final int sel_setMark_1 = sel_registerName("setMark:");
public static final int sel_terminate = sel_registerName("terminate");
public static final int sel_setTickMarkPosition_1 = sel_registerName("setTickMarkPosition:");
public static final int sel_setIgnoresMouseEvents_1 = sel_registerName("setIgnoresMouseEvents:");
public static final int sel_pointerArrayWithStrongObjects = sel_registerName("pointerArrayWithStrongObjects");
public static final int sel_intersectsHashTable_1 = sel_registerName("intersectsHashTable:");
public static final int sel_initWithTransform_1 = sel_registerName("initWithTransform:");
public static final int sel_deviceRGBColorSpace = sel_registerName("deviceRGBColorSpace");
public static final int sel_currentDiskUsage = sel_registerName("currentDiskUsage");
public static final int sel_writeToFile_1ofType_1 = sel_registerName("writeToFile:ofType:");
public static final int sel_unionSet_1 = sel_registerName("unionSet:");
public static final int sel_bitmapFormat = sel_registerName("bitmapFormat");
public static final int sel_moveItemAtPath_1toPath_1error_1 = sel_registerName("moveItemAtPath:toPath:error:");
public static final int sel_tableView = sel_registerName("tableView");
public static final int sel_performSelectorOnMainThread_1withObject_1waitUntilDone_1modes_1 = sel_registerName("performSelectorOnMainThread:withObject:waitUntilDone:modes:");
public static final int sel_initAndTestWithTests_1 = sel_registerName("initAndTestWithTests:");
public static final int sel_setVerticalMotionCanBeginDrag_1 = sel_registerName("setVerticalMotionCanBeginDrag:");
public static final int sel_documentClassNames = sel_registerName("documentClassNames");
public static final int sel_setShadow_1 = sel_registerName("setShadow:");
public static final int sel_beginLineWithGlyphAtIndex_1 = sel_registerName("beginLineWithGlyphAtIndex:");
public static final int sel_predicateWithSubstitutionVariables_1 = sel_registerName("predicateWithSubstitutionVariables:");
public static final int sel_EPSOperationWithView_1insideRect_1toPath_1printInfo_1 = sel_registerName("EPSOperationWithView:insideRect:toPath:printInfo:");
public static final int sel_startSubelementIndex = sel_registerName("startSubelementIndex");
public static final int sel_sleepUntilDate_1 = sel_registerName("sleepUntilDate:");
public static final int sel_menuForEvent_1 = sel_registerName("menuForEvent:");
public static final int sel_disabledControlTextColor = sel_registerName("disabledControlTextColor");
public static final int sel_addRegularFileWithContents_1preferredFilename_1 = sel_registerName("addRegularFileWithContents:preferredFilename:");
public static final int sel_setTakesTitleFromPreviousColumn_1 = sel_registerName("setTakesTitleFromPreviousColumn:");
public static final int sel_removeSelectionIndexes_1 = sel_registerName("removeSelectionIndexes:");
public static final int sel_resizedColumn = sel_registerName("resizedColumn");
public static final int sel_host = sel_registerName("host");
public static final int sel_setDefaultAttachmentScaling_1 = sel_registerName("setDefaultAttachmentScaling:");
public static final int sel_boundingRectWithSize_1options_1 = sel_registerName("boundingRectWithSize:options:");
public static final int sel_magentaColor = sel_registerName("magentaColor");
public static final int sel_performDefaultImplementation = sel_registerName("performDefaultImplementation");
public static final int sel_getPeriodicDelay_1interval_1 = sel_registerName("getPeriodicDelay:interval:");
public static final int sel_RTFFromRange_1 = sel_registerName("RTFFromRange:");
public static final int sel_setStringValue_1 = sel_registerName("setStringValue:");
public static final int sel_setPaletteLabel_1 = sel_registerName("setPaletteLabel:");
public static final int sel_years_1months_1days_1hours_1minutes_1seconds_1sinceDate_1 = sel_registerName("years:months:days:hours:minutes:seconds:sinceDate:");
public static final int sel_initWithFormat_1arguments_1 = sel_registerName("initWithFormat:arguments:");
public static final int sel_firstUnlaidCharacterIndex = sel_registerName("firstUnlaidCharacterIndex");
public static final int sel_panelSelectionDidChange_1 = sel_registerName("panelSelectionDidChange:");
public static final int sel_typesFilterableTo_1 = sel_registerName("typesFilterableTo:");
public static final int sel_selectPreviousTabViewItem_1 = sel_registerName("selectPreviousTabViewItem:");
public static final int sel_URLProtocol_1didReceiveResponse_1cacheStoragePolicy_1 = sel_registerName("URLProtocol:didReceiveResponse:cacheStoragePolicy:");
public static final int sel_loadView = sel_registerName("loadView");
public static final int sel_setPositiveSuffix_1 = sel_registerName("setPositiveSuffix:");
public static final int sel_setSizeMode_1 = sel_registerName("setSizeMode:");
public static final int sel_addValue_1forHTTPHeaderField_1 = sel_registerName("addValue:forHTTPHeaderField:");
public static final int sel_replacementObjectForPortCoder_1 = sel_registerName("replacementObjectForPortCoder:");
public static final int sel_cycleToNextInputLanguage_1 = sel_registerName("cycleToNextInputLanguage:");
public static final int sel_setContentMinSize_1 = sel_registerName("setContentMinSize:");
public static final int sel_convertWeight_1ofFont_1 = sel_registerName("convertWeight:ofFont:");
public static final int sel_code = sel_registerName("code");
public static final int sel_TIFFRepresentationUsingCompression_1factor_1 = sel_registerName("TIFFRepresentationUsingCompression:factor:");
public static final int sel_setSelector_1 = sel_registerName("setSelector:");
public static final int sel_URLHandleResourceDidCancelLoading_1 = sel_registerName("URLHandleResourceDidCancelLoading:");
public static final int sel_setTag_1forSegment_1 = sel_registerName("setTag:forSegment:");
public static final int sel_viewFrameChanged_1 = sel_registerName("viewFrameChanged:");
public static final int sel_attachmentCell = sel_registerName("attachmentCell");
public static final int sel_removeStatusItem_1 = sel_registerName("removeStatusItem:");
public static final int sel_pathForAuxiliaryExecutable_1 = sel_registerName("pathForAuxiliaryExecutable:");
public static final int sel_fileURL = sel_registerName("fileURL");
public static final int sel_drawerShouldOpen_1 = sel_registerName("drawerShouldOpen:");
public static final int sel_initForWritingWithMutableData_1 = sel_registerName("initForWritingWithMutableData:");
public static final int sel_content = sel_registerName("content");
public static final int sel_addSubview_1 = sel_registerName("addSubview:");
public static final int sel_stringByReplacingOccurrencesOfString_1withString_1 = sel_registerName("stringByReplacingOccurrencesOfString:withString:");
public static final int sel_stringWithFileSystemRepresentation_1length_1 = sel_registerName("stringWithFileSystemRepresentation:length:");
public static final int sel_isVerticallyCentered = sel_registerName("isVerticallyCentered");
public static final int sel_setVerticallyCentered_1 = sel_registerName("setVerticallyCentered:");
public static final int sel_selectPrevious_1 = sel_registerName("selectPrevious:");
public static final int sel_addTemporaryAttributes_1forCharacterRange_1 = sel_registerName("addTemporaryAttributes:forCharacterRange:");
public static final int sel_tabState = sel_registerName("tabState");
public static final int sel_defaultQueue = sel_registerName("defaultQueue");
public static final int sel_showsControlCharacters = sel_registerName("showsControlCharacters");
public static final int sel_indexOfObject_1 = sel_registerName("indexOfObject:");
public static final int sel_shadow = sel_registerName("shadow");
public static final int sel_fontMenu_1 = sel_registerName("fontMenu:");
public static final int sel_movePath_1toPath_1handler_1 = sel_registerName("movePath:toPath:handler:");
public static final int sel_setDictionary_1 = sel_registerName("setDictionary:");
public static final int sel_verticalLineScroll = sel_registerName("verticalLineScroll");
public static final int sel_showsAlpha = sel_registerName("showsAlpha");
public static final int sel_removeObserver_1 = sel_registerName("removeObserver:");
public static final int sel_isFieldEditor = sel_registerName("isFieldEditor");
public static final int sel_fileHandleForWriting = sel_registerName("fileHandleForWriting");
public static final int sel_contentsAtPath_1 = sel_registerName("contentsAtPath:");
public static final int sel_writeProperty_1forKey_1 = sel_registerName("writeProperty:forKey:");
public static final int sel_drawWithRect_1options_1attributes_1 = sel_registerName("drawWithRect:options:attributes:");
public static final int sel_initWithName_1 = sel_registerName("initWithName:");
public static final int sel_getFileSystemInfoForPath_1isRemovable_1isWritable_1isUnmountable_1description_1type_1 = sel_registerName("getFileSystemInfoForPath:isRemovable:isWritable:isUnmountable:description:type:");
public static final int sel_setOpenGLContext_1 = sel_registerName("setOpenGLContext:");
public static final int sel_hasSubmenu = sel_registerName("hasSubmenu");
public static final int sel_rangeOfTextTable_1atIndex_1 = sel_registerName("rangeOfTextTable:atIndex:");
public static final int sel_connection_1willCacheResponse_1 = sel_registerName("connection:willCacheResponse:");
public static final int sel_automaticallyRearrangesObjects = sel_registerName("automaticallyRearrangesObjects");
public static final int sel_registerCommandDescription_1 = sel_registerName("registerCommandDescription:");
public static final int sel_indexOfSelectedItem = sel_registerName("indexOfSelectedItem");
public static final int sel_underline_1 = sel_registerName("underline:");
public static final int sel_beginModalSessionForWindow_1relativeToWindow_1 = sel_registerName("beginModalSessionForWindow:relativeToWindow:");
public static final int sel_initWithData_1options_1documentAttributes_1error_1 = sel_registerName("initWithData:options:documentAttributes:error:");
public static final int sel_revert_1 = sel_registerName("revert:");
public static final int sel_displayableSubpredicatesOfPredicate_1 = sel_registerName("displayableSubpredicatesOfPredicate:");
public static final int sel_dataWithData_1 = sel_registerName("dataWithData:");
public static final int sel_scaleXBy_1yBy_1 = sel_registerName("scaleXBy:yBy:");
public static final int sel_decodeBoolForKey_1 = sel_registerName("decodeBoolForKey:");
public static final int sel_itemTitles = sel_registerName("itemTitles");
public static final int sel_removeFontDescriptor_1fromCollection_1 = sel_registerName("removeFontDescriptor:fromCollection:");
public static final int sel_isContinuousSpellCheckingEnabled = sel_registerName("isContinuousSpellCheckingEnabled");
public static final int sel_paragraphSpacingBeforeGlyphAtIndex_1withProposedLineFragmentRect_1 = sel_registerName("paragraphSpacingBeforeGlyphAtIndex:withProposedLineFragmentRect:");
public static final int sel_ignoreSpelling_1 = sel_registerName("ignoreSpelling:");
public static final int sel_crosshairCursor = sel_registerName("crosshairCursor");
public static final int sel_setSelected_1 = sel_registerName("setSelected:");
public static final int sel_RTFDFromRange_1 = sel_registerName("RTFDFromRange:");
public static final int sel_setCanSelectHiddenExtension_1 = sel_registerName("setCanSelectHiddenExtension:");
public static final int sel_setNestingMode_1 = sel_registerName("setNestingMode:");
public static final int sel_addItemsWithObjectValues_1 = sel_registerName("addItemsWithObjectValues:");
public static final int sel_setContentFilters_1 = sel_registerName("setContentFilters:");
public static final int sel_setAutorepeat_1 = sel_registerName("setAutorepeat:");
public static final int sel_resizeWithOldSuperviewSize_1 = sel_registerName("resizeWithOldSuperviewSize:");
public static final int sel_areCursorRectsEnabled = sel_registerName("areCursorRectsEnabled");
public static final int sel_browser_1selectCellWithString_1inColumn_1 = sel_registerName("browser:selectCellWithString:inColumn:");
public static final int sel_setLastColumn_1 = sel_registerName("setLastColumn:");
public static final int sel_isContextHelpModeActive = sel_registerName("isContextHelpModeActive");
public static final int sel_setTitleColor_1 = sel_registerName("setTitleColor:");
public static final int sel_initWithBytes_1length_1 = sel_registerName("initWithBytes:length:");
public static final int sel_animation_1valueForProgress_1 = sel_registerName("animation:valueForProgress:");
public static final int sel_fillColor = sel_registerName("fillColor");
public static final int sel_completionsForPartialWordRange_1inString_1language_1inSpellDocumentWithTag_1 = sel_registerName("completionsForPartialWordRange:inString:language:inSpellDocumentWithTag:");
public static final int sel_typeForContentsOfURL_1error_1 = sel_registerName("typeForContentsOfURL:error:");
public static final int sel_setShowPanels_1 = sel_registerName("setShowPanels:");
public static final int sel_outlineView_1dataCellForTableColumn_1item_1 = sel_registerName("outlineView:dataCellForTableColumn:item:");
public static final int sel_setLineJoinStyle_1 = sel_registerName("setLineJoinStyle:");
public static final int sel_cancelPerformSelectorsWithTarget_1 = sel_registerName("cancelPerformSelectorsWithTarget:");
public static final int sel_nextDaylightSavingTimeTransition = sel_registerName("nextDaylightSavingTimeTransition");
public static final int sel_setEndSubelementIdentifier_1 = sel_registerName("setEndSubelementIdentifier:");
public static final int sel_channelMapping = sel_registerName("channelMapping");
public static final int sel_setTitle_1ofColumn_1 = sel_registerName("setTitle:ofColumn:");
public static final int sel_setHeaderToolTip_1 = sel_registerName("setHeaderToolTip:");
public static final int sel_initWithChar_1 = sel_registerName("initWithChar:");
public static final int sel_shouldReportNamespacePrefixes = sel_registerName("shouldReportNamespacePrefixes");
public static final int sel_decomposedStringWithCompatibilityMapping = sel_registerName("decomposedStringWithCompatibilityMapping");
public static final int sel_undoActionName = sel_registerName("undoActionName");
public static final int sel_attachColorList_1 = sel_registerName("attachColorList:");
public static final int sel_cancelPreviousPerformRequestsWithTarget_1 = sel_registerName("cancelPreviousPerformRequestsWithTarget:");
public static final int sel_addToolTipRect_1owner_1userData_1 = sel_registerName("addToolTipRect:owner:userData:");
public static final int sel_isOptionalArgumentWithName_1 = sel_registerName("isOptionalArgumentWithName:");
public static final int sel_fileHandleForReading = sel_registerName("fileHandleForReading");
public static final int sel_removeConnection_1fromRunLoop_1forMode_1 = sel_registerName("removeConnection:fromRunLoop:forMode:");
public static final int sel_controlTextDidBeginEditing_1 = sel_registerName("controlTextDidBeginEditing:");
public static final int sel_closePath = sel_registerName("closePath");
public static final int sel_isPlaying = sel_registerName("isPlaying");
public static final int sel_matrixClass = sel_registerName("matrixClass");
public static final int sel_doCommandBySelector_1client_1 = sel_registerName("doCommandBySelector:client:");
public static final int sel_appendBytes_1length_1 = sel_registerName("appendBytes:length:");
public static final int sel_lightGrayColor = sel_registerName("lightGrayColor");
public static final int sel_menuRepresentation = sel_registerName("menuRepresentation");
public static final int sel_dateWithString_1calendarFormat_1 = sel_registerName("dateWithString:calendarFormat:");
public static final int sel_decodeClassName_1asClassName_1 = sel_registerName("decodeClassName:asClassName:");
public static final int sel_deleteToBeginningOfParagraph_1 = sel_registerName("deleteToBeginningOfParagraph:");
public static final int sel_runModalForDirectory_1file_1 = sel_registerName("runModalForDirectory:file:");
public static final int sel_inverseForRelationshipKey_1 = sel_registerName("inverseForRelationshipKey:");
public static final int sel_cancelLoadInBackground = sel_registerName("cancelLoadInBackground");
public static final int sel_setLeftMargin_1 = sel_registerName("setLeftMargin:");
public static final int sel_tabStopType = sel_registerName("tabStopType");
public static final int sel_replaceCharactersInRange_1withRTF_1 = sel_registerName("replaceCharactersInRange:withRTF:");
public static final int sel_drawInRect_1fromRect_1operation_1fraction_1 = sel_registerName("drawInRect:fromRect:operation:fraction:");
public static final int sel_sound = sel_registerName("sound");
public static final int sel_localizedRecoverySuggestion = sel_registerName("localizedRecoverySuggestion");
public static final int sel_getInputStream_1outputStream_1 = sel_registerName("getInputStream:outputStream:");
public static final int sel_defaultType = sel_registerName("defaultType");
public static final int sel_sharedFontPanel = sel_registerName("sharedFontPanel");
public static final int sel_fixParagraphStyleAttributeInRange_1 = sel_registerName("fixParagraphStyleAttributeInRange:");
public static final int sel_textColor = sel_registerName("textColor");
public static final int sel_noteFileSystemChanged = sel_registerName("noteFileSystemChanged");
public static final int sel_setObject_1forKey_1 = sel_registerName("setObject:forKey:");
public static final int sel_drawAtPoint_1 = sel_registerName("drawAtPoint:");
public static final int sel_tableView_1shouldSelectTableColumn_1 = sel_registerName("tableView:shouldSelectTableColumn:");
public static final int sel_deleteWordBackward_1 = sel_registerName("deleteWordBackward:");
public static final int sel_pipe = sel_registerName("pipe");
public static final int sel_resetStandardUserDefaults = sel_registerName("resetStandardUserDefaults");
public static final int sel_orderFrontSpacingPanel_1 = sel_registerName("orderFrontSpacingPanel:");
public static final int sel_setUsesFontPanel_1 = sel_registerName("setUsesFontPanel:");
public static final int sel_saveToURL_1ofType_1forSaveOperation_1delegate_1didSaveSelector_1contextInfo_1 = sel_registerName("saveToURL:ofType:forSaveOperation:delegate:didSaveSelector:contextInfo:");
public static final int sel_linkPath_1toPath_1handler_1 = sel_registerName("linkPath:toPath:handler:");
public static final int sel_addTimeInterval_1 = sel_registerName("addTimeInterval:");
public static final int sel_formattingDictionary = sel_registerName("formattingDictionary");
public static final int sel_ignoresMultiClick = sel_registerName("ignoresMultiClick");
public static final int sel_encodeValuesOfObjCTypes_1 = sel_registerName("encodeValuesOfObjCTypes:");
public static final int sel_indexAtPosition_1 = sel_registerName("indexAtPosition:");
public static final int sel_autoresizesSubviews = sel_registerName("autoresizesSubviews");
public static final int sel_takesTitleFromPreviousColumn = sel_registerName("takesTitleFromPreviousColumn");
public static final int sel_titlePosition = sel_registerName("titlePosition");
public static final int sel_currentAppleEvent = sel_registerName("currentAppleEvent");
public static final int sel_valueForDimension_1 = sel_registerName("valueForDimension:");
public static final int sel_printDocumentWithSettings_1showPrintPanel_1delegate_1didPrintSelector_1contextInfo_1 = sel_registerName("printDocumentWithSettings:showPrintPanel:delegate:didPrintSelector:contextInfo:");
public static final int sel_isZoomable = sel_registerName("isZoomable");
public static final int sel_setNeedsDisplay = sel_registerName("setNeedsDisplay");
public static final int sel_initWithColors_1 = sel_registerName("initWithColors:");
public static final int sel_isSubclassOfClass_1 = sel_registerName("isSubclassOfClass:");
public static final int sel_adobeRGB1998ColorSpace = sel_registerName("adobeRGB1998ColorSpace");
public static final int sel_textView_1willChangeSelectionFromCharacterRange_1toCharacterRange_1 = sel_registerName("textView:willChangeSelectionFromCharacterRange:toCharacterRange:");
public static final int sel_useAllLigatures_1 = sel_registerName("useAllLigatures:");
public static final int sel_setFrameUsingName_1force_1 = sel_registerName("setFrameUsingName:force:");
public static final int sel_percentSymbol = sel_registerName("percentSymbol");
public static final int sel_addRepresentations_1 = sel_registerName("addRepresentations:");
public static final int sel_writeEPSInsideRect_1toPasteboard_1 = sel_registerName("writeEPSInsideRect:toPasteboard:");
public static final int sel_systemFontSize = sel_registerName("systemFontSize");
public static final int sel_canRemoveAllRows = sel_registerName("canRemoveAllRows");
public static final int sel_endLineWithGlyphRange_1 = sel_registerName("endLineWithGlyphRange:");
public static final int sel_maxItemSize = sel_registerName("maxItemSize");
public static final int sel_setImageScaling_1forSegment_1 = sel_registerName("setImageScaling:forSegment:");
public static final int sel_reloadDefaultFontFamilies = sel_registerName("reloadDefaultFontFamilies");
public static final int sel_removeRow_1 = sel_registerName("removeRow:");
public static final int sel_contentSize = sel_registerName("contentSize");
public static final int sel_setValueTransformer_1forName_1 = sel_registerName("setValueTransformer:forName:");
public static final int sel_defaultCStringEncoding = sel_registerName("defaultCStringEncoding");
public static final int sel_setMaxNumberOfRows_1 = sel_registerName("setMaxNumberOfRows:");
public static final int sel_continueWithoutCredentialForAuthenticationChallenge_1 = sel_registerName("continueWithoutCredentialForAuthenticationChallenge:");
public static final int sel_encodeArrayOfObjCType_1count_1at_1 = sel_registerName("encodeArrayOfObjCType:count:at:");
public static final int sel_tabStops = sel_registerName("tabStops");
public static final int sel_altIncrementValue = sel_registerName("altIncrementValue");
public static final int sel_removeAttribute_1range_1 = sel_registerName("removeAttribute:range:");
public static final int sel_rightExpressionAttributeType = sel_registerName("rightExpressionAttributeType");
public static final int sel_setAutoresizesAllColumnsToFit_1 = sel_registerName("setAutoresizesAllColumnsToFit:");
public static final int sel_removeAllToolTips = sel_registerName("removeAllToolTips");
public static final int sel_setNotANumberSymbol_1 = sel_registerName("setNotANumberSymbol:");
public static final int sel_setMinWidth_1 = sel_registerName("setMinWidth:");
public static final int sel_setDefaultTimeZone_1 = sel_registerName("setDefaultTimeZone:");
public static final int sel_setTabStops_1 = sel_registerName("setTabStops:");
public static final int sel_textView_1draggedCell_1inRect_1event_1 = sel_registerName("textView:draggedCell:inRect:event:");
public static final int sel_PDFOperationWithView_1insideRect_1toData_1 = sel_registerName("PDFOperationWithView:insideRect:toData:");
public static final int sel_outlineView_1selectionIndexesForProposedSelection_1 = sel_registerName("outlineView:selectionIndexesForProposedSelection:");
public static final int sel_initWithContentsOfURL_1 = sel_registerName("initWithContentsOfURL:");
public static final int sel_setBidiProcessingEnabled_1 = sel_registerName("setBidiProcessingEnabled:");
public static final int sel_selectToMark_1 = sel_registerName("selectToMark:");
public static final int sel_newlineCharacterSet = sel_registerName("newlineCharacterSet");
public static final int sel_accessibilitySetOverrideValue_1forAttribute_1 = sel_registerName("accessibilitySetOverrideValue:forAttribute:");
public static final int sel_setPostsFrameChangedNotifications_1 = sel_registerName("setPostsFrameChangedNotifications:");
public static final int sel_cellPrototype = sel_registerName("cellPrototype");
public static final int sel_unmarkText = sel_registerName("unmarkText");
public static final int sel_displayValuesKeyPath = sel_registerName("displayValuesKeyPath");
public static final int sel_orderFrontStylesPanel_1 = sel_registerName("orderFrontStylesPanel:");
public static final int sel_getBuffer_1length_1 = sel_registerName("getBuffer:length:");
public static final int sel_calcDrawInfo_1 = sel_registerName("calcDrawInfo:");
public static final int sel_initWithUTF8String_1 = sel_registerName("initWithUTF8String:");
public static final int sel_deselectAllCells = sel_registerName("deselectAllCells");
public static final int sel_checkGrammarOfString_1startingAt_1language_1wrap_1inSpellDocumentWithTag_1details_1 = sel_registerName("checkGrammarOfString:startingAt:language:wrap:inSpellDocumentWithTag:details:");
public static final int sel_poolCountHighWaterResolution = sel_registerName("poolCountHighWaterResolution");
public static final int sel_canInitWithData_1 = sel_registerName("canInitWithData:");
public static final int sel_setHasVerticalScroller_1 = sel_registerName("setHasVerticalScroller:");
public static final int sel_flushHostCache = sel_registerName("flushHostCache");
public static final int sel_toolbarDefaultItemIdentifiers_1 = sel_registerName("toolbarDefaultItemIdentifiers:");
public static final int sel_setSearchButtonCell_1 = sel_registerName("setSearchButtonCell:");
public static final int sel_defaultButtonCell = sel_registerName("defaultButtonCell");
public static final int sel_sizeLastColumnToFit = sel_registerName("sizeLastColumnToFit");
public static final int sel_addColumn = sel_registerName("addColumn");
public static final int sel_failureResponse = sel_registerName("failureResponse");
public static final int sel_insertTabIgnoringFieldEditor_1 = sel_registerName("insertTabIgnoringFieldEditor:");
public static final int sel_locationForGlyphAtIndex_1 = sel_registerName("locationForGlyphAtIndex:");
public static final int sel_insertContainerBreak_1 = sel_registerName("insertContainerBreak:");
public static final int sel_setAutosizesCells_1 = sel_registerName("setAutosizesCells:");
public static final int sel_isEditable = sel_registerName("isEditable");
public static final int sel_path = sel_registerName("path");
public static final int sel_setStringValue_1resolvingEntities_1 = sel_registerName("setStringValue:resolvingEntities:");
public static final int sel_readFileContentsType_1toFile_1 = sel_registerName("readFileContentsType:toFile:");
public static final int sel_fileExtensionHidden = sel_registerName("fileExtensionHidden");
public static final int sel_setTextureImageToPixelBuffer_1colorBuffer_1 = sel_registerName("setTextureImageToPixelBuffer:colorBuffer:");
public static final int sel_setFilename_1 = sel_registerName("setFilename:");
public static final int sel_callStackReturnAddresses = sel_registerName("callStackReturnAddresses");
public static final int sel_blocksOtherRecognizers = sel_registerName("blocksOtherRecognizers");
public static final int sel_pixelBuffer = sel_registerName("pixelBuffer");
public static final int sel_initWithStartingColor_1endingColor_1 = sel_registerName("initWithStartingColor:endingColor:");
public static final int sel_indexOfObjectIdenticalTo_1inRange_1 = sel_registerName("indexOfObjectIdenticalTo:inRange:");
public static final int sel_duration = sel_registerName("duration");
public static final int sel_matchForPredicate_1 = sel_registerName("matchForPredicate:");
public static final int sel_windowDidMiniaturize_1 = sel_registerName("windowDidMiniaturize:");
public static final int sel_drawWithFrame_1inView_1characterIndex_1layoutManager_1 = sel_registerName("drawWithFrame:inView:characterIndex:layoutManager:");
public static final int sel_setTwoDigitStartDate_1 = sel_registerName("setTwoDigitStartDate:");
public static final int sel_selectTextAtRow_1column_1 = sel_registerName("selectTextAtRow:column:");
public static final int sel_splitView_1shouldHideDividerAtIndex_1 = sel_registerName("splitView:shouldHideDividerAtIndex:");
public static final int sel_isExcludedFromWindowsMenu = sel_registerName("isExcludedFromWindowsMenu");
public static final int sel_earlierDate_1 = sel_registerName("earlierDate:");
public static final int sel_initWithLeftExpressions_1rightExpressionAttributeType_1modifier_1operators_1options_1 = sel_registerName("initWithLeftExpressions:rightExpressionAttributeType:modifier:operators:options:");
public static final int sel_minItemSize = sel_registerName("minItemSize");
public static final int sel_setSearchMenuTemplate_1 = sel_registerName("setSearchMenuTemplate:");
public static final int sel_rightMouseUp_1 = sel_registerName("rightMouseUp:");
public static final int sel_stopSpeaking_1 = sel_registerName("stopSpeaking:");
public static final int sel_getObjectValue_1forString_1errorDescription_1 = sel_registerName("getObjectValue:forString:errorDescription:");
public static final int sel_unarchiver_1didDecodeObject_1 = sel_registerName("unarchiver:didDecodeObject:");
public static final int sel_endSpecifier = sel_registerName("endSpecifier");
public static final int sel_ascending = sel_registerName("ascending");
public static final int sel_sharedCoercionHandler = sel_registerName("sharedCoercionHandler");
public static final int sel_textAttributesForPositiveInfinity = sel_registerName("textAttributesForPositiveInfinity");
public static final int sel_isEqualToData_1 = sel_registerName("isEqualToData:");
public static final int sel_setHighlightMode_1 = sel_registerName("setHighlightMode:");
public static final int sel_valueWithNonretainedObject_1 = sel_registerName("valueWithNonretainedObject:");
public static final int sel_textAttributesForNotANumber = sel_registerName("textAttributesForNotANumber");
public static final int sel_getCFRunLoop = sel_registerName("getCFRunLoop");
public static final int sel_invalidateGlyphsForCharacterRange_1changeInLength_1actualCharacterRange_1 = sel_registerName("invalidateGlyphsForCharacterRange:changeInLength:actualCharacterRange:");
public static final int sel_cachedResponse = sel_registerName("cachedResponse");
public static final int sel_containerIsRangeContainerObject = sel_registerName("containerIsRangeContainerObject");
public static final int sel_setLanguage_1 = sel_registerName("setLanguage:");
public static final int sel_loadNibFile_1externalNameTable_1withZone_1 = sel_registerName("loadNibFile:externalNameTable:withZone:");
public static final int sel_offsetInFile = sel_registerName("offsetInFile");
public static final int sel_initWithRulerView_1markerLocation_1image_1imageOrigin_1 = sel_registerName("initWithRulerView:markerLocation:image:imageOrigin:");
public static final int sel_commandDescriptionWithAppleEventClass_1andAppleEventCode_1 = sel_registerName("commandDescriptionWithAppleEventClass:andAppleEventCode:");
public static final int sel_detachDrawingThread_1toTarget_1withObject_1 = sel_registerName("detachDrawingThread:toTarget:withObject:");
public static final int sel_outlineView_1shouldShowCellExpansionForTableColumn_1item_1 = sel_registerName("outlineView:shouldShowCellExpansionForTableColumn:item:");
public static final int sel_catalogNameComponent = sel_registerName("catalogNameComponent");
public static final int sel_monthSymbols = sel_registerName("monthSymbols");
public static final int sel_invalidateShadow = sel_registerName("invalidateShadow");
public static final int sel_waitUntilDate_1 = sel_registerName("waitUntilDate:");
public static final int sel_languageLevel = sel_registerName("languageLevel");
public static final int sel_XMLData = sel_registerName("XMLData");
public static final int sel_textView_1shouldChangeTextInRanges_1replacementStrings_1 = sel_registerName("textView:shouldChangeTextInRanges:replacementStrings:");
public static final int sel_initWithPointerFunctions_1 = sel_registerName("initWithPointerFunctions:");
public static final int sel_initWithTextureTarget_1textureInternalFormat_1textureMaxMipMapLevel_1pixelsWide_1pixelsHigh_1 = sel_registerName("initWithTextureTarget:textureInternalFormat:textureMaxMipMapLevel:pixelsWide:pixelsHigh:");
public static final int sel_classForClassName_1 = sel_registerName("classForClassName:");
public static final int sel_decodeInt64ForKey_1 = sel_registerName("decodeInt64ForKey:");
public static final int sel_stringWithSavedFrame = sel_registerName("stringWithSavedFrame");
public static final int sel_writeRTFDToFile_1atomically_1 = sel_registerName("writeRTFDToFile:atomically:");
public static final int sel_initWithLocal_1connection_1 = sel_registerName("initWithLocal:connection:");
public static final int sel_sendBeforeDate_1msgid_1components_1from_1reserved_1 = sel_registerName("sendBeforeDate:msgid:components:from:reserved:");
public static final int sel_playsEveryFrame = sel_registerName("playsEveryFrame");
public static final int sel_prependTransform_1 = sel_registerName("prependTransform:");
public static final int sel_setUsesWeakReadAndWriteBarriers_1 = sel_registerName("setUsesWeakReadAndWriteBarriers:");
public static final int sel_isContinuous = sel_registerName("isContinuous");
public static final int sel_andPredicateWithSubpredicates_1 = sel_registerName("andPredicateWithSubpredicates:");
public static final int sel_cookieWithProperties_1 = sel_registerName("cookieWithProperties:");
public static final int sel_builtInPlugInsPath = sel_registerName("builtInPlugInsPath");
public static final int sel_performSelector_1onThread_1withObject_1waitUntilDone_1 = sel_registerName("performSelector:onThread:withObject:waitUntilDone:");
public static final int sel_sharedDocumentController = sel_registerName("sharedDocumentController");
public static final int sel_setNeedsSizing_1 = sel_registerName("setNeedsSizing:");
public static final int sel_selectorForCommand_1 = sel_registerName("selectorForCommand:");
public static final int sel_displayIfNeededInRectIgnoringOpacity_1 = sel_registerName("displayIfNeededInRectIgnoringOpacity:");
public static final int sel_draggingPasteboard = sel_registerName("draggingPasteboard");
public static final int sel_unscriptRange_1 = sel_registerName("unscriptRange:");
public static final int sel_launchApplication_1 = sel_registerName("launchApplication:");
public static final int sel_inputClientBecomeActive_1 = sel_registerName("inputClientBecomeActive:");
public static final int sel_getFirstUnlaidCharacterIndex_1glyphIndex_1 = sel_registerName("getFirstUnlaidCharacterIndex:glyphIndex:");
public static final int sel_initWithContentsOfURL_1options_1error_1 = sel_registerName("initWithContentsOfURL:options:error:");
public static final int sel_createSymbolicLinkAtPath_1withDestinationPath_1error_1 = sel_registerName("createSymbolicLinkAtPath:withDestinationPath:error:");
public static final int sel_accessibilityAttributeValue_1forParameter_1 = sel_registerName("accessibilityAttributeValue:forParameter:");
public static final int sel_setPlaceholderAttributedString_1 = sel_registerName("setPlaceholderAttributedString:");
public static final int sel_initWithIndex_1 = sel_registerName("initWithIndex:");
public static final int sel_readFromURL_1ofType_1error_1 = sel_registerName("readFromURL:ofType:error:");
public static final int sel_preferredFilename = sel_registerName("preferredFilename");
public static final int sel_smartInsertDeleteEnabled = sel_registerName("smartInsertDeleteEnabled");
public static final int sel_horizontalLineScroll = sel_registerName("horizontalLineScroll");
public static final int sel_doDoubleClick_1 = sel_registerName("doDoubleClick:");
public static final int sel_fontDescriptorWithFace_1 = sel_registerName("fontDescriptorWithFace:");
public static final int sel_pointerArrayWithPointerFunctions_1 = sel_registerName("pointerArrayWithPointerFunctions:");
public static final int sel_defaultDate = sel_registerName("defaultDate");
public static final int sel_typesetterBehavior = sel_registerName("typesetterBehavior");
public static final int sel_setAllowsNonContiguousLayout_1 = sel_registerName("setAllowsNonContiguousLayout:");
public static final int sel_control_1didFailToFormatString_1errorDescription_1 = sel_registerName("control:didFailToFormatString:errorDescription:");
public static final int sel_isBaseFont = sel_registerName("isBaseFont");
public static final int sel_removeDescriptorWithKeyword_1 = sel_registerName("removeDescriptorWithKeyword:");
public static final int sel_substringFromIndex_1 = sel_registerName("substringFromIndex:");
public static final int sel_componentsFromLocaleIdentifier_1 = sel_registerName("componentsFromLocaleIdentifier:");
public static final int sel_setUsesFeedbackWindow_1 = sel_registerName("setUsesFeedbackWindow:");
public static final int sel_setAnimates_1 = sel_registerName("setAnimates:");
public static final int sel_initWithDomain_1code_1userInfo_1 = sel_registerName("initWithDomain:code:userInfo:");
public static final int sel_setContentView_1 = sel_registerName("setContentView:");
public static final int sel_allowedFileTypes = sel_registerName("allowedFileTypes");
public static final int sel_leftExpressions = sel_registerName("leftExpressions");
public static final int sel_isStandalone = sel_registerName("isStandalone");
public static final int sel_floatForKey_1inTable_1 = sel_registerName("floatForKey:inTable:");
public static final int sel_notANumber = sel_registerName("notANumber");
public static final int sel_updateFromPMPrintSettings = sel_registerName("updateFromPMPrintSettings");
public static final int sel_wantsToTrackMouse = sel_registerName("wantsToTrackMouse");
public static final int sel_initWithName_1reason_1userInfo_1 = sel_registerName("initWithName:reason:userInfo:");
public static final int sel_prepareOpenGL = sel_registerName("prepareOpenGL");
public static final int sel_setAttributedStringForNil_1 = sel_registerName("setAttributedStringForNil:");
public static final int sel_sizeToFit = sel_registerName("sizeToFit");
public static final int sel_setSortDescriptorPrototype_1 = sel_registerName("setSortDescriptorPrototype:");
public static final int sel_canHide = sel_registerName("canHide");
public static final int sel_replacementObjectForArchiver_1 = sel_registerName("replacementObjectForArchiver:");
public static final int sel_purpleColor = sel_registerName("purpleColor");
public static final int sel_setProperty_1forKey_1 = sel_registerName("setProperty:forKey:");
public static final int sel_separatorItem = sel_registerName("separatorItem");
public static final int sel_loadedCellAtRow_1column_1 = sel_registerName("loadedCellAtRow:column:");
public static final int sel_containerSpecifier = sel_registerName("containerSpecifier");
public static final int sel_draggingSourceOperationMaskForLocal_1 = sel_registerName("draggingSourceOperationMaskForLocal:");
public static final int sel_willPresentError_1 = sel_registerName("willPresentError:");
public static final int sel_strikethroughGlyphRange_1strikethroughType_1lineFragmentRect_1lineFragmentGlyphRange_1containerOrigin_1 = sel_registerName("strikethroughGlyphRange:strikethroughType:lineFragmentRect:lineFragmentGlyphRange:containerOrigin:");
public static final int sel_elementWithName_1stringValue_1 = sel_registerName("elementWithName:stringValue:");
public static final int sel_unsignedCharValue = sel_registerName("unsignedCharValue");
public static final int sel_rangeOfComposedCharacterSequencesForRange_1 = sel_registerName("rangeOfComposedCharacterSequencesForRange:");
public static final int sel_activate_1 = sel_registerName("activate:");
public static final int sel_controlView = sel_registerName("controlView");
public static final int sel_cachePolicy = sel_registerName("cachePolicy");
public static final int sel_fontAttributesInRange_1 = sel_registerName("fontAttributesInRange:");
public static final int sel_setPreservesSelection_1 = sel_registerName("setPreservesSelection:");
public static final int sel_unscript_1 = sel_registerName("unscript:");
public static final int sel_deltaZ = sel_registerName("deltaZ");
public static final int sel_connection_1handleRequest_1 = sel_registerName("connection:handleRequest:");
public static final int sel_caseSensitive = sel_registerName("caseSensitive");
public static final int sel_tabViewItemAtPoint_1 = sel_registerName("tabViewItemAtPoint:");
public static final int sel_setTextAttributesForNegativeValues_1 = sel_registerName("setTextAttributesForNegativeValues:");
public static final int sel_underlineGlyphRange_1underlineType_1lineFragmentRect_1lineFragmentGlyphRange_1containerOrigin_1 = sel_registerName("underlineGlyphRange:underlineType:lineFragmentRect:lineFragmentGlyphRange:containerOrigin:");
public static final int sel_classForCoder = sel_registerName("classForCoder");
public static final int sel_setContent_1 = sel_registerName("setContent:");
public static final int sel_getLineStart_1end_1contentsEnd_1forRange_1 = sel_registerName("getLineStart:end:contentsEnd:forRange:");
public static final int sel_removeRowsAtIndexes_1includeSubrows_1 = sel_registerName("removeRowsAtIndexes:includeSubrows:");
public static final int sel_tokenFieldCell_1styleForRepresentedObject_1 = sel_registerName("tokenFieldCell:styleForRepresentedObject:");
public static final int sel_setToolTip_1 = sel_registerName("setToolTip:");
public static final int sel_titleHeight = sel_registerName("titleHeight");
public static final int sel_setShowsStateBy_1 = sel_registerName("setShowsStateBy:");
public static final int sel_URLWithString_1relativeToURL_1 = sel_registerName("URLWithString:relativeToURL:");
public static final int sel_fileSystemRepresentationWithPath_1 = sel_registerName("fileSystemRepresentationWithPath:");
public static final int sel_setRate_1 = sel_registerName("setRate:");
public static final int sel_extraLineFragmentTextContainer = sel_registerName("extraLineFragmentTextContainer");
public static final int sel_insertObjects_1atArrangedObjectIndexes_1 = sel_registerName("insertObjects:atArrangedObjectIndexes:");
public static final int sel_fontDescriptorWithSymbolicTraits_1 = sel_registerName("fontDescriptorWithSymbolicTraits:");
public static final int sel_topMargin = sel_registerName("topMargin");
public static final int sel_tokenField_1representedObjectForEditingString_1 = sel_registerName("tokenField:representedObjectForEditingString:");
public static final int sel_drawInsertionPointInRect_1color_1turnedOn_1 = sel_registerName("drawInsertionPointInRect:color:turnedOn:");
public static final int sel_fontNamed_1hasTraits_1 = sel_registerName("fontNamed:hasTraits:");
public static final int sel_revertToSavedFromFile_1ofType_1 = sel_registerName("revertToSavedFromFile:ofType:");
public static final int sel_cString = sel_registerName("cString");
public static final int sel_markerForItemNumber_1 = sel_registerName("markerForItemNumber:");
public static final int sel_mapTableWithWeakToStrongObjects = sel_registerName("mapTableWithWeakToStrongObjects");
public static final int sel_autosaveExpandedItems = sel_registerName("autosaveExpandedItems");
public static final int sel_setMiterLimit_1 = sel_registerName("setMiterLimit:");
public static final int sel_indentationLevel = sel_registerName("indentationLevel");
public static final int sel_fileHandleForUpdatingAtPath_1 = sel_registerName("fileHandleForUpdatingAtPath:");
public static final int sel_fontWithDescriptor_1textTransform_1 = sel_registerName("fontWithDescriptor:textTransform:");
public static final int sel_selectLine_1 = sel_registerName("selectLine:");
public static final int sel_deleteForward_1 = sel_registerName("deleteForward:");
public static final int sel_getAdvancements_1forPackedGlyphs_1length_1 = sel_registerName("getAdvancements:forPackedGlyphs:length:");
public static final int sel_usesRuler = sel_registerName("usesRuler");
public static final int sel_performClose_1 = sel_registerName("performClose:");
public static final int sel_trackRect = sel_registerName("trackRect");
public static final int sel_setFont_1 = sel_registerName("setFont:");
public static final int sel_conformsToProtocol_1 = sel_registerName("conformsToProtocol:");
public static final int sel_appendBezierPathWithPoints_1count_1 = sel_registerName("appendBezierPathWithPoints:count:");
public static final int sel_defaultLineHeightForFont_1 = sel_registerName("defaultLineHeightForFont:");
public static final int sel_mouse_1inRect_1 = sel_registerName("mouse:inRect:");
public static final int sel_portCoderWithReceivePort_1sendPort_1components_1 = sel_registerName("portCoderWithReceivePort:sendPort:components:");
public static final int sel_inputClientDisabled_1 = sel_registerName("inputClientDisabled:");
public static final int sel_widthForSegment_1 = sel_registerName("widthForSegment:");
public static final int sel_performSelector_1 = sel_registerName("performSelector:");
public static final int sel_recalculateKeyViewLoop = sel_registerName("recalculateKeyViewLoop");
public static final int sel_initWithDrawSelector_1delegate_1 = sel_registerName("initWithDrawSelector:delegate:");
public static final int sel_breakUndoCoalescing = sel_registerName("breakUndoCoalescing");
public static final int sel_font = sel_registerName("font");
public static final int sel_fontDescriptorWithSize_1 = sel_registerName("fontDescriptorWithSize:");
public static final int sel_insertItemWithTitle_1atIndex_1 = sel_registerName("insertItemWithTitle:atIndex:");
public static final int sel_contentAspectRatio = sel_registerName("contentAspectRatio");
public static final int sel_currentHandler = sel_registerName("currentHandler");
public static final int sel_sharedAppleEventManager = sel_registerName("sharedAppleEventManager");
public static final int sel_pathForResource_1ofType_1 = sel_registerName("pathForResource:ofType:");
public static final int sel_initWithRequest_1cachedResponse_1client_1 = sel_registerName("initWithRequest:cachedResponse:client:");
public static final int sel_isTitled = sel_registerName("isTitled");
public static final int sel_drawerWillOpen_1 = sel_registerName("drawerWillOpen:");
public static final int sel_screenFont = sel_registerName("screenFont");
public static final int sel_principalClass = sel_registerName("principalClass");
public static final int sel_pathControl_1willDisplayOpenPanel_1 = sel_registerName("pathControl:willDisplayOpenPanel:");
public static final int sel_setGroupingSeparator_1 = sel_registerName("setGroupingSeparator:");
public static final int sel_fontWithDescriptor_1size_1 = sel_registerName("fontWithDescriptor:size:");
public static final int sel_glyphInfoWithCharacterIdentifier_1collection_1baseString_1 = sel_registerName("glyphInfoWithCharacterIdentifier:collection:baseString:");
public static final int sel_movieUnfilteredFileTypes = sel_registerName("movieUnfilteredFileTypes");
public static final int sel_portList = sel_registerName("portList");
public static final int sel_tokenField_1readFromPasteboard_1 = sel_registerName("tokenField:readFromPasteboard:");
public static final int sel_setEndSpecifier_1 = sel_registerName("setEndSpecifier:");
public static final int sel_textView_1willDisplayToolTip_1forCharacterAtIndex_1 = sel_registerName("textView:willDisplayToolTip:forCharacterAtIndex:");
public static final int sel_applicationIconImage = sel_registerName("applicationIconImage");
public static final int sel_target = sel_registerName("target");
public static final int sel_replaceGlyphAtIndex_1withGlyph_1 = sel_registerName("replaceGlyphAtIndex:withGlyph:");
public static final int sel_borderColorForEdge_1 = sel_registerName("borderColorForEdge:");
public static final int sel_timeIntervalSinceDate_1 = sel_registerName("timeIntervalSinceDate:");
public static final int sel_pathsForResourcesOfType_1inDirectory_1forLocalization_1 = sel_registerName("pathsForResourcesOfType:inDirectory:forLocalization:");
public static final int sel_bitmapData = sel_registerName("bitmapData");
public static final int sel_redComponent = sel_registerName("redComponent");
public static final int sel_numberOfVisibleItems = sel_registerName("numberOfVisibleItems");
public static final int sel_selectCell_1 = sel_registerName("selectCell:");
public static final int sel_applicationWillHide_1 = sel_registerName("applicationWillHide:");
public static final int sel_characterIsMember_1 = sel_registerName("characterIsMember:");
public static final int sel_setArrowsPosition_1 = sel_registerName("setArrowsPosition:");
public static final int sel_minusSign = sel_registerName("minusSign");
public static final int sel_canSpawnSeparateThread = sel_registerName("canSpawnSeparateThread");
public static final int sel_setContinuous_1 = sel_registerName("setContinuous:");
public static final int sel_addSymbolicLinkWithDestination_1preferredFilename_1 = sel_registerName("addSymbolicLinkWithDestination:preferredFilename:");
public static final int sel_destinationOfSymbolicLinkAtPath_1error_1 = sel_registerName("destinationOfSymbolicLinkAtPath:error:");
public static final int sel_runUntilDate_1 = sel_registerName("runUntilDate:");
public static final int sel_stringByAbbreviatingWithTildeInPath = sel_registerName("stringByAbbreviatingWithTildeInPath");
public static final int sel_drawerWillResizeContents_1toSize_1 = sel_registerName("drawerWillResizeContents:toSize:");
public static final int sel_imageRectForBounds_1 = sel_registerName("imageRectForBounds:");
public static final int sel_indexGreaterThanIndex_1 = sel_registerName("indexGreaterThanIndex:");
public static final int sel_setSelectionFrom_1to_1anchor_1highlight_1 = sel_registerName("setSelectionFrom:to:anchor:highlight:");
public static final int sel_unsignedIntegerValue = sel_registerName("unsignedIntegerValue");
public static final int sel_focusView = sel_registerName("focusView");
public static final int sel_longCharacterIsMember_1 = sel_registerName("longCharacterIsMember:");
public static final int sel_groupingSeparator = sel_registerName("groupingSeparator");
public static final int sel_depthLimit = sel_registerName("depthLimit");
public static final int sel_attributesAtIndex_1longestEffectiveRange_1inRange_1 = sel_registerName("attributesAtIndex:longestEffectiveRange:inRange:");
public static final int sel_setAcceptsArrowKeys_1 = sel_registerName("setAcceptsArrowKeys:");
public static final int sel_isGreaterThanOrEqualTo_1 = sel_registerName("isGreaterThanOrEqualTo:");
public static final int sel_maxContentSize = sel_registerName("maxContentSize");
public static final int sel_setParentWindow_1 = sel_registerName("setParentWindow:");
public static final int sel_importsGraphics = sel_registerName("importsGraphics");
public static final int sel_setPaddingPosition_1 = sel_registerName("setPaddingPosition:");
public static final int sel_yearOfCommonEra = sel_registerName("yearOfCommonEra");
public static final int sel_cells = sel_registerName("cells");
public static final int sel_cyanComponent = sel_registerName("cyanComponent");
public static final int sel_documentClassForType_1 = sel_registerName("documentClassForType:");
public static final int sel_setSelectionHighlightStyle_1 = sel_registerName("setSelectionHighlightStyle:");
public static final int sel_addWindowController_1 = sel_registerName("addWindowController:");
public static final int sel_initWithXMLString_1error_1 = sel_registerName("initWithXMLString:error:");
public static final int sel_authenticateComponents_1withData_1 = sel_registerName("authenticateComponents:withData:");
public static final int sel_traitsOfFont_1 = sel_registerName("traitsOfFont:");
public static final int sel_timeIntervalSinceReferenceDate = sel_registerName("timeIntervalSinceReferenceDate");
public static final int sel_orderFrontCharacterPalette_1 = sel_registerName("orderFrontCharacterPalette:");
public static final int sel_setServicesProvider_1 = sel_registerName("setServicesProvider:");
public static final int sel_setMessage_1 = sel_registerName("setMessage:");
public static final int sel_msgid = sel_registerName("msgid");
public static final int sel_beginUndoGrouping = sel_registerName("beginUndoGrouping");
public static final int sel_RTFDFromRange_1documentAttributes_1 = sel_registerName("RTFDFromRange:documentAttributes:");
public static final int sel_selectedItem = sel_registerName("selectedItem");
public static final int sel_addTabStop_1 = sel_registerName("addTabStop:");
public static final int sel_scrollRect_1by_1 = sel_registerName("scrollRect:by:");
public static final int sel_icon = sel_registerName("icon");
public static final int sel_setValue_1forUndefinedKey_1 = sel_registerName("setValue:forUndefinedKey:");
public static final int sel_decodeFloatForKey_1 = sel_registerName("decodeFloatForKey:");
public static final int sel_commentURL = sel_registerName("commentURL");
public static final int sel_shortStandaloneMonthSymbols = sel_registerName("shortStandaloneMonthSymbols");
public static final int sel_browser_1titleOfColumn_1 = sel_registerName("browser:titleOfColumn:");
public static final int sel_exit = sel_registerName("exit");
public static final int sel_deselectAll_1 = sel_registerName("deselectAll:");
public static final int sel_canRemove = sel_registerName("canRemove");
public static final int sel_proxyType = sel_registerName("proxyType");
public static final int sel_shouldCloseDocument = sel_registerName("shouldCloseDocument");
public static final int sel_setMinimumLineHeight_1 = sel_registerName("setMinimumLineHeight:");
public static final int sel_grayColor = sel_registerName("grayColor");
public static final int sel_suspend = sel_registerName("suspend");
public static final int sel_printJobTitle = sel_registerName("printJobTitle");
public static final int sel_fileHandleWithStandardOutput = sel_registerName("fileHandleWithStandardOutput");
public static final int sel_objCType = sel_registerName("objCType");
public static final int sel_maximumIntegerDigits = sel_registerName("maximumIntegerDigits");
public static final int sel_initWithKey_1ascending_1 = sel_registerName("initWithKey:ascending:");
public static final int sel_paramDescriptorForKeyword_1 = sel_registerName("paramDescriptorForKeyword:");
public static final int sel_cookiesForURL_1 = sel_registerName("cookiesForURL:");
public static final int sel_currentTextContainer = sel_registerName("currentTextContainer");
public static final int sel_removeAllCachedResponses = sel_registerName("removeAllCachedResponses");
public static final int sel_setAllHTTPHeaderFields_1 = sel_registerName("setAllHTTPHeaderFields:");
public static final int sel_setShortQuarterSymbols_1 = sel_registerName("setShortQuarterSymbols:");
public static final int sel_removeItemWithObjectValue_1 = sel_registerName("removeItemWithObjectValue:");
public static final int sel_reloadColumn_1 = sel_registerName("reloadColumn:");
public static final int sel_initWithData_1 = sel_registerName("initWithData:");
public static final int sel_textDidEndEditing_1 = sel_registerName("textDidEndEditing:");
public static final int sel_descriptorForKeyword_1 = sel_registerName("descriptorForKeyword:");
public static final int sel_gState = sel_registerName("gState");
public static final int sel_setCellClass_1 = sel_registerName("setCellClass:");
public static final int sel_requestUserAttention_1 = sel_registerName("requestUserAttention:");
public static final int sel_disableUndoRegistration = sel_registerName("disableUndoRegistration");
public static final int sel_currencySymbol = sel_registerName("currencySymbol");
public static final int sel_defaultWritingDirectionForLanguage_1 = sel_registerName("defaultWritingDirectionForLanguage:");
public static final int sel_selectedCellInColumn_1 = sel_registerName("selectedCellInColumn:");
public static final int sel_spellServer_1didForgetWord_1inLanguage_1 = sel_registerName("spellServer:didForgetWord:inLanguage:");
public static final int sel_initWithType_1error_1 = sel_registerName("initWithType:error:");
public static final int sel_editedRow = sel_registerName("editedRow");
public static final int sel_expressionForUnionSet_1with_1 = sel_registerName("expressionForUnionSet:with:");
public static final int sel_verticalMotionCanBeginDrag = sel_registerName("verticalMotionCanBeginDrag");
public static final int sel_selectNextKeyView_1 = sel_registerName("selectNextKeyView:");
public static final int sel_lowercaseString = sel_registerName("lowercaseString");
public static final int sel_intercellSpacing = sel_registerName("intercellSpacing");
public static final int sel_selectedItemIdentifier = sel_registerName("selectedItemIdentifier");
public static final int sel_getIndexes_1 = sel_registerName("getIndexes:");
public static final int sel_contentRect = sel_registerName("contentRect");
public static final int sel_addObjects_1 = sel_registerName("addObjects:");
public static final int sel_selectedRowIndexes = sel_registerName("selectedRowIndexes");
public static final int sel_setSecond_1 = sel_registerName("setSecond:");
public static final int sel_setIgnoresMultiClick_1 = sel_registerName("setIgnoresMultiClick:");
public static final int sel_hasMemberInPlane_1 = sel_registerName("hasMemberInPlane:");
public static final int sel_setClientView_1 = sel_registerName("setClientView:");
public static final int sel_setInitialFirstResponder_1 = sel_registerName("setInitialFirstResponder:");
public static final int sel_defaultAnimationForKey_1 = sel_registerName("defaultAnimationForKey:");
public static final int sel_systemTimeZone = sel_registerName("systemTimeZone");
public static final int sel_pageSizeForPaper_1 = sel_registerName("pageSizeForPaper:");
public static final int sel_windowBackgroundColor = sel_registerName("windowBackgroundColor");
public static final int sel_prepareGState = sel_registerName("prepareGState");
public static final int sel_willSetLineFragmentRect_1forGlyphRange_1usedRect_1baselineOffset_1 = sel_registerName("willSetLineFragmentRect:forGlyphRange:usedRect:baselineOffset:");
public static final int sel_setScriptingProperties_1 = sel_registerName("setScriptingProperties:");
public static final int sel_initWithScrollView_1orientation_1 = sel_registerName("initWithScrollView:orientation:");
public static final int sel_canBecomeVisibleWithoutLogin = sel_registerName("canBecomeVisibleWithoutLogin");
public static final int sel_scrollLineDown_1 = sel_registerName("scrollLineDown:");
public static final int sel_setServicesMenu_1 = sel_registerName("setServicesMenu:");
public static final int sel_appleEventCode = sel_registerName("appleEventCode");
public static final int sel_replaceObjectsInRange_1withObjectsFromArray_1range_1 = sel_registerName("replaceObjectsInRange:withObjectsFromArray:range:");
public static final int sel_autosizesCells = sel_registerName("autosizesCells");
public static final int sel_tableView_1toolTipForCell_1rect_1tableColumn_1row_1mouseLocation_1 = sel_registerName("tableView:toolTipForCell:rect:tableColumn:row:mouseLocation:");
public static final int sel_dateWithYear_1month_1day_1hour_1minute_1second_1timeZone_1 = sel_registerName("dateWithYear:month:day:hour:minute:second:timeZone:");
public static final int sel_windowWillResize_1toSize_1 = sel_registerName("windowWillResize:toSize:");
public static final int sel_initWithUnsignedChar_1 = sel_registerName("initWithUnsignedChar:");
public static final int sel_suiteForAppleEventCode_1 = sel_registerName("suiteForAppleEventCode:");
public static final int sel_setTrailingOffset_1 = sel_registerName("setTrailingOffset:");
public static final int sel_canBecomeKeyWindow = sel_registerName("canBecomeKeyWindow");
public static final int sel_setAnimationBlockingMode_1 = sel_registerName("setAnimationBlockingMode:");
public static final int sel_formUnionWithCharacterSet_1 = sel_registerName("formUnionWithCharacterSet:");
public static final int sel_typeForArgumentWithName_1 = sel_registerName("typeForArgumentWithName:");
public static final int sel_setFileName_1 = sel_registerName("setFileName:");
public static final int sel_createSymbolicLinkAtPath_1pathContent_1 = sel_registerName("createSymbolicLinkAtPath:pathContent:");
public static final int sel_undoMenuTitleForUndoActionName_1 = sel_registerName("undoMenuTitleForUndoActionName:");
public static final int sel_dateStyle = sel_registerName("dateStyle");
public static final int sel_currentContext = sel_registerName("currentContext");
public static final int sel_dequeueNotificationsMatching_1coalesceMask_1 = sel_registerName("dequeueNotificationsMatching:coalesceMask:");
public static final int sel_thousandSeparator = sel_registerName("thousandSeparator");
public static final int sel_writeData_1 = sel_registerName("writeData:");
public static final int sel_selectedTag = sel_registerName("selectedTag");
public static final int sel_drawWithRect_1options_1 = sel_registerName("drawWithRect:options:");
public static final int sel_canonicalLocaleIdentifierFromString_1 = sel_registerName("canonicalLocaleIdentifierFromString:");
public static final int sel_convertFontTraits_1 = sel_registerName("convertFontTraits:");
public static final int sel_itemAdded_1 = sel_registerName("itemAdded:");
public static final int sel_scriptErrorString = sel_registerName("scriptErrorString");
public static final int sel_submenuAction_1 = sel_registerName("submenuAction:");
public static final int sel_initWithType_1subpredicates_1 = sel_registerName("initWithType:subpredicates:");
public static final int sel_subpathsOfDirectoryAtPath_1error_1 = sel_registerName("subpathsOfDirectoryAtPath:error:");
public static final int sel_becomesKeyOnlyIfNeeded = sel_registerName("becomesKeyOnlyIfNeeded");
public static final int sel_displayAllColumns = sel_registerName("displayAllColumns");
public static final int sel_indexOfItemWithSubmenu_1 = sel_registerName("indexOfItemWithSubmenu:");
public static final int sel_runModalSavePanelForSaveOperation_1delegate_1didSaveSelector_1contextInfo_1 = sel_registerName("runModalSavePanelForSaveOperation:delegate:didSaveSelector:contextInfo:");
public static final int sel_setCollectionBehavior_1 = sel_registerName("setCollectionBehavior:");
public static final int sel_boundingRectWithSize_1options_1attributes_1 = sel_registerName("boundingRectWithSize:options:attributes:");
public static final int sel_valueForAttribute_1 = sel_registerName("valueForAttribute:");
public static final int sel_attributedStringForNotANumber = sel_registerName("attributedStringForNotANumber");
public static final int sel_indicesOfObjectsByEvaluatingObjectSpecifier_1 = sel_registerName("indicesOfObjectsByEvaluatingObjectSpecifier:");
public static final int sel_initWithPath_1 = sel_registerName("initWithPath:");
public static final int sel_doCommandBySelector_1 = sel_registerName("doCommandBySelector:");
public static final int sel_numberWithChar_1 = sel_registerName("numberWithChar:");
public static final int sel_setAllowsMixedState_1 = sel_registerName("setAllowsMixedState:");
public static final int sel_abortEditing = sel_registerName("abortEditing");
public static final int sel_context = sel_registerName("context");
public static final int sel_drawerShouldClose_1 = sel_registerName("drawerShouldClose:");
public static final int sel_tabViewDidChangeNumberOfTabViewItems_1 = sel_registerName("tabViewDidChangeNumberOfTabViewItems:");
public static final int sel_focusRingType = sel_registerName("focusRingType");
public static final int sel_copyScriptingValue_1forKey_1withProperties_1 = sel_registerName("copyScriptingValue:forKey:withProperties:");
public static final int sel_acceptsFirstMouse_1 = sel_registerName("acceptsFirstMouse:");
public static final int sel_initWithPosition_1objectSpecifier_1 = sel_registerName("initWithPosition:objectSpecifier:");
public static final int sel_selectionRangeForProposedRange_1granularity_1 = sel_registerName("selectionRangeForProposedRange:granularity:");
public static final int sel_isNotEqualTo_1 = sel_registerName("isNotEqualTo:");
public static final int sel_encodeRootObject_1 = sel_registerName("encodeRootObject:");
public static final int sel_hasSuffix_1 = sel_registerName("hasSuffix:");
public static final int sel_initWithFontAttributes_1 = sel_registerName("initWithFontAttributes:");
public static final int sel_initWithRTFDFileWrapper_1documentAttributes_1 = sel_registerName("initWithRTFDFileWrapper:documentAttributes:");
public static final int sel_miniwindowImage = sel_registerName("miniwindowImage");
public static final int sel_developmentLocalization = sel_registerName("developmentLocalization");
public static final int sel_localizedSummaryItems = sel_registerName("localizedSummaryItems");
public static final int sel_intValue = sel_registerName("intValue");
public static final int sel_setReturnValue_1 = sel_registerName("setReturnValue:");
public static final int sel_selectedMenuItemColor = sel_registerName("selectedMenuItemColor");
public static final int sel_editColumn_1row_1withEvent_1select_1 = sel_registerName("editColumn:row:withEvent:select:");
public static final int sel_descriptionWithCalendarFormat_1timeZone_1locale_1 = sel_registerName("descriptionWithCalendarFormat:timeZone:locale:");
public static final int sel_itemHeight = sel_registerName("itemHeight");
public static final int sel_application_1openFiles_1 = sel_registerName("application:openFiles:");
public static final int sel_window = sel_registerName("window");
public static final int sel_setShortStandaloneMonthSymbols_1 = sel_registerName("setShortStandaloneMonthSymbols:");
public static final int sel_setTag_1 = sel_registerName("setTag:");
public static final int sel_ignoredWordsInSpellDocumentWithTag_1 = sel_registerName("ignoredWordsInSpellDocumentWithTag:");
public static final int sel_preferredLocalizationsFromArray_1 = sel_registerName("preferredLocalizationsFromArray:");
public static final int sel_intersectsIndexesInRange_1 = sel_registerName("intersectsIndexesInRange:");
public static final int sel_scanLongLong_1 = sel_registerName("scanLongLong:");
public static final int sel_characterSetWithContentsOfFile_1 = sel_registerName("characterSetWithContentsOfFile:");
public static final int sel_elementWithName_1children_1attributes_1 = sel_registerName("elementWithName:children:attributes:");
public static final int sel_removeItem_1 = sel_registerName("removeItem:");
public static final int sel_classForKeyedArchiver = sel_registerName("classForKeyedArchiver");
public static final int sel_initWithString_1locale_1 = sel_registerName("initWithString:locale:");
public static final int sel_initWithData_1options_1error_1 = sel_registerName("initWithData:options:error:");
public static final int sel_setIsPaneSplitter_1 = sel_registerName("setIsPaneSplitter:");
public static final int sel_URLHandle_1resourceDataDidBecomeAvailable_1 = sel_registerName("URLHandle:resourceDataDidBecomeAvailable:");
public static final int sel_systemDefaultPortNameServer = sel_registerName("systemDefaultPortNameServer");
public static final int sel_controlTextDidEndEditing_1 = sel_registerName("controlTextDidEndEditing:");
public static final int sel_commandDescription = sel_registerName("commandDescription");
public static final int sel_collapseItem_1 = sel_registerName("collapseItem:");
public static final int sel_setAutoresizesOutlineColumn_1 = sel_registerName("setAutoresizesOutlineColumn:");
public static final int sel_isSubsetOfHashTable_1 = sel_registerName("isSubsetOfHashTable:");
public static final int sel_discardEventsMatchingMask_1beforeEvent_1 = sel_registerName("discardEventsMatchingMask:beforeEvent:");
public static final int sel_highlightSelectionInClipRect_1 = sel_registerName("highlightSelectionInClipRect:");
public static final int sel_decodeSizeForKey_1 = sel_registerName("decodeSizeForKey:");
public static final int sel_decimalNumberByRaisingToPower_1 = sel_registerName("decimalNumberByRaisingToPower:");
public static final int sel_canBecomeMainWindow = sel_registerName("canBecomeMainWindow");
public static final int sel_setMenuItem_1 = sel_registerName("setMenuItem:");
public static final int sel_contentRectForFrameRect_1styleMask_1 = sel_registerName("contentRectForFrameRect:styleMask:");
public static final int sel_clearGLContext = sel_registerName("clearGLContext");
public static final int sel_setFileType_1 = sel_registerName("setFileType:");
public static final int sel_expressionForIntersectSet_1with_1 = sel_registerName("expressionForIntersectSet:with:");
public static final int sel_sharedHelpManager = sel_registerName("sharedHelpManager");
public static final int sel_setMiniwindowTitle_1 = sel_registerName("setMiniwindowTitle:");
public static final int sel_fontDescriptorWithName_1size_1 = sel_registerName("fontDescriptorWithName:size:");
public static final int sel_cookies = sel_registerName("cookies");
public static final int sel_detachNewThreadSelector_1toTarget_1withObject_1 = sel_registerName("detachNewThreadSelector:toTarget:withObject:");
public static final int sel_needsPanelToBecomeKey = sel_registerName("needsPanelToBecomeKey");
public static final int sel_retainArguments = sel_registerName("retainArguments");
public static final int sel_textStorageWillProcessEditing_1 = sel_registerName("textStorageWillProcessEditing:");
public static final int sel_location = sel_registerName("location");
public static final int sel_shouldChangeTextInRange_1replacementString_1 = sel_registerName("shouldChangeTextInRange:replacementString:");
public static final int sel_textView_1doubleClickedOnCell_1inRect_1 = sel_registerName("textView:doubleClickedOnCell:inRect:");
public static final int sel_validateVisibleItems = sel_registerName("validateVisibleItems");
public static final int sel_isOneway = sel_registerName("isOneway");
public static final int sel_zone = sel_registerName("zone");
public static final int sel_titleAlignment = sel_registerName("titleAlignment");
public static final int sel_localNameForName_1 = sel_registerName("localNameForName:");
public static final int sel_loopMode = sel_registerName("loopMode");
public static final int sel_setFocusRingType_1 = sel_registerName("setFocusRingType:");
public static final int sel_stringForKey_1 = sel_registerName("stringForKey:");
public static final int sel_initWithDomain_1type_1name_1 = sel_registerName("initWithDomain:type:name:");
public static final int sel_animationDidEnd_1 = sel_registerName("animationDidEnd:");
public static final int sel_addSubview_1positioned_1relativeTo_1 = sel_registerName("addSubview:positioned:relativeTo:");
public static final int sel_removeObjects_1 = sel_registerName("removeObjects:");
public static final int sel_graphicsContextWithBitmapImageRep_1 = sel_registerName("graphicsContextWithBitmapImageRep:");
public static final int sel_isDescendantOf_1 = sel_registerName("isDescendantOf:");
public static final int sel_tableView_1nextTypeSelectMatchFromRow_1toRow_1forString_1 = sel_registerName("tableView:nextTypeSelectMatchFromRow:toRow:forString:");
public static final int sel_initWithRequest_1delegate_1startImmediately_1 = sel_registerName("initWithRequest:delegate:startImmediately:");
public static final int sel_reservedThicknessForMarkers = sel_registerName("reservedThicknessForMarkers");
public static final int sel_movieRect = sel_registerName("movieRect");
public static final int sel_portForName_1host_1 = sel_registerName("portForName:host:");
public static final int sel_tabView_1willSelectTabViewItem_1 = sel_registerName("tabView:willSelectTabViewItem:");
public static final int sel_isOneShot = sel_registerName("isOneShot");
public static final int sel_usesThreadedAnimation = sel_registerName("usesThreadedAnimation");
public static final int sel_shortStandaloneQuarterSymbols = sel_registerName("shortStandaloneQuarterSymbols");
public static final int sel_browser_1validateDrop_1proposedRow_1column_1dropOperation_1 = sel_registerName("browser:validateDrop:proposedRow:column:dropOperation:");
public static final int sel_setLineSpacing_1 = sel_registerName("setLineSpacing:");
public static final int sel_indexOfItemWithTitle_1 = sel_registerName("indexOfItemWithTitle:");
public static final int sel_subrowsKeyPath = sel_registerName("subrowsKeyPath");
public static final int sel_showsResizeIndicator = sel_registerName("showsResizeIndicator");
public static final int sel_setState_1 = sel_registerName("setState:");
public static final int sel_fileAttributesAtPath_1traverseLink_1 = sel_registerName("fileAttributesAtPath:traverseLink:");
public static final int sel_setHorizontal_1 = sel_registerName("setHorizontal:");
public static final int sel_windowDidExpose_1 = sel_registerName("windowDidExpose:");
public static final int sel_systemID = sel_registerName("systemID");
public static final int sel_turnOffKerning_1 = sel_registerName("turnOffKerning:");
public static final int sel_stringByReplacingPercentEscapesUsingEncoding_1 = sel_registerName("stringByReplacingPercentEscapesUsingEncoding:");
public static final int sel_control_1textView_1completions_1forPartialWordRange_1indexOfSelectedItem_1 = sel_registerName("control:textView:completions:forPartialWordRange:indexOfSelectedItem:");
public static final int sel_selectLastTabViewItem_1 = sel_registerName("selectLastTabViewItem:");
public static final int sel_setKeyEquivalentFont_1 = sel_registerName("setKeyEquivalentFont:");
public static final int sel_invalidateCursorRectsForView_1 = sel_registerName("invalidateCursorRectsForView:");
public static final int sel_selectTextAtIndex_1 = sel_registerName("selectTextAtIndex:");
public static final int sel_showPools = sel_registerName("showPools");
public static final int sel_setPlaysSelectionOnly_1 = sel_registerName("setPlaysSelectionOnly:");
public static final int sel_note = sel_registerName("note");
public static final int sel_setDrawsCellBackground_1 = sel_registerName("setDrawsCellBackground:");
public static final int sel_layoutCharactersInRange_1forLayoutManager_1maximumNumberOfLineFragments_1 = sel_registerName("layoutCharactersInRange:forLayoutManager:maximumNumberOfLineFragments:");
public static final int sel_lengthOfBytesUsingEncoding_1 = sel_registerName("lengthOfBytesUsingEncoding:");
public static final int sel_columnResizingType = sel_registerName("columnResizingType");
public static final int sel_paragraphSeparatorGlyphRange = sel_registerName("paragraphSeparatorGlyphRange");
public static final int sel_floatValue = sel_registerName("floatValue");
public static final int sel_setRoundingIncrement_1 = sel_registerName("setRoundingIncrement:");
public static final int sel_dateFromString_1 = sel_registerName("dateFromString:");
public static final int sel_panel_1shouldShowFilename_1 = sel_registerName("panel:shouldShowFilename:");
public static final int sel_isEqualToDate_1 = sel_registerName("isEqualToDate:");
public static final int sel_drawWithFrame_1inView_1characterIndex_1 = sel_registerName("drawWithFrame:inView:characterIndex:");
public static final int sel_initWithInteger_1 = sel_registerName("initWithInteger:");
public static final int sel_CGImage = sel_registerName("CGImage");
public static final int sel_endDocument = sel_registerName("endDocument");
public static final int sel_removeFile = sel_registerName("removeFile");
public static final int sel_splitView_1shouldCollapseSubview_1forDoubleClickOnDividerAtIndex_1 = sel_registerName("splitView:shouldCollapseSubview:forDoubleClickOnDividerAtIndex:");
public static final int sel_setDefaultMiterLimit_1 = sel_registerName("setDefaultMiterLimit:");
public static final int sel_keyCode = sel_registerName("keyCode");
public static final int sel_raise_1format_1 = sel_registerName("raise:format:");
public static final int sel_cellSize = sel_registerName("cellSize");
public static final int sel_runModalForWindow_1 = sel_registerName("runModalForWindow:");
public static final int sel_colorListNamed_1 = sel_registerName("colorListNamed:");
public static final int sel_detachColorList_1 = sel_registerName("detachColorList:");
public static final int sel_postEvent_1atStart_1 = sel_registerName("postEvent:atStart:");
public static final int sel_setMaximumFractionDigits_1 = sel_registerName("setMaximumFractionDigits:");
public static final int sel_setVolatileDomain_1forName_1 = sel_registerName("setVolatileDomain:forName:");
public static final int sel_imageInterpolation = sel_registerName("imageInterpolation");
public static final int sel_setTitlePosition_1 = sel_registerName("setTitlePosition:");
public static final int sel_leadingOffset = sel_registerName("leadingOffset");
public static final int sel_invokeWithTarget_1 = sel_registerName("invokeWithTarget:");
public static final int sel_negativeFormat = sel_registerName("negativeFormat");
public static final int sel_windowController = sel_registerName("windowController");
public static final int sel_setVerticalPageScroll_1 = sel_registerName("setVerticalPageScroll:");
public static final int sel_applicationDidUpdate_1 = sel_registerName("applicationDidUpdate:");
public static final int sel_valueForProperty_1 = sel_registerName("valueForProperty:");
public static final int sel_tokenField_1hasMenuForRepresentedObject_1 = sel_registerName("tokenField:hasMenuForRepresentedObject:");
public static final int sel_resolveClassMethod_1 = sel_registerName("resolveClassMethod:");
public static final int sel_setAutomaticQuoteSubstitutionEnabled_1 = sel_registerName("setAutomaticQuoteSubstitutionEnabled:");
public static final int sel_ordinalityOfUnit_1inUnit_1forDate_1 = sel_registerName("ordinalityOfUnit:inUnit:forDate:");
public static final int sel_initWithHost_1port_1protocol_1realm_1authenticationMethod_1 = sel_registerName("initWithHost:port:protocol:realm:authenticationMethod:");
public static final int sel_timeIntervalSinceNow = sel_registerName("timeIntervalSinceNow");
public static final int sel_showFindIndicatorForRange_1 = sel_registerName("showFindIndicatorForRange:");
public static final int sel_drawLabel_1inRect_1 = sel_registerName("drawLabel:inRect:");
public static final int sel_startQuery = sel_registerName("startQuery");
public static final int sel_initWithNibNamed_1bundle_1 = sel_registerName("initWithNibNamed:bundle:");
public static final int sel_firstResponder = sel_registerName("firstResponder");
public static final int sel_windowWillMove_1 = sel_registerName("windowWillMove:");
public static final int sel_dictionaryForKey_1 = sel_registerName("dictionaryForKey:");
public static final int sel_decodeValueOfObjCType_1at_1 = sel_registerName("decodeValueOfObjCType:at:");
public static final int sel_activeApplication = sel_registerName("activeApplication");
public static final int sel_initWithUnsignedLongLong_1 = sel_registerName("initWithUnsignedLongLong:");
public static final int sel_decimalNumberWithString_1 = sel_registerName("decimalNumberWithString:");
public static final int sel_replaceTextStorage_1 = sel_registerName("replaceTextStorage:");
public static final int sel_relativePosition = sel_registerName("relativePosition");
public static final int sel_objectValueOfSelectedItem = sel_registerName("objectValueOfSelectedItem");
public static final int sel_timeInterval = sel_registerName("timeInterval");
public static final int sel_getBytes_1range_1 = sel_registerName("getBytes:range:");
public static final int sel_initWithViewAnimations_1 = sel_registerName("initWithViewAnimations:");
public static final int sel_setHorizontalRulerView_1 = sel_registerName("setHorizontalRulerView:");
public static final int sel_keyPathsForValuesAffectingPreview = sel_registerName("keyPathsForValuesAffectingPreview");
public static final int sel_setWithObjects_1count_1 = sel_registerName("setWithObjects:count:");
public static final int sel_bitsPerSample = sel_registerName("bitsPerSample");
public static final int sel_dayOfYear = sel_registerName("dayOfYear");
public static final int sel_maximumFractionDigits = sel_registerName("maximumFractionDigits");
public static final int sel_isSelectionByRect = sel_registerName("isSelectionByRect");
public static final int sel_getRed_1green_1blue_1alpha_1 = sel_registerName("getRed:green:blue:alpha:");
public static final int sel_glyphIsEncoded_1 = sel_registerName("glyphIsEncoded:");
public static final int sel_setStartSubelementIdentifier_1 = sel_registerName("setStartSubelementIdentifier:");
public static final int sel_connection_1didFailWithError_1 = sel_registerName("connection:didFailWithError:");
public static final int sel_parser_1foundExternalEntityDeclarationWithName_1publicID_1systemID_1 = sel_registerName("parser:foundExternalEntityDeclarationWithName:publicID:systemID:");
public static final int sel_outlineView_1shouldTypeSelectForEvent_1withCurrentSearchString_1 = sel_registerName("outlineView:shouldTypeSelectForEvent:withCurrentSearchString:");
public static final int sel_lowerBaseline_1 = sel_registerName("lowerBaseline:");
public static final int sel_outlineView_1willDisplayCell_1forTableColumn_1item_1 = sel_registerName("outlineView:willDisplayCell:forTableColumn:item:");
public static final int sel_notificationWithName_1object_1userInfo_1 = sel_registerName("notificationWithName:object:userInfo:");
public static final int sel_setMaxConcurrentOperationCount_1 = sel_registerName("setMaxConcurrentOperationCount:");
public static final int sel_closeSpellDocumentWithTag_1 = sel_registerName("closeSpellDocumentWithTag:");
public static final int sel_popUpStatusItemMenu_1 = sel_registerName("popUpStatusItemMenu:");
public static final int sel_itemPrototype = sel_registerName("itemPrototype");
public static final int sel_commandName = sel_registerName("commandName");
public static final int sel_setTextAttributesForZero_1 = sel_registerName("setTextAttributesForZero:");
public static final int sel_dateFromComponents_1 = sel_registerName("dateFromComponents:");
public static final int sel_outlineViewColumnDidResize_1 = sel_registerName("outlineViewColumnDidResize:");
public static final int sel_setTailIndent_1 = sel_registerName("setTailIndent:");
public static final int sel_setRowTemplates_1 = sel_registerName("setRowTemplates:");
public static final int sel_objectsForXQuery_1constants_1error_1 = sel_registerName("objectsForXQuery:constants:error:");
public static final int sel_mutableCopyWithZone_1 = sel_registerName("mutableCopyWithZone:");
public static final int sel_initWithItemIdentifier_1 = sel_registerName("initWithItemIdentifier:");
public static final int sel_minuteOfHour = sel_registerName("minuteOfHour");
public static final int sel_setAutosavingDelay_1 = sel_registerName("setAutosavingDelay:");
public static final int sel_nextKeyView = sel_registerName("nextKeyView");
public static final int sel_orderFront_1 = sel_registerName("orderFront:");
public static final int sel_encodeValueOfObjCType_1at_1 = sel_registerName("encodeValueOfObjCType:at:");
public static final int sel_mode = sel_registerName("mode");
public static final int sel_appleEventWithEventClass_1eventID_1targetDescriptor_1returnID_1transactionID_1 = sel_registerName("appleEventWithEventClass:eventID:targetDescriptor:returnID:transactionID:");
public static final int sel_stringByDeletingPathExtension = sel_registerName("stringByDeletingPathExtension");
public static final int sel_standardOutput = sel_registerName("standardOutput");
public static final int sel_enumCodeValue = sel_registerName("enumCodeValue");
public static final int sel_setResourceData_1 = sel_registerName("setResourceData:");
public static final int sel_convertRectFromBase_1 = sel_registerName("convertRectFromBase:");
public static final int sel_initWithContentRect_1styleMask_1backing_1defer_1screen_1 = sel_registerName("initWithContentRect:styleMask:backing:defer:screen:");
public static final int sel_autoenablesItems = sel_registerName("autoenablesItems");
public static final int sel_textContainerForGlyphAtIndex_1effectiveRange_1withoutAdditionalLayout_1 = sel_registerName("textContainerForGlyphAtIndex:effectiveRange:withoutAdditionalLayout:");
public static final int sel_QTMovie = sel_registerName("QTMovie");
public static final int sel_addObserver_1selector_1name_1object_1suspensionBehavior_1 = sel_registerName("addObserver:selector:name:object:suspensionBehavior:");
public static final int sel_getArgument_1atIndex_1 = sel_registerName("getArgument:atIndex:");
public static final int sel_replaceChildAtIndex_1withNode_1 = sel_registerName("replaceChildAtIndex:withNode:");
public static final int sel_beginForDirectory_1file_1types_1modelessDelegate_1didEndSelector_1contextInfo_1 = sel_registerName("beginForDirectory:file:types:modelessDelegate:didEndSelector:contextInfo:");
public static final int sel_supportsMode_1 = sel_registerName("supportsMode:");
public static final int sel_openFile_1 = sel_registerName("openFile:");
public static final int sel_zero = sel_registerName("zero");
public static final int sel_compositingFilter = sel_registerName("compositingFilter");
public static final int sel_fileGroupOwnerAccountID = sel_registerName("fileGroupOwnerAccountID");
public static final int sel_tokenField_1writeRepresentedObjects_1toPasteboard_1 = sel_registerName("tokenField:writeRepresentedObjects:toPasteboard:");
public static final int sel_tabViewType = sel_registerName("tabViewType");
public static final int sel_drawSortIndicatorWithFrame_1inView_1ascending_1priority_1 = sel_registerName("drawSortIndicatorWithFrame:inView:ascending:priority:");
public static final int sel_spellCheckerDocumentTag = sel_registerName("spellCheckerDocumentTag");
public static final int sel_updateFromPMPageFormat = sel_registerName("updateFromPMPageFormat");
public static final int sel_colorSyncProfile = sel_registerName("colorSyncProfile");
public static final int sel_flushBufferedKeyEvents = sel_registerName("flushBufferedKeyEvents");
public static final int sel_removeAllObjects = sel_registerName("removeAllObjects");
public static final int sel_selectItemWithTitle_1 = sel_registerName("selectItemWithTitle:");
public static final int sel_textContainers = sel_registerName("textContainers");
public static final int sel_isHorizontallyResizable = sel_registerName("isHorizontallyResizable");
public static final int sel_selectionIndexPaths = sel_registerName("selectionIndexPaths");
public static final int sel_setString_1forType_1 = sel_registerName("setString:forType:");
public static final int sel_setWraps_1 = sel_registerName("setWraps:");
public static final int sel_dataCell = sel_registerName("dataCell");
public static final int sel_addPointer_1 = sel_registerName("addPointer:");
public static final int sel_invalidate = sel_registerName("invalidate");
public static final int sel_draggingImageForRowsWithIndexes_1inColumn_1withEvent_1offset_1 = sel_registerName("draggingImageForRowsWithIndexes:inColumn:withEvent:offset:");
public static final int sel_horizontalEdgePadding = sel_registerName("horizontalEdgePadding");
public static final int sel_view = sel_registerName("view");
public static final int sel_showsPrintPanel = sel_registerName("showsPrintPanel");
public static final int sel_hyphenationFactor = sel_registerName("hyphenationFactor");
public static final int sel_setAcceptsGlyphInfo_1 = sel_registerName("setAcceptsGlyphInfo:");
public static final int sel_formatWidth = sel_registerName("formatWidth");
public static final int sel_stringByAppendingFormat_1 = sel_registerName("stringByAppendingFormat:");
public static final int sel_documentForFileName_1 = sel_registerName("documentForFileName:");
public static final int sel_outlineView_1nextTypeSelectMatchFromItem_1toItem_1forString_1 = sel_registerName("outlineView:nextTypeSelectMatchFromItem:toItem:forString:");
public static final int sel_isItemExpanded_1 = sel_registerName("isItemExpanded:");
public static final int sel_playbackDeviceIdentifier = sel_registerName("playbackDeviceIdentifier");
public static final int sel_addButtonWithTitle_1 = sel_registerName("addButtonWithTitle:");
public static final int sel_lowercaseLetterCharacterSet = sel_registerName("lowercaseLetterCharacterSet");
public static final int sel_netService_1didNotResolve_1 = sel_registerName("netService:didNotResolve:");
public static final int sel_copiesOnScroll = sel_registerName("copiesOnScroll");
public static final int sel_unarchiver_1willReplaceObject_1withObject_1 = sel_registerName("unarchiver:willReplaceObject:withObject:");
public static final int sel_setHasShadow_1 = sel_registerName("setHasShadow:");
public static final int sel_addObserver_1selector_1name_1object_1 = sel_registerName("addObserver:selector:name:object:");
public static final int sel_setDouble_1forKey_1 = sel_registerName("setDouble:forKey:");
public static final int sel_positionOfGlyph_1struckOverRect_1metricsExist_1 = sel_registerName("positionOfGlyph:struckOverRect:metricsExist:");
public static final int sel_sharedInstance = sel_registerName("sharedInstance");
public static final int sel_setPaperSize_1 = sel_registerName("setPaperSize:");
public static final int sel_data1 = sel_registerName("data1");
public static final int sel_applicationWillBecomeActive_1 = sel_registerName("applicationWillBecomeActive:");
public static final int sel_URLProtocol_1cachedResponseIsValid_1 = sel_registerName("URLProtocol:cachedResponseIsValid:");
public static final int sel_mouseDown_1 = sel_registerName("mouseDown:");
public static final int sel_setVeryShortStandaloneWeekdaySymbols_1 = sel_registerName("setVeryShortStandaloneWeekdaySymbols:");
public static final int sel_setUsesStrongWriteBarrier_1 = sel_registerName("setUsesStrongWriteBarrier:");
public static final int sel_second = sel_registerName("second");
public static final int sel_predicateWithLeftExpression_1rightExpression_1modifier_1type_1options_1 = sel_registerName("predicateWithLeftExpression:rightExpression:modifier:type:options:");
public static final int sel_setFloatingPanel_1 = sel_registerName("setFloatingPanel:");
public static final int sel_parser_1didEndElement_1namespaceURI_1qualifiedName_1 = sel_registerName("parser:didEndElement:namespaceURI:qualifiedName:");
public static final int sel_handlePortMessage_1 = sel_registerName("handlePortMessage:");
public static final int sel_filteredSetUsingPredicate_1 = sel_registerName("filteredSetUsingPredicate:");
public static final int sel_setLocalizedKeyDictionary_1 = sel_registerName("setLocalizedKeyDictionary:");
public static final int sel_drawCellInside_1 = sel_registerName("drawCellInside:");
public static final int sel_browserDidScroll_1 = sel_registerName("browserDidScroll:");
public static final int sel_isDirectory = sel_registerName("isDirectory");
public static final int sel_setEnvironment_1 = sel_registerName("setEnvironment:");
public static final int sel_persistence = sel_registerName("persistence");
public static final int sel_backingType = sel_registerName("backingType");
public static final int sel_orderedDocuments = sel_registerName("orderedDocuments");
public static final int sel_windowWillUseStandardFrame_1defaultFrame_1 = sel_registerName("windowWillUseStandardFrame:defaultFrame:");
public static final int sel_toggleTraditionalCharacterShape_1 = sel_registerName("toggleTraditionalCharacterShape:");
public static final int sel_fractionOfDistanceThroughGlyphForPoint_1 = sel_registerName("fractionOfDistanceThroughGlyphForPoint:");
public static final int sel_netServiceWillPublish_1 = sel_registerName("netServiceWillPublish:");
public static final int sel_drawInRect_1relativeCenterPosition_1 = sel_registerName("drawInRect:relativeCenterPosition:");
public static final int sel_setShowsAlpha_1 = sel_registerName("setShowsAlpha:");
public static final int sel_canDragRowsWithIndexes_1inColumn_1withEvent_1 = sel_registerName("canDragRowsWithIndexes:inColumn:withEvent:");
public static final int sel_start = sel_registerName("start");
public static final int sel_imageRectInRuler = sel_registerName("imageRectInRuler");
public static final int sel_TXTRecordData = sel_registerName("TXTRecordData");
public static final int sel_groupingLevel = sel_registerName("groupingLevel");
public static final int sel_response = sel_registerName("response");
public static final int sel_insertionIndex = sel_registerName("insertionIndex");
public static final int sel_cancelPreviousPerformRequestsWithTarget_1selector_1object_1 = sel_registerName("cancelPreviousPerformRequestsWithTarget:selector:object:");
public static final int sel_itemWithTitle_1 = sel_registerName("itemWithTitle:");
public static final int sel_insertRow_1 = sel_registerName("insertRow:");
public static final int sel_mutableChildNodes = sel_registerName("mutableChildNodes");
public static final int sel_removeAllPoints = sel_registerName("removeAllPoints");
public static final int sel_searchForRegistrationDomains = sel_registerName("searchForRegistrationDomains");
public static final int sel_replacementObjectForCoder_1 = sel_registerName("replacementObjectForCoder:");
public static final int sel_tangentialPressure = sel_registerName("tangentialPressure");
public static final int sel_setMaxDate_1 = sel_registerName("setMaxDate:");
public static final int sel_performMnemonic_1 = sel_registerName("performMnemonic:");
public static final int sel_maximumRecentDocumentCount = sel_registerName("maximumRecentDocumentCount");
public static final int sel_stringsByAppendingPaths_1 = sel_registerName("stringsByAppendingPaths:");
public static final int sel_localTimeZone = sel_registerName("localTimeZone");
public static final int sel_draggingLocation = sel_registerName("draggingLocation");
public static final int sel_searchForAllDomains = sel_registerName("searchForAllDomains");
public static final int sel_attributedStringWithAttachment_1 = sel_registerName("attributedStringWithAttachment:");
public static final int sel_initWithContentsOfURL_1byReference_1 = sel_registerName("initWithContentsOfURL:byReference:");
public static final int sel_exchangeObjectAtIndex_1withObjectAtIndex_1 = sel_registerName("exchangeObjectAtIndex:withObjectAtIndex:");
public static final int sel_draw = sel_registerName("draw");
public static final int sel_fileIsImmutable = sel_registerName("fileIsImmutable");
public static final int sel_tokenField_1styleForRepresentedObject_1 = sel_registerName("tokenField:styleForRepresentedObject:");
public static final int sel_setAutorecalculatesContentBorderThickness_1forEdge_1 = sel_registerName("setAutorecalculatesContentBorderThickness:forEdge:");
public static final int sel_firstRectForCharacterRange_1actualRange_1 = sel_registerName("firstRectForCharacterRange:actualRange:");
public static final int sel_targetForAction_1to_1from_1 = sel_registerName("targetForAction:to:from:");
public static final int sel_setShouldCloseDocument_1 = sel_registerName("setShouldCloseDocument:");
public static final int sel_originOffset = sel_registerName("originOffset");
public static final int sel_sharedSupportPath = sel_registerName("sharedSupportPath");
public static final int sel_disableScreenUpdatesUntilFlush = sel_registerName("disableScreenUpdatesUntilFlush");
public static final int sel_setShortStandaloneQuarterSymbols_1 = sel_registerName("setShortStandaloneQuarterSymbols:");
public static final int sel_filenames = sel_registerName("filenames");
public static final int sel_numberOfItemsInComboBox_1 = sel_registerName("numberOfItemsInComboBox:");
public static final int sel_hasBytesAvailable = sel_registerName("hasBytesAvailable");
public static final int sel_currentConversation = sel_registerName("currentConversation");
public static final int sel_setAllowsEditingTextAttributes_1 = sel_registerName("setAllowsEditingTextAttributes:");
public static final int sel_initWithName_1stringValue_1 = sel_registerName("initWithName:stringValue:");
public static final int sel_tableViewColumnDidResize_1 = sel_registerName("tableViewColumnDidResize:");
public static final int sel_knowsPageRange_1 = sel_registerName("knowsPageRange:");
public static final int sel_uppercaseLetterCharacterSet = sel_registerName("uppercaseLetterCharacterSet");
public static final int sel_capitalizedLetterCharacterSet = sel_registerName("capitalizedLetterCharacterSet");
public static final int sel_main = sel_registerName("main");
public static final int sel_genericRGBColorSpace = sel_registerName("genericRGBColorSpace");
public static final int sel_clearsFilterPredicateOnInsertion = sel_registerName("clearsFilterPredicateOnInsertion");
public static final int sel_paragraphs = sel_registerName("paragraphs");
public static final int sel_setJobDisposition_1 = sel_registerName("setJobDisposition:");
public static final int sel_setContainerClassDescription_1 = sel_registerName("setContainerClassDescription:");
public static final int sel_stringWithContentsOfURL_1 = sel_registerName("stringWithContentsOfURL:");
public static final int sel_setTrackingMode_1 = sel_registerName("setTrackingMode:");
public static final int sel_canCloseDocumentWithDelegate_1shouldCloseSelector_1contextInfo_1 = sel_registerName("canCloseDocumentWithDelegate:shouldCloseSelector:contextInfo:");
public static final int sel_usesItemFromMenu = sel_registerName("usesItemFromMenu");
public static final int sel_shortValue = sel_registerName("shortValue");
public static final int sel_readDataOfLength_1 = sel_registerName("readDataOfLength:");
public static final int sel_descriptorWithDescriptorType_1data_1 = sel_registerName("descriptorWithDescriptorType:data:");
public static final int sel_setCanRemoveAllRows_1 = sel_registerName("setCanRemoveAllRows:");
public static final int sel_defaultCenter = sel_registerName("defaultCenter");
public static final int sel_scriptingIsGreaterThan_1 = sel_registerName("scriptingIsGreaterThan:");
public static final int sel_splitView_1constrainSplitPosition_1ofSubviewAt_1 = sel_registerName("splitView:constrainSplitPosition:ofSubviewAt:");
public static final int sel_setTokenStyle_1 = sel_registerName("setTokenStyle:");
public static final int sel_initWithContentRect_1styleMask_1backing_1defer_1 = sel_registerName("initWithContentRect:styleMask:backing:defer:");
public static final int sel_insertTabViewItem_1atIndex_1 = sel_registerName("insertTabViewItem:atIndex:");
public static final int sel_rowForDisplayValue_1 = sel_registerName("rowForDisplayValue:");
public static final int sel_isDrawingToScreen = sel_registerName("isDrawingToScreen");
public static final int sel_encodeRect_1 = sel_registerName("encodeRect:");
public static final int sel_controlDarkShadowColor = sel_registerName("controlDarkShadowColor");
public static final int sel_maxDate = sel_registerName("maxDate");
public static final int sel_lock = sel_registerName("lock");
public static final int sel_resetSystemTimeZone = sel_registerName("resetSystemTimeZone");
public static final int sel_coerceValue_1toClass_1 = sel_registerName("coerceValue:toClass:");
public static final int sel_qdPort = sel_registerName("qdPort");
public static final int sel_resultAtIndex_1 = sel_registerName("resultAtIndex:");
public static final int sel_descriptorWithBoolean_1 = sel_registerName("descriptorWithBoolean:");
public static final int sel_markedRange = sel_registerName("markedRange");
public static final int sel_colorWithCalibratedHue_1saturation_1brightness_1alpha_1 = sel_registerName("colorWithCalibratedHue:saturation:brightness:alpha:");
public static final int sel_setSharedPrintInfo_1 = sel_registerName("setSharedPrintInfo:");
public static final int sel_setBorderColor_1 = sel_registerName("setBorderColor:");
public static final int sel_parser_1foundCharacters_1 = sel_registerName("parser:foundCharacters:");
public static final int sel_preferredPasteboardTypeFromArray_1restrictedToTypesFromArray_1 = sel_registerName("preferredPasteboardTypeFromArray:restrictedToTypesFromArray:");
public static final int sel_resume = sel_registerName("resume");
public static final int sel_iconForFiles_1 = sel_registerName("iconForFiles:");
public static final int sel_drawKeyEquivalentWithFrame_1inView_1 = sel_registerName("drawKeyEquivalentWithFrame:inView:");
public static final int sel_boxType = sel_registerName("boxType");
public static final int sel_initWithContainerClassDescription_1containerSpecifier_1key_1name_1 = sel_registerName("initWithContainerClassDescription:containerSpecifier:key:name:");
public static final int sel_setFill = sel_registerName("setFill");
public static final int sel_setParagraphGlyphRange_1separatorGlyphRange_1 = sel_registerName("setParagraphGlyphRange:separatorGlyphRange:");
public static final int sel_copyWithZone_1 = sel_registerName("copyWithZone:");
public static final int sel_self = sel_registerName("self");
public static final int sel_reservedSpaceLength = sel_registerName("reservedSpaceLength");
public static final int sel_unsignedIntValue = sel_registerName("unsignedIntValue");
public static final int sel_URLHandleResourceDidFinishLoading_1 = sel_registerName("URLHandleResourceDidFinishLoading:");
public static final int sel_menuWillOpen_1 = sel_registerName("menuWillOpen:");
public static final int sel_menuWillClose_1 = sel_registerName("menuWillClose:");
public static final int sel_pointerArrayWithWeakObjects = sel_registerName("pointerArrayWithWeakObjects");
public static final int sel_fetchPredicate = sel_registerName("fetchPredicate");
public static final int sel_pathToColumn_1 = sel_registerName("pathToColumn:");
public static final int sel_columnWithIdentifier_1 = sel_registerName("columnWithIdentifier:");
public static final int sel_setShouldCreateUI_1 = sel_registerName("setShouldCreateUI:");
public static final int sel_getGlyphs_1range_1 = sel_registerName("getGlyphs:range:");
public static final int sel_returnID = sel_registerName("returnID");
public static final int sel_miterLimit = sel_registerName("miterLimit");
public static final int sel_hidesEmptyCells = sel_registerName("hidesEmptyCells");
public static final int sel_userSpaceScaleFactor = sel_registerName("userSpaceScaleFactor");
public static final int sel_xHeight = sel_registerName("xHeight");
public static final int sel_decimalNumberByMultiplyingBy_1withBehavior_1 = sel_registerName("decimalNumberByMultiplyingBy:withBehavior:");
public static final int sel_reloadData = sel_registerName("reloadData");
public static final int sel_setShortWeekdaySymbols_1 = sel_registerName("setShortWeekdaySymbols:");
public static final int sel_containsIndexesInRange_1 = sel_registerName("containsIndexesInRange:");
public static final int sel_colorWithDeviceRed_1green_1blue_1alpha_1 = sel_registerName("colorWithDeviceRed:green:blue:alpha:");
public static final int sel_screenFontWithRenderingMode_1 = sel_registerName("screenFontWithRenderingMode:");
public static final int sel_suggestedFilename = sel_registerName("suggestedFilename");
public static final int sel_fileNameExtensionForType_1saveOperation_1 = sel_registerName("fileNameExtensionForType:saveOperation:");
public static final int sel_labelFontSize = sel_registerName("labelFontSize");
public static final int sel_setAlphaValue_1 = sel_registerName("setAlphaValue:");
public static final int sel_openGLContext = sel_registerName("openGLContext");
public static final int sel_scriptingIsLessThan_1 = sel_registerName("scriptingIsLessThan:");
public static final int sel_keysSortedByValueUsingSelector_1 = sel_registerName("keysSortedByValueUsingSelector:");
public static final int sel_control_1didFailToValidatePartialString_1errorDescription_1 = sel_registerName("control:didFailToValidatePartialString:errorDescription:");
public static final int sel_offStateImage = sel_registerName("offStateImage");
public static final int sel_bidiProcessingEnabled = sel_registerName("bidiProcessingEnabled");
public static final int sel_isKeyWindow = sel_registerName("isKeyWindow");
public static final int sel_initWithIconRef_1 = sel_registerName("initWithIconRef:");
public static final int sel_changeCurrentDirectoryPath_1 = sel_registerName("changeCurrentDirectoryPath:");
public static final int sel_textView = sel_registerName("textView");
public static final int sel_localizedStringForStatusCode_1 = sel_registerName("localizedStringForStatusCode:");
public static final int sel_setWantsLayer_1 = sel_registerName("setWantsLayer:");
public static final int sel_positivePrefix = sel_registerName("positivePrefix");
public static final int sel_setDefaultFlatness_1 = sel_registerName("setDefaultFlatness:");
public static final int sel_addChild_1 = sel_registerName("addChild:");
public static final int sel_parser_1foundAttributeDeclarationWithName_1forElement_1type_1defaultValue_1 = sel_registerName("parser:foundAttributeDeclarationWithName:forElement:type:defaultValue:");
public static final int sel_scannerWithString_1 = sel_registerName("scannerWithString:");
public static final int sel_removeFileWrapper_1 = sel_registerName("removeFileWrapper:");
public static final int sel_setTitleWidth_1 = sel_registerName("setTitleWidth:");
public static final int sel_setTabKeyTraversesCells_1 = sel_registerName("setTabKeyTraversesCells:");
public static final int sel_glyphRangeForBoundingRect_1inTextContainer_1 = sel_registerName("glyphRangeForBoundingRect:inTextContainer:");
public static final int sel_fileHandleForWritingAtPath_1 = sel_registerName("fileHandleForWritingAtPath:");
public static final int sel_initWithContainerClassDescription_1containerSpecifier_1key_1 = sel_registerName("initWithContainerClassDescription:containerSpecifier:key:");
public static final int sel_fontAttributes = sel_registerName("fontAttributes");
public static final int sel_reviewUnsavedDocumentsWithAlertTitle_1cancellable_1delegate_1didReviewAllSelector_1contextInfo_1 = sel_registerName("reviewUnsavedDocumentsWithAlertTitle:cancellable:delegate:didReviewAllSelector:contextInfo:");
public static final int sel_minWidth = sel_registerName("minWidth");
public static final int sel_getLineFragmentInsertionPointsForCharacterAtIndex_1alternatePositions_1inDisplayOrder_1positions_1characterIndexes_1 = sel_registerName("getLineFragmentInsertionPointsForCharacterAtIndex:alternatePositions:inDisplayOrder:positions:characterIndexes:");
public static final int sel_finishDecoding = sel_registerName("finishDecoding");
public static final int sel_currentContextDrawingToScreen = sel_registerName("currentContextDrawingToScreen");
public static final int sel_setKeyEquivalent_1 = sel_registerName("setKeyEquivalent:");
public static final int sel_smartInsertForString_1replacingRange_1beforeString_1afterString_1 = sel_registerName("smartInsertForString:replacingRange:beforeString:afterString:");
public static final int sel_useStandardKerning_1 = sel_registerName("useStandardKerning:");
public static final int sel_sharedSystemTypesetter = sel_registerName("sharedSystemTypesetter");
public static final int sel_setDatePickerMode_1 = sel_registerName("setDatePickerMode:");
public static final int sel_encodePoint_1forKey_1 = sel_registerName("encodePoint:forKey:");
public static final int sel_colorSpace = sel_registerName("colorSpace");
public static final int sel_pasteboardByFilteringTypesInPasteboard_1 = sel_registerName("pasteboardByFilteringTypesInPasteboard:");
public static final int sel_sendDoubleAction = sel_registerName("sendDoubleAction");
public static final int sel_isColumnSelected_1 = sel_registerName("isColumnSelected:");
public static final int sel_unarchiveObjectWithFile_1 = sel_registerName("unarchiveObjectWithFile:");
public static final int sel_usesEPSOnResolutionMismatch = sel_registerName("usesEPSOnResolutionMismatch");
public static final int sel_encodeBycopyObject_1 = sel_registerName("encodeBycopyObject:");
public static final int sel_removeAttributeForName_1 = sel_registerName("removeAttributeForName:");
public static final int sel_keyCell = sel_registerName("keyCell");
public static final int sel_allocWithZone_1 = sel_registerName("allocWithZone:");
public static final int sel_getCompression_1factor_1 = sel_registerName("getCompression:factor:");
public static final int sel_insertValue_1inPropertyWithKey_1 = sel_registerName("insertValue:inPropertyWithKey:");
public static final int sel_drawAtPoint_1withAttributes_1 = sel_registerName("drawAtPoint:withAttributes:");
public static final int sel_isTrue = sel_registerName("isTrue");
public static final int sel_expectedContentLength = sel_registerName("expectedContentLength");
public static final int sel_setTitle_1 = sel_registerName("setTitle:");
public static final int sel_connection_1didReceiveAuthenticationChallenge_1 = sel_registerName("connection:didReceiveAuthenticationChallenge:");
public static final int sel_isEnabledForSegment_1 = sel_registerName("isEnabledForSegment:");
public static final int sel_speechSynthesizer_1willSpeakPhoneme_1 = sel_registerName("speechSynthesizer:willSpeakPhoneme:");
public static final int sel_setShowsStateColumn_1 = sel_registerName("setShowsStateColumn:");
public static final int sel_requiredFileType = sel_registerName("requiredFileType");
public static final int sel_convertRect_1fromView_1 = sel_registerName("convertRect:fromView:");
public static final int sel_visibleFrame = sel_registerName("visibleFrame");
public static final int sel_concludeDragOperation_1 = sel_registerName("concludeDragOperation:");
public static final int sel_minimumFractionDigits = sel_registerName("minimumFractionDigits");
public static final int sel_reopenDocumentForURL_1withContentsOfURL_1error_1 = sel_registerName("reopenDocumentForURL:withContentsOfURL:error:");
public static final int sel_roundingMode = sel_registerName("roundingMode");
public static final int sel_colorWithCatalogName_1colorName_1 = sel_registerName("colorWithCatalogName:colorName:");
public static final int sel_setWithSet_1 = sel_registerName("setWithSet:");
public static final int sel_fileManager_1willProcessPath_1 = sel_registerName("fileManager:willProcessPath:");
public static final int sel_setSuspended_1 = sel_registerName("setSuspended:");
public static final int sel_currentInputManager = sel_registerName("currentInputManager");
public static final int sel_operatingSystemVersionString = sel_registerName("operatingSystemVersionString");
public static final int sel_resetBytesInRange_1 = sel_registerName("resetBytesInRange:");
public static final int sel_sizeForKey_1inTable_1 = sel_registerName("sizeForKey:inTable:");
public static final int sel_setFloat_1forKey_1 = sel_registerName("setFloat:forKey:");
public static final int sel_enableUndoRegistration = sel_registerName("enableUndoRegistration");
public static final int sel_initWithCGImage_1 = sel_registerName("initWithCGImage:");
public static final int sel_initWithCIImage_1 = sel_registerName("initWithCIImage:");
public static final int sel_addCharactersInRange_1 = sel_registerName("addCharactersInRange:");
public static final int sel_initWithRect_1options_1owner_1userInfo_1 = sel_registerName("initWithRect:options:owner:userInfo:");
public static final int sel_incrementalLoadFromData_1complete_1 = sel_registerName("incrementalLoadFromData:complete:");
public static final int sel_tableView_1acceptDrop_1row_1dropOperation_1 = sel_registerName("tableView:acceptDrop:row:dropOperation:");
public static final int sel_classNamed_1 = sel_registerName("classNamed:");
public static final int sel_setIndeterminate_1 = sel_registerName("setIndeterminate:");
public static final int sel_normalizeAdjacentTextNodesPreservingCDATA_1 = sel_registerName("normalizeAdjacentTextNodesPreservingCDATA:");
public static final int sel_validateUserInterfaceItem_1 = sel_registerName("validateUserInterfaceItem:");
public static final int sel_setPlaysEveryFrame_1 = sel_registerName("setPlaysEveryFrame:");
public static final int sel_isCompiled = sel_registerName("isCompiled");
public static final int sel_tokenFieldCell_1editingStringForRepresentedObject_1 = sel_registerName("tokenFieldCell:editingStringForRepresentedObject:");
public static final int sel_tableView_1isGroupRow_1 = sel_registerName("tableView:isGroupRow:");
public static final int sel_orderFrontLinkPanel_1 = sel_registerName("orderFrontLinkPanel:");
public static final int sel_alphaControlAddedOrRemoved_1 = sel_registerName("alphaControlAddedOrRemoved:");
public static final int sel_setShadowColor_1 = sel_registerName("setShadowColor:");
public static final int sel_canBecomeKeyView = sel_registerName("canBecomeKeyView");
public static final int sel_addTimer_1forMode_1 = sel_registerName("addTimer:forMode:");
public static final int sel_clickedColumn = sel_registerName("clickedColumn");
public static final int sel_initWithName_1URI_1 = sel_registerName("initWithName:URI:");
public static final int sel_saveDocument_1 = sel_registerName("saveDocument:");
public static final int sel_observationInfo = sel_registerName("observationInfo");
public static final int sel_readFromURL_1options_1documentAttributes_1error_1 = sel_registerName("readFromURL:options:documentAttributes:error:");
public static final int sel_addClient_1 = sel_registerName("addClient:");
public static final int sel_appleEventForSuspensionID_1 = sel_registerName("appleEventForSuspensionID:");
public static final int sel_setGeneratesCalendarDates_1 = sel_registerName("setGeneratesCalendarDates:");
public static final int sel_tableView_1sortDescriptorsDidChange_1 = sel_registerName("tableView:sortDescriptorsDidChange:");
public static final int sel_predicateFormat = sel_registerName("predicateFormat");
public static final int sel_windowShouldZoom_1toFrame_1 = sel_registerName("windowShouldZoom:toFrame:");
public static final int sel_usesFontPanel = sel_registerName("usesFontPanel");
public static final int sel_encodeNXObject_1 = sel_registerName("encodeNXObject:");
public static final int sel_colorAtX_1y_1 = sel_registerName("colorAtX:y:");
public static final int sel_publishWithOptions_1 = sel_registerName("publishWithOptions:");
public static final int sel_allHTTPHeaderFields = sel_registerName("allHTTPHeaderFields");
public static final int sel_registerPort_1name_1 = sel_registerName("registerPort:name:");
public static final int sel_lineFragmentUsedRectForGlyphAtIndex_1effectiveRange_1withoutAdditionalLayout_1 = sel_registerName("lineFragmentUsedRectForGlyphAtIndex:effectiveRange:withoutAdditionalLayout:");
public static final int sel_hour = sel_registerName("hour");
public static final int sel_setTextLists_1 = sel_registerName("setTextLists:");
public static final int sel_maximumAdvancement = sel_registerName("maximumAdvancement");
public static final int sel_setHighlightedItemIndex_1 = sel_registerName("setHighlightedItemIndex:");
public static final int sel_initWithMemoryCapacity_1diskCapacity_1diskPath_1 = sel_registerName("initWithMemoryCapacity:diskCapacity:diskPath:");
public static final int sel_setDocumentContentKind_1 = sel_registerName("setDocumentContentKind:");
public static final int sel_updateDragTypeRegistration = sel_registerName("updateDragTypeRegistration");
public static final int sel_deviceDescription = sel_registerName("deviceDescription");
public static final int sel_setMiniwindowImage_1 = sel_registerName("setMiniwindowImage:");
public static final int sel_sharedTypesetter = sel_registerName("sharedTypesetter");
public static final int sel_deleteToEndOfLine_1 = sel_registerName("deleteToEndOfLine:");
public static final int sel_setState_1atRow_1column_1 = sel_registerName("setState:atRow:column:");
public static final int sel_validModesForFontPanel_1 = sel_registerName("validModesForFontPanel:");
public static final int sel_currentCalendar = sel_registerName("currentCalendar");
public static final int sel_selectionIndexPath = sel_registerName("selectionIndexPath");
public static final int sel_setTextFont_1 = sel_registerName("setTextFont:");
public static final int sel_password = sel_registerName("password");
public static final int sel_words = sel_registerName("words");
public static final int sel_status = sel_registerName("status");
public static final int sel_typingAttributes = sel_registerName("typingAttributes");
public static final int sel_handleTakeValue_1forUnboundKey_1 = sel_registerName("handleTakeValue:forUnboundKey:");
public static final int sel_image_1didLoadRepresentation_1withStatus_1 = sel_registerName("image:didLoadRepresentation:withStatus:");
public static final int sel_setBitsPerSample_1 = sel_registerName("setBitsPerSample:");
public static final int sel_sortSubviewsUsingFunction_1context_1 = sel_registerName("sortSubviewsUsingFunction:context:");
public static final int sel_initWithProtocolFamily_1socketType_1protocol_1socket_1 = sel_registerName("initWithProtocolFamily:socketType:protocol:socket:");
public static final int sel_numberOfItemsInMenu_1 = sel_registerName("numberOfItemsInMenu:");
public static final int sel_numberWithUnsignedShort_1 = sel_registerName("numberWithUnsignedShort:");
public static final int sel_textView_1menu_1forEvent_1atIndex_1 = sel_registerName("textView:menu:forEvent:atIndex:");
public static final int sel_arrowCursor = sel_registerName("arrowCursor");
public static final int sel_abbreviation = sel_registerName("abbreviation");
public static final int sel_moveDown_1 = sel_registerName("moveDown:");
public static final int sel_activateContextHelpMode_1 = sel_registerName("activateContextHelpMode:");
public static final int sel_properties = sel_registerName("properties");
public static final int sel_setObject_1forProperty_1error_1 = sel_registerName("setObject:forProperty:error:");
public static final int sel_setAutodisplay_1 = sel_registerName("setAutodisplay:");
public static final int sel_locationInWindow = sel_registerName("locationInWindow");
public static final int sel_layoutManager = sel_registerName("layoutManager");
public static final int sel_hyphenCharacterForGlyphAtIndex_1 = sel_registerName("hyphenCharacterForGlyphAtIndex:");
public static final int sel_play = sel_registerName("play");
public static final int sel_compositeToPoint_1fromRect_1operation_1fraction_1 = sel_registerName("compositeToPoint:fromRect:operation:fraction:");
public static final int sel_cellBackgroundColor = sel_registerName("cellBackgroundColor");
public static final int sel_shouldAntialias = sel_registerName("shouldAntialias");
public static final int sel_windowWillReturnFieldEditor_1toObject_1 = sel_registerName("windowWillReturnFieldEditor:toObject:");
public static final int sel_setValuesForKeysWithDictionary_1 = sel_registerName("setValuesForKeysWithDictionary:");
public static final int sel_drawsGrid = sel_registerName("drawsGrid");
public static final int sel_patternPhase = sel_registerName("patternPhase");
public static final int sel_setFrame_1 = sel_registerName("setFrame:");
public static final int sel_roundingIncrement = sel_registerName("roundingIncrement");
public static final int sel_adjustScroll_1 = sel_registerName("adjustScroll:");
public static final int sel_alertShowHelp_1 = sel_registerName("alertShowHelp:");
public static final int sel_animate_1 = sel_registerName("animate:");
public static final int sel_tabletID = sel_registerName("tabletID");
public static final int sel_selectedRowEnumerator = sel_registerName("selectedRowEnumerator");
public static final int sel_XMLString = sel_registerName("XMLString");
public static final int sel_setWarningValue_1 = sel_registerName("setWarningValue:");
public static final int sel_tableView_1validateDrop_1proposedRow_1proposedDropOperation_1 = sel_registerName("tableView:validateDrop:proposedRow:proposedDropOperation:");
public static final int sel_checkSpelling_1 = sel_registerName("checkSpelling:");
public static final int sel_setFormattingStringsFilename_1 = sel_registerName("setFormattingStringsFilename:");
public static final int sel_displayIfNeeded = sel_registerName("displayIfNeeded");
public static final int sel_localizedName = sel_registerName("localizedName");
public static final int sel_isEqualToSet_1 = sel_registerName("isEqualToSet:");
public static final int sel_initWithBytesNoCopy_1length_1encoding_1freeWhenDone_1 = sel_registerName("initWithBytesNoCopy:length:encoding:freeWhenDone:");
public static final int sel_reloadPredicate = sel_registerName("reloadPredicate");
public static final int sel_setNumberOfMajorTickMarks_1 = sel_registerName("setNumberOfMajorTickMarks:");
public static final int sel_defaultPlaceholderForMarker_1withBinding_1 = sel_registerName("defaultPlaceholderForMarker:withBinding:");
public static final int sel_encodeDataObject_1 = sel_registerName("encodeDataObject:");
public static final int sel_writeToURL_1ofType_1 = sel_registerName("writeToURL:ofType:");
public static final int sel_createContext = sel_registerName("createContext");
public static final int sel_verticalScroller = sel_registerName("verticalScroller");
public static final int sel_setShowsInvisibleCharacters_1 = sel_registerName("setShowsInvisibleCharacters:");
public static final int sel_encodeConditionalObject_1forKey_1 = sel_registerName("encodeConditionalObject:forKey:");
public static final int sel_isEqualTo_1 = sel_registerName("isEqualTo:");
public static final int sel_translateXBy_1yBy_1 = sel_registerName("translateXBy:yBy:");
public static final int sel_customizationPaletteIsRunning = sel_registerName("customizationPaletteIsRunning");
public static final int sel_dictionaryWithDictionary_1 = sel_registerName("dictionaryWithDictionary:");
public static final int sel_drawMarkersInRect_1 = sel_registerName("drawMarkersInRect:");
public static final int sel_centerSelectionInVisibleArea_1 = sel_registerName("centerSelectionInVisibleArea:");
public static final int sel_stringByAppendingString_1 = sel_registerName("stringByAppendingString:");
public static final int sel_flushWindowIfNeeded = sel_registerName("flushWindowIfNeeded");
public static final int sel_lockFocusOnRepresentation_1 = sel_registerName("lockFocusOnRepresentation:");
public static final int sel_setNotShownAttribute_1forGlyphAtIndex_1 = sel_registerName("setNotShownAttribute:forGlyphAtIndex:");
public static final int sel_currentReplyAppleEvent = sel_registerName("currentReplyAppleEvent");
public static final int sel_setTitleAlignment_1 = sel_registerName("setTitleAlignment:");
public static final int sel_removeSuiteNamed_1 = sel_registerName("removeSuiteNamed:");
public static final int sel_capitalizedString = sel_registerName("capitalizedString");
public static final int sel_typeFromFileExtension_1 = sel_registerName("typeFromFileExtension:");
public static final int sel_allowsImageEditing = sel_registerName("allowsImageEditing");
public static final int sel_loosenKerning_1 = sel_registerName("loosenKerning:");
public static final int sel_decomposableCharacterSet = sel_registerName("decomposableCharacterSet");
public static final int sel_subdataWithRange_1 = sel_registerName("subdataWithRange:");
public static final int sel_attachPopUpWithFrame_1inView_1 = sel_registerName("attachPopUpWithFrame:inView:");
public static final int sel_setColumnResizingType_1 = sel_registerName("setColumnResizingType:");
public static final int sel_genericCMYKColorSpace = sel_registerName("genericCMYKColorSpace");
public static final int sel_actionForControlCharacterAtIndex_1 = sel_registerName("actionForControlCharacterAtIndex:");
public static final int sel_documentRect = sel_registerName("documentRect");
public static final int sel_dataWithContentsOfFile_1 = sel_registerName("dataWithContentsOfFile:");
public static final int sel_localizedDescriptionForType_1 = sel_registerName("localizedDescriptionForType:");
public static final int sel_increment = sel_registerName("increment");
public static final int sel_deleteToEndOfParagraph_1 = sel_registerName("deleteToEndOfParagraph:");
public static final int sel_exceptionWithName_1reason_1userInfo_1 = sel_registerName("exceptionWithName:reason:userInfo:");
public static final int sel_postscriptName = sel_registerName("postscriptName");
public static final int sel_setPreferredFilename_1 = sel_registerName("setPreferredFilename:");
public static final int sel_setPostsBoundsChangedNotifications_1 = sel_registerName("setPostsBoundsChangedNotifications:");
public static final int sel_decimalNumberHandlerWithRoundingMode_1scale_1raiseOnExactness_1raiseOnOverflow_1raiseOnUnderflow_1raiseOnDivideByZero_1 = sel_registerName("decimalNumberHandlerWithRoundingMode:scale:raiseOnExactness:raiseOnOverflow:raiseOnUnderflow:raiseOnDivideByZero:");
public static final int sel_openDocumentWithContentsOfFile_1display_1 = sel_registerName("openDocumentWithContentsOfFile:display:");
public static final int sel_objectForInfoDictionaryKey_1 = sel_registerName("objectForInfoDictionaryKey:");
public static final int sel_setFrameOrigin_1 = sel_registerName("setFrameOrigin:");
public static final int sel_pathControl_1willPopUpMenu_1 = sel_registerName("pathControl:willPopUpMenu:");
public static final int sel_lineWidth = sel_registerName("lineWidth");
public static final int sel_poseAsClass_1 = sel_registerName("poseAsClass:");
public static final int sel_selectPreviousKeyView_1 = sel_registerName("selectPreviousKeyView:");
public static final int sel_isKey_1inTable_1 = sel_registerName("isKey:inTable:");
public static final int sel_isZoomed = sel_registerName("isZoomed");
public static final int sel_setCompletionDelay_1 = sel_registerName("setCompletionDelay:");
public static final int sel_mainMenu = sel_registerName("mainMenu");
public static final int sel_scrollView = sel_registerName("scrollView");
public static final int sel_dividerColor = sel_registerName("dividerColor");
public static final int sel_requestModes = sel_registerName("requestModes");
public static final int sel_setShowsResizeIndicator_1 = sel_registerName("setShowsResizeIndicator:");
public static final int sel_setScrollable_1 = sel_registerName("setScrollable:");
public static final int sel_setLineScroll_1 = sel_registerName("setLineScroll:");
public static final int sel_resolvePrefixForNamespaceURI_1 = sel_registerName("resolvePrefixForNamespaceURI:");
public static final int sel_bind_1toObject_1withKeyPath_1options_1 = sel_registerName("bind:toObject:withKeyPath:options:");
public static final int sel_alignCenter_1 = sel_registerName("alignCenter:");
public static final int sel_addTemporaryAttribute_1value_1forCharacterRange_1 = sel_registerName("addTemporaryAttribute:value:forCharacterRange:");
public static final int sel_expressionForConstantValue_1 = sel_registerName("expressionForConstantValue:");
public static final int sel_initWithContentSize_1preferredEdge_1 = sel_registerName("initWithContentSize:preferredEdge:");
public static final int sel_setAccessoryView_1 = sel_registerName("setAccessoryView:");
public static final int sel_setContentWidth_1type_1 = sel_registerName("setContentWidth:type:");
public static final int sel_searchMenuTemplate = sel_registerName("searchMenuTemplate");
public static final int sel_imageRepClassForType_1 = sel_registerName("imageRepClassForType:");
public static final int sel_decimalValue = sel_registerName("decimalValue");
public static final int sel_protocolSpecificInformation = sel_registerName("protocolSpecificInformation");
public static final int sel_statusBar = sel_registerName("statusBar");
public static final int sel_setTimeZone_1 = sel_registerName("setTimeZone:");
public static final int sel_setWidth_1forSegment_1 = sel_registerName("setWidth:forSegment:");
public static final int sel_objectIsForcedForKey_1inDomain_1 = sel_registerName("objectIsForcedForKey:inDomain:");
public static final int sel_evaluationErrorSpecifier = sel_registerName("evaluationErrorSpecifier");
public static final int sel_application_1openFile_1 = sel_registerName("application:openFile:");
public static final int sel_changeDocumentBackgroundColor_1 = sel_registerName("changeDocumentBackgroundColor:");
public static final int sel_volatileDomainNames = sel_registerName("volatileDomainNames");
public static final int sel_changeInLength = sel_registerName("changeInLength");
public static final int sel_autoresizingMask = sel_registerName("autoresizingMask");
public static final int sel_setRepresentedObject_1 = sel_registerName("setRepresentedObject:");
public static final int sel_isUndoRegistrationEnabled = sel_registerName("isUndoRegistrationEnabled");
public static final int sel_alertWithError_1 = sel_registerName("alertWithError:");
public static final int sel_saturationComponent = sel_registerName("saturationComponent");
public static final int sel_spellServer_1didLearnWord_1inLanguage_1 = sel_registerName("spellServer:didLearnWord:inLanguage:");
public static final int sel_performActionWithHighlightingForItemAtIndex_1 = sel_registerName("performActionWithHighlightingForItemAtIndex:");
public static final int sel_loadSuitesFromBundle_1 = sel_registerName("loadSuitesFromBundle:");
public static final int sel_firstTextView = sel_registerName("firstTextView");
public static final int sel_targetForAction_1 = sel_registerName("targetForAction:");
public static final int sel_enterExitEventWithType_1location_1modifierFlags_1timestamp_1windowNumber_1context_1eventNumber_1trackingNumber_1userData_1 = sel_registerName("enterExitEventWithType:location:modifierFlags:timestamp:windowNumber:context:eventNumber:trackingNumber:userData:");
public static final int sel_setHelpAnchor_1 = sel_registerName("setHelpAnchor:");
public static final int sel_printerWithName_1 = sel_registerName("printerWithName:");
public static final int sel_boundingBoxForControlGlyphAtIndex_1forTextContainer_1proposedLineFragment_1glyphPosition_1characterIndex_1 = sel_registerName("boundingBoxForControlGlyphAtIndex:forTextContainer:proposedLineFragment:glyphPosition:characterIndex:");
public static final int sel_initWithBytesNoCopy_1length_1freeWhenDone_1 = sel_registerName("initWithBytesNoCopy:length:freeWhenDone:");
public static final int sel_getRow_1column_1ofCell_1 = sel_registerName("getRow:column:ofCell:");
public static final int sel_smartDeleteRangeForProposedRange_1 = sel_registerName("smartDeleteRangeForProposedRange:");
public static final int sel_getHue_1saturation_1brightness_1alpha_1 = sel_registerName("getHue:saturation:brightness:alpha:");
public static final int sel_automaticallyNotifiesObserversForKey_1 = sel_registerName("automaticallyNotifiesObserversForKey:");
public static final int sel_setAllowsImageEditing_1 = sel_registerName("setAllowsImageEditing:");
public static final int sel_draggingUpdated_1 = sel_registerName("draggingUpdated:");
public static final int sel_insertRowAtIndex_1withType_1asSubrowOfRow_1animate_1 = sel_registerName("insertRowAtIndex:withType:asSubrowOfRow:animate:");
public static final int sel_getRectsExposedDuringLiveResize_1count_1 = sel_registerName("getRectsExposedDuringLiveResize:count:");
public static final int sel_usesSignificantDigits = sel_registerName("usesSignificantDigits");
public static final int sel_numberOfVirtualScreens = sel_registerName("numberOfVirtualScreens");
public static final int sel_sendSynchronousRequest_1returningResponse_1error_1 = sel_registerName("sendSynchronousRequest:returningResponse:error:");
public static final int sel_setBecomesKeyOnlyIfNeeded_1 = sel_registerName("setBecomesKeyOnlyIfNeeded:");
public static final int sel_autorecalculatesKeyViewLoop = sel_registerName("autorecalculatesKeyViewLoop");
public static final int sel_decodeDataObject = sel_registerName("decodeDataObject");
public static final int sel_setOriginOffset_1 = sel_registerName("setOriginOffset:");
public static final int sel_pointingDeviceSerialNumber = sel_registerName("pointingDeviceSerialNumber");
public static final int sel_drawSegment_1inFrame_1withView_1 = sel_registerName("drawSegment:inFrame:withView:");
public static final int sel_close = sel_registerName("close");
public static final int sel_setAlignmentRect_1 = sel_registerName("setAlignmentRect:");
public static final int sel_paragraphSeparatorCharacterRange = sel_registerName("paragraphSeparatorCharacterRange");
public static final int sel_measurementUnits = sel_registerName("measurementUnits");
public static final int sel_setUsesEPSOnResolutionMismatch_1 = sel_registerName("setUsesEPSOnResolutionMismatch:");
public static final int sel_setLineFragmentPadding_1 = sel_registerName("setLineFragmentPadding:");
public static final int sel_setLastComponentOfFileName_1 = sel_registerName("setLastComponentOfFileName:");
public static final int sel_initWithSuiteName_1commandName_1dictionary_1 = sel_registerName("initWithSuiteName:commandName:dictionary:");
public static final int sel_initWithContent_1 = sel_registerName("initWithContent:");
public static final int sel_provideNewView_1 = sel_registerName("provideNewView:");
public static final int sel_pathComponentCells = sel_registerName("pathComponentCells");
public static final int sel_instanceMethodForSelector_1 = sel_registerName("instanceMethodForSelector:");
public static final int sel_layoutManagerDidInvalidateLayout_1 = sel_registerName("layoutManagerDidInvalidateLayout:");
public static final int sel_helpAnchor = sel_registerName("helpAnchor");
public static final int sel_URLProtocol_1wasRedirectedToRequest_1redirectResponse_1 = sel_registerName("URLProtocol:wasRedirectedToRequest:redirectResponse:");
public static final int sel_setIsVisible_1 = sel_registerName("setIsVisible:");
public static final int sel_browser_1sizeToFitWidthOfColumn_1 = sel_registerName("browser:sizeToFitWidthOfColumn:");
public static final int sel_handleFailureInMethod_1object_1file_1lineNumber_1description_1 = sel_registerName("handleFailureInMethod:object:file:lineNumber:description:");
public static final int sel_serializedRepresentation = sel_registerName("serializedRepresentation");
public static final int sel_replaceTextContainer_1 = sel_registerName("replaceTextContainer:");
public static final int sel_speechSynthesizer_1willSpeakWord_1ofString_1 = sel_registerName("speechSynthesizer:willSpeakWord:ofString:");
public static final int sel_startSpeaking_1 = sel_registerName("startSpeaking:");
public static final int sel_setHyphenationFactor_1 = sel_registerName("setHyphenationFactor:");
public static final int sel_retain = sel_registerName("retain");
public static final int sel_insertItem_1atIndex_1 = sel_registerName("insertItem:atIndex:");
public static final int sel_sortWithSortDescriptors_1recursively_1 = sel_registerName("sortWithSortDescriptors:recursively:");
public static final int sel_selectTabViewItem_1 = sel_registerName("selectTabViewItem:");
public static final int sel_clipRect_1 = sel_registerName("clipRect:");
public static final int sel_close_1 = sel_registerName("close:");
public static final int sel_didAddSubview_1 = sel_registerName("didAddSubview:");
public static final int sel_markedTextSelectionChanged_1client_1 = sel_registerName("markedTextSelectionChanged:client:");
public static final int sel_registerLanguage_1byVendor_1 = sel_registerName("registerLanguage:byVendor:");
public static final int sel_removeClient_1 = sel_registerName("removeClient:");
public static final int sel_setSendsWholeSearchString_1 = sel_registerName("setSendsWholeSearchString:");
public static final int sel_localName = sel_registerName("localName");
public static final int sel_setSelectedSegment_1 = sel_registerName("setSelectedSegment:");
public static final int sel_setLineHeightMultiple_1 = sel_registerName("setLineHeightMultiple:");
public static final int sel_setCanCreateDirectories_1 = sel_registerName("setCanCreateDirectories:");
public static final int sel_setCookieAcceptPolicy_1 = sel_registerName("setCookieAcceptPolicy:");
public static final int sel_convertFont_1toHaveTrait_1 = sel_registerName("convertFont:toHaveTrait:");
public static final int sel_headerCell = sel_registerName("headerCell");
public static final int sel_maximumDecimalNumber = sel_registerName("maximumDecimalNumber");
public static final int sel_browser_1isColumnValid_1 = sel_registerName("browser:isColumnValid:");
public static final int sel_tableViewSelectionIsChanging_1 = sel_registerName("tableViewSelectionIsChanging:");
public static final int sel_setNotificationBatchingInterval_1 = sel_registerName("setNotificationBatchingInterval:");
public static final int sel_isLeaf = sel_registerName("isLeaf");
public static final int sel_valuesForAttributes_1 = sel_registerName("valuesForAttributes:");
public static final int sel_removeTemporaryAttribute_1forCharacterRange_1 = sel_registerName("removeTemporaryAttribute:forCharacterRange:");
public static final int sel_pixelsWide = sel_registerName("pixelsWide");
public static final int sel_orderFrontStandardAboutPanel_1 = sel_registerName("orderFrontStandardAboutPanel:");
public static final int sel_beginSheetModalForWindow_1modalDelegate_1didEndSelector_1contextInfo_1 = sel_registerName("beginSheetModalForWindow:modalDelegate:didEndSelector:contextInfo:");
public static final int sel_setToolTip_1forSegment_1 = sel_registerName("setToolTip:forSegment:");
public static final int sel_canonicalXMLStringPreservingComments_1 = sel_registerName("canonicalXMLStringPreservingComments:");
public static final int sel_orderFrontListPanel_1 = sel_registerName("orderFrontListPanel:");
public static final int sel_setIsMiniaturized_1 = sel_registerName("setIsMiniaturized:");
public static final int sel_download_1didReceiveDataOfLength_1 = sel_registerName("download:didReceiveDataOfLength:");
public static final int sel_layoutManager_1didCompleteLayoutForTextContainer_1atEnd_1 = sel_registerName("layoutManager:didCompleteLayoutForTextContainer:atEnd:");
public static final int sel_standardWindowButton_1forStyleMask_1 = sel_registerName("standardWindowButton:forStyleMask:");
public static final int sel_writeToURL_1atomically_1 = sel_registerName("writeToURL:atomically:");
public static final int sel_useStandardLigatures_1 = sel_registerName("useStandardLigatures:");
public static final int sel_currentRunLoop = sel_registerName("currentRunLoop");
public static final int sel_setExtraLineFragmentRect_1usedRect_1textContainer_1 = sel_registerName("setExtraLineFragmentRect:usedRect:textContainer:");
public static final int sel_rootElement = sel_registerName("rootElement");
public static final int sel_setContentViewMargins_1 = sel_registerName("setContentViewMargins:");
public static final int sel_cancelPerformSelector_1target_1argument_1 = sel_registerName("cancelPerformSelector:target:argument:");
public static final int sel_outputFormat = sel_registerName("outputFormat");
public static final int sel_arrayWithContentsOfFile_1 = sel_registerName("arrayWithContentsOfFile:");
public static final int sel_applicationWillFinishLaunching_1 = sel_registerName("applicationWillFinishLaunching:");
public static final int sel_prefixForName_1 = sel_registerName("prefixForName:");
public static final int sel_decimalNumberByDividingBy_1 = sel_registerName("decimalNumberByDividingBy:");
public static final int sel_mouseUpOnCharacterIndex_1atCoordinate_1withModifier_1client_1 = sel_registerName("mouseUpOnCharacterIndex:atCoordinate:withModifier:client:");
public static final int sel_defaultVoice = sel_registerName("defaultVoice");
public static final int sel_operand = sel_registerName("operand");
public static final int sel_moveToEndOfLine_1 = sel_registerName("moveToEndOfLine:");
public static final int sel_addEntry_1 = sel_registerName("addEntry:");
public static final int sel_scaleBy_1 = sel_registerName("scaleBy:");
public static final int sel_setMnemonicLocation_1 = sel_registerName("setMnemonicLocation:");
public static final int sel_dateWithCalendarFormat_1timeZone_1 = sel_registerName("dateWithCalendarFormat:timeZone:");
public static final int sel_setUsesFontLeading_1 = sel_registerName("setUsesFontLeading:");
public static final int sel_CIContext = sel_registerName("CIContext");
public static final int sel_isDaylightSavingTime = sel_registerName("isDaylightSavingTime");
public static final int sel_setShowsBorderOnlyWhileMouseInside_1 = sel_registerName("setShowsBorderOnlyWhileMouseInside:");
public static final int sel_isSetOnMouseEntered = sel_registerName("isSetOnMouseEntered");
public static final int sel_stringFromDate_1 = sel_registerName("stringFromDate:");
public static final int sel_deselectColumn_1 = sel_registerName("deselectColumn:");
public static final int sel_requestHeaderFieldsWithCookies_1 = sel_registerName("requestHeaderFieldsWithCookies:");
public static final int sel_outlineViewColumnDidMove_1 = sel_registerName("outlineViewColumnDidMove:");
public static final int sel_fileExtensionsFromType_1 = sel_registerName("fileExtensionsFromType:");
public static final int sel_setUsesScreenFonts_1 = sel_registerName("setUsesScreenFonts:");
public static final int sel_commandDescriptionsInSuite_1 = sel_registerName("commandDescriptionsInSuite:");
public static final int sel_notShownAttributeForGlyphAtIndex_1 = sel_registerName("notShownAttributeForGlyphAtIndex:");
public static final int sel_isRunning = sel_registerName("isRunning");
public static final int sel_sharedPrintInfo = sel_registerName("sharedPrintInfo");
public static final int sel_isValid = sel_registerName("isValid");
public static final int sel_handleFailureInFunction_1file_1lineNumber_1description_1 = sel_registerName("handleFailureInFunction:file:lineNumber:description:");
public static final int sel_localizedRecoveryOptions = sel_registerName("localizedRecoveryOptions");
public static final int sel_establishConnection = sel_registerName("establishConnection");
public static final int sel_isMainWindow = sel_registerName("isMainWindow");
public static final int sel_setDrawsBackground_1 = sel_registerName("setDrawsBackground:");
public static final int sel_intAttribute_1forGlyphAtIndex_1 = sel_registerName("intAttribute:forGlyphAtIndex:");
public static final int sel_shadowColor = sel_registerName("shadowColor");
public static final int sel_keyEquivalentModifierMask = sel_registerName("keyEquivalentModifierMask");
public static final int sel_textStorageDidProcessEditing_1 = sel_registerName("textStorageDidProcessEditing:");
public static final int sel_setType_1 = sel_registerName("setType:");
public static final int sel_previousSibling = sel_registerName("previousSibling");
public static final int sel_dateByAddingYears_1months_1days_1hours_1minutes_1seconds_1 = sel_registerName("dateByAddingYears:months:days:hours:minutes:seconds:");
public static final int sel_setMinimum_1 = sel_registerName("setMinimum:");
public static final int sel_columnAutoresizingStyle = sel_registerName("columnAutoresizingStyle");
public static final int sel_convertPointFromBase_1 = sel_registerName("convertPointFromBase:");
public static final int sel_layout = sel_registerName("layout");
public static final int sel_textStorage = sel_registerName("textStorage");
public static final int sel_values = sel_registerName("values");
public static final int sel_RTFFromRange_1documentAttributes_1 = sel_registerName("RTFFromRange:documentAttributes:");
public static final int sel_isMiniaturizable = sel_registerName("isMiniaturizable");
public static final int sel_opaqueAncestor = sel_registerName("opaqueAncestor");
public static final int sel_notationName = sel_registerName("notationName");
public static final int sel_setBaseWritingDirection_1range_1 = sel_registerName("setBaseWritingDirection:range:");
public static final int sel_setManagedObjectContext_1 = sel_registerName("setManagedObjectContext:");
public static final int sel_patternImage = sel_registerName("patternImage");
public static final int sel_windowDidResize_1 = sel_registerName("windowDidResize:");
public static final int sel_setFieldEditor_1 = sel_registerName("setFieldEditor:");
public static final int sel_initWithContainerClassDescription_1containerSpecifier_1key_1relativePosition_1baseSpecifier_1 = sel_registerName("initWithContainerClassDescription:containerSpecifier:key:relativePosition:baseSpecifier:");
public static final int sel_setMainMenu_1 = sel_registerName("setMainMenu:");
public static final int sel_setObjectZone_1 = sel_registerName("setObjectZone:");
public static final int sel_localizedDescription = sel_registerName("localizedDescription");
public static final int sel_setImageScaling_1 = sel_registerName("setImageScaling:");
public static final int sel_moveToBeginningOfLine_1 = sel_registerName("moveToBeginningOfLine:");
public static final int sel_transposeWords_1 = sel_registerName("transposeWords:");
public static final int sel_protocol = sel_registerName("protocol");
public static final int sel_isHorizontallyCentered = sel_registerName("isHorizontallyCentered");
public static final int sel_invert = sel_registerName("invert");
public static final int sel_isEqualToValue_1 = sel_registerName("isEqualToValue:");
public static final int sel_registerName_1withNameServer_1 = sel_registerName("registerName:withNameServer:");
public static final int sel_writeToURL_1ofType_1error_1 = sel_registerName("writeToURL:ofType:error:");
public static final int sel_rangeForUserTextChange = sel_registerName("rangeForUserTextChange");
public static final int sel_configurePersistentStoreCoordinatorForURL_1ofType_1error_1 = sel_registerName("configurePersistentStoreCoordinatorForURL:ofType:error:");
public static final int sel_setShouldAntialias_1 = sel_registerName("setShouldAntialias:");
public static final int sel_alignmentRect = sel_registerName("alignmentRect");
public static final int sel_zoom_1 = sel_registerName("zoom:");
public static final int sel_rate = sel_registerName("rate");
public static final int sel_maxVisibleColumns = sel_registerName("maxVisibleColumns");
public static final int sel_splitViewDidResizeSubviews_1 = sel_registerName("splitViewDidResizeSubviews:");
public static final int sel_maxWidth = sel_registerName("maxWidth");
public static final int sel_setData_1 = sel_registerName("setData:");
public static final int sel_isVisible = sel_registerName("isVisible");
public static final int sel_isSelected = sel_registerName("isSelected");
public static final int sel_rulerView_1shouldRemoveMarker_1 = sel_registerName("rulerView:shouldRemoveMarker:");
public static final int sel_setURL_1 = sel_registerName("setURL:");
public static final int sel_drawTitle_1withFrame_1inView_1 = sel_registerName("drawTitle:withFrame:inView:");
public static final int sel_usesWeakReadAndWriteBarriers = sel_registerName("usesWeakReadAndWriteBarriers");
public static final int sel_elementDeclarationForName_1 = sel_registerName("elementDeclarationForName:");
public static final int sel_setOneShot_1 = sel_registerName("setOneShot:");
public static final int sel_shouldProcessNamespaces = sel_registerName("shouldProcessNamespaces");
public static final int sel_isEqualToArray_1 = sel_registerName("isEqualToArray:");
public static final int sel_XMLStringWithOptions_1 = sel_registerName("XMLStringWithOptions:");
public static final int sel_initFileURLWithPath_1isDirectory_1 = sel_registerName("initFileURLWithPath:isDirectory:");
public static final int sel_datePickerElements = sel_registerName("datePickerElements");
public static final int sel_willChange_1valuesAtIndexes_1forKey_1 = sel_registerName("willChange:valuesAtIndexes:forKey:");
public static final int sel_setSelected_1forSegment_1 = sel_registerName("setSelected:forSegment:");
public static final int sel_initWithFormat_1shareContext_1 = sel_registerName("initWithFormat:shareContext:");
public static final int sel_browser_1shouldSizeColumn_1forUserResize_1toWidth_1 = sel_registerName("browser:shouldSizeColumn:forUserResize:toWidth:");
public static final int sel_indexSetWithIndexesInRange_1 = sel_registerName("indexSetWithIndexesInRange:");
public static final int sel_netServiceBrowser_1didFindService_1moreComing_1 = sel_registerName("netServiceBrowser:didFindService:moreComing:");
public static final int sel_keyUp_1 = sel_registerName("keyUp:");
public static final int sel_pageHeader = sel_registerName("pageHeader");
public static final int sel_isCancelled = sel_registerName("isCancelled");
public static final int sel_segmentStyle = sel_registerName("segmentStyle");
public static final int sel_imageRepWithContentsOfURL_1 = sel_registerName("imageRepWithContentsOfURL:");
public static final int sel_initWithNibName_1bundle_1 = sel_registerName("initWithNibName:bundle:");
public static final int sel_removeObserver_1fromObjectsAtIndexes_1forKeyPath_1 = sel_registerName("removeObserver:fromObjectsAtIndexes:forKeyPath:");
public static final int sel_setFetchPredicate_1 = sel_registerName("setFetchPredicate:");
public static final int sel_compare_1options_1range_1 = sel_registerName("compare:options:range:");
public static final int sel_validateVisibleColumns = sel_registerName("validateVisibleColumns");
public static final int sel_initWithCGColorSpace_1 = sel_registerName("initWithCGColorSpace:");
public static final int sel_mountNewRemovableMedia = sel_registerName("mountNewRemovableMedia");
public static final int sel_compare_1options_1range_1locale_1 = sel_registerName("compare:options:range:locale:");
public static final int sel_setTopMargin_1 = sel_registerName("setTopMargin:");
public static final int sel_maximumLengthOfBytesUsingEncoding_1 = sel_registerName("maximumLengthOfBytesUsingEncoding:");
public static final int sel_colorWithAlphaComponent_1 = sel_registerName("colorWithAlphaComponent:");
public static final int sel_appendBezierPathWithRoundedRect_1xRadius_1yRadius_1 = sel_registerName("appendBezierPathWithRoundedRect:xRadius:yRadius:");
public static final int sel_autosavedContentsFileURL = sel_registerName("autosavedContentsFileURL");
public static final int sel_markedTextAttributes = sel_registerName("markedTextAttributes");
public static final int sel_predicateWithValue_1 = sel_registerName("predicateWithValue:");
public static final int sel_makeFirstResponder_1 = sel_registerName("makeFirstResponder:");
public static final int sel_alternateTitle = sel_registerName("alternateTitle");
public static final int sel_attribute = sel_registerName("attribute");
public static final int sel_decodeIntegerForKey_1 = sel_registerName("decodeIntegerForKey:");
public static final int sel_setSeparatesColumns_1 = sel_registerName("setSeparatesColumns:");
public static final int sel_imageRepsWithContentsOfURL_1 = sel_registerName("imageRepsWithContentsOfURL:");
public static final int sel_isPlanar = sel_registerName("isPlanar");
public static final int sel_download_1didReceiveAuthenticationChallenge_1 = sel_registerName("download:didReceiveAuthenticationChallenge:");
public static final int sel_startingRow = sel_registerName("startingRow");
public static final int sel_evaluateWithObject_1substitutionVariables_1 = sel_registerName("evaluateWithObject:substitutionVariables:");
public static final int sel_initWithRTFD_1documentAttributes_1 = sel_registerName("initWithRTFD:documentAttributes:");
public static final int sel_ensureLayoutForTextContainer_1 = sel_registerName("ensureLayoutForTextContainer:");
public static final int sel_runModalForWindow_1relativeToWindow_1 = sel_registerName("runModalForWindow:relativeToWindow:");
public static final int sel_isResizable = sel_registerName("isResizable");
public static final int sel_isSymbolicLink = sel_registerName("isSymbolicLink");
public static final int sel_containsIndexes_1 = sel_registerName("containsIndexes:");
public static final int sel_splitView_1constrainMaxCoordinate_1ofSubviewAt_1 = sel_registerName("splitView:constrainMaxCoordinate:ofSubviewAt:");
public static final int sel_setImportsGraphics_1 = sel_registerName("setImportsGraphics:");
public static final int sel_action = sel_registerName("action");
public static final int sel_noteNumberOfItemsChanged = sel_registerName("noteNumberOfItemsChanged");
public static final int sel_drawBackgroundInClipRect_1 = sel_registerName("drawBackgroundInClipRect:");
public static final int sel_booleanValue = sel_registerName("booleanValue");
public static final int sel_printInfo = sel_registerName("printInfo");
public static final int sel_performSelector_1withObject_1afterDelay_1 = sel_registerName("performSelector:withObject:afterDelay:");
public static final int sel_boundingRectForGlyphRange_1inTextContainer_1 = sel_registerName("boundingRectForGlyphRange:inTextContainer:");
public static final int sel_currencyCode = sel_registerName("currencyCode");
public static final int sel_splitView_1canCollapseSubview_1 = sel_registerName("splitView:canCollapseSubview:");
public static final int sel_hide = sel_registerName("hide");
public static final int sel_setMonth_1 = sel_registerName("setMonth:");
public static final int sel_dataFromTXTRecordDictionary_1 = sel_registerName("dataFromTXTRecordDictionary:");
public static final int sel_rulerView_1didAddMarker_1 = sel_registerName("rulerView:didAddMarker:");
public static final int sel_deleteBackward_1 = sel_registerName("deleteBackward:");
public static final int sel_setMaximumLineHeight_1 = sel_registerName("setMaximumLineHeight:");
public static final int sel_orderedWindows = sel_registerName("orderedWindows");
public static final int sel_standaloneWeekdaySymbols = sel_registerName("standaloneWeekdaySymbols");
public static final int sel_isAttached = sel_registerName("isAttached");
public static final int sel_resizeLeftRightCursor = sel_registerName("resizeLeftRightCursor");
public static final int sel_methodSignature = sel_registerName("methodSignature");
public static final int sel_setDiskCapacity_1 = sel_registerName("setDiskCapacity:");
public static final int sel_lineFragmentRectForGlyphAtIndex_1effectiveRange_1withoutAdditionalLayout_1 = sel_registerName("lineFragmentRectForGlyphAtIndex:effectiveRange:withoutAdditionalLayout:");
public static final int sel_screen = sel_registerName("screen");
public static final int sel_windowNumber = sel_registerName("windowNumber");
public static final int sel_selectSegmentWithTag_1 = sel_registerName("selectSegmentWithTag:");
public static final int sel_availableFontFamilies = sel_registerName("availableFontFamilies");
public static final int sel_superclass = sel_registerName("superclass");
public static final int sel_registeredImageRepClasses = sel_registerName("registeredImageRepClasses");
public static final int sel_needsSizing = sel_registerName("needsSizing");
public static final int sel_setUsesAlternatingRowBackgroundColors_1 = sel_registerName("setUsesAlternatingRowBackgroundColors:");
public static final int sel_getBitmapDataPlanes_1 = sel_registerName("getBitmapDataPlanes:");
public static final int sel_fontWithFamily_1traits_1weight_1size_1 = sel_registerName("fontWithFamily:traits:weight:size:");
public static final int sel_borderColor = sel_registerName("borderColor");
public static final int sel_colorUsingColorSpace_1 = sel_registerName("colorUsingColorSpace:");
public static final int sel_propertyForKey_1 = sel_registerName("propertyForKey:");
public static final int sel_setPublicID_1 = sel_registerName("setPublicID:");
public static final int sel_forwardInvocation_1 = sel_registerName("forwardInvocation:");
public static final int sel_deleteToBeginningOfLine_1 = sel_registerName("deleteToBeginningOfLine:");
public static final int sel_hasNonContiguousLayout = sel_registerName("hasNonContiguousLayout");
public static final int sel_getObjects_1 = sel_registerName("getObjects:");
public static final int sel_clearRecentDocuments_1 = sel_registerName("clearRecentDocuments:");
public static final int sel_paletteFontOfSize_1 = sel_registerName("paletteFontOfSize:");
public static final int sel_rightMargin = sel_registerName("rightMargin");
public static final int sel_browser_1createRowsForColumn_1inMatrix_1 = sel_registerName("browser:createRowsForColumn:inMatrix:");
public static final int sel_removeItemAtPath_1error_1 = sel_registerName("removeItemAtPath:error:");
public static final int sel_getRectsBeingDrawn_1count_1 = sel_registerName("getRectsBeingDrawn:count:");
public static final int sel_numberWithUnsignedInt_1 = sel_registerName("numberWithUnsignedInt:");
public static final int sel_complete_1 = sel_registerName("complete:");
public static final int sel_synchronizeTitleAndSelectedItem = sel_registerName("synchronizeTitleAndSelectedItem");
public static final int sel_archiverData = sel_registerName("archiverData");
public static final int sel_selectNextTabViewItem_1 = sel_registerName("selectNextTabViewItem:");
public static final int sel_displayNameForType_1 = sel_registerName("displayNameForType:");
public static final int sel_defaultNameServerPortNumber = sel_registerName("defaultNameServerPortNumber");
public static final int sel_setFireDate_1 = sel_registerName("setFireDate:");
public static final int sel_selectFirstTabViewItem_1 = sel_registerName("selectFirstTabViewItem:");
public static final int sel_setRightMargin_1 = sel_registerName("setRightMargin:");
public static final int sel_menuView = sel_registerName("menuView");
public static final int sel_removeObjectsFromIndices_1numIndices_1 = sel_registerName("removeObjectsFromIndices:numIndices:");
public static final int sel_tabKeyTraversesCells = sel_registerName("tabKeyTraversesCells");
public static final int sel_initToBuffer_1capacity_1 = sel_registerName("initToBuffer:capacity:");
public static final int sel_endPage = sel_registerName("endPage");
public static final int sel_setTextAttributesForNotANumber_1 = sel_registerName("setTextAttributesForNotANumber:");
public static final int sel_makeNextSegmentKey = sel_registerName("makeNextSegmentKey");
public static final int sel_addAttributes_1range_1 = sel_registerName("addAttributes:range:");
public static final int sel_lineFragmentPadding = sel_registerName("lineFragmentPadding");
public static final int sel_showController_1adjustingSize_1 = sel_registerName("showController:adjustingSize:");
public static final int sel_glyphInfoWithGlyphName_1forFont_1baseString_1 = sel_registerName("glyphInfoWithGlyphName:forFont:baseString:");
public static final int sel_initWithCondition_1 = sel_registerName("initWithCondition:");
public static final int sel_handleMachMessage_1 = sel_registerName("handleMachMessage:");
public static final int sel_setFontMenu_1 = sel_registerName("setFontMenu:");
public static final int sel_invocationWithMethodSignature_1 = sel_registerName("invocationWithMethodSignature:");
public static final int sel_textAttributesForPositiveValues = sel_registerName("textAttributesForPositiveValues");
public static final int sel_decodePointForKey_1 = sel_registerName("decodePointForKey:");
public static final int sel_doubleForKey_1 = sel_registerName("doubleForKey:");
public static final int sel_application_1willPresentError_1 = sel_registerName("application:willPresentError:");
public static final int sel_setFloatingPointFormat_1left_1right_1 = sel_registerName("setFloatingPointFormat:left:right:");
public static final int sel_loadColumnZero = sel_registerName("loadColumnZero");
public static final int sel_availableFonts = sel_registerName("availableFonts");
public static final int sel_drawUnderlineForGlyphRange_1underlineType_1baselineOffset_1lineFragmentRect_1lineFragmentGlyphRange_1containerOrigin_1 = sel_registerName("drawUnderlineForGlyphRange:underlineType:baselineOffset:lineFragmentRect:lineFragmentGlyphRange:containerOrigin:");
public static final int sel_highlightedTableColumn = sel_registerName("highlightedTableColumn");
public static final int sel_removeObjectsInRange_1 = sel_registerName("removeObjectsInRange:");
public static final int sel_rectForKey_1inTable_1 = sel_registerName("rectForKey:inTable:");
public static final int sel_canStoreColor = sel_registerName("canStoreColor");
public static final int sel_windowWillMiniaturize_1 = sel_registerName("windowWillMiniaturize:");
public static final int sel_documentForWindow_1 = sel_registerName("documentForWindow:");
public static final int sel_setAttributedStringForNotANumber_1 = sel_registerName("setAttributedStringForNotANumber:");
public static final int sel_rangeOfString_1options_1range_1 = sel_registerName("rangeOfString:options:range:");
public static final int sel_pause = sel_registerName("pause");
public static final int sel_continueTracking_1at_1inView_1 = sel_registerName("continueTracking:at:inView:");
public static final int sel_servicesProvider = sel_registerName("servicesProvider");
public static final int sel_setIgnoredWords_1inSpellDocumentWithTag_1 = sel_registerName("setIgnoredWords:inSpellDocumentWithTag:");
public static final int sel_clear_1 = sel_registerName("clear:");
public static final int sel_readFromData_1options_1documentAttributes_1error_1 = sel_registerName("readFromData:options:documentAttributes:error:");
public static final int sel_columnNumber = sel_registerName("columnNumber");
public static final int sel_components = sel_registerName("components");
public static final int sel_image = sel_registerName("image");
public static final int sel_setDisplayMode_1 = sel_registerName("setDisplayMode:");
public static final int sel_insertParagraphSeparator_1 = sel_registerName("insertParagraphSeparator:");
public static final int sel_setPaperName_1 = sel_registerName("setPaperName:");
public static final int sel_defaultFormatterBehavior = sel_registerName("defaultFormatterBehavior");
public static final int sel_timeZoneWithAbbreviation_1 = sel_registerName("timeZoneWithAbbreviation:");
public static final int sel_setHighlighted_1 = sel_registerName("setHighlighted:");
public static final int sel_addFileWithPath_1 = sel_registerName("addFileWithPath:");
public static final int sel_allowsDocumentBackgroundColorChange = sel_registerName("allowsDocumentBackgroundColorChange");
public static final int sel_initWithURL_1documentAttributes_1 = sel_registerName("initWithURL:documentAttributes:");
public static final int sel_allowsUndo = sel_registerName("allowsUndo");
public static final int sel_localeIdentifierFromComponents_1 = sel_registerName("localeIdentifierFromComponents:");
public static final int sel_allowsNonContiguousLayout = sel_registerName("allowsNonContiguousLayout");
public static final int sel_arrayWithArray_1 = sel_registerName("arrayWithArray:");
public static final int sel_setCompositingOperation_1 = sel_registerName("setCompositingOperation:");
public static final int sel_netServiceBrowserDidStopSearch_1 = sel_registerName("netServiceBrowserDidStopSearch:");
public static final int sel_setHorizontalEdgePadding_1 = sel_registerName("setHorizontalEdgePadding:");
public static final int sel_accessibilityActionDescription_1 = sel_registerName("accessibilityActionDescription:");
public static final int sel_localizedKeyDictionary = sel_registerName("localizedKeyDictionary");
public static final int sel_initWithColorSyncProfile_1 = sel_registerName("initWithColorSyncProfile:");
public static final int sel_displayedCommandsTitle = sel_registerName("displayedCommandsTitle");
public static final int sel_flatness = sel_registerName("flatness");
public static final int sel_localizations = sel_registerName("localizations");
public static final int sel_mountedRemovableMedia = sel_registerName("mountedRemovableMedia");
public static final int sel_topAutoreleasePoolCount = sel_registerName("topAutoreleasePoolCount");
public static final int sel_postsFrameChangedNotifications = sel_registerName("postsFrameChangedNotifications");
public static final int sel_performZoom_1 = sel_registerName("performZoom:");
public static final int sel_moveBackward_1 = sel_registerName("moveBackward:");
public static final int sel_verticalPageScroll = sel_registerName("verticalPageScroll");
public static final int sel_setToolTip_1forCell_1 = sel_registerName("setToolTip:forCell:");
public static final int sel_layoutManagerOwnsFirstResponderInWindow_1 = sel_registerName("layoutManagerOwnsFirstResponderInWindow:");
public static final int sel_jobStyleHint = sel_registerName("jobStyleHint");
public static final int sel_selectionIndexes = sel_registerName("selectionIndexes");
public static final int sel_segmentCount = sel_registerName("segmentCount");
public static final int sel_accessibilityIsIgnored = sel_registerName("accessibilityIsIgnored");
public static final int sel_hasUnautosavedChanges = sel_registerName("hasUnautosavedChanges");
public static final int sel_deactivate = sel_registerName("deactivate");
public static final int sel_setSelectionIndexPaths_1 = sel_registerName("setSelectionIndexPaths:");
public static final int sel_pathForSoundResource_1 = sel_registerName("pathForSoundResource:");
public static final int sel_setUsesRuler_1 = sel_registerName("setUsesRuler:");
public static final int sel_takeSelectedTabViewItemFromSender_1 = sel_registerName("takeSelectedTabViewItemFromSender:");
public static final int sel_writeToFile_1ofType_1originalFile_1saveOperation_1 = sel_registerName("writeToFile:ofType:originalFile:saveOperation:");
public static final int sel_numberWithLong_1 = sel_registerName("numberWithLong:");
public static final int sel_interiorBackgroundStyle = sel_registerName("interiorBackgroundStyle");
public static final int sel_insertionPointColor = sel_registerName("insertionPointColor");
public static final int sel_prompt = sel_registerName("prompt");
public static final int sel_finishLaunching = sel_registerName("finishLaunching");
public static final int sel_addTextContainer_1 = sel_registerName("addTextContainer:");
public static final int sel_setAutosavedContentsFileURL_1 = sel_registerName("setAutosavedContentsFileURL:");
public static final int sel_initWithFrame_1textContainer_1 = sel_registerName("initWithFrame:textContainer:");
public static final int sel_clearColor = sel_registerName("clearColor");
public static final int sel_insertText_1 = sel_registerName("insertText:");
public static final int sel_sendAction = sel_registerName("sendAction");
public static final int sel_innerRect = sel_registerName("innerRect");
public static final int sel_pointerFunctions = sel_registerName("pointerFunctions");
public static final int sel_key = sel_registerName("key");
public static final int sel_comboBoxSelectionDidChange_1 = sel_registerName("comboBoxSelectionDidChange:");
public static final int sel_hasMarkedText = sel_registerName("hasMarkedText");
public static final int sel_setDefaultLineCapStyle_1 = sel_registerName("setDefaultLineCapStyle:");
public static final int sel_stringListForKey_1inTable_1 = sel_registerName("stringListForKey:inTable:");
public static final int sel_defaultConnection = sel_registerName("defaultConnection");
public static final int sel_pathContentOfSymbolicLinkAtPath_1 = sel_registerName("pathContentOfSymbolicLinkAtPath:");
public static final int sel_stringWithContentsOfFile_1encoding_1error_1 = sel_registerName("stringWithContentsOfFile:encoding:error:");
public static final int sel_detachSubmenu = sel_registerName("detachSubmenu");
public static final int sel_isSecure = sel_registerName("isSecure");
public static final int sel_movie = sel_registerName("movie");
public static final int sel_outlineViewItemWillExpand_1 = sel_registerName("outlineViewItemWillExpand:");
public static final int sel_sharedScriptSuiteRegistry = sel_registerName("sharedScriptSuiteRegistry");
public static final int sel_removeCharactersInString_1 = sel_registerName("removeCharactersInString:");
public static final int sel_setLocation_1withAdvancements_1forStartOfGlyphRange_1 = sel_registerName("setLocation:withAdvancements:forStartOfGlyphRange:");
public static final int sel_moveDownAndModifySelection_1 = sel_registerName("moveDownAndModifySelection:");
public static final int sel_fileAttributesToWriteToURL_1ofType_1forSaveOperation_1originalContentsURL_1error_1 = sel_registerName("fileAttributesToWriteToURL:ofType:forSaveOperation:originalContentsURL:error:");
public static final int sel_classDescriptionForKey_1 = sel_registerName("classDescriptionForKey:");
public static final int sel_addRequestMode_1 = sel_registerName("addRequestMode:");
public static final int sel_setPullsDown_1 = sel_registerName("setPullsDown:");
public static final int sel_setItemHeight_1 = sel_registerName("setItemHeight:");
public static final int sel_printerFont = sel_registerName("printerFont");
public static final int sel_linkTextAttributes = sel_registerName("linkTextAttributes");
public static final int sel_state = sel_registerName("state");
public static final int sel_shouldCloseWindowController_1delegate_1shouldCloseSelector_1contextInfo_1 = sel_registerName("shouldCloseWindowController:delegate:shouldCloseSelector:contextInfo:");
public static final int sel_addIndex_1 = sel_registerName("addIndex:");
public static final int sel_setChildSpecifier_1 = sel_registerName("setChildSpecifier:");
public static final int sel_toolbarDidRemoveItem_1 = sel_registerName("toolbarDidRemoveItem:");
public static final int sel_displayName = sel_registerName("displayName");
public static final int sel_setInsertionPointColor_1 = sel_registerName("setInsertionPointColor:");
public static final int sel_bezierPathByReversingPath = sel_registerName("bezierPathByReversingPath");
public static final int sel_connection_1didReceiveData_1 = sel_registerName("connection:didReceiveData:");
public static final int sel_eraSymbols = sel_registerName("eraSymbols");
public static final int sel_removeObjectsForKeys_1 = sel_registerName("removeObjectsForKeys:");
public static final int sel_subrowIndexesForRow_1 = sel_registerName("subrowIndexesForRow:");
public static final int sel_increaseLengthBy_1 = sel_registerName("increaseLengthBy:");
public static final int sel_viewDidEndLiveResize = sel_registerName("viewDidEndLiveResize");
public static final int sel_encodeBool_1forKey_1 = sel_registerName("encodeBool:forKey:");
public static final int sel_handleQueryWithUnboundKey_1 = sel_registerName("handleQueryWithUnboundKey:");
public static final int sel_elementsForName_1 = sel_registerName("elementsForName:");
public static final int sel_cascadeTopLeftFromPoint_1 = sel_registerName("cascadeTopLeftFromPoint:");
public static final int sel_linkItemAtPath_1toPath_1error_1 = sel_registerName("linkItemAtPath:toPath:error:");
public static final int sel_frameSizeForContentSize_1hasHorizontalScroller_1hasVerticalScroller_1borderType_1 = sel_registerName("frameSizeForContentSize:hasHorizontalScroller:hasVerticalScroller:borderType:");
public static final int sel_initWithString_1attributes_1 = sel_registerName("initWithString:attributes:");
public static final int sel_readFromData_1options_1documentAttributes_1 = sel_registerName("readFromData:options:documentAttributes:");
public static final int sel_setAlpha_1 = sel_registerName("setAlpha:");
public static final int sel_hash = sel_registerName("hash");
public static final int sel_rangeForUserParagraphAttributeChange = sel_registerName("rangeForUserParagraphAttributeChange");
public static final int sel_initWithData_1encoding_1 = sel_registerName("initWithData:encoding:");
public static final int sel_newScriptingObjectOfClass_1forValueForKey_1withContentsValue_1properties_1 = sel_registerName("newScriptingObjectOfClass:forValueForKey:withContentsValue:properties:");
public static final int sel_pageDown_1 = sel_registerName("pageDown:");
public static final int sel_hasCloseBox = sel_registerName("hasCloseBox");
public static final int sel_standardizedURL = sel_registerName("standardizedURL");
public static final int sel_setAttributes_1range_1 = sel_registerName("setAttributes:range:");
public static final int sel_setControlSize_1 = sel_registerName("setControlSize:");
public static final int sel_revertToInitialValues_1 = sel_registerName("revertToInitialValues:");
public static final int sel_setIntAttribute_1value_1forGlyphAtIndex_1 = sel_registerName("setIntAttribute:value:forGlyphAtIndex:");
public static final int sel_stopTracking_1at_1inView_1mouseIsUp_1 = sel_registerName("stopTracking:at:inView:mouseIsUp:");
public static final int sel_setParamDescriptor_1forKeyword_1 = sel_registerName("setParamDescriptor:forKeyword:");
public static final int sel_textShouldBeginEditing_1 = sel_registerName("textShouldBeginEditing:");
public static final int sel_applicationDidHide_1 = sel_registerName("applicationDidHide:");
public static final int sel_beginSheetWithPrintInfo_1modalForWindow_1delegate_1didEndSelector_1contextInfo_1 = sel_registerName("beginSheetWithPrintInfo:modalForWindow:delegate:didEndSelector:contextInfo:");
public static final int sel_shiftIndexesStartingAtIndex_1by_1 = sel_registerName("shiftIndexesStartingAtIndex:by:");
public static final int sel_getStreamsToHost_1port_1inputStream_1outputStream_1 = sel_registerName("getStreamsToHost:port:inputStream:outputStream:");
public static final int sel_attributesOfFileSystemForPath_1error_1 = sel_registerName("attributesOfFileSystemForPath:error:");
public static final int sel_setTemporaryAttributes_1forCharacterRange_1 = sel_registerName("setTemporaryAttributes:forCharacterRange:");
public static final int sel_checkSpellingOfString_1startingAt_1language_1wrap_1inSpellDocumentWithTag_1wordCount_1 = sel_registerName("checkSpellingOfString:startingAt:language:wrap:inSpellDocumentWithTag:wordCount:");
public static final int sel_insertChild_1atIndex_1 = sel_registerName("insertChild:atIndex:");
public static final int sel_defaultManager = sel_registerName("defaultManager");
public static final int sel_invocation = sel_registerName("invocation");
public static final int sel_setMinValue_1 = sel_registerName("setMinValue:");
public static final int sel_decodeSize = sel_registerName("decodeSize");
public static final int sel_replaceObject_1withObject_1 = sel_registerName("replaceObject:withObject:");
public static final int sel_descriptionWithLocale_1 = sel_registerName("descriptionWithLocale:");
public static final int sel_setSharingType_1 = sel_registerName("setSharingType:");
public static final int sel_isLenient = sel_registerName("isLenient");
public static final int sel_decimalNumberWithString_1locale_1 = sel_registerName("decimalNumberWithString:locale:");
public static final int sel_allowedTypes = sel_registerName("allowedTypes");
public static final int sel_superscript_1 = sel_registerName("superscript:");
public static final int sel_initWithContentsOfFile_1encoding_1error_1 = sel_registerName("initWithContentsOfFile:encoding:error:");
public static final int sel_windowsMenu = sel_registerName("windowsMenu");
public static final int sel_performSelector_1target_1argument_1order_1modes_1 = sel_registerName("performSelector:target:argument:order:modes:");
public static final int sel_unscheduleFromRunLoop_1forMode_1 = sel_registerName("unscheduleFromRunLoop:forMode:");
public static final int sel_evaluatedArguments = sel_registerName("evaluatedArguments");
public static final int sel_encodeSize_1forKey_1 = sel_registerName("encodeSize:forKey:");
public static final int sel_sendBeforeDate_1components_1from_1reserved_1 = sel_registerName("sendBeforeDate:components:from:reserved:");
public static final int sel_containerSize = sel_registerName("containerSize");
public static final int sel_selectedTextColor = sel_registerName("selectedTextColor");
public static final int sel_getGlyphsInRange_1glyphs_1characterIndexes_1glyphInscriptions_1elasticBits_1 = sel_registerName("getGlyphsInRange:glyphs:characterIndexes:glyphInscriptions:elasticBits:");
public static final int sel_curveToPoint_1controlPoint1_1controlPoint2_1 = sel_registerName("curveToPoint:controlPoint1:controlPoint2:");
public static final int sel_mutableBytes = sel_registerName("mutableBytes");
public static final int sel_rangeOfUnit_1inUnit_1forDate_1 = sel_registerName("rangeOfUnit:inUnit:forDate:");
public static final int sel_allowsNaturalLanguage = sel_registerName("allowsNaturalLanguage");
public static final int sel_mouseLocation = sel_registerName("mouseLocation");
public static final int sel_selectCellAtRow_1column_1 = sel_registerName("selectCellAtRow:column:");
public static final int sel_toggleBaseWritingDirection_1 = sel_registerName("toggleBaseWritingDirection:");
public static final int sel_maximum = sel_registerName("maximum");
public static final int sel_initWithFocusedViewRect_1 = sel_registerName("initWithFocusedViewRect:");
public static final int sel_thickness = sel_registerName("thickness");
public static final int sel_setImageOrigin_1 = sel_registerName("setImageOrigin:");
public static final int sel_color = sel_registerName("color");
public static final int sel_capitalizeWord_1 = sel_registerName("capitalizeWord:");
public static final int sel_imageRepClassForData_1 = sel_registerName("imageRepClassForData:");
public static final int sel_outlineTableColumn = sel_registerName("outlineTableColumn");
public static final int sel_runModalWithPrintInfo_1 = sel_registerName("runModalWithPrintInfo:");
public static final int sel_flushCachedData = sel_registerName("flushCachedData");
public static final int sel_exitFullScreenModeWithOptions_1 = sel_registerName("exitFullScreenModeWithOptions:");
public static final int sel_alertStyle = sel_registerName("alertStyle");
public static final int sel_runModalPageLayoutWithPrintInfo_1delegate_1didRunSelector_1contextInfo_1 = sel_registerName("runModalPageLayoutWithPrintInfo:delegate:didRunSelector:contextInfo:");
public static final int sel_setDisplayedWhenStopped_1 = sel_registerName("setDisplayedWhenStopped:");
public static final int sel_drawBackgroundWithFrame_1inView_1characterRange_1layoutManager_1 = sel_registerName("drawBackgroundWithFrame:inView:characterRange:layoutManager:");
public static final int sel_addObject_1 = sel_registerName("addObject:");
public static final int sel_dragPromisedFilesOfTypes_1fromRect_1source_1slideBack_1event_1 = sel_registerName("dragPromisedFilesOfTypes:fromRect:source:slideBack:event:");
public static final int sel_samplesPerPixel = sel_registerName("samplesPerPixel");
public static final int sel_negativePrefix = sel_registerName("negativePrefix");
public static final int sel_initialKey = sel_registerName("initialKey");
public static final int sel_orderFrontColorPanel_1 = sel_registerName("orderFrontColorPanel:");
public static final int sel_hasLearnedWord_1 = sel_registerName("hasLearnedWord:");
public static final int sel_setLineFragmentRect_1forGlyphRange_1usedRect_1baselineOffset_1 = sel_registerName("setLineFragmentRect:forGlyphRange:usedRect:baselineOffset:");
public static final int sel_setHidesOnDeactivate_1 = sel_registerName("setHidesOnDeactivate:");
public static final int sel_setMsgid_1 = sel_registerName("setMsgid:");
public static final int sel_elementCount = sel_registerName("elementCount");
public static final int sel_dateWithString_1 = sel_registerName("dateWithString:");
public static final int sel_rangeOfTextBlock_1atIndex_1 = sel_registerName("rangeOfTextBlock:atIndex:");
public static final int sel_setMenuItemCell_1forItemAtIndex_1 = sel_registerName("setMenuItemCell:forItemAtIndex:");
public static final int sel_defaultTimeZone = sel_registerName("defaultTimeZone");
public static final int sel_gotoBeginning_1 = sel_registerName("gotoBeginning:");
public static final int sel_setDrawsOutsideLineFragment_1forGlyphAtIndex_1 = sel_registerName("setDrawsOutsideLineFragment:forGlyphAtIndex:");
public static final int sel_characterCollection = sel_registerName("characterCollection");
public static final int sel_getValues_1forParameter_1 = sel_registerName("getValues:forParameter:");
public static final int sel_removeColumn_1 = sel_registerName("removeColumn:");
public static final int sel_descender = sel_registerName("descender");
public static final int sel_fragment = sel_registerName("fragment");
public static final int sel_setSelectionByRect_1 = sel_registerName("setSelectionByRect:");
public static final int sel_colorWithColorSpace_1components_1count_1 = sel_registerName("colorWithColorSpace:components:count:");
public static final int sel_windingRule = sel_registerName("windingRule");
public static final int sel_insertColumn_1 = sel_registerName("insertColumn:");
public static final int sel_resumeWithSuspensionID_1 = sel_registerName("resumeWithSuspensionID:");
public static final int sel_seekToEndOfFile = sel_registerName("seekToEndOfFile");
public static final int sel_initWithTarget_1connection_1 = sel_registerName("initWithTarget:connection:");
public static final int sel_symbolCharacterSet = sel_registerName("symbolCharacterSet");
public static final int sel_filterPredicate = sel_registerName("filterPredicate");
public static final int sel_setAutoenablesItems_1 = sel_registerName("setAutoenablesItems:");
public static final int sel_printShowingPrintPanel_1 = sel_registerName("printShowingPrintPanel:");
public static final int sel_pathForResource_1ofType_1inDirectory_1forLocalization_1 = sel_registerName("pathForResource:ofType:inDirectory:forLocalization:");
public static final int sel_objectByApplyingXSLTAtURL_1arguments_1error_1 = sel_registerName("objectByApplyingXSLTAtURL:arguments:error:");
public static final int sel_setHidesEmptyCells_1 = sel_registerName("setHidesEmptyCells:");
public static final int sel_date = sel_registerName("date");
public static final int sel_writeToFile_1atomically_1 = sel_registerName("writeToFile:atomically:");
public static final int sel_locale = sel_registerName("locale");
public static final int sel_localizedKeyTable = sel_registerName("localizedKeyTable");
public static final int sel_absoluteURL = sel_registerName("absoluteURL");
public static final int sel_bundleWithPath_1 = sel_registerName("bundleWithPath:");
public static final int sel_setHeaderCell_1 = sel_registerName("setHeaderCell:");
public static final int sel_setAutoresizesSubviews_1 = sel_registerName("setAutoresizesSubviews:");
public static final int sel_URI = sel_registerName("URI");
public static final int sel_controlBackgroundColor = sel_registerName("controlBackgroundColor");
public static final int sel_displayNameAtPath_1 = sel_registerName("displayNameAtPath:");
public static final int sel_decodePortObject = sel_registerName("decodePortObject");
public static final int sel_alpha = sel_registerName("alpha");
public static final int sel_initWithLeftExpression_1rightExpression_1customSelector_1 = sel_registerName("initWithLeftExpression:rightExpression:customSelector:");
public static final int sel_secondaryGroupingSize = sel_registerName("secondaryGroupingSize");
public static final int sel_connectionDidFinishLoading_1 = sel_registerName("connectionDidFinishLoading:");
public static final int sel_localObjects = sel_registerName("localObjects");
public static final int sel_enableKeyEquivalentForDefaultButtonCell = sel_registerName("enableKeyEquivalentForDefaultButtonCell");
public static final int sel_drawKnobSlotInRect_1highlight_1 = sel_registerName("drawKnobSlotInRect:highlight:");
public static final int sel_dateWithString_1calendarFormat_1locale_1 = sel_registerName("dateWithString:calendarFormat:locale:");
public static final int sel_stop = sel_registerName("stop");
public static final int sel_appendBezierPathWithOvalInRect_1 = sel_registerName("appendBezierPathWithOvalInRect:");
public static final int sel_componentsSeparatedByCharactersInSet_1 = sel_registerName("componentsSeparatedByCharactersInSet:");
public static final int sel_tightenKerning_1 = sel_registerName("tightenKerning:");
public static final int sel_verticalRulerView = sel_registerName("verticalRulerView");
public static final int sel_setImageAlignment_1 = sel_registerName("setImageAlignment:");
public static final int sel_removeFrameUsingName_1 = sel_registerName("removeFrameUsingName:");
public static final int sel_insertColor_1key_1atIndex_1 = sel_registerName("insertColor:key:atIndex:");
public static final int sel_terminate_1 = sel_registerName("terminate:");
public static final int sel_textContainerChangedTextView_1 = sel_registerName("textContainerChangedTextView:");
public static final int sel_removeFileAtPath_1handler_1 = sel_registerName("removeFileAtPath:handler:");
public static final int sel_splitViewWillResizeSubviews_1 = sel_registerName("splitViewWillResizeSubviews:");
public static final int sel_windowDidBecomeMain_1 = sel_registerName("windowDidBecomeMain:");
public static final int sel_cellBaselineOffset = sel_registerName("cellBaselineOffset");
public static final int sel_addEntriesFromDictionary_1 = sel_registerName("addEntriesFromDictionary:");
public static final int sel_setOnStateImage_1 = sel_registerName("setOnStateImage:");
public static final int sel_colorWithCIColor_1 = sel_registerName("colorWithCIColor:");
public static final int sel_getCyan_1magenta_1yellow_1black_1alpha_1 = sel_registerName("getCyan:magenta:yellow:black:alpha:");
public static final int sel_symbolicTraits = sel_registerName("symbolicTraits");
public static final int sel_stringByAppendingPathExtension_1 = sel_registerName("stringByAppendingPathExtension:");
public static final int sel_horizontalScroller = sel_registerName("horizontalScroller");
public static final int sel_setInitialValue_1 = sel_registerName("setInitialValue:");
public static final int sel_sizeForPaperName_1 = sel_registerName("sizeForPaperName:");
public static final int sel_CGLContextObj = sel_registerName("CGLContextObj");
public static final int sel_elementWithName_1 = sel_registerName("elementWithName:");
public static final int sel_fileManager_1shouldMoveItemAtPath_1toPath_1 = sel_registerName("fileManager:shouldMoveItemAtPath:toPath:");
public static final int sel_richTextSource = sel_registerName("richTextSource");
public static final int sel_unregisterDraggedTypes = sel_registerName("unregisterDraggedTypes");
public static final int sel_absoluteString = sel_registerName("absoluteString");
public static final int sel_spellingPanel = sel_registerName("spellingPanel");
public static final int sel_launchedApplications = sel_registerName("launchedApplications");
public static final int sel_initWithContentsOfFile_1byReference_1 = sel_registerName("initWithContentsOfFile:byReference:");
public static final int sel_setLoaded_1 = sel_registerName("setLoaded:");
public static final int sel_setWindowFrameAutosaveName_1 = sel_registerName("setWindowFrameAutosaveName:");
public static final int sel_initOrTestWithTests_1 = sel_registerName("initOrTestWithTests:");
public static final int sel_drawsBackground = sel_registerName("drawsBackground");
public static final int sel_numberWithDouble_1 = sel_registerName("numberWithDouble:");
public static final int sel_textView_1writeCell_1atIndex_1toPasteboard_1type_1 = sel_registerName("textView:writeCell:atIndex:toPasteboard:type:");
public static final int sel_defaultMiterLimit = sel_registerName("defaultMiterLimit");
public static final int sel_containsObject_1 = sel_registerName("containsObject:");
public static final int sel_headerTextColor = sel_registerName("headerTextColor");
public static final int sel_textView_1doCommandBySelector_1 = sel_registerName("textView:doCommandBySelector:");
public static final int sel_drawBorderAndBackgroundWithFrame_1inView_1 = sel_registerName("drawBorderAndBackgroundWithFrame:inView:");
public static final int sel_quarterSymbols = sel_registerName("quarterSymbols");
public static final int sel_setContainerSize_1 = sel_registerName("setContainerSize:");
public static final int sel_sortUsingSelector_1 = sel_registerName("sortUsingSelector:");
public static final int sel_setKey_1 = sel_registerName("setKey:");
public static final int sel_headerView = sel_registerName("headerView");
public static final int sel_isRegularFile = sel_registerName("isRegularFile");
public static final int sel_userData = sel_registerName("userData");
public static final int sel_documentCursor = sel_registerName("documentCursor");
public static final int sel_textEncodingName = sel_registerName("textEncodingName");
public static final int sel_performActionForItemAtIndex_1 = sel_registerName("performActionForItemAtIndex:");
public static final int sel_isCaseInsensitiveLike_1 = sel_registerName("isCaseInsensitiveLike:");
public static final int sel_isEditing = sel_registerName("isEditing");
public static final int sel_selectFile_1inFileViewerRootedAtPath_1 = sel_registerName("selectFile:inFileViewerRootedAtPath:");
public static final int sel_messageFontOfSize_1 = sel_registerName("messageFontOfSize:");
public static final int sel_independentConversationQueueing = sel_registerName("independentConversationQueueing");
public static final int sel_initWithCoder_1 = sel_registerName("initWithCoder:");
public static final int sel_rangesForUserParagraphAttributeChange = sel_registerName("rangesForUserParagraphAttributeChange");
public static final int sel_removeTrackingArea_1 = sel_registerName("removeTrackingArea:");
public static final int sel_glyphGenerator = sel_registerName("glyphGenerator");
public static final int sel_extraLineFragmentUsedRect = sel_registerName("extraLineFragmentUsedRect");
public static final int sel_isButtonBordered = sel_registerName("isButtonBordered");
public static final int sel_setDefaultFormatterBehavior_1 = sel_registerName("setDefaultFormatterBehavior:");
public static final int sel_didChange_1valuesAtIndexes_1forKey_1 = sel_registerName("didChange:valuesAtIndexes:forKey:");
public static final int sel_timeoutInterval = sel_registerName("timeoutInterval");
public static final int sel_initialValues = sel_registerName("initialValues");
public static final int sel_getRow_1column_1forPoint_1 = sel_registerName("getRow:column:forPoint:");
public static final int sel_tabletPoint_1 = sel_registerName("tabletPoint:");
public static final int sel_setAutorecalculatesKeyViewLoop_1 = sel_registerName("setAutorecalculatesKeyViewLoop:");
public static final int sel_identifier = sel_registerName("identifier");
public static final int sel_scheduleInRunLoop_1forMode_1 = sel_registerName("scheduleInRunLoop:forMode:");
public static final int sel_baseURL = sel_registerName("baseURL");
public static final int sel_initWithURL_1 = sel_registerName("initWithURL:");
public static final int sel_setBackgroundColors_1 = sel_registerName("setBackgroundColors:");
public static final int sel_addTableColumn_1 = sel_registerName("addTableColumn:");
public static final int sel_fontDescriptorWithFontAttributes_1 = sel_registerName("fontDescriptorWithFontAttributes:");
public static final int sel_dataCellForRow_1 = sel_registerName("dataCellForRow:");
public static final int sel_speechSynthesizer_1didEncounterErrorAtIndex_1ofString_1message_1 = sel_registerName("speechSynthesizer:didEncounterErrorAtIndex:ofString:message:");
public static final int sel_recoveryAttempter = sel_registerName("recoveryAttempter");
public static final int sel_alignJustified_1 = sel_registerName("alignJustified:");
public static final int sel_setCompression_1factor_1 = sel_registerName("setCompression:factor:");
public static final int sel_elementsForLocalName_1URI_1 = sel_registerName("elementsForLocalName:URI:");
public static final int sel_deviceGrayColorSpace = sel_registerName("deviceGrayColorSpace");
public static final int sel_scheduledTimerWithTimeInterval_1target_1selector_1userInfo_1repeats_1 = sel_registerName("scheduledTimerWithTimeInterval:target:selector:userInfo:repeats:");
public static final int sel_runModalSession_1 = sel_registerName("runModalSession:");
public static final int sel_awakeFromNib = sel_registerName("awakeFromNib");
public static final int sel_connectionWithReceivePort_1sendPort_1 = sel_registerName("connectionWithReceivePort:sendPort:");
public static final int sel_outlineView_1validateDrop_1proposedItem_1proposedChildIndex_1 = sel_registerName("outlineView:validateDrop:proposedItem:proposedChildIndex:");
public static final int sel_remove_1 = sel_registerName("remove:");
public static final int sel_setTimeInterval_1 = sel_registerName("setTimeInterval:");
public static final int sel_splitView_1effectiveRect_1forDrawnRect_1ofDividerAtIndex_1 = sel_registerName("splitView:effectiveRect:forDrawnRect:ofDividerAtIndex:");
public static final int sel_setUpGState = sel_registerName("setUpGState");
public static final int sel_initWithResponse_1data_1 = sel_registerName("initWithResponse:data:");
public static final int sel_notificationCenter = sel_registerName("notificationCenter");
public static final int sel_setAlternateImage_1 = sel_registerName("setAlternateImage:");
public static final int sel_mainWindow = sel_registerName("mainWindow");
public static final int sel_substringWithRange_1 = sel_registerName("substringWithRange:");
public static final int sel_forgetWord_1 = sel_registerName("forgetWord:");
public static final int sel_shouldCascadeWindows = sel_registerName("shouldCascadeWindows");
public static final int sel_updateScroller = sel_registerName("updateScroller");
public static final int sel_currentDirectoryPath = sel_registerName("currentDirectoryPath");
public static final int sel_isPartialStringValidationEnabled = sel_registerName("isPartialStringValidationEnabled");
public static final int sel_splitView_1constrainMinCoordinate_1ofSubviewAt_1 = sel_registerName("splitView:constrainMinCoordinate:ofSubviewAt:");
public static final int sel_drawWithFrame_1inView_1 = sel_registerName("drawWithFrame:inView:");
public static final int sel_encodingScheme = sel_registerName("encodingScheme");
public static final int sel_namespaceWithName_1stringValue_1 = sel_registerName("namespaceWithName:stringValue:");
public static final int sel_initWithLongLong_1 = sel_registerName("initWithLongLong:");
public static final int sel_processIdentifier = sel_registerName("processIdentifier");
public static final int sel_setSubmenu_1forItem_1 = sel_registerName("setSubmenu:forItem:");
public static final int sel_textAttributesForNil = sel_registerName("textAttributesForNil");
public static final int sel_lockWithPath_1 = sel_registerName("lockWithPath:");
public static final int sel_removeFromSuperviewWithoutNeedingDisplay = sel_registerName("removeFromSuperviewWithoutNeedingDisplay");
public static final int sel_cut_1 = sel_registerName("cut:");
public static final int sel_nullDescriptor = sel_registerName("nullDescriptor");
public static final int sel_menuFormRepresentation = sel_registerName("menuFormRepresentation");
public static final int sel_removeObjectsAtIndexes_1 = sel_registerName("removeObjectsAtIndexes:");
public static final int sel_initWithSource_1 = sel_registerName("initWithSource:");
public static final int sel_acceptsGlyphInfo = sel_registerName("acceptsGlyphInfo");
public static final int sel_borderType = sel_registerName("borderType");
public static final int sel_initWithResumeData_1delegate_1path_1 = sel_registerName("initWithResumeData:delegate:path:");
public static final int sel_attachedMenu = sel_registerName("attachedMenu");
public static final int sel_stopAnimation = sel_registerName("stopAnimation");
public static final int sel_setDoubleAction_1 = sel_registerName("setDoubleAction:");
public static final int sel_returnType = sel_registerName("returnType");
public static final int sel_fontDescriptorsInCollection_1 = sel_registerName("fontDescriptorsInCollection:");
public static final int sel_setMeasurementUnits_1 = sel_registerName("setMeasurementUnits:");
public static final int sel_baseWritingDirection = sel_registerName("baseWritingDirection");
public static final int sel_currentPoint = sel_registerName("currentPoint");
public static final int sel_initRemoteWithTCPPort_1host_1 = sel_registerName("initRemoteWithTCPPort:host:");
public static final int sel_entityDeclarationForName_1 = sel_registerName("entityDeclarationForName:");
public static final int sel_evaluate = sel_registerName("evaluate");
public static final int sel_browser_1draggingImageForRowsWithIndexes_1inColumn_1withEvent_1offset_1 = sel_registerName("browser:draggingImageForRowsWithIndexes:inColumn:withEvent:offset:");
public static final int sel_turnOffLigatures_1 = sel_registerName("turnOffLigatures:");
public static final int sel_setTitleWithMnemonic_1 = sel_registerName("setTitleWithMnemonic:");
public static final int sel_deepestScreen = sel_registerName("deepestScreen");
public static final int sel_connection_1shouldMakeNewConnection_1 = sel_registerName("connection:shouldMakeNewConnection:");
public static final int sel_selectionShouldChangeInOutlineView_1 = sel_registerName("selectionShouldChangeInOutlineView:");
public static final int sel_preservesSelection = sel_registerName("preservesSelection");
public static final int sel_preparePageLayout_1 = sel_registerName("preparePageLayout:");
public static final int sel_setOpaque_1 = sel_registerName("setOpaque:");
public static final int sel_insertObject_1atIndex_1 = sel_registerName("insertObject:atIndex:");
public static final int sel_isActive = sel_registerName("isActive");
public static final int sel_drawStrikethroughForGlyphRange_1strikethroughType_1baselineOffset_1lineFragmentRect_1lineFragmentGlyphRange_1containerOrigin_1 = sel_registerName("drawStrikethroughForGlyphRange:strikethroughType:baselineOffset:lineFragmentRect:lineFragmentGlyphRange:containerOrigin:");
public static final int sel_insertObject_1atArrangedObjectIndex_1 = sel_registerName("insertObject:atArrangedObjectIndex:");
public static final int sel_initWithCStringNoCopy_1length_1freeWhenDone_1 = sel_registerName("initWithCStringNoCopy:length:freeWhenDone:");
public static final int sel_previousKeyView = sel_registerName("previousKeyView");
public static final int sel_performMiniaturize_1 = sel_registerName("performMiniaturize:");
public static final int sel_decimalNumberWithDecimal_1 = sel_registerName("decimalNumberWithDecimal:");
public static final int sel_autosaveTableColumns = sel_registerName("autosaveTableColumns");
public static final int sel_baselineOffsetInLayoutManager_1glyphIndex_1 = sel_registerName("baselineOffsetInLayoutManager:glyphIndex:");
public static final int sel_keyViewSelectionDirection = sel_registerName("keyViewSelectionDirection");
public static final int sel_encodeBytes_1length_1 = sel_registerName("encodeBytes:length:");
public static final int sel_fileManager_1shouldProceedAfterError_1copyingItemAtPath_1toPath_1 = sel_registerName("fileManager:shouldProceedAfterError:copyingItemAtPath:toPath:");
public static final int sel_menuNeedsUpdate_1 = sel_registerName("menuNeedsUpdate:");
public static final int sel_paragraphSpacingAfterGlyphAtIndex_1withProposedLineFragmentRect_1 = sel_registerName("paragraphSpacingAfterGlyphAtIndex:withProposedLineFragmentRect:");
public static final int sel_synchronize = sel_registerName("synchronize");
public static final int sel_lockFocus = sel_registerName("lockFocus");
public static final int sel_toggleSmartInsertDelete_1 = sel_registerName("toggleSmartInsertDelete:");
public static final int sel_setMenu_1forSegment_1 = sel_registerName("setMenu:forSegment:");
public static final int sel_removeParamDescriptorWithKeyword_1 = sel_registerName("removeParamDescriptorWithKeyword:");
public static final int sel_applicationShouldOpenUntitledFile_1 = sel_registerName("applicationShouldOpenUntitledFile:");
public static final int sel_DTD = sel_registerName("DTD");
public static final int sel_cancelTracking = sel_registerName("cancelTracking");
public static final int sel_fileSystemNumber = sel_registerName("fileSystemNumber");
public static final int sel_setLevel_1 = sel_registerName("setLevel:");
public static final int sel_setRequiredFileType_1 = sel_registerName("setRequiredFileType:");
public static final int sel_presentError_1 = sel_registerName("presentError:");
public static final int sel_allowsUserCustomization = sel_registerName("allowsUserCustomization");
public static final int sel_childrenKeyPathForNode_1 = sel_registerName("childrenKeyPathForNode:");
public static final int sel_setYear_1 = sel_registerName("setYear:");
public static final int sel_movieController = sel_registerName("movieController");
public static final int sel_unsignedLongValue = sel_registerName("unsignedLongValue");
public static final int sel_hashTableWithOptions_1 = sel_registerName("hashTableWithOptions:");
public static final int sel_setVerticalAlignment_1 = sel_registerName("setVerticalAlignment:");
public static final int sel_cycleToNextInputServerInLanguage_1 = sel_registerName("cycleToNextInputServerInLanguage:");
public static final int sel_sendAction_1to_1from_1 = sel_registerName("sendAction:to:from:");
public static final int sel_numberFromString_1 = sel_registerName("numberFromString:");
public static final int sel_setUndoManager_1 = sel_registerName("setUndoManager:");
public static final int sel_imageDimsWhenDisabled = sel_registerName("imageDimsWhenDisabled");
public static final int sel_autosavingFileType = sel_registerName("autosavingFileType");
public static final int sel_unsignedLongLongValue = sel_registerName("unsignedLongLongValue");
public static final int sel_initImageCell_1 = sel_registerName("initImageCell:");
public static final int sel_invalidateDisplayForCharacterRange_1 = sel_registerName("invalidateDisplayForCharacterRange:");
public static final int sel_setMaxContentSize_1 = sel_registerName("setMaxContentSize:");
public static final int sel_outlineView_1isItemExpandable_1 = sel_registerName("outlineView:isItemExpandable:");
public static final int sel_initWithUser_1password_1persistence_1 = sel_registerName("initWithUser:password:persistence:");
public static final int sel_setBackgroundFilters_1 = sel_registerName("setBackgroundFilters:");
public static final int sel_setAllowsDocumentBackgroundColorChange_1 = sel_registerName("setAllowsDocumentBackgroundColorChange:");
public static final int sel_decodeNXObject = sel_registerName("decodeNXObject");
public static final int sel_setMaximumSignificantDigits_1 = sel_registerName("setMaximumSignificantDigits:");
public static final int sel_URLsFromRunningOpenPanel = sel_registerName("URLsFromRunningOpenPanel");
public static final int sel_removeChildWindow_1 = sel_registerName("removeChildWindow:");
public static final int sel_removeObjectForKey_1 = sel_registerName("removeObjectForKey:");
public static final int sel_setCellSize_1 = sel_registerName("setCellSize:");
public static final int sel_getParagraphStart_1end_1contentsEnd_1forRange_1 = sel_registerName("getParagraphStart:end:contentsEnd:forRange:");
public static final int sel_connectionWithRequest_1delegate_1 = sel_registerName("connectionWithRequest:delegate:");
public static final int sel_setNotShownAttribute_1forGlyphRange_1 = sel_registerName("setNotShownAttribute:forGlyphRange:");
public static final int sel_collapsesBorders = sel_registerName("collapsesBorders");
public static final int sel_setNegativeInfinitySymbol_1 = sel_registerName("setNegativeInfinitySymbol:");
public static final int sel_initWithKind_1 = sel_registerName("initWithKind:");
public static final int sel_appleEventCodeForArgumentWithName_1 = sel_registerName("appleEventCodeForArgumentWithName:");
public static final int sel_moveUp_1 = sel_registerName("moveUp:");
public static final int sel_initWithTextAlignment_1location_1options_1 = sel_registerName("initWithTextAlignment:location:options:");
public static final int sel_systemVersion = sel_registerName("systemVersion");
public static final int sel_numberOfItemsInComboBoxCell_1 = sel_registerName("numberOfItemsInComboBoxCell:");
public static final int sel_readableTypes = sel_registerName("readableTypes");
public static final int sel_setDraggingSourceOperationMask_1forLocal_1 = sel_registerName("setDraggingSourceOperationMask:forLocal:");
public static final int sel_insertLineBreak_1 = sel_registerName("insertLineBreak:");
public static final int sel_inLiveResize = sel_registerName("inLiveResize");
public static final int sel_setCanHide_1 = sel_registerName("setCanHide:");
public static final int sel_nextResponder = sel_registerName("nextResponder");
public static final int sel_scrollClipView_1toPoint_1 = sel_registerName("scrollClipView:toPoint:");
public static final int sel_positiveFormat = sel_registerName("positiveFormat");
public static final int sel_redoMenuItemTitle = sel_registerName("redoMenuItemTitle");
public static final int sel_addIndexesInRange_1 = sel_registerName("addIndexesInRange:");
public static final int sel_lockBeforeDate_1 = sel_registerName("lockBeforeDate:");
public static final int sel_unlockWithCondition_1 = sel_registerName("unlockWithCondition:");
public static final int sel_nextWordFromIndex_1forward_1 = sel_registerName("nextWordFromIndex:forward:");
public static final int sel_waitUntilAllOperationsAreFinished = sel_registerName("waitUntilAllOperationsAreFinished");
public static final int sel_drawRow_1clipRect_1 = sel_registerName("drawRow:clipRect:");
public static final int sel_setPartialStringValidationEnabled_1 = sel_registerName("setPartialStringValidationEnabled:");
public static final int sel_methodSignatureForSelector_1 = sel_registerName("methodSignatureForSelector:");
public static final int sel_setSecondaryGroupingSize_1 = sel_registerName("setSecondaryGroupingSize:");
public static final int sel_criteriaForRow_1 = sel_registerName("criteriaForRow:");
public static final int sel_setShadowBlurRadius_1 = sel_registerName("setShadowBlurRadius:");
public static final int sel_expressionForFunction_1selectorName_1arguments_1 = sel_registerName("expressionForFunction:selectorName:arguments:");
public static final int sel_initWithWindowNibName_1 = sel_registerName("initWithWindowNibName:");
public static final int sel_selectItemWithTag_1 = sel_registerName("selectItemWithTag:");
public static final int sel_characterIndexForPoint_1 = sel_registerName("characterIndexForPoint:");
public static final int sel_validate = sel_registerName("validate");
public static final int sel_setHorizontalPageScroll_1 = sel_registerName("setHorizontalPageScroll:");
public static final int sel_localizedColorNameComponent = sel_registerName("localizedColorNameComponent");
public static final int sel_setVoice_1 = sel_registerName("setVoice:");
public static final int sel_setCachedSeparately_1 = sel_registerName("setCachedSeparately:");
public static final int sel_frameRectForContentRect_1 = sel_registerName("frameRectForContentRect:");
public static final int sel_bezelStyle = sel_registerName("bezelStyle");
public static final int sel_setDecimalSeparator_1 = sel_registerName("setDecimalSeparator:");
public static final int sel_conversationIdentifier = sel_registerName("conversationIdentifier");
public static final int sel_setPrompt_1 = sel_registerName("setPrompt:");
public static final int sel_setShowsFirstResponder_1 = sel_registerName("setShowsFirstResponder:");
public static final int sel_setRootObject_1 = sel_registerName("setRootObject:");
public static final int sel_menuBarVisible = sel_registerName("menuBarVisible");
public static final int sel_netServiceBrowser_1didRemoveDomain_1moreComing_1 = sel_registerName("netServiceBrowser:didRemoveDomain:moreComing:");
public static final int sel_threadPriority = sel_registerName("threadPriority");
public static final int sel_countKeyPath = sel_registerName("countKeyPath");
public static final int sel_runCustomizationPalette_1 = sel_registerName("runCustomizationPalette:");
public static final int sel_fileHandleWithStandardError = sel_registerName("fileHandleWithStandardError");
public static final int sel_documentContentKind = sel_registerName("documentContentKind");
public static final int sel_view_1stringForToolTip_1point_1userData_1 = sel_registerName("view:stringForToolTip:point:userData:");
public static final int sel_nameFieldLabel = sel_registerName("nameFieldLabel");
public static final int sel_miniaturizeAll_1 = sel_registerName("miniaturizeAll:");
public static final int sel_initWithRepresentedObject_1 = sel_registerName("initWithRepresentedObject:");
public static final int sel_runOperation = sel_registerName("runOperation");
public static final int sel_drawBackgroundForBlock_1withFrame_1inView_1characterRange_1layoutManager_1 = sel_registerName("drawBackgroundForBlock:withFrame:inView:characterRange:layoutManager:");
public static final int sel_localizedInfoDictionary = sel_registerName("localizedInfoDictionary");
public static final int sel_scanFloat_1 = sel_registerName("scanFloat:");
public static final int sel_scanHexDouble_1 = sel_registerName("scanHexDouble:");
public static final int sel_continueSpeaking = sel_registerName("continueSpeaking");
public static final int sel_attachedMenuView = sel_registerName("attachedMenuView");
public static final int sel_wantsToHandleMouseEvents = sel_registerName("wantsToHandleMouseEvents");
public static final int sel_attemptRecoveryFromError_1optionIndex_1 = sel_registerName("attemptRecoveryFromError:optionIndex:");
public static final int sel_window_1shouldDragDocumentWithEvent_1from_1withPasteboard_1 = sel_registerName("window:shouldDragDocumentWithEvent:from:withPasteboard:");
public static final int sel_mouseEntered_1 = sel_registerName("mouseEntered:");
public static final int sel_setNameFieldLabel_1 = sel_registerName("setNameFieldLabel:");
public static final int sel_setIndentationPerLevel_1 = sel_registerName("setIndentationPerLevel:");
public static final int sel_setMinColumnWidth_1 = sel_registerName("setMinColumnWidth:");
public static final int sel_classNameForClass_1 = sel_registerName("classNameForClass:");
public static final int sel_runLoopModes = sel_registerName("runLoopModes");
public static final int sel_pullsDown = sel_registerName("pullsDown");
public static final int sel_setOutlineTableColumn_1 = sel_registerName("setOutlineTableColumn:");
public static final int sel_windowDidLoad = sel_registerName("windowDidLoad");
public static final int sel_read_1maxLength_1 = sel_registerName("read:maxLength:");
public static final int sel_removeItemAtIndex_1 = sel_registerName("removeItemAtIndex:");
public static final int sel_initWithColor_1 = sel_registerName("initWithColor:");
public static final int sel_compare_1options_1 = sel_registerName("compare:options:");
public static final int sel_removeTableColumn_1 = sel_registerName("removeTableColumn:");
public static final int sel_isRedoing = sel_registerName("isRedoing");
public static final int sel_setTitleWithRepresentedFilename_1 = sel_registerName("setTitleWithRepresentedFilename:");
public static final int sel_setDirectory_1 = sel_registerName("setDirectory:");
public static final int sel_makeDocumentWithContentsOfURL_1ofType_1error_1 = sel_registerName("makeDocumentWithContentsOfURL:ofType:error:");
public static final int sel_isSelectedForSegment_1 = sel_registerName("isSelectedForSegment:");
public static final int sel_month = sel_registerName("month");
public static final int sel_addRow = sel_registerName("addRow");
public static final int sel_layoutOptions = sel_registerName("layoutOptions");
public static final int sel_maxNumberOfRows = sel_registerName("maxNumberOfRows");
public static final int sel_setUpPrintOperationDefaultValues = sel_registerName("setUpPrintOperationDefaultValues");
public static final int sel_initByReferencingURL_1 = sel_registerName("initByReferencingURL:");
public static final int sel_class = sel_registerName("class");
public static final int sel_setFrameAutosaveName_1 = sel_registerName("setFrameAutosaveName:");
public static final int sel_fileWrapperFromRange_1documentAttributes_1error_1 = sel_registerName("fileWrapperFromRange:documentAttributes:error:");
public static final int sel_int32Value = sel_registerName("int32Value");
public static final int sel_setControlView_1 = sel_registerName("setControlView:");
public static final int sel_setCharacterEncoding_1 = sel_registerName("setCharacterEncoding:");
public static final int sel_disableFlushWindow = sel_registerName("disableFlushWindow");
public static final int sel_insertString_1atIndex_1 = sel_registerName("insertString:atIndex:");
public static final int sel_childNodes = sel_registerName("childNodes");
public static final int sel_rangeContainerObject = sel_registerName("rangeContainerObject");
public static final int sel_kind = sel_registerName("kind");
public static final int sel_title = sel_registerName("title");
public static final int sel_bundleWithIdentifier_1 = sel_registerName("bundleWithIdentifier:");
public static final int sel_initWithMovie_1 = sel_registerName("initWithMovie:");
public static final int sel_unionHashTable_1 = sel_registerName("unionHashTable:");
public static final int sel_setStartSpecifier_1 = sel_registerName("setStartSpecifier:");
public static final int sel_browser_1nextTypeSelectMatchFromRow_1toRow_1inColumn_1forString_1 = sel_registerName("browser:nextTypeSelectMatchFromRow:toRow:inColumn:forString:");
public static final int sel_tokenFieldCell_1representedObjectForEditingString_1 = sel_registerName("tokenFieldCell:representedObjectForEditingString:");
public static final int sel_initWithContentsOfFile_1 = sel_registerName("initWithContentsOfFile:");
public static final int sel_dataWithContentsOfURL_1 = sel_registerName("dataWithContentsOfURL:");
public static final int sel_firstWeekday = sel_registerName("firstWeekday");
public static final int sel_setInitialValues_1 = sel_registerName("setInitialValues:");
public static final int sel_setIntegerValue_1 = sel_registerName("setIntegerValue:");
public static final int sel_calcSize = sel_registerName("calcSize");
public static final int sel_setTokenizingCharacterSet_1 = sel_registerName("setTokenizingCharacterSet:");
public static final int sel_setRepresentedFilename_1 = sel_registerName("setRepresentedFilename:");
public static final int sel_colorSpaceName = sel_registerName("colorSpaceName");
public static final int sel_setLineBreakMode_1 = sel_registerName("setLineBreakMode:");
public static final int sel_appliesImmediately = sel_registerName("appliesImmediately");
public static final int sel_classDescriptionWithAppleEventCode_1 = sel_registerName("classDescriptionWithAppleEventCode:");
public static final int sel_eventRef = sel_registerName("eventRef");
public static final int sel_textAttributesForZero = sel_registerName("textAttributesForZero");
public static final int sel_setAutosavesConfiguration_1 = sel_registerName("setAutosavesConfiguration:");
public static final int sel_countOfIndexesInRange_1 = sel_registerName("countOfIndexesInRange:");
public static final int sel_count = sel_registerName("count");
public static final int sel_initWithSuiteName_1className_1dictionary_1 = sel_registerName("initWithSuiteName:className:dictionary:");
public static final int sel_isReleasedWhenClosed = sel_registerName("isReleasedWhenClosed");
public static final int sel_windowWithWindowNumber_1 = sel_registerName("windowWithWindowNumber:");
public static final int sel_removeNamespaceForPrefix_1 = sel_registerName("removeNamespaceForPrefix:");
public static final int sel_documentWithRootElement_1 = sel_registerName("documentWithRootElement:");
public static final int sel_pageFooter = sel_registerName("pageFooter");
public static final int sel_initWithOptions_1capacity_1 = sel_registerName("initWithOptions:capacity:");
public static final int sel_insertBacktab_1 = sel_registerName("insertBacktab:");
public static final int sel_changeWindowsItem_1title_1filename_1 = sel_registerName("changeWindowsItem:title:filename:");
public static final int sel_changeCount = sel_registerName("changeCount");
public static final int sel_paragraphCharacterRange = sel_registerName("paragraphCharacterRange");
public static final int sel_currentProgress = sel_registerName("currentProgress");
public static final int sel_parser_1didStartMappingPrefix_1toURI_1 = sel_registerName("parser:didStartMappingPrefix:toURI:");
public static final int sel_setFormatWidth_1 = sel_registerName("setFormatWidth:");
public static final int sel_cancelAllOperations = sel_registerName("cancelAllOperations");
public static final int sel_beginLoadInBackground = sel_registerName("beginLoadInBackground");
public static final int sel_draggedDistance = sel_registerName("draggedDistance");
public static final int sel_setIndex_1 = sel_registerName("setIndex:");
public static final int sel_initWithScheme_1host_1path_1 = sel_registerName("initWithScheme:host:path:");
public static final int sel_toolTipForCell_1 = sel_registerName("toolTipForCell:");
public static final int sel_predicateForRow_1 = sel_registerName("predicateForRow:");
public static final int sel_predefinedEntityDeclarationForName_1 = sel_registerName("predefinedEntityDeclarationForName:");
public static final int sel_replacePointerAtIndex_1withPointer_1 = sel_registerName("replacePointerAtIndex:withPointer:");
public static final int sel_fileURLWithPath_1 = sel_registerName("fileURLWithPath:");
public static final int sel_currentDocument = sel_registerName("currentDocument");
public static final int sel_shouldDrawInsertionPoint = sel_registerName("shouldDrawInsertionPoint");
public static final int sel_saveAllDocuments_1 = sel_registerName("saveAllDocuments:");
public static final int sel_windowControllerWillLoadNib_1 = sel_registerName("windowControllerWillLoadNib:");
public static final int sel_closeAllDocumentsWithDelegate_1didCloseAllSelector_1contextInfo_1 = sel_registerName("closeAllDocumentsWithDelegate:didCloseAllSelector:contextInfo:");
public static final int sel_tableView_1heightOfRow_1 = sel_registerName("tableView:heightOfRow:");
public static final int sel_postNotificationName_1object_1userInfo_1options_1 = sel_registerName("postNotificationName:object:userInfo:options:");
public static final int sel_imageTypes = sel_registerName("imageTypes");
public static final int sel_setPreferredBackingLocation_1 = sel_registerName("setPreferredBackingLocation:");
public static final int sel_netServiceDidPublish_1 = sel_registerName("netServiceDidPublish:");
public static final int sel_diskCapacity = sel_registerName("diskCapacity");
public static final int sel_initWithString_1calendarFormat_1locale_1 = sel_registerName("initWithString:calendarFormat:locale:");
public static final int sel_preferredEdge = sel_registerName("preferredEdge");
public static final int sel_comboBoxCell_1indexOfItemWithStringValue_1 = sel_registerName("comboBoxCell:indexOfItemWithStringValue:");
public static final int sel_replaceCharactersInRange_1withString_1 = sel_registerName("replaceCharactersInRange:withString:");
public static final int sel_initWithTimeIntervalSinceReferenceDate_1 = sel_registerName("initWithTimeIntervalSinceReferenceDate:");
public static final int sel_secondsFromGMT = sel_registerName("secondsFromGMT");
public static final int sel_hasOrderedToManyRelationshipForKey_1 = sel_registerName("hasOrderedToManyRelationshipForKey:");
public static final int sel_resignFirstResponder = sel_registerName("resignFirstResponder");
public static final int sel_netServiceDidStop_1 = sel_registerName("netServiceDidStop:");
public static final int sel_absoluteY = sel_registerName("absoluteY");
public static final int sel_beginModalSessionForWindow_1 = sel_registerName("beginModalSessionForWindow:");
public static final int sel_alignment = sel_registerName("alignment");
public static final int sel_setCharactersToBeSkipped_1 = sel_registerName("setCharactersToBeSkipped:");
public static final int sel_requestWithURL_1cachePolicy_1timeoutInterval_1 = sel_registerName("requestWithURL:cachePolicy:timeoutInterval:");
public static final int sel_ruler = sel_registerName("ruler");
public static final int sel_isSetOnMouseExited = sel_registerName("isSetOnMouseExited");
public static final int sel_setRemovable_1 = sel_registerName("setRemovable:");
public static final int sel_draggingSource = sel_registerName("draggingSource");
public static final int sel_textView_1clickedOnLink_1 = sel_registerName("textView:clickedOnLink:");
public static final int sel_canBeVisibleOnAllSpaces = sel_registerName("canBeVisibleOnAllSpaces");
public static final int sel_setBadgeLabel_1 = sel_registerName("setBadgeLabel:");
public static final int sel_parser_1foundUnparsedEntityDeclarationWithName_1publicID_1systemID_1notationName_1 = sel_registerName("parser:foundUnparsedEntityDeclarationWithName:publicID:systemID:notationName:");
public static final int sel_operations = sel_registerName("operations");
public static final int sel_setInteger_1forKey_1 = sel_registerName("setInteger:forKey:");
public static final int sel_otherMouseUp_1 = sel_registerName("otherMouseUp:");
public static final int sel_drawImageWithFrame_1inView_1 = sel_registerName("drawImageWithFrame:inView:");
public static final int sel_getPixel_1atX_1y_1 = sel_registerName("getPixel:atX:y:");
public static final int sel_standardError = sel_registerName("standardError");
public static final int sel_setLabel_1 = sel_registerName("setLabel:");
public static final int sel_initWithUnsignedInt_1 = sel_registerName("initWithUnsignedInt:");
public static final int sel_isFinished = sel_registerName("isFinished");
public static final int sel_drawSwatchInRect_1 = sel_registerName("drawSwatchInRect:");
public static final int sel_descriptorAtIndex_1 = sel_registerName("descriptorAtIndex:");
public static final int sel_cachedHandleForURL_1 = sel_registerName("cachedHandleForURL:");
public static final int sel_classCode = sel_registerName("classCode");
public static final int sel_resolvesAliases = sel_registerName("resolvesAliases");
public static final int sel_textTypes = sel_registerName("textTypes");
public static final int sel_invalidateTextContainerOrigin = sel_registerName("invalidateTextContainerOrigin");
public static final int sel_document = sel_registerName("document");
public static final int sel_interiorBackgroundStyleForSegment_1 = sel_registerName("interiorBackgroundStyleForSegment:");
public static final int sel_transformedValue_1 = sel_registerName("transformedValue:");
public static final int sel_substringToIndex_1 = sel_registerName("substringToIndex:");
public static final int sel_addDocument_1 = sel_registerName("addDocument:");
public static final int sel_numberWithInteger_1 = sel_registerName("numberWithInteger:");
public static final int sel_setBoundsRotation_1 = sel_registerName("setBoundsRotation:");
public static final int sel_convertFont_1toFace_1 = sel_registerName("convertFont:toFace:");
public static final int sel_updateInsertionPointStateAndRestartTimer_1 = sel_registerName("updateInsertionPointStateAndRestartTimer:");
public static final int sel_tryToPerform_1with_1 = sel_registerName("tryToPerform:with:");
public static final int sel_defaultLineHeightForFont = sel_registerName("defaultLineHeightForFont");
public static final int sel_scriptingIsEqualTo_1 = sel_registerName("scriptingIsEqualTo:");
public static final int sel_setDoubleValue_1 = sel_registerName("setDoubleValue:");
public static final int sel_AMSymbol = sel_registerName("AMSymbol");
public static final int sel_valueWraps = sel_registerName("valueWraps");
public static final int sel_allCredentials = sel_registerName("allCredentials");
public static final int sel_editingDelegate = sel_registerName("editingDelegate");
public static final int sel_maintainsInactiveSelection = sel_registerName("maintainsInactiveSelection");
public static final int sel_policyDelegate = sel_registerName("policyDelegate");
public static final int sel_preferences = sel_registerName("preferences");
public static final int sel_registerViewClass_1representationClass_1forMIMEType_1 = sel_registerName("registerViewClass:representationClass:forMIMEType:");
public static final int sel_setHostWindow_1 = sel_registerName("setHostWindow:");
public static final int sel_hostWindow = sel_registerName("hostWindow");
public static final int sel_searchFor_1direction_1caseSensitive_1wrap_1 = sel_registerName("searchFor:direction:caseSensitive:wrap:");
public static final int sel_initWithFrame_1frameName_1groupName_1 = sel_registerName("initWithFrame:frameName:groupName:");
public static final int sel_canGoBack = sel_registerName("canGoBack");
public static final int sel_setFrameLoadDelegate_1 = sel_registerName("setFrameLoadDelegate:");
public static final int sel_takeStringURLFrom_1 = sel_registerName("takeStringURLFrom:");
public static final int sel_registerURLSchemeAsLocal_1 = sel_registerName("registerURLSchemeAsLocal:");
public static final int sel_stringByEvaluatingJavaScriptFromString_1 = sel_registerName("stringByEvaluatingJavaScriptFromString:");
public static final int sel_replaceSelectionWithMarkupString_1 = sel_registerName("replaceSelectionWithMarkupString:");
public static final int sel_setPreferences_1 = sel_registerName("setPreferences:");
public static final int sel_customUserAgent = sel_registerName("customUserAgent");
public static final int sel_mainFrame = sel_registerName("mainFrame");
public static final int sel_goToBackForwardItem_1 = sel_registerName("goToBackForwardItem:");
public static final int sel_pasteboardTypesForElement_1 = sel_registerName("pasteboardTypesForElement:");
public static final int sel_applyStyle_1 = sel_registerName("applyStyle:");
public static final int sel_setResourceLoadDelegate_1 = sel_registerName("setResourceLoadDelegate:");
public static final int sel_moveToBeginningOfSentenceAndModifySelection_1 = sel_registerName("moveToBeginningOfSentenceAndModifySelection:");
public static final int sel_replaceSelectionWithArchive_1 = sel_registerName("replaceSelectionWithArchive:");
public static final int sel_userAgentForURL_1 = sel_registerName("userAgentForURL:");
public static final int sel_frameLoadDelegate = sel_registerName("frameLoadDelegate");
public static final int sel_windowScriptObject = sel_registerName("windowScriptObject");
public static final int sel_removeDragCaret = sel_registerName("removeDragCaret");
public static final int sel_editableDOMRangeForPoint_1 = sel_registerName("editableDOMRangeForPoint:");
public static final int sel_moveToEndOfSentence_1 = sel_registerName("moveToEndOfSentence:");
public static final int sel_preferencesIdentifier = sel_registerName("preferencesIdentifier");
public static final int sel_setPolicyDelegate_1 = sel_registerName("setPolicyDelegate:");
public static final int sel_goBack = sel_registerName("goBack");
public static final int sel_downloadDelegate = sel_registerName("downloadDelegate");
public static final int sel_canShowMIMEType_1 = sel_registerName("canShowMIMEType:");
public static final int sel_elementAtPoint_1 = sel_registerName("elementAtPoint:");
public static final int sel_groupName = sel_registerName("groupName");
public static final int sel_selectedFrame = sel_registerName("selectedFrame");
public static final int sel_setMIMETypesShownAsHTML_1 = sel_registerName("setMIMETypesShownAsHTML:");
public static final int sel_goForward = sel_registerName("goForward");
public static final int sel_makeTextStandardSize_1 = sel_registerName("makeTextStandardSize:");
public static final int sel_setMainFrameURL_1 = sel_registerName("setMainFrameURL:");
public static final int sel_pasteboardTypesForSelection = sel_registerName("pasteboardTypesForSelection");
public static final int sel_customTextEncodingName = sel_registerName("customTextEncodingName");
public static final int sel_MIMETypesShownAsHTML = sel_registerName("MIMETypesShownAsHTML");
public static final int sel_replaceSelectionWithText_1 = sel_registerName("replaceSelectionWithText:");
public static final int sel_setTextSizeMultiplier_1 = sel_registerName("setTextSizeMultiplier:");
public static final int sel_stopLoading_1 = sel_registerName("stopLoading:");
public static final int sel_goBack_1 = sel_registerName("goBack:");
public static final int sel_canMakeTextStandardSize = sel_registerName("canMakeTextStandardSize");
public static final int sel_setCustomUserAgent_1 = sel_registerName("setCustomUserAgent:");
public static final int sel_moveDragCaretToPoint_1 = sel_registerName("moveDragCaretToPoint:");
public static final int sel_makeTextSmaller_1 = sel_registerName("makeTextSmaller:");
public static final int sel_moveToBeginningOfSentence_1 = sel_registerName("moveToBeginningOfSentence:");
public static final int sel_reload_1 = sel_registerName("reload:");
public static final int sel_typingStyle = sel_registerName("typingStyle");
public static final int sel_setShouldCloseWithWindow_1 = sel_registerName("setShouldCloseWithWindow:");
public static final int sel_setMediaStyle_1 = sel_registerName("setMediaStyle:");
public static final int sel_canMakeTextLarger = sel_registerName("canMakeTextLarger");
public static final int sel_textSizeMultiplier = sel_registerName("textSizeMultiplier");
public static final int sel_shouldCloseWithWindow = sel_registerName("shouldCloseWithWindow");
public static final int sel_setPreferencesIdentifier_1 = sel_registerName("setPreferencesIdentifier:");
public static final int sel_setApplicationNameForUserAgent_1 = sel_registerName("setApplicationNameForUserAgent:");
public static final int sel_mainFrameURL = sel_registerName("mainFrameURL");
public static final int sel_goForward_1 = sel_registerName("goForward:");
public static final int sel_selectedDOMRange = sel_registerName("selectedDOMRange");
public static final int sel_setDownloadDelegate_1 = sel_registerName("setDownloadDelegate:");
public static final int sel_setEditingDelegate_1 = sel_registerName("setEditingDelegate:");
public static final int sel_setUIDelegate_1 = sel_registerName("setUIDelegate:");
public static final int sel_mainFrameTitle = sel_registerName("mainFrameTitle");
public static final int sel_setSelectedDOMRange_1affinity_1 = sel_registerName("setSelectedDOMRange:affinity:");
public static final int sel_setTypingStyle_1 = sel_registerName("setTypingStyle:");
public static final int sel_backForwardList = sel_registerName("backForwardList");
public static final int sel_deleteSelection = sel_registerName("deleteSelection");
public static final int sel_canGoForward = sel_registerName("canGoForward");
public static final int sel_styleDeclarationWithText_1 = sel_registerName("styleDeclarationWithText:");
public static final int sel_moveToEndOfSentenceAndModifySelection_1 = sel_registerName("moveToEndOfSentenceAndModifySelection:");
public static final int sel_replaceSelectionWithNode_1 = sel_registerName("replaceSelectionWithNode:");
public static final int sel_URLTitleFromPasteboard_1 = sel_registerName("URLTitleFromPasteboard:");
public static final int sel_UIDelegate = sel_registerName("UIDelegate");
public static final int sel_setMaintainsBackForwardList_1 = sel_registerName("setMaintainsBackForwardList:");
public static final int sel_mainFrameIcon = sel_registerName("mainFrameIcon");
public static final int sel_setGroupName_1 = sel_registerName("setGroupName:");
public static final int sel_canMakeTextSmaller = sel_registerName("canMakeTextSmaller");
public static final int sel_applicationNameForUserAgent = sel_registerName("applicationNameForUserAgent");
public static final int sel_supportsTextEncoding = sel_registerName("supportsTextEncoding");
public static final int sel_canShowMIMETypeAsHTML_1 = sel_registerName("canShowMIMETypeAsHTML:");
public static final int sel_mediaStyle = sel_registerName("mediaStyle");
public static final int sel_makeTextLarger_1 = sel_registerName("makeTextLarger:");
public static final int sel_writeElement_1withPasteboardTypes_1toPasteboard_1 = sel_registerName("writeElement:withPasteboardTypes:toPasteboard:");
public static final int sel_estimatedProgress = sel_registerName("estimatedProgress");
public static final int sel_setCustomTextEncodingName_1 = sel_registerName("setCustomTextEncodingName:");
public static final int sel_mainFrameDocument = sel_registerName("mainFrameDocument");
public static final int sel_isLoading = sel_registerName("isLoading");
public static final int sel_selectSentence_1 = sel_registerName("selectSentence:");
public static final int sel_computedStyleForElement_1pseudoElement_1 = sel_registerName("computedStyleForElement:pseudoElement:");
public static final int sel_writeSelectionWithPasteboardTypes_1toPasteboard_1 = sel_registerName("writeSelectionWithPasteboardTypes:toPasteboard:");
public static final int sel_resourceLoadDelegate = sel_registerName("resourceLoadDelegate");
public static final int sel_reload = sel_registerName("reload");
public static final int sel_loadAlternateHTMLString_1baseURL_1forUnreachableURL_1 = sel_registerName("loadAlternateHTMLString:baseURL:forUnreachableURL:");
public static final int sel_loadHTMLString_1baseURL_1 = sel_registerName("loadHTMLString:baseURL:");
public static final int sel_loadArchive_1 = sel_registerName("loadArchive:");
public static final int sel_webView = sel_registerName("webView");
public static final int sel_provisionalDataSource = sel_registerName("provisionalDataSource");
public static final int sel_findFrameNamed_1 = sel_registerName("findFrameNamed:");
public static final int sel_DOMDocument = sel_registerName("DOMDocument");
public static final int sel_frameView = sel_registerName("frameView");
public static final int sel_globalContext = sel_registerName("globalContext");
public static final int sel_windowObject = sel_registerName("windowObject");
public static final int sel_childFrames = sel_registerName("childFrames");
public static final int sel_loadData_1MIMEType_1textEncodingName_1baseURL_1 = sel_registerName("loadData:MIMEType:textEncodingName:baseURL:");
public static final int sel_initWithName_1webFrameView_1webView_1 = sel_registerName("initWithName:webFrameView:webView:");
public static final int sel_frameElement = sel_registerName("frameElement");
public static final int sel_loadRequest_1 = sel_registerName("loadRequest:");
public static final int sel_parentFrame = sel_registerName("parentFrame");
public static final int sel_representation = sel_registerName("representation");
public static final int sel_documentSource = sel_registerName("documentSource");
public static final int sel_webView_1didChangeLocationWithinPageForFrame_1 = sel_registerName("webView:didChangeLocationWithinPageForFrame:");
public static final int sel_webView_1didFailProvisionalLoadWithError_1forFrame_1 = sel_registerName("webView:didFailProvisionalLoadWithError:forFrame:");
public static final int sel_webView_1didFinishLoadForFrame_1 = sel_registerName("webView:didFinishLoadForFrame:");
public static final int sel_webView_1didReceiveTitle_1forFrame_1 = sel_registerName("webView:didReceiveTitle:forFrame:");
public static final int sel_webView_1didStartProvisionalLoadForFrame_1 = sel_registerName("webView:didStartProvisionalLoadForFrame:");
public static final int sel_webView_1didCommitLoadForFrame_1 = sel_registerName("webView:didCommitLoadForFrame:");
public static final int sel_webView_1resource_1didFinishLoadingFromDataSource_1 = sel_registerName("webView:resource:didFinishLoadingFromDataSource:");
public static final int sel_webView_1resource_1didFailLoadingWithError_1fromDataSource_1 = sel_registerName("webView:resource:didFailLoadingWithError:fromDataSource:");
public static final int sel_webView_1identifierForInitialRequest_1fromDataSource_1 = sel_registerName("webView:identifierForInitialRequest:fromDataSource:");
public static final int sel_webView_1resource_1willSendRequest_1redirectResponse_1fromDataSource_1 = sel_registerName("webView:resource:willSendRequest:redirectResponse:fromDataSource:");
public static final int sel_webView_1createWebViewWithRequest_1 = sel_registerName("webView:createWebViewWithRequest:");
public static final int sel_webViewShow_1 = sel_registerName("webViewShow:");
public static final int sel_webView_1setFrame_1 = sel_registerName("webView:setFrame:");
public static final int sel_webViewClose_1 = sel_registerName("webViewClose:");
public static final int sel_webView_1contextMenuItemsForElement_1defaultMenuItems_1 = sel_registerName("webView:contextMenuItemsForElement:defaultMenuItems:");
public static final int sel_webView_1setStatusBarVisible_1 = sel_registerName("webView:setStatusBarVisible:");
public static final int sel_webView_1setResizable_1 = sel_registerName("webView:setResizable:");
public static final int sel_webView_1setToolbarsVisible_1 = sel_registerName("webView:setToolbarsVisible:");
public static final int sel_webView_1setStatusText_1 = sel_registerName("webView:setStatusText:");
public static final int sel_webViewFocus_1 = sel_registerName("webViewFocus:");
public static final int sel_webViewUnfocus_1 = sel_registerName("webViewUnfocus:");
public static final int sel_webView_1runJavaScriptAlertPanelWithMessage_1 = sel_registerName("webView:runJavaScriptAlertPanelWithMessage:");
public static final int sel_webView_1runJavaScriptConfirmPanelWithMessage_1 = sel_registerName("webView:runJavaScriptConfirmPanelWithMessage:");
public static final int sel_webView_1runOpenPanelForFileButtonWithResultListener_1 = sel_registerName("webView:runOpenPanelForFileButtonWithResultListener:");
public static final int sel_webView_1mouseDidMoveOverElement_1modifierFlags_1 = sel_registerName("webView:mouseDidMoveOverElement:modifierFlags:");
public static final int sel_webView_1printFrameView_1 = sel_registerName("webView:printFrameView:");
public static final int sel_webView_1decidePolicyForMIMEType_1request_1frame_1decisionListener_1 = sel_registerName("webView:decidePolicyForMIMEType:request:frame:decisionListener:");
public static final int sel_webView_1decidePolicyForNewWindowAction_1request_1newFrameName_1decisionListener_1 = sel_registerName("webView:decidePolicyForNewWindowAction:request:newFrameName:decisionListener:");
public static final int sel_webView_1unableToImplementPolicyWithError_1frame_1 = sel_registerName("webView:unableToImplementPolicyWithError:frame:");
public static final int sel_webView_1decidePolicyForNavigationAction_1request_1frame_1decisionListener_1 = sel_registerName("webView:decidePolicyForNavigationAction:request:frame:decisionListener::");
public static final int sel_standardPreferences = sel_registerName("standardPreferences");
public static final int sel_setJavaEnabled_1 = sel_registerName("setJavaEnabled:");
public static final int sel_use = sel_registerName("use");
public static final int sel_download = sel_registerName("download");
public static final int sel_ignore = sel_registerName("ignore");
public static final int sel_pageTitle = sel_registerName("pageTitle");
public static final int sel_webFrame = sel_registerName("webFrame");
public static final int sel_chooseFilename_1 = sel_registerName("chooseFilename:");
public static final int sel_addEventListener_1listener_1useCapture_1 = sel_registerName("addEventListener:listener:useCapture:");
public static final int sel_handleEvent_1 = sel_registerName("handleEvent:");
public static final int sel_cancelable = sel_registerName("cancelable");
public static final int sel_timeStamp = sel_registerName("timeStamp");
public static final int sel_initEvent_1_1_1 = sel_registerName("initEvent:::");
public static final int sel_bubbles = sel_registerName("bubbles");
public static final int sel_stopPropagation = sel_registerName("stopPropagation");
public static final int sel_initEvent_1canBubbleArg_1cancelableArg_1 = sel_registerName("initEvent:canBubbleArg:cancelableArg:");
public static final int sel_eventPhase = sel_registerName("eventPhase");
public static final int sel_currentTarget = sel_registerName("currentTarget");
public static final int sel_preventDefault = sel_registerName("preventDefault");
public static final int sel_screenX = sel_registerName("screenX");
public static final int sel_initMouseEvent_1_1_1_1_1_1_1_1_1_1_1_1_1_1_1 = sel_registerName("initMouseEvent:::::::::::::::");
public static final int sel_clientY = sel_registerName("clientY");
public static final int sel_charCode = sel_registerName("charCode");
public static final int sel_relatedTarget = sel_registerName("relatedTarget");
public static final int sel_button = sel_registerName("button");
public static final int sel_clientX = sel_registerName("clientX");
public static final int sel_initMouseEvent_1canBubble_1cancelable_1view_1detail_1screenX_1screenY_1clientX_1clientY_1ctrlKey_1altKey_1shiftKey_1metaKey_1button_1relatedTarget_1 = sel_registerName("initMouseEvent:canBubble:cancelable:view:detail:screenX:screenY:clientX:clientY:ctrlKey:altKey:shiftKey:metaKey:button:relatedTarget:");
public static final int sel_shiftKey = sel_registerName("shiftKey");
public static final int sel_ctrlKey = sel_registerName("ctrlKey");
public static final int sel_metaKey = sel_registerName("metaKey");
public static final int sel_altKey = sel_registerName("altKey");
public static final int sel_keyLocation = sel_registerName("keyLocation");
public static final int sel_getModifierState_1 = sel_registerName("getModifierState:");
public static final int sel_screenY = sel_registerName("screenY");
public static final int sel_detail = sel_registerName("detail");
public static final int sel_handleNotification_1 = sel_registerName("handleNotification:");
public static final int sel_setAllowsScrolling_1 = sel_registerName("setAllowsScrolling:");
public static final int sel_allowsScrolling = sel_registerName("allowsScrolling");
public static final int sel_printDocumentView = sel_registerName("printDocumentView");
public static final int sel_documentViewShouldHandlePrint = sel_registerName("documentViewShouldHandlePrint");
public static final int sel_printOperationWithPrintInfo_1 = sel_registerName("printOperationWithPrintInfo:");
public static final int sel_canPrintHeadersAndFooters = sel_registerName("canPrintHeadersAndFooters");
public static final int sel_wheelDelta = sel_registerName("wheelDelta");

/** Constants */
public static final int NSAWTEventType = 16;
public static final int NSAboveBottom = 4;
public static final int NSAboveTop = 1;
public static final int NSAddTraitFontAction = 2;
public static final int NSAdobeCNS1CharacterCollection = 1;
public static final int NSAdobeGB1CharacterCollection = 2;
public static final int NSAdobeJapan1CharacterCollection = 3;
public static final int NSAdobeJapan2CharacterCollection = 4;
public static final int NSAdobeKorea1CharacterCollection = 5;
public static final int NSAlertAlternateReturn = 0;
public static final int NSAlertDefaultReturn = 1;
public static final int NSAlertErrorReturn = -2;
public static final int NSAlertFirstButtonReturn = 1000;
public static final int NSAlertOtherReturn = -1;
public static final int NSAlertSecondButtonReturn = 1001;
public static final int NSAlertThirdButtonReturn = 1002;
public static final int NSAllScrollerParts = 2;
public static final int NSAlphaFirstBitmapFormat = 1;
public static final int NSAlphaNonpremultipliedBitmapFormat = 2;
public static final int NSAlphaShiftKeyMask = 65536;
public static final int NSAlternateKeyMask = 524288;
public static final int NSAnimationBlocking = 0;
public static final int NSAnimationEaseIn = 1;
public static final int NSAnimationEaseInOut = 0;
public static final int NSAnimationEaseOut = 2;
public static final int NSAnimationEffectDisappearingItemDefault = 0;
public static final int NSAnimationEffectPoof = 10;
public static final int NSAnimationLinear = 3;
public static final int NSAnimationNonblocking = 1;
public static final int NSAnimationNonblockingThreaded = 2;
public static final int NSAnyEventMask = -1;
public static final int NSAnyType = 0;
public static final int NSAppKitDefined = 13;
public static final int NSAppKitDefinedMask = 8192;
public static final int NSAppKitVersionNumber10_0 = 577;
public static final int NSAppKitVersionNumber10_1 = 620;
public static final int NSAppKitVersionNumber10_2 = 663;
public static final double NSAppKitVersionNumber10_2_3 = 663.60000000000002;
public static final int NSAppKitVersionNumber10_3 = 743;
public static final double NSAppKitVersionNumber10_3_2 = 743.13999999999999;
public static final double NSAppKitVersionNumber10_3_3 = 743.20000000000005;
public static final double NSAppKitVersionNumber10_3_5 = 743.24000000000001;
public static final double NSAppKitVersionNumber10_3_7 = 743.33000000000004;
public static final double NSAppKitVersionNumber10_3_9 = 743.36000000000001;
public static final int NSAppKitVersionNumber10_4 = 824;
public static final double NSAppKitVersionNumberWithColumnResizingBrowser = 685.00000000000000;
public static final double NSAppKitVersionNumberWithContinuousScrollingBrowser = 680.00000000000000;
public static final double NSAppKitVersionNumberWithCursorSizeSupport = 682.00000000000000;
public static final double NSAppKitVersionNumberWithCustomSheetPosition = 686.00000000000000;
public static final double NSAppKitVersionNumberWithDirectionalTabs = 631.00000000000000;
public static final double NSAppKitVersionNumberWithPatternColorLeakFix = 641.00000000000000;
public static final int NSApplicationActivatedEventType = 1;
public static final int NSApplicationDeactivatedEventType = 2;
public static final int NSApplicationDefined = 15;
public static final int NSApplicationDefinedMask = 32768;
public static final int NSApplicationDelegateReplyCancel = 1;
public static final int NSApplicationDelegateReplyFailure = 2;
public static final int NSApplicationDelegateReplySuccess = 0;
public static final int NSAscendingPageOrder = 1;
public static final int NSAtBottom = 5;
public static final int NSAtTop = 2;
public static final int NSAttachmentCharacter = 65532;
public static final int NSAutoPagination = 0;
public static final int NSAutosaveOperation = 3;
public static final int NSBMPFileType = 1;
public static final int NSBackTabCharacter = 25;
public static final int NSBackgroundStyleDark = 1;
public static final int NSBackgroundStyleLight = 0;
public static final int NSBackgroundStyleLowered = 3;
public static final int NSBackgroundStyleRaised = 2;
public static final int NSBackgroundTab = 1;
public static final int NSBackingStoreBuffered = 2;
public static final int NSBackingStoreNonretained = 1;
public static final int NSBackingStoreRetained = 0;
public static final int NSBackspaceCharacter = 8;
public static final int NSBacktabTextMovement = 18;
public static final int NSBeginFunctionKey = 63274;
public static final int NSBelowBottom = 6;
public static final int NSBelowTop = 3;
public static final int NSBevelLineJoinStyle = 2;
public static final int NSBezelBorder = 2;
public static final int NSBlueControlTint = 1;
public static final int NSBoldFontMask = 2;
public static final int NSBorderlessWindowMask = 0;
public static final int NSBottomTabsBezelBorder = 2;
public static final int NSBoxCustom = 4;
public static final int NSBoxOldStyle = 3;
public static final int NSBoxPrimary = 0;
public static final int NSBoxSecondary = 1;
public static final int NSBoxSeparator = 2;
public static final int NSBreakFunctionKey = 63282;
public static final int NSBrowserAutoColumnResizing = 1;
public static final int NSBrowserDropAbove = 1;
public static final int NSBrowserDropOn = 0;
public static final int NSBrowserNoColumnResizing = 0;
public static final int NSBrowserUserColumnResizing = 2;
public static final int NSButtLineCapStyle = 0;
public static final int NSCMYKColorSpaceModel = 2;
public static final int NSCMYKModeColorPanel = 2;
public static final int NSCancelButton = 0;
public static final int NSCancelTextMovement = 23;
public static final int NSCarriageReturnCharacter = 13;
public static final int NSCellAllowsMixedState = 16;
public static final int NSCellChangesContents = 14;
public static final int NSCellDisabled = 0;
public static final int NSCellEditable = 3;
public static final int NSCellHasImageHorizontal = 12;
public static final int NSCellHasImageOnLeftOrBottom = 13;
public static final int NSCellHasOverlappingImage = 11;
public static final int NSCellHighlighted = 5;
public static final int NSCellHitContentArea = 1;
public static final int NSCellHitEditableTextArea = 2;
public static final int NSCellHitNone = 0;
public static final int NSCellHitTrackableArea = 4;
public static final int NSCellIsBordered = 10;
public static final int NSCellIsInsetButton = 15;
public static final int NSCellLightsByBackground = 9;
public static final int NSCellLightsByContents = 6;
public static final int NSCellLightsByGray = 7;
public static final int NSCellState = 1;
public static final int NSCenterTabStopType = 2;
public static final int NSCenterTextAlignment = 2;
public static final int NSChangeAutosaved = 4;
public static final int NSChangeBackgroundCell = 8;
public static final int NSChangeBackgroundCellMask = 8;
public static final int NSChangeCleared = 2;
public static final int NSChangeDone = 0;
public static final int NSChangeGrayCell = 4;
public static final int NSChangeGrayCellMask = 4;
public static final int NSChangeReadOtherContents = 3;
public static final int NSChangeRedone = 5;
public static final int NSChangeUndone = 1;
public static final int NSCircularBezelStyle = 7;
public static final int NSCircularSlider = 1;
public static final int NSClearControlTint = 7;
public static final int NSClearDisplayFunctionKey = 63290;
public static final int NSClearLineFunctionKey = 63289;
public static final int NSClipPagination = 2;
public static final int NSClockAndCalendarDatePickerStyle = 1;
public static final int NSClosableWindowMask = 2;
public static final int NSClosePathBezierPathElement = 3;
public static final int NSColorListModeColorPanel = 5;
public static final int NSColorPanelAllModesMask = 65535;
public static final int NSColorPanelCMYKModeMask = 4;
public static final int NSColorPanelColorListModeMask = 32;
public static final int NSColorPanelCrayonModeMask = 128;
public static final int NSColorPanelCustomPaletteModeMask = 16;
public static final int NSColorPanelGrayModeMask = 1;
public static final int NSColorPanelHSBModeMask = 8;
public static final int NSColorPanelRGBModeMask = 2;
public static final int NSColorPanelWheelModeMask = 64;
public static final int NSColorRenderingIntentAbsoluteColorimetric = 1;
public static final int NSColorRenderingIntentDefault = 0;
public static final int NSColorRenderingIntentPerceptual = 3;
public static final int NSColorRenderingIntentRelativeColorimetric = 2;
public static final int NSColorRenderingIntentSaturation = 4;
public static final int NSCommandKeyMask = 1048576;
public static final int NSCompositeClear = 0;
public static final int NSCompositeCopy = 1;
public static final int NSCompositeDestinationAtop = 9;
public static final int NSCompositeDestinationIn = 7;
public static final int NSCompositeDestinationOut = 8;
public static final int NSCompositeDestinationOver = 6;
public static final int NSCompositeHighlight = 12;
public static final int NSCompositePlusDarker = 11;
public static final int NSCompositePlusLighter = 13;
public static final int NSCompositeSourceAtop = 5;
public static final int NSCompositeSourceIn = 3;
public static final int NSCompositeSourceOut = 4;
public static final int NSCompositeSourceOver = 2;
public static final int NSCompositeXOR = 10;
public static final int NSCompressedFontMask = 512;
public static final int NSCondensedFontMask = 64;
public static final int NSContentsCellMask = 1;
public static final int NSContinuousCapacityLevelIndicatorStyle = 1;
public static final int NSControlGlyph = 16777215;
public static final int NSControlKeyMask = 262144;
public static final int NSCrayonModeColorPanel = 7;
public static final int NSCriticalAlertStyle = 2;
public static final int NSCriticalRequest = 0;
public static final int NSCursorPointingDevice = 2;
public static final int NSCursorUpdate = 17;
public static final int NSCursorUpdateMask = 131072;
public static final int NSCurveToBezierPathElement = 2;
public static final int NSCustomPaletteModeColorPanel = 4;
public static final int NSDecimalTabStopType = 3;
public static final int NSDefaultControlTint = 0;
public static final int NSDefaultTokenStyle = 0;
public static final int NSDeleteCharFunctionKey = 63294;
public static final int NSDeleteCharacter = 127;
public static final int NSDeleteFunctionKey = 63272;
public static final int NSDeleteLineFunctionKey = 63292;
public static final int NSDescendingPageOrder = -1;
public static final int NSDeviceIndependentModifierFlagsMask = -65536;
public static final int NSDeviceNColorSpaceModel = 4;
public static final int NSDirectSelection = 0;
public static final int NSDisclosureBezelStyle = 5;
public static final int NSDiscreteCapacityLevelIndicatorStyle = 2;
public static final int NSDisplayWindowRunLoopOrdering = 600000;
public static final int NSDocModalWindowMask = 64;
public static final int NSDockWindowLevel = 20;
public static final int NSDoubleType = 6;
public static final int NSDownArrowFunctionKey = 63233;
public static final int NSDownTextMovement = 22;
public static final int NSDragOperationAll = 15;
public static final int NSDragOperationAll_Obsolete = 15;
public static final int NSDragOperationCopy = 1;
public static final int NSDragOperationDelete = 32;
public static final int NSDragOperationEvery = -1;
public static final int NSDragOperationGeneric = 4;
public static final int NSDragOperationLink = 2;
public static final int NSDragOperationMove = 16;
public static final int NSDragOperationNone = 0;
public static final int NSDragOperationPrivate = 8;
public static final int NSDrawerClosedState = 0;
public static final int NSDrawerClosingState = 3;
public static final int NSDrawerOpenState = 2;
public static final int NSDrawerOpeningState = 1;
public static final int NSEndFunctionKey = 63275;
public static final int NSEnterCharacter = 3;
public static final int NSEraDatePickerElementFlag = 256;
public static final int NSEraserPointingDevice = 3;
public static final int NSEvenOddWindingRule = 1;
public static final int NSExclude10_4ElementsIconCreationOption = 4;
public static final int NSExcludeQuickDrawElementsIconCreationOption = 2;
public static final int NSExecuteFunctionKey = 63298;
public static final int NSExpandedFontMask = 32;
public static final int NSF10FunctionKey = 63245;
public static final int NSF11FunctionKey = 63246;
public static final int NSF12FunctionKey = 63247;
public static final int NSF13FunctionKey = 63248;
public static final int NSF14FunctionKey = 63249;
public static final int NSF15FunctionKey = 63250;
public static final int NSF16FunctionKey = 63251;
public static final int NSF17FunctionKey = 63252;
public static final int NSF18FunctionKey = 63253;
public static final int NSF19FunctionKey = 63254;
public static final int NSF1FunctionKey = 63236;
public static final int NSF20FunctionKey = 63255;
public static final int NSF21FunctionKey = 63256;
public static final int NSF22FunctionKey = 63257;
public static final int NSF23FunctionKey = 63258;
public static final int NSF24FunctionKey = 63259;
public static final int NSF25FunctionKey = 63260;
public static final int NSF26FunctionKey = 63261;
public static final int NSF27FunctionKey = 63262;
public static final int NSF28FunctionKey = 63263;
public static final int NSF29FunctionKey = 63264;
public static final int NSF2FunctionKey = 63237;
public static final int NSF30FunctionKey = 63265;
public static final int NSF31FunctionKey = 63266;
public static final int NSF32FunctionKey = 63267;
public static final int NSF33FunctionKey = 63268;
public static final int NSF34FunctionKey = 63269;
public static final int NSF35FunctionKey = 63270;
public static final int NSF3FunctionKey = 63238;
public static final int NSF4FunctionKey = 63239;
public static final int NSF5FunctionKey = 63240;
public static final int NSF6FunctionKey = 63241;
public static final int NSF7FunctionKey = 63242;
public static final int NSF8FunctionKey = 63243;
public static final int NSF9FunctionKey = 63244;
public static final int NSFPCurrentField = 134;
public static final int NSFPPreviewButton = 131;
public static final int NSFPPreviewField = 128;
public static final int NSFPRevertButton = 130;
public static final int NSFPSetButton = 132;
public static final int NSFPSizeField = 129;
public static final int NSFPSizeTitle = 133;
public static final int NSFileHandlingPanelCancelButton = 0;
public static final int NSFileHandlingPanelOKButton = 1;
public static final int NSFindFunctionKey = 63301;
public static final int NSFindPanelActionNext = 2;
public static final int NSFindPanelActionPrevious = 3;
public static final int NSFindPanelActionReplace = 5;
public static final int NSFindPanelActionReplaceAll = 4;
public static final int NSFindPanelActionReplaceAllInSelection = 8;
public static final int NSFindPanelActionReplaceAndFind = 6;
public static final int NSFindPanelActionSelectAll = 9;
public static final int NSFindPanelActionSelectAllInSelection = 10;
public static final int NSFindPanelActionSetFindString = 7;
public static final int NSFindPanelActionShowFindPanel = 1;
public static final int NSFindPanelSubstringMatchTypeContains = 0;
public static final int NSFindPanelSubstringMatchTypeEndsWith = 3;
public static final int NSFindPanelSubstringMatchTypeFullWord = 2;
public static final int NSFindPanelSubstringMatchTypeStartsWith = 1;
public static final int NSFitPagination = 1;
public static final int NSFixedPitchFontMask = 1024;
public static final int NSFlagsChanged = 12;
public static final int NSFlagsChangedMask = 4096;
public static final int NSFloatType = 3;
public static final int NSFloatingPointSamplesBitmapFormat = 4;
public static final int NSFloatingWindowLevel = 3;
public static final int NSFocusRingAbove = 2;
public static final int NSFocusRingBelow = 1;
public static final int NSFocusRingOnly = 0;
public static final int NSFocusRingTypeDefault = 0;
public static final int NSFocusRingTypeExterior = 2;
public static final int NSFocusRingTypeNone = 1;
public static final int NSFontAntialiasedIntegerAdvancementsRenderingMode = 3;
public static final int NSFontAntialiasedRenderingMode = 1;
public static final int NSFontBoldTrait = 2;
public static final int NSFontClarendonSerifsClass = 1073741824;
public static final int NSFontCollectionApplicationOnlyMask = 1;
public static final int NSFontCondensedTrait = 64;
public static final int NSFontDefaultRenderingMode = 0;
public static final int NSFontExpandedTrait = 32;
public static final int NSFontFamilyClassMask = -268435456;
public static final int NSFontFreeformSerifsClass = 1879048192;
public static final int NSFontIntegerAdvancementsRenderingMode = 2;
public static final int NSFontItalicTrait = 1;
public static final int NSFontModernSerifsClass = 805306368;
public static final int NSFontMonoSpaceTrait = 1024;
public static final int NSFontOldStyleSerifsClass = 268435456;
public static final int NSFontOrnamentalsClass = -1879048192;
public static final int NSFontPanelAllEffectsModeMask = 1048320;
public static final int NSFontPanelAllModesMask = -1;
public static final int NSFontPanelCollectionModeMask = 4;
public static final int NSFontPanelDocumentColorEffectModeMask = 2048;
public static final int NSFontPanelFaceModeMask = 1;
public static final int NSFontPanelShadowEffectModeMask = 4096;
public static final int NSFontPanelSizeModeMask = 2;
public static final int NSFontPanelStandardModesMask = 65535;
public static final int NSFontPanelStrikethroughEffectModeMask = 512;
public static final int NSFontPanelTextColorEffectModeMask = 1024;
public static final int NSFontPanelUnderlineEffectModeMask = 256;
public static final int NSFontSansSerifClass = -2147483648;
public static final int NSFontScriptsClass = -1610612736;
public static final int NSFontSlabSerifsClass = 1342177280;
public static final int NSFontSymbolicClass = -1073741824;
public static final int NSFontTransitionalSerifsClass = 536870912;
public static final int NSFontUIOptimizedTrait = 4096;
public static final int NSFontUnknownClass = 0;
public static final int NSFontVerticalTrait = 2048;
public static final int NSFormFeedCharacter = 12;
public static final int NSFunctionKeyMask = 8388608;
public static final int NSGIFFileType = 2;
public static final int NSGlyphAttributeBidiLevel = 2;
public static final int NSGlyphAttributeElastic = 1;
public static final int NSGlyphAttributeInscribe = 5;
public static final int NSGlyphAttributeSoft = 0;
public static final int NSGlyphInscribeAbove = 2;
public static final int NSGlyphInscribeBase = 0;
public static final int NSGlyphInscribeBelow = 1;
public static final int NSGlyphInscribeOverBelow = 4;
public static final int NSGlyphInscribeOverstrike = 3;
public static final int NSGradientConcaveStrong = 2;
public static final int NSGradientConcaveWeak = 1;
public static final int NSGradientConvexStrong = 4;
public static final int NSGradientConvexWeak = 3;
public static final int NSGradientDrawsAfterEndingLocation = 2;
public static final int NSGradientDrawsBeforeStartingLocation = 1;
public static final int NSGradientNone = 0;
public static final int NSGraphiteControlTint = 6;
public static final int NSGrayColorSpaceModel = 0;
public static final int NSGrayModeColorPanel = 0;
public static final int NSGrooveBorder = 3;
public static final int NSHSBModeColorPanel = 3;
public static final int NSHUDWindowMask = 8192;
public static final int NSHeavierFontAction = 5;
public static final int NSHelpButtonBezelStyle = 9;
public static final int NSHelpFunctionKey = 63302;
public static final int NSHelpKeyMask = 4194304;
public static final int NSHighlightModeMatrix = 1;
public static final int NSHomeFunctionKey = 63273;
public static final int NSHorizontalRuler = 0;
public static final int NSHourMinuteDatePickerElementFlag = 12;
public static final int NSHourMinuteSecondDatePickerElementFlag = 14;
public static final int NSIdentityMappingCharacterCollection = 0;
public static final int NSIllegalTextMovement = 0;
public static final int NSImageAbove = 5;
public static final int NSImageAlignBottom = 5;
public static final int NSImageAlignBottomLeft = 6;
public static final int NSImageAlignBottomRight = 7;
public static final int NSImageAlignCenter = 0;
public static final int NSImageAlignLeft = 4;
public static final int NSImageAlignRight = 8;
public static final int NSImageAlignTop = 1;
public static final int NSImageAlignTopLeft = 2;
public static final int NSImageAlignTopRight = 3;
public static final int NSImageBelow = 4;
public static final int NSImageCacheAlways = 1;
public static final int NSImageCacheBySize = 2;
public static final int NSImageCacheDefault = 0;
public static final int NSImageCacheNever = 3;
public static final int NSImageCellType = 2;
public static final int NSImageFrameButton = 4;
public static final int NSImageFrameGrayBezel = 2;
public static final int NSImageFrameGroove = 3;
public static final int NSImageFrameNone = 0;
public static final int NSImageFramePhoto = 1;
public static final int NSImageInterpolationDefault = 0;
public static final int NSImageInterpolationHigh = 3;
public static final int NSImageInterpolationLow = 2;
public static final int NSImageInterpolationNone = 1;
public static final int NSImageLeft = 2;
public static final int NSImageLoadStatusCancelled = 1;
public static final int NSImageLoadStatusCompleted = 0;
public static final int NSImageLoadStatusInvalidData = 2;
public static final int NSImageLoadStatusReadError = 4;
public static final int NSImageLoadStatusUnexpectedEOF = 3;
public static final int NSImageOnly = 1;
public static final int NSImageOverlaps = 6;
public static final int NSImageRepLoadStatusCompleted = -6;
public static final int NSImageRepLoadStatusInvalidData = -4;
public static final int NSImageRepLoadStatusReadingHeader = -2;
public static final int NSImageRepLoadStatusUnexpectedEOF = -5;
public static final int NSImageRepLoadStatusUnknownType = -1;
public static final int NSImageRepLoadStatusWillNeedAllData = -3;
public static final int NSImageRepMatchesDevice = 0;
public static final int NSImageRight = 3;
public static final int NSImageScaleAxesIndependently = 1;
public static final int NSImageScaleNone = 2;
public static final int NSImageScaleProportionallyDown = 0;
public static final int NSImageScaleProportionallyUpOrDown = 3;
public static final int NSIndexedColorSpaceModel = 5;
public static final int NSInformationalAlertStyle = 1;
public static final int NSInformationalRequest = 10;
public static final int NSInsertCharFunctionKey = 63293;
public static final int NSInsertFunctionKey = 63271;
public static final int NSInsertLineFunctionKey = 63291;
public static final int NSIntType = 1;
public static final int NSItalicFontMask = 1;
public static final int NSJPEG2000FileType = 5;
public static final int NSJPEGFileType = 3;
public static final int NSJustifiedTextAlignment = 3;
public static final int NSKeyDown = 10;
public static final int NSKeyDownMask = 1024;
public static final int NSKeyUp = 11;
public static final int NSKeyUpMask = 2048;
public static final int NSLABColorSpaceModel = 3;
public static final int NSLandscapeOrientation = 1;
public static final int NSLeftArrowFunctionKey = 63234;
public static final int NSLeftMouseDown = 1;
public static final int NSLeftMouseDownMask = 2;
public static final int NSLeftMouseDragged = 6;
public static final int NSLeftMouseDraggedMask = 64;
public static final int NSLeftMouseUp = 2;
public static final int NSLeftMouseUpMask = 4;
public static final int NSLeftTabStopType = 0;
public static final int NSLeftTabsBezelBorder = 1;
public static final int NSLeftTextAlignment = 0;
public static final int NSLeftTextMovement = 19;
public static final int NSLighterFontAction = 6;
public static final int NSLineBorder = 1;
public static final int NSLineBreakByCharWrapping = 1;
public static final int NSLineBreakByClipping = 2;
public static final int NSLineBreakByTruncatingHead = 3;
public static final int NSLineBreakByTruncatingMiddle = 5;
public static final int NSLineBreakByTruncatingTail = 4;
public static final int NSLineBreakByWordWrapping = 0;
public static final int NSLineDoesntMove = 0;
public static final int NSLineMovesDown = 3;
public static final int NSLineMovesLeft = 1;
public static final int NSLineMovesRight = 2;
public static final int NSLineMovesUp = 4;
public static final int NSLineSeparatorCharacter = 8232;
public static final int NSLineSweepDown = 2;
public static final int NSLineSweepLeft = 0;
public static final int NSLineSweepRight = 1;
public static final int NSLineSweepUp = 3;
public static final int NSLineToBezierPathElement = 1;
public static final int NSLinearSlider = 0;
public static final int NSListModeMatrix = 2;
public static final int NSMacintoshInterfaceStyle = 3;
public static final int NSMainMenuWindowLevel = 24;
public static final int NSMenuFunctionKey = 63285;
public static final int NSMiniControlSize = 2;
public static final int NSMiniaturizableWindowMask = 4;
public static final int NSMiterLineJoinStyle = 0;
public static final int NSMixedState = -1;
public static final int NSModalPanelWindowLevel = 8;
public static final int NSModeSwitchFunctionKey = 63303;
public static final int NSMomentaryChangeButton = 5;
public static final int NSMomentaryLight = 7;
public static final int NSMomentaryLightButton = 0;
public static final int NSMomentaryPushButton = 0;
public static final int NSMomentaryPushInButton = 7;
public static final int NSMouseEntered = 8;
public static final int NSMouseEnteredMask = 256;
public static final int NSMouseEventSubtype = 0;
public static final int NSMouseExited = 9;
public static final int NSMouseExitedMask = 512;
public static final int NSMouseMoved = 5;
public static final int NSMouseMovedMask = 32;
public static final int NSMoveToBezierPathElement = 0;
public static final int NSNarrowFontMask = 16;
public static final int NSNativeShortGlyphPacking = 5;
public static final int NSNaturalTextAlignment = 4;
public static final int NSNewlineCharacter = 10;
public static final int NSNextFunctionKey = 63296;
public static final int NSNextStepInterfaceStyle = 1;
public static final int NSNoBorder = 0;
public static final int NSNoCellMask = 0;
public static final int NSNoFontChangeAction = 0;
public static final int NSNoImage = 0;
public static final int NSNoInterfaceStyle = 0;
public static final int NSNoModeColorPanel = -1;
public static final int NSNoScrollerParts = 0;
public static final int NSNoTabsBezelBorder = 4;
public static final int NSNoTabsLineBorder = 5;
public static final int NSNoTabsNoBorder = 6;
public static final int NSNoTitle = 0;
public static final int NSNoUnderlineStyle = 0;
public static final int NSNonStandardCharacterSetFontMask = 8;
public static final int NSNonZeroWindingRule = 0;
public static final int NSNonactivatingPanelMask = 128;
public static final int NSNormalWindowLevel = 0;
public static final int NSNullCellType = 0;
public static final int NSNullGlyph = 0;
public static final int NSNumericPadKeyMask = 2097152;
public static final int NSOKButton = 1;
public static final int NSOPENGL_CURRENT_VERSION = 1;
public static final int NSOffState = 0;
public static final int NSOnOffButton = 6;
public static final int NSOnState = 1;
public static final int NSOnlyScrollerArrows = 1;
public static final int NSOpenGLCPRasterizationEnable = 221;
public static final int NSOpenGLCPStateValidation = 301;
public static final int NSOpenGLCPSurfaceOpacity = 236;
public static final int NSOpenGLCPSurfaceOrder = 235;
public static final int NSOpenGLCPSwapInterval = 222;
public static final int NSOpenGLCPSwapRectangle = 200;
public static final int NSOpenGLCPSwapRectangleEnable = 201;
public static final int NSOpenGLGOClearFormatCache = 502;
public static final int NSOpenGLGOFormatCacheSize = 501;
public static final int NSOpenGLGOResetLibrary = 504;
public static final int NSOpenGLGORetainRenderers = 503;
public static final int NSOpenGLPFAAccelerated = 73;
public static final int NSOpenGLPFAAccumSize = 14;
public static final int NSOpenGLPFAAllRenderers = 1;
public static final int NSOpenGLPFAAllowOfflineRenderers = 96;
public static final int NSOpenGLPFAAlphaSize = 11;
public static final int NSOpenGLPFAAuxBuffers = 7;
public static final int NSOpenGLPFAAuxDepthStencil = 57;
public static final int NSOpenGLPFABackingStore = 76;
public static final int NSOpenGLPFAClosestPolicy = 74;
public static final int NSOpenGLPFAColorFloat = 58;
public static final int NSOpenGLPFAColorSize = 8;
public static final int NSOpenGLPFACompliant = 83;
public static final int NSOpenGLPFADepthSize = 12;
public static final int NSOpenGLPFADoubleBuffer = 5;
public static final int NSOpenGLPFAFullScreen = 54;
public static final int NSOpenGLPFAMPSafe = 78;
public static final int NSOpenGLPFAMaximumPolicy = 52;
public static final int NSOpenGLPFAMinimumPolicy = 51;
public static final int NSOpenGLPFAMultiScreen = 81;
public static final int NSOpenGLPFAMultisample = 59;
public static final int NSOpenGLPFANoRecovery = 72;
public static final int NSOpenGLPFAOffScreen = 53;
public static final int NSOpenGLPFAPixelBuffer = 90;
public static final int NSOpenGLPFARendererID = 70;
public static final int NSOpenGLPFARobust = 75;
public static final int NSOpenGLPFASampleAlpha = 61;
public static final int NSOpenGLPFASampleBuffers = 55;
public static final int NSOpenGLPFASamples = 56;
public static final int NSOpenGLPFAScreenMask = 84;
public static final int NSOpenGLPFASingleRenderer = 71;
public static final int NSOpenGLPFAStencilSize = 13;
public static final int NSOpenGLPFAStereo = 6;
public static final int NSOpenGLPFASupersample = 60;
public static final int NSOpenGLPFAVirtualScreenCount = 128;
public static final int NSOpenGLPFAWindow = 80;
public static final int NSOtherMouseDown = 25;
public static final int NSOtherMouseDownMask = 33554432;
public static final int NSOtherMouseDragged = 27;
public static final int NSOtherMouseDraggedMask = 134217728;
public static final int NSOtherMouseUp = 26;
public static final int NSOtherMouseUpMask = 67108864;
public static final int NSOtherTextMovement = 0;
public static final int NSOutlineViewDropOnItemIndex = -1;
public static final int NSPNGFileType = 4;
public static final int NSPageDownFunctionKey = 63277;
public static final int NSPageUpFunctionKey = 63276;
public static final int NSParagraphSeparatorCharacter = 8233;
public static final int NSPathStyleNavigationBar = 1;
public static final int NSPathStylePopUp = 2;
public static final int NSPathStyleStandard = 0;
public static final int NSPatternColorSpaceModel = 6;
public static final int NSPauseFunctionKey = 63280;
public static final int NSPenLowerSideMask = 2;
public static final int NSPenPointingDevice = 1;
public static final int NSPenTipMask = 1;
public static final int NSPenUpperSideMask = 4;
public static final int NSPeriodic = 16;
public static final int NSPeriodicMask = 65536;
public static final int NSPlainTextTokenStyle = 1;
public static final int NSPopUpArrowAtBottom = 2;
public static final int NSPopUpArrowAtCenter = 1;
public static final int NSPopUpMenuWindowLevel = 101;
public static final int NSPopUpNoArrow = 0;
public static final int NSPortraitOrientation = 0;
public static final int NSPositiveDoubleType = 7;
public static final int NSPositiveFloatType = 4;
public static final int NSPositiveIntType = 2;
public static final int NSPosterFontMask = 256;
public static final int NSPowerOffEventType = 1;
public static final int NSPressedTab = 2;
public static final int NSPrevFunctionKey = 63295;
public static final int NSPrintFunctionKey = 63288;
public static final int NSPrintPanelShowsCopies = 1;
public static final int NSPrintPanelShowsOrientation = 8;
public static final int NSPrintPanelShowsPageRange = 2;
public static final int NSPrintPanelShowsPageSetupAccessory = 256;
public static final int NSPrintPanelShowsPaperSize = 4;
public static final int NSPrintPanelShowsPreview = 131072;
public static final int NSPrintPanelShowsScaling = 16;
public static final int NSPrintScreenFunctionKey = 63278;
public static final int NSPrinterTableError = 2;
public static final int NSPrinterTableNotFound = 1;
public static final int NSPrinterTableOK = 0;
public static final int NSPrintingCancelled = 0;
public static final int NSPrintingFailure = 3;
public static final int NSPrintingReplyLater = 2;
public static final int NSPrintingSuccess = 1;
public static final int NSProgressIndicatorBarStyle = 0;
public static final int NSProgressIndicatorPreferredAquaThickness = 12;
public static final int NSProgressIndicatorPreferredLargeThickness = 18;
public static final int NSProgressIndicatorPreferredSmallThickness = 10;
public static final int NSProgressIndicatorPreferredThickness = 14;
public static final int NSProgressIndicatorSpinningStyle = 1;
public static final int NSPushInCell = 2;
public static final int NSPushInCellMask = 2;
public static final int NSPushOnPushOffButton = 1;
public static final int NSQTMovieLoopingBackAndForthPlayback = 2;
public static final int NSQTMovieLoopingPlayback = 1;
public static final int NSQTMovieNormalPlayback = 0;
public static final int NSRGBColorSpaceModel = 1;
public static final int NSRGBModeColorPanel = 1;
public static final int NSRadioButton = 4;
public static final int NSRadioModeMatrix = 0;
public static final int NSRangeDateMode = 1;
public static final int NSRatingLevelIndicatorStyle = 3;
public static final int NSRecessedBezelStyle = 13;
public static final int NSRedoFunctionKey = 63300;
public static final int NSRegularControlSize = 0;
public static final int NSRegularSquareBezelStyle = 2;
public static final int NSRelevancyLevelIndicatorStyle = 0;
public static final int NSRemoveTraitFontAction = 7;
public static final int NSResetCursorRectsRunLoopOrdering = 700000;
public static final int NSResetFunctionKey = 63283;
public static final int NSResizableWindowMask = 8;
public static final int NSReturnTextMovement = 16;
public static final int NSRightArrowFunctionKey = 63235;
public static final int NSRightMouseDown = 3;
public static final int NSRightMouseDownMask = 8;
public static final int NSRightMouseDragged = 7;
public static final int NSRightMouseDraggedMask = 128;
public static final int NSRightMouseUp = 4;
public static final int NSRightMouseUpMask = 16;
public static final int NSRightTabStopType = 1;
public static final int NSRightTabsBezelBorder = 3;
public static final int NSRightTextAlignment = 1;
public static final int NSRightTextMovement = 20;
public static final int NSRoundLineCapStyle = 1;
public static final int NSRoundLineJoinStyle = 1;
public static final int NSRoundRectBezelStyle = 12;
public static final int NSRoundedBezelStyle = 1;
public static final int NSRoundedDisclosureBezelStyle = 14;
public static final int NSRoundedTokenStyle = 2;
public static final int NSRuleEditorNestingModeCompound = 2;
public static final int NSRuleEditorNestingModeList = 1;
public static final int NSRuleEditorNestingModeSimple = 3;
public static final int NSRuleEditorNestingModeSingle = 0;
public static final int NSRuleEditorRowTypeCompound = 1;
public static final int NSRuleEditorRowTypeSimple = 0;
public static final int NSRunAbortedResponse = -1001;
public static final int NSRunContinuesResponse = -1002;
public static final int NSRunStoppedResponse = -1000;
public static final int NSSaveAsOperation = 1;
public static final int NSSaveOperation = 0;
public static final int NSSaveToOperation = 2;
public static final int NSScaleNone = 2;
public static final int NSScaleProportionally = 0;
public static final int NSScaleToFit = 1;
public static final int NSScreenChangedEventType = 8;
public static final int NSScreenSaverWindowLevel = 1000;
public static final int NSScrollLockFunctionKey = 63279;
public static final int NSScrollWheel = 22;
public static final int NSScrollWheelMask = 4194304;
public static final int NSScrollerArrowsDefaultSetting = 0;
public static final int NSScrollerArrowsMaxEnd = 0;
public static final int NSScrollerArrowsMinEnd = 1;
public static final int NSScrollerArrowsNone = 2;
public static final int NSScrollerDecrementArrow = 1;
public static final int NSScrollerDecrementLine = 4;
public static final int NSScrollerDecrementPage = 1;
public static final int NSScrollerIncrementArrow = 0;
public static final int NSScrollerIncrementLine = 5;
public static final int NSScrollerIncrementPage = 3;
public static final int NSScrollerKnob = 2;
public static final int NSScrollerKnobSlot = 6;
public static final int NSScrollerNoPart = 0;
public static final int NSSearchFieldClearRecentsMenuItemTag = 1002;
public static final int NSSearchFieldNoRecentsMenuItemTag = 1003;
public static final int NSSearchFieldRecentsMenuItemTag = 1001;
public static final int NSSearchFieldRecentsTitleMenuItemTag = 1000;
public static final int NSSegmentStyleAutomatic = 0;
public static final int NSSegmentStyleCapsule = 5;
public static final int NSSegmentStyleRoundRect = 3;
public static final int NSSegmentStyleRounded = 1;
public static final int NSSegmentStyleSmallSquare = 6;
public static final int NSSegmentStyleTexturedRounded = 2;
public static final int NSSegmentStyleTexturedSquare = 4;
public static final int NSSegmentSwitchTrackingMomentary = 2;
public static final int NSSegmentSwitchTrackingSelectAny = 1;
public static final int NSSegmentSwitchTrackingSelectOne = 0;
public static final int NSSelectByCharacter = 0;
public static final int NSSelectByParagraph = 2;
public static final int NSSelectByWord = 1;
public static final int NSSelectFunctionKey = 63297;
public static final int NSSelectedTab = 0;
public static final int NSSelectingNext = 1;
public static final int NSSelectingPrevious = 2;
public static final int NSSelectionAffinityDownstream = 1;
public static final int NSSelectionAffinityUpstream = 0;
public static final int NSServiceApplicationLaunchFailedError = 66561;
public static final int NSServiceApplicationNotFoundError = 66560;
public static final int NSServiceErrorMaximum = 66817;
public static final int NSServiceErrorMinimum = 66560;
public static final int NSServiceInvalidPasteboardDataError = 66563;
public static final int NSServiceMalformedServiceDictionaryError = 66564;
public static final int NSServiceMiscellaneousError = 66800;
public static final int NSServiceRequestTimedOutError = 66562;
public static final int NSShadowlessSquareBezelStyle = 6;
public static final int NSShiftKeyMask = 131072;
public static final int NSShowControlGlyphs = 1;
public static final int NSShowInvisibleGlyphs = 2;
public static final int NSSingleDateMode = 0;
public static final int NSSingleUnderlineStyle = 1;
public static final int NSSizeDownFontAction = 4;
public static final int NSSizeUpFontAction = 3;
public static final int NSSmallCapsFontMask = 128;
public static final int NSSmallControlSize = 1;
public static final int NSSmallIconButtonBezelStyle = 2;
public static final int NSSmallSquareBezelStyle = 10;
public static final int NSSpecialPageOrder = 0;
public static final int NSSpeechImmediateBoundary = 0;
public static final int NSSpeechSentenceBoundary = 2;
public static final int NSSpeechWordBoundary = 1;
public static final int NSSpellingStateGrammarFlag = 2;
public static final int NSSpellingStateSpellingFlag = 1;
public static final int NSSplitViewDividerStyleThick = 1;
public static final int NSSplitViewDividerStyleThin = 2;
public static final int NSSquareLineCapStyle = 2;
public static final int NSSquareStatusItemLength = -2;
public static final int NSStatusWindowLevel = 25;
public static final int NSStopFunctionKey = 63284;
public static final int NSStringDrawingDisableScreenFontSubstitution = 4;
public static final int NSStringDrawingOneShot = 16;
public static final int NSStringDrawingTruncatesLastVisibleLine = 32;
public static final int NSStringDrawingUsesDeviceMetrics = 8;
public static final int NSStringDrawingUsesFontLeading = 2;
public static final int NSStringDrawingUsesLineFragmentOrigin = 1;
public static final int NSSubmenuWindowLevel = 3;
public static final int NSSwitchButton = 3;
public static final int NSSysReqFunctionKey = 63281;
public static final int NSSystemDefined = 14;
public static final int NSSystemDefinedMask = 16384;
public static final int NSSystemFunctionKey = 63287;
public static final int NSTIFFCompressionCCITTFAX3 = 3;
public static final int NSTIFFCompressionCCITTFAX4 = 4;
public static final int NSTIFFCompressionJPEG = 6;
public static final int NSTIFFCompressionLZW = 5;
public static final int NSTIFFCompressionNEXT = 32766;
public static final int NSTIFFCompressionNone = 1;
public static final int NSTIFFCompressionOldJPEG = 32865;
public static final int NSTIFFCompressionPackBits = 32773;
public static final int NSTIFFFileType = 0;
public static final int NSTabCharacter = 9;
public static final int NSTabTextMovement = 17;
public static final int NSTableColumnAutoresizingMask = 1;
public static final int NSTableColumnNoResizing = 0;
public static final int NSTableColumnUserResizingMask = 2;
public static final int NSTableViewDropAbove = 1;
public static final int NSTableViewDropOn = 0;
public static final int NSTableViewFirstColumnOnlyAutoresizingStyle = 5;
public static final int NSTableViewGridNone = 0;
public static final int NSTableViewLastColumnOnlyAutoresizingStyle = 4;
public static final int NSTableViewNoColumnAutoresizing = 0;
public static final int NSTableViewReverseSequentialColumnAutoresizingStyle = 3;
public static final int NSTableViewSelectionHighlightStyleRegular = 0;
public static final int NSTableViewSelectionHighlightStyleSourceList = 1;
public static final int NSTableViewSequentialColumnAutoresizingStyle = 2;
public static final int NSTableViewSolidHorizontalGridLineMask = 2;
public static final int NSTableViewSolidVerticalGridLineMask = 1;
public static final int NSTableViewUniformColumnAutoresizingStyle = 1;
public static final int NSTabletPoint = 23;
public static final int NSTabletPointEventSubtype = 1;
public static final int NSTabletPointMask = 8388608;
public static final int NSTabletProximity = 24;
public static final int NSTabletProximityEventSubtype = 2;
public static final int NSTabletProximityMask = 16777216;
public static final int NSTerminateCancel = 0;
public static final int NSTerminateLater = 2;
public static final int NSTerminateNow = 1;
public static final int NSTextBlockAbsoluteValueType = 0;
public static final int NSTextBlockBaselineAlignment = 3;
public static final int NSTextBlockBorder = 0;
public static final int NSTextBlockBottomAlignment = 2;
public static final int NSTextBlockHeight = 4;
public static final int NSTextBlockMargin = 1;
public static final int NSTextBlockMaximumHeight = 6;
public static final int NSTextBlockMaximumWidth = 2;
public static final int NSTextBlockMiddleAlignment = 1;
public static final int NSTextBlockMinimumHeight = 5;
public static final int NSTextBlockMinimumWidth = 1;
public static final int NSTextBlockPadding = -1;
public static final int NSTextBlockPercentageValueType = 1;
public static final int NSTextBlockTopAlignment = 0;
public static final int NSTextBlockWidth = 0;
public static final int NSTextCellType = 1;
public static final int NSTextFieldAndStepperDatePickerStyle = 0;
public static final int NSTextFieldDatePickerStyle = 2;
public static final int NSTextFieldRoundedBezel = 1;
public static final int NSTextFieldSquareBezel = 0;
public static final int NSTextListPrependEnclosingMarker = 1;
public static final int NSTextReadInapplicableDocumentTypeError = 65806;
public static final int NSTextReadWriteErrorMaximum = 66303;
public static final int NSTextReadWriteErrorMinimum = 65792;
public static final int NSTextStorageEditedAttributes = 1;
public static final int NSTextStorageEditedCharacters = 2;
public static final int NSTextTableAutomaticLayoutAlgorithm = 0;
public static final int NSTextTableFixedLayoutAlgorithm = 1;
public static final int NSTextWriteInapplicableDocumentTypeError = 66062;
public static final int NSTexturedBackgroundWindowMask = 256;
public static final int NSTexturedRoundedBezelStyle = 11;
public static final int NSTexturedSquareBezelStyle = 8;
public static final int NSThickSquareBezelStyle = 3;
public static final int NSThickerSquareBezelStyle = 4;
public static final int NSTickMarkAbove = 1;
public static final int NSTickMarkBelow = 0;
public static final int NSTickMarkLeft = 1;
public static final int NSTickMarkRight = 0;
public static final int NSTimeZoneDatePickerElementFlag = 16;
public static final int NSTitledWindowMask = 1;
public static final int NSToggleButton = 2;
public static final int NSToolbarDisplayModeDefault = 0;
public static final int NSToolbarDisplayModeIconAndLabel = 1;
public static final int NSToolbarDisplayModeIconOnly = 2;
public static final int NSToolbarDisplayModeLabelOnly = 3;
public static final int NSToolbarItemVisibilityPriorityHigh = 1000;
public static final int NSToolbarItemVisibilityPriorityLow = -1000;
public static final int NSToolbarItemVisibilityPriorityStandard = 0;
public static final int NSToolbarItemVisibilityPriorityUser = 2000;
public static final int NSToolbarSizeModeDefault = 0;
public static final int NSToolbarSizeModeRegular = 1;
public static final int NSToolbarSizeModeSmall = 2;
public static final int NSTopTabsBezelBorder = 0;
public static final int NSTornOffMenuWindowLevel = 3;
public static final int NSTrackModeMatrix = 3;
public static final int NSTrackingActiveAlways = 128;
public static final int NSTrackingActiveInActiveApp = 64;
public static final int NSTrackingActiveInKeyWindow = 32;
public static final int NSTrackingActiveWhenFirstResponder = 16;
public static final int NSTrackingAssumeInside = 256;
public static final int NSTrackingCursorUpdate = 4;
public static final int NSTrackingEnabledDuringMouseDrag = 1024;
public static final int NSTrackingInVisibleRect = 512;
public static final int NSTrackingMouseEnteredAndExited = 1;
public static final int NSTrackingMouseMoved = 2;
public static final int NSTypesetterBehavior_10_2 = 2;
public static final int NSTypesetterBehavior_10_2_WithCompatibility = 1;
public static final int NSTypesetterBehavior_10_3 = 3;
public static final int NSTypesetterBehavior_10_4 = 4;
public static final int NSTypesetterContainerBreakAction = 32;
public static final int NSTypesetterHorizontalTabAction = 4;
public static final int NSTypesetterLatestBehavior = -1;
public static final int NSTypesetterLineBreakAction = 8;
public static final int NSTypesetterOriginalBehavior = 0;
public static final int NSTypesetterParagraphBreakAction = 16;
public static final int NSTypesetterWhitespaceAction = 2;
public static final int NSTypesetterZeroAdvancementAction = 1;
public static final int NSUnboldFontMask = 4;
public static final int NSUnderlinePatternDash = 512;
public static final int NSUnderlinePatternDashDot = 768;
public static final int NSUnderlinePatternDashDotDot = 1024;
public static final int NSUnderlinePatternDot = 256;
public static final int NSUnderlinePatternSolid = 0;
public static final int NSUnderlineStyleDouble = 9;
public static final int NSUnderlineStyleNone = 0;
public static final int NSUnderlineStyleSingle = 1;
public static final int NSUnderlineStyleThick = 2;
public static final int NSUndoFunctionKey = 63299;
public static final int NSUnifiedTitleAndToolbarWindowMask = 4096;
public static final int NSUnitalicFontMask = 16777216;
public static final int NSUnknownColorSpaceModel = -1;
public static final int NSUnknownPageOrder = 2;
public static final int NSUnknownPointingDevice = 0;
public static final int NSUnscaledWindowMask = 2048;
public static final int NSUpArrowFunctionKey = 63232;
public static final int NSUpTextMovement = 21;
public static final int NSUpdateWindowsRunLoopOrdering = 500000;
public static final int NSUserFunctionKey = 63286;
public static final int NSUtilityWindowMask = 16;
public static final int NSVariableStatusItemLength = -1;
public static final int NSVerticalRuler = 1;
public static final int NSViaPanelFontAction = 1;
public static final int NSViewHeightSizable = 16;
public static final int NSViewMaxXMargin = 4;
public static final int NSViewMaxYMargin = 32;
public static final int NSViewMinXMargin = 1;
public static final int NSViewMinYMargin = 8;
public static final int NSViewNotSizable = 0;
public static final int NSViewWidthSizable = 2;
public static final int NSWantsBidiLevels = 4;
public static final int NSWarningAlertStyle = 0;
public static final int NSWheelModeColorPanel = 6;
public static final int NSWindowAbove = 1;
public static final int NSWindowBackingLocationDefault = 0;
public static final int NSWindowBackingLocationMainMemory = 2;
public static final int NSWindowBackingLocationVideoMemory = 1;
public static final int NSWindowBelow = -1;
public static final int NSWindowCloseButton = 0;
public static final int NSWindowCollectionBehaviorCanJoinAllSpaces = 1;
public static final int NSWindowCollectionBehaviorDefault = 0;
public static final int NSWindowCollectionBehaviorMoveToActiveSpace = 2;
public static final int NSWindowDocumentIconButton = 4;
public static final int NSWindowExposedEventType = 0;
public static final int NSWindowMiniaturizeButton = 1;
public static final int NSWindowMovedEventType = 4;
public static final int NSWindowOut = 0;
public static final int NSWindowSharingNone = 0;
public static final int NSWindowSharingReadOnly = 1;
public static final int NSWindowSharingReadWrite = 2;
public static final int NSWindowToolbarButton = 3;
public static final int NSWindowZoomButton = 2;
public static final int NSWindows95InterfaceStyle = 2;
public static final int NSWorkspaceLaunchAllowingClassicStartup = 131072;
public static final int NSWorkspaceLaunchAndHide = 1048576;
public static final int NSWorkspaceLaunchAndHideOthers = 2097152;
public static final int NSWorkspaceLaunchAndPrint = 2;
public static final int NSWorkspaceLaunchAsync = 65536;
public static final int NSWorkspaceLaunchDefault = 196608;
public static final int NSWorkspaceLaunchInhibitingBackgroundOnly = 128;
public static final int NSWorkspaceLaunchNewInstance = 524288;
public static final int NSWorkspaceLaunchPreferringClassic = 262144;
public static final int NSWorkspaceLaunchWithoutActivation = 512;
public static final int NSWorkspaceLaunchWithoutAddingToRecents = 256;
public static final int NSWritingDirectionLeftToRight = 0;
public static final int NSWritingDirectionNatural = -1;
public static final int NSWritingDirectionRightToLeft = 1;
public static final int NSYearMonthDatePickerElementFlag = 192;
public static final int NSYearMonthDayDatePickerElementFlag = 224;
public static final int NSASCIIStringEncoding = 1;
public static final int NSAdminApplicationDirectory = 4;
public static final int NSAggregateExpressionType = 14;
public static final int NSAllApplicationsDirectory = 100;
public static final int NSAllDomainsMask = 65535;
public static final int NSAllLibrariesDirectory = 101;
public static final int NSAllPredicateModifier = 1;
public static final int NSAnchoredSearch = 8;
public static final int NSAndPredicateType = 1;
public static final int NSAnyPredicateModifier = 2;
public static final int NSApplicationDirectory = 1;
public static final int NSApplicationSupportDirectory = 14;
public static final int NSArgumentEvaluationScriptError = 3;
public static final int NSArgumentsWrongScriptError = 6;
public static final int NSAtomicWrite = 1;
public static final int NSBackwardsSearch = 4;
public static final int NSBeginsWithComparison = 5;
public static final int NSBeginsWithPredicateOperatorType = 8;
public static final int NSBetweenPredicateOperatorType = 100;
public static final int NSBundleExecutableArchitectureI386 = 7;
public static final int NSBundleExecutableArchitecturePPC = 18;
public static final int NSBundleExecutableArchitecturePPC64 = 16777234;
public static final int NSBundleExecutableArchitectureX86_64 = 16777223;
public static final int NSCachesDirectory = 13;
public static final int NSCalculationDivideByZero = 4;
public static final int NSCalculationLossOfPrecision = 1;
public static final int NSCalculationNoError = 0;
public static final int NSCalculationOverflow = 3;
public static final int NSCalculationUnderflow = 2;
public static final int NSCannotCreateScriptCommandError = 10;
public static final int NSCaseInsensitivePredicateOption = 1;
public static final int NSCaseInsensitiveSearch = 1;
public static final int NSCollectorDisabledOption = 2;
public static final int NSConstantValueExpressionType = 0;
public static final int NSContainerSpecifierError = 2;
public static final int NSContainsComparison = 7;
public static final int NSContainsPredicateOperatorType = 99;
public static final int NSCoreServiceDirectory = 10;
public static final int NSCustomSelectorPredicateOperatorType = 11;
public static final int NSDateFormatterBehavior10_0 = 1000;
public static final int NSDateFormatterBehavior10_4 = 1040;
public static final int NSDateFormatterBehaviorDefault = 0;
public static final int NSDateFormatterFullStyle = 4;
public static final int NSDateFormatterLongStyle = 3;
public static final int NSDateFormatterMediumStyle = 2;
public static final int NSDateFormatterNoStyle = 0;
public static final int NSDateFormatterShortStyle = 1;
public static final int NSDayCalendarUnit = 16;
public static final int NSDecimalMaxSize = 8;
public static final int NSDecimalNoScale = 32767;
public static final int NSDemoApplicationDirectory = 2;
public static final int NSDesktopDirectory = 12;
public static final int NSDeveloperApplicationDirectory = 3;
public static final int NSDeveloperDirectory = 6;
public static final int NSDiacriticInsensitivePredicateOption = 2;
public static final int NSDiacriticInsensitiveSearch = 128;
public static final int NSDirectPredicateModifier = 0;
public static final int NSDocumentDirectory = 9;
public static final int NSDocumentationDirectory = 8;
public static final int NSDownloadsDirectory = 15;
public static final int NSEndsWithComparison = 6;
public static final int NSEndsWithPredicateOperatorType = 9;
public static final int NSEqualToComparison = 0;
public static final int NSEqualToPredicateOperatorType = 4;
public static final int NSEraCalendarUnit = 2;
public static final int NSEvaluatedObjectExpressionType = 1;
public static final int NSEverySubelement = 1;
public static final int NSExecutableArchitectureMismatchError = 3585;
public static final int NSExecutableErrorMaximum = 3839;
public static final int NSExecutableErrorMinimum = 3584;
public static final int NSExecutableLinkError = 3588;
public static final int NSExecutableLoadError = 3587;
public static final int NSExecutableNotLoadableError = 3584;
public static final int NSExecutableRuntimeMismatchError = 3586;
public static final int NSFileErrorMaximum = 1023;
public static final int NSFileErrorMinimum = 0;
public static final int NSFileLockingError = 255;
public static final int NSFileNoSuchFileError = 4;
public static final int NSFileReadCorruptFileError = 259;
public static final int NSFileReadInapplicableStringEncodingError = 261;
public static final int NSFileReadInvalidFileNameError = 258;
public static final int NSFileReadNoPermissionError = 257;
public static final int NSFileReadNoSuchFileError = 260;
public static final int NSFileReadTooLargeError = 263;
public static final int NSFileReadUnknownError = 256;
public static final int NSFileReadUnknownStringEncodingError = 264;
public static final int NSFileReadUnsupportedSchemeError = 262;
public static final int NSFileWriteInapplicableStringEncodingError = 517;
public static final int NSFileWriteInvalidFileNameError = 514;
public static final int NSFileWriteNoPermissionError = 513;
public static final int NSFileWriteOutOfSpaceError = 640;
public static final int NSFileWriteUnknownError = 512;
public static final int NSFileWriteUnsupportedSchemeError = 518;
public static final int NSForcedOrderingSearch = 512;
public static final int NSFormattingError = 2048;
public static final int NSFormattingErrorMaximum = 2559;
public static final int NSFormattingErrorMinimum = 2048;
public static final double NSFoundationVersionNumber10_0 = 397.39999999999998;
public static final double NSFoundationVersionNumber10_1 = 425.00000000000000;
public static final double NSFoundationVersionNumber10_1_1 = 425.00000000000000;
public static final double NSFoundationVersionNumber10_1_2 = 425.00000000000000;
public static final double NSFoundationVersionNumber10_1_3 = 425.00000000000000;
public static final double NSFoundationVersionNumber10_1_4 = 425.00000000000000;
public static final double NSFoundationVersionNumber10_2 = 462.00000000000000;
public static final double NSFoundationVersionNumber10_2_1 = 462.00000000000000;
public static final double NSFoundationVersionNumber10_2_2 = 462.00000000000000;
public static final double NSFoundationVersionNumber10_2_3 = 462.00000000000000;
public static final double NSFoundationVersionNumber10_2_4 = 462.00000000000000;
public static final double NSFoundationVersionNumber10_2_5 = 462.00000000000000;
public static final double NSFoundationVersionNumber10_2_6 = 462.00000000000000;
public static final double NSFoundationVersionNumber10_2_7 = 462.69999999999999;
public static final double NSFoundationVersionNumber10_2_8 = 462.69999999999999;
public static final double NSFoundationVersionNumber10_3 = 500.00000000000000;
public static final double NSFoundationVersionNumber10_3_1 = 500.00000000000000;
public static final double NSFoundationVersionNumber10_3_2 = 500.30000000000001;
public static final double NSFoundationVersionNumber10_3_3 = 500.54000000000002;
public static final double NSFoundationVersionNumber10_3_4 = 500.56000000000000;
public static final double NSFoundationVersionNumber10_3_5 = 500.56000000000000;
public static final double NSFoundationVersionNumber10_3_6 = 500.56000000000000;
public static final double NSFoundationVersionNumber10_3_7 = 500.56000000000000;
public static final double NSFoundationVersionNumber10_3_8 = 500.56000000000000;
public static final double NSFoundationVersionNumber10_3_9 = 500.57999999999998;
public static final double NSFoundationVersionNumber10_4 = 567.00000000000000;
public static final double NSFoundationVersionNumber10_4_1 = 567.00000000000000;
public static final double NSFoundationVersionNumber10_4_10 = 567.28999999999996;
public static final double NSFoundationVersionNumber10_4_11 = 567.36000000000001;
public static final double NSFoundationVersionNumber10_4_2 = 567.12000000000000;
public static final double NSFoundationVersionNumber10_4_3 = 567.21000000000004;
public static final double NSFoundationVersionNumber10_4_4_Intel = 567.23000000000002;
public static final double NSFoundationVersionNumber10_4_4_PowerPC = 567.21000000000004;
public static final double NSFoundationVersionNumber10_4_5 = 567.25000000000000;
public static final double NSFoundationVersionNumber10_4_6 = 567.25999999999999;
public static final double NSFoundationVersionNumber10_4_7 = 567.26999999999998;
public static final double NSFoundationVersionNumber10_4_8 = 567.27999999999997;
public static final double NSFoundationVersionNumber10_4_9 = 567.28999999999996;
public static final int NSFoundationVersionWithFileManagerResourceForkSupport = 412;
public static final int NSFunctionExpressionType = 4;
public static final int NSGreaterThanComparison = 4;
public static final int NSGreaterThanOrEqualToComparison = 3;
public static final int NSGreaterThanOrEqualToPredicateOperatorType = 3;
public static final int NSGreaterThanPredicateOperatorType = 2;
public static final int NSHPUXOperatingSystem = 4;
public static final int NSHTTPCookieAcceptPolicyAlways = 0;
public static final int NSHTTPCookieAcceptPolicyNever = 1;
public static final int NSHTTPCookieAcceptPolicyOnlyFromMainDocumentDomain = 2;
public static final int NSHashTableCopyIn = 65536;
public static final int NSHashTableObjectPointerPersonality = 512;
public static final int NSHashTableStrongMemory = 0;
public static final int NSHashTableZeroingWeakMemory = 1;
public static final int NSHourCalendarUnit = 32;
public static final int NSINTEGER_DEFINED = 1;
public static final int NSISO2022JPStringEncoding = 21;
public static final int NSISOLatin1StringEncoding = 5;
public static final int NSISOLatin2StringEncoding = 9;
public static final int NSInPredicateOperatorType = 10;
public static final int NSIndexSubelement = 0;
public static final int NSIntegerMax = 2147483647;
public static final int NSIntegerMin = -2147483648;
public static final int NSInternalScriptError = 8;
public static final int NSInternalSpecifierError = 5;
public static final int NSIntersectSetExpressionType = 6;
public static final int NSInvalidIndexSpecifierError = 4;
public static final int NSJapaneseEUCStringEncoding = 3;
public static final int NSKeyPathExpressionType = 3;
public static final int NSKeySpecifierEvaluationScriptError = 2;
public static final int NSKeyValueChangeInsertion = 2;
public static final int NSKeyValueChangeRemoval = 3;
public static final int NSKeyValueChangeReplacement = 4;
public static final int NSKeyValueChangeSetting = 1;
public static final int NSKeyValueIntersectSetMutation = 3;
public static final int NSKeyValueMinusSetMutation = 2;
public static final int NSKeyValueObservingOptionInitial = 4;
public static final int NSKeyValueObservingOptionNew = 1;
public static final int NSKeyValueObservingOptionOld = 2;
public static final int NSKeyValueObservingOptionPrior = 8;
public static final int NSKeyValueSetSetMutation = 4;
public static final int NSKeyValueUnionSetMutation = 1;
public static final int NSKeyValueValidationError = 1024;
public static final int NSLessThanComparison = 2;
public static final int NSLessThanOrEqualToComparison = 1;
public static final int NSLessThanOrEqualToPredicateOperatorType = 1;
public static final int NSLessThanPredicateOperatorType = 0;
public static final int NSLibraryDirectory = 5;
public static final int NSLikePredicateOperatorType = 7;
public static final int NSLiteralSearch = 2;
public static final int NSLocalDomainMask = 2;
public static final int NSMACHOperatingSystem = 5;
public static final int NSMacOSRomanStringEncoding = 30;
public static final int NSMachPortDeallocateNone = 0;
public static final int NSMachPortDeallocateReceiveRight = 2;
public static final int NSMachPortDeallocateSendRight = 1;
public static final int NSMapTableCopyIn = 65536;
public static final int NSMapTableObjectPointerPersonality = 512;
public static final int NSMapTableStrongMemory = 0;
public static final int NSMapTableZeroingWeakMemory = 1;
public static final int NSMappedRead = 1;
public static final int NSMatchesPredicateOperatorType = 6;
public static final int NSMaxXEdge = 2;
public static final int NSMaxYEdge = 3;
public static final int NSMiddleSubelement = 2;
public static final int NSMinXEdge = 0;
public static final int NSMinYEdge = 1;
public static final int NSMinusSetExpressionType = 7;
public static final int NSMinuteCalendarUnit = 64;
public static final int NSMonthCalendarUnit = 8;
public static final int NSNEXTSTEPStringEncoding = 2;
public static final int NSNetServiceNoAutoRename = 1;
public static final int NSNetServicesActivityInProgress = -72003;
public static final int NSNetServicesBadArgumentError = -72004;
public static final int NSNetServicesCancelledError = -72005;
public static final int NSNetServicesCollisionError = -72001;
public static final int NSNetServicesInvalidError = -72006;
public static final int NSNetServicesNotFoundError = -72002;
public static final int NSNetServicesTimeoutError = -72007;
public static final int NSNetServicesUnknownError = -72000;
public static final int NSNetworkDomainMask = 4;
public static final int NSNoScriptError = 0;
public static final int NSNoSpecifierError = 0;
public static final int NSNoSubelement = 4;
public static final int NSNoTopLevelContainersSpecifierError = 1;
public static final int NSNonLossyASCIIStringEncoding = 7;
public static final int NSNotEqualToPredicateOperatorType = 5;
public static final int NSNotFound = 2147483647;
public static final int NSNotPredicateType = 0;
public static final int NSNotificationCoalescingOnName = 1;
public static final int NSNotificationCoalescingOnSender = 2;
public static final int NSNotificationDeliverImmediately = 1;
public static final int NSNotificationNoCoalescing = 0;
public static final int NSNotificationPostToAllSessions = 2;
public static final int NSNotificationSuspensionBehaviorCoalesce = 2;
public static final int NSNotificationSuspensionBehaviorDeliverImmediately = 4;
public static final int NSNotificationSuspensionBehaviorDrop = 1;
public static final int NSNotificationSuspensionBehaviorHold = 3;
public static final int NSNumberFormatterBehavior10_0 = 1000;
public static final int NSNumberFormatterBehavior10_4 = 1040;
public static final int NSNumberFormatterBehaviorDefault = 0;
public static final int NSNumberFormatterCurrencyStyle = 2;
public static final int NSNumberFormatterDecimalStyle = 1;
public static final int NSNumberFormatterNoStyle = 0;
public static final int NSNumberFormatterPadAfterPrefix = 1;
public static final int NSNumberFormatterPadAfterSuffix = 3;
public static final int NSNumberFormatterPadBeforePrefix = 0;
public static final int NSNumberFormatterPadBeforeSuffix = 2;
public static final int NSNumberFormatterPercentStyle = 3;
public static final int NSNumberFormatterRoundCeiling = 0;
public static final int NSNumberFormatterRoundDown = 2;
public static final int NSNumberFormatterRoundFloor = 1;
public static final int NSNumberFormatterRoundHalfDown = 5;
public static final int NSNumberFormatterRoundHalfEven = 4;
public static final int NSNumberFormatterRoundHalfUp = 6;
public static final int NSNumberFormatterRoundUp = 3;
public static final int NSNumberFormatterScientificStyle = 4;
public static final int NSNumberFormatterSpellOutStyle = 5;
public static final int NSNumericSearch = 64;
public static final int NSOSF1OperatingSystem = 7;
public static final int NSObjCArrayType = 91;
public static final int NSObjCBitfield = 98;
public static final int NSObjCBoolType = 66;
public static final int NSObjCCharType = 99;
public static final int NSObjCDoubleType = 100;
public static final int NSObjCFloatType = 102;
public static final int NSObjCLongType = 108;
public static final int NSObjCLonglongType = 113;
public static final int NSObjCNoType = 0;
public static final int NSObjCObjectType = 64;
public static final int NSObjCPointerType = 94;
public static final int NSObjCSelectorType = 58;
public static final int NSObjCShortType = 115;
public static final int NSObjCStringType = 42;
public static final int NSObjCStructType = 123;
public static final int NSObjCUnionType = 40;
public static final int NSObjCVoidType = 118;
public static final int NSObjectAutoreleasedEvent = 3;
public static final int NSObjectExtraRefDecrementedEvent = 5;
public static final int NSObjectExtraRefIncrementedEvent = 4;
public static final int NSObjectInternalRefDecrementedEvent = 7;
public static final int NSObjectInternalRefIncrementedEvent = 6;
public static final int NSOpenStepUnicodeReservedBase = 62464;
public static final int NSOperationNotSupportedForKeyScriptError = 9;
public static final int NSOperationNotSupportedForKeySpecifierError = 6;
public static final int NSOperationQueueDefaultMaxConcurrentOperationCount = -1;
public static final int NSOperationQueuePriorityHigh = 4;
public static final int NSOperationQueuePriorityLow = -4;
public static final int NSOperationQueuePriorityNormal = 0;
public static final int NSOperationQueuePriorityVeryHigh = 8;
public static final int NSOperationQueuePriorityVeryLow = -8;
public static final int NSOrPredicateType = 2;
public static final int NSOrderedAscending = -1;
public static final int NSOrderedDescending = 1;
public static final int NSOrderedSame = 0;
public static final int NSPointerFunctionsCStringPersonality = 768;
public static final int NSPointerFunctionsCopyIn = 65536;
public static final int NSPointerFunctionsIntegerPersonality = 1280;
public static final int NSPointerFunctionsMachVirtualMemory = 4;
public static final int NSPointerFunctionsMallocMemory = 3;
public static final int NSPointerFunctionsObjectPersonality = 0;
public static final int NSPointerFunctionsObjectPointerPersonality = 512;
public static final int NSPointerFunctionsOpaqueMemory = 2;
public static final int NSPointerFunctionsOpaquePersonality = 256;
public static final int NSPointerFunctionsStrongMemory = 0;
public static final int NSPointerFunctionsStructPersonality = 1024;
public static final int NSPointerFunctionsZeroingWeakMemory = 1;
public static final int NSPositionAfter = 0;
public static final int NSPositionBefore = 1;
public static final int NSPositionBeginning = 2;
public static final int NSPositionEnd = 3;
public static final int NSPositionReplace = 4;
public static final int NSPostASAP = 2;
public static final int NSPostNow = 3;
public static final int NSPostWhenIdle = 1;
public static final int NSPropertyListBinaryFormat_v1_0 = 200;
public static final int NSPropertyListImmutable = 0;
public static final int NSPropertyListMutableContainers = 1;
public static final int NSPropertyListMutableContainersAndLeaves = 2;
public static final int NSPropertyListOpenStepFormat = 1;
public static final int NSPropertyListXMLFormat_v1_0 = 100;
public static final int NSRandomSubelement = 3;
public static final int NSReceiverEvaluationScriptError = 1;
public static final int NSReceiversCantHandleCommandScriptError = 4;
public static final int NSRelativeAfter = 0;
public static final int NSRelativeBefore = 1;
public static final int NSRequiredArgumentsMissingScriptError = 5;
public static final int NSRoundBankers = 3;
public static final int NSRoundDown = 1;
public static final int NSRoundPlain = 0;
public static final int NSRoundUp = 2;
public static final int NSSaveOptionsAsk = 2;
public static final int NSSaveOptionsNo = 1;
public static final int NSSaveOptionsYes = 0;
public static final int NSScannedOption = 1;
public static final int NSSecondCalendarUnit = 128;
public static final int NSShiftJISStringEncoding = 8;
public static final int NSSolarisOperatingSystem = 3;
public static final int NSStreamEventEndEncountered = 16;
public static final int NSStreamEventErrorOccurred = 8;
public static final int NSStreamEventHasBytesAvailable = 2;
public static final int NSStreamEventHasSpaceAvailable = 4;
public static final int NSStreamEventNone = 0;
public static final int NSStreamEventOpenCompleted = 1;
public static final int NSStreamStatusAtEnd = 5;
public static final int NSStreamStatusClosed = 6;
public static final int NSStreamStatusError = 7;
public static final int NSStreamStatusNotOpen = 0;
public static final int NSStreamStatusOpen = 2;
public static final int NSStreamStatusOpening = 1;
public static final int NSStreamStatusReading = 3;
public static final int NSStreamStatusWriting = 4;
public static final int NSStringEncodingConversionAllowLossy = 1;
public static final int NSStringEncodingConversionExternalRepresentation = 2;
public static final int NSSubqueryExpressionType = 13;
public static final int NSSunOSOperatingSystem = 6;
public static final int NSSymbolStringEncoding = 6;
public static final int NSSystemDomainMask = 8;
public static final double NSTimeIntervalSince1970 = 978307200.00000000;
public static final int NSTimeZoneNameStyleDaylightSaving = 2;
public static final int NSTimeZoneNameStyleShortDaylightSaving = 3;
public static final int NSTimeZoneNameStyleShortStandard = 1;
public static final int NSTimeZoneNameStyleStandard = 0;
public static final long NSUIntegerMax = 4294967295L;
public static final int NSURLCacheStorageAllowed = 0;
public static final int NSURLCacheStorageAllowedInMemoryOnly = 1;
public static final int NSURLCacheStorageNotAllowed = 2;
public static final int NSURLCredentialPersistenceForSession = 1;
public static final int NSURLCredentialPersistenceNone = 0;
public static final int NSURLCredentialPersistencePermanent = 2;
public static final int NSURLErrorBadServerResponse = -1011;
public static final int NSURLErrorBadURL = -1000;
public static final int NSURLErrorCancelled = -999;
public static final int NSURLErrorCannotCloseFile = -3002;
public static final int NSURLErrorCannotConnectToHost = -1004;
public static final int NSURLErrorCannotCreateFile = -3000;
public static final int NSURLErrorCannotDecodeContentData = -1016;
public static final int NSURLErrorCannotDecodeRawData = -1015;
public static final int NSURLErrorCannotFindHost = -1003;
public static final int NSURLErrorCannotLoadFromNetwork = -2000;
public static final int NSURLErrorCannotMoveFile = -3005;
public static final int NSURLErrorCannotOpenFile = -3001;
public static final int NSURLErrorCannotParseResponse = -1017;
public static final int NSURLErrorCannotRemoveFile = -3004;
public static final int NSURLErrorCannotWriteToFile = -3003;
public static final int NSURLErrorClientCertificateRejected = -1205;
public static final int NSURLErrorDNSLookupFailed = -1006;
public static final int NSURLErrorDataLengthExceedsMaximum = -1103;
public static final int NSURLErrorDownloadDecodingFailedMidStream = -3006;
public static final int NSURLErrorDownloadDecodingFailedToComplete = -3007;
public static final int NSURLErrorFileDoesNotExist = -1100;
public static final int NSURLErrorFileIsDirectory = -1101;
public static final int NSURLErrorHTTPTooManyRedirects = -1007;
public static final int NSURLErrorNetworkConnectionLost = -1005;
public static final int NSURLErrorNoPermissionsToReadFile = -1102;
public static final int NSURLErrorNotConnectedToInternet = -1009;
public static final int NSURLErrorRedirectToNonExistentLocation = -1010;
public static final int NSURLErrorResourceUnavailable = -1008;
public static final int NSURLErrorSecureConnectionFailed = -1200;
public static final int NSURLErrorServerCertificateHasBadDate = -1201;
public static final int NSURLErrorServerCertificateHasUnknownRoot = -1203;
public static final int NSURLErrorServerCertificateNotYetValid = -1204;
public static final int NSURLErrorServerCertificateUntrusted = -1202;
public static final int NSURLErrorTimedOut = -1001;
public static final int NSURLErrorUnknown = -1;
public static final int NSURLErrorUnsupportedURL = -1002;
public static final int NSURLErrorUserAuthenticationRequired = -1013;
public static final int NSURLErrorUserCancelledAuthentication = -1012;
public static final int NSURLErrorZeroByteResource = -1014;
public static final int NSURLHandleLoadFailed = 3;
public static final int NSURLHandleLoadInProgress = 2;
public static final int NSURLHandleLoadSucceeded = 1;
public static final int NSURLHandleNotLoaded = 0;
public static final int NSURLRequestReloadIgnoringCacheData = 1;
public static final int NSURLRequestReloadIgnoringLocalAndRemoteCacheData = 4;
public static final int NSURLRequestReloadIgnoringLocalCacheData = 1;
public static final int NSURLRequestReloadRevalidatingCacheData = 5;
public static final int NSURLRequestReturnCacheDataDontLoad = 3;
public static final int NSURLRequestReturnCacheDataElseLoad = 2;
public static final int NSURLRequestUseProtocolCachePolicy = 0;
public static final int NSUTF16BigEndianStringEncoding = -1879047936;
public static final int NSUTF16LittleEndianStringEncoding = -1811939072;
public static final int NSUTF16StringEncoding = 10;
public static final int NSUTF32BigEndianStringEncoding = -1744830208;
public static final int NSUTF32LittleEndianStringEncoding = -1677721344;
public static final int NSUTF32StringEncoding = -1946156800;
public static final int NSUTF8StringEncoding = 4;
public static final int NSUncachedRead = 2;
public static final int NSUndefinedDateComponent = 2147483647;
public static final int NSUndoCloseGroupingRunLoopOrdering = 350000;
public static final int NSUnicodeStringEncoding = 10;
public static final int NSUnionSetExpressionType = 5;
public static final int NSUnknownKeyScriptError = 7;
public static final int NSUnknownKeySpecifierError = 3;
public static final int NSUserCancelledError = 3072;
public static final int NSUserDirectory = 7;
public static final int NSUserDomainMask = 1;
public static final int NSValidationErrorMaximum = 2047;
public static final int NSValidationErrorMinimum = 1024;
public static final int NSVariableExpressionType = 2;
public static final int NSWeekCalendarUnit = 256;
public static final int NSWeekdayCalendarUnit = 512;
public static final int NSWeekdayOrdinalCalendarUnit = 1024;
public static final int NSWidthInsensitiveSearch = 256;
public static final int NSWindows95OperatingSystem = 2;
public static final int NSWindowsCP1250StringEncoding = 15;
public static final int NSWindowsCP1251StringEncoding = 11;
public static final int NSWindowsCP1252StringEncoding = 12;
public static final int NSWindowsCP1253StringEncoding = 13;
public static final int NSWindowsCP1254StringEncoding = 14;
public static final int NSWindowsNTOperatingSystem = 1;
public static final int NSWrapCalendarComponents = 1;
public static final int NSXMLAttributeCDATAKind = 6;
public static final int NSXMLAttributeDeclarationKind = 10;
public static final int NSXMLAttributeEntitiesKind = 11;
public static final int NSXMLAttributeEntityKind = 10;
public static final int NSXMLAttributeEnumerationKind = 14;
public static final int NSXMLAttributeIDKind = 7;
public static final int NSXMLAttributeIDRefKind = 8;
public static final int NSXMLAttributeIDRefsKind = 9;
public static final int NSXMLAttributeKind = 3;
public static final int NSXMLAttributeNMTokenKind = 12;
public static final int NSXMLAttributeNMTokensKind = 13;
public static final int NSXMLAttributeNotationKind = 15;
public static final int NSXMLCommentKind = 6;
public static final int NSXMLDTDKind = 8;
public static final int NSXMLDocumentHTMLKind = 2;
public static final int NSXMLDocumentIncludeContentTypeDeclaration = 262144;
public static final int NSXMLDocumentKind = 1;
public static final int NSXMLDocumentTextKind = 3;
public static final int NSXMLDocumentTidyHTML = 512;
public static final int NSXMLDocumentTidyXML = 1024;
public static final int NSXMLDocumentValidate = 8192;
public static final int NSXMLDocumentXHTMLKind = 1;
public static final int NSXMLDocumentXInclude = 65536;
public static final int NSXMLDocumentXMLKind = 0;
public static final int NSXMLElementDeclarationAnyKind = 18;
public static final int NSXMLElementDeclarationElementKind = 20;
public static final int NSXMLElementDeclarationEmptyKind = 17;
public static final int NSXMLElementDeclarationKind = 11;
public static final int NSXMLElementDeclarationMixedKind = 19;
public static final int NSXMLElementDeclarationUndefinedKind = 16;
public static final int NSXMLElementKind = 2;
public static final int NSXMLEntityDeclarationKind = 9;
public static final int NSXMLEntityGeneralKind = 1;
public static final int NSXMLEntityParameterKind = 4;
public static final int NSXMLEntityParsedKind = 2;
public static final int NSXMLEntityPredefined = 5;
public static final int NSXMLEntityUnparsedKind = 3;
public static final int NSXMLInvalidKind = 0;
public static final int NSXMLNamespaceKind = 4;
public static final int NSXMLNodeCompactEmptyElement = 4;
public static final int NSXMLNodeExpandEmptyElement = 2;
public static final int NSXMLNodeIsCDATA = 1;
public static final int NSXMLNodeOptionsNone = 0;
public static final int NSXMLNodePreserveAll = -1048546;
public static final int NSXMLNodePreserveAttributeOrder = 2097152;
public static final int NSXMLNodePreserveCDATA = 16777216;
public static final int NSXMLNodePreserveCharacterReferences = 134217728;
public static final int NSXMLNodePreserveDTD = 67108864;
public static final int NSXMLNodePreserveEmptyElements = 6;
public static final int NSXMLNodePreserveEntities = 4194304;
public static final int NSXMLNodePreserveNamespaceOrder = 1048576;
public static final int NSXMLNodePreservePrefixes = 8388608;
public static final int NSXMLNodePreserveQuotes = 24;
public static final int NSXMLNodePreserveWhitespace = 33554432;
public static final int NSXMLNodePrettyPrint = 131072;
public static final int NSXMLNodeUseDoubleQuotes = 16;
public static final int NSXMLNodeUseSingleQuotes = 8;
public static final int NSXMLNotationDeclarationKind = 12;
public static final int NSXMLParserAttributeHasNoValueError = 41;
public static final int NSXMLParserAttributeListNotFinishedError = 51;
public static final int NSXMLParserAttributeListNotStartedError = 50;
public static final int NSXMLParserAttributeNotFinishedError = 40;
public static final int NSXMLParserAttributeNotStartedError = 39;
public static final int NSXMLParserAttributeRedefinedError = 42;
public static final int NSXMLParserCDATANotFinishedError = 63;
public static final int NSXMLParserCharacterRefAtEOFError = 10;
public static final int NSXMLParserCharacterRefInDTDError = 13;
public static final int NSXMLParserCharacterRefInEpilogError = 12;
public static final int NSXMLParserCharacterRefInPrologError = 11;
public static final int NSXMLParserCommentContainsDoubleHyphenError = 80;
public static final int NSXMLParserCommentNotFinishedError = 45;
public static final int NSXMLParserConditionalSectionNotFinishedError = 59;
public static final int NSXMLParserConditionalSectionNotStartedError = 58;
public static final int NSXMLParserDOCTYPEDeclNotFinishedError = 61;
public static final int NSXMLParserDelegateAbortedParseError = 512;
public static final int NSXMLParserDocumentStartError = 3;
public static final int NSXMLParserElementContentDeclNotFinishedError = 55;
public static final int NSXMLParserElementContentDeclNotStartedError = 54;
public static final int NSXMLParserEmptyDocumentError = 4;
public static final int NSXMLParserEncodingNotSupportedError = 32;
public static final int NSXMLParserEntityBoundaryError = 90;
public static final int NSXMLParserEntityIsExternalError = 29;
public static final int NSXMLParserEntityIsParameterError = 30;
public static final int NSXMLParserEntityNotFinishedError = 37;
public static final int NSXMLParserEntityNotStartedError = 36;
public static final int NSXMLParserEntityRefAtEOFError = 14;
public static final int NSXMLParserEntityRefInDTDError = 17;
public static final int NSXMLParserEntityRefInEpilogError = 16;
public static final int NSXMLParserEntityRefInPrologError = 15;
public static final int NSXMLParserEntityRefLoopError = 89;
public static final int NSXMLParserEntityReferenceMissingSemiError = 23;
public static final int NSXMLParserEntityReferenceWithoutNameError = 22;
public static final int NSXMLParserEntityValueRequiredError = 84;
public static final int NSXMLParserEqualExpectedError = 75;
public static final int NSXMLParserExternalStandaloneEntityError = 82;
public static final int NSXMLParserExternalSubsetNotFinishedError = 60;
public static final int NSXMLParserExtraContentError = 86;
public static final int NSXMLParserGTRequiredError = 73;
public static final int NSXMLParserInternalError = 1;
public static final int NSXMLParserInvalidCharacterError = 9;
public static final int NSXMLParserInvalidCharacterInEntityError = 87;
public static final int NSXMLParserInvalidCharacterRefError = 8;
public static final int NSXMLParserInvalidConditionalSectionError = 83;
public static final int NSXMLParserInvalidDecimalCharacterRefError = 7;
public static final int NSXMLParserInvalidEncodingError = 81;
public static final int NSXMLParserInvalidEncodingNameError = 79;
public static final int NSXMLParserInvalidHexCharacterRefError = 6;
public static final int NSXMLParserInvalidURIError = 91;
public static final int NSXMLParserLTRequiredError = 72;
public static final int NSXMLParserLTSlashRequiredError = 74;
public static final int NSXMLParserLessThanSymbolInAttributeError = 38;
public static final int NSXMLParserLiteralNotFinishedError = 44;
public static final int NSXMLParserLiteralNotStartedError = 43;
public static final int NSXMLParserMisplacedCDATAEndStringError = 62;
public static final int NSXMLParserMisplacedXMLDeclarationError = 64;
public static final int NSXMLParserMixedContentDeclNotFinishedError = 53;
public static final int NSXMLParserMixedContentDeclNotStartedError = 52;
public static final int NSXMLParserNAMERequiredError = 68;
public static final int NSXMLParserNMTOKENRequiredError = 67;
public static final int NSXMLParserNamespaceDeclarationError = 35;
public static final int NSXMLParserNoDTDError = 94;
public static final int NSXMLParserNotWellBalancedError = 85;
public static final int NSXMLParserNotationNotFinishedError = 49;
public static final int NSXMLParserNotationNotStartedError = 48;
public static final int NSXMLParserOutOfMemoryError = 2;
public static final int NSXMLParserPCDATARequiredError = 69;
public static final int NSXMLParserParsedEntityRefAtEOFError = 18;
public static final int NSXMLParserParsedEntityRefInEpilogError = 20;
public static final int NSXMLParserParsedEntityRefInInternalError = 88;
public static final int NSXMLParserParsedEntityRefInInternalSubsetError = 21;
public static final int NSXMLParserParsedEntityRefInPrologError = 19;
public static final int NSXMLParserParsedEntityRefMissingSemiError = 25;
public static final int NSXMLParserParsedEntityRefNoNameError = 24;
public static final int NSXMLParserPrematureDocumentEndError = 5;
public static final int NSXMLParserProcessingInstructionNotFinishedError = 47;
public static final int NSXMLParserProcessingInstructionNotStartedError = 46;
public static final int NSXMLParserPublicIdentifierRequiredError = 71;
public static final int NSXMLParserSeparatorRequiredError = 66;
public static final int NSXMLParserSpaceRequiredError = 65;
public static final int NSXMLParserStandaloneValueError = 78;
public static final int NSXMLParserStringNotClosedError = 34;
public static final int NSXMLParserStringNotStartedError = 33;
public static final int NSXMLParserTagNameMismatchError = 76;
public static final int NSXMLParserURIFragmentError = 92;
public static final int NSXMLParserURIRequiredError = 70;
public static final int NSXMLParserUndeclaredEntityError = 26;
public static final int NSXMLParserUnfinishedTagError = 77;
public static final int NSXMLParserUnknownEncodingError = 31;
public static final int NSXMLParserUnparsedEntityError = 28;
public static final int NSXMLParserXMLDeclNotFinishedError = 57;
public static final int NSXMLParserXMLDeclNotStartedError = 56;
public static final int NSXMLProcessingInstructionKind = 5;
public static final int NSXMLTextKind = 7;
public static final int NSYearCalendarUnit = 4;
public static final int NS_BigEndian = 2;
public static final int NS_LittleEndian = 1;
public static final int NS_UNICHAR_IS_EIGHT_BIT = 0;
public static final int NS_UnknownByteOrder = 0;
public static final int DOM_ADDITION = 2;
public static final int DOM_ANY_TYPE = 0;
public static final int DOM_ANY_UNORDERED_NODE_TYPE = 8;
public static final int DOM_ATTRIBUTE_NODE = 2;
public static final int DOM_AT_TARGET = 2;
public static final int DOM_BAD_BOUNDARYPOINTS_ERR = 1;
public static final int DOM_BOOLEAN_TYPE = 3;
public static final int DOM_BOTH = 2;
public static final int DOM_BUBBLING_PHASE = 3;
public static final int DOM_CAPTURING_PHASE = 1;
public static final int DOM_CDATA_SECTION_NODE = 4;
public static final int DOM_CHARSET_RULE = 2;
public static final int DOM_COMMENT_NODE = 8;
public static final int DOM_CSS_ATTR = 22;
public static final int DOM_CSS_CM = 6;
public static final int DOM_CSS_COUNTER = 23;
public static final int DOM_CSS_CUSTOM = 3;
public static final int DOM_CSS_DEG = 11;
public static final int DOM_CSS_DIMENSION = 18;
public static final int DOM_CSS_EMS = 3;
public static final int DOM_CSS_EXS = 4;
public static final int DOM_CSS_GRAD = 13;
public static final int DOM_CSS_HZ = 16;
public static final int DOM_CSS_IDENT = 21;
public static final int DOM_CSS_IN = 8;
public static final int DOM_CSS_INHERIT = 0;
public static final int DOM_CSS_KHZ = 17;
public static final int DOM_CSS_MM = 7;
public static final int DOM_CSS_MS = 14;
public static final int DOM_CSS_NUMBER = 1;
public static final int DOM_CSS_PC = 10;
public static final int DOM_CSS_PERCENTAGE = 2;
public static final int DOM_CSS_PRIMITIVE_VALUE = 1;
public static final int DOM_CSS_PT = 9;
public static final int DOM_CSS_PX = 5;
public static final int DOM_CSS_RAD = 12;
public static final int DOM_CSS_RECT = 24;
public static final int DOM_CSS_RGBCOLOR = 25;
public static final int DOM_CSS_S = 15;
public static final int DOM_CSS_STRING = 19;
public static final int DOM_CSS_UNKNOWN = 0;
public static final int DOM_CSS_URI = 20;
public static final int DOM_CSS_VALUE_LIST = 2;
public static final int DOM_DOCUMENT_FRAGMENT_NODE = 11;
public static final int DOM_DOCUMENT_NODE = 9;
public static final int DOM_DOCUMENT_TYPE_NODE = 10;
public static final int DOM_DOMSTRING_SIZE_ERR = 2;
public static final int DOM_ELEMENT_NODE = 1;
public static final int DOM_END_TO_END = 2;
public static final int DOM_END_TO_START = 3;
public static final int DOM_ENTITY_NODE = 6;
public static final int DOM_ENTITY_REFERENCE_NODE = 5;
public static final int DOM_FILTER_ACCEPT = 1;
public static final int DOM_FILTER_REJECT = 2;
public static final int DOM_FILTER_SKIP = 3;
public static final int DOM_FIRST_ORDERED_NODE_TYPE = 9;
public static final int DOM_FONT_FACE_RULE = 5;
public static final int DOM_HIERARCHY_REQUEST_ERR = 3;
public static final int DOM_HORIZONTAL = 0;
public static final int DOM_IMPORT_RULE = 3;
public static final int DOM_INDEX_SIZE_ERR = 1;
public static final int DOM_INUSE_ATTRIBUTE_ERR = 10;
public static final int DOM_INVALID_ACCESS_ERR = 15;
public static final int DOM_INVALID_CHARACTER_ERR = 5;
public static final int DOM_INVALID_EXPRESSION_ERR = 51;
public static final int DOM_INVALID_MODIFICATION_ERR = 13;
public static final int DOM_INVALID_NODE_TYPE_ERR = 2;
public static final int DOM_INVALID_STATE_ERR = 11;
public static final int DOM_KEY_LOCATION_LEFT = 1;
public static final int DOM_KEY_LOCATION_NUMPAD = 3;
public static final int DOM_KEY_LOCATION_RIGHT = 2;
public static final int DOM_KEY_LOCATION_STANDARD = 0;
public static final int DOM_MEDIA_RULE = 4;
public static final int DOM_MODIFICATION = 1;
public static final int DOM_NAMESPACE_ERR = 14;
public static final int DOM_NODE_AFTER = 1;
public static final int DOM_NODE_BEFORE = 0;
public static final int DOM_NODE_BEFORE_AND_AFTER = 2;
public static final int DOM_NODE_INSIDE = 3;
public static final int DOM_NOTATION_NODE = 12;
public static final int DOM_NOT_FOUND_ERR = 8;
public static final int DOM_NOT_SUPPORTED_ERR = 9;
public static final int DOM_NO_DATA_ALLOWED_ERR = 6;
public static final int DOM_NO_MODIFICATION_ALLOWED_ERR = 7;
public static final int DOM_NUMBER_TYPE = 1;
public static final int DOM_ORDERED_NODE_ITERATOR_TYPE = 5;
public static final int DOM_ORDERED_NODE_SNAPSHOT_TYPE = 7;
public static final int DOM_PAGE_RULE = 6;
public static final int DOM_PROCESSING_INSTRUCTION_NODE = 7;
public static final int DOM_REMOVAL = 3;
public static final int DOM_SHOW_ALL = -1;
public static final int DOM_SHOW_ATTRIBUTE = 2;
public static final int DOM_SHOW_CDATA_SECTION = 8;
public static final int DOM_SHOW_COMMENT = 128;
public static final int DOM_SHOW_DOCUMENT = 256;
public static final int DOM_SHOW_DOCUMENT_FRAGMENT = 1024;
public static final int DOM_SHOW_DOCUMENT_TYPE = 512;
public static final int DOM_SHOW_ELEMENT = 1;
public static final int DOM_SHOW_ENTITY = 32;
public static final int DOM_SHOW_ENTITY_REFERENCE = 16;
public static final int DOM_SHOW_NOTATION = 2048;
public static final int DOM_SHOW_PROCESSING_INSTRUCTION = 64;
public static final int DOM_SHOW_TEXT = 4;
public static final int DOM_START_TO_END = 1;
public static final int DOM_START_TO_START = 0;
public static final int DOM_STRING_TYPE = 2;
public static final int DOM_STYLE_RULE = 1;
public static final int DOM_SYNTAX_ERR = 12;
public static final int DOM_TEXT_NODE = 3;
public static final int DOM_TYPE_ERR = 52;
public static final int DOM_UNKNOWN_RULE = 0;
public static final int DOM_UNORDERED_NODE_ITERATOR_TYPE = 4;
public static final int DOM_UNORDERED_NODE_SNAPSHOT_TYPE = 6;
public static final int DOM_UNSPECIFIED_EVENT_TYPE_ERR = 0;
public static final int DOM_VERTICAL = 1;
public static final int DOM_WRONG_DOCUMENT_ERR = 4;
public static final int WebCacheModelDocumentBrowser = 1;
public static final int WebCacheModelDocumentViewer = 0;
public static final int WebCacheModelPrimaryWebBrowser = 2;
public static final int WebDragDestinationActionAny = -1;
public static final int WebDragDestinationActionDHTML = 1;
public static final int WebDragDestinationActionEdit = 2;
public static final int WebDragDestinationActionLoad = 4;
public static final int WebDragDestinationActionNone = 0;
public static final int WebDragSourceActionAny = -1;
public static final int WebDragSourceActionDHTML = 1;
public static final int WebDragSourceActionImage = 2;
public static final int WebDragSourceActionLink = 4;
public static final int WebDragSourceActionNone = 0;
public static final int WebDragSourceActionSelection = 8;
public static final int WebJNIReturnTypeBoolean = 3;
public static final int WebJNIReturnTypeByte = 4;
public static final int WebJNIReturnTypeChar = 5;
public static final int WebJNIReturnTypeDouble = 10;
public static final int WebJNIReturnTypeFloat = 9;
public static final int WebJNIReturnTypeInt = 7;
public static final int WebJNIReturnTypeInvalid = 0;
public static final int WebJNIReturnTypeLong = 8;
public static final int WebJNIReturnTypeObject = 2;
public static final int WebJNIReturnTypeShort = 6;
public static final int WebJNIReturnTypeVoid = 1;
public static final int WebKitErrorCannotFindPlugIn = 200;
public static final int WebKitErrorCannotLoadPlugIn = 201;
public static final int WebKitErrorCannotShowMIMEType = 100;
public static final int WebKitErrorCannotShowURL = 101;
public static final int WebKitErrorFrameLoadInterruptedByPolicyChange = 102;
public static final int WebKitErrorJavaUnavailable = 202;
public static final int WebMenuItemPDFActualSize = 24;
public static final int WebMenuItemPDFAutoSize = 27;
public static final int WebMenuItemPDFContinuous = 30;
public static final int WebMenuItemPDFFacingPages = 29;
public static final int WebMenuItemPDFNextPage = 31;
public static final int WebMenuItemPDFPreviousPage = 32;
public static final int WebMenuItemPDFSinglePage = 28;
public static final int WebMenuItemPDFZoomIn = 25;
public static final int WebMenuItemPDFZoomOut = 26;
public static final int WebMenuItemTagCopy = 8;
public static final int WebMenuItemTagCopyImageToClipboard = 6;
public static final int WebMenuItemTagCopyLinkToClipboard = 3;
public static final int WebMenuItemTagCut = 13;
public static final int WebMenuItemTagDownloadImageToDisk = 5;
public static final int WebMenuItemTagDownloadLinkToDisk = 2;
public static final int WebMenuItemTagGoBack = 9;
public static final int WebMenuItemTagGoForward = 10;
public static final int WebMenuItemTagIgnoreSpelling = 17;
public static final int WebMenuItemTagLearnSpelling = 18;
public static final int WebMenuItemTagLookUpInDictionary = 22;
public static final int WebMenuItemTagNoGuessesFound = 16;
public static final int WebMenuItemTagOpenFrameInNewWindow = 7;
public static final int WebMenuItemTagOpenImageInNewWindow = 4;
public static final int WebMenuItemTagOpenLinkInNewWindow = 1;
public static final int WebMenuItemTagOpenWithDefaultApplication = 23;
public static final int WebMenuItemTagOther = 19;
public static final int WebMenuItemTagPaste = 14;
public static final int WebMenuItemTagReload = 12;
public static final int WebMenuItemTagSearchInSpotlight = 20;
public static final int WebMenuItemTagSearchWeb = 21;
public static final int WebMenuItemTagSpellingGuess = 15;
public static final int WebMenuItemTagStop = 11;
public static final int WebNavigationTypeBackForward = 2;
public static final int WebNavigationTypeFormResubmitted = 4;
public static final int WebNavigationTypeFormSubmitted = 1;
public static final int WebNavigationTypeLinkClicked = 0;
public static final int WebNavigationTypeOther = 5;
public static final int WebNavigationTypeReload = 3;
public static final int WebViewInsertActionDropped = 2;
public static final int WebViewInsertActionPasted = 1;
public static final int WebViewInsertActionTyped = 0;


/** Globals */
//public static final native int NSAbortModalException();
//public static final native int NSAbortPrintingException();
//public static final native int NSAccessibilityAllowedValuesAttribute();
//public static final native int NSAccessibilityApplicationActivatedNotification();
//public static final native int NSAccessibilityApplicationDeactivatedNotification();
//public static final native int NSAccessibilityApplicationHiddenNotification();
//public static final native int NSAccessibilityApplicationRole();
//public static final native int NSAccessibilityApplicationShownNotification();
//public static final native int NSAccessibilityAscendingSortDirectionValue();
//public static final native int NSAccessibilityAttachmentTextAttribute();
//public static final native int NSAccessibilityAttributedStringForRangeParameterizedAttribute();
//public static final native int NSAccessibilityBackgroundColorTextAttribute();
//public static final native int NSAccessibilityBoundsForRangeParameterizedAttribute();
//public static final native int NSAccessibilityBrowserRole();
//public static final native int NSAccessibilityBusyIndicatorRole();
//public static final native int NSAccessibilityButtonRole();
//public static final native int NSAccessibilityCancelAction();
//public static final native int NSAccessibilityCancelButtonAttribute();
//public static final native int NSAccessibilityCenterTabStopMarkerTypeValue();
//public static final native int NSAccessibilityCentimetersUnitValue();
//public static final native int NSAccessibilityCheckBoxRole();
//public static final native int NSAccessibilityChildrenAttribute();
//public static final native int NSAccessibilityClearButtonAttribute();
//public static final native int NSAccessibilityCloseButtonAttribute();
//public static final native int NSAccessibilityCloseButtonSubrole();
//public static final native int NSAccessibilityColorWellRole();
//public static final native int NSAccessibilityColumnCountAttribute();
//public static final native int NSAccessibilityColumnRole();
//public static final native int NSAccessibilityColumnTitlesAttribute();
//public static final native int NSAccessibilityColumnsAttribute();
//public static final native int NSAccessibilityComboBoxRole();
//public static final native int NSAccessibilityConfirmAction();
//public static final native int NSAccessibilityContentsAttribute();
//public static final native int NSAccessibilityCreatedNotification();
//public static final native int NSAccessibilityDecimalTabStopMarkerTypeValue();
//public static final native int NSAccessibilityDecrementAction();
//public static final native int NSAccessibilityDecrementArrowSubrole();
//public static final native int NSAccessibilityDecrementButtonAttribute();
//public static final native int NSAccessibilityDecrementPageSubrole();
//public static final native int NSAccessibilityDefaultButtonAttribute();
//public static final native int NSAccessibilityDeleteAction();
//public static final native int NSAccessibilityDescendingSortDirectionValue();
//public static final native int NSAccessibilityDescriptionAttribute();
//public static final native int NSAccessibilityDialogSubrole();
//public static final native int NSAccessibilityDisclosedByRowAttribute();
//public static final native int NSAccessibilityDisclosedRowsAttribute();
//public static final native int NSAccessibilityDisclosingAttribute();
//public static final native int NSAccessibilityDisclosureLevelAttribute();
//public static final native int NSAccessibilityDisclosureTriangleRole();
//public static final native int NSAccessibilityDocumentAttribute();
//public static final native int NSAccessibilityDrawerCreatedNotification();
//public static final native int NSAccessibilityDrawerRole();
//public static final native int NSAccessibilityEditedAttribute();
//public static final native int NSAccessibilityEnabledAttribute();
//public static final native int NSAccessibilityErrorCodeExceptionInfo();
//public static final native int NSAccessibilityException();
//public static final native int NSAccessibilityExpandedAttribute();
//public static final native int NSAccessibilityFilenameAttribute();
//public static final native int NSAccessibilityFirstLineIndentMarkerTypeValue();
//public static final native int NSAccessibilityFloatingWindowSubrole();
//public static final native int NSAccessibilityFocusedAttribute();
//public static final native int NSAccessibilityFocusedUIElementAttribute();
//public static final native int NSAccessibilityFocusedUIElementChangedNotification();
//public static final native int NSAccessibilityFocusedWindowAttribute();
//public static final native int NSAccessibilityFocusedWindowChangedNotification();
//public static final native int NSAccessibilityFontFamilyKey();
//public static final native int NSAccessibilityFontNameKey();
//public static final native int NSAccessibilityFontSizeKey();
//public static final native int NSAccessibilityFontTextAttribute();
//public static final native int NSAccessibilityForegroundColorTextAttribute();
//public static final native int NSAccessibilityFrontmostAttribute();
//public static final native int NSAccessibilityGridRole();
//public static final native int NSAccessibilityGroupRole();
//public static final native int NSAccessibilityGrowAreaAttribute();
//public static final native int NSAccessibilityGrowAreaRole();
//public static final native int NSAccessibilityHeadIndentMarkerTypeValue();
//public static final native int NSAccessibilityHeaderAttribute();
//public static final native int NSAccessibilityHelpAttribute();
//public static final native int NSAccessibilityHelpTagCreatedNotification();
//public static final native int NSAccessibilityHelpTagRole();
//public static final native int NSAccessibilityHiddenAttribute();
//public static final native int NSAccessibilityHorizontalOrientationValue();
//public static final native int NSAccessibilityHorizontalScrollBarAttribute();
//public static final native int NSAccessibilityImageRole();
//public static final native int NSAccessibilityInchesUnitValue();
//public static final native int NSAccessibilityIncrementAction();
//public static final native int NSAccessibilityIncrementArrowSubrole();
//public static final native int NSAccessibilityIncrementButtonAttribute();
//public static final native int NSAccessibilityIncrementPageSubrole();
//public static final native int NSAccessibilityIncrementorRole();
//public static final native int NSAccessibilityIndexAttribute();
//public static final native int NSAccessibilityInsertionPointLineNumberAttribute();
//public static final native int NSAccessibilityLabelUIElementsAttribute();
//public static final native int NSAccessibilityLabelValueAttribute();
//public static final native int NSAccessibilityLeftTabStopMarkerTypeValue();
//public static final native int NSAccessibilityLineForIndexParameterizedAttribute();
//public static final native int NSAccessibilityLinkRole();
//public static final native int NSAccessibilityLinkTextAttribute();
//public static final native int NSAccessibilityLinkedUIElementsAttribute();
//public static final native int NSAccessibilityListRole();
//public static final native int NSAccessibilityMainAttribute();
//public static final native int NSAccessibilityMainWindowAttribute();
//public static final native int NSAccessibilityMainWindowChangedNotification();
//public static final native int NSAccessibilityMarkerGroupUIElementAttribute();
//public static final native int NSAccessibilityMarkerTypeAttribute();
//public static final native int NSAccessibilityMarkerTypeDescriptionAttribute();
//public static final native int NSAccessibilityMarkerUIElementsAttribute();
//public static final native int NSAccessibilityMarkerValuesAttribute();
//public static final native int NSAccessibilityMatteContentUIElementAttribute();
//public static final native int NSAccessibilityMatteHoleAttribute();
//public static final native int NSAccessibilityMatteRole();
//public static final native int NSAccessibilityMaxValueAttribute();
//public static final native int NSAccessibilityMenuBarAttribute();
//public static final native int NSAccessibilityMenuBarRole();
//public static final native int NSAccessibilityMenuButtonRole();
//public static final native int NSAccessibilityMenuItemRole();
//public static final native int NSAccessibilityMenuRole();
//public static final native int NSAccessibilityMinValueAttribute();
//public static final native int NSAccessibilityMinimizeButtonAttribute();
//public static final native int NSAccessibilityMinimizeButtonSubrole();
//public static final native int NSAccessibilityMinimizedAttribute();
//public static final native int NSAccessibilityMisspelledTextAttribute();
//public static final native int NSAccessibilityModalAttribute();
//public static final native int NSAccessibilityMovedNotification();
//public static final native int NSAccessibilityNextContentsAttribute();
//public static final native int NSAccessibilityNumberOfCharactersAttribute();
//public static final native int NSAccessibilityOrderedByRowAttribute();
//public static final native int NSAccessibilityOrientationAttribute();
//public static final native int NSAccessibilityOutlineRole();
//public static final native int NSAccessibilityOutlineRowSubrole();
//public static final native int NSAccessibilityOverflowButtonAttribute();
//public static final native int NSAccessibilityParentAttribute();
//public static final native int NSAccessibilityPicasUnitValue();
//public static final native int NSAccessibilityPickAction();
//public static final native int NSAccessibilityPointsUnitValue();
//public static final native int NSAccessibilityPopUpButtonRole();
public static final native int NSAccessibilityPositionAttribute();
//public static final native int NSAccessibilityPressAction();
//public static final native int NSAccessibilityPreviousContentsAttribute();
//public static final native int NSAccessibilityProgressIndicatorRole();
//public static final native int NSAccessibilityProxyAttribute();
//public static final native int NSAccessibilityRTFForRangeParameterizedAttribute();
//public static final native int NSAccessibilityRadioButtonRole();
//public static final native int NSAccessibilityRadioGroupRole();
//public static final native int NSAccessibilityRaiseAction();
//public static final native int NSAccessibilityRangeForIndexParameterizedAttribute();
//public static final native int NSAccessibilityRangeForLineParameterizedAttribute();
//public static final native int NSAccessibilityRangeForPositionParameterizedAttribute();
//public static final native int NSAccessibilityResizedNotification();
//public static final native int NSAccessibilityRightTabStopMarkerTypeValue();
//public static final native int NSAccessibilityRoleAttribute();
//public static final native int NSAccessibilityRoleDescriptionAttribute();
//public static final native int NSAccessibilityRowCountAttribute();
//public static final native int NSAccessibilityRowCountChangedNotification();
//public static final native int NSAccessibilityRowRole();
//public static final native int NSAccessibilityRowsAttribute();
//public static final native int NSAccessibilityRulerMarkerRole();
//public static final native int NSAccessibilityRulerRole();
//public static final native int NSAccessibilityScrollAreaRole();
//public static final native int NSAccessibilityScrollBarRole();
//public static final native int NSAccessibilitySearchButtonAttribute();
//public static final native int NSAccessibilitySearchFieldSubrole();
//public static final native int NSAccessibilitySearchMenuAttribute();
//public static final native int NSAccessibilitySecureTextFieldSubrole();
//public static final native int NSAccessibilitySelectedAttribute();
//public static final native int NSAccessibilitySelectedChildrenAttribute();
//public static final native int NSAccessibilitySelectedChildrenChangedNotification();
//public static final native int NSAccessibilitySelectedColumnsAttribute();
//public static final native int NSAccessibilitySelectedColumnsChangedNotification();
//public static final native int NSAccessibilitySelectedRowsAttribute();
//public static final native int NSAccessibilitySelectedRowsChangedNotification();
//public static final native int NSAccessibilitySelectedTextAttribute();
//public static final native int NSAccessibilitySelectedTextChangedNotification();
//public static final native int NSAccessibilitySelectedTextRangeAttribute();
//public static final native int NSAccessibilitySelectedTextRangesAttribute();
//public static final native int NSAccessibilityServesAsTitleForUIElementsAttribute();
//public static final native int NSAccessibilityShadowTextAttribute();
//public static final native int NSAccessibilitySharedCharacterRangeAttribute();
//public static final native int NSAccessibilitySharedTextUIElementsAttribute();
//public static final native int NSAccessibilitySheetCreatedNotification();
//public static final native int NSAccessibilitySheetRole();
//public static final native int NSAccessibilityShowMenuAction();
//public static final native int NSAccessibilityShownMenuAttribute();
public static final native int NSAccessibilitySizeAttribute();
//public static final native int NSAccessibilitySliderRole();
//public static final native int NSAccessibilitySortButtonRole();
//public static final native int NSAccessibilitySortDirectionAttribute();
//public static final native int NSAccessibilitySplitGroupRole();
//public static final native int NSAccessibilitySplitterRole();
//public static final native int NSAccessibilitySplittersAttribute();
//public static final native int NSAccessibilityStandardWindowSubrole();
//public static final native int NSAccessibilityStaticTextRole();
//public static final native int NSAccessibilityStrikethroughColorTextAttribute();
//public static final native int NSAccessibilityStrikethroughTextAttribute();
//public static final native int NSAccessibilityStringForRangeParameterizedAttribute();
//public static final native int NSAccessibilityStyleRangeForIndexParameterizedAttribute();
//public static final native int NSAccessibilitySubroleAttribute();
//public static final native int NSAccessibilitySuperscriptTextAttribute();
//public static final native int NSAccessibilitySystemDialogSubrole();
//public static final native int NSAccessibilitySystemFloatingWindowSubrole();
//public static final native int NSAccessibilitySystemWideRole();
//public static final native int NSAccessibilityTabGroupRole();
//public static final native int NSAccessibilityTableRole();
//public static final native int NSAccessibilityTableRowSubrole();
//public static final native int NSAccessibilityTabsAttribute();
//public static final native int NSAccessibilityTailIndentMarkerTypeValue();
//public static final native int NSAccessibilityTextAreaRole();
//public static final native int NSAccessibilityTextAttachmentSubrole();
//public static final native int NSAccessibilityTextFieldRole();
//public static final native int NSAccessibilityTextLinkSubrole();
//public static final native int NSAccessibilityTimelineSubrole();
//public static final native int NSAccessibilityTitleAttribute();
//public static final native int NSAccessibilityTitleChangedNotification();
//public static final native int NSAccessibilityTitleUIElementAttribute();
//public static final native int NSAccessibilityToolbarButtonAttribute();
//public static final native int NSAccessibilityToolbarButtonSubrole();
//public static final native int NSAccessibilityToolbarRole();
//public static final native int NSAccessibilityTopLevelUIElementAttribute();
//public static final native int NSAccessibilityUIElementDestroyedNotification();
//public static final native int NSAccessibilityURLAttribute();
//public static final native int NSAccessibilityUnderlineColorTextAttribute();
//public static final native int NSAccessibilityUnderlineTextAttribute();
//public static final native int NSAccessibilityUnitDescriptionAttribute();
//public static final native int NSAccessibilityUnitsAttribute();
//public static final native int NSAccessibilityUnknownMarkerTypeValue();
//public static final native int NSAccessibilityUnknownRole();
//public static final native int NSAccessibilityUnknownSortDirectionValue();
//public static final native int NSAccessibilityUnknownSubrole();
//public static final native int NSAccessibilityUnknownUnitValue();
//public static final native int NSAccessibilityValueAttribute();
//public static final native int NSAccessibilityValueChangedNotification();
//public static final native int NSAccessibilityValueDescriptionAttribute();
//public static final native int NSAccessibilityValueIndicatorRole();
//public static final native int NSAccessibilityVerticalOrientationValue();
//public static final native int NSAccessibilityVerticalScrollBarAttribute();
//public static final native int NSAccessibilityVisibleCharacterRangeAttribute();
//public static final native int NSAccessibilityVisibleChildrenAttribute();
//public static final native int NSAccessibilityVisibleColumnsAttribute();
//public static final native int NSAccessibilityVisibleNameKey();
//public static final native int NSAccessibilityVisibleRowsAttribute();
//public static final native int NSAccessibilityWindowAttribute();
//public static final native int NSAccessibilityWindowCreatedNotification();
//public static final native int NSAccessibilityWindowDeminiaturizedNotification();
//public static final native int NSAccessibilityWindowMiniaturizedNotification();
//public static final native int NSAccessibilityWindowMovedNotification();
//public static final native int NSAccessibilityWindowResizedNotification();
//public static final native int NSAccessibilityWindowRole();
//public static final native int NSAccessibilityWindowsAttribute();
//public static final native int NSAccessibilityZoomButtonAttribute();
//public static final native int NSAccessibilityZoomButtonSubrole();
//public static final native int NSAlignmentBinding();
//public static final native int NSAllRomanInputSourcesLocaleIdentifier();
//public static final native int NSAllowsEditingMultipleValuesSelectionBindingOption();
//public static final native int NSAllowsNullArgumentBindingOption();
//public static final native int NSAlternateImageBinding();
//public static final native int NSAlternateTitleBinding();
//public static final native int NSAlwaysPresentsApplicationModalAlertsBindingOption();
//public static final native int NSAnimateBinding();
//public static final native int NSAnimationDelayBinding();
//public static final native int NSAnimationProgressMark();
//public static final native int NSAnimationProgressMarkNotification();
//public static final native int NSAnimationTriggerOrderIn();
//public static final native int NSAnimationTriggerOrderOut();
//public static final native int NSAntialiasThresholdChangedNotification();
//public static final native int NSApp();
//public static final native int NSAppKitIgnoredException();
//public static final native int NSAppKitVersionNumber();
//public static final native int NSAppKitVirtualMemoryException();
//public static final native int NSApplicationDidBecomeActiveNotification();
//public static final native int NSApplicationDidChangeScreenParametersNotification();
//public static final native int NSApplicationDidFinishLaunchingNotification();
//public static final native int NSApplicationDidHideNotification();
//public static final native int NSApplicationDidResignActiveNotification();
//public static final native int NSApplicationDidUnhideNotification();
//public static final native int NSApplicationDidUpdateNotification();
//public static final native int NSApplicationFileType();
//public static final native int NSApplicationWillBecomeActiveNotification();
//public static final native int NSApplicationWillFinishLaunchingNotification();
//public static final native int NSApplicationWillHideNotification();
//public static final native int NSApplicationWillResignActiveNotification();
//public static final native int NSApplicationWillTerminateNotification();
//public static final native int NSApplicationWillUnhideNotification();
//public static final native int NSApplicationWillUpdateNotification();
//public static final native int NSArgumentBinding();
//public static final native int NSAttachmentAttributeName();
//public static final native int NSAttributedStringBinding();
//public static final native int NSAuthorDocumentAttribute();
public static final NSString NSBackgroundColorAttributeName = new NSString(OS.NSBackgroundColorAttributeName());
public static final native int NSBackgroundColorAttributeName();
//public static final native int NSBackgroundColorDocumentAttribute();
//public static final native int NSBadBitmapParametersException();
//public static final native int NSBadComparisonException();
//public static final native int NSBadRTFColorTableException();
//public static final native int NSBadRTFDirectiveException();
//public static final native int NSBadRTFFontTableException();
//public static final native int NSBadRTFStyleSheetException();
//public static final native int NSBaseURLDocumentOption();
public static final native int NSBaselineOffsetAttributeName();
//public static final native int NSBlack();
//public static final native int NSBottomMarginDocumentAttribute();
//public static final native int NSBrowserColumnConfigurationDidChangeNotification();
//public static final native int NSBrowserIllegalDelegateException();
//public static final native int NSCalibratedBlackColorSpace();
//public static final native int NSCalibratedRGBColorSpace();
//public static final native int NSCalibratedWhiteColorSpace();
//public static final native int NSCharacterEncodingDocumentAttribute();
//public static final native int NSCharacterEncodingDocumentOption();
//public static final native int NSCharacterShapeAttributeName();
//public static final native int NSCocoaVersionDocumentAttribute();
//public static final native int NSColorListDidChangeNotification();
//public static final native int NSColorListIOException();
//public static final native int NSColorListNotEditableException();
//public static final native int NSColorPanelColorDidChangeNotification();
//public static final native int NSColorPboardType();
//public static final native int NSComboBoxSelectionDidChangeNotification();
//public static final native int NSComboBoxSelectionIsChangingNotification();
//public static final native int NSComboBoxWillDismissNotification();
//public static final native int NSComboBoxWillPopUpNotification();
//public static final native int NSCommentDocumentAttribute();
//public static final native int NSCompanyDocumentAttribute();
//public static final native int NSConditionallySetsEditableBindingOption();
//public static final native int NSConditionallySetsEnabledBindingOption();
//public static final native int NSConditionallySetsHiddenBindingOption();
//public static final native int NSContentArrayBinding();
//public static final native int NSContentArrayForMultipleSelectionBinding();
//public static final native int NSContentBinding();
//public static final native int NSContentDictionaryBinding();
//public static final native int NSContentHeightBinding();
//public static final native int NSContentObjectBinding();
//public static final native int NSContentObjectsBinding();
//public static final native int NSContentPlacementTagBindingOption();
//public static final native int NSContentSetBinding();
//public static final native int NSContentValuesBinding();
//public static final native int NSContentWidthBinding();
//public static final native int NSContextHelpModeDidActivateNotification();
//public static final native int NSContextHelpModeDidDeactivateNotification();
//public static final native int NSContinuouslyUpdatesValueBindingOption();
//public static final native int NSControlTextDidBeginEditingNotification();
//public static final native int NSControlTextDidChangeNotification();
//public static final native int NSControlTextDidEndEditingNotification();
//public static final native int NSControlTintDidChangeNotification();
//public static final native int NSConvertedDocumentAttribute();
//public static final native int NSCopyrightDocumentAttribute();
//public static final native int NSCreatesSortDescriptorBindingOption();
//public static final native int NSCreationTimeDocumentAttribute();
//public static final native int NSCriticalValueBinding();
//public static final native int NSCursorAttributeName();
//public static final native int NSCustomColorSpace();
//public static final native int NSDarkGray();
//public static final native int NSDataBinding();
//public static final native int NSDefaultAttributesDocumentOption();
//public static final native int NSDefaultTabIntervalDocumentAttribute();
//public static final native int NSDeletesObjectsOnRemoveBindingsOption();
//public static final native int NSDeviceBitsPerSample();
//public static final native int NSDeviceBlackColorSpace();
//public static final native int NSDeviceCMYKColorSpace();
//public static final native int NSDeviceColorSpaceName();
//public static final native int NSDeviceIsPrinter();
//public static final native int NSDeviceIsScreen();
//public static final native int NSDeviceRGBColorSpace();
public static final native int NSDeviceResolution();
//public static final native int NSDeviceSize();
//public static final native int NSDeviceWhiteColorSpace();
//public static final native int NSDirectoryFileType();
//public static final native int NSDisplayNameBindingOption();
//public static final native int NSDisplayPatternBindingOption();
//public static final native int NSDisplayPatternTitleBinding();
//public static final native int NSDisplayPatternValueBinding();
//public static final native int NSDocFormatTextDocumentType();
//public static final native int NSDocumentEditedBinding();
//public static final native int NSDocumentTypeDocumentAttribute();
//public static final native int NSDocumentTypeDocumentOption();
//public static final native int NSDoubleClickArgumentBinding();
//public static final native int NSDoubleClickTargetBinding();
//public static final native int NSDragPboard();
//public static final native int NSDraggingException();
//public static final native int NSDrawerDidCloseNotification();
//public static final native int NSDrawerDidOpenNotification();
//public static final native int NSDrawerWillCloseNotification();
//public static final native int NSDrawerWillOpenNotification();
//public static final native int NSEditableBinding();
//public static final native int NSEditorDocumentAttribute();
//public static final native int NSEnabledBinding();
//public static final native int NSEventTrackingRunLoopMode();
//public static final native int NSExcludedElementsDocumentAttribute();
//public static final native int NSExcludedKeysBinding();
//public static final native int NSExpansionAttributeName();
//public static final native int NSFileContentsPboardType();
//public static final native int NSFilenamesPboardType();
//public static final native int NSFilesPromisePboardType();
//public static final native int NSFilesystemFileType();
//public static final native int NSFilterPredicateBinding();
//public static final native int NSFindPanelCaseInsensitiveSearch();
//public static final native int NSFindPanelSearchOptionsPboardType();
//public static final native int NSFindPanelSubstringMatch();
//public static final native int NSFindPboard();
public static final native int NSFontAttributeName();
//public static final native int NSFontBinding();
//public static final native int NSFontBoldBinding();
//public static final native int NSFontCascadeListAttribute();
//public static final native int NSFontCharacterSetAttribute();
//public static final native int NSFontFaceAttribute();
//public static final native int NSFontFamilyAttribute();
//public static final native int NSFontFamilyNameBinding();
//public static final native int NSFontFeatureSelectorIdentifierKey();
//public static final native int NSFontFeatureSettingsAttribute();
//public static final native int NSFontFeatureTypeIdentifierKey();
//public static final native int NSFontFixedAdvanceAttribute();
//public static final native int NSFontIdentityMatrix();
//public static final native int NSFontItalicBinding();
//public static final native int NSFontMatrixAttribute();
//public static final native int NSFontNameAttribute();
//public static final native int NSFontNameBinding();
//public static final native int NSFontPboard();
//public static final native int NSFontPboardType();
//public static final native int NSFontSetChangedNotification();
//public static final native int NSFontSizeAttribute();
//public static final native int NSFontSizeBinding();
//public static final native int NSFontSlantTrait();
//public static final native int NSFontSymbolicTrait();
//public static final native int NSFontTraitsAttribute();
//public static final native int NSFontUnavailableException();
//public static final native int NSFontVariationAttribute();
//public static final native int NSFontVariationAxisDefaultValueKey();
//public static final native int NSFontVariationAxisIdentifierKey();
//public static final native int NSFontVariationAxisMaximumValueKey();
//public static final native int NSFontVariationAxisMinimumValueKey();
//public static final native int NSFontVariationAxisNameKey();
//public static final native int NSFontVisibleNameAttribute();
//public static final native int NSFontWeightTrait();
//public static final native int NSFontWidthTrait();
public static final native int NSForegroundColorAttributeName();
//public static final native int NSFullScreenModeAllScreens();
//public static final native int NSFullScreenModeSetting();
//public static final native int NSFullScreenModeWindowLevel();
//public static final native int NSGeneralPboard();
//public static final native int NSGlyphInfoAttributeName();
//public static final native int NSGraphicsContextDestinationAttributeName();
//public static final native int NSGraphicsContextPDFFormat();
//public static final native int NSGraphicsContextPSFormat();
//public static final native int NSGraphicsContextRepresentationFormatAttributeName();
//public static final native int NSHTMLPboardType();
//public static final native int NSHTMLTextDocumentType();
//public static final native int NSHandlesContentAsCompoundValueBindingOption();
//public static final native int NSHeaderTitleBinding();
//public static final native int NSHiddenBinding();
//public static final native int NSHyphenationFactorDocumentAttribute();
//public static final native int NSIllegalSelectorException();
//public static final native int NSImageBinding();
//public static final native int NSImageCacheException();
//public static final native int NSImageColorSyncProfileData();
//public static final native int NSImageCompressionFactor();
//public static final native int NSImageCompressionMethod();
//public static final native int NSImageCurrentFrame();
//public static final native int NSImageCurrentFrameDuration();
//public static final native int NSImageDitherTransparency();
//public static final native int NSImageEXIFData();
//public static final native int NSImageFallbackBackgroundColor();
//public static final native int NSImageFrameCount();
//public static final native int NSImageGamma();
//public static final native int NSImageInterlaced();
//public static final native int NSImageLoopCount();
//public static final native int NSImageNameActionTemplate();
//public static final native int NSImageNameAddTemplate();
//public static final native int NSImageNameAdvanced();
//public static final native int NSImageNameBluetoothTemplate();
//public static final native int NSImageNameBonjour();
//public static final native int NSImageNameColorPanel();
//public static final native int NSImageNameColumnViewTemplate();
//public static final native int NSImageNameComputer();
//public static final native int NSImageNameDotMac();
//public static final native int NSImageNameEnterFullScreenTemplate();
//public static final native int NSImageNameEveryone();
//public static final native int NSImageNameExitFullScreenTemplate();
//public static final native int NSImageNameFlowViewTemplate();
//public static final native int NSImageNameFolderBurnable();
//public static final native int NSImageNameFolderSmart();
//public static final native int NSImageNameFollowLinkFreestandingTemplate();
//public static final native int NSImageNameFontPanel();
//public static final native int NSImageNameGoLeftTemplate();
//public static final native int NSImageNameGoRightTemplate();
//public static final native int NSImageNameIChatTheaterTemplate();
//public static final native int NSImageNameIconViewTemplate();
//public static final native int NSImageNameInfo();
//public static final native int NSImageNameInvalidDataFreestandingTemplate();
//public static final native int NSImageNameLeftFacingTriangleTemplate();
//public static final native int NSImageNameListViewTemplate();
//public static final native int NSImageNameLockLockedTemplate();
//public static final native int NSImageNameLockUnlockedTemplate();
//public static final native int NSImageNameMultipleDocuments();
//public static final native int NSImageNameNetwork();
//public static final native int NSImageNamePathTemplate();
//public static final native int NSImageNamePreferencesGeneral();
//public static final native int NSImageNameQuickLookTemplate();
//public static final native int NSImageNameRefreshFreestandingTemplate();
//public static final native int NSImageNameRefreshTemplate();
//public static final native int NSImageNameRemoveTemplate();
//public static final native int NSImageNameRevealFreestandingTemplate();
//public static final native int NSImageNameRightFacingTriangleTemplate();
//public static final native int NSImageNameSlideshowTemplate();
//public static final native int NSImageNameSmartBadgeTemplate();
//public static final native int NSImageNameStopProgressFreestandingTemplate();
//public static final native int NSImageNameStopProgressTemplate();
//public static final native int NSImageNameUser();
//public static final native int NSImageNameUserAccounts();
//public static final native int NSImageNameUserGroup();
//public static final native int NSImageProgressive();
//public static final native int NSImageRGBColorTable();
//public static final native int NSImageRepRegistryDidChangeNotification();
//public static final native int NSIncludedKeysBinding();
//public static final native int NSInitialKeyBinding();
//public static final native int NSInitialValueBinding();
//public static final native int NSInkTextPboardType();
//public static final native int NSInsertsNullPlaceholderBindingOption();
//public static final native int NSInterfaceStyleDefault();
//public static final native int NSInvokesSeparatelyWithArrayObjectsBindingOption();
//public static final native int NSIsIndeterminateBinding();
//public static final native int NSKernAttributeName();
//public static final native int NSKeywordsDocumentAttribute();
//public static final native int NSLabelBinding();
//public static final native int NSLeftMarginDocumentAttribute();
//public static final native int NSLigatureAttributeName();
//public static final native int NSLightGray();
public static final native int NSLinkAttributeName();
//public static final native int NSLocalizedKeyDictionaryBinding();
//public static final native int NSMacSimpleTextDocumentType();
//public static final native int NSManagedObjectContextBinding();
//public static final native int NSMarkedClauseSegmentAttributeName();
//public static final native int NSMaxValueBinding();
//public static final native int NSMaxWidthBinding();
//public static final native int NSMaximumRecentsBinding();
//public static final native int NSMenuDidAddItemNotification();
//public static final native int NSMenuDidBeginTrackingNotification();
//public static final native int NSMenuDidChangeItemNotification();
//public static final native int NSMenuDidEndTrackingNotification();
//public static final native int NSMenuDidRemoveItemNotification();
//public static final native int NSMenuDidSendActionNotification();
//public static final native int NSMenuWillSendActionNotification();
//public static final native int NSMinValueBinding();
//public static final native int NSMinWidthBinding();
//public static final native int NSMixedStateImageBinding();
//public static final native int NSModalPanelRunLoopMode();
//public static final native int NSModificationTimeDocumentAttribute();
//public static final native int NSMultipleTextSelectionPboardType();
//public static final native int NSMultipleValuesMarker();
//public static final native int NSMultipleValuesPlaceholderBindingOption();
//public static final native int NSNamedColorSpace();
//public static final native int NSNibLoadingException();
//public static final native int NSNibOwner();
//public static final native int NSNibTopLevelObjects();
//public static final native int NSNoSelectionMarker();
//public static final native int NSNoSelectionPlaceholderBindingOption();
//public static final native int NSNotApplicableMarker();
//public static final native int NSNotApplicablePlaceholderBindingOption();
//public static final native int NSNullPlaceholderBindingOption();
//public static final native int NSObliquenessAttributeName();
//public static final native int NSObservedKeyPathKey();
//public static final native int NSObservedObjectKey();
//public static final native int NSOffStateImageBinding();
//public static final native int NSOfficeOpenXMLTextDocumentType();
//public static final native int NSOnStateImageBinding();
//public static final native int NSOpenDocumentTextDocumentType();
//public static final native int NSOptionsKey();
//public static final native int NSOutlineViewColumnDidMoveNotification();
//public static final native int NSOutlineViewColumnDidResizeNotification();
//public static final native int NSOutlineViewItemDidCollapseNotification();
//public static final native int NSOutlineViewItemDidExpandNotification();
//public static final native int NSOutlineViewItemWillCollapseNotification();
//public static final native int NSOutlineViewItemWillExpandNotification();
//public static final native int NSOutlineViewSelectionDidChangeNotification();
//public static final native int NSOutlineViewSelectionIsChangingNotification();
//public static final native int NSPDFPboardType();
//public static final native int NSPICTPboardType();
//public static final native int NSPPDIncludeNotFoundException();
//public static final native int NSPPDIncludeStackOverflowException();
//public static final native int NSPPDIncludeStackUnderflowException();
//public static final native int NSPPDParseException();
//public static final native int NSPaperSizeDocumentAttribute();
public static final native int NSParagraphStyleAttributeName();
//public static final native int NSPasteboardCommunicationException();
//public static final native int NSPatternColorSpace();
//public static final native int NSPlainFileType();
//public static final native int NSPlainTextDocumentType();
//public static final native int NSPopUpButtonCellWillPopUpNotification();
//public static final native int NSPopUpButtonWillPopUpNotification();
//public static final native int NSPostScriptPboardType();
//public static final native int NSPredicateBinding();
//public static final native int NSPredicateFormatBindingOption();
//public static final native int NSPrefixSpacesDocumentAttribute();
//public static final native int NSPrintAllPages();
//public static final native int NSPrintBottomMargin();
//public static final native int NSPrintCancelJob();
//public static final native int NSPrintCopies();
//public static final native int NSPrintDetailedErrorReporting();
//public static final native int NSPrintFaxCoverSheetName();
//public static final native int NSPrintFaxHighResolution();
//public static final native int NSPrintFaxJob();
//public static final native int NSPrintFaxModem();
//public static final native int NSPrintFaxNumber();
//public static final native int NSPrintFaxReceiverNames();
//public static final native int NSPrintFaxReceiverNumbers();
//public static final native int NSPrintFaxReturnReceipt();
//public static final native int NSPrintFaxSendTime();
//public static final native int NSPrintFaxTrimPageEnds();
//public static final native int NSPrintFaxUseCoverSheet();
//public static final native int NSPrintFirstPage();
//public static final native int NSPrintFormName();
//public static final native int NSPrintHeaderAndFooter();
//public static final native int NSPrintHorizontalPagination();
//public static final native int NSPrintHorizontallyCentered();
//public static final native int NSPrintJobDisposition();
//public static final native int NSPrintJobFeatures();
//public static final native int NSPrintLastPage();
//public static final native int NSPrintLeftMargin();
//public static final native int NSPrintManualFeed();
//public static final native int NSPrintMustCollate();
//public static final native int NSPrintOperationExistsException();
//public static final native int NSPrintOrientation();
//public static final native int NSPrintPackageException();
//public static final native int NSPrintPagesAcross();
//public static final native int NSPrintPagesDown();
//public static final native int NSPrintPagesPerSheet();
//public static final native int NSPrintPanelAccessorySummaryItemDescriptionKey();
//public static final native int NSPrintPanelAccessorySummaryItemNameKey();
//public static final native int NSPrintPaperFeed();
//public static final native int NSPrintPaperName();
//public static final native int NSPrintPaperSize();
//public static final native int NSPrintPhotoJobStyleHint();
//public static final native int NSPrintPreviewJob();
//public static final native int NSPrintPrinter();
//public static final native int NSPrintPrinterName();
//public static final native int NSPrintReversePageOrder();
//public static final native int NSPrintRightMargin();
//public static final native int NSPrintSaveJob();
//public static final native int NSPrintSavePath();
//public static final native int NSPrintScalingFactor();
//public static final native int NSPrintSpoolJob();
//public static final native int NSPrintTime();
//public static final native int NSPrintTopMargin();
//public static final native int NSPrintVerticalPagination();
//public static final native int NSPrintVerticallyCentered();
//public static final native int NSPrintingCommunicationException();
//public static final native int NSRTFDPboardType();
//public static final native int NSRTFDTextDocumentType();
//public static final native int NSRTFPboardType();
//public static final native int NSRTFPropertyStackOverflowException();
//public static final native int NSRTFTextDocumentType();
//public static final native int NSRaisesForNotApplicableKeysBindingOption();
//public static final native int NSReadOnlyDocumentAttribute();
//public static final native int NSRecentSearchesBinding();
//public static final native int NSRepresentedFilenameBinding();
//public static final native int NSRightMarginDocumentAttribute();
//public static final native int NSRowHeightBinding();
//public static final native int NSRuleEditorPredicateComparisonModifier();
//public static final native int NSRuleEditorPredicateCompoundType();
//public static final native int NSRuleEditorPredicateCustomSelector();
//public static final native int NSRuleEditorPredicateLeftExpression();
//public static final native int NSRuleEditorPredicateOperatorType();
//public static final native int NSRuleEditorPredicateOptions();
//public static final native int NSRuleEditorPredicateRightExpression();
//public static final native int NSRuleEditorRowsDidChangeNotification();
//public static final native int NSRulerPboard();
//public static final native int NSRulerPboardType();
//public static final native int NSSelectedIdentifierBinding();
//public static final native int NSSelectedIndexBinding();
//public static final native int NSSelectedLabelBinding();
//public static final native int NSSelectedObjectBinding();
//public static final native int NSSelectedObjectsBinding();
//public static final native int NSSelectedTagBinding();
//public static final native int NSSelectedValueBinding();
//public static final native int NSSelectedValuesBinding();
//public static final native int NSSelectionIndexPathsBinding();
//public static final native int NSSelectionIndexesBinding();
//public static final native int NSSelectorNameBindingOption();
//public static final native int NSSelectsAllWhenSettingContentBindingOption();
//public static final native int NSShadowAttributeName();
//public static final native int NSShellCommandFileType();
//public static final native int NSSortDescriptorsBinding();
//public static final native int NSSoundPboardType();
//public static final native int NSSpeechCharacterModeProperty();
//public static final native int NSSpeechCommandDelimiterProperty();
//public static final native int NSSpeechCommandPrefix();
//public static final native int NSSpeechCommandSuffix();
//public static final native int NSSpeechCurrentVoiceProperty();
//public static final native int NSSpeechDictionaryAbbreviations();
//public static final native int NSSpeechDictionaryEntryPhonemes();
//public static final native int NSSpeechDictionaryEntrySpelling();
//public static final native int NSSpeechDictionaryLocaleIdentifier();
//public static final native int NSSpeechDictionaryModificationDate();
//public static final native int NSSpeechDictionaryPronunciations();
//public static final native int NSSpeechErrorCount();
//public static final native int NSSpeechErrorNewestCharacterOffset();
//public static final native int NSSpeechErrorNewestCode();
//public static final native int NSSpeechErrorOldestCharacterOffset();
//public static final native int NSSpeechErrorOldestCode();
//public static final native int NSSpeechErrorsProperty();
//public static final native int NSSpeechInputModeProperty();
//public static final native int NSSpeechModeLiteral();
//public static final native int NSSpeechModeNormal();
//public static final native int NSSpeechModePhoneme();
//public static final native int NSSpeechModeText();
//public static final native int NSSpeechNumberModeProperty();
//public static final native int NSSpeechOutputToFileURLProperty();
//public static final native int NSSpeechPhonemeInfoExample();
//public static final native int NSSpeechPhonemeInfoHiliteEnd();
//public static final native int NSSpeechPhonemeInfoHiliteStart();
//public static final native int NSSpeechPhonemeInfoOpcode();
//public static final native int NSSpeechPhonemeInfoSymbol();
//public static final native int NSSpeechPhonemeSymbolsProperty();
//public static final native int NSSpeechPitchBaseProperty();
//public static final native int NSSpeechPitchModProperty();
//public static final native int NSSpeechRateProperty();
//public static final native int NSSpeechRecentSyncProperty();
//public static final native int NSSpeechResetProperty();
//public static final native int NSSpeechStatusNumberOfCharactersLeft();
//public static final native int NSSpeechStatusOutputBusy();
//public static final native int NSSpeechStatusOutputPaused();
//public static final native int NSSpeechStatusPhonemeCode();
//public static final native int NSSpeechStatusProperty();
//public static final native int NSSpeechSynthesizerInfoIdentifier();
//public static final native int NSSpeechSynthesizerInfoProperty();
//public static final native int NSSpeechSynthesizerInfoVersion();
//public static final native int NSSpeechVolumeProperty();
//public static final native int NSSpellingStateAttributeName();
//public static final native int NSSplitViewDidResizeSubviewsNotification();
//public static final native int NSSplitViewWillResizeSubviewsNotification();
public static final native int NSStrikethroughColorAttributeName();
public static final native int NSStrikethroughStyleAttributeName();
//public static final native int NSStringPboardType();
//public static final native int NSStrokeColorAttributeName();
//public static final native int NSStrokeWidthAttributeName();
//public static final native int NSSubjectDocumentAttribute();
//public static final native int NSSuperscriptAttributeName();
//public static final native int NSSystemColorsDidChangeNotification();
//public static final native int NSTIFFException();
//public static final native int NSTIFFPboardType();
//public static final native int NSTabColumnTerminatorsAttributeName();
//public static final native int NSTableViewColumnDidMoveNotification();
//public static final native int NSTableViewColumnDidResizeNotification();
//public static final native int NSTableViewSelectionDidChangeNotification();
//public static final native int NSTableViewSelectionIsChangingNotification();
//public static final native int NSTabularTextPboardType();
//public static final native int NSTargetBinding();
//public static final native int NSTextColorBinding();
//public static final native int NSTextDidBeginEditingNotification();
//public static final native int NSTextDidChangeNotification();
//public static final native int NSTextDidEndEditingNotification();
//public static final native int NSTextEncodingNameDocumentAttribute();
//public static final native int NSTextEncodingNameDocumentOption();
//public static final native int NSTextLineTooLongException();
//public static final native int NSTextNoSelectionException();
//public static final native int NSTextReadException();
//public static final native int NSTextSizeMultiplierDocumentOption();
//public static final native int NSTextStorageDidProcessEditingNotification();
//public static final native int NSTextStorageWillProcessEditingNotification();
//public static final native int NSTextViewDidChangeSelectionNotification();
//public static final native int NSTextViewDidChangeTypingAttributesNotification();
//public static final native int NSTextViewWillChangeNotifyingTextViewNotification();
//public static final native int NSTextWriteException();
//public static final native int NSTimeoutDocumentOption();
//public static final native int NSTitleBinding();
//public static final native int NSTitleDocumentAttribute();
//public static final native int NSToolTipAttributeName();
//public static final native int NSToolTipBinding();
//public static final native int NSToolbarCustomizeToolbarItemIdentifier();
//public static final native int NSToolbarDidRemoveItemNotification();
//public static final native int NSToolbarFlexibleSpaceItemIdentifier();
//public static final native int NSToolbarPrintItemIdentifier();
//public static final native int NSToolbarSeparatorItemIdentifier();
//public static final native int NSToolbarShowColorsItemIdentifier();
//public static final native int NSToolbarShowFontsItemIdentifier();
//public static final native int NSToolbarSpaceItemIdentifier();
//public static final native int NSToolbarWillAddItemNotification();
//public static final native int NSTopMarginDocumentAttribute();
//public static final native int NSTransparentBinding();
//public static final native int NSTypedStreamVersionException();
//public static final native int NSURLPboardType();
//public static final native int NSUnderlineByWordMask();
public static final native int NSUnderlineColorAttributeName();
//public static final native int NSUnderlineStrikethroughMask();
public static final native int NSUnderlineStyleAttributeName();
//public static final native int NSVCardPboardType();
//public static final native int NSValidatesImmediatelyBindingOption();
//public static final native int NSValueBinding();
//public static final native int NSValuePathBinding();
//public static final native int NSValueTransformerBindingOption();
//public static final native int NSValueTransformerNameBindingOption();
//public static final native int NSValueURLBinding();
//public static final native int NSViewAnimationEffectKey();
//public static final native int NSViewAnimationEndFrameKey();
//public static final native int NSViewAnimationFadeInEffect();
//public static final native int NSViewAnimationFadeOutEffect();
//public static final native int NSViewAnimationStartFrameKey();
//public static final native int NSViewAnimationTargetKey();
//public static final native int NSViewBoundsDidChangeNotification();
//public static final native int NSViewDidUpdateTrackingAreasNotification();
//public static final native int NSViewFocusDidChangeNotification();
//public static final native int NSViewFrameDidChangeNotification();
//public static final native int NSViewGlobalFrameDidChangeNotification();
//public static final native int NSViewModeDocumentAttribute();
//public static final native int NSViewSizeDocumentAttribute();
//public static final native int NSViewZoomDocumentAttribute();
//public static final native int NSVisibleBinding();
//public static final native int NSVoiceAge();
//public static final native int NSVoiceDemoText();
//public static final native int NSVoiceGender();
//public static final native int NSVoiceGenderFemale();
//public static final native int NSVoiceGenderMale();
//public static final native int NSVoiceGenderNeuter();
//public static final native int NSVoiceIdentifier();
//public static final native int NSVoiceIndividuallySpokenCharacters();
//public static final native int NSVoiceLocaleIdentifier();
//public static final native int NSVoiceName();
//public static final native int NSVoiceSupportedCharacters();
//public static final native int NSWarningValueBinding();
//public static final native int NSWebArchiveTextDocumentType();
//public static final native int NSWebPreferencesDocumentOption();
//public static final native int NSWebResourceLoadDelegateDocumentOption();
//public static final native int NSWhite();
//public static final native int NSWidthBinding();
//public static final native int NSWindowDidBecomeKeyNotification();
//public static final native int NSWindowDidBecomeMainNotification();
//public static final native int NSWindowDidChangeScreenNotification();
//public static final native int NSWindowDidChangeScreenProfileNotification();
//public static final native int NSWindowDidDeminiaturizeNotification();
//public static final native int NSWindowDidEndSheetNotification();
//public static final native int NSWindowDidExposeNotification();
//public static final native int NSWindowDidMiniaturizeNotification();
//public static final native int NSWindowDidMoveNotification();
//public static final native int NSWindowDidResignKeyNotification();
//public static final native int NSWindowDidResignMainNotification();
//public static final native int NSWindowDidResizeNotification();
//public static final native int NSWindowDidUpdateNotification();
//public static final native int NSWindowServerCommunicationException();
//public static final native int NSWindowWillBeginSheetNotification();
//public static final native int NSWindowWillCloseNotification();
//public static final native int NSWindowWillMiniaturizeNotification();
//public static final native int NSWindowWillMoveNotification();
//public static final native int NSWordMLTextDocumentType();
//public static final native int NSWordTablesReadException();
//public static final native int NSWordTablesWriteException();
//public static final native int NSWorkspaceCompressOperation();
//public static final native int NSWorkspaceCopyOperation();
//public static final native int NSWorkspaceDecompressOperation();
//public static final native int NSWorkspaceDecryptOperation();
//public static final native int NSWorkspaceDestroyOperation();
//public static final native int NSWorkspaceDidLaunchApplicationNotification();
//public static final native int NSWorkspaceDidMountNotification();
//public static final native int NSWorkspaceDidPerformFileOperationNotification();
//public static final native int NSWorkspaceDidTerminateApplicationNotification();
//public static final native int NSWorkspaceDidUnmountNotification();
//public static final native int NSWorkspaceDidWakeNotification();
//public static final native int NSWorkspaceDuplicateOperation();
//public static final native int NSWorkspaceEncryptOperation();
//public static final native int NSWorkspaceLinkOperation();
//public static final native int NSWorkspaceMoveOperation();
//public static final native int NSWorkspaceRecycleOperation();
//public static final native int NSWorkspaceSessionDidBecomeActiveNotification();
//public static final native int NSWorkspaceSessionDidResignActiveNotification();
//public static final native int NSWorkspaceWillLaunchApplicationNotification();
//public static final native int NSWorkspaceWillPowerOffNotification();
//public static final native int NSWorkspaceWillSleepNotification();
//public static final native int NSWorkspaceWillUnmountNotification();
//public static final native int NSAppleEventManagerWillProcessFirstEventNotification();
//public static final native int NSAppleEventTimeOutDefault();
//public static final native int NSAppleEventTimeOutNone();
//public static final native int NSAppleScriptErrorAppName();
//public static final native int NSAppleScriptErrorBriefMessage();
//public static final native int NSAppleScriptErrorMessage();
//public static final native int NSAppleScriptErrorNumber();
//public static final native int NSAppleScriptErrorRange();
//public static final native int NSArgumentDomain();
//public static final native int NSAverageKeyValueOperator();
//public static final native int NSBuddhistCalendar();
//public static final native int NSBundleDidLoadNotification();
//public static final native int NSCharacterConversionException();
//public static final native int NSChineseCalendar();
//public static final native int NSClassDescriptionNeededForClassNotification();
//public static final native int NSCocoaErrorDomain();
//public static final native int NSConnectionDidDieNotification();
//public static final native int NSConnectionDidInitializeNotification();
//public static final native int NSConnectionReplyMode();
//public static final native int NSCountKeyValueOperator();
//public static final native int NSCurrentLocaleDidChangeNotification();
//public static final native int NSDeallocateZombies();
//public static final native int NSDebugEnabled();
//public static final native int NSDecimalNumberDivideByZeroException();
//public static final native int NSDecimalNumberExactnessException();
//public static final native int NSDecimalNumberOverflowException();
//public static final native int NSDecimalNumberUnderflowException();
public static final NSString NSDefaultRunLoopMode = new NSString(OS.NSDefaultRunLoopMode());
public static final native int NSDefaultRunLoopMode();
//public static final native int NSDestinationInvalidException();
//public static final native int NSDidBecomeSingleThreadedNotification();
//public static final native int NSDistinctUnionOfArraysKeyValueOperator();
//public static final native int NSDistinctUnionOfObjectsKeyValueOperator();
//public static final native int NSDistinctUnionOfSetsKeyValueOperator();
//public static final native int NSErrorFailingURLStringKey();
//public static final native int NSFailedAuthenticationException();
//public static final native int NSFileAppendOnly();
//public static final native int NSFileBusy();
//public static final native int NSFileCreationDate();
//public static final native int NSFileDeviceIdentifier();
//public static final native int NSFileExtensionHidden();
//public static final native int NSFileGroupOwnerAccountID();
//public static final native int NSFileGroupOwnerAccountName();
//public static final native int NSFileHFSCreatorCode();
//public static final native int NSFileHFSTypeCode();
//public static final native int NSFileHandleConnectionAcceptedNotification();
//public static final native int NSFileHandleDataAvailableNotification();
//public static final native int NSFileHandleNotificationDataItem();
//public static final native int NSFileHandleNotificationFileHandleItem();
//public static final native int NSFileHandleNotificationMonitorModes();
//public static final native int NSFileHandleOperationException();
//public static final native int NSFileHandleReadCompletionNotification();
//public static final native int NSFileHandleReadToEndOfFileCompletionNotification();
//public static final native int NSFileImmutable();
//public static final native int NSFileModificationDate();
//public static final native int NSFileOwnerAccountID();
//public static final native int NSFileOwnerAccountName();
//public static final native int NSFilePathErrorKey();
//public static final native int NSFilePosixPermissions();
//public static final native int NSFileReferenceCount();
//public static final native int NSFileSize();
//public static final native int NSFileSystemFileNumber();
//public static final native int NSFileSystemFreeNodes();
//public static final native int NSFileSystemFreeSize();
//public static final native int NSFileSystemNodes();
//public static final native int NSFileSystemNumber();
//public static final native int NSFileSystemSize();
//public static final native int NSFileType();
//public static final native int NSFileTypeBlockSpecial();
//public static final native int NSFileTypeCharacterSpecial();
//public static final native int NSFileTypeDirectory();
//public static final native int NSFileTypeRegular();
//public static final native int NSFileTypeSocket();
//public static final native int NSFileTypeSymbolicLink();
//public static final native int NSFileTypeUnknown();
//public static final native int NSFoundationVersionNumber();
//public static final native int NSGenericException();
//public static final native int NSGlobalDomain();
//public static final native int NSGrammarCorrections();
//public static final native int NSGrammarRange();
//public static final native int NSGrammarUserDescription();
//public static final native int NSGregorianCalendar();
//public static final native int NSHTTPCookieComment();
//public static final native int NSHTTPCookieCommentURL();
//public static final native int NSHTTPCookieDiscard();
//public static final native int NSHTTPCookieDomain();
//public static final native int NSHTTPCookieExpires();
//public static final native int NSHTTPCookieManagerAcceptPolicyChangedNotification();
//public static final native int NSHTTPCookieManagerCookiesChangedNotification();
//public static final native int NSHTTPCookieMaximumAge();
//public static final native int NSHTTPCookieName();
//public static final native int NSHTTPCookieOriginURL();
//public static final native int NSHTTPCookiePath();
//public static final native int NSHTTPCookiePort();
//public static final native int NSHTTPCookieSecure();
//public static final native int NSHTTPCookieValue();
//public static final native int NSHTTPCookieVersion();
//public static final native int NSHangOnUncaughtException();
//public static final native int NSHebrewCalendar();
//public static final native int NSInconsistentArchiveException();
//public static final native int NSIntegerHashCallBacks();
//public static final native int NSIntegerMapKeyCallBacks();
//public static final native int NSIntegerMapValueCallBacks();
//public static final native int NSInternalInconsistencyException();
//public static final native int NSInvalidArchiveOperationException();
//public static final native int NSInvalidArgumentException();
//public static final native int NSInvalidReceivePortException();
//public static final native int NSInvalidSendPortException();
//public static final native int NSInvalidUnarchiveOperationException();
//public static final native int NSInvocationOperationCancelledException();
//public static final native int NSInvocationOperationVoidResultException();
//public static final native int NSIsNilTransformerName();
//public static final native int NSIsNotNilTransformerName();
//public static final native int NSIslamicCalendar();
//public static final native int NSIslamicCivilCalendar();
//public static final native int NSJapaneseCalendar();
//public static final native int NSKeepAllocationStatistics();
//public static final native int NSKeyValueChangeIndexesKey();
//public static final native int NSKeyValueChangeKindKey();
//public static final native int NSKeyValueChangeNewKey();
//public static final native int NSKeyValueChangeNotificationIsPriorKey();
//public static final native int NSKeyValueChangeOldKey();
//public static final native int NSKeyedUnarchiveFromDataTransformerName();
//public static final native int NSLoadedClasses();
//public static final native int NSLocalNotificationCenterType();
//public static final native int NSLocaleCalendar();
//public static final native int NSLocaleCollationIdentifier();
//public static final native int NSLocaleCountryCode();
//public static final native int NSLocaleCurrencyCode();
//public static final native int NSLocaleCurrencySymbol();
//public static final native int NSLocaleDecimalSeparator();
//public static final native int NSLocaleExemplarCharacterSet();
//public static final native int NSLocaleGroupingSeparator();
//public static final native int NSLocaleIdentifier();
//public static final native int NSLocaleLanguageCode();
//public static final native int NSLocaleMeasurementSystem();
//public static final native int NSLocaleScriptCode();
//public static final native int NSLocaleUsesMetricSystem();
//public static final native int NSLocaleVariantCode();
//public static final native int NSLocalizedDescriptionKey();
//public static final native int NSLocalizedFailureReasonErrorKey();
//public static final native int NSLocalizedRecoveryOptionsErrorKey();
//public static final native int NSLocalizedRecoverySuggestionErrorKey();
//public static final native int NSMachErrorDomain();
//public static final native int NSMallocException();
//public static final native int NSMaximumKeyValueOperator();
//public static final native int NSMetadataQueryDidFinishGatheringNotification();
//public static final native int NSMetadataQueryDidStartGatheringNotification();
//public static final native int NSMetadataQueryDidUpdateNotification();
//public static final native int NSMetadataQueryGatheringProgressNotification();
//public static final native int NSMetadataQueryLocalComputerScope();
//public static final native int NSMetadataQueryNetworkScope();
//public static final native int NSMetadataQueryResultContentRelevanceAttribute();
//public static final native int NSMetadataQueryUserHomeScope();
//public static final native int NSMinimumKeyValueOperator();
//public static final native int NSNegateBooleanTransformerName();
//public static final native int NSNetServicesErrorCode();
//public static final native int NSNetServicesErrorDomain();
//public static final native int NSNonOwnedPointerHashCallBacks();
//public static final native int NSNonOwnedPointerMapKeyCallBacks();
//public static final native int NSNonOwnedPointerMapValueCallBacks();
//public static final native int NSNonOwnedPointerOrNullMapKeyCallBacks();
//public static final native int NSNonRetainedObjectHashCallBacks();
//public static final native int NSNonRetainedObjectMapKeyCallBacks();
//public static final native int NSNonRetainedObjectMapValueCallBacks();
//public static final native int NSOSStatusErrorDomain();
//public static final native int NSObjectHashCallBacks();
//public static final native int NSObjectInaccessibleException();
//public static final native int NSObjectMapKeyCallBacks();
//public static final native int NSObjectMapValueCallBacks();
//public static final native int NSObjectNotAvailableException();
//public static final native int NSOldStyleException();
//public static final native int NSOperationNotSupportedForKeyException();
//public static final native int NSOwnedObjectIdentityHashCallBacks();
//public static final native int NSOwnedPointerHashCallBacks();
//public static final native int NSOwnedPointerMapKeyCallBacks();
//public static final native int NSOwnedPointerMapValueCallBacks();
//public static final native int NSPOSIXErrorDomain();
//public static final native int NSParseErrorException();
//public static final native int NSPointerToStructHashCallBacks();
//public static final native int NSPortDidBecomeInvalidNotification();
//public static final native int NSPortReceiveException();
//public static final native int NSPortSendException();
//public static final native int NSPortTimeoutException();
//public static final native int NSRangeException();
//public static final native int NSRecoveryAttempterErrorKey();
//public static final native int NSRegistrationDomain();
//public static final native int NSRunLoopCommonModes();
//public static final native int NSStreamDataWrittenToMemoryStreamKey();
//public static final native int NSStreamFileCurrentOffsetKey();
//public static final native int NSStreamSOCKSErrorDomain();
//public static final native int NSStreamSOCKSProxyConfigurationKey();
//public static final native int NSStreamSOCKSProxyHostKey();
//public static final native int NSStreamSOCKSProxyPasswordKey();
//public static final native int NSStreamSOCKSProxyPortKey();
//public static final native int NSStreamSOCKSProxyUserKey();
//public static final native int NSStreamSOCKSProxyVersion4();
//public static final native int NSStreamSOCKSProxyVersion5();
//public static final native int NSStreamSOCKSProxyVersionKey();
//public static final native int NSStreamSocketSSLErrorDomain();
//public static final native int NSStreamSocketSecurityLevelKey();
//public static final native int NSStreamSocketSecurityLevelNegotiatedSSL();
//public static final native int NSStreamSocketSecurityLevelNone();
//public static final native int NSStreamSocketSecurityLevelSSLv2();
//public static final native int NSStreamSocketSecurityLevelSSLv3();
//public static final native int NSStreamSocketSecurityLevelTLSv1();
//public static final native int NSStringEncodingErrorKey();
//public static final native int NSSumKeyValueOperator();
//public static final native int NSSystemTimeZoneDidChangeNotification();
//public static final native int NSTaskDidTerminateNotification();
//public static final native int NSThreadWillExitNotification();
//public static final native int NSURLAuthenticationMethodDefault();
//public static final native int NSURLAuthenticationMethodHTMLForm();
//public static final native int NSURLAuthenticationMethodHTTPBasic();
//public static final native int NSURLAuthenticationMethodHTTPDigest();
//public static final native int NSURLCredentialStorageChangedNotification();
//public static final native int NSURLErrorDomain();
//public static final native int NSURLErrorKey();
//public static final native int NSURLFileScheme();
//public static final native int NSURLProtectionSpaceFTPProxy();
//public static final native int NSURLProtectionSpaceHTTPProxy();
//public static final native int NSURLProtectionSpaceHTTPSProxy();
//public static final native int NSURLProtectionSpaceSOCKSProxy();
//public static final native int NSUnarchiveFromDataTransformerName();
//public static final native int NSUndefinedKeyException();
//public static final native int NSUnderlyingErrorKey();
//public static final native int NSUndoManagerCheckpointNotification();
//public static final native int NSUndoManagerDidOpenUndoGroupNotification();
//public static final native int NSUndoManagerDidRedoChangeNotification();
//public static final native int NSUndoManagerDidUndoChangeNotification();
//public static final native int NSUndoManagerWillCloseUndoGroupNotification();
//public static final native int NSUndoManagerWillRedoChangeNotification();
//public static final native int NSUndoManagerWillUndoChangeNotification();
//public static final native int NSUnionOfArraysKeyValueOperator();
//public static final native int NSUnionOfObjectsKeyValueOperator();
//public static final native int NSUnionOfSetsKeyValueOperator();
//public static final native int NSUserDefaultsDidChangeNotification();
//public static final native int NSWillBecomeMultiThreadedNotification();
//public static final native int NSXMLParserErrorDomain();
//public static final native int NSZeroPoint();
//public static final native int NSZeroRect();
//public static final native int NSZeroSize();
//public static final native int NSZombieEnabled();
//public static final native int DOMEventException();
//public static final native int DOMException();
//public static final native int DOMRangeException();
//public static final native int DOMXPathException();
//public static final native int WebActionButtonKey();
//public static final native int WebActionElementKey();
//public static final native int WebActionModifierFlagsKey();
//public static final native int WebActionNavigationTypeKey();
//public static final native int WebActionOriginalURLKey();
//public static final native int WebArchivePboardType();
//public static final native int WebElementDOMNodeKey();
//public static final native int WebElementFrameKey();
//public static final native int WebElementImageAltStringKey();
//public static final native int WebElementImageKey();
//public static final native int WebElementImageRectKey();
//public static final native int WebElementImageURLKey();
//public static final native int WebElementIsSelectedKey();
//public static final native int WebElementLinkLabelKey();
//public static final native int WebElementLinkTargetFrameKey();
//public static final native int WebElementLinkTitleKey();
//public static final native int WebElementLinkURLKey();
//public static final native int WebHistoryAllItemsRemovedNotification();
//public static final native int WebHistoryItemChangedNotification();
//public static final native int WebHistoryItemsAddedNotification();
//public static final native int WebHistoryItemsKey();
//public static final native int WebHistoryItemsRemovedNotification();
//public static final native int WebHistoryLoadedNotification();
//public static final native int WebHistorySavedNotification();
//public static final native int WebKitErrorDomain();
//public static final native int WebKitErrorMIMETypeKey();
//public static final native int WebKitErrorPlugInNameKey();
//public static final native int WebKitErrorPlugInPageURLStringKey();
//public static final native int WebPlugInAttributesKey();
//public static final native int WebPlugInBaseURLKey();
//public static final native int WebPlugInContainerKey();
//public static final native int WebPlugInContainingElementKey();
//public static final native int WebPreferencesChangedNotification();
//public static final native int WebViewDidBeginEditingNotification();
//public static final native int WebViewDidChangeNotification();
//public static final native int WebViewDidChangeSelectionNotification();
//public static final native int WebViewDidChangeTypingStyleNotification();
//public static final native int WebViewDidEndEditingNotification();
//public static final native int WebViewProgressEstimateChangedNotification();
//public static final native int WebViewProgressFinishedNotification();
//public static final native int WebViewProgressStartedNotification();

/** Functions */
//public static final native int NSAccessibilityActionDescription(int action);
//public static final native void NSAccessibilityPostNotification(int element, int notification);
//public static final native void NSAccessibilityRaiseBadArgumentException(int element, int attribute, int value);
//public static final native int NSAccessibilityRoleDescription(int role, int subrole);
//public static final native int NSAccessibilityRoleDescriptionForUIElement(int element);
//public static final native int NSAccessibilityUnignoredAncestor(int element);
//public static final native int NSAccessibilityUnignoredChildren(int originalChildren);
//public static final native int NSAccessibilityUnignoredChildrenForOnlyChild(int originalChild);
//public static final native int NSAccessibilityUnignoredDescendant(int element);
//public static final native boolean NSApplicationLoad();
//public static final native int NSApplicationMain(int argc, int argv);
//public static final native int NSAvailableWindowDepths();
//public static final native void NSBeep();
//public static final native void NSBeginAlertSheet(int title, int defaultButton, int alternateButton, int otherButton, int docWindow, int modalDelegate, int didEndSelector, int didDismissSelector, int contextInfo, int msgFormat);
//public static final native void NSBeginCriticalAlertSheet(int title, int defaultButton, int alternateButton, int otherButton, int docWindow, int modalDelegate, int didEndSelector, int didDismissSelector, int contextInfo, int msgFormat);
//public static final native void NSBeginInformationalAlertSheet(int title, int defaultButton, int alternateButton, int otherButton, int docWindow, int modalDelegate, int didEndSelector, int didDismissSelector, int contextInfo, int msgFormat);
//public static final native int NSBestDepth(int colorSpace, int bps, int bpp, boolean planar, int exactMatch);
public static final native int NSBitsPerPixelFromDepth(int depth);
//public static final native int NSBitsPerSampleFromDepth(int depth);
//public static final native int NSColorSpaceFromDepth(int depth);
//public static final native int NSConvertGlyphsToPackedGlyphs(int glBuf, int count, int packing, int packedGlyphs);
//public static final native void NSCopyBits(int srcGState, NSRect srcRect, NSPoint destPoint);
//public static final native void NSCountWindows(int count);
//public static final native void NSCountWindowsForContext(int context, int count);
//public static final native int NSCreateFileContentsPboardType(int fileType);
//public static final native int NSCreateFilenamePboardType(int fileType);
//public static final native void NSDisableScreenUpdates();
//public static final native void NSDottedFrameRect(NSRect aRect);
//public static final native void NSDrawBitmap(NSRect rect, int width, int height, int bps, int spp, int bpp, int bpr, boolean isPlanar, boolean hasAlpha, int colorSpaceName, int data);
//public static final native void NSDrawButton(NSRect aRect, NSRect clipRect);
////public static final native NSRect NSDrawColorTiledRects(NSRect boundsRect, NSRect clipRect, int sides, int colors, int count);
//public static final native void NSDrawDarkBezel(NSRect aRect, NSRect clipRect);
//public static final native void NSDrawGrayBezel(NSRect aRect, NSRect clipRect);
//public static final native void NSDrawGroove(NSRect aRect, NSRect clipRect);
//public static final native void NSDrawLightBezel(NSRect aRect, NSRect clipRect);
//public static final native void NSDrawNinePartImage(NSRect frame, int topLeftCorner, int topEdgeFill, int topRightCorner, int leftEdgeFill, int centerFill, int rightEdgeFill, int bottomLeftCorner, int bottomEdgeFill, int bottomRightCorner, int op, float alphaFraction, boolean flipped);
//public static final native void NSDrawThreePartImage(NSRect frame, int startCap, int centerFill, int endCap, boolean vertical, int op, float alphaFraction, boolean flipped);
////public static final native NSRect NSDrawTiledRects(NSRect boundsRect, NSRect clipRect, int sides, int grays, int count);
//public static final native void NSDrawWhiteBezel(NSRect aRect, NSRect clipRect);
//public static final native void NSDrawWindowBackground(NSRect aRect);
//public static final native void NSEnableScreenUpdates();
//public static final native void NSEraseRect(NSRect aRect);
//public static final native int NSEventMaskFromType(int type);
//public static final native void NSFrameRect(NSRect aRect);
//public static final native void NSFrameRectWithWidth(NSRect aRect, float frameWidth);
//public static final native void NSFrameRectWithWidthUsingOperation(NSRect aRect, float frameWidth, int op);
//public static final native int NSGetAlertPanel(int title, int msgFormat, int defaultButton, int alternateButton, int otherButton);
//public static final native int NSGetCriticalAlertPanel(int title, int msgFormat, int defaultButton, int alternateButton, int otherButton);
//public static final native int NSGetFileType(int pboardType);
//public static final native int NSGetFileTypes(int pboardTypes);
//public static final native int NSGetInformationalAlertPanel(int title, int msgFormat, int defaultButton, int alternateButton, int otherButton);
//public static final native int NSGetWindowServerMemory(int context, int virtualMemory, int windowBackingMemory, int windowDumpString);
//public static final native void NSHighlightRect(NSRect aRect);
//public static final native int NSInterfaceStyleForKey(int key, int responder);
//public static final native boolean NSIsControllerMarker(int object);
//public static final native int NSNumberOfColorComponents(int colorSpaceName);
//public static final native void NSOpenGLGetOption(int pname, int param);
//public static final native void NSOpenGLGetVersion(int major, int minor);
//public static final native void NSOpenGLSetOption(int pname, int param);
//public static final native boolean NSPerformService(int itemName, int pboard);
//public static final native boolean NSPlanarFromDepth(int depth);
//public static final native int NSReadPixel(NSPoint passedPoint);
//public static final native void NSRectClip(NSRect aRect);
//public static final native void NSRectClipList(int rects, int count);
//public static final native void NSRectFill(NSRect aRect);
//public static final native void NSRectFillList(int rects, int count);
//public static final native void NSRectFillListUsingOperation(int rects, int count, int op);
//public static final native void NSRectFillListWithColors(int rects, int colors, int num);
//public static final native void NSRectFillListWithColorsUsingOperation(int rects, int colors, int num, int op);
//public static final native void NSRectFillListWithGrays(int rects, int grays, int num);
//public static final native void NSRectFillUsingOperation(NSRect aRect, int op);
//public static final native void NSRegisterServicesProvider(int provider, int name);
//public static final native void NSReleaseAlertPanel(int panel);
//public static final native int NSRunAlertPanel(int title, int msgFormat, int defaultButton, int alternateButton, int otherButton);
//public static final native int NSRunAlertPanelRelativeToWindow(int title, int msgFormat, int defaultButton, int alternateButton, int otherButton, int docWindow);
//public static final native int NSRunCriticalAlertPanel(int title, int msgFormat, int defaultButton, int alternateButton, int otherButton);
//public static final native int NSRunCriticalAlertPanelRelativeToWindow(int title, int msgFormat, int defaultButton, int alternateButton, int otherButton, int docWindow);
//public static final native int NSRunInformationalAlertPanel(int title, int msgFormat, int defaultButton, int alternateButton, int otherButton);
//public static final native int NSRunInformationalAlertPanelRelativeToWindow(int title, int msgFormat, int defaultButton, int alternateButton, int otherButton, int docWindow);
//public static final native void NSSetFocusRingStyle(int placement);
//public static final native int NSSetShowsServicesMenuItem(int itemName, boolean enabled);
////public static final native void NSShowAnimationEffect(int animationEffect, NSPoint centerLocation, NSSize size, int animationDelegate, int didEndSelector, int contextInfo);
//public static final native boolean NSShowsServicesMenuItem(int itemName);
//public static final native void NSUnregisterServicesProvider(int name);
//public static final native void NSUpdateDynamicServices();
//public static final native void NSWindowList(int size, int list);
//public static final native void NSWindowListForContext(int context, int size, int list);
//public static final native int NSAllHashTableObjects(int table);
//public static final native int NSAllMapTableKeys(int table);
//public static final native int NSAllMapTableValues(int table);
//public static final native int NSAllocateCollectable(int size, int options);
//public static final native int NSAllocateMemoryPages(int bytes);
//public static final native int NSAllocateObject(int aClass, int extraBytes, int zone);
//public static final native int NSClassFromString(int aClassName);
//public static final native boolean NSCompareHashTables(int table1, int table2);
//public static final native boolean NSCompareMapTables(int table1, int table2);
//public static final native boolean NSContainsRect(NSRect aRect, NSRect bRect);
////public static final native NSSwappedDouble NSConvertHostDoubleToSwapped(double x);
////public static final native NSSwappedFloat NSConvertHostFloatToSwapped(float x);
//public static final native double NSConvertSwappedDoubleToHost(NSSwappedDouble x);
//public static final native float NSConvertSwappedFloatToHost(NSSwappedFloat x);
//public static final native int NSCopyHashTableWithZone(int table, int zone);
//public static final native int NSCopyMapTableWithZone(int table, int zone);
//public static final native void NSCopyMemoryPages(int source, int dest, int bytes);
//public static final native int NSCopyObject(int object, int extraBytes, int zone);
//public static final native int NSCountFrames();
//public static final native int NSCountHashTable(int table);
//public static final native int NSCountMapTable(int table);
//public static final native int NSCreateHashTable(NSHashTableCallBacks callBacks, int capacity);
//public static final native int NSCreateHashTableWithZone(NSHashTableCallBacks callBacks, int capacity, int zone);
//public static final native int NSCreateMapTable(NSMapTableKeyCallBacks keyCallBacks, NSMapTableValueCallBacks valueCallBacks, int capacity);
//public static final native int NSCreateMapTableWithZone(NSMapTableKeyCallBacks keyCallBacks, NSMapTableValueCallBacks valueCallBacks, int capacity, int zone);
//public static final native int NSCreateZone(int startSize, int granularity, boolean canFree);
//public static final native void NSDeallocateMemoryPages(int ptr, int bytes);
//public static final native void NSDeallocateObject(int object);
//public static final native int NSDecimalAdd(int result, int leftOperand, int rightOperand, int roundingMode);
//public static final native void NSDecimalCompact(int number);
//public static final native int NSDecimalCompare(int leftOperand, int rightOperand);
//public static final native void NSDecimalCopy(int destination, int source);
//public static final native int NSDecimalDivide(int result, int leftOperand, int rightOperand, int roundingMode);
//public static final native boolean NSDecimalIsNotANumber(int dcm);
//public static final native int NSDecimalMultiply(int result, int leftOperand, int rightOperand, int roundingMode);
//public static final native int NSDecimalMultiplyByPowerOf10(int result, int number, short power, int roundingMode);
//public static final native int NSDecimalNormalize(int number1, int number2, int roundingMode);
//public static final native int NSDecimalPower(int result, int number, int power, int roundingMode);
//public static final native void NSDecimalRound(int result, int number, int scale, int roundingMode);
//public static final native int NSDecimalString(int dcm, int locale);
//public static final native int NSDecimalSubtract(int result, int leftOperand, int rightOperand, int roundingMode);
//public static final native boolean NSDecrementExtraRefCountWasZero(int object);
//public static final native int NSDefaultMallocZone();
//public static final native void NSDivideRect(NSRect inRect, int slice, int rem, float amount, int edge);
//public static final native void NSEndHashTableEnumeration(int enumerator);
//public static final native void NSEndMapTableEnumeration(int enumerator);
////public static final native NSHashEnumerator NSEnumerateHashTable(int table);
////public static final native NSMapEnumerator NSEnumerateMapTable(int table);
//public static final native boolean NSEqualPoints(NSPoint aPoint, NSPoint bPoint);
//public static final native boolean NSEqualRanges(NSRange range1, NSRange range2);
//public static final native boolean NSEqualRects(NSRect aRect, NSRect bRect);
//public static final native boolean NSEqualSizes(NSSize aSize, NSSize bSize);
//public static final native int NSExtraRefCount(int object);
public static final native int NSFileTypeForHFSTypeCode(int hfsFileTypeCode);
//public static final native int NSFrameAddress(int frame);
//public static final native void NSFreeHashTable(int table);
//public static final native void NSFreeMapTable(int table);
//public static final native int NSFullUserName();
//public static final native int NSGetSizeAndAlignment(int typePtr, int sizep, int alignp);
//public static final native int NSGetUncaughtExceptionHandler();
//public static final native int NSHFSTypeCodeFromFileType(int fileTypeString);
//public static final native int NSHFSTypeOfFile(int fullFilePath);
//public static final native int NSHashGet(int table, int pointer);
//public static final native void NSHashInsert(int table, int pointer);
//public static final native int NSHashInsertIfAbsent(int table, int pointer);
//public static final native void NSHashInsertKnownAbsent(int table, int pointer);
//public static final native void NSHashRemove(int table, int pointer);
//public static final native float NSHeight(NSRect aRect);
//public static final native int NSHomeDirectory();
//public static final native int NSHomeDirectoryForUser(int userName);
//public static final native int NSHostByteOrder();
//public static final native void NSIncrementExtraRefCount(int object);
////public static final native NSRect NSInsetRect(NSRect aRect, float dX, float dY);
////public static final native NSRect NSIntegralRect(NSRect aRect);
////public static final native NSRange NSIntersectionRange(NSRange range1, NSRange range2);
////public static final native NSRect NSIntersectionRect(NSRect aRect, NSRect bRect);
//public static final native boolean NSIntersectsRect(NSRect aRect, NSRect bRect);
//public static final native boolean NSIsEmptyRect(NSRect aRect);
//public static final native boolean NSIsFreedObject(int anObject);
//public static final native boolean NSLocationInRange(int loc, NSRange range);
//public static final native void NSLog(int format);
//public static final native int NSLogPageSize();
//public static final native void NSLogv(int format, int args);
//public static final native int NSMakeCollectable(int cf);
////public static final native NSPoint NSMakePoint(float x, float y);
////public static final native NSRange NSMakeRange(int loc, int len);
////public static final native NSRect NSMakeRect(float x, float y, float w, float h);
////public static final native NSSize NSMakeSize(float w, float h);
//public static final native int NSMapGet(int table, int key);
//public static final native void NSMapInsert(int table, int key, int value);
//public static final native int NSMapInsertIfAbsent(int table, int key, int value);
//public static final native void NSMapInsertKnownAbsent(int table, int key, int value);
//public static final native boolean NSMapMember(int table, int key, int originalKey, int value);
//public static final native void NSMapRemove(int table, int key);
//public static final native int NSMaxRange(NSRange range);
//public static final native float NSMaxX(NSRect aRect);
//public static final native float NSMaxY(NSRect aRect);
//public static final native float NSMidX(NSRect aRect);
//public static final native float NSMidY(NSRect aRect);
//public static final native float NSMinX(NSRect aRect);
//public static final native float NSMinY(NSRect aRect);
//public static final native boolean NSMouseInRect(NSPoint aPoint, NSRect aRect, boolean flipped);
//public static final native int NSNextHashEnumeratorItem(int enumerator);
//public static final native boolean NSNextMapEnumeratorPair(int enumerator, int key, int value);
////public static final native NSRect NSOffsetRect(NSRect aRect, float dX, float dY);
//public static final native int NSOpenStepRootDirectory();
//public static final native int NSPageSize();
////public static final native NSPoint NSPointFromCGPoint(CGPoint cgpoint);
////public static final native NSPoint NSPointFromString(int aString);
//public static final native boolean NSPointInRect(NSPoint aPoint, NSRect aRect);
////public static final native CGPoint NSPointToCGPoint(NSPoint nspoint);
//public static final native int NSProtocolFromString(int namestr);
////public static final native NSRange NSRangeFromString(int aString);
//public static final native int NSRealMemoryAvailable();
//public static final native int NSReallocateCollectable(int ptr, int size, int options);
//public static final native void NSRecordAllocationEvent(int eventType, int object);
////public static final native NSRect NSRectFromCGRect(CGRect cgrect);
////public static final native NSRect NSRectFromString(int aString);
////public static final native CGRect NSRectToCGRect(NSRect nsrect);
//public static final native void NSRecycleZone(int zone);
//public static final native void NSResetHashTable(int table);
//public static final native void NSResetMapTable(int table);
//public static final native int NSReturnAddress(int frame);
//public static final native int NSRoundDownToMultipleOfPageSize(int bytes);
//public static final native int NSRoundUpToMultipleOfPageSize(int bytes);
//public static final native int NSSearchPathForDirectoriesInDomains(int directory, int domainMask, boolean expandTilde);
//public static final native int NSSelectorFromString(int aSelectorName);
//public static final native void NSSetUncaughtExceptionHandler(int dummy);
//public static final native void NSSetZoneName(int zone, int name);
//public static final native boolean NSShouldRetainWithZone(int anObject, int requestedZone);
////public static final native NSSize NSSizeFromCGSize(CGSize cgsize);
////public static final native NSSize NSSizeFromString(int aString);
////public static final native CGSize NSSizeToCGSize(NSSize nssize);
//public static final native int NSStringFromClass(int aClass);
//public static final native int NSStringFromHashTable(int table);
//public static final native int NSStringFromMapTable(int table);
//public static final native int NSStringFromPoint(NSPoint aPoint);
//public static final native int NSStringFromProtocol(int proto);
//public static final native int NSStringFromRange(NSRange range);
//public static final native int NSStringFromRect(NSRect aRect);
//public static final native int NSStringFromSelector(int aSelector);
//public static final native int NSStringFromSize(NSSize aSize);
//public static final native double NSSwapBigDoubleToHost(NSSwappedDouble x);
//public static final native float NSSwapBigFloatToHost(NSSwappedFloat x);
//public static final native int NSSwapBigIntToHost(int x);
//public static final native long NSSwapBigLongLongToHost(long x);
//public static final native int NSSwapBigLongToHost(int x);
//public static final native short NSSwapBigShortToHost(short x);
////public static final native NSSwappedDouble NSSwapDouble(NSSwappedDouble x);
////public static final native NSSwappedFloat NSSwapFloat(NSSwappedFloat x);
////public static final native NSSwappedDouble NSSwapHostDoubleToBig(double x);
////public static final native NSSwappedDouble NSSwapHostDoubleToLittle(double x);
////public static final native NSSwappedFloat NSSwapHostFloatToBig(float x);
////public static final native NSSwappedFloat NSSwapHostFloatToLittle(float x);
//public static final native int NSSwapHostIntToBig(int x);
//public static final native int NSSwapHostIntToLittle(int x);
//public static final native long NSSwapHostLongLongToBig(long x);
//public static final native long NSSwapHostLongLongToLittle(long x);
//public static final native int NSSwapHostLongToBig(int x);
//public static final native int NSSwapHostLongToLittle(int x);
//public static final native short NSSwapHostShortToBig(short x);
//public static final native short NSSwapHostShortToLittle(short x);
//public static final native int NSSwapInt(int inv);
//public static final native double NSSwapLittleDoubleToHost(NSSwappedDouble x);
//public static final native float NSSwapLittleFloatToHost(NSSwappedFloat x);
//public static final native int NSSwapLittleIntToHost(int x);
//public static final native long NSSwapLittleLongLongToHost(long x);
//public static final native int NSSwapLittleLongToHost(int x);
//public static final native short NSSwapLittleShortToHost(short x);
//public static final native int NSSwapLong(int inv);
//public static final native long NSSwapLongLong(long inv);
//public static final native short NSSwapShort(short inv);
//public static final native int NSTemporaryDirectory();
//public static final native NSRange NSUnionRange(NSRange range1, NSRange range2);
//public static final native NSRect NSUnionRect(NSRect aRect, NSRect bRect);
//public static final native int NSUserName();
//public static final native float NSWidth(NSRect aRect);
//public static final native int NSZoneCalloc(int zone, int numElems, int byteSize);
//public static final native void NSZoneFree(int zone, int ptr);
//public static final native int NSZoneFromPointer(int ptr);
//public static final native int NSZoneMalloc(int zone, int size);
//public static final native int NSZoneName(int zone);
//public static final native int NSZoneRealloc(int zone, int ptr, int size);
//public static final native int NXReadNSObjectFromCoder(int decoder);

}
